<?php

/**
 * Class Index
 * The index controller
 */
class Testlevel extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index($val="")
    { 
		try{
			
			$viewper = $this->checkPermission(16, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(16, 4);
			$this->view->editper= $this->checkPermission(16, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(16, 3);	
			$testlevel_model = $this->loadModel('Testlevel');
			$this->view->levels = $testlevel_model->getAllTestlevel();
			$this->view->render('levels/index');
		}
		}
		catch(Exception $e){
		}
    }
	
	 public function createLevel()
    {
       
            $Testlevel = $this->loadModel('Testlevel');
            $arr=$Testlevel->create();
       echo json_encode($arr);
    }
	
	public function updateLevel()
    {
       
            $Testlevel = $this->loadModel('Testlevel');
            $arr=$Testlevel->updateLevel();
       echo json_encode($arr);
    }
	
	public function deleteLevel()
    {
       
            $Testlevel = $this->loadModel('Testlevel');
            $arr=$Testlevel->deleteLevel();
       echo json_encode($arr);
    }
	public function getAllLevels($val)
    {
		$designation_model = $this->loadModel('Testlevel');
        $arr= $designation_model->getAlllevel($val);
		echo json_encode($arr);
		
    }
	
	public function getalltype()
    {
		$designation_model = $this->loadModel('Testlevel');
        $arr= $designation_model->getAllTestlevel();
		echo json_encode($arr);
		exit();
        
    }
	
	public function getallcurrentlevel()
    {
		$designation_model = $this->loadModel('Testlevel');
        $arr= $designation_model->getAllCurrentTestlevel();
		echo json_encode($arr);
		exit();
        
    }
	public function getpositions($val=1)
    {
		$designation_model = $this->loadModel('Testlevel');
        $arr= $designation_model->getAllDesignations($val);
		echo json_encode($arr);
		exit();
        
    }
	public function addnew()
    {
            $this->view->render('levels/addnew');
    }
	public function details($designation_id)
    {
		if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            $designation_model = $this->loadModel('Designation');
            $this->view->designation = $designation_model->getDesignation($designation_id);
            $this->view->render('designations/details');
        } else {
            header('location: ' . URL . 'designation');
        }
            
    }
    public function create()
    {
        if (isset($_POST['level']) AND !empty($_POST['level'])) {
            $Testlevel = $this->loadModel('Testlevel');
            $sts=$Testlevel->create();
        }
		if($sts)
			header('location: ' . URL . 'testlevel/index');
		else
			header('location: ' . URL . 'designation/addnew');
    }

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
    public function edit($id)
    {
        if (isset($id)) {
            // get the group that you want to edit (to show the current content)
            $Testlevel = $this->loadModel('Testlevel');
            $this->view->testlevel = $Testlevel->getTestLevel($id);
            $this->view->render('levels/edit');
        } else {
            header('location: ' . URL . 'designation/currentpositions');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($id)
    {
        if (isset($_POST['level']) && isset($id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $Testlevel = $this->loadModel('Testlevel');
            $Testlevel->editSave($id);
        }
        header('location: ' . URL . 'testlevel/index');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($id)
    {
        if (isset($id)) {
            $Testlevel = $this->loadModel('Testlevel');
            $Testlevel->delete($id);
        }
        header('location: ' . URL . 'testlevel/index');
    }
    
	public function statuschange($designation_id, $status, $val=0)
    {
        if (isset($designation_id)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changestatus($designation_id, $status);
        }
        if($val==1)
        header('location: ' . URL . 'designation/currentpositions');
         if($val==2)
        header('location: ' . URL . 'designation/pastpositions');
         if($val==0)
        header('location: ' . URL . 'designation'); 
    }
    public function stschange($designation_id, $status)
    {
        if (isset($designation_id)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changests($designation_id, $status);
        }
        header('location: ' . URL . 'designation'); 
    }
	///////////Get Selected Candiate feedback table///////////
	public function getselectcandidate($level,$desig)
    {
		$designation_model = $this->loadModel('Testlevel');
        $arr= $designation_model->getselectcandidate($level,$desig);
		echo json_encode($arr);
		exit();
        
    }
}
