<?php

/**
 * Class Index
 * The index controller
 */
class TestCategory extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index($val="")
    {
		$viewper = $this->checkPermission(3, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->viewper= $this->checkPermission(3, 1);
			$this->view->viewper1= $this->checkPermission(22, 1);
			$this->view->addper= $this->checkPermission(3, 4);
			$this->view->editper= $this->checkPermission(3, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(3, 3);	
			$this->view->editper1= $this->checkPermission(22, 2);
			$this->view->addper1= $this->checkPermission(22, 4);
		 if($val!=''){
		   Session::set('edit_label', true);		
		  } 
		  $this->view->pageid=10;
		  $testcategory_model = $this->loadModel('TestCategory');
          $this->view->testcategorys = $testcategory_model->getAllTestCategorys();
          $this->view->render('testcategory/index');
		}
    }
	public function showtest($test_id)
    {
		$this->view->testid=$test_id;
		$testcategory_model = $this->loadModel('TestCategory');
        $this->view->tests = $testcategory_model->getTest($test_id);
		$this->view->category = $testcategory_model->getTestCategory($test_id);
        $this->view->render('testcategory/testshow');
    }
	
	public function addnew($val="")
	 {
		 if($val!=''){
		   Session::set('edit_label', true);
		 } 
		$this->view->pageid=10;   
		$testcategory_model = $this->loadModel('TestCategory');
        $this->view->testcategorys = $testcategory_model->getAllTestCategorys();
		$this->view->categoryid=0;	
        $this->view->render('testcategory/addnew');
    }
	public function details($designation_id)
    {
		if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            $designation_model = $this->loadModel('Designation');
            $this->view->designation = $designation_model->getDesignation($designation_id);
            $this->view->render('designations/details');
        } else {
            header('location: ' . URL . 'designation');
        }
            
    }
    public function create()
    {
		try{
        $testcategory_model = $this->loadModel('TestCategory');
       $cate= $testcategory_model->create();
		echo json_encode($cate)	;	
			
		}
catch(Exeception $e)
{
	
	
}		
       
    }

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
    public function edit($test_id)
    {
        if (isset($test_id)) {
            // get the group that you want to edit (to show the current content)
            $testcategory_model = $this->loadModel('TestCategory');
			$this->view->categoryid=$test_id;
            $this->view->testcategory= $testcategory_model->getTestCategory($test_id);
			$this->view->testcategorys = $testcategory_model->getAllTestCategorys();
            $this->view->render('testcategory/addnew');
        } else {
            header('location: ' . URL . 'testcategory');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($test_id)
    {
		try{
			
        if (isset($test_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $testcategory_model = $this->loadModel('TestCategory');
            $res=$testcategory_model->editSave($test_id);
			echo json_encode($res);
        }
        //header('location: ' . URL . 'testcategory');
		}
    catch(Execption $e){
	
	
       }
		}

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($test_id)
    {
		try{
        if (isset($test_id)) {
            $testcategory_model = $this->loadModel('TestCategory');
            $testcategory_model->delete($test_id);
        }
        header('location: ' . URL . 'testcategory');
    }catch(Execption $e){
		
		
	}
	
	}
	
     public function deletetest($cat_id)
    {
        if (isset($test_id)) {
            $testcategory_model = $this->loadModel('TestCategory');
            $testcategory_model->delete($test_id);
        }
        header('location: ' . URL . 'testcategory');
    }
	public function statuschange($test_id, $status)
    {
        if (isset($test_id)) {
            $testcategory_model = $this->loadModel('TestCategory');
            $testcategory_model->changestatus($test_id, $status);
        }
        header('location: ' . URL . 'testcategory');
    }
}
