<?php

/**
 * Class Student
 * The Student controller
 */
class Student extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
		
        Auth::handleLogin();

    }

   
    public function index()
    {
		$student_model = $this->loadModel('Student');
        $this->view->students = $student_model->getAllStudents();
        $this->view->render('students/index');
    }
    
    public function addnew()
    {
		$student_model = $this->loadModel('Student');
        
        $this->view->render('students/addnew');
	}
    public function details($stud_id)
    {
		if (isset($stud_id)) {
            // get the group that you want to edit (to show the current content)
            $student_model = $this->loadModel('Student');
            $this->view->student = $student_model->getStudent($stud_id);
            $this->view->render('students/details');
        } else {
            header('location: ' . URL . 'student');
        }
            
    }
    public function create()
    {
        if (isset($_POST['fname']) AND !empty($_POST['pwd'])) {
            $student_model = $this->loadModel('Student');
            $student_model->create();
        }
        header('location: ' . URL . 'student');
    }
    public function edit($stud_id)
    {
        if (isset($stud_id)) {
            $student_model = $this->loadModel('Student');
			$this->view->student = $student_model->getStudent($stud_id);
            $this->view->render('students/edit');
        } else {
            header('location: ' . URL . 'student');
        }
    }
    public function editSave($stud_id)
    {
        if (isset($_POST['fname']) && isset($stud_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $student_model = $this->loadModel('Student');
            $student_model->editSave($stud_id);
        }
        header('location: ' . URL . 'student');
    }
    public function delete($stud_id)
    {
        if (isset($stud_id)) {
            $student_model = $this->loadModel('Student');
            $student_model->delete($stud_id);
        }
        header('location: ' . URL . 'student');
    }
	public function statuschange($stud_id, $status)
    {
        if (isset($stud_id)) {
            $student_model = $this->loadModel('Student');
            $student_model->changestatus($stud_id, $status);
        }
        header('location: ' . URL . 'student');
    }
	
}
