<?php

/**
 * Class SMS
 * The SMS controller
 */
class SMS extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
        $template_model = $this->loadModel('Template');
        $this->view->smss = $template_model->getAllTemplates('SMS');
        $this->view->render('sms/index');
    }
	
	function addnew()
    {
            $this->view->render('sms/addnew');
    }
    function detail($id)
    {
			$template_model = $this->loadModel('Template');
			$this->view->sms = $template_model->getTemplate($id);
			
            $this->view->render('sms/details');
    }
    function getcontacts()
	{
		$student_model = $this->loadModel('Student');
		$student = $student_model->getAllStudentsContact();
		echo $student;
	}
	function sendmessage($id)
    {
		if (isset($_POST['email_to']) AND !empty($_POST['email_subject'])) {
            $student_model = $this->loadModel('Student');
			$student = $student_model->sendmessage();
        }
        header('location: ' . URL . 'sms');
    }
    public function create()
    {
        if (isset($_POST['temp_name']) AND !empty($_POST['temp_name'])) {
            $template_model = $this->loadModel('Template');
            $template_model->create("SMS");
        }
        header('location: ' . URL . 'sms');
    }

    public function edit($template_id)
    {
        if (isset($template_id)) {
            // get the note that you want to edit (to show the current content)
            $template_model = $this->loadModel('Template');
            $this->view->sms = $template_model->getTemplate($template_id);
            $this->view->render('sms/edit');
        } else {
            header('location: ' . URL . 'sms');
        }
    }

    public function editSave($template_id)
    {
        if (isset($_POST['temp_name']) && isset($template_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $template_model = $this->loadModel('Template');
            $template_model->editSave($template_id,"SMS");
        }
        header('location: ' . URL . 'sms');
    }

    public function delete($template_id)
    {
        if (isset($template_id)) {
            $template_model = $this->loadModel('Template');
            $template_model->delete($template_id);
        }
        header('location: ' . URL . 'sms');
    }
}
