<?php

/**
 * Class Index
 * The index controller
 */
class SkillLevel extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index($val="")
    {
		$viewper = $this->checkPermission(33, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$this->view->addper= $this->checkPermission(33, 4);
			$this->view->editper= $this->checkPermission(33, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(33, 3);
          $this->view->render('skilllevel/index');
		}
    }
	
	function getAllSkillLevels()
	{
		try{
			$SkillLevel_model = $this->loadModel('SkillLevel');
			$SkillLevelarray = $SkillLevel_model->getAllSkillLevels();
			echo json_encode($SkillLevelarray);
		}catch(Exception $e){}		
	}
	
    public function createSkillLevel()
    {
		try{
        $SkillLevel_model = $this->loadModel('SkillLevel');
        $SkillLevelarray= $SkillLevel_model->createSkillLevel();
		echo json_encode($SkillLevelarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }

    public function updateSkillLevel()
    {
		try{
        $SkillLevel_model = $this->loadModel('SkillLevel');
        $SkillLevelarray= $SkillLevel_model->updateSkillLevel();
		echo json_encode($SkillLevelarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }

    public function deleteSkillLevel()
    {
		try{
        $SkillLevel_model = $this->loadModel('SkillLevel');
        $SkillLevelarray= $SkillLevel_model->deleteSkillLevel();
		echo json_encode($SkillLevelarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
}
