<?php

/**
 * Class Index
 * The index controller
 */
class Report extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    function studentlist()
    {
            $this->view->render('reports/studentlist');
    }
	
	function candidatebydate($sts=0)
    {
		$designation_model = $this->loadModel('Designation');
		$this->view->positions = $designation_model->getAllDesignationsBySts();
		$schedule_model = $this->loadModel('Schedule');
		$this->view->schedule= $schedule_model->getTable($sts);
		$position = isset($_POST["position"])?$_POST["position"]:0;
		$candidate_model = $this->loadModel('Candidate');
		$this->view->positionid = $position;
        $this->view->position_name = $candidate_model->getName($position,"DefaultPosition","PositionName","Id");
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";
		//$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
	//	$this->view->positionSts=$positionSts;
		$this->view->render('reports/candidatebydate');
    }
	
	
	function activitylog($sts=0)
    {
		$user_model = $this->loadModel('User');
		$this->view->usersprofile = $user_model->getUserprofiledata();
		$this->view->userslist = $user_model->getAllUsers();
		
		$this->view->activity= $user_model->getActivityLog();
		$profile = isset($_POST["profile"])?$_POST["profile"]:0;
		$this->view->profile = $profile;
		$users = isset($_POST["users"])?$_POST["users"]:0;
		$this->view->users = $users;
		//$candidate_model = $this->loadModel('Candidate');
		
       $this->view->username = $user_model->getName($users,"users","user_name","user_id");
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";
		//$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
	//	$this->view->positionSts=$positionSts;
		$this->view->render('reports/activitylog');
    }
	function testthismonth($sts=0)
    {
		 $Dashboard_model = $this->loadModel('Dashboard');
         $this->view->schedule= $Dashboard_model->getTable($sts);
         $this->view->render('reports/testthismonth');
    }
	function candidatebyposition($sts=0)
    {
		
		$designation_model = $this->loadModel('Designation');
        $this->view->positions = $designation_model->getAllDesignationsBySts();
		$candidate_model = $this->loadModel('Candidate');
        $this->view->candidates = $candidate_model->getAllpositionCandidates($sts);
		$position = isset($_POST["position"])?$_POST["position"]:0;
		//$this->view->sortby = isset($_POST["sortby"])?$_POST["sortby"]:0;
		$this->view->positionid = $position;
        $this->view->position_name = $candidate_model->getName($position,"DefaultPosition","PositionName","Id");
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";		
		$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->sortby = isset($_POST["sortby"])?$_POST["sortby"]:"0";
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->positionSts=$positionSts;
        $this->view->render('reports/candidatebyposition');
    }
	function resultbyposition($sts=0)
    {
		$CandidateResult_model = $this->loadModel('Report');
		$this->view->candidate= $CandidateResult_model->getCandidateresult($sts);
		$designation_model = $this->loadModel('Designation');
        $this->view->positions = $designation_model->getAllDesignationsBySts();
		$position = isset($_POST["position"])?$_POST["position"]:0;
		$this->view->positionid =$position;
		$candidate_model = $this->loadModel('Candidate');
        $this->view->position_name = $candidate_model->getName($position,"DefaultPosition","PositionName","Id");
        $candidate_rating =isset($_POST['rating'])?($_POST['rating']):0;
	    $this->view->rating=$candidate_rating;
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";	
		$positionSts =isset($_POST['positionSts'])?($_POST['positionSts']):0;
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->positionSts=$positionSts;
        $this->view->render('reports/resultbyposition');
    }
	function resultbytest($sts)
    {
		$CandidateResult_model = $this->loadModel('Candidateresult');
		$this->view->candidate= $CandidateResult_model->getResultByTest($sts);
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";	
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		$testid = isset($_POST["test"])?$_POST["test"]:"";
		
		$this->view->testname = $CandidateResult_model->getName($testid,'Test_paper','Name','Id');
		$this->view->test_name = $testid;
		/* if($enddate=="")
		{
		$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
		$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->testid=$testid;
			$candidate_model = $this->loadModel('Schedule');
		$this->view->tests = $candidate_model->gettestpaper();
        $this->view->render('reports/resultbytest');
		
    }
	
	function overallreport($sts=0)
    {
		$report_model = $this->loadModel('Report');
		$this->view->candidateresults = $report_model->getAllTest($sts);
		 $this->view->testlevels = $report_model->getAllTestlevel(); 
		 $this->view->alltestattempt = $report_model->getalltestattempt(); 
		$designation_model = $this->loadModel('Designation');
       $this->view->positions = $designation_model->getAllDesignationsBySts();
		$orgid = $_SESSION['user_org_id'];
		$this->view->company=$this->getName($orgid,"company_master","company_name","id");
		$this->view->address=$this->getName($orgid,"company_master","address","id");
		$this->view->url=URL."public/uploads/".$orgid."/companylogo.png";	
		////////////Get all test level ////////////
		/* $testlevel_model = $this->loadModel('Testlevel');
        $this->view->testlevels = $testlevel_model->getAllTestlevel(); */
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date("Y-m-d");
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		//$candidate_model = $this->loadModel('Candidate');
        $this->view->candidates = $report_model->getAllCandidates(0);
        $this->view->candidatesbypos = $report_model->getAllCandidatesbypos(0);
		$this->view->posid = isset($_POST["position_id"])?$_POST["position_id"]:0;
		$this->view->canid = isset($_POST["candidate_id"])?$_POST["candidate_id"]:0;
		$this->view->positionSts = isset($_POST["positionSts"])?$_POST["positionSts"]:0;
		//print_r($this->view->candidates);
		//print_r($this->view->positions);
		//print_r($this->view->candidateresults);
		//die();
		$candidate_rating =isset($_POST['rating'])?($_POST['rating']):0;
	    $this->view->rating=$candidate_rating;
		$this->view->render('reports/overallperformance');
    }
	function questionlist()
    {
            $this->view->render('reports/questionlist');
    }
	function invoicelist()
    {
            $this->view->render('reports/invoicelist');
    }
	function certificatelist()
    {
            $this->view->render('reports/certificatelist');
    }
	function userlist()
    {
            $this->view->render('reports/userlist');
    }
	
    public function getName($id,$table,$field,$where)
	{
			$name="";
			$sql = "select $field from $table where $where = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($id));
			while($row=$query->fetch())
			{
				$name=$row->$field;
			}
			return $name;
	}
	
}
