<?php

/**
 * Class Index
 * The index controller
 */
class Ratingcriteria extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index($val="")
    {
		$viewper = $this->checkPermission(15, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		 if($viewper){
		 	$this->view->addper= $this->checkPermission(15, 4);
			$this->view->editper= $this->checkPermission(15, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(15, 3);
		
            $ratingcriteria_model = $this->loadModel('Ratingcriteria');
        
        $this->view->render('ratingcriteria/index');
		 }
			
    }
	
	public function getcriteria()
    {
		
		$ratingcriteria_model = $this->loadModel('Ratingcriteria');
        $arr= $ratingcriteria_model->getAllRatingcriterias();
		echo json_encode($arr);
        exit();
    }
	
    public function savecriteria()
    {
        $ratingcriteria_model = $this->loadModel('Ratingcriteria');
        $cate= $ratingcriteria_model->save();
		
		echo json_encode($cate);
	}

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
   
}
