<?php

/**
 * Class Quiz
 * The Quiz controller
 */
class Quiz extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
		parent::__construct();
		// VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
		// need this line! Otherwise not-logged in users could do actions. If all of your pages should only
		// be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();
    }

    public function index($val="")
    {
		$viewper = $this->checkPermission(22, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->viewper= $this->checkPermission(3, 1);
			$this->view->viewper1= $this->checkPermission(22, 1);
			$this->view->addper= $this->checkPermission(22, 4);
			$this->view->editper= $this->checkPermission(22, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(22, 3);
			$this->view->editper1= $this->checkPermission(3, 2);			
			 if($val!='')
				{
			   Session::set('edit_label', true);		
			   } 
		$this->view->pageid=11;
		$quiz_model = $this->loadModel('Quiz');
        $this->view->quizs = $quiz_model->getAllQuizs();
        $this->view->render('quizs/index');
		}
    }
	
	
	public function getcriteria($testid=0)
    {
		
		$ratingcriteria_model = $this->loadModel('Quiz');
        $arr= $ratingcriteria_model->getAllRatingcriterias($testid);
		echo json_encode($arr);
        exit();
    }
	public function showtest($cat_id)
    {
		$viewper = $this->checkPermission(3, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->viewper= $this->checkPermission(3, 1);
			$this->view->viewper1= $this->checkPermission(22, 1);
			$this->view->addper= $this->checkPermission(3, 4);
			$this->view->editper= $this->checkPermission(3, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(3, 3);	
			$this->view->editper1= $this->checkPermission(22, 2);
			$this->view->addper1= $this->checkPermission(22, 4);
			$this->view->deleteper1= $this->checkPermission(22, 3);
		$quiz_model = $this->loadModel('Quiz');
		$this->view->catid = $cat_id;
		$this->view->cid= $cat_id;
		$this->view->catid = $quiz_model->testname($cat_id);
        $this->view->testshow = $quiz_model->getAlltest($cat_id);
        $this->view->render('quizs/testshow');
		}
    }
	public function addnew($val="")
    {	if($val!=''){
		   Session::set('edit_label', true);
		 
		   } 
		 $this->view->pageid=11;
		$this->view->testid=0;	
		$testcategory_model = $this->loadModel('TestCategory');
		$this->view->testcategory = $testcategory_model->getAllTestCategorys();
		
		/* if(isset($_POST['test_id']) && !empty($_POST['test_id']))
		{	
			$test_id=$_POST['test_id'];
			$quiz_model = $this->loadModel('Quiz');
			$this->view->category = $quiz_model->getAllCategorys($test_id);
		} */
		$this->view->render('quizs/addnew');
    }
	//////Dynamic choose test////////////////
	
	public function details($cat_id)
    {
		$viewper = $this->checkPermission(22, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			
			$this->view->addper= $this->checkPermission(22, 4);
			$this->view->editper= $this->checkPermission(22, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(22, 3);
			
		 if (isset($cat_id)) {
			$quiz_model = $this->loadModel('Quiz');
			$this->view->catname = $quiz_model->getCatrgoryName1($cat_id);
			$ques_model = $this->loadModel('Question');
            $this->view->quess = $ques_model->getAllQuizQues($cat_id);
			$this->view->catid=$cat_id;
            $this->view->render('quizs/details');
         } else {
            header('location: ' . URL . 'quiz');
        }
	}
    }
    
    public function create()
    {
		try {
        $quiz_model = $this->loadModel('Quiz');
        $result = $quiz_model->create();
      
        if($result){
			//header('location: ' . URL . 'question/addnew');
			 echo json_encode($result); 
	   exit();
			header('location: ' . URL . 'quiz');
		}else{
			header('location: ' . URL . 'quiz/addnew');
		}
	}catch(Exception $e){}
    }

    
    public function edit($quiz_id)
    {
        if (isset($quiz_id)) {
            // get the group that you want to edit (to show the current content)
            
            $testcategory_model = $this->loadModel('TestCategory');
			$this->view->testcategory = $testcategory_model->getAllTestCategorys();
			
			$quiz_model = $this->loadModel('Quiz');
			$this->view->category = $quiz_model->getCatrgoryName();
			
             $this->view->pageid="";
			$this->view->testid=$quiz_id;
            $this->view->quiz = $quiz_model->getQuizEdit($quiz_id);
            $this->view->render('quizs/addnew');
        } else {
            header('location: ' . URL . 'quiz');
        }
    }

    public function editSave($quiz_id)
    {
		try{
			if(isset($quiz_id)) 
			{
				// perform the update: pass note_id from URL and note_text from POST
				$quiz_model = $this->loadModel('Quiz');
				$result= $quiz_model->editSave($quiz_id);
				echo json_encode($result); 		
			}
			//header('location: ' . URL . 'quiz');
		   }catch(Exception $ex){}
    }

    public function delete($quiz_id)
    {
        if (isset($quiz_id)) 
		{
            $quiz_model = $this->loadModel('Quiz');
            $quiz_model->delete($quiz_id);
        }
        header('location: ' . URL . 'quiz');
    }
    
    public function statuschange($quiz_id, $status)
    {
        if (isset($quiz_id)) {
            $quiz_model = $this->loadModel('Quiz');
            $quiz_model->changestatus($quiz_id, $status);
        }
        header('location: ' . URL . 'quiz');
    }
	
}
