<?php

/**
 * Class Quiz
 * The Quiz controller
 */
class Questionbank extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
		parent::__construct();
		// VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
		// need this line! Otherwise not-logged in users could do actions. If all of your pages should only
		// be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();
    }

    public function index($val="")
    {
		$viewper = $this->checkPermission(3, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper)
		{
			if($val!="")
				$this->view->levelid=$val;
			$this->view->addper= $this->checkPermission(3, 4);
			$this->view->editper= $this->checkPermission(3, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(3, 3);
						
		
		//$Questionbank_model = $this->loadModel('Questionbank');
      //  $this->view->quizs = $Questionbank_model->getAllQuizs();
        $this->view->render('questionbank/index');
		}
    }
	
	
    public function getLevelQuestions()
    {
		try
		{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->getLevelQuestions();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	public function addnew($lvlid)
    {
		 if($lvlid)
		 {
			$this->view->levelid = $lvlid;
			$this->view->render('questionbank/addnew');
		 }else
		 {
			  header('location: ' . URL . 'questionbank');
		 }
    }
	
	
	public function upload($lvlid)
    {
     if($lvlid){
		$this->view->levelid = $lvlid;
        $this->view->render('questionbank/upload');
	 }else{
		  header('location: ' . URL . 'questionbank');
	 }
    }
	
    public function createQuestion()
    {
		try{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->createQuestion();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	  public function updateQuestion()
    {
		try{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->updateQuestion();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	  public function deletequestionbank()
    {
		try
		{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->deleteQuestion();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	
	
	  public function movequestionbank()
    {
		try
		{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->movequestionbank();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	  public function copyquestionbank()
    {
		try
		{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->copyquestionbank();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
public function importquestion($lvlid)
    {
		$this->view->levelid = $lvlid;
		$Questionbank_model = $this->loadModel('Questionbank');
		$this->view->exceldata = $Questionbank_model->importQuestion($lvlid);
	    header('location: ' . URL . 'questionbank/index/'.$lvlid);
    }	
	
	
    public function edit($quesid)
    {
        if (isset($quesid))
			{
			$this->view->quesid=$quesid;
            $this->view->render('questionbank/addnew');
			} 
			else
				{
            header('location: ' . URL . 'questionbank');
        }
    }
	


	  public function getQuestionDetails()
    {
		try{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->getQuestionDetails();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	  public function getlevelpath()
    {
		try{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->getlevelpath();
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	
    public function uploadQuesAttach($quesid)
    {
		try{
        $Questionbank_model = $this->loadModel('Questionbank');
        $Questionbankarray= $Questionbank_model->uploadQuesAttach($quesid);
		echo json_encode($Questionbankarray);	
		}
	catch(Exception $e)
		{
			Utils::Trace($e->getMessage());
		}		
    }
	
	
	
	
	public function getcriteria($testid=0)
    {
		$ratingcriteria_model = $this->loadModel('Quiz');
        $arr= $ratingcriteria_model->getAllRatingcriterias($testid);
		echo json_encode($arr);
        exit();
    }
	public function showtest($cat_id)
    {
		$viewper = $this->checkPermission(3, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->viewper= $this->checkPermission(3, 1);
			$this->view->viewper1= $this->checkPermission(22, 1);
			$this->view->addper= $this->checkPermission(3, 4);
			$this->view->editper= $this->checkPermission(3, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(3, 3);	
			$this->view->editper1= $this->checkPermission(22, 2);
			$this->view->addper1= $this->checkPermission(22, 4);
			$this->view->deleteper1= $this->checkPermission(22, 3);
		$quiz_model = $this->loadModel('Quiz');
		$this->view->catid = $cat_id;
		$this->view->cid= $cat_id;
		$this->view->catid = $quiz_model->testname($cat_id);
        $this->view->testshow = $quiz_model->getAlltest($cat_id);
        $this->view->render('quizs/testshow');
		}
    }
	public function details($cat_id)
    {
		$viewper = $this->checkPermission(22, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			
			$this->view->addper= $this->checkPermission(22, 4);
			$this->view->editper= $this->checkPermission(22, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(22, 3);
			
		 if (isset($cat_id)) {
			$quiz_model = $this->loadModel('Quiz');
			$this->view->catname = $quiz_model->getCatrgoryName1($cat_id);
			$ques_model = $this->loadModel('Question');
            $this->view->quess = $ques_model->getAllQuizQues($cat_id);
			$this->view->catid=$cat_id;
            $this->view->render('quizs/details');
         } else {
            header('location: ' . URL . 'quiz');
        }
	}
    }

    public function editSave($quiz_id)
    {
		try{
			if(isset($quiz_id)) 
			{
				// perform the update: pass note_id from URL and note_text from POST
				$quiz_model = $this->loadModel('Quiz');
				$result= $quiz_model->editSave($quiz_id);
				echo json_encode($result); 		
			}
			//header('location: ' . URL . 'quiz');
		   }catch(Exception $ex){}
    }

    public function delete($quiz_id)
    {
        if (isset($quiz_id)) 
		{
            $quiz_model = $this->loadModel('Quiz');
            $quiz_model->delete($quiz_id);
        }
        header('location: ' . URL . 'quiz');
    }
    
    public function statuschange($quiz_id, $status)
    {
        if (isset($quiz_id))
			{
            $quiz_model = $this->loadModel('Quiz');
            $quiz_model->changestatus($quiz_id, $status);
        }
        header('location: ' . URL . 'quiz');
    }
	
	
	 public function import($lvlid)
    {
			$this->view->levelid = $lvlid;
		$Questionbank_model = $this->loadModel('Questionbank');
        $this->view->exceldata = $Questionbank_model->getExcelData();
		$this->view->render('questionbank/import');
    }
	
}
