<?php

/**
 * Class Question
 * The Question controller
 */
class Question extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
	
        Auth::handleLogin();

    }

   
    public function index($cid)
    {
		$quiz_model = $this->loadModel('Quiz');
		$this->view->catname = $quiz_model->getCatrgoryName1($cid);
		$ques_model = $this->loadModel('Question');
        $this->view->cat_id = $cid;
		
        $this->view->quesns = $ques_model->getAllQuestions($cid);
        $this->view->render('questions/index');
    }
	
	public function addnew($cat_id,$val="")
    {
		if($val!=''){
		   Session::set('edit_label', true);
		
		   } 
		    $this->view->pageid=4;
		$quiz_model = $this->loadModel('Quiz');
        $this->view->category = $quiz_model->getQuiz($cat_id);
		
		$this->view->catname = $quiz_model->getCatrgoryName();
        
        $ques_model = $this->loadModel('Question');
        $this->view->quizques = $ques_model->getQuizQuestion($cat_id);
        
        $this->view->render('questions/addnew');
	
    }
	
    public function create($cat_id)
    {
        $ques_model = $this->loadModel('Question');
        $result =$ques_model->create($cat_id);
        
        header('location: ' . URL . 'question/addnew/'.$cat_id);
    }

   
    public function edit($ques_id, $cat_id)
    {
        if (isset($ques_id) && isset($cat_id)) {
            // get the group that you want to edit (to show the current content)
            $quiz_model = $this->loadModel('Quiz');
			$this->view->category = $quiz_model->getQuiz($cat_id);
            $this->view->catname = $quiz_model->getCatrgoryName();
            $ques_model = $this->loadModel('Question');
            $this->view->ques = $ques_model->getQuestion($ques_id);
            $this->view->ans = $ques_model->getAnswers($ques_id);
            $this->view->render('questions/edit');
        } else {
            header('location: ' . URL . 'question');
        }
    }

   
    public function editSave($ques_id,$cat_id)
    {
        if (isset($ques_id)&&isset($cat_id)) {
            $ques_model = $this->loadModel('Question');
            $ques_model->editSave($ques_id);
        }
        header('location: ' . URL . 'quiz/details/'.$cat_id);
    }

    
    public function delete($ques_id,$cat_id)
    {
        if (isset($ques_id) && isset($cat_id)) {
            $ques_model = $this->loadModel('Question');
            $ques_model->delete($ques_id);
        }
        header('location: ' . URL . 'quiz/details/'.$cat_id);
    }
	
}
