<?php

/**
 * Class Index
 * The index controller
 */
class Lesion extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
		
        Auth::handleLogin();

    }

    
    public function index()
    {
		$lesion_model = $this->loadModel('Lesion');
        $this->view->lesions = $lesion_model->getAllLesions();
        $this->view->render('lesions/index');
    }
	
	public function addnew()
    {
			$course_model = $this->loadModel('Course');
			$this->view->courses = $course_model->getAllCourses();
        
            $this->view->render('lesions/addnew');
    }
    
	
	public function details($lesion_id)
    {
		if (isset($lesion_id)) {
            // get the group that you want to edit (to show the current content)
            $lesion_model = $this->loadModel('Lesion');
            $this->view->lesion = $lesion_model->getLesion($lesion_id);
            $this->view->feedback = $lesion_model->getLesionFeedback($lesion_id);
            $this->view->render('lesions/details');
        } else {
            header('location: ' . URL . 'lesion');
        }
            
    }
    
    public function create()
    {
        if (isset($_POST['lesion_name']) AND !empty($_POST['lesion_name'])) {
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->create();
        }
        header('location: ' . URL . 'lesion');
    }

    public function getcourselesion($course_id)
    {
        if (isset($course_id)) {
           $lesion_model = $this->loadModel('Lesion');
           $this->view->lessions = $lesion_model->getCourseLesion2($course_id);
           echo json_encode($this->view->lessions);
        } else {
           echo "Not found";
        }
    }
    
    public function edit($lesion_id, $course_id)
    {
        if (isset($lesion_id)) {
            $course_model = $this->loadModel('Course');
			$this->view->courses = $course_model->getAllCourses();
			
            $lesion_model = $this->loadModel('Lesion');
            $this->view->lesion = $lesion_model->getLesion($lesion_id);
            
            $this->view->lessions = $lesion_model->getCourseLesion($course_id);
            
            $this->view->render('lesions/edit');
        } else {
            header('location: ' . URL . 'lesion');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($lesion_id)
    {
        if (isset($_POST['lesion_name']) && isset($lesion_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->editSave($lesion_id);
        }
        header('location: ' . URL . 'lesion');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($lesion_id)
    {
        if (isset($lesion_id)) {
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->delete($lesion_id);
        }
        header('location: ' . URL . 'lesion');
    }
    
    public function statuschange($lesion_id, $status)
    {
        if (isset($lesion_id)) {
            $lesion_model = $this->loadModel('Lesion');
            $lesion_model->changestatus($lesion_id, $status);
        }
        header('location: ' . URL . 'lesion');
    }
}
