<?php

/**
 * Class Index
 * The index controller
 */
class Groups extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
		
        Auth::handleLogin();

    }

   
    function index()
    {
		$group_model = $this->loadModel('Group');
        $this->view->groups = $group_model->getAllGroups();
        $this->view->render('groups/index');
    }
	
	function addnew()
    {
		
		$group_model = $this->loadModel('Group');
        $this->view->modules = $group_model->getAllModules();
		 $this->view->render('groups/addnew');
    }
	
	/**
     * This method controls what happens when you move to /dashboard/create in your app.
     * Creates a new note. This is usually the target of form submit actions.
     */
    public function create()
    {
        if (isset($_POST['group_name']) AND !empty($_POST['group_name'])) {
            $group_model = $this->loadModel('Group');
            $group_model->create();
        }
        header('location: ' . URL . 'groups');
    }

    public function edit($group_id)
    {
        if (isset($group_id)) {
            // get the group that you want to edit (to show the current content)
            
            $group_model = $this->loadModel('Group');
			$this->view->modules = $group_model->getAllModules();        
            
            $this->view->group = $group_model->getGroup($group_id);
            $this->view->render('groups/edit');
        } else {
            header('location: ' . URL . 'groups');
        }
    }

  
    public function editSave($group_id)
    {
        if (isset($_POST['group_name']) && isset($group_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $group_model = $this->loadModel('Group');
            $group_model->editSave($group_id);
        }
        header('location: ' . URL . 'groups');
    }

   
    public function delete($group_id)
    {
        if (isset($group_id)) {
            $group_model = $this->loadModel('Group');
            $group_model->delete($group_id);
        }
        header('location: ' . URL . 'groups');
    }
}
