<?php

/**
 * Class Email
 * The Email controller
 */
class Email extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index($val="")
    {
		$viewper = $this->checkPermission(17, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(17, 4);
			$this->view->editper= $this->checkPermission(17, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(17, 3);
		 if($val!=''){
		   Session::set('edit_label', true);
		 } 
		$this->view->pageid=7;
        $template_model = $this->loadModel('Template');
        $this->view->emails = $template_model->getAllTemplates('Email');
        $this->view->render('emails/index');
		}
    }
	
	function addnew($val="")
    {
		if($val!=''){
		   Session::set('edit_label', true);		 
		   } 
            $this->view->render('emails/addnew');
    }
    
    function getcourse()
    {
		
		$course_model = $this->loadModel('Course');
		$this->view->courses = $course_model->getAllCourses();
		echo json_encode($this->view->courses);
		
	}
	function getemailids()
	{
		$student_model = $this->loadModel('Student');
		$student = $student_model->getAllStudentsEmails();
		echo $student;
	}
    function send_mail()
    {
			$email=$_POST['hiddenmails'];
			$template_model = $this->loadModel('Template');
			$this->view->email = $template_model->getAllTemplates("Email");
			//print_r($this->view->email);
		
			$this->view->emailid=$email;
            $this->view->render('emails/details');
    }

	
	 function sendMailToAll($val="")
    {		
        if($val!='')
        {
			Session::set('edit_label', true);
		}
		$this->view->pageid= 7;

	    $designation_model = $this->loadModel('Designation');
        $this->view->positions = $designation_model->getAllDesignationsbystsforcandidates(1);	
		$template_model = $this->loadModel('Template');
		$this->view->email = $template_model->getAllTemplates("Email");
		//print_r($this->view->email);
		$this->view->emailid="";
        $this->view->render('emails/sendmail');
    }
	
	
	 function getTemplate($id)
    {
			$template_model = $this->loadModel('Template');
			$email = $template_model->getTemplate1($id);
			//print_r($this->view->email);
		
			echo json_encode($email);
		
           
    }
	
    function sendmail()
    {
           if (isset($_POST['email_to']) AND !empty($_POST['email_subject']))
		   {
			
            $student_model = $this->loadModel('Student');
			$student = $student_model->sendmail();
        }
        header('location: ' . URL . 'candidateresult/index/0');
       
        
    }
    public function create()
    {
        if (isset($_POST['temp_name']) AND !empty($_POST['temp_name'])) {
            $template_model = $this->loadModel('Template');
            $template_model->create("Email");
        }
        header('location: ' . URL . 'email');
    }

    public function edit($template_id)
    {
        if (isset($template_id)) {
            // get the note that you want to edit (to show the current content)
            $template_model = $this->loadModel('Template');
            $this->view->email = $template_model->getTemplate($template_id);
            $this->view->render('emails/edit');
        } else {
            header('location: ' . URL . 'email');
        }
    }

    public function editSave($template_id)
    {
        if (isset($_POST['temp_subject']) && isset($template_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $template_model = $this->loadModel('Template');
            $template_model->editSave($template_id,"Email");
        }
        header('location: ' . URL . 'email');
    }

    public function delete($template_id)
    {
        if (isset($template_id)) {
            $template_model = $this->loadModel('Template');
            $template_model->delete($template_id);
        }
        header('location: ' . URL . 'email');
    }
}
