<?php

/**
 * Class Index
 * The index controller
 */
class Designation extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();
	if(isset($_SESSION['edit_label']))
		unset($_SESSION['edit_label']);
    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations();
        $this->view->render('designations/index');
    }
	
	public function getAllDefaultPosition()
    {
		try{
				$designation_model = $this->loadModel('Defaultposition');
				$desigarr = $designation_model->getAllDefaultPosition();
				echo json_encode($desigarr);
			}
		catch(Exception $e)
		{
		}
    }
	
	public function getcreatedDefaultPosition()
    {
		try{
				$designation_model = $this->loadModel('Defaultposition');
				$desigarr = $designation_model->getcreatedDefaultPosition();
				echo json_encode($desigarr);
			}
		catch(Exception $e)
		{
		}
    }
	
	public function getallpositions()
    {
		try	{
				$designation_model = $this->loadModel('Designation');
				$desigarr = $designation_model->getAllDesignations(1);
				echo json_encode($desigarr);
			}
		catch(Exception $e)
		{
		}
    }
	public function positionBySts()
    {
		try{
			
			$designation_model = $this->loadModel('Designation');
			$desigarr = $designation_model->getDesignationBySts();
			echo json_encode($desigarr);
		}
		catch(Exception $e){
		}
    }
	public function currentpositions($val='')
    {
		$viewper = $this->checkPermission(1, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(1, 4);
			$this->view->editper= $this->checkPermission(1, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(1, 3);	
		
	try{
		if($val!=''){
			Session::set('edit_label', true);
		}
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date('Y-m-d');
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(1);
        $this->view->render('designations/indexcurrent');
	
		}
		catch(Exception $e){
		}
		
	}
    }
	
	public function savepositions($val='')
    {
	$viewper = $this->checkPermission(1, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(1, 4);
			$this->view->editper= $this->checkPermission(1, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(1, 3);		
	try{
		if($val!=''){
			Session::set('edit_label', true);
		}
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date('Y-m-d');
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(5);
        $this->view->render('designations/savepositions');
	
		}
		catch(Exception $e){
		}
	}
    }
	public function pastpositions($val='')
    {
		$viewper = $this->checkPermission(1, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(1, 4);
			$this->view->editper= $this->checkPermission(1, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(1, 3);	
		if($val==4){
			Session::set('edit_label', true);
		}
		else if($val==3)
		{
			Session::set('edit_label', true);
		}
		
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($enddate=="")
		{
			$enddate=date('Y-m-d');
		}
		if($startdate=="")
		{
			$startdate=date('Y-m-d',(strtotime ( '-30 day',strtotime(date('Y-m-d'))) ));
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$this->view->pageid= 1;
		$this->view->val= $val;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(2);
        $this->view->render('designations/indexpast');
	}
    }
	public function allpositions($val='')
    {
		if($val!=''){
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		//$this->view->val= $val;
		$designation_model = $this->loadModel('Designation');
        $this->view->positionArr = $designation_model->getAllpositions();
        $this->view->render('designations/indexall');
		
    }
	public function unpublished($val='')
    {
		if($val!=''){
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		//$this->view->val= $val;
		$designation_model = $this->loadModel('Designation');
        $this->view->positionArr = $designation_model->getunpublished();
        $this->view->render('designations/indexunpublished');
		
    }
	
	public function getpositions($val=1)
    {
		$designation_model = $this->loadModel('Designation');
        $arr= $designation_model->getAllDesignations($val);
		echo json_encode($arr);
		exit();
    }
	public function addnew($val='')
    {
		if($val!='')
		{
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(1);
        $this->view->render('designations/addnew');
    }
	
	
	public function addnew1($val='')
    {
		if($val!=''){
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
         $this->view->designation = $designation_model->getDesignation(1);
		//$designation_model = $this->loadModel('Designation');
        //$this->view->designations = $designation_model->getAllDesignations(1);
        $this->view->render('designations/edit');
    }
	
	public function details($designation_id)
    {
		if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            $designation_model = $this->loadModel('Designation');
            $this->view->designation = $designation_model->getDesignation($designation_id);
            $this->view->render('designations/details');
        } else {
            header('location: ' . URL . 'designation');
        }
            
    }
	
    public function create()
    {
		try
		{
		if($_POST['hiddendefaultPosition']!="") 
			{
            $designation_model = $this->loadModel('Designation');
            $sts=$designation_model->create();
			header('location: ' . URL . 'designation/addnew');
			}
		  else
		   {
			   $_SESSION["feedback_negative"][] = "Please select position.";
			   header('location: ' . URL . 'designation/addnew');
		   }
		}
		catch(Exception $e)
		{
			
		}
			
    }
	
	
	public function openforpublish($positionid)
	{
		$positionupdate = $this->loadModel("Designation");
		$arr = $positionupdate->openforpublish($positionid);
		echo json_encode($arr);
	}
	

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
    public function edit($designation_id)
    {
		$this->view->pageid= 1;
		$this->view->pageid1= $designation_id;
		
        if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            $designation_model = $this->loadModel('Designation');
            $this->view->designation = $designation_model->getDesignation($designation_id);
            $this->view->render('designations/edit');
        } else {
            header('location: ' . URL . 'designation/currentpositions');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($designation_id)
    {
        if (($_POST['hiddendefaultPosition']!="")&& isset($designation_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $designation_model = $this->loadModel('Designation');
            $designation_model->editSave($designation_id);
			 header('location: ' . URL . 'designation/currentpositions');
        }else{
		   $_SESSION["feedback_negative"][] = "Please select position.";
		   header('location: ' . URL . 'designation/edit/'.$designation_id);
	   }
        //header('location: ' . URL . 'designation/addnew');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($designation_id,$val=0)
    {
        if (isset($designation_id)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->delete($designation_id);
        }
		if($val==1){
			 header('location: ' . URL . 'designation/pastpositions');
		}else{
			
			 header('location: ' . URL . 'designation/currentpositions');
		}
       
    }
    
	public function statuschange($designation_id, $status, $val=0)
    {
        if (isset($designation_id) && isset($status)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changestatus($designation_id, $status);
        }
        if($val==1)
        header('location: ' . URL . 'designation/currentpositions');
         if($val==2)
        header('location: ' . URL . 'designation/pastpositions');
         if($val==0)
        header('location: ' . URL . 'designation'); 
    }
    public function stschange($designation_id, $status)
    {
        if (isset($designation_id) && isset($designation_id)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changests($designation_id, $status);
        }
        header('location: ' . URL . 'designation'); 
    }
	//////////////////for Dynamic page label /////////////
	public function getlabel()  {
		try{
				$page_id = $_REQUEST['pageid'];
		if (isset($page_id)) {
			$label = $this->loadModel('Page');
			$labelarr = $label->getPositionlabel($page_id);
			echo json_encode($labelarr);	
        } else {
            header('location: ' . URL . 'designation');
        }
		}catch(Exception $e){} 
    }
	
	
	public function getlabeldata()  {
		try{
		$arr = array();
		$arr[1] = $_POST['pageid'];
		$arr[2] = $_POST['label'];
		$label = $this->loadModel('Page');
		$labelarr = $label->getlabelvalue($arr);
		echo json_encode($labelarr);	
      
		}catch(Exception $e){} 
    }
	public function createlabel()  {
		try{
		$arr = array();
		$arr[1] = $_POST['pageid'];
		
		$arr[2] = $_POST['label'];
		$arr[3] = $_POST['labelname'];
		$label = $this->loadModel('Page');
		$labelarr = $label->Createlabel($arr);
		echo json_encode($labelarr);	
      
		}catch(Exception $e){} 
    }
}
