<?php

/**
 * Class Index
 * The index controller
 */
class DefaultPosition extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();
	if(isset($_SESSION['edit_label']))
		unset($_SESSION['edit_label']);
    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
		$viewper = $this->checkPermission(1, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(1, 4);
			$this->view->editper= $this->checkPermission(1, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(1, 3);	
		$startdate = isset($_POST["startdate"])?$_POST["startdate"]:"";
		$enddate = isset($_POST["enddate"])?$_POST["enddate"]:"";
		/* if($startdate==''){
			$startdate='2019-10-02';
		}
		if($enddate==''){
			$enddate='2019-10-02';
		} */
		$this->view->startdate=$startdate;
		$this->view->enddate=$enddate;
		$settest_model = $this->loadModel('Defaultposition');
        $this->view->positionArr = $settest_model->getAllDefaultPosition();		
		$this->view->render('defaultPosition/index');
		}
    }
	
	public function alldefaultpositions()
    {
		$viewper = $this->checkPermission(14, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
	
		if($viewper){
			$this->view->addper= $this->checkPermission(14, 4);
			$this->view->editper= $this->checkPermission(14, 2); ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$this->view->deleteper= $this->checkPermission(14, 3);	
		
		$settest_model = $this->loadModel('Defaultposition');
        $this->view->positionArr = $settest_model->getAllcreatedPosition();		
		$this->view->render('defaultPosition/addpositions');
		}
    }
	
   public function addnew($val='')
	{	
		$designation_model = $this->loadModel('Designation');
		$this->view->designations = $designation_model->getAllDesignations(1);	   
		$Testlevel = $this->loadModel('Testlevel');
		$this->view->testlevel = $Testlevel->getAllTestlevel();		
		$testcategory_model = $this->loadModel('TestCategory');
		$this->view->tests = $testcategory_model->getAllTestCategorys();		
		if(isset($_POST['category_id']) && !empty($_POST['category_id']))
		{	
			$category_id=$_POST['category_id'];
			$quiz_model = $this->loadModel('Quiz');
			$this->view->category = $quiz_model->getAllCategorys($category_id);
		}
		$this->view->positionid=$val;
		$this->view->render('defaultPosition/addnew');
	}
		
	public function getallpositions()
    {
		try
		{
			$designation_model = $this->loadModel('Designation');
			$desigarr = $designation_model->getAllDesignations(1);
			echo json_encode($desigarr);
		}
		catch(Exception $e)
		{
		}
    }
	public function positionBySts()
    {
		try{
			
			$designation_model = $this->loadModel('Designation');
			$desigarr = $designation_model->getDesignationBySts();
			echo json_encode($desigarr);
		}
		catch(Exception $e){
		}
    }
	public function currentpositions($val='')
    {
	try{
		if($val!=''){
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(1);
        $this->view->render('designations/indexcurrent');
	
		}
		catch(Exception $e){
		}
    }
	public function pastpositions($val='')
    {
		if($val!=''){
			Session::set('edit_label', true);
		}
		$this->view->pageid= 1;
		$designation_model = $this->loadModel('Designation');
        $this->view->designations = $designation_model->getAllDesignations(2);
        $this->view->render('designations/indexpast');
    }
	
	public function getpositions($val=1)
    {
		$designation_model = $this->loadModel('Designation');
        $arr= $designation_model->getAllDesignations($val);
		echo json_encode($arr);
		exit();
    }
	
	public function details($designation_id)
    {
		if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            $designation_model = $this->loadModel('Designation');
            $this->view->designation = $designation_model->getDesignation($designation_id);
            $this->view->render('designations/details');
        } else {
            header('location: ' . URL . 'designation');
        }
            
    }
	
    public function create()
    {
            $defaultposition_model = $this->loadModel('Defaultposition');
            $arr=$defaultposition_model->create();
			echo json_encode($arr);
			exit();
    }

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
    public function edit($designation_id)
    {
		
        if (isset($designation_id)) {
            // get the group that you want to edit (to show the current content)
            //$designation_model = $this->loadModel('Defaultposition');
           // $this->view->designation = $designation_model->getDesignation($designation_id);
		   $this->positionid=$designation_id;
            $this->view->render('defaultPosition/addnew');
        } else {
            header('location: ' . URL . 'designation/currentpositions');
        }
    }
	    
	public function newpublish($designation_id)
    {
		//echo $designation_id;
		if (isset($designation_id)) {
		    $this->view->positionid=$designation_id;
			
            $this->view->render('defaultPosition/addnewpublish');
        } else {
            header('location: ' . URL . 'defaultPosition/alldefaultpositions');
        }
        
    }
    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($designation_id)
    {
        if (isset($_POST['designation_name']) && isset($designation_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $designation_model = $this->loadModel('Designation');
            $designation_model->editSave($designation_id);
        }
        header('location: ' . URL . 'designation/currentpositions');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($defaultPositionId,$val=0)
    {
		
        if (isset($defaultPositionId)) {
            $designation_model = $this->loadModel('DefaultPosition');
            $designation_model->delete($defaultPositionId);
        }
		if($val==11)
			header('location: ' . URL . 'designation/allpositions');
		else if($val==12)
			header('location: ' . URL . 'designation/unpublished');
			else
		header('location: ' . URL . 'defaultPosition');
    }
	
	public function deletedefault($defaultPositionId,$val=0)
    {
		
        if (isset($defaultPositionId)) {
            $designation_model = $this->loadModel('DefaultPosition');
            $designation_model->deletedefault($defaultPositionId);
        }
		if($val==11)
			header('location: ' . URL . 'designation/allpositions');
		else if($val==12)
			header('location: ' . URL . 'designation/unpublished');
			else
		header('location: ' . URL . 'defaultPosition/alldefaultpositions');
    }
    
	public function statuschange($designation_id, $status, $val=0)
    {
        if (isset($designation_id) && isset($status)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changestatus($designation_id, $status);
        }
        if($val==1)
        header('location: ' . URL . 'designation/currentpositions');
         if($val==2)
        header('location: ' . URL . 'designation/pastpositions');
         if($val==0)
        header('location: ' . URL . 'designation'); 
    }
    public function stschange($designation_id, $status)
    {
        if (isset($designation_id) && isset($designation_id)) {
            $designation_model = $this->loadModel('Designation');
            $designation_model->changests($designation_id, $status);
        }
        header('location: ' . URL . 'designation'); 
    }
	//////////////////for Dynamic page label /////////////
	public function getlabel()  {
		try{
				$page_id = $_REQUEST['pageid'];
		if (isset($page_id)) {
			$label = $this->loadModel('Page');
			$labelarr = $label->getPositionlabel($page_id);
			echo json_encode($labelarr);	
        } else {
            header('location: ' . URL . 'designation');
        }
		}catch(Exception $e){} 
    }
	public function getlabeldata()  {
		try{
		$arr = array();
		$arr[1] = isset($_POST['pageid'])? $_POST['pageid'] : 0;
		$arr[2] = isset ($_POST['label']) ? $_POST['label'] : 0  ;
		$label = $this->loadModel('Page');
		$labelarr = $label->getlabelvalue($arr);
		echo json_encode($labelarr);	
      
		}catch(Exception $e){} 
    }
	public function createlabel()  {
		try{
		$arr = array();
		$arr[1] = $_POST['pageid'];
		$arr[2] = $_POST['label'];
		$arr[3] = $_POST['labelname'];
		$label = $this->loadModel('Page');
		$labelarr = $label->Createlabel($arr);
		echo json_encode($labelarr);	
      
		}catch(Exception $e){} 
    }
	public function getdefaultposition($positionid)
	{
		$position_id = $this->loadModel("DefaultPosition");
		$arr = $position_id->getdefaultposition($positionid);
		echo json_encode($arr);
		
	}
	public function updatetestprofile($positionid)
	{
		$positionupdate = $this->loadModel("DefaultPosition");
		$arr = $positionupdate->updateposition($positionid);
		echo json_encode($arr);
	}
}
