<?php

/**
 * Class Index
 * The index controller
 */
class Course extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			        // VERY IMPORTANT: All controllers/areas that should only be usable by logged-in users
        // need this line! Otherwise not-logged in users could do actions. If all of your pages should only
        // be usable by logged-in users: Put this line into libs/Controller->__construct
        Auth::handleLogin();

    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    public function index()
    {
		$course_model = $this->loadModel('Course');
        $this->view->courses = $course_model->getAllCourses();
        $this->view->render('courses/index');
    }
	
	public function addnew()
    {
            $this->view->render('courses/addnew');
    }
	public function details($course_id)
    {
		if (isset($course_id)) {
            // get the group that you want to edit (to show the current content)
            $course_model = $this->loadModel('Course');
            $this->view->course = $course_model->getCourse($course_id);
            $this->view->render('courses/details');
        } else {
            header('location: ' . URL . 'course');
        }
            
    }
    public function create()
    {
        if (isset($_POST['course_name']) AND !empty($_POST['course_name'])) {
            $course_model = $this->loadModel('Course');
            $course_model->create();
        }
        header('location: ' . URL . 'course');
    }

    /**
     * This method controls what happens when you move to /note/edit(/XX) in your app.
     * Shows the current content of the note and an editing form.
     * @param $note_id int id of the note
     */
    public function edit($course_id)
    {
        if (isset($course_id)) {
            // get the group that you want to edit (to show the current content)
            $course_model = $this->loadModel('Course');
            $this->view->course = $course_model->getCourse($course_id);
            $this->view->render('courses/edit');
        } else {
            header('location: ' . URL . 'course');
        }
    }

    /**
     * This method controls what happens when you move to /note/editsave(/XX) in your app.
     * Edits a note (performs the editing after form submit).
     * @param int $note_id id of the note
     */
    public function editSave($course_id)
    {
        if (isset($_POST['course_name']) && isset($course_id)) {
            // perform the update: pass note_id from URL and note_text from POST
            $course_model = $this->loadModel('Course');
            $course_model->editSave($course_id);
        }
        header('location: ' . URL . 'course');
    }

    /**
     * This method controls what happens when you move to /note/delete(/XX) in your app.
     * Deletes a note. In a real application a deletion via GET/URL is not recommended, but for demo purposes it's
     * totally okay.
     * @param int $note_id id of the note
     */
    public function delete($course_id)
    {
        if (isset($course_id)) {
            $course_model = $this->loadModel('Course');
            $course_model->delete($course_id);
        }
        header('location: ' . URL . 'course');
    }
    
	public function statuschange($course_id, $status)
    {
        if (isset($course_id)) {
            $course_model = $this->loadModel('Course');
            $course_model->changestatus($course_id, $status);
        }
        header('location: ' . URL . 'course');
    }
}
