
  
(function($) {
    $.fn.orgChart = function(options) {
        var opts = $.extend({}, $.fn.orgChart.defaults, options);
        return new OrgChart($(this), opts);        
    }

    $.fn.orgChart.defaults = {
        data: [{id:0, name:'Root', parent: 0}], 
        showControls: false,
        allowEdit: false,
        onAddNode: null,
        onDeleteNode: null,
        onClickNode: null,
        newNodeText: 'Add Designation'
    }; 

    function OrgChart($container, opts){//alert('e');
        var data = opts.data;
        var nodes = {};
        var rootNodes = [];
        this.opts = opts;
        this.$container = $container;
        var self = this;

        this.draw = function(){//alert('j');
            $container.empty().append(rootNodes[0].render(opts));
            $container.find('.node').click(function(){//alert('h');
                if(self.opts.onClickNode !== null){//alert('i');
                    self.opts.onClickNode(nodes[$(this).attr('node-id')]);
                }
            });

            if(opts.allowEdit){//alert('k');
                $container.find('.node h2').click(function(e){//alert('l');
                    var thisId = $(this).parent().attr('node-id');
                    self.startEdit(thisId);
                    e.stopPropagation();
                });
            }

            // add "add button" listener
            $container.find('.org-add-button').click(function(e){
                var thisId = $(this).parent().attr('node-id');
				var namebool=false;
				if(nodes[thisId].data.name== ''){
					namebool=true;
					alert("Node cannot be blank");
				}
				for(var i in nodes){
					if(nodes[i].data.name== ''){
						namebool=true;
						alert("Any node cannot be blank");
						document.getElementById("node_"+nodes[i].data.id).focus();
					}  
					 
				}
				if(namebool==false){
					if(self.opts.onAddNode !== null){
						self.opts.onAddNode(nodes[thisId]);
					}
					else{
						self.newNode(thisId);
					}
				}
                e.stopPropagation();
            });

            $container.find('.org-del-button').click(function(e){//alert();
                var thisId = $(this).parent().attr('node-id');
				var nodests = nodes[thisId].data.sts;
				console.log(nodes[thisId].data.sts);
				if(self.opts.onDeleteNode !== null){
				var nodeid= $(this).attr('id');
				
                    self.opts.onDeleteNode(nodes[thisId]);
				//	console.log(nodes[thisId].data.sts);
					removeParentDesignation(thisId, nodests);
                }
                else{
                    self.deleteNode(thisId);
                }
                e.stopPropagation();
            });
        }

        this.startEdit = function(id){
			if(nodes[id].data.parent == 0)
					return false;
				
			var optionlist="";	
			for(var i in nodes){
				if(nodes[i].data.parent != 0){
					if(nodes[i].data.name == nodes[id].data.name){
						optionlist += '<option selected value="'+nodes[id].data.name+'">'+nodes[id].data.name+'</option>';
					}else{
						if(nodes[i].data.parent == 1 && nodes[i].data.sts == 0){
							optionlist += '<option value="'+nodes[i].data.name+'">'+nodes[i].data.name+'</option>';
						}
					} 
				}  
				 
			}	 
			console.log(optionlist); 
			
            var inputElement = $('<select id="node_'+nodes[id].data.id+'"class="org-input selectpicker" data-live-search="true">'+optionlist+'</select>');
            
			$container.find('div[node-id='+id+'] h2').replaceWith(inputElement);
            var commitChange = function(){//alert();
				if(nodes[id].data.name == "")
				{	return false;	} 
                var h2Element = $('<h2>'+nodes[id].data.name+'</h2>');
				
                if(opts.allowEdit){
                    h2Element.click(function(){
                        self.startEdit(id);
                    })
                }
                inputElement.replaceWith(h2Element);
				//console.log(nodes[id].data)
				 
			assigndesignation(nodes[id].data);     
            }
				 
           /*  var inputElement = $('<input class="org-input" type="text" value="'+nodes[id].data.name+'"/>');
			
            $container.find('div[node-id='+id+'] h2').replaceWith(inputElement);
            var commitChange = function(){
				if(nodes[id].data.name == "")
					return false;	
                var h2Element = $('<h2>'+nodes[id].data.name+'</h2>');
                if(opts.allowEdit){
                    h2Element.click(function(){
                        self.startEdit(id);
                    })
                }
                inputElement.replaceWith(h2Element);
				//console.log(nodes[id].data)
				
			//	assigndesignation(nodes[id].data); 
            } */  
            inputElement.focus();  
            inputElement.change(function(event){//alert('jjjjj');   
                if(event.which == 13){
                    commitChange();
                }
                else{
                    nodes[id].data.name = inputElement.val();
				//	console.log(nodes[id].data.name);
                }
            });
            inputElement.blur(function(event){
                commitChange();
            })
			
        }

        this.newNode = function(parentId){//alert('AA');
            var nextId = Object.keys(nodes).length;
			//alert("  "+nextId+" ");   
            while(nextId in nodes){
                nextId++;
            }
		//	alert(nextId);
		//	alert(parentId); 

            self.addNode({id: nextId, name: '', parent: parentId});
        }

        this.addNode = function(data){//alert('BB');
            var newNode = new Node(data);
            nodes[data.id] = newNode;
            nodes[data.parent].addChild(newNode);

            self.draw();//alert(data.id);
            self.startEdit(data.id);
        }

        this.deleteNode = function(id){
            for(var i=0;i<nodes[id].children.length;i++){
                self.deleteNode(nodes[id].children[i].data.id);
            }
            nodes[nodes[id].data.parent].removeChild(id);
            delete nodes[id];
            self.draw();
        }

        this.getData = function(){
            var outData = [];
            for(var i in nodes){
                outData.push(nodes[i].data);
            }
            return outData;
        }

        // constructor
        for(var i in data){
            var node = new Node(data[i]);
            nodes[data[i].id] = node;
        }

        // generate parent child tree
        for(var i in nodes){
            if(nodes[i].data.parent == 0){//console.log('1');console.log(nodes[i].data.name);
                rootNodes.push(nodes[i]);
            }
            else if(nodes[i].data.parent == 1 && nodes[i].data.sts == 1){//console.log('2');console.log(nodes[i].data.name);
                nodes[nodes[i].data.parent].addChild(nodes[i]);
            }
			else if(nodes[i].data.parent != 0 && nodes[i].data.parent != 1 && (nodes[i].data.child == 1 || nodes[i].data.child == 0)){//console.log('3');console.log(nodes[i].data.name);
                nodes[nodes[i].data.parent].addChild(nodes[i]);
            }
        }

        // draw org chart
        $container.addClass('orgChart');
        self.draw();
    }

    function Node(data){
        this.data = data;
        this.children = [];
        var self = this;

        this.addChild = function(childNode){
            this.children.push(childNode);
        }

        this.removeChild = function(id){
            for(var i=0;i<self.children.length;i++){
                if(self.children[i].data.id == id){
                    self.children.splice(i,1);
                    return;
                }
            }
        }

        this.render = function(opts){
            var childLength = self.children.length,
                mainTable;

            mainTable = "<table cellpadding='0' cellspacing='0' border='0'>";
            var nodeColspan = childLength>0?2*childLength:2;
            mainTable += "<tr><td colspan='"+nodeColspan+"'>"+self.formatNode(opts)+"</td></tr>";

            if(childLength > 0){
                var downLineTable = "<table cellpadding='0' cellspacing='0' border='0'><tr class='lines x'><td class='line left half'></td><td class='line right half'></td></table>";
                mainTable += "<tr class='lines'><td colspan='"+childLength*2+"'>"+downLineTable+'</td></tr>';

                var linesCols = '';
                for(var i=0;i<childLength;i++){
                    if(childLength==1){
                        linesCols += "<td class='line left half'></td>";    // keep vertical lines aligned if there's only 1 child
                    }
                    else if(i==0){
                        linesCols += "<td class='line left'></td>";     // the first cell doesn't have a line in the top
                    }
                    else{
                        linesCols += "<td class='line left top'></td>";
                    }

                    if(childLength==1){
                        linesCols += "<td class='line right half'></td>";
                    }
                    else if(i==childLength-1){
                        linesCols += "<td class='line right'></td>";
                    }
                    else{
                        linesCols += "<td class='line right top'></td>";
                    }
                }
                mainTable += "<tr class='lines v'>"+linesCols+"</tr>";

                mainTable += "<tr>";
                for(var i in self.children){
                    mainTable += "<td colspan='2'>"+self.children[i].render(opts)+"</td>";
                }
                mainTable += "</tr>";
            }
            mainTable += '</table>';
            return mainTable;
        }

        this.formatNode = function(opts){
            var nameString = '',
                descString = '';
            if(typeof data.name !== 'undefined'){
                nameString = '<h2>'+self.data.name+'</h2>';
            }
            if(typeof data.description !== 'undefined'){
                descString = '<p>'+self.data.description+'</p>';
            }
            if(opts.showControls){
				if(this.data.child==1){
				
					var buttonsHtml = "<div class='org-add-button'>"+opts.newNodeText+"</div><div class='org-del-button' id='org-del-button_"+this.data.id+"_"+this.data.child+"' style='pointer-events:none'></div>";
				
				}else if(this.data.child==0){
					
					var buttonsHtml = "<div class='org-add-button'>"+opts.newNodeText+"</div><div class='org-del-button' id='org-del-button_"+this.data.id+"_"+this.data.child+"'style='pointer-events:auto'></div>";

				}else{
					var buttonsHtml = "<div class='org-add-button'>"+opts.newNodeText+"</div><div class='org-del-button'></div>"; 
				}
            }
            else{
                buttonsHtml = '';
                buttonsHtml = '';
            }
            return "<div class='node' node-id='"+this.data.id+"'>"+nameString+descString+buttonsHtml+"</div>";
        }
    }
	
	function assigndesignation ($data){
		//console.log($data.name)
		if($data.name == "")
			return false;
		var saveData = $.ajax({
      type: 'POST',
	  data:$data,
      url: '../setup/AssignDesignations',
     // data: myKeyVals,
      dataType: "json",
      success: function(resultData) { 
	  console.log(resultData.returnsts);
		if(resultData.returnsts=='insert'){
		//	alert("Designation created successfully!");
			location.reload();
		}
		else if(resultData.returnsts=='update'){
		//	alert("Designation updated successfully!");
			location.reload();
		}
		else if(resultData.returnsts=='duplicate'){
		//	alert("Designation already exist!");
			location.reload();
		}
		else if(resultData.returnsts=='hierarchy loop'){
			alert("hierarchy loop");
			location.reload();
		}else if(resultData.returnsts=='root node'){
		//	alert("This Designation is already root node");
			location.reload();
		}else{
			alert("There is some problem!");
			//location.reload(); 
		}		
		
		//console.log(resultData)
		
		
	  },
	   error : function($xhr,textStatus,errorThrown){
		   console.log("ERROR : ", errorThrown);
		   console.log("ERROR : ", $xhr);
		   console.log("ERROR : ", textStatus);
		}
	});
		
	}
	 
	function removeParentDesignation ($nodeid, $sts){
		console.log($nodeid);
		if($nodeid == "")
			return false;
		
		var xsrf = $.param({nodeid: $nodeid, sts: $sts});
		var saveData = $.ajax({
		type: 'POST',
		data: xsrf,
		url: '../setup/removeParentDesignation',
		dataType: "json", 

		success: function(resultData) { 
			  console.log(resultData.status);

		if(resultData.status){
			alert("Parent Designation removed succesfully!");
			location.reload();

		}	
		
		 
		},
		   error : function($xhr,textStatus,errorThrown){
			   console.log("ERROR : ", errorThrown);
			   console.log("ERROR : ", $xhr);
			   console.log("ERROR : ", textStatus);
			}
		});
		
	} 
	function getHierarchy()
	{
		var saveData = $.ajax({
      type: 'POST',
      url: '../setup/getHierarchy',
     // data: myKeyVals,
      dataType: "json",
      success: function(resultData) { 
		
		testData = resultData.data;
		//console.log(testData)
		 org_chart = $('#orgChart').orgChart({
            data: testData,
            showControls: true,
            allowEdit: true,
            onAddNode: function(node){ 
                //log('Created new node on node '+node.data.id);
                org_chart.newNode(node.data.id);
				
				
				
				//console.log(node)
            },
            onDeleteNode: function(node){//alert('onDeleteNode');
                //log('Deleted node '+node.data.id);
                org_chart.deleteNode(node.data.id); 
            },
            onClickNode: function(node){
                //log('Clicked node '+node.data.id);
            }

        });
		var saveData1 = $.ajax({
		  type: 'POST',
		  url: '../setup/getalldesignation',
		 // data: myKeyVals,
		  dataType: "json",
		  success: function(resultData) { 
		
			testData = resultData.data;
			//console.log(testData)
			var temp="";		
			for(var i=0;i<testData.length;i++)
			{
				
				if(testData[i].Name != "")
					temp=temp+'<li class="list-group-item">'+testData[i].Name+'</li>';
				
			}
			$("#desig").html(temp);
		 
		  }
		}); 
		
	  }
	  });
	}

})(jQuery);

