/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('ubiapp', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
 app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});
/////////////////////////// Organization Controller Starts From Here  ///////////////////////////////////

app.controller('organizationCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.currencyarr=[];
$scope.countryarr=[];
$scope.cityarr=[];
$scope.otherarr=[];
$scope.timezonearr=[];
$scope.currency=0;
$scope.country=0;
$scope.city=0;
$scope.dateformat=0;
$scope.timeformat=0;
$scope.timezone=0;
$scope.listarr=[];

onLoadOrganizationData();

$scope.onRefresh=function(){
	onLoadOrganizationData();
}
function onfetchother()
{ 
$scope.otherarr=[];
	$http({
        url: path+'other',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.otherarr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchzone($id)
{ 
$scope.timezonearr=[];
var xsrf = $.param({countryid:$id });
	$http({
        url: path+'other/getallzones',
        method: "POST", data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.timezonearr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchcurrency($id)
{ 
$scope.currencyarr=[];
var xsrf = $.param({countryid:$id });
	$http({
        url: path+'currency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.currencyarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchcountry()
{ 
$scope.countryarr=[];
	$http({
        url: path+'country',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.countryarr=data;
			
			if($scope.country>0){
				onfetchcity($scope.country);
				onfetchcurrency($scope.country);
				onfetchzone($scope.country);
			}else{
				$scope.country=data[0]['id'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.oncountry =function()
{
	$scope.city=0;
	$scope.currency=0;
	onfetchcity($scope.country);
	onfetchcurrency($scope.country);
	onfetchzone($scope.country);
}

function onfetchcity($id)
{
$scope.cityarr=[];
	$scope.hastrue=true;
	var xsrf = $.param({countryid:$id });
	$http({
        url: path+'city',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.cityarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onLoadOrganizationData()
{
$scope.hastrue=true;

  $http({
        url: path+'setup/getOrganization',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	  
			if(data.result){
				$scope.about = data.data[0]['aboutcompany'];
				$scope.company_name = data.data[0]['name'];
				$scope.company_website = data.data[0]['website'];
				$scope.contact_number = Number(data.data[0]['phone']);
				$scope.alternate_number = Number(data.data[0]['altphone']);
				$scope.email_address = data.data[0]['email'];
				$scope.alternate_email = data.data[0]['altemail'];
				$scope.address = data.data[0]['address'];
				$scope.landmark = data.data[0]['landmark'];
				$scope.country = data.data[0]['country'];
				$scope.city = data.data[0]['city'];
				$scope.zip_code = data.data[0]['zip'];
				$scope.currency = data.data[0]['currency'];
				$scope.dateformate = data.data[0]['dateformat'];
				$scope.timeformate = data.data[0]['timeformat'];
				$scope.timezone = data.data[0]['timezone'];
				$scope.cmppic = data.data[0]['cmppic'];
				
				
			}
			onfetchcountry();
			onfetchother();
			onfetchlist();
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onUpdate= function()
{
$scope.orgdata =[];
$scope.hastrue=true;

var xsrf = $.param({ company_name:$scope.company_name, company_website:$scope.company_website, contact_number:$scope.contact_number, alternate_number:$scope.alternate_number, email_address:$scope.email_address, alternate_email:$scope.alternate_email, address:$scope.address, country:$scope.country, landmark:$scope.landmark, city:$scope.city, zip_code:$scope.zip_code, currency:$scope.currency, timezone:$scope.timezone, dateformate:$scope.dateformate, timeformate:$scope.timeformate, about:$scope.about});
  $http({
        url: path+'setup/updateOrganization',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.result)
			{
				successMessage(data.msg);	
					if($scope.files!=""){
						
						$scope.uploadFile();
					}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchlist()
{ 

$scope.listarr=[];
$scope.listname=[];
$scope.column=[];
$scope.table_name="CompanyMaster";

$scope.hastrue=true;
var xsrf = $.param({table_name: $scope.table_name});
	$http({
        url: path+'setup/getRelatedList',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       
		       $scope.listarr=data; 
		       
			for(var i=0; i<data.length; i++)
			{
				$scope.listname[i]=data[i]['listname'];
				//alert($scope.listname[i]);
				$scope.column[i]=data[i]['dfields'];
				//alert($scope.column[i]);
			}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
//////////for upload company logo////////////////

$scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"setup/uploadCompanyLogo",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                //formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				//formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				//window.open(path+"setup/company", "_self");
					$timeout(function(){window.open(path+"setup/company", "_self");}, timeo);  
				
			}
			else{
				errorMessage(data.errorMsg);
			}
			
			$scope.hastrue=false;
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }

});


//////////////////////////// Related List Controller Starts From Here ////////////////////////////////


app.controller('relatedlistCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.listarr=[];
$scope.dfields=0;
$scope.list_name='';
$scope.parent_name=0;
$scope.child_name=0;
$scope.ch=true;

$scope.refresh = function(){
	table.fnClearTable();
}

onLoadRelatedlistData();

$scope.oncreate = function($val)
{
if($scope.list_name=="" || angular.isUndefined($scope.list_name))
{
	alert("List Name cannot be left blank.");
	return false;
}
if($scope.parent_name=="Select List" || angular.isUndefined($scope.parent_name))
{
	alert("Parent Name cannot be left blank.");
	return false;
}
if($scope.child_name=="Select List" || angular.isUndefined($scope.child_name))
{
	alert("Child Name cannot be left blank.");
	return false;
}


$scope.hastrue=true;
var xsrf = $.param({list_name: $scope.list_name, parent_name: $scope.parent_name, child_name: $scope.child_name, dfields: $scope.dfields, sts: $scope.ch});
  $http({
        url: path+'setup/createrelatedlist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.list_name='';
				$scope.child_name=0;
				$scope.parent_name=0;
				$scope.dfields=0;
				
				if($val==1){
					//window.open(path+"setup/relatedlist/index", "_self");
					$timeout(function(){window.open(path+"setup/relatedlist", "_self");}, timeo);  
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onupdate = function($val)
{
//alert($scope.relatedlistid);
if($scope.child_name=="")
{
	alert("List name cannot be left blank.");
	return false;
}
$scope.hastrue=true;
var xsrf = $.param({relatedlistid: $scope.relatedlistid, list_name: $scope.list_name, parent_name: $scope.parent_name, child_name: $scope.child_name, dfields: $scope.dfields, sts: $scope.ch});
  $http({
        url: path+'setup/updatedrelatedlist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.list_name='';
				$scope.parent_name=0;
				$scope.child_name=0;
				$scope.dfields=0;
				
				$scope.relatedlistid=0;
				
				if($val==1){
					$timeout(function(){window.open(path+"setup/relatedlist", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


function onfetchlist()
{ 
$scope.listarr=[];
	$http({
        url: path+'setup/getalllist',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.listarr=data;
			
			if($scope.child_name>0){
				onfetchfields($scope.child_name);
				//onfetchcurrency($scope.country);
			}else{
				//$scope.list_name=data[0]['list_name'];
				$scope.parent_name=data[0]['child_name'];
				$scope.child_name=data[0]['child_name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onlistchange =function()
{
	$scope.dfields=0;
	onfetchfields($scope.child_name);
}

function onfetchfields($child_name)
{
$scope.fieldsarr=[];
	$scope.hastrue=true;
	var xsrf = $.param({child_name:$child_name });
	$http({
        url: path+'setup/getallcolumnname',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.fieldsarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onLoadRelatedlistData()
{
$scope.hastrue=true;
$scope.dfields=0;
onfetchlist();
$scope.hastrue=false;
}



$scope.onfetchrelatedlist =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({relatedlistid: $id});
	$http({
        url: path+'setup/getarelatedlist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.list_name=data.data[0]['name'];
				$scope.parent_name=data.data[0]['pname'];
				$scope.child_name=data.data[0]['cname'];
				$scope.fieldsarr=onfetchfields($scope.child_name);
				$scope.dfields=data.data[0]['dfields'].split(',');
				//alert($scope.fieldsarr);
								
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


});


/////////////////////////// Related List Controller Ends Here ////////////////////////////////////////


/////////////////////////// Division Controller Starts From Here  ///////////////////////////////////

app.controller('divisionCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.currencyarr=[];
$scope.countryarr=[];
$scope.cityarr=[];
$scope.otherarr=[];
$scope.timezonearr=[];
$scope.currency=0;
$scope.country=0;
$scope.city=0;
$scope.dateformat=0;
$scope.timeformat=0;
$scope.timezone=0;
$scope.divisionid=0;
$scope.columnarr=[];
$scope.establishment="";
$scope.account="";

$scope.getId = function($id) {
	$scope.divisionid=$id;
}
$scope.getarchiveId = function($id,$val) {
	
	$scope.archivepath="setarchive/"+$id+'/'+$val;
	
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletedivision/'+$scope.divisionid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.divisionid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangests =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/'+$scope.archivepath,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.gradeid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchzone($id)
{ 
$scope.timezonearr=[];
var xsrf = $.param({countryid:$id });
	$http({
        url: path+'other/getallzones',
        method: "POST", data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.timezonearr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchother()
{ 
$scope.otherarr=[];
	$http({
        url: path+'other',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.otherarr=data.data;
			}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchcountry()
{ 
$scope.countryarr=[];
	$http({
        url: path+'country',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.countryarr=data;
			
			if($scope.country>0){
				onfetchcity($scope.country);
				onfetchcurrency($scope.country);
				onfetchzone($scope.country);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.oncountry =function()
{
	$scope.city=0;
	$scope.currency=0;
	onfetchcity($scope.country);
	onfetchcurrency($scope.country);
	onfetchzone($scope.country);
}
function onfetchcurrency($id)
{ 
$scope.currencyarr=[];
var xsrf = $.param({countryid:$id });
	$http({
        url: path+'currency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.currencyarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchcity($id)
{
$scope.cityarr=[];
	$scope.hastrue=true;
	var xsrf = $.param({countryid:$id });
	$http({
        url: path+'city',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.cityarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdivision =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({divisionid: $id});
	$http({
        url: path+'setup/getadivision',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.divisionname=data.data[0]['name'];
				$scope.divisioncode=data.data[0]['code'];
				$scope.contactperson=data.data[0]['cperson'];
				$scope.emailaddress=data.data[0]['email'];
				$scope.contactnumber=data.data[0]['cnumber'];
				$scope.altnumber=data.data[0]['altcnumber'];
				$scope.currency=data.data[0]['currencyid'];
				$scope.timezone=data.data[0]['timezone'];
				$scope.dateformat=data.data[0]['dateformat'];
				$scope.timeformat=data.data[0]['timeformat'];
				$scope.address=data.data[0]['address'];
				$scope.landmark=data.data[0]['landmark'];
				$scope.zipcode=data.data[0]['zipcode'];
				$scope.country=data.data[0]['countryid'];
				$scope.city=data.data[0]['cityid'];
				$scope.shortname=data.data[0]['shortname'];
				$scope.account=data.data[0]['account'];
				$scope.establishment=data.data[0]['establishment'];
			}
			onfetchcountry();
			onfetchother();
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

//////////////////////////////////////////////

$scope.onfetchcolumn =function($id)
{
//alert("hello");
	$scope.columnarr=[];
	$scope.hastrue=true;
	var xsrf = $.param({divisionid: $id});
	$http({
        url: path+'setup/getcolumns',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
      				successMessage(data.data[0]);
      				$scope.columnarr=data;
				$scope.hastrue=false;
	        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

//////////////////////////////////////////////

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({divisionname: $scope.divisionname, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber, altnumber: $scope.altnumber, emailaddress: $scope.emailaddress, address: $scope.address, country: $scope.country, city: $scope.city, zipcode:$scope.zipcode, landmark: $scope.landmark, currency: $scope.currency, dateformat: $scope.dateformat, timeformat: $scope.timeformat, timezone: $scope.timezone, divisioncode:$scope.divisioncode, shortname:$scope.shortname, account:$scope.account, establishment:$scope.establishment});
  $http({
        url: path+'setup/createdivision',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);				
				$scope.divisionname="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.altnumber="";
				$scope.currency="";
				$scope.timezone="";
				$scope.dateformat="";
				$scope.timeformat="";
				$scope.address="";
				$scope.landmark="";
				$scope.zipcode="";
				$scope.country="";
				$scope.city="";
				$scope.divisionid=0;
				$scope.divisioncode="";
				$scope.shortname="";
				$scope.establishment="";
				$scope.account="";
				if($val==1){
					//window.open(path+"setup/division", "_self");
					$timeout(function(){window.open(path+"setup/division", "_self");}, timeo);  
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({divisionid: $scope.divisionid, divisionname: $scope.divisionname, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber, altnumber: $scope.altnumber, emailaddress: $scope.emailaddress, address: $scope.address, country: $scope.country, city: $scope.city, zipcode:$scope.zipcode, landmark: $scope.landmark, currency: $scope.currency, dateformat: $scope.dateformat, timeformat: $scope.timeformat, timezone: $scope.timezone, divisioncode:$scope.divisioncode,  shortname:$scope.shortname,  account:$scope.account, establishment:$scope.establishment});
  $http({
        url: path+'setup/updatededivision',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.divisionname="";
				$scope.divisioncode="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.altnumber="";
				$scope.currency="";
				$scope.timezone="";
				$scope.dateformat="";
				$scope.timeformat="";
				$scope.address="";
				$scope.landmark="";
				$scope.zipcode="";
				$scope.country="";
				$scope.city="";
				$scope.divisionid=0;
				$scope.shortname="";
				$scope.establishment="";
				$scope.account="";
				if($val==1){
					$timeout(function(){window.open(path+"setup/division", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});


/////////////////////////// Department Controller Starts From Here  ///////////////////////////////////

app.controller('departmentCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.departments=[];
$scope.parentdeptname=0;
$scope.dep=[];
$scope.deptid=0;
onloadtreeview();

var org_chart ;
/////////////////////////////
$scope.getId = function($id) {
	$scope.deptid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletedepartment/'+$scope.deptid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.deptid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onloadtreeview()
{
	//alert("onloadtreeview");
	$scope.dep=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getalldepartment',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dep=data.data;
				
				org_chart = $('#orgChart').orgChart({
				    data: $scope.dep,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					log('Clicked node '+node.data.id);
				    }

				});
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////
    
    function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }
    
   
    
    
/////////////////////////////////////////////
    
$scope.onfetch =function()
{
	$scope.departments=[];
	$scope.hastrue=true;

	$http({
        url: path+'setup/getalldepartment',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.departments=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdept =function($id)
{
	$scope.departments=[];
	$scope.hastrue=true;
var xsrf = $.param({deptid: $id});
	$http({
        url: path+'setup/getadepartment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.deptname=data.data[0]['name'];
				$scope.deptcode=data.data[0]['code'];
				$scope.parentdeptname=data.data[0]['parentid'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({deptname: $scope.deptname, parentdeptname: $scope.parentdeptname, deptcode:$scope.deptcode});
  $http({
        url: path+'setup/createdepartment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.deptname="";
				$scope.parentdeptname=0;
				$scope.deptid=0;
				$scope.deptcode="";
				
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/department", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({deptid: $scope.deptid, deptname: $scope.deptname, parentdeptname: $scope.parentdeptname, deptcode:$scope.deptcode});
  $http({
        url: path+'setup/updatedepartment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.deptname="";
				$scope.parentdeptname=0;
				$scope.deptid=0;
				$scope.deptcode="";
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/department", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


/////////////////////////// channel Controller Starts From Here  ///////////////////////////////////

app.controller('channelCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.departments=[];
$scope.parentdeptname=0;
$scope.dep=[];
$scope.deptid=0;
onloadtreeview();

var org_chart ;
/////////////////////////////
$scope.getId = function($id) {
	$scope.deptid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletechannel/'+$scope.deptid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.deptid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onloadtreeview()
{
	//alert("onloadtreeview");
	$scope.dep=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getallchannel',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dep=data.data;
				
				org_chart = $('#orgChart1').orgChart({
				    data: $scope.dep,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					log('Clicked node '+node.data.id);
				    }

				});
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////
    
    function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }
    
   
    
    
/////////////////////////////////////////////
    
$scope.onfetch =function()
{
	$scope.departments=[];
	$scope.hastrue=true;

	$http({
        url: path+'setup/getallchannel',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.departments=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdept =function($id)
{
	$scope.departments=[];
	$scope.hastrue=true;
var xsrf = $.param({deptid: $id});
	$http({
        url: path+'setup/getachannel',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.deptname=data.data[0]['name'];
				$scope.deptcode=data.data[0]['code'];
				$scope.parentdeptname=data.data[0]['parentid'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({deptname: $scope.deptname, parentdeptname: $scope.parentdeptname, deptcode:$scope.deptcode});
  $http({
        url: path+'setup/createchannel',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.deptname="";
				$scope.parentdeptname=0;
				$scope.deptid=0;
				$scope.deptcode="";
				
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/channels", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({deptid: $scope.deptid, deptname: $scope.deptname, parentdeptname: $scope.parentdeptname, deptcode:$scope.deptcode});
  $http({
        url: path+'setup/updatechannel',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.deptname="";
				$scope.parentdeptname=0;
				$scope.deptid=0;
				$scope.deptcode="";
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/channels", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});



/////////////////////////// Designation Controller Starts From Here  ///////////////////////////////////

app.controller('designationCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.rolearray=[];
$scope.rol=[];
$scope.desigid=0;

//onfetch('setup/getalldesignation',1);
	$('input').on('ifChecked', function(event){	
		if(event.target.name=="hrsts"){
			$scope.hrsts=event.target.value;		
		}
	});		
var org_chart ;
/////////////////////////////////////////
$scope.getId = function($id) {
	$scope.desigid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletedesignation/'+$scope.desigid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.desigid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangehrsts =function()
{
	$http({
        url: path+'setup/adddesigstatus/'+$scope.desigid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.desigid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}



$scope.onfetch = function($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				$scope.rolearray=[];
					$scope.rolearray=data.data;
				if($id==1){
					
					org_chart = $('#orgChart').orgChart({
				    data: $scope.rolearray,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					//log('Clicked node '+node.data.id);
				    }

				});
					
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

$scope.getalldesigforparentdesig = function($desigid)
{
	$scope.hastrue=true;
	var xsrf = $.param({desigid: $desigid});
	$http({
        url: path+'setup/getalldesigforparentdesig',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				$scope.rolearray1=[];
					$scope.rolearray1=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}		



$scope.onfetchdept =function($id)
{
	
	$scope.hastrue=true;
var xsrf = $.param({desigid: $id});
	$http({
        url: path+'setup/getadesignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.designame=data.data[0]['name'];
				$scope.desigcode=data.data[0]['code'];
				//document.getElementById('desc').value=data.data[0]['desc'];
				$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
				$scope.roleid=data.data[0]['parent'];
				$scope.hrsts=data.data[0]['hrsts'];
				$('#chk1').iCheck(($scope.hrsts=="1")?'check':'uncheck'); 
				$('#chk2').iCheck(($scope.hrsts=="0")?'check':'uncheck');
				//$scope.gradeid=data.data[0]['grade'];
				//$scope.rolearray=data.data[0]['rolearr'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

/*$scope.oncheckdesc=function()
{
	//alert($scope.desc.length);
	if($scope.desc.length<=20)
	{return true;}
	else
	{alert("You can not add more than 20 characters."); return false;}
	return false;
}*/

$scope.oncreate = function($val)
{
//alert($scope.desc.length);

$scope.hastrue=true;
var xsrf = $.param({designame: $scope.designame, desigcode: $scope.desigcode, gradeid:$scope.gradeid, roleid:$scope.roleid, desc: document.getElementById('desc').value,hrsts:$scope.hrsts});
  $http({
        url: path+'setup/createdesignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.designame="";
				$scope.desigid=0;
				$scope.desigcode="";
				$scope.roleid="";
				$scope.gradeid="";
				$scope.desc="";
				if($val==1){
					$timeout(function(){window.open(path+"setup/designation", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({desigid: $scope.desigid, designame: $scope.designame, desigcode: $scope.desigcode, gradeid:$scope.gradeid, roleid:$scope.roleid, desc: document.getElementById('desc').value ,hrsts:$scope.hrsts});
  $http({
        url: path+'setup/updatedesignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.designame="";
				$scope.desigcode="";
				$scope.desigid=0;
				$scope.roleid="";
				$scope.gradeid="";
				$scope.desc="";
				if($val==1){
					$timeout(function(){window.open(path+"setup/designation", "_self");}, timeo);  
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});

/////////////////////////// Grade Controller Starts From Here  ///////////////////////////////////

app.controller('gradeCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.grades=[];
$scope.parentdeptname=0;
$scope.gradename="";
$scope.desc="";
$scope.nomonths="";
$scope.salincreamentper="";
$scope.gradeid=0;
$scope.benefits=[];
$scope.gradebenefits=[{benefit:"", amount:""}];
onfetchbenefit();

$scope.refresh = function(){
	table.fnClearTable();
}
$scope.addsalary = function()
   {
		$scope.gradebenefits.insert($scope.gradebenefits.length,{benefit:"", amount:""});
   }
   $scope.removesalary = function($index)
   {
	$scope.gradebenefits.remove($index);
   }

	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
$scope.getId = function($id) {
	$scope.gradeid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deletegrade/'+$scope.gradeid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.gradeid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangelevel =function($path)
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/'+$path,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.gradeid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchbenefit()
{
	$scope.hastrue=true;
	var xsrf = $.param({headtype: 2});
	$http({
        url: path+'salary/getallbenefit',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.benefits=[];
				$scope.benefits=data.data;
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetchdept =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({gradeid: $id});
	$http({
        url: path+'setup/getagrade',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.gradename=data.data[0]['name'];
				$scope.gradecode=data.data[0]['code'];
				$scope.gradebenefits=data.data[0]['gradeid'];
				$scope.salincreamentper=data.data[0]['salincreamentper'];
				$scope.nomonths=data.data[0]['nomonths'];
				$scope.desc=data.data[0]['description'];
				if($scope.gradebenefits.length==0){
					$scope.gradebenefits.insert($scope.gradebenefits.length,{benefit:"", amount:""});
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({gradename: $scope.gradename, desc: $scope.desc, gradebenefits:$scope.gradebenefits,nomonths:$scope.nomonths,salincreamentper:$scope.salincreamentper, gradecode:$scope.gradecode});
  $http({
        url: path+'setup/creategrade',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.gradename="";
				$scope.desc="";
				$scope.gradecode="";
				$scope.gradeid=0;
				$scope.nomonths="";
				$scope.salincreamentper="";
				
				if($val==1){					
					 $timeout(function(){window.open(path+"setup/grade", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({gradeid: $scope.gradeid, gradename: $scope.gradename, desc: $scope.desc, gradebenefits:$scope.gradebenefits, gradecode:$scope.gradecode,nomonths:$scope.nomonths,salincreamentper:$scope.salincreamentper, });
  $http({
        url: path+'setup/updatedegrade',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.gradename="";
				$scope.desc="";
				$scope.gradecode="";
				$scope.gradeid=0;
				$scope.nomonths="";
				$scope.salincreamentper="";
				if($val==1){					
					 $timeout(function(){window.open(path+"setup/grade", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});




/////////////////////////// Approval Process Controller Starts From Here  ///////////////////////////////////

app.controller('approvalCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.approvals=[];
$scope.approvaltype=1;
$scope.approvalfor="";
$scope.period=1;
$scope.approvalid=0;
$scope.designations=[];
$scope.approvalbenefits=[];
$scope.designationarray=[];
$scope.hrapproval=0;
$scope.approvalupto=0;
$scope.showdesig=1;
$scope.showuptolevel=0;
onfetchdesignation();
$scope.CheckMaxVal=function($approvalupto){
	var approvalvalue=$("#approvalupto").val();
	console.log(approvalvalue);
	if(approvalvalue>4){
		
		alert("You can not choose upto 4 value");
		$scope.approvalupto=0;
	}
	
}
$scope.getId = function($id) {
	$scope.approvalid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deleteapproval/'+$scope.approvalid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.approvalid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.addsalary = function($id,$index)
   {
		
		var temp ="";
		var temp1 ="";
		for(var i=0;i<$scope.designationarray.length;i++){
			if($scope.designationarray[i].id == $id){
				
				temp=$scope.designationarray[i].name;
				$scope.approvalbenefits.insert($index,{benefit:$id,dname:temp});
				//$scope.approvalbenefits[$index].dname=temp;
				//$scope.approvalbenefits[$index].benefit=$id;
				//console.log($scope.approvalbenefits[$index].benefit)
				var level=$scope.designationarray[i]['level'];
				var desig=$scope.designationarray.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		//console.log($scope.approvalbenefits)
		if($scope.designationarray.length>=1){
			//$scope.approvalbenefits.insert($scope.approvalbenefits.length,{benefit:""});	
		}
		
		
   }
   $scope.removesalary = function($id,$index)
   {
   
	$scope.designationarray=[];
		for(var i=0;i<$scope.desigarray.length;i++){
			if($scope.desigarray[i].id == $id){
				if($scope.approvalbenefits.length>1){
					var temp=$scope.approvalbenefits[$index-1].benefit;
					var level=$scope.desigarray[i]['level'];
					var desig=$scope.desigarray.length;
					for(var j=0;j<desig;j++){
						if($scope.desigarray[j].id == temp){
							for(var x=j;x<desig;x++){
								$scope.designationarray.insert(x,{id:$scope.desigarray[x].id,name:$scope.desigarray[x].name,level:$scope.desigarray[x].level});
							}
						}
					}	
				}
			}	
		}
   
	
	$scope.approvalbenefits.remove($index);
	if($scope.approvalbenefits.length ==0){
		$scope.approvalbenefits.insert(0,{benefit:""});
	}
	if($scope.approvalbenefits[0].benefit ==""){
		$scope.onchangedesig();
	}
	
   }

	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
function onfetchdesignation()
{
	$scope.hastrue=true;
	var xsrf = $.param({headtype: 2});
	$http({
        url: path+'setup/getalldesignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.designations=[];
				$scope.designations=data.data;
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.alls=true;
$scope.hier=false;
$scope.onchangedesig =function($val)
{ ////////For Show Div/////////////////
	if($scope.approvalfor==0){
		$scope.showuptolevel=1;
		$scope.showdesig=0;
	}
	else{
		$scope.showuptolevel=0;
		$scope.showdesig=1;
	}
	var func="getseniordesig";
	if($val==0){
		$scope.alls=true;
		$scope.hier=false;//document.getElementById("showapprovalsall").checked = true;
		func="getalldesignation";
	}
	if($val==1){
		$scope.alls=false;
		$scope.hier=true;//document.getElementById("showapprovalsall").checked = true;
		func="getseniordesig";
	}
	$scope.hastrue=true;
	var xsrf = $.param({designationid: $scope.approvalfor});
	$http({
        url: path+'setup/'+func,
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
				$scope.approvalbenefits=[];
				$scope.desigarray=[];
		        $scope.approvalbenefits.insert(0,{benefit:""});
		        $scope.designationarray=data.data; 
				
				for(var j=0;j<$scope.designationarray.length;j++){
					$scope.desigarray.insert(j,{id:$scope.designationarray[j].id,name:$scope.designationarray[j].name,level:$scope.designationarray[j].level});
				}	    
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetchdept =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({approvalid: $id});
	$http({
        url: path+'setup/getaapproval',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.approvaltype=data.data[0]['type'];
				$scope.approvalfor=data.data[0]['desig'];
				//$scope.approvalbenefits=data.data[0]['cirteria'];
				$scope.period=data.data[0]['period'];
				$scope.hrapp=data.data[0]['hrapproval'];
				$scope.approvalupto=data.data[0]['approvalupto'];
				////////For Show Div/////////////////
				if($scope.approvalfor==0){
					$scope.showuptolevel=1;
					$scope.showdesig=0;
				}
				else{
					$scope.showuptolevel=0;
					$scope.showdesig=1;
					$scope.onchangedesig($scope.showapprovals);
				}
				if($scope.hrapp==1){
					$('#hrapproval').prop('checked', true);
				}
				//$scope.showapprovals=data.data[0]['sts'];
				
				$timeout(function(){
				
				if(data.data[0]['cirteria'].length>0){
				var temp=data.data[0]['cirteria'];
					for(var i=0; i<temp.length; i++)
					{
						for(var j=0;j<$scope.designationarray.length;j++){
							if($scope.designationarray[j].id == temp[i]){
								$scope.approvalbenefits.insert(i,{benefit:Number($scope.designationarray[j].id),dname:$scope.designationarray[j].name});
								$scope.designationarray.remove(j);
							}
						}
					}
					$scope.designationarray=[];
					$scope.approvalbenefits.remove(temp.length);
				}
				},2000);
			}else{
				$scope.approvalbenefits.insert(0,{benefit:""});
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
	var jsondata = angular.toJson($scope.approvalbenefits);

	$scope.hastrue=true;
	var xsrf = $.param({approvaltype: $scope.approvaltype, approvalfor: $scope.approvalfor, period:$scope.period, jsondata:jsondata,hrapproval:$scope.hrapproval, approvalupto: $scope.approvalupto});
	$http({
        url: path+'setup/createapproval',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.approvalfor=0;
				$scope.period=1;
				$scope.approvalcode="";
				$scope.approvalid=0;
				
				if($val==1){					
					 $timeout(function(){window.open(path+"setup/approval", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
	$scope.hastrue=true;
	var jsondata = angular.toJson($scope.approvalbenefits);
	var xsrf = $.param({approvalid: $scope.approvalid, approvaltype: $scope.approvaltype, approvalfor: $scope.approvalfor, period:$scope.period, jsondata:jsondata,hrapproval:$scope.hrapproval, approvalupto: $scope.approvalupto});
	$http({
        url: path+'setup/updatedeapproval',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.approvalfor=0;
				$scope.period=1;
				$scope.approvalcode="";
				$scope.approvalid=0;
				if($val==1){					
					$timeout(function(){window.open(path+"setup/approval", "_self");}, timeo);  
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});

/////////////////////////// Location Controller Starts From Here  ///////////////////////////////////

app.controller('locationCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.countryarr=[];
$scope.cityarr=[];
$scope.country=0;
$scope.city=0;
$scope.locationid=0;

$scope.getId = function($id) {
	$scope.locationid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deletelocation/'+$scope.locationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.locationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetchcountry()
{ 
	$http({
        url: path+'country',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.countryarr=data;
			
			if($scope.country>0){
				onfetchcity($scope.country);
			}else{
				$scope.country=data[0]['id'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.oncountry =function()
{
	$scope.city=0;
	onfetchcity($scope.country);
}

function onfetchcity($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({countryid:$id });
	$http({
        url: path+'city',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.cityarr=data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdept =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({locationid: $id});
	$http({
        url: path+'setup/getalocation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.locname=data.data[0]['name'];
				$scope.address=data.data[0]['address'];
				$scope.landmark=data.data[0]['landmark'];
				$scope.zipcode=data.data[0]['zipcode'];
				$scope.country=data.data[0]['country'];
				$scope.city=data.data[0]['city'];
				onfetchcountry();
			}else{
				onfetchcountry();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
if($scope.locname=="")
{
	alert("Field cannot left blank");
	return false;
}
$scope.hastrue=true;
var xsrf = $.param({locname: $scope.locname, address: $scope.address, landmark: $scope.landmark, zipcode:$scope.zipcode, country: $scope.country, city: $scope.city});
  $http({
        url: path+'setup/createlocation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.locname="";
				$scope.address="";
				$scope.landmark="";
				$scope.zipcode="";
				$scope.country="";
				$scope.city="";
				$scope.locationid=0;
				
				
				if($val==1){
					//window.open(path+"setup/location", "_self");
					$timeout(function(){window.open(path+"setup/location", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({locationid: $scope.locationid, locname: $scope.locname, address: $scope.address, landmark: $scope.landmark, zipcode:$scope.zipcode, country: $scope.country, city: $scope.city});
  $http({
        url: path+'setup/updatedelocation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.locname="";
				$scope.address="";
				$scope.landmark="";
				$scope.zipcode="";
				$scope.country="";
				$scope.city="";
				$scope.locationid=0;
				
				if($val==1){
					//window.open(path+"setup/location", "_self");
					$timeout(function(){window.open(path+"setup/location", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


/////////////////////////// Role Controller Starts From Here  ///////////////////////////////////

app.controller('roleCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.roles=[];
$scope.parentrolename=0;
$scope.clonerolename=0;
$scope.roleid=0;
$scope.rol=[];
$scope.modulearr=[];
onloadtreeview();
//onfetch();

$scope.refresh = function(){
	table.fnClearTable();
}

/////////////////////////////////////////

function onloadtreeview()
{
	
	$scope.rol=[];
	$scope.hastrue=true;
var xsrf = $.param({roleid: $scope.roleid});
	$http({
        url: path+'setup/getallrole1',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.rol=data.data;
				//alert($scope.rol);
												
				var org_chart = $('#orgChart').orgChart({
				    data: $scope.rol,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					log('Clicked node '+node.data.id);
				    }

				});
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }

/*$scope.onfetchrole =function($id)
{
//return false;
$scope.modulearr=[];
	$scope.hastrue=true;
var xsrf = $.param({permissionid: $id});
	$http({
        url: path+'setup/getapermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				//$scope.clonerolename=data.data[0]['rolename'];
				$scope.modulearr=data.data;
				
			}
			//$scope.rolename=data.data[0]['rolename'];
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {f
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}*/


////////////////////////////////////////

$scope.onfetch =function()
{
	$scope.roles=[];
	$scope.hastrue=true;
var xsrf = $.param({roleid: $scope.roleid});
	$http({
        url: path+'setup/getallrole1',   //getallrole changed by getallrole1
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.roles=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdept =function($id)
{
	$scope.roles=[];
	$scope.hastrue=true;
var xsrf = $.param({roleid: $id});
	$http({
        url: path+'setup/getarole',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.rolename=data.data[0]['name'];
				$scope.parentrolename=data.data[0]['parentid'];
				$scope.desc=data.data[0]['desc'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

//return false;
$scope.hastrue=true;

var xsrf = $.param({rolename: $scope.rolename, parentid: $scope.parentrolename, cloneid: $scope.clonerolename, desc: $scope.desc});
  $http({
        url: path+'setup/createrole',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.rolename="";
				$scope.parentrolename=0;
				$scope.clonerolename=0;
				$scope.desc=0;
				$scope.roleid=0;
				
				
				if($val==1){
					//window.open(path+"setup/roles", "_self");
					$timeout(function(){window.open(path+"setup/roles", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({roleid: $scope.roleid, rolename: $scope.rolename, parentid: $scope.parentrolename, desc: $scope.desc});
  $http({
        url: path+'setup/updatederole',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.rolename="";
				$scope.parentdeptname=0;
				$scope.desc=0;
				$scope.roleid=0;
				
				if($val==1){
					//window.open(path+"setup/roles", "_self");
					$timeout(function(){window.open(path+"setup/roles", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});




/////////////////////////// Holiday Controller Starts From Here  ///////////////////////////////////

app.controller('holidayCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.holidayname='';
$scope.holidayid=0;

$scope.divisionarray=[];
$scope.division="";


$scope.getId = function($id) {
	$scope.holidayid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deleteholiday/'+$scope.holidayid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.holidayid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({holidayid: $id});
	$http({
        url: path+'setup/getaholiday',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.holidayname=data.data[0]['name'];
				$scope.fromdate=data.data[0]['datefrom'];
				$scope.todate=data.data[0]['dateto'];
				$scope.desc=data.data[0]['desc'];
				$scope.division=data.data[0]['divisions'].split(',');
				//console.log($scope.division)
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

//var jsonData = angular.toJson($scope.division);
$scope.hastrue=true;
var xsrf = $.param({holidayname: $scope.holidayname, fromdate: $scope.fromdate, todate: $scope.todate, desc: $scope.desc, division: $scope.division});
  $http({
        url: path+'setup/createholiday',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.holidayname="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.desc="";
				$scope.division="";
				$scope.holidayid=0;
				if($val==1){
					//window.open(path+"setup/holiday", "_self");
					$timeout(function(){window.open(path+"setup/holiday", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({holidayid: $scope.holidayid, holidayname: $scope.holidayname, fromdate: $scope.fromdate, todate: $scope.todate, desc: $scope.desc, division: $scope.division});
  $http({
        url: path+'setup/updatedeholiday',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.holidayname="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.desc="";
				$scope.division="";
				$scope.holidayid=0;
				
				if($val==1){
					//window.open(path+"setup/holiday", "_self");
					$timeout(function(){window.open(path+"setup/holiday", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

/////////////////////////////////

$scope.onfetchdivisions =function()
{
	$scope.divisionarray=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getalldivision',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.divisionarray=data.data;
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

/////////////////////////////////


});



/////////////////////////// Fiscal Controller Starts From Here  ///////////////////////////////////

app.controller('fiscalCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
	$scope.fiscalname="";
	$scope.startdate="";
	$scope.enddate="";
	$scope.fiscalsts=0;
	$scope.fiscalid="";
	/* setTimeout(function(){				
		$('input').iCheck({checkboxClass: 'icheckbox_square-blue', increaseArea: '20%'  });
		$('input').on('ifToggled', function(event){
			if(event.target.checked){
				$scope.fiscalsts = 1;
			}else{
				errorMessage("You cannot set a fiscal year inactive");
			}
		});
	}, 10); */
	$scope.onfetch =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid: $id});
		$http({
			url: path+'setup/getafiscal',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
		  	if(data.status){
					$scope.fiscalname=data.data[0]['name'];
					$scope.startdate=data.data[0]['startdate'];
					$scope.enddate=data.data[0]['enddate'];
					//$scope.fiscalsts=data.data[0]['fiscalsts'];
					/* if($scope.fiscalsts=="1"){
						$('#fiscalsts').iCheck('check');
					} */
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.oncreate = function($val)
	{
	$scope.hastrue=true;
	var xsrf = $.param({fiscalname: $scope.fiscalname, startdate: $scope.startdate, enddate: $scope.enddate});
	  $http({
			url: path+'setup/createfiscal',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$scope.fiscalname="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.fiscalsts=0;
					$scope.fiscalid="";
					if($val==1){
						//window.open(path+"setup/fiscal", "_self");
						$timeout(function(){window.open(path+"setup/fiscal", "_self");}, timeo);
					}					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.onupdate = function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid: $scope.fiscalid, fiscalname: $scope.fiscalname, startdate: $scope.startdate, enddate: $scope.enddate});
	  $http({
			url: path+'setup/updatedfiscal',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$scope.fiscalname="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.fiscalsts=0;
					$scope.fiscalid="";
					
					if($val==1){
						//window.open(path+"setup/fiscal", "_self");
						$timeout(function(){window.open(path+"setup/fiscal", "_self");}, timeo);
					}
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});	
	}
});


/////////////////////////// Template Controller Starts From Here  ///////////////////////////////////

app.controller('templateCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.templatename="";
$scope.templateid=0;

$scope.emparr=[];

$scope.getId = function($id) {
	$scope.templateid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deletetemplate/'+$scope.templateid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.templateid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({templateid: $id});
	$http({
        url: path+'setup/getatemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.templatename=data.data[0]['name'];
				//document.getElementById('desc').value=data.data[0]['desc'];
				$scope.desc=data.data[0]['desc'];
				document.getElementById('output').innerHTML=$scope.desc;
				//$('#some-textarea').data("wysihtml5").editor.setValue(data.data[0]['desc']);
				$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.oncreate = function($val)
{
	
	$scope.hastrue=true;
	var xsrf = $.param({templatename: $scope.templatename, desc: document.getElementById('desc').value});
	$http({
        url: path+'setup/createtemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.templatename="";
				$scope.desc="";
				$scope.templateid=0;
				
				
				if($val==1){
					//window.open(path+"setup/template", "_self");
					$timeout(function(){window.open(path+"setup/template", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({templateid: $scope.templateid, templatename: $scope.templatename, desc: document.getElementById('desc').value});
  $http({
        url: path+'setup/updatedetemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.templatename="";
				$scope.desc="";
				$scope.templateid=0;
				
				if($val==1){
					//window.open(path+"setup/template", "_self");
					$timeout(function(){window.open(path+"setup/template", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


 $scope.cursorPosVal = -1;

    $scope.getCursorPos = function($event) {
    //alert("hello");
     //var myEl = $event.target;
    //alert($event);
    $scope.doGetCaretPosition($event);  
    }
    
    $scope.doGetCaretPosition = function(oField) {

    // Initialize
    var iCaretPos = 0;
//alert(oField.selectionStart);
    // IE Support
    if (document.selection) {

      // Set focus on the element
      oField.focus ();

      // To get cursor position, get empty selection range
      var oSel = document.selection.createRange ();

      // Move selection start to 0 position
      oSel.moveStart ('character', -oField.value.length);

      // The caret position is selection length
      iCaretPos = oSel.text.length;
      //alert(iCaretPos);
    }

    // Firefox support
    else if (oField.selectionStart || oField.selectionStart == '0')
      iCaretPos = oField.selectionStart;

    // Return results
    $scope.cursorPosVal = iCaretPos;
    
   }

$scope.onchangeemp=function()
{
	alert("hello");
	if($scope.empname=='')
	{
		return false;
	}
	insertAtCursor('desc', $scope.empname);
	
}

function insertAtCursor(myField, myValue) {

    
    if (document.selection) {
    
        document.getElementById(myField).focus();
        sel = document.selection.createRange();
        sel.text = myValue;
    }
    
    else if (document.getElementById(myField).selectionStart || document.getElementById(myField).selectionStart == '0') {
    //alert(document.getElementById(myField));
        var startPos = document.getElementById(myField).selectionStart;
        var endPos = document.getElementById(myField).selectionEnd;
        //alert(startPos+", "+endPos);
        document.getElementById(myField).value = document.getElementById(myField).value.substring(0, startPos)
            + myValue
            + document.getElementById(myField).value.substring(endPos, document.getElementById(myField).value.length);
    } else {
        document.getElementById(myField).value += myValue;
    }
}


});



/////////////////////////// Asset Controller Starts From Here  ///////////////////////////////////

app.controller('assetCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.assetname="";
$scope.assetid=0;
//onfetch();

$scope.getId = function($id) {
	$scope.assetid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deleteasset/'+$scope.assetid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.assetid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({assetid: $id});
	$http({
        url: path+'setup/getaasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.assetname=data.data[0]['name'];
				$scope.desc=data.data[0]['desc'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({assetname: $scope.assetname, desc: $scope.desc});
  $http({
        url: path+'setup/createasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.assetname="";
				$scope.desc="";
				$scope.assetid=0;
				
				
				if($val==1){
					//window.open(path+"setup/asset", "_self");
					$timeout(function(){window.open(path+"setup/asset", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({assetid: $scope.assetid, assetname: $scope.assetname, desc: $scope.desc});
  $http({
        url: path+'setup/updatedeasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.assetname="";
				$scope.desc="";
				$scope.assetid=0;
				
				if($val==1){
					//window.open(path+"setup/asset", "_self");
					$timeout(function(){window.open(path+"setup/asset", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});



/////////////////////////// Category Controller Starts From Here  ///////////////////////////////////

app.controller('categoryCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.categoryname="";
$scope.categoryid=0;
$scope.typeid=2;
//onfetch();
$scope.category=[];
onfetchtype();
$scope.getId = function($id) {
	$scope.categoryid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletecategory/'+$scope.categoryid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.categoryid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


function onfetchtype()
{
	$scope.category=[];
	$scope.hastrue=true;
	
	$http({
        url: path+'setup/getalltype',
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({categoryid: $id});
	$http({
        url: path+'setup/getacategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.categoryname=data.data[0]['name'];
				$scope.desc=data.data[0]['desc'];
				$scope.typeid=data.data[0]['typeid'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/createcategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;				
				
				if($val==1){
					//window.open(path+"setup/category", "_self");
					$timeout(function(){window.open(path+"setup/category", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({categoryid: $scope.categoryid, categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/updatedecategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;
				
				if($val==1){
					//window.open(path+"setup/category", "_self");
					$timeout(function(){window.open(path+"setup/category", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


/////////////////////////// Checklist Controller Starts From Here  ///////////////////////////////////

app.controller('checklistCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.checklistname="";
$scope.checklistid=0;
$scope.catid="";
//onfetch();
$scope.category=[{id:"1", name:"New Joining"}, {id:"2", name:"Final Settlement"}, {id:"3", name:"Process Salary"}];
$scope.getId = function($id) {
	$scope.checklistid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletechecklist/'+$scope.checklistid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.checklistid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchcat =function()
{
	$scope.category=[];
	$scope.hastrue=true;
var xsrf = $.param({typeid: 1});
	$http({
        url: path+'setup/getallcategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({checklistid: $id});
	$http({
        url: path+'setup/getachecklist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.checklistname=data.data[0]['name'];
				$scope.catid=data.data[0]['catid'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{


$scope.hastrue=true;
var xsrf = $.param({checklistname: $scope.checklistname, catid: $scope.catid});
  $http({
        url: path+'setup/createchecklist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.checklistname="";
				$scope.desc="";
				$scope.checklistid=0;
				
				
				if($val==1){
					//window.open(path+"setup/checklist", "_self");
					$timeout(function(){window.open(path+"setup/checklist", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({checklistid: $scope.checklistid, checklistname: $scope.checklistname, catid: $scope.catid});
  $http({
        url: path+'setup/updatedechecklist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.checklistname="";
				$scope.catid=0;
				$scope.checklistid=0;
				
				if($val==1){
					//window.open(path+"setup/checklist", "_self");
					$timeout(function(){window.open(path+"setup/checklist", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});




/////////////////////////// Users Controller Starts From Here  ///////////////////////////////////

app.controller('userCtrl', function($scope, $http, $timeout) {


$scope.hastrue=false;
$scope.users=[];
//$scope.parentrolename=0;
$scope.userid=0;
$scope.emparr=[];
$scope.rolearr=[];
$scope.rolename=0;
$scope.employeename=0;
$scope.username='';
$scope.password='';
$scope.cpassword='';
$scope.adminsts=0;
$scope.hrsts=0;
$scope.profilename="";
$scope.usermob="";
$scope.onfetchuser =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({userid: $id});
	$http({
        url: path+'setup/getauser',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeename=data.data[0]['employeename'];
				$scope.profilename=data.data[0]['profilename'];
				$scope.username=data.data[0]['username'];
				$scope.usermob=data.data[0]['usermob'];
				$scope.password=data.data[0]['password'];
				$scope.cpassword=data.data[0]['password'];
				$scope.adminsts=data.data[0]['adminsts'];
				$scope.hrsts=data.data[0]['hrsts'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onchangeemployee =function()
{
	if($scope.employeeidmodel != undefined)
	{
		if($scope.employeeidmodel.length>1)
		{
			errorMessage("Select only one Employee");
			$scope.employeeidmodel=[];
			return;
		}	
		else
			$scope.employeename=parseInt($scope.employeeidmodel.toString());
	}
	$scope.employeeidmodel=undefined;

	for(var i=0;i<$scope.emparr.length;i++)
	{
		if($scope.emparr[i]['id'] == $scope.employeename){
			$scope.employeename = $scope.emparr[i]['id'];
			$scope.username = $scope.emparr[i]['companyemail'];
			$scope.usermob = $scope.emparr[i]['mobile_no'];
			//$scope.rolename = $scope.emparr[i]['rolename'];
		}
	}

}

$scope.onfetchemployee =function()
{

	$scope.emparr=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getempuser',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.emparr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.getId = function($id) {
	$scope.userid=$id;
	
}
$scope.getadminvalue = function($id) {
	$scope.adminvalue=$id;
	//console.log($scope.adminvalue);
	$timeout(function(){$('#confirm2').modal('show');}, 500);
	
	
}
$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deleteuser/'+$scope.userid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.fnClearTable();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangeadmin =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/adduserstatus/'+$scope.userid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.fnClearTable();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangests =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/OnChangeUserSts/'+$scope.userid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.fnClearTable();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangehrsts =function()
{
	$http({
        url: path+'setup/adduserhrstatus/'+$scope.userid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.fnClearTable();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.desigid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

/* $scope.onfetchrole =function()
{
	$scope.rolearr=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getalldesignation',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.desigarr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
 */
$scope.onfetchuserprofile =function()
{
	$scope.rolearr=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getallUserProfile',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.profilearr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
//errorMessage($scope.employeename);
if($scope.employeename==0 || angular.isUndefined($scope.employeename))
{
	errorMessage("Please select employee name.");
	$('#employeename').focus();
	return false;
}

if($scope.password!==$scope.cpassword)
{
	errorMessage("Confirm Password is not matched.");
	$('#cpassword').focus();
	return false;
}
if($scope.adminsts==1 && $scope.profilename==0){
	
	errorMessage("Please select user type name.");
	$('#adminsts').focus();
	return false;
}
$scope.hastrue=true;
var xsrf = $.param({employeeid: $scope.employeename,profilename: $scope.profilename, username: $scope.username, password: $scope.password, adminsts: $scope.adminsts, hrsts: $scope.hrsts, usermob:$scope.usermob});
  $http({
        url: path+'setup/createuser',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.username="";
				$scope.password="";
				$scope.cpassword="";
				$scope.employeename=0;
				$scope.profilename="";
				$scope.userid=0;
								
				if($val==1){
					//window.open(path+"setup/users", "_self");
					$timeout(function(){window.open(path+"setup/users", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

if($scope.employeename==0 || angular.isUndefined($scope.employeename))
{
	errorMessage("Please select employee name.");
	$('#employeename').focus();
	return false;
}
if($scope.adminsts==1 && $scope.profilename==0){
	
	errorMessage("Please select user type name.");
	$('#adminsts').focus();
	return false;
}

if($scope.password!==$scope.cpassword)
{
	errorMessage("Confirm Password is not matched.");
	$('#cpassword').focus();
	return false;
}
//return false;
$scope.hastrue=true;
var xsrf = $.param({employeeid: $scope.employeename, profilename: $scope.profilename, username: $scope.username, password: $scope.password, userid: $scope.userid, adminsts: $scope.adminsts, hrsts: $scope.hrsts, usermob:$scope.usermob});
  $http({
        url: path+'setup/updatedeuser',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.employeename=0;
					$scope.profilename="";
				$scope.username="";
				$scope.password="";
				$scope.cpassword="";
				$scope.userid=0;
				
				if($val==1){
					//window.open(path+"setup/users", "_self");
					$timeout(function(){window.open(path+"setup/users", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


});




/////////////////////////// Permission Controller Starts From Here  ///////////////////////////////////

app.controller('permissionCtrl', function($scope, $http, $timeout) {


$scope.hastrue=false;
$scope.users=[];
//$scope.parentrolename=0;
$scope.permissionid=0;
$scope.rolearr=[];
$scope.rolename=0;
$scope.modulearr=[];
$scope.modulename=0;
//onfetch();
$scope.roles="";



function onfetchpermission()
{
//return false;
	$scope.hastrue=true;
var xsrf = $.param({permissionid: $scope.permissionid});
	$http({
        url: path+'setup/getapermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				//errorMessage(data.data[1]['vsts']);
				//$scope.rolename=data.data[0]['rolename'];
				//errorMessage(data.data[0]['dsts']);
				
				$scope.roles = "for "+data.data[0]['roles'];
				
				for(var i=0; i<data.data.length; i++)
				{
					for(var j=0; j<$scope.modulearr.length; j++)
					{
						if($scope.modulearr[j]['id'] == data.data[i]['modulename'])
						{
							$scope.modulearr[j]['vsts']=(data.data[i]['vsts']==1)?true:false;
							$scope.modulearr[j]['ests']=(data.data[i]['ests']==1)?true:false;
							$scope.modulearr[j]['asts']=(data.data[i]['asts']==1)?true:false;
							$scope.modulearr[j]['dsts']=(data.data[i]['dsts']==1)?true:false;
							break;
						}
					}
				}
				//errorMessage($scope.modulearr);
				//$scope.username=data.data[0]['username'];
			}
			//$scope.rolename=data.data[0]['rolename'];
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncheckother =function($id)
{
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($id==$scope.modulearr[i]['id'])
		{
			if(!$scope.modulearr[i]['vsts']){
				$scope.modulearr[i]['ests']=false;
				$scope.modulearr[i]['asts']=false;
				$scope.modulearr[i]['dsts']=false;
			}
			break;
		}
	}
}
$scope.oncheckview =function($id)
{
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($id==$scope.modulearr[i]['id'])
		{
			if(!$scope.modulearr[i]['vsts']){
				$scope.modulearr[i]['vsts']=true;
			}			
			break;
		}
	}
}
$scope.oncheckall =function($val)
{
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($scope.tabid==$scope.modulearr[i]['tabid'])
		{
			if($val==1){
				$scope.modulearr[i]['vsts']=$scope.chkvsts;
				if(!$scope.chkvsts){
					$scope.modulearr[i]['ests']=$scope.chkvsts;
					$scope.modulearr[i]['asts']=$scope.chkvsts;
					$scope.modulearr[i]['dsts']=$scope.chkvsts;
					$scope.chkests = $scope.chkvsts;
					$scope.chkasts = $scope.chkvsts;
					$scope.chkdsts = $scope.chkvsts;
				}
			}else if($val==2){
				$scope.modulearr[i]['ests']=$scope.chkests;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}else if($val==3){
				$scope.modulearr[i]['asts']=$scope.chkasts;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}else if($val==4){
				$scope.modulearr[i]['dsts']=$scope.chkdsts;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}
		}
	}
	
}
$scope.onchangetab =function($tabid)
{
	$scope.tabid=$tabid;
}
$scope.onfetchmodule =function()
{
	$scope.modulearr=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getmodulepermission',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulearr=data.data;
				$scope.tabsarr=data.tabs;
				
				/*setTimeout(function(){
				
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', radioClass: 'iradio_square-blue',
          increaseArea: '20%'  });
					$('input').on('ifToggled', function(event){
					  $scope.modulearr[event.target.name][this.id]=event.target.checked;
					  //$scope.modulearr[event.target.name].vsts=event.target.checked;
					 //errorMessage($scope.modulearr[event.target.name].name);
					});
					
					onfetchpermission();
				}, 1000);*/
				onfetchpermission();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.getId = function($id) {
	$scope.desigid=$id;
}

$scope.onchangehrsts =function()
{
	$http({
        url: path+'setup/adddesigstatus/'+$scope.desigid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.desigid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
//errorMessage($scope.rolename);

if($scope.rolename==0 || angular.isUndefined($scope.rolename))
{
	errorMessage("Please select role name.");
	$('#rolename').focus();
	return false;
}

//return false;


$scope.hastrue=true;

var jsonData = angular.toJson($scope.modulearr);
//errorMessage(jsonData);
//return false;
var xsrf = $.param({rolename: $scope.rolename, jsonarr:jsonData});
  $http({
        url: path+'setup/createpermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.rolename=0;
				$scope.permissionid=0;
								
				if($val==1){
					//window.open(path+"setup/permission", "_self");
					$timeout(function(){window.open(path+"setup/permission", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var jsonData = angular.toJson($scope.modulearr);
//errorMessage(jsonData);
//return false;

var xsrf = $.param({permissionid: $scope.permissionid, jsonarr:jsonData});
  $http({
        url: path+'setup/updatedepermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.permissionid=0;
				
				if($val==1){
					//window.open(path+"setup/permission", "_self");
					$timeout(function(){window.open(path+"setup/permission", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


});

/////////////User Profile Controller Starts From Here  //////////

app.controller('UserprofileCtrl', function($scope, $http, $timeout) {


$scope.hastrue=false;
$scope.users=[];
//$scope.parentrolename=0;
$scope.permissionid=0;
$scope.rolearr=[];
$scope.profilename="";
$scope.profileId=0;
$scope.modulearr=[];
$scope.modulename=0;
//onfetch();
$scope.roles="";



function onfetchpermission()
{
//return false;
	$scope.hastrue=true;
var xsrf = $.param({permissionid: $scope.permissionid});
	$http({
        url: path+'setup/getaUserProfilepermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				//errorMessage(data.data[1]['vsts']);
				//$scope.rolename=data.data[0]['rolename'];
				//errorMessage(data.data[0]['dsts']);
				
				$scope.profilename =data.data[0]['profilename'];
				
				for(var i=0; i<data.data.length; i++)
				{
					for(var j=0; j<$scope.modulearr.length; j++)
					{
						if($scope.modulearr[j]['id'] == data.data[i]['modulename'])
						{
							$scope.modulearr[j]['vsts']=(data.data[i]['vsts']==1)?true:false;
							$scope.modulearr[j]['ests']=(data.data[i]['ests']==1)?true:false;
							$scope.modulearr[j]['asts']=(data.data[i]['asts']==1)?true:false;
							$scope.modulearr[j]['dsts']=(data.data[i]['dsts']==1)?true:false;
							break;
						}
					}
				}
				//errorMessage($scope.modulearr);
				//$scope.username=data.data[0]['username'];
			}
			//$scope.rolename=data.data[0]['rolename'];
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncheckother =function($id)
{
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($id==$scope.modulearr[i]['id'])
		{
			if(!$scope.modulearr[i]['vsts']){
				$scope.modulearr[i]['ests']=false;
				$scope.modulearr[i]['asts']=false;
				$scope.modulearr[i]['dsts']=false;
			}
			break;
		}
	}
}
$scope.oncheckview =function($id)
{
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($id==$scope.modulearr[i]['id'])
		{
			if(!$scope.modulearr[i]['vsts']){
				$scope.modulearr[i]['vsts']=true;
			}			
			break;
		}
	}
}
$scope.oncheckall =function($val)
{
	console.log($val);
	var len = $scope.modulearr.length;
	for(var i=0; i<len; i++)
	{
		if($scope.tabid==$scope.modulearr[i]['tabid'])
		{
			if($val==1){
				$scope.modulearr[i]['vsts']=$scope.chkvsts;
				if(!$scope.chkvsts){
					$scope.modulearr[i]['ests']=$scope.chkvsts;
					$scope.modulearr[i]['asts']=$scope.chkvsts;
					$scope.modulearr[i]['dsts']=$scope.chkvsts;
					$scope.chkests = $scope.chkvsts;
					$scope.chkasts = $scope.chkvsts;
					$scope.chkdsts = $scope.chkvsts;
				}
			}else if($val==2){
				$scope.modulearr[i]['ests']=$scope.chkests;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}else if($val==3){
				$scope.modulearr[i]['asts']=$scope.chkasts;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}else if($val==4){
				$scope.modulearr[i]['dsts']=$scope.chkdsts;
				if(!$scope.modulearr[i]['vsts']){
					$scope.modulearr[i]['vsts']=true;
				}
			}
		}
	}
	
}
$scope.onchangetab =function($tabid)
{
	$scope.tabid=$tabid;
	$scope.chkvsts=false;
	$scope.chkests=false;
	$scope.chkasts=false;
	$scope.chkdsts=false;
}
$scope.onfetchmodule =function()
{
	$scope.modulearr=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getmodulepermission',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulearr=data.data;
				$scope.tabsarr=data.tabs;
				
				/*setTimeout(function(){
				
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', radioClass: 'iradio_square-blue',
          increaseArea: '20%'  });
					$('input').on('ifToggled', function(event){
					  $scope.modulearr[event.target.name][this.id]=event.target.checked;
					  //$scope.modulearr[event.target.name].vsts=event.target.checked;
					 //errorMessage($scope.modulearr[event.target.name].name);
					});
					
					onfetchpermission();
				}, 1000);*/
				onfetchpermission();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.getId = function($id) {
	$scope.desigid=$id;
}

$scope.onchangehrsts =function()
{
	$http({
        url: path+'setup/adddesigstatus/'+$scope.desigid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.desigid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val) {
	$scope.hastrue=true;
	var jsonData = angular.toJson($scope.modulearr);
	var xsrf = $.param({profilename: $scope.profilename, jsonarr:jsonData});
	$http({
        url: path+'setup/createUserProfile',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
    }).success(function (data, status, headers, config) {
		if(data.status){
			successMessage(data.successMsg);
			$scope.rolename=0;
			$scope.permissionid=0;
			if($val==1){
				//window.open(path+"setup/permission", "_self");
				$timeout(function(){window.open(path+"setup/UserProfile", "_self");}, timeo);
			}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val) {
	$scope.hastrue=true;
	var jsonData = angular.toJson($scope.modulearr);
	var xsrf = $.param({permissionid: $scope.permissionid,profilename: $scope.profilename, jsonarr:jsonData});
	$http({
        url: path+'setup/updatedeUserProfilepermission',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
    }).success(function (data, status, headers, config) {
		if(data.status){
			successMessage(data.successMsg);
			$scope.permissionid=0;
			if($val==1){
				//window.open(path+"setup/permission", "_self");
				$timeout(function(){window.open(path+"setup/UserProfile", "_self");}, timeo);
			}
		}else{
			errorMessage(data.errorMsg);
		}
		$scope.hastrue=false;
    }).error(function (data, status, headers, config) {
        //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		$scope.hastrue=false;
	});
}


});

/////////////////////////// Settings Controller Starts From Here  ///////////////////////////////////

app.controller('settingsCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.approvalid=0;
$scope.pagetype=0;
$scope.settings=[];
$scope.expressiontype=[{id:0, name:"Hour(s)"},{id:1, name:"Day(s)"},{id:2, name:"Month(s)"},{id:3, name:"Year(s)"}];
onfetchEmpType();
/* $scope.notifyarr=[{id:0, name:"Person performing this action", notifyto: false},{id:1, name:"Supervisor", notifyto: false},{id:2, name:"HR/Admin", notifyto: false},{id:3, name:"Team Members", notifyto: false}]; */
$scope.onfetchsettings = function($val)
{
	$scope.pagetype=$val;
	onfetchsetting();
}
$scope.onchangetab =function($tabid)
{
	$scope.tabid=$tabid;
	$scope.settingdiv=false;
}
$scope.showtype =function()
{
	console.log($scope.type);
}
/* function onfetchsetting1()
{
	$scope.hastrue=true;
	var xsrf = $.param({type: $scope.pagetype});
	$http({
        url: path+'setup/getasettings',
        method: "POST",data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.settings=[];
				$scope.settings=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
} */

function onfetchsetting()
{
	$scope.modulearr=[];
	$scope.hastrue=true;
	var xsrf = $.param({type: $scope.pagetype});
	$http({
        url: path+'setup/getasettings',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulearr=data.data;
				$scope.tabsarr=data.tabs;
				$scope.empcount=data.empcount;
				
				/*setTimeout(function(){
				
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', radioClass: 'iradio_square-blue',increaseArea: '20%'  });
					$('input').on('ifToggled', function(event){
					  $scope.modulearr[event.target.name][this.id]=event.target.checked;
					  //$scope.modulearr[event.target.name].vsts=event.target.checked;
					 //errorMessage($scope.modulearr[event.target.name].name);
					});
					onfetchpermission();
				}, 1000);*/
				//onfetchpermission();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetchnoticesetting =function($val)
{
	//$scope.modulearr=[];
	$scope.hastrue=true;
	$scope.pagetype=$val;
	var xsrf = $.param({type: $scope.pagetype});
	$http({
        url: path+'setup/getasettingsofnotice',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.settings=data.data;
			//	$scope.tabsarr=data.tabs;
				
				/*setTimeout(function(){
				
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', radioClass: 'iradio_square-blue',increaseArea: '20%'  });
					$('input').on('ifToggled', function(event){
					  $scope.modulearr[event.target.name][this.id]=event.target.checked;
					  //$scope.modulearr[event.target.name].vsts=event.target.checked;
					 //errorMessage($scope.modulearr[event.target.name].name);
					});
					onfetchpermission();
				}, 1000);*/
				//onfetchpermission();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchEmpType()
{
	$scope.hastrue=true;
	$http({
        url: path+'employee/getallemptype',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.emptypearr=data.data;
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
var jsonData = angular.toJson($scope.settings);
$scope.hastrue=true;
var xsrf = $.param({settings_array: jsonData});
  $http({
        url: path+'setup/updatesettings',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				onfetchsetting();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.settingdiv=false;
$scope.showdiv=function($id,$val){ 
	if($val==1)
	$scope.settingdiv=true;
	else
	$scope.settingdiv=false;
	var i=0;
	if($val==1){
	   for(i=0;i<$scope.modulearr.length;i++){
			if($scope.modulearr[i].id!=$id){
				$scope.modulearr[i].mail=0;
			}else{
				$scope.headtitle=$scope.modulearr[i].label;
			}
		}  
	}
	var xsrf = $.param({setid: $id});
	$http({
        url: path+'setup/getEventDetail',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.id=data.data[0]['id'];
				$scope.setid=data.data[0]['setid'];
				$scope.title=data.data[0]['title'];
				$scope.descemp=data.data[0]['descemp'];
				$('#descemp').data("wysihtml5").editor.setValue($scope.descemp);
				$scope.descother=data.data[0]['descother'];
				$('#descother').data("wysihtml5").editor.setValue($scope.descother);
				$scope.leaddays=parseInt(data.data[0]['leaddays']);
				$scope.sendmail=data.data[0]['sendmail'];
				$scope.genalert=data.data[0]['alert'];
				$scope.notifyall=data.data[0]['notifyall'];
				$scope.notifyself=data.data[0]['notifyself'];
				$scope.notifysupervisor=data.data[0]['notifysupervisor'];
				$scope.notifyhradmin=data.data[0]['notifyhradmin'];
				$scope.notifyteam=data.data[0]['notifyteam'];
				$scope.notifyjsteam=data.data[0]['notifyjsteam'];
				$scope.employeetype=data.data[0]['employeetype'];
			}
			else{
				$scope.id=0;
				$scope.setid=$id;
				$scope.title='';
				$scope.descemp='';
				$('#descemp').data("wysihtml5").editor.setValue($scope.descemp);
				$scope.descother='';
				$('#descother').data("wysihtml5").editor.setValue($scope.descother);
				$scope.leaddays=0;
				$scope.sendmail=false;
				$scope.genalert=false;
				$scope.notifyall=false;
				$scope.notifyself=false;
				$scope.notifysupervisor=false;
				$scope.notifyhradmin=false;
				$scope.notifyteam=false;
				$scope.notifyjsteam=false;
				$scope.employeetype="";
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		}); 
}
$scope.enableSettings=function($id,$val){
	var xsrf = $.param({setid: $id, setting: $val});
	$http({
        url: path+'setup/enableSettings',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		}); 
}

$scope.oncreateupdate = function($val)
{
//var jsonData = angular.toJson($scope.settings);
$scope.hastrue=true;
var xsrf = $.param({title: $scope.title,descemp:document.getElementById('descemp').value,descother:document.getElementById('descother').value,leaddays:$scope.leaddays,sendmail:$scope.sendmail,genalert:$scope.genalert,notifyall:$scope.notifyall,notifyself:$scope.notifyself,notifysupervisor:$scope.notifysupervisor,notifyhradmin:$scope.notifyhradmin,notifyteam:$scope.notifyteam,notifyjsteam:$scope.notifyjsteam,employeetype:$scope.employeetype,setid:$scope.setid,id:$scope.id});
  $http({
        url: path+'setup/createupdatesettings',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				//onfetchsetting();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});

/////////////////////////// Dashboard Controller Starts From Here  ///////////////////////////////////

app.controller('dashboardCtrl', function($scope, $http) {
$scope.hastrue=true;
$scope.dashboard1=[];
$scope.dashboard2=[];
$scope.updateDB  =function($orgid)
{ 
    $scope.orgid = $orgid;
		//alert(path+'backup_db.php');
	var xsrf = $.param({orgid: $scope.orgid});
	$http({
        url: path+'backup_db.php',
        method: "POST",
        data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
      	//	alert("dedee");
			
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
        	alert(data);
            
			$scope.hastrue=false;
		});
}	

$scope.onfetchdash1 =function()
{
	$scope.dashboard1=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getDashboardData1',
        method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dashboard1=data.data;
				var donut = new Morris.Donut({
				  element: 'sales-chart',
				  resize: true,
				  colors: ["#3399FF", "#FF0000", "#009933", "#CC66FF", "#f39c12", "#00CCFF"],
				  data: $scope.dashboard1,
				  hideHover: 'auto'
				});
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
/*
$scope.onfetchdash2 =function()
{
	$scope.dashboard2=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getDashboardData2',
        method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dashboard2=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}*/

onfetch('setup/getDashboardData3',1);
//onfetch('employee/getnewjoiningdashboard',2);

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				
					
					///// DIVISION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart1',
					  resize: true, //ymax:100, postUnits:'%',
					  axes:true, 
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empindivision'],
					  barColors: ['#3399FF', '#009933', '#FF0000'],
					  xkey: 'type',
					  //gridTextSize: 5,
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					///// DEPARTMENT BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, //ymax:100, postUnits:'%',
					  axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empindepartment'],
					  barColors: ['#FF0000', '#009933', '#FF0000'],
					  xkey: 'type',
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					///// DESIGNATION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true, //ymax:100, postUnits:'%',
					   axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empindesignation'],
					  barColors: ['#009933', '#3399FF', '#FF0000'],
					  xkey: 'type',
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					///// GRADE BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart4',
					  resize: true, //ymax:100, postUnits:'%',
					  axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empingrade'],
					  barColors: ['#CC66FF'],
					  xkey: 'type',
					   ykeys: ['count'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					///// SHIFT BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart5',
					  resize: true, //ymax:100, postUnits:'%',
					   axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empinshift'],
					  barColors: ['#f39c12'],
					  xkey: 'type',
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					
					///// NATIONALITY BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart6',
					  resize: true, ymax:100, postUnits:'%',
					  axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empinnationality'],
					  barColors: ['#99cc00'],
					  xkey: 'type',
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					
					///// AGE GROUP BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart7',
					  resize: true, ymax:100, postUnits:'%',
					  axes:true,
					  xLabels: 'name',
					  xLabelAngle: -90,
					  data: data.data['empinage'],
					  barColors: ['#ff66b3'],
					  xkey: 'name',
					   ykeys: ['value'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
					
					///// GENDER BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true, ymax:100, postUnits:'%',
					  axes:true,
					  xLabels: 'type',
					  xLabelAngle: -90,
					  data: data.data['empingender'],
					  barColors: ['#00ffff'],
					  xkey: 'type',
					   ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employees'],
					  hideHover: 'auto'
					});
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}


});

/////////////////////////// COSTCENTRE Controller Starts From Here  ///////////////////////////////////

app.controller('costcentreCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.departments=[];
$scope.parentdeptname=0;
$scope.dep=[];
$scope.costcentreid=0;

var org_chart ;
/////////////////////////////
$scope.getId = function($id) {
	$scope.costcentreid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletecostcentre/'+$scope.costcentreid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.costcentreid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onloadtreeview()
{
	//alert("onloadtreeview");
	$scope.dep=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getallcostcentre',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dep=data.data;
				
				org_chart = $('#orgChart').orgChart({
				    data: $scope.dep,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					log('Clicked node '+node.data.id);
				    }

				});
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////
    
    function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }
    
   
    
    
/////////////////////////////////////////////
    
$scope.onfetch =function()
{
	$scope.costcentres=[];
	$scope.hastrue=true;

	$http({
        url: path+'setup/getallcostcentre',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.costcentres=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchcostcentre =function($id)
{
	$scope.costcentres=[];
	$scope.hastrue=true;
var xsrf = $.param({costcentreid: $id});
	$http({
        url: path+'setup/getacostcentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.costcentrename=data.data[0]['name'];
				$scope.costcentrecode=data.data[0]['code'];
				$scope.parentcostcentrename=data.data[0]['parentid'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({costcentrename: $scope.costcentrename, parentcostcentrename: $scope.parentcostcentrename, costcentrecode:$scope.costcentrecode});
  $http({
        url: path+'setup/createcostcentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.costcentrename="";
				$scope.parentcostcentrename=0;
				$scope.costcentreid=0;
				$scope.costcentrecode="";
				
				if($val==1){
					//window.open(path+"setup/costcentre", "_self");
					$timeout(function(){window.open(path+"setup/costcentre", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({costcentreid: $scope.costcentreid, costcentrename: $scope.costcentrename, parentcostcentrename: $scope.parentcostcentrename, costcentrecode:$scope.costcentrecode});
  $http({
        url: path+'setup/updatecostcentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.costcentrename="";
				$scope.parentcostcentrename=0;
				$scope.costcentreid=0;
				$scope.costcentrecode="";
				if($val==1){
					//window.open(path+"setup/costcentre", "_self");
					$timeout(function(){window.open(path+"setup/costcentre", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});
/////////////////////////// Cost Centre Controller Starts From Here  ///////////////////////////////////

app.controller('cocentreCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.departments=[];
$scope.parentdeptname=0;
$scope.dep=[];
$scope.costcentreid=0;
//onloadtreeview();

//var org_chart ;
/////////////////////////////
$scope.getId = function($id) {
	$scope.costcentreid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'setup/deletecocentre/'+$scope.costcentreid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.deptid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onloadtreeview()
{
	//alert("onloadtreeview");
	$scope.dep=[];
	$scope.hastrue=true;
	$http({
        url: path+'setup/getalldepartment',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.dep=data.data;
				
				org_chart = $('#orgChart').orgChart({
				    data: $scope.dep,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					log('Clicked node '+node.data.id);
				    }

				});
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////
    
    function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }
    
   
    
    
/////////////////////////////////////////////
    
$scope.onfetch =function()
{
	$scope.costcentres=[];
	$scope.hastrue=true;

	$http({
        url: path+'setup/getallcocentre',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.departments=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchcocentre =function($id)
{
	$scope.departments=[];
	$scope.hastrue=true;
var xsrf = $.param({costcentreid: $id});
	$http({
        url: path+'setup/getacocentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.ccname=data.data[0]['name'];
				$scope.cccode=data.data[0]['code'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({ccname: $scope.ccname, cccode:$scope.cccode});
  $http({
        url: path+'setup/createcocentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.ccname="";
				$scope.costcentreid=0;
				$scope.cccode="";
				
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/cocentre", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({costcentreid: $scope.costcentreid, ccname: $scope.ccname, cccode:$scope.cccode});
  $http({
        url: path+'setup/updatecocentre',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.ccname="";
				$scope.costcentreid=0;
				$scope.cccode="";
				if($val==1){
					//window.open(path+"setup/department", "_self");
					$timeout(function(){window.open(path+"setup/cocentre", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});



