/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('timesheetapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////////////////// Topbar Controller Starts From Here  ///////////////////////////////////
/* app.controller('projectCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.leavereason="";
	$scope.leavestatus="";
	$scope.leavevalidsts="";
	$scope.applydate="";
	$scope.approvercomment="";
	$scope.resumptiondate="";
    $scope.approvedby=0; 
    $scope.leavetypeid=0;
	//$scope.leavevalidsts=[];
    onfetch('leave/getallleaveemployee',4);
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					if($id==4){
						$scope.employeearray=[];
						$scope.employeearray=data.data;
					}
					
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

	
	$scope.getId = function($id) {
		$scope.projectid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'timesheet/deleteproject/'+$scope.projectid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
 $scope.juniourarr=[];  
	$scope.onfetchjuniours =function($id)
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'employee/getemployeehierarchy',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                
				$scope.juniourarr=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.fillassignto = function($id) {
		alert($id);
		$scope.assigntoarr=new Array();
		//console.log($id);
		var arr=$id;
		for(var j=0;j<arr.length;j++)
		{
			for(var i=0;i<$scope.juniourarr.length;i++)
			{
				if(arr[j]==$scope.juniourarr[i]['id'])
					$scope.assigntoarr.insert(j,{id:$scope.juniourarr[i]['id'],name:$scope.juniourarr[i]['name']});
			}
			
		}
		console.log($scope.assigntoarr);
		
	}
	
  $scope.onfetchproject =function()
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({projectid: $scope.projectid});
		$http({
			url: path+'timesheet/getaproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.leavereason=data.data[0]['leavereason'];
				$scope.leavestatus=data.data[0]['leavestatus'];
				$scope.leavevalidsts=data.data[0]['leavevalidsts'];
				$scope.leavedays=data.data[0]['leavevalidsts'];
				$scope.applydate=data.data[0]['applydate'];
				$scope.approvercomment=data.data[0]['approvercomment'];
				$scope.resumptiondate=data.data[0]['resumptiondate'];
               	$scope.approvedby = data.data[0]['approvedby'];
				$scope.approvercomment = data.data[0]['approvercomment'];
				$scope.contactdetail = data.data[0]['emergencycontact'];
				$scope.leavetype = data.data[0]['leavetypeid'];
				$scope.fromdaytype=data.data[0]['fromdaytype'];
				$scope.todaytype=data.data[0]['todaytype'];
				$scope.timeoffrom=data.data[0]['timeoffrom'];
				$scope.timeofto=data.data[0]['timeofto'];
				$scope.leaveat=data.data[0]['leaveattachment'];
				var temp = data.data[0]['leavebreakdown'];
				if(temp != "")
				{
					temp=temp.split(',');
					
					$scope.entitled=Number(temp[0]);
					$scope.carryforward=Number(temp[1]);
					$scope.advance=Number(temp[2]);
					$scope.unpaid=Number(temp[3]);
					
				}
				gettimediff();
				$scope.onfetchleavetype();
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{ 
	
		
		
		$scope.hastrue=true;
		var xsrf = $.param({ ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title, assignempid:$scope.assignempid });
		$http({
			url: path+'timesheet/createproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                            
				successMessage(data.successMsg);
				
		        
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onupdate = function($val)
	{ 
	
		i$scope.hastrue=true;
		var xsrf = $.param({project_id:$scope.projectid, ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title, assignempid:$scope.assignempid });
		$http({
			url: path+'timesheet/updateproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                            
				successMessage(data.successMsg);
				
		        
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
}); */

/////////////////////////// Project Controller Starts From Here  ///////////////////////////////////
app.controller('projectCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.ownerid=0;
	$scope.projectid=0;
	$scope.projecttypeid=0;
	$scope.title="";
	$scope.desc="";
	$scope.projectstatus="";
	$scope.fromdate="";
	$scope.todate="";
	$scope.company="";
	$scope.locationname="";
	$scope.milestoneids="";
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	$scope.leftdisableMilestone=true;
	$scope.rightdisableMilestone=true;
	//$scope.leavevalidsts=[];
	//onfetch('milestone/getalldefaultmilestone',6);
	onfetch('leave/getallleaveemployee',4);
    onfetch('profile/getallproject',1);
    onfetch('profile/getalltask',2);
	onfetch('other',5);
	onfetch('timesheet/getallprojecttype',7);
	onfetch('client/getallclients',8);
	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==1){
					$scope.projectarray=[];
					$scope.projectarray=data.data;
				}else if($id==2){
					$scope.taskarray=[];
					$scope.taskarray=data.data;
				}else if($id==4){
					$scope.employeearray=[];
					$scope.employeearray=data.data;
				}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						$scope.projectstatus=$scope.otherarray[0]['id'];
				}
				else if($id==7){
						$scope.projecttypearray=[];
						$scope.projecttypearray=data.data;
				}else if($id==8){
						$scope.clientarray=[];
						$scope.clientarray=data.data;
				}
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchmilestones=function($projecttypeid){
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getalldefaultmilestone/"+$projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.milestonearray=[];
				$scope.milestonearray=data.data;
				$scope.selectedcolumnsarrMilestone=new Array();	
				/* console.log($scope.selectedcolumnsarr);
				console.log($scope.milestonearray); */
				//$scope.selectedcolumnsarrMilestone=new Array();	
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.timesheetarray=[{id:0,priority:1, taskid:"", assignto:"", sdate:"", edate:"",totaltime:""}];
	$scope.addtask = function($i){
		var len = $scope.timesheetarray.length-1;
		if($scope.timesheetarray[len]['taskid']=="" || $scope.timesheetarray[len]['assignto']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.timesheetarray.insert($i,{id:0,priority:($i+1),taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	$scope.removetask = function($i){
		$scope.timesheetarray.remove($i);	
		if($scope.timesheetarray.length==0){
			$scope.timesheetarray.insert($i,{id:0,priority:1,taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	

	/* $scope.fillassignto = function($id) {
		//alert($id);
		$scope.assigntoarr=new Array();
		//console.log($id);
		var arr=$id;
		for(var j=0;j<arr.length;j++){
			for(var i=0;i<$scope.juniourarr.length;i++){
				if(arr[j]==$scope.juniourarr[i]['id'])
				$scope.assigntoarr.insert(j,{id:$scope.juniourarr[i]['id'],name:$scope.juniourarr[i]['name']});
			}
		}
		//console.log($scope.assigntoarr);
	} */
	$scope.getId = function($id) {
		$scope.projectid=$id;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'timesheet/deleteproject/'+$scope.projectid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	$scope.juniourarr=[]; 
	$scope.selectedcolumnsarr = [];		
	$scope.selectedcolumnsarrMilestone = [];	
	$scope.onfetchjuniours =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'employee/getEmployeeListbyreport',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.juniourarr=data.data;
				$scope.selectedcolumnsarr=new Array();	
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

		///////////Check employee  available selected box //////////
	$scope.toggleSelection = function($x) {
		
	  if($scope.juniourarr[$x].vsts){
		$scope.juniourarr[$x].vsts=false;
	  }else{
		$scope.juniourarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.juniourarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.juniourarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
   
   ///////////Check employee  selected box //////////
   $scope.toggleSelection1 = function($x) {
	
	  if($scope.selectedcolumnsarr[$x].vsts){		
		$scope.selectedcolumnsarr[$x].vsts=false;
	  }else{
		$scope.selectedcolumnsarr[$x].vsts=true;
	  }
	  $scope.rightdisable=true;
	  var len = $scope.selectedcolumnsarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedcolumnsarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
   };
	///////////end check checkbox ////////////   
   //////////left right move function//////////////
	$scope.onAddSelection = function()
	{
		$scope.checkleft = false;
		$scope.leftdisable=true;
		$scope.rightdisable=true;
		for (var i=0; i<$scope.juniourarr.length; i++) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr[i].vsts=false;
					$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
					$scope.juniourarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.juniourarr.length-1; i>=0; i--) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr.remove(i);
				
				}
		}
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			$scope.selectedcolumnsarr[i].vsts=false;
		 }
	}
	$scope.SelectionAll = function()
	{
		for (var i=0; i<$scope.juniourarr.length; i++) {
			//console.log($scope.juniourarr[i].vsts);
			if($scope.checkleft==false){ 
					$scope.juniourarr[i].vsts=false;
                       
				}else{
					$scope.juniourarr[i].vsts=true;
					$scope.juniourarr[i];
					}
			  }
			  $scope.leftdisable=true;
			  var len = $scope.juniourarr.length;
			  for(var i=0; i<len; i++)
			  {
				if($scope.juniourarr[i].vsts){		
					$scope.leftdisable=false;
					break;
				  }
			  }
		
	}
	$scope.SelectionRightAll = function()
	{
	console.log($scope.selectedcolumnsarr);
		for (var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			//console.log($scope.juniourarr[i].vsts);
				if($scope.checkright==false){ 
					$scope.selectedcolumnsarr[i].vsts=false;
                       
				}else{
					$scope.selectedcolumnsarr[i].vsts=true;
					$scope.selectedcolumnsarr[i];
					}
			  }
			  $scope.rightdisable=true;
			  var len = $scope.selectedcolumnsarr.length;
			  for(var i=0; i<len; i++)
			  {
				if($scope.selectedcolumnsarr[i].vsts){		
					$scope.rightdisable=false;
					break;
				  }
			  }
		
	}
	$scope.onRemoveSelection = function()
	{
		$scope.checkright = false;
		$scope.leftdisable = true;
		$scope.rightdisable = true;
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr[i].vsts=false;
					$scope.juniourarr.insert($scope.juniourarr.length,$scope.selectedcolumnsarr[i]);
					$scope.selectedcolumnsarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.selectedcolumnsarr.length-1; i>=0; i--) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.juniourarr.length; i++) {
				$scope.juniourarr[i].vsts=false;
		}
			
	}
	
	///////////end left right move function/////////////
	
	/* 
		sending milestones from left to right  array
	*/
	///////////Check employee  available selected box //////////
	$scope.toggleSelectionMilestone = function($x) {
	  if($scope.milestonearray[$x].vsts){
		$scope.milestonearray[$x].vsts=false;
	  }else{
		$scope.milestonearray[$x].vsts=true;
	  }
	  $scope.leftdisableMilestone=true;
	  var len = $scope.milestonearray.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.milestonearray[i].vsts){		
			$scope.leftdisableMilestone=false;
			break;
		  }
	  }
   };
   ///////////Check employee  selected box //////////
   $scope.toggleSelection1Milestone = function($x) {
	
	  if($scope.selectedcolumnsarrMilestone[$x].vsts){		
		$scope.selectedcolumnsarrMilestone[$x].vsts=false;
	  }else{
		$scope.selectedcolumnsarrMilestone[$x].vsts=true;
	  }
	  $scope.rightdisableMilestone=true;
	  var len = $scope.selectedcolumnsarrMilestone.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedcolumnsarrMilestone[i].vsts){		
			$scope.rightdisableMilestone=false;
			break;
		  }
	  }
   };
	///////////end check checkbox ////////////   
   //////////left right move function//////////////
	$scope.onAddSelectionMilestone = function()
	{		
		$scope.leftdisableMilestone=true;
		$scope.rightdisableMilestone=true;
		for (var i=0; i<$scope.milestonearray.length; i++) {
				if ($scope.milestonearray[i].vsts){ 
					$scope.milestonearray[i].vsts=false;
					$scope.selectedcolumnsarrMilestone.insert($scope.selectedcolumnsarrMilestone.length,$scope.milestonearray[i]);
					$scope.milestonearray[i].vsts=true;
					}
			  }
		for ( var i=$scope.milestonearray.length-1; i>=0; i--) {
				if ($scope.milestonearray[i].vsts){ 
					$scope.milestonearray.remove(i);
				}
		}
		for ( var i=0; i<$scope.selectedcolumnsarrMilestone.length; i++) {
			$scope.selectedcolumnsarrMilestone[i].vsts=false;
		 }
	};
	
	$scope.onRemoveSelectionMilestone = function()
	{
		$scope.leftdisableMilestone=true;
		$scope.rightdisableMilestone=true;
		for ( var i=0; i<$scope.selectedcolumnsarrMilestone.length; i++) {
				if ($scope.selectedcolumnsarrMilestone[i].vsts){ 
					$scope.selectedcolumnsarrMilestone[i].vsts=false;
					$scope.milestonearray.insert($scope.milestonearray.length,$scope.selectedcolumnsarrMilestone[i]);
					$scope.selectedcolumnsarrMilestone[i].vsts=true;
					}
			  }
		for ( var i=$scope.selectedcolumnsarrMilestone.length-1; i>=0; i--) {
				if ($scope.selectedcolumnsarrMilestone[i].vsts){ 
					$scope.selectedcolumnsarrMilestone.remove(i);
				}
		}
		for ( var i=0; i<$scope.milestonearray.length; i++) {
				$scope.milestonearray[i].vsts=false;
		}
	};
	
	///////////end left right move function/////////////
	/* 
		Ending milestones from left to right array
	*/
	
	
	
	$scope.timediff = function($leaveto){
		//alert($leaveto);
		//$scope.resumptiondate="";
		var fromdate=$("#"+$leaveto+"actstart").datetimepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#'+$leaveto+'actend').datetimepicker("remove");
		$('#'+$leaveto+'actend').datetimepicker({
			startDate: fromdate
			
		});
	}
	$scope.timediffest = function($leaveto){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
		
		
	}
	$scope.onfetchprojectDetail =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'timesheet/getprojectdetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.timesheetarray=[{id:0,priority:1, taskid:"", assignto:"", sdate:"", edate:"",totaltime:""}];
				if(data.data[0]['jobchild'].length>0){
				$scope.timesheetarray=data.data[0]['jobchild'];
				}
				
				$scope.title=data.data[0]['project_title'];
				$scope.fromdate=data.data[0]['start_date'];
				$scope.todate=data.data[0]['completed_date'];
				$scope.ownerid=data.data[0]['owner_id'];
				$scope.projectstatus=data.data[0]['project_status'];
				$scope.onfetchjuniours($scope.ownerid);
				$scope.desc=data.data[0]['project_desc'];
				$scope.company=data.data[0]['company'];
				$scope.locationname=data.data[0]['locationname'];
				$scope.projectdocs=data.data[0]['ProjectDoc'];
				$scope.file=data.data[0]['ProjectDoc'];
				$scope.projecttypeid=data.data[0]['projecttypeid'];
				
				$scope.onfetchmilestones($scope.projecttypeid);
				 
				$scope.assignempid=data.data[0]['assigned_to'];
				var temparr= data.data[0]['assigned_to'];
				$timeout(function(){
					for ( var x=0; x<temparr.length; x++){
						for ( var i=0; i<$scope.juniourarr.length; i++){
							if ($scope.juniourarr[i].id == temparr[x]){ 
								$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.juniourarr.remove(i);
							}
						}
					}
					//$scope.fillassignto($scope.assignempid);
				}, 5000);  
				
				var temparr1= data.data[0]['milestones'];
				$timeout(function(){
					for ( var x=0; x<temparr1.length; x++){
						for ( var i=0; i<$scope.milestonearray.length; i++){
							if ($scope.milestonearray[i].id == temparr1[x]){ 
								$scope.selectedcolumnsarrMilestone.insert($scope.selectedcolumnsarrMilestone.length,$scope.milestonearray[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.milestonearray.remove(i);
							}
						}
					}
					console.log($scope.milestonearray);
					//$scope.fillassignto($scope.assignempid);
				}, 5000);
				
				/* $timeout(function(){
				
				//console.log($scope.selectedcolumnsarr);
				}, 5000);   */
               // $scope.juniourarr=data.data;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val){
		
		var json = angular.toJson($scope.timesheetarray);
		var milestoneidsjson=angular.toJson($scope.selectedcolumnsarrMilestone);
		$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
		$scope.hastrue=true;
		var xsrf = $.param({ ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title,projectstatus : $scope.projectstatus, assignempid:$scope.selectedcol ,timesheet:json, company: $scope.company, locationname: $scope.locationname,milestoneids:milestoneidsjson, projecttypeid : $scope.projecttypeid});
		$http({
			url: path+'timesheet/createproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            successMessage(data.successMsg);
			   if($scope.files != ""){
					$scope.projectid=data.data[0]['projectid'];
					$scope.uploadFile($val);
				
				}	
			   $scope.ownerid=0;
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.desc="";
			   $scope.title="";
			   $scope.locationname="";
			   $scope.projectstatus=0;
			   $scope.company="";
			   $scope.selectedcolumnsarr=[];
				$scope.juniourarr=[];
				
				 if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				} 				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

	 $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
	  $scope.uploadFile = function($val) {
	var emp=$scope.projectid;
//alert(emp);
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"timesheet/uploadprojectdocs",
            
            headers: { 'Content-Type': undefined },
            
            transformRequest: function (data) {
                var formData = new FormData();
                
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('projectid', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
			if(data.status){
				
				if($val){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
					}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
		}).
        error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	
	$scope.onupdate = function($val)
	{ 
		$scope.hastrue=true;
		var json = angular.toJson($scope.timesheetarray);
		$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
		var milestoneidsjson=angular.toJson($scope.selectedcolumnsarrMilestone);
		var xsrf = $.param({project_id:$scope.projectid,  ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title, projectstatus : $scope.projectstatus, assignempid:$scope.selectedcol, timesheet:json, company: $scope.company,locationname: $scope.locationname, projecttypeid : $scope.projecttypeid, milestoneids:milestoneidsjson});
		$http({
			url: path+'timesheet/updateproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
		 if($scope.files!=""){
					$scope.uploadFile($scope.projectid);
					//window.open(path+"setup/users", "_self");
				}
			if(data.status){
                            
				successMessage(data.successMsg);
				
		       $scope.ownerid=0;
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.desc="";
			   $scope.title="";
			   $scope.projectstatus=0;
			   $scope.locationname="";
			   $scope.company="";
			   $scope.selectedcolumnsarr=[];
				$scope.juniourarr=[];
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/////////////////get time format and set time/////
	
	$scope.settotaltime= function($index)
	{
		//alert($index);//alert($edate);
		
		var strt = $("#"+$index+"actstart").datetimepicker('getDate');
		var end = $("#"+$index+"actend").datetimepicker('getDate');
		
		var a = new Date(strt);
		var b = new Date(end);
		
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		/* var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		var day = Math.floor((utc2 - utc1) / _MS_PER_DAY);
		 */
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
		//console.log($scope.TaskList);
		for(var i=0;i<$scope.timesheetarray.length;i++){
			if($index == i){
			$scope.timesheetarray[i]['totaltime1']=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.timesheetarray[i]['totaltime']=days1+':'+minutes;
			}
		
		}
	}
});

app.controller('timesheetdashCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.shiftid=0;
	$scope.chart1date="";
	$scope.attendancearray=[];
	$scope.latecomerarray=[];
	$scope.filscalid=0;
	$scope.date1="";
	$scope.mails="";
	
	function auto_save_pdf(){
		$timeout(function(){
			
			$scope.save_pdf();
			
		}, 3000);
	}
	var theme = {
          color: [
              '#26B99A', '#34495E', '#BDC3C7', '#3498DB',
              '#9B59B6', '#8abb6f', '#759c6a', '#bfd3b7'
          ],
		title: {
              itemGap: 8,
              textStyle: {
                  fontWeight: 'normal',
                  color: '#408829'
              }
          },

          dataRange: {
              color: ['#1f610a', '#97b58d']
          },

          toolbox: {
              color: ['#408829', '#408829', '#408829', '#408829']
          },

          tooltip: {
              backgroundColor: 'rgba(0,0,0,0.5)',
              axisPointer: {
                  type: 'line',
                  lineStyle: {
                      color: '#408829',
                      type: 'dashed'
                  },
                  crossStyle: {
                      color: '#408829'
                  },
                  shadowStyle: {
                      color: 'rgba(200,200,200,0.3)'
                  }
              }
          },

          dataZoom: {
              dataBackgroundColor: '#eee',
              fillerColor: 'rgba(64,136,41,0.2)',
              handleColor: '#408829'
          },
          grid: {
              borderWidth: 0
          },

          categoryAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },

          valueAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitArea: {
                  show: true,
                  areaStyle: {
                      color: ['rgba(250,250,250,0.1)', 'rgba(200,200,200,0.1)']
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },
          timeline: {
              lineStyle: {
                  color: '#408829'
              },
              controlStyle: {
                  normal: {color: '#408829'},
                  emphasis: {color: '#408829'}
              }
          },

          k: {
              itemStyle: {
                  normal: {
                      color: '#68a54a',
                      color0: '#a9cba2',
                      lineStyle: {
                          width: 1,
                          color: '#408829',
                          color0: '#86b379'
                      }
                  }
              }
          },
          map: {
              itemStyle: {
                  normal: {
                      areaStyle: {
                          color: '#ddd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  },
                  emphasis: {
                      areaStyle: {
                          color: '#99d2dd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  }
              }
          },
          force: {
              itemStyle: {
                  normal: {
                      linkStyle: {
                          strokeColor: '#408829'
                      }
                  }
              }
          },
          chord: {
              padding: 4,
              itemStyle: {
                  normal: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  },
                  emphasis: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  }
              }
          },
          gauge: {
              startAngle: 225,
              endAngle: -45,
              axisLine: {
                  show: true,
                  lineStyle: {
                      color: [[0.2, '#86b379'], [0.8, '#68a54a'], [1, '#408829']],
                      width: 8
                  }
              },
              axisTick: {
                  splitNumber: 10,
                  length: 12,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              axisLabel: {
                  textStyle: {
                      color: 'auto'
                  }
              },
              splitLine: {
                  length: 18,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              pointer: {
                  length: '90%',
                  color: 'auto'
              },
              title: {
                  textStyle: {
                      color: '#333'
                  }
              },
              detail: {
                  textStyle: {
                      color: 'auto'
                  }
              }
          },
          textStyle: {
              fontFamily: 'Arial, Verdana, sans-serif'
          }
      };
	
	$scope.onfetchdashboard=function($val,$type)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid:$scope.filscalid, type:$type,date:$scope.date1});
		$http({
			url: path+'timesheet/gettimesheetDashboard',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.mails=data.senioremail;
				$('#bar-chart3').html('');
				$('#bar-chart2').html('');
				$('#bar-chart4').html('');
				$('#bar-chart5').html('');
				$('#bar-chart6').html('');
				$('#bar-chart7').html('');
				$scope.date1=data.date;
				$scope.fiscalformat=data.fiscal_format;
				$scope.monthview=data.curmonth;
				//$scope.fiscalview =data.data['financialyear'][0]['name'];
				//$scope.chart1date = data.data['chartdata1date'];
				$scope.filscalid=data.filscalid;
				//alert($scope.date1);
				console.log(data.data['chartdata4name']);
				var bar ="";
				
		    var echartPie = echarts.init(document.getElementById('chart9'), theme);

      echartPie.setOption({
        tooltip: {
          trigger: 'item',
          formatter: "{a} <br/>{b} : {c} "
        },
        
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              type: ['pie', 'funnel'],
              option: {
                funnel: {
                  x: '25%',
                  width: '50%',
                  funnelAlign: 'right',
                  max: 1548
                }
              }
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        series: [{
          name: '',
          type: 'pie',
          
          data: data.data['chartdata1']
        }]
      });
				
				
	var echartPie = echarts.init(document.getElementById('bar-chart77'), theme);

      echartPie.setOption({
        tooltip: {
          trigger: 'item',
          formatter: "{a} <br/>{b} : {c} "
        },
        
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              type: ['pie', 'funnel'],
              option: {
                funnel: {
                  x: '25%',
                  width: '50%',
                  funnelAlign: 'right',
                  max: 1548
                }
              }
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        series: [{
			radius : '50%',
          name: '',
          type: 'pie',
          
          data: data.data['chartdata7']
        }]
      });

	  
	var echartPie = echarts.init(document.getElementById('bar-chart33'), theme);
    echartPie.setOption({
        tooltip: {
          trigger: 'item',
          formatter: "{a} <br/>{b} : {c} "
        },
        
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              type: ['pie', 'funnel'],
              option: {
                funnel: {
                  x: '25%',
                  width: '50%',
                  funnelAlign: 'right',
                  max: 1548
                }
              }
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        series: [{
			
          name: '',
          type: 'pie',
          
          data: data.data['chartdata3']
        }]
      });
		
		  var echartBar = echarts.init(document.getElementById('bar-chart44'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: ['No. of Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata4name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: '',
          type: 'bar',
          data: data.data['chartdata4total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }]
      });
	  
	  
	   var echartBar = echarts.init(document.getElementById('bar-chart22'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata2name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['No. of days'],
          type: 'bar',
          data: data.data['chartdata2total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }]
      });
    	
	var echartBar = echarts.init(document.getElementById('bar-chart55'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata5name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimated Time'],
          type: 'bar',
          data: data.data['chartdata5total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
		{
          name: ['Actual Time'],
          type: 'bar',
          data: data.data['chartdata5count'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
		]
      });
		
		var echartBar = echarts.init(document.getElementById('bar-chart66'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata6name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimated Time'],
          type: 'bar',
          data: data.data['chartdata6total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
		{
          name: ['Actual Time'],
          type: 'bar',
          data: data.data['chartdata6count'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
		]
      });
		
		$scope.hastrue=false;
		//auto_save_pdf();
			}
			else{
					errorMessage(data.errorMsg);
					}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
			$scope.hastrue=false;
	}
	
	var
	form = $('.form'),
	cache_width = form.width(),
	a3  =[ 841.89, 1190.55];  // for a4 size paper width and height
	
	$scope.save_pdf=function()
	{
		getCanvas().then(function(canvas){
		var
		img = canvas.toDataURL("image/png"),
		doc = new jsPDF({
          unit:'px',
          format:'a3'
        });
        doc.addImage(img, 'JPEG', 20, 20);
		
		//window.open(img);
		/* console.log(doc.output('datauri')); */

		var pdfencoded=doc.output('blob');
		//alert($scope.mails);
		var mails=$scope.mails;
		//alert(pdfencoded);
		var fd = new FormData();     // To carry on your data  
		fd.append('mypdf',pdfencoded);
		fd.append('mail',mails);
		$http({
			url: path+'report/showpdf',
			method: "POST",
			data: fd,
			 headers: { 'Content-Type': undefined }
		}).success(function (data, status, headers, config) {
			//errorMessage( $scope.leavevalidsts);
			if(data.status){
				successMessage(data.successMsg);
			   $scope.hastrue=false;				
			}else{
				errorMessage(data.errorMsg);
				 
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
       // doc.save('Employee_dashboard.pdf');
        form.width(cache_width);
	});
	}
	
function getCanvas(){
	
	form.width((a3[0]*1.33333) -80).css('max-width','none');
	return html2canvas(form,{
    	imageTimeout:2000,
    	removeContainer:true
		
    });
}
	
});
/////////////////Clients Controller Start From Here/////////
app.controller('clientCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.clientid=0;
	$scope.employername="";
	$scope.aliasname="";
		$scope.contactperson="";
		$scope.emailaddress='';
		$scope.contactnumber='';
		$scope.address='';
		$scope.descriptions='';
		$scope.website='';
		$scope.projectsts=2;
		$scope.country=0;
		$scope.city=0;
		$scope.countryList=[];
		$scope.cityList=[];
		onfetch('country/getallcountry',15);
		function onfetch($val, $id) {
		$scope.hastrue=true;
		var xsrf = $.param({employeeid: $scope.employeeid});
		$http({
			url: path+$val,
			method: "POST", data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray=[];
					$scope.cityarray=data.data;
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	$scope.getcity = function($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.country,$val);
		}
	}
	function getcity1($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.country,$val);
		}
	}
	$scope.onfetchclientDetail =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({clientid: $id});
	$http({
        url: path+'client/getaclient',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.clientid=data.data[0]['id'];
				$scope.employername=data.data[0]['name'];
				$scope.aliasname=data.data[0]['aliasname'];
				$scope.contactperson=data.data[0]['cperson'];
				$scope.emailaddress=data.data[0]['email'];
				$scope.contactnumber=data.data[0]['cnumber'];
				$scope.address=data.data[0]['address'];
				$scope.projectsts=data.data[0]['projectsts'];
				
				//$scope.landmark=data.data[0]['landmark'];
				//$scope.zipcode=data.data[0]['zipcode'];
				$scope.country=data.data[0]['countryid'];
				$scope.city=data.data[0]['cityid'];
				$scope.descriptions=data.data[0]['aboutcompany'];
				$scope.website=data.data[0]['companywebsite'];
				getcity1(16);
			}
		
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	$scope.getId = function($id){
		$scope.clientid=$id;
	}
	//$scope.admlmt="";
	$scope.ondelete =function(){
		$scope.hastrue=true;
		$http({
			url: path+'client/deleteclient/'+$scope.clientid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				/* //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers; */$scope.hastrue=false;
		});
	}
	$scope.onchangeadmin =function(){
		$scope.hastrue=true;
		$http({
			url: path+'client/changeclientstatus/'+$scope.clientid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				/* //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers; */$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({employername: $scope.employername, aliasname: $scope.aliasname, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber,  emailaddress: $scope.emailaddress, address: $scope.address, country: $scope.country, city: $scope.city, description:$scope.descriptions, website:$scope.website, projectsts:$scope.projectsts});
		$http({
			url: path+'client/createclient',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
				successMessage(data.successMsg);
				
				$scope.employername="";
				$scope.aliasname="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.address="";
				$scope.country="";
				$scope.city="";
				$scope.descriptions="";
				$scope.website="";
				$scope.clientid=0;
				if($val==1){
				$timeout(function(){window.open(path+"client/index", "_self");}, timeo);
				}
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	$scope.onupdate = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({clientid: $scope.clientid, employername: $scope.employername,aliasname: $scope.aliasname, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber, emailaddress: $scope.emailaddress, address: $scope.address, country: $scope.country, city: $scope.city,  description:$scope.descriptions, website:$scope.website, projectsts:$scope.projectsts });
		  $http({
				url: path+'client/updatedeclient',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			  }).success(function (data, status, headers, config) {
				
			if(data.status){
				//alert(data.successMsg);
				successMessage(data.successMsg);
				$scope.employername="";
				$scope.aliasname="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.address="";
				
				$scope.country="";
				$scope.city="";
				$scope.descriptions="";
				$scope.website="";
				$scope.clientid=0;
				
				if($val==1){
					//window.open(path+"setup/employer", "_self");
					$timeout(function(){window.open(path+"client/index", "_self");}, timeo);
				}
				
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


////////////////////////////////////////////// Start Project Type Controller //////////////////////////////////////////////

 app.controller('ProjectTypeCtrl', function($scope, $http, $timeout) {
	 
	$scope.projecttypeid=0;
	$scope.projecttypename="";
	$scope.projecttypedescription="";
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
    $scope.milestonearray = [{name:"", desc:""}];
	
	$scope.addmilestone = function($i){
		var len = $scope.milestonearray.length-1;
		if($scope.milestonearray[len]['name']==""){
			errorMessage("Please fill milestone name");
		}else{
			$scope.milestonearray.insert($i+1,{name:"", desc:""});
		}
	}
	
	$scope.removemilestone = function($i){
		$scope.milestonearray.remove($i);
		if($scope.milestonearray.length==0){
			$scope.milestonearray.insert($i,{name:"", desc:""});
		}
	}
	
	$scope.onfetch= function($projecttypeid){
		$scope.projecttypeid = $projecttypeid;
		$scope.hastrue=true;
		$http({
			url: path+"timesheet/getaProjectType/"+$projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.projecttypename=data.data[0].name;		
				$scope.projecttypedescription=data.data[0].desc;
				$scope.milestonearray=data.data[0].milestone;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val){
		var jsonData8 = angular.toJson($scope.milestonearray);
	
		$scope.hastrue=true;
		var xsrf = $.param({ milestone:jsonData8, projecttypename:$scope.projecttypename, projecttypedescription:$scope.projecttypedescription });
		$http({
			url: path+'timesheet/createProjectType',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$scope.projecttypeid=0;
					$scope.projecttypename="";
					$scope.projecttypedescription="";
					$scope.milestonearray = [{name:"", desc:""}];
						if($val==1)
						$timeout(function(){window.open(path+"timesheet/projecttypelist", "_self");}, timeo);
				}else{
					errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				$scope.hastrue=false;
		}); 
 }
 
 	$scope.onupdate = function($val)
	{	
		var jsonData8 = angular.toJson($scope.milestonearray);
			$scope.hastrue=true;
		var xsrf = $.param({ milestone:jsonData8, projecttypename:$scope.projecttypename, projecttypedescription:$scope.projecttypedescription, projecttypeid:$scope.projecttypeid });
		$http({
			url: path+'timesheet/updateProjectType',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);	
					//window.open(path+"salary/generatesalary", "_self");
					$scope.projecttypeid=0;
					$scope.projecttypename="";
					$scope.projecttypedescription="";
					$scope.milestonearray = [{name:"", desc:""}];
					if($val==1)
					$timeout(function(){window.open(path+"timesheet/projecttypelist", "_self");}, timeo);
				}
				else{
				errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	$scope.getId = function($id,$projecttypeid) {
		$scope.milestoneid=$id;
		$scope.projecttypeid=$projecttypeid;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'timesheet/deleteDefaultMilestone/'+$scope.milestoneid+'/'+$scope.projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
});

///////////////////////////////////////////// Ending Project Type Controller ///////////////////////////////////////////////


 app.controller('Timesheetctrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.TaskList=[];
	$scope.marks="";
	$scope.remark="";
	$scope.empList=[];
	$scope.totalmarks=0;
	$scope.date="";
	$scope.todate="";
	$scope.fromdate="";
	$scope.desc="";
	$scope.taskid=0;
	$scope.projectid=0;
	

    onfetch('profile/getallproject1',1);
    onfetch('profile/getalltask',2);

	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				if($id==1){
					$scope.projectarray=[];
					$scope.projectarray=data.data;
				}else if($id==2){
					$scope.taskarray=[];
					$scope.taskarray=data.data;
				}
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
		$scope.onfetchtimesheet =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({timesheetid: $id});
		$http({
			url: path+'timesheet/getatimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.projectid=data.data[0]['project_id'];
				$scope.fromdate=data.data[0]['start_date'];
				$scope.todate=data.data[0]['end_date'];
				$scope.desc=data.data[0]['description'];
				$scope.taskid=data.data[0]['task_id'];				
				$scope.hastrue=false;		
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}else{
			$scope.hastrue=false;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	

});


app.controller('Milestonectrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.TaskList=[];
	$scope.marks="";
	$scope.remark="";
	$scope.empList=[];
	$scope.totalmarks=0;
	$scope.date="";
	$scope.desc="";
	$scope.title="";
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.projectstartdate="";
	$scope.projectenddate="";
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	//$scope.leavevalidsts=[];
	$scope.projectarray=[];
	onfetch();
	function onfetch(){
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getallproject",
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
					$scope.projectarray=data.data;			
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
		$scope.milestonearray=[{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""}];
	$scope.addmile = function($i){
		var len = $scope.milestonearray.length-1;
		if($scope.milestonearray[len]['projectid']=="" || $scope.milestonearray[len]['desc']=="" || $scope.milestonearray[len]['assignempid']=="" ||$scope.milestonearray[len]['title']=="" || $scope.milestonearray[len]['fromdate']==""|| $scope.milestonearray[len]['todate']=="" || $scope.milestonearray[len]['projectstatus']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.milestonearray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	}
	$scope.removemile = function($i){
		$scope.milestonearray.remove($i);	
		if($scope.milestonearray.length==0){
			$scope.milestonearray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};

	$scope.juniourarr=[]; 
	$scope.selectedcolumnsarr = [];		
	$scope.onfetchjuniours =function($id){

		$scope.hastrue=true;
		var xsrf = $.param({userid: $id});
		$http({
			url: path+'projects/getallprojects',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.juniourarr=data.data;
				$scope.selectedcolumnsarr=new Array();	
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.toggleSelection = function($x) {
	
	  if($scope.juniourarr[$x].vsts){		
		$scope.juniourarr[$x].vsts=false;
	  }else{
		$scope.juniourarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.juniourarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.juniourarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
    $scope.toggleSelection1 = function($x) {
	
	  if($scope.selectedcolumnsarr[$x].vsts){		
		$scope.selectedcolumnsarr[$x].vsts=false;
	  }else{
		$scope.selectedcolumnsarr[$x].vsts=true;
	  }
	  $scope.rightdisable=true;
	  var len = $scope.selectedcolumnsarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedcolumnsarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
   };
	///////////end check checkbox ////////////   
   //////////left right move function//////////////
	$scope.onAddSelection = function()
	{
		$scope.leftdisable=true;
		$scope.rightdisable=true;
		for (var i=0; i<$scope.juniourarr.length; i++) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr[i].vsts=false;
					$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
					$scope.juniourarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.juniourarr.length-1; i>=0; i--) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			$scope.selectedcolumnsarr[i].vsts=false;
		 }
	}
	$scope.onRemoveSelection = function()
	{
		$scope.leftdisable=true;
		$scope.rightdisable=true;
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr[i].vsts=false;
					$scope.juniourarr.insert($scope.juniourarr.length,$scope.selectedcolumnsarr[i]);
					$scope.selectedcolumnsarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.selectedcolumnsarr.length-1; i>=0; i--) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.juniourarr.length; i++) {
				$scope.juniourarr[i].vsts=false;
		}
			
	}
	
	$scope.onfetchmilestoneDetail =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'milestone/getmilestonedetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.title=data.data[0]['title'];
				$scope.fromdate=data.data[0]['startdate'];
				$scope.todate=data.data[0]['enddate'];
				$scope.desc=data.data[0]['desc'];
				//$scope.desc=data.data[0]['assignee_id'];
			    $scope.projectid=data.data[0]['projectid'];
				$scope.getDefaultMilestoneByProject($scope.projectid);
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val){
		
		$scope.hastrue=true;
		var xsrf = $.param({ projectid: $scope.projectid , desc : $scope.desc,fromdate: $scope.fromdate , todate : $scope.todate ,  title : $scope.title});
		$http({
			url: path+'milestone/createmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
			   $scope.projectid=0;
			   $scope.desc="";
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.title="";
			   $scope.milestonearray=[];
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"milestone/milestonelist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
		$scope.onupdate = function($val)
	{ 
		$scope.hastrue=true;
		
		var xsrf = $.param({projectid:$scope.projectid,  title: $scope.title , startdate: $scope.fromdate , enddate : $scope.todate , desc : $scope.desc,milestoneid:$scope.milestoneid});
		$http({
			url: path+'milestone/updatemilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                            
				successMessage(data.successMsg);
				
		        $scope.projectid=0;
				$scope.milestoneid=0;
			   $scope.desc="";
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.title="";
			   $scope.milestonearray=[];
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"milestone/milestonelist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.getId = function($id) {
		$scope.milestoneid=$id;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'milestone/deletemilestone/'+$scope.milestoneid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.setdate =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getprojectdate',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.projectstartdate=data.data[0]['start_date'];
				$scope.projectenddate=data.data[0]['completed_date'];
                 $('#fromdate').datepicker("remove");
				$('#fromdate').datepicker({
				startDate: new Date($scope.projectstartdate),
				endDate: new Date($scope.projectenddate)
				
		});
				  $('#todate').datepicker("remove");
				$('#todate').datepicker({
				startDate: new Date($scope.projectstartdate),
				endDate: new Date($scope.projectenddate)
				
		});
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.timediffest = function($leaveto){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate,
			endDate: new Date($scope.projectenddate)
		});
		
		
	}
	
		/////////////////get default milestones for project/////
	
	$scope.getDefaultMilestoneByProject= function($id)
	{
		var xsrf = $.param({projectid: $id});
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getDefaultMilestoneByProject",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				
						$scope.milestonearray=[];
						$scope.milestonearray=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

////////////////////////////// Default milestone controller ////////////////////////////////////////////////////

app.controller('DefaultMilestonectrl', function($scope, $http, $timeout) {
	
	$scope.milestone="";
	$scope.description="";
	$scope.successmessage="";
	$scope.errormessage="";
	
		$scope.onsavedefaultmilestone = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({ milestone: $scope.milestone , description: $scope.description});
		$http({
			url: path+'milestone/saveDefaultMilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
			   $scope.successmessage=data.successMsg;
			    $scope.milestone="";
			   $scope.description="";
			  
				$scope.errormessage="";
			 if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					window.open(path+"milestone/getDefaultMilestone", "_self");
				}else{
					 table.draw();
				}				
				$scope.hastrue=false;
			}else{
				$scope.hastrue=false;
				errorMessage(data.errorMsg);
				$scope.errormessage=data.errorMsg;
					$scope.successmessage="";
			}
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
	$scope.getId = function($id) {
		$scope.defaultmilestoneid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'milestone/deletedefaultmilestone/'+$scope.defaultmilestoneid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
		$scope.fetchDefaultMilestone =function($id){ 
		$scope.milestoneid=$id;
		 $scope.errormessage="";
		$scope.successmessage="";
		$scope.hastrue=true;
		var xsrf = $.param({milestoneid: $id});
		$http({
			url: path+'milestone/getdefaultmilestonebyid',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.milestone=data.data[0]['name'];
				$scope.description=data.data[0]['description'];
			    //console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}else{
				
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


		$scope.onupdate = function($val)
	{ 
		$scope.hastrue=true;
		
		var xsrf = $.param({milestoneid:$scope.milestoneid,  name: $scope.milestone , description: $scope.description});
		$http({
			url: path+'milestone/updatedefaultmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
				successMessage(data.successMsg);
				$scope.successmessage=data.successMsg;
				$scope.milestoneid=0;
				$scope.description="";
				$scope.milestone="";
				$timeout(function(){$('#myModal').modal('show');}, 300);
				$scope.errormessage="";
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					window.open(path+"milestone/getDefaultMilestone", "_self");
				}			
				table.draw();
				$scope.hastrue=false;				
			}else{
				errorMessage(data.errorMsg);
				  $scope.errormessage=data.errorMsg;
				  $scope.successmessage="";
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.addingdefaultmilestone = function($id) {
		$scope.errormessage="";
		$scope.successmessage="";
		$scope.milestoneid=0;
		$scope.milestone="";
		$scope.description="";
		$timeout(function(){$('#myModal').modal('show');}, 300);
		}
	
	
});

////////////////////////////// Ending Default milestone controller ////////////////////////////////////////////////////
