/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('timesheetapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////////////////// Topbar Controller Starts From Here  ///////////////////////////////////
/* app.controller('projectCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.leavereason="";
	$scope.leavestatus="";
	$scope.leavevalidsts="";
	$scope.applydate="";
	$scope.approvercomment="";
	$scope.resumptiondate="";
    $scope.approvedby=0; 
    $scope.leavetypeid=0;
	//$scope.leavevalidsts=[];
    onfetch('leave/getallleaveemployee',4);
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					if($id==4){
						$scope.employeearray=[];
						$scope.employeearray=data.data;
					}
					
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

	
	$scope.getId = function($id) {
		$scope.projectid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'timesheet/deleteproject/'+$scope.projectid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
 $scope.juniourarr=[];  
	$scope.onfetchjuniours =function($id)
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'employee/getemployeehierarchy',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                
				$scope.juniourarr=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.fillassignto = function($id) {
		alert($id);
		$scope.assigntoarr=new Array();
		//console.log($id);
		var arr=$id;
		for(var j=0;j<arr.length;j++)
		{
			for(var i=0;i<$scope.juniourarr.length;i++)
			{
				if(arr[j]==$scope.juniourarr[i]['id'])
					$scope.assigntoarr.insert(j,{id:$scope.juniourarr[i]['id'],name:$scope.juniourarr[i]['name']});
			}
			
		}
		console.log($scope.assigntoarr);
		
	}
	
  $scope.onfetchproject =function()
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({projectid: $scope.projectid});
		$http({
			url: path+'timesheet/getaproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.leavereason=data.data[0]['leavereason'];
				$scope.leavestatus=data.data[0]['leavestatus'];
				$scope.leavevalidsts=data.data[0]['leavevalidsts'];
				$scope.leavedays=data.data[0]['leavevalidsts'];
				$scope.applydate=data.data[0]['applydate'];
				$scope.approvercomment=data.data[0]['approvercomment'];
				$scope.resumptiondate=data.data[0]['resumptiondate'];
               	$scope.approvedby = data.data[0]['approvedby'];
				$scope.approvercomment = data.data[0]['approvercomment'];
				$scope.contactdetail = data.data[0]['emergencycontact'];
				$scope.leavetype = data.data[0]['leavetypeid'];
				$scope.fromdaytype=data.data[0]['fromdaytype'];
				$scope.todaytype=data.data[0]['todaytype'];
				$scope.timeoffrom=data.data[0]['timeoffrom'];
				$scope.timeofto=data.data[0]['timeofto'];
				$scope.leaveat=data.data[0]['leaveattachment'];
				var temp = data.data[0]['leavebreakdown'];
				if(temp != "")
				{
					temp=temp.split(',');
					
					$scope.entitled=Number(temp[0]);
					$scope.carryforward=Number(temp[1]);
					$scope.advance=Number(temp[2]);
					$scope.unpaid=Number(temp[3]);
					
				}
				gettimediff();
				$scope.onfetchleavetype();
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{ 
	
		
		
		$scope.hastrue=true;
		var xsrf = $.param({ ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title, assignempid:$scope.assignempid });
		$http({
			url: path+'timesheet/createproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                            
				successMessage(data.successMsg);
				
		        
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onupdate = function($val)
	{ 
	
		i$scope.hastrue=true;
		var xsrf = $.param({project_id:$scope.projectid, ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title, assignempid:$scope.assignempid });
		$http({
			url: path+'timesheet/updateproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                            
				successMessage(data.successMsg);
				
		        
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
}); */

/////////////////////////// Project Controller Starts From Here  ///////////////////////////////////
app.controller('projectCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.ownerid='';
	$scope.projectlead='';
	$scope.clientmanager='';
	$scope.projectid=0;
	$scope.projecttypeid='';
	$scope.title="";
	$scope.desc="";
	$scope.projectstatus="";
	$scope.fromdate="";
	$scope.todate="";
	$scope.company="";
	$scope.locationname="";
	$scope.milestoneids="";
	$scope.billingmethod=0;
	$scope.budget=0;
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	$scope.milestonearray=[];
	$scope.juniourarr=[]; 
	$scope.startdatelabel="Started on";
	$scope.enddatelabel="Estimated End Date";
	$scope.selectmilestone="";
	$scope.leftdisableMilestone=true;
	$scope.rightdisableMilestone=true;
	$scope.billablests=1;
	$scope.billingshow=true;
	//$scope.leavevalidsts=[];
	//onfetch('milestone/getalldefaultmilestone',6);
	//onfetch('leave/getallleaveemployee',4);
	onfetch('employee/getEmployeeListbyreport',4);
    onfetch('other',3);
    onfetch('profile/getallproject',1);
    onfetch('profile/getalltask',2);
	onfetch('other',5);
	onfetch('timesheet/getallprojecttype',7);
	onfetch('client/getallclients',8);
	//////Match DeliveryHead, ProjectManager,ProjectLead are same or not//////////
	$scope.matchValue=function(){
		var clientmanager=$("#clientmanager").val();
		var ownerid=$("#ownerid").val();
		
		var projectlead=$("#projectlead").val();
		
		//alert($scope.clientmanager);alert($scope.ownerid);alert(projectlead);
		if(ownerid==clientmanager){
			alert("Project Manager is not be same DeliveryHead");
			$timeout(function() {
				$("#ownerid").selectpicker('refresh');                      
			}, 1000);
			$("#ownerid").val('');
			$scope.ownerid="";
			return false;
		}
		
		if(projectlead==clientmanager ){
			alert("Project Manager is not be same DeliveryHead");
			$timeout(function() {
					$("#projectlead").selectpicker('refresh');                      
			}, 1000);
			$("#projectlead").val('');
			$scope.projectlead="";
			return false;
			
		}
		if (projectlead==ownerid){
			alert("Project Lead is not be same Project Manager");
			$timeout(function() {
					$("#projectlead").selectpicker('refresh');                      
			}, 1000);
			$("#projectlead").val('');
			$scope.projectlead="";
			return false;
					return false;
			}
	}
	
	var currentDate = new Date()
	var day = currentDate.getDate()
	var month = currentDate.getMonth() + 1
	var year = currentDate.getFullYear()
	var currdate = day + "/" + month + "/" + year;
	$scope.getbilling= function($val){
		if($val==1){
			$scope.billingshow=true;
			$scope.getclientcurr($scope.company);
		}
		else{
			$scope.billingshow=false;
			$scope.getclientcurr($scope.company);
		}
	}
	$scope.changedatelebel= function($projectsts){
		
		$scope.fromdate = $scope.fromdate1;
		$scope.todate = $scope.todate1;
		if($projectsts==1){
			/////1.Running Project//////////
			$scope.startdatelabel="Started on ";
			$scope.enddatelabel="Estimated End Date";
		//	$scope.fromdate=""; 
			//$scope.todate=""; 
			if($scope.projectid!=0){
				
				$scope.fromdate=$scope.fromdate; 
				$scope.todate=$scope.todate; 
			}else{
				$scope.fromdate=""; 
				$scope.todate=""; 
			}
		}else if($projectsts==2){
			/////2.Abandoned Project//////////
			$scope.startdatelabel="Started on ";
			$scope.enddatelabel="Abandoned Date";
			
			if($scope.projectid!=0){
				$scope.fromdate=$scope.fromdate; 
				$scope.todate=currdate; 
			}else{
				$scope.fromdate=""; 
				$scope.todate=""; 
			}
		}else if($projectsts==3){
			/////3.Finish  Project//////////
			$scope.startdatelabel="Started on ";
			$scope.enddatelabel="Ended on";
			
			if($scope.projectid!=0){
				$scope.fromdate=$scope.fromdate; 
				$scope.todate=currdate; 
			}else{
				$scope.fromdate=""; 
				$scope.todate=""; 
			}
		
		}else if($projectsts==4){
			/////4.Reopened Project//////////
			$scope.startdatelabel="Reopened Date";
			$scope.enddatelabel="Estimated.End Date";
			if($scope.projectid!=0){
				$scope.fromdate=currdate; 
				$scope.todate=""; 
			}else{
				$scope.fromdate=""; 
				$scope.todate=""; 
			}
		}else if($projectsts==5){
			/////5.Not Started Project//////////
			$scope.startdatelabel="Estimated start Date";
			$scope.enddatelabel="Estimated end Date";
			
			if($scope.projectid!=0){
			//$scope.fromdate=""; 
			//$scope.todate=""; 
			}else{
				$scope.fromdate=$scope.fromdate; 
				$scope.todate=$scope.todate; 
			}
		}
		
	}
	
	$scope.onfetchClient =function(){ 
		$scope.hastrue=true;
		
		$http({
			url: path+'client/getallclients',
			method: "POST",
			//data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.clientarray=data.data;
			}else
				$scope.clientarray=[];				
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/* $scope.getDurationValue= function(){
		$scope.projectduration;
		//console.log( $scope.projectduration);
		var tempStartDate=$("#fromdate").datepicker('getDate');
		if(tempStartDate!="" && $scope.projectduration!=""){
			var tempEndDate = new Date(tempStartDate);
			//	console.log( tempEndDate);
			var default_end = new Date(tempEndDate.getFullYear(), tempEndDate.getMonth(), tempEndDate.getDate()+$scope.projectduration); //this parses date to overcome new year date weirdness
			$('#todate').datepicker('setDate', default_end);
			//console.log( default_end);
		}if( $scope.projectduration==undefined){
			$scope.todate="";
		}
		//$('#todate').datepicker('setDate', '');
	//$scope.todate="";
	} */
	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==1){
					$scope.projectarray=[];
					$scope.projectarray=data.data;
				}else if($id==2){
					$scope.taskarray=[];
					$scope.taskarray=data.data;
				}else if($id==3){
					$scope.otherfieldarr=[];
					$scope.otherfieldarr=data.data;
				}else if($id==4){
					$scope.employeearray=[];
					$scope.employeearray=data.data;
					$timeout(function() {
					$('.selectpicker').selectpicker('refresh');                      
				}, 1000);
				}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						$scope.projectstatus=$scope.otherarray[0]['id'];
				}
				else if($id==7){
						$scope.projecttypearray=[];
						$scope.projecttypearray=data.data;
				}else if($id==8){
						$scope.clientarray=[];
						$scope.clientarray=data.data;
				}
					$timeout(function() {
					$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);   
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	//////////Get All Milestone///////////////
	$scope.onfetchmilestones=function($projecttypeid){
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getalldefaultmilestone/"+$projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.milestonearray=[];
				$scope.milestonearray=data.data;
				$timeout(function() {
					$('.selectpicker').selectpicker('refresh');                      
				}, 1000);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	///////////Show select milestone////
	$scope.getSelectMilestone=function(){
		$scope.selectmilestone="";$scope.newmilestonearr=[];
			$('#milestoneidlist').empty(); 
		for(var i=0; i<$scope.milestoneids.length; i++){
			for(var j=0;j<$scope.milestonearray.length; j++){
				if($scope.milestonearray[j].id==$scope.milestoneids[i]){
					/* if($scope.selectmilestone==""){
					$scope.selectmilestone +=$scope.milestonearray[j].name;
					}else{
						$scope.selectmilestone += " , ";
						$scope.selectmilestone +=$scope.milestonearray[j].name;
					} */
					$('#milestoneidlist').append('<span>'+$scope.milestonearray[j].name+'</span><br>');
					$scope.newmilestonearr.push($scope.milestonearray[j]);
				}
			}
		}
	}
	///////////////Add milestone cost array//////////////////////////
	$scope.billingmilestone=[{milestoneid:"", milestonecost:0}];
	$scope.addmilestonecost = function() {
		var len = $scope.billingmilestone.length-1;
		if($scope.billingmilestone[len]['milestoneid']=="" || $scope.billingmilestone[len]['milestonecost']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.billingmilestone.insert($scope.billingmilestone.length,{milestoneid:"", milestonecost:0});
		}
   }
	$scope.removemilestonecost= function($index){
		$scope.billingmilestone.remove($index);
   }
	////////////Add employee cost array///////////////////
	$scope.billingemployee=[{selectemployeeid:"", empdesigid:"", employeecost:0}];
	$scope.addemployeecost = function() {
		var len = $scope.billingemployee.length-1;
		if($scope.billingemployee[len]['selectemployeeid']=="" || $scope.billingemployee[len]['empdesigid']=="" || $scope.billingemployee[len]['employeecost']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.billingemployee.insert($scope.billingemployee.length,{selectemployeeid:"", empdesigid:"" , employeecost:0});
		}
   }
    $scope.removeemployeecost= function($index){
		$scope.billingemployee.remove($index);
	} 
	////////Set Multiple task//////////////
	$scope.timesheetarray=[{id:0,priority:1, taskid:"", assignto:"", sdate:"", edate:"",totaltime:""}];
	$scope.addtask = function($i){
		var len = $scope.timesheetarray.length-1;
		if($scope.timesheetarray[len]['taskid']=="" || $scope.timesheetarray[len]['assignto']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.timesheetarray.insert($i,{id:0,priority:($i+1),taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	$scope.removetask = function($i){
		$scope.timesheetarray.remove($i);	
		if($scope.timesheetarray.length==0){
			$scope.timesheetarray.insert($i,{id:0,priority:1,taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	/* $scope.fillassignto = function($id) {
		//alert($id);
		$scope.assigntoarr=new Array();
		//console.log($id);
		var arr=$id;
		for(var j=0;j<arr.length;j++){
			for(var i=0;i<$scope.juniourarr.length;i++){
				if(arr[j]==$scope.juniourarr[i]['id'])
				$scope.assigntoarr.insert(j,{id:$scope.juniourarr[i]['id'],name:$scope.juniourarr[i]['name']});
			}
		}
		//console.log($scope.assigntoarr);
	} */
	$scope.getId = function($id) {
		$scope.projectid=$id;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'timesheet/deleteproject/'+$scope.projectid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	////////Search Project manager/////////////
	$scope.onfetchprojecttype= function() {
		if($scope.owneridmodel != undefined) {
			if($scope.owneridmodel.length>1) {
				errorMessage("Select only one Employee");
				$scope.owneridmodel=[];
				return;
			}else{
				$scope.ownerid=parseInt($scope.owneridmodel.toString());
				//$scope.onfetchjuniours($scope.ownerid);
			}	
		}
	}
	/////////Get Employee according to hera///////////////
	$scope.onfetchjuniours =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'employee/getEmployeeListbyreport',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.juniourarr=data.data;
				$timeout(function() {
					$('.selectpicker').selectpicker('refresh');                      
				}, 1000);
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	///////////Show select Employee////
	$scope.getSelectEmployee=function(){
		$scope.newemployeearr=[];
		//console.log($scope.employeeid);
		$('#empidlist').empty(); 
		if($scope.employeeid!=undefined){
		for(var i=0; i<$scope.employeeid.length; i++){
			for(var j=0;j<$scope.employeearray.length; j++){
				if($scope.employeearray[j].id==$scope.employeeid[i]){
					$('#empidlist').append('<span>'+$scope.employeearray[j].name+'</span><br>');
					$scope.newemployeearr.push($scope.employeearray[j]);
				//	console.log($scope.newemployeearr);
				}
			}
		}
	}
	}
	$scope.getclientcurr=function($clientid){
		$('.currency').empty(); 
		for(var i=0; i<$scope.clientarray.length; i++){
			if($scope.clientarray[i].id==$clientid){
				$('.currency').append('<span>'+$scope.clientarray[i].currency+'</span>');
				//	$scope.newemployeearr.push($scope.employeearray[j]);
			}
		}
	}
	//////Check Designation dublicate//////////////
	$scope.getemployeedesig=function($selectempid,$index){
	 //console.log($index);
		for(var i=0; i<$scope.billingemployee.length; i++){
		//$scope.newemployeearr[i].id="";
			if($scope.billingemployee[i].selectemployeeid==$selectempid && $index!=i){
				alert("Already selected");
				$scope.billingemployee[$index].selectemployeeid="";
				$scope.billingemployee[$index].empdesigid="";
			return;
			}else{
				for(var i=0; i<$scope.newemployeearr.length; i++){
					if($scope.newemployeearr[i].id==$selectempid){
						$scope.billingemployee[$index].empdesigid=$scope.newemployeearr[i].designationname;
					}
				}
			}
		}
	}
	$scope.timediff = function($leaveto){
		//alert($leaveto);
		//$scope.resumptiondate="";
		var fromdate=$("#"+$leaveto+"actstart").datetimepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#'+$leaveto+'actend').datetimepicker("remove");
		$('#'+$leaveto+'actend').datetimepicker({
			startDate: fromdate
			
		});
	}
	$scope.timediffest = function(){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
	}
	$scope.onfetchprojectDetail =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'timesheet/getprojectdetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				
				$scope.company=data.data[0]['company'];
				$scope.title=data.data[0]['project_title'];
				$scope.projecttypeid=data.data[0]['projecttypeid'];
				$scope.milestoneids=data.data[0]['milestoneids'];
				$scope.fromdate=data.data[0]['start_date'];
				console.log($scope.fromdate);
				$scope.todate=data.data[0]['completed_date'];
				$scope.fromdate1=data.data[0]['start_date'];
				$scope.todate1=data.data[0]['completed_date'];
				
				$scope.desc=data.data[0]['project_desc'];
				$scope.projectstatus=data.data[0]['project_status'];
				$scope.projectdocs=data.data[0]['ProjectDoc'];
				$scope.file=data.data[0]['ProjectDoc'];
				$scope.billablests=data.data[0]['billablests'];
				$scope.ownerid=data.data[0]['owner_id'];
				$scope.projectlead=data.data[0]['projectlead'];
				$scope.clientmanager=data.data[0]['clientmanager'];
				$scope.employeeid=data.data[0]['assigned_to'];
				//console.log($scope.employeeid);
				$scope.billingmethod=data.data[0]['billingmethod'];
				$scope.budget=data.data[0]['budget'];
				$scope.costproject=data.data[0]['costproject'];
				//$scope.onfetchjuniours($scope.ownerid);
				
				$scope.onfetchmilestones($scope.projecttypeid);
				$scope.changedatelebel($scope.projectstatus);
				
				
				$timeout(function(){
					//$scope.getclientcurr($scope.company);
					$scope.getSelectEmployee();
					$scope.getSelectMilestone();
				//console.log($scope.selectedcolumnsarr);
				}, 2000); 
				 $scope.billingemployee=[{selectemployeeid:"", empdesigid:"", employeecost:0}];
				 if(data.data[0]['billingemployee']!=undefined){
					if(data.data[0]['billingemployee'].length>0){
						$scope.billingemployee=data.data[0]['billingemployee'];
					}
				 }
				$scope.billingmilestone=[{milestoneid:"", milestonecost:0}];
				if(data.data[0]['billingmilestone']!=undefined){
					if(data.data[0]['billingmilestone'].length>0){
						$scope.billingmilestone=data.data[0]['billingmilestone'];
					}
				}
				$timeout(function(){
					//$scope.getclientcurr($scope.company);
					$scope.getbilling($scope.billablests);
				
				}, 2000); 
				/* var temparr= data.data[0]['assigned_to'];
				$timeout(function(){
					for ( var x=0; x<temparr.length; x++){
						for ( var i=0; i<$scope.juniourarr.length; i++){
							if ($scope.juniourarr[i].id == temparr[x]){ 
								$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.juniourarr.remove(i);
							}
						}
					}
					//$scope.fillassignto($scope.assignempid);
				}, 5000);   */
				
				/* var temparr1= data.data[0]['milestones'];
				$timeout(function(){
					for ( var x=0; x<temparr1.length; x++){
						for ( var i=0; i<$scope.milestonearray.length; i++){
							if ($scope.milestonearray[i].id == temparr1[x]){ 
								$scope.selectedcolumnsarrMilestone.insert($scope.selectedcolumnsarrMilestone.length,$scope.milestonearray[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.milestonearray.remove(i);
							}
						}
					}
					console.log($scope.milestonearray);
					//$scope.fillassignto($scope.assignempid);
				}, 5000); */
				
				/* $timeout(function(){
				
				//console.log($scope.selectedcolumnsarr);
				}, 5000);   */
               // $scope.juniourarr=data.data;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	///////////Reopened Project History////////////
	$scope.reopenedhistory = function($id,$projectname) {
		$scope.title=$projectname;
		$scope.projectid=$id;
		$scope.hastrue=true;
		$http({
			url : path+'timesheet/getReopenedHistory/'+$id,
			method: "POST",
			//data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			if(data.status) {
				
				$scope.ReopenedProjectList=data.data;
				
			}else{
				$scope.ReopenedProjectList=[];
			}
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
		/* errorMessage("error: "+$scope.status); */
			$scope.hastrue=false;
		});
		
	}
	
	$scope.oncreate = function($val){
		//var json = angular.toJson($scope.timesheetarray);	
		var billingemployee = angular.toJson($scope.billingemployee);	
		var billingmillestone = angular.toJson($scope.billingmilestone);
	
		$scope.hastrue=true;
		var xsrf = $.param({ company: $scope.company, title : $scope.title, projecttypeid : $scope.projecttypeid, milestoneids : $scope.milestoneids, fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, projectstatus : $scope.projectstatus,  billablests : $scope.billablests, ownerid: $scope.ownerid , employeeid:$scope.employeeid , billingmethod:$scope.billingmethod , budget:$scope.budget , costproject:$scope.costproject , billingemployee:billingemployee,  billingmillestone: billingmillestone, clientmanager:$scope.clientmanager, projectlead:$scope.projectlead});
		$http({
			url: path+'timesheet/createproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            successMessage(data.successMsg);
				$scope.projectid=data.data[0]['projectid'];
			   if($scope.files != ""){
					$scope.uploadFile($val);
				}	
			   $scope.ownerid=0;
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.desc="";
			   $scope.title="";
			   $scope.employeeid="";
			   $scope.locationname="";
			   $scope.budget="";
			    $scope.projectstatus=0;
			   $scope.company="";
			   $scope.selectedcolumnsarr=[];
				$scope.juniourarr=[];
				
				 if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					//$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
					$timeout(function(){window.open(path+"milestone/addmilestone/"+$scope.projectid, "_self");}, timeo);
				} 				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.model = {
        name: "",
        comments: ""
	};
    //an array of files selected
    $scope.files = [];
	$scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
		 });
    });
	$scope.uploadFile = function($val) {
		var emp=$scope.projectid;
		//alert(emp);
		$scope.hastrue=true;
		$http({
			method: 'POST',
			url: path+"timesheet/uploadprojectdocs",
			headers: { 'Content-Type': undefined },
			transformRequest: function (data) {
				var formData = new FormData();
				formData.append("model", angular.toJson(data.model));
				//now add all of the assigned files
				for (var i = 0; i < data.files.length; i++) {
					//add each file to the form data and iteratively name them
					formData.append("file" + i, data.files[i]);
				}
				formData.append('projectid', emp);
				return formData;
			},
			//Create an object that contains the model and files which will be transformed
			// in the above transformRequest method
			data: { model: $scope.model, files: $scope.files }
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($val){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"milestone/addmilestone/"+$scope.projectid, "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
    };
	
	$scope.onupdate = function($val) { 
		$scope.hastrue=true;
		var billingemployee = angular.toJson($scope.billingemployee);	
		var billingmillestone = angular.toJson($scope.billingmilestone);
		//console.log($scope.employeeid);
		var xsrf = $.param({ company: $scope.company, title : $scope.title, projecttypeid : $scope.projecttypeid, milestoneids : $scope.milestoneids, fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, projectstatus : $scope.projectstatus,  billablests : $scope.billablests, ownerid: $scope.ownerid , employeeid:$scope.employeeid , billingmethod:$scope.billingmethod , budget:$scope.budget , costproject:$scope.costproject , billingemployee:billingemployee,  billingmillestone: billingmillestone,project_id:$scope.projectid, clientmanager:$scope.clientmanager, projectlead:$scope.projectlead});
	
		$http({
			url: path+'timesheet/updateproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
		 if($scope.files!=""){
					$scope.uploadFile($scope.projectid);
					//window.open(path+"setup/users", "_self");
				}
			if(data.status){
                            
				successMessage(data.successMsg);
				
		       $scope.ownerid=0;
			   $scope.fromdate="";
			   $scope.todate="";
			   $scope.desc="";
			   $scope.title="";
			   $scope.projectstatus=0;
			   $scope.locationname="";
			   $scope.budget="";
			   $scope.company="";
			   $scope.selectedcolumnsarr=[];
				$scope.juniourarr=[];
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"timesheet/projectlist", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/////////////////get time format and set time/////
	$scope.settotaltime= function($index) {
		//alert($index);//alert($edate);
		var strt = $("#"+$index+"actstart").datetimepicker('getDate');
		var end = $("#"+$index+"actend").datetimepicker('getDate');
		
		var a = new Date(strt);
		var b = new Date(end);
		
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		/* var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		var day = Math.floor((utc2 - utc1) / _MS_PER_DAY);
		 */
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
		//console.log($scope.TaskList);
		for(var i=0;i<$scope.timesheetarray.length;i++){
			if($index == i){
			$scope.timesheetarray[i]['totaltime1']=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.timesheetarray[i]['totaltime']=days1+':'+minutes;
			}
		
		}
	}
	$scope.milestonedublicacy=function($milstoneid,$index){
		for(var i=0; i<$scope.billingmilestone.length; i++){
			if($scope.billingmilestone[i].milestoneid==$milstoneid && $index!=i){
				alert("Already selected");
				$scope.billingmilestone[$index].milestoneid="";
			return;
			}
		}
	}
	$scope.setbudgetval= function($billingmethod){
		$scope.billingmethod=$billingmethod;
		if($billingmethod==1){
			$scope.costproject=$scope.budget;	
		}
		if($billingmethod==2){
			$scope.costproject="";
		}
	}
});

app.controller('timesheetdashCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.shiftid=0;
	$scope.chart1date="";
	$scope.attendancearray=[];
	$scope.latecomerarray=[];
	$scope.filscalid=0;
	$scope.date1="";
	$scope.mails="";
	
	function auto_save_pdf(){
		$timeout(function(){
			$scope.save_pdf();
		}, 3000);
	}
	var theme = {
          color: [
              '#26B99A', '#34495E', '#BDC3C7', '#3498DB',
              '#9B59B6', '#8abb6f', '#759c6a', '#bfd3b7'
          ],
		title: {
              itemGap: 8,
              textStyle: {
                  fontWeight: 'normal',
                  color: '#408829'
              }
          },

          dataRange: {
              color: ['#1f610a', '#97b58d']
          },

          toolbox: {
              color: ['#408829', '#408829', '#408829', '#408829']
          },

          tooltip: {
              backgroundColor: 'rgba(0,0,0,0.5)',
              axisPointer: {
                  type: 'line',
                  lineStyle: {
                      color: '#408829',
                      type: 'dashed'
                  },
                  crossStyle: {
                      color: '#408829'
                  },
                  shadowStyle: {
                      color: 'rgba(200,200,200,0.3)'
                  }
              }
          },

          dataZoom: {
              dataBackgroundColor: '#eee',
              fillerColor: 'rgba(64,136,41,0.2)',
              handleColor: '#408829'
          },
          grid: {
              borderWidth: 0
          },

          categoryAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },

          valueAxis: {
              axisLine: {
                  lineStyle: {
                      color: '#408829'
                  }
              },
              splitArea: {
                  show: true,
                  areaStyle: {
                      color: ['rgba(250,250,250,0.1)', 'rgba(200,200,200,0.1)']
                  }
              },
              splitLine: {
                  lineStyle: {
                      color: ['#eee']
                  }
              }
          },
          timeline: {
              lineStyle: {
                  color: '#408829'
              },
              controlStyle: {
                  normal: {color: '#408829'},
                  emphasis: {color: '#408829'}
              }
          },

          k: {
              itemStyle: {
                  normal: {
                      color: '#68a54a',
                      color0: '#a9cba2',
                      lineStyle: {
                          width: 1,
                          color: '#408829',
                          color0: '#86b379'
                      }
                  }
              }
          },
          map: {
              itemStyle: {
                  normal: {
                      areaStyle: {
                          color: '#ddd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  },
                  emphasis: {
                      areaStyle: {
                          color: '#99d2dd'
                      },
                      label: {
                          textStyle: {
                              color: '#c12e34'
                          }
                      }
                  }
              }
          },
          force: {
              itemStyle: {
                  normal: {
                      linkStyle: {
                          strokeColor: '#408829'
                      }
                  }
              }
          },
          chord: {
              padding: 4,
              itemStyle: {
                  normal: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  },
                  emphasis: {
                      lineStyle: {
                          width: 1,
                          color: 'rgba(128, 128, 128, 0.5)'
                      },
                      chordStyle: {
                          lineStyle: {
                              width: 1,
                              color: 'rgba(128, 128, 128, 0.5)'
                          }
                      }
                  }
              }
          },
          gauge: {
              startAngle: 225,
              endAngle: -45,
              axisLine: {
                  show: true,
                  lineStyle: {
                      color: [[0.2, '#86b379'], [0.8, '#68a54a'], [1, '#408829']],
                      width: 8
                  }
              },
              axisTick: {
                  splitNumber: 10,
                  length: 12,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              axisLabel: {
                  textStyle: {
                      color: 'auto'
                  }
              },
              splitLine: {
                  length: 18,
                  lineStyle: {
                      color: 'auto'
                  }
              },
              pointer: {
                  length: '90%',
                  color: 'auto'
              },
              title: {
                  textStyle: {
                      color: '#333'
                  }
              },
              detail: {
                  textStyle: {
                      color: 'auto'
                  }
              }
          },
          textStyle: {
              fontFamily: 'Arial, Verdana, sans-serif'
          }
      };
	
	$scope.onfetchdashboard=function($val,$type)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid:$scope.filscalid, type:$type,date:$scope.date1});
		$http({
			url: path+'timesheet/gettimesheetDashboard',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.mails=data.senioremail;
				$('#bar-chart3').html('');
				$('#bar-chart2').html('');
				$('#bar-chart4').html('');
				$('#bar-chart5').html('');
				$('#bar-chart6').html('');
				$('#bar-chart7').html('');
				$scope.date1=data.date;
				$scope.fiscalformat=data.fiscal_format;
				$scope.monthview=data.curmonth;
				//$scope.fiscalview =data.data['financialyear'][0]['name'];
				//$scope.chart1date = data.data['chartdata1date'];
				$scope.filscalid=data.filscalid;
				//alert($scope.date1);
			//	console.log(data.data['chartdata4name']);
				var bar ="";
				
		    var echartPie = echarts.init(document.getElementById('chart9'), theme);

      echartPie.setOption({
        tooltip: {
          trigger: 'item',
          formatter: "{a} <br/>{b} : {c} "
        },
        
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              type: ['pie', 'funnel'],
              option: {
                funnel: {
                  x: '25%',
                  width: '50%',
                  funnelAlign: 'right',
                  max: 1548
                }
              }
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        series: [{
          name: '',
          type: 'pie',
          
          data: data.data['chartdata1']
        }]
      });
				
				
	var echartPie = echarts.init(document.getElementById('bar-chart77'), theme);

      echartPie.setOption({
        tooltip: {
          trigger: 'item',
          formatter: "{a} <br/>{b} : {c} "
        },
        
        toolbox: {
          show: true,
          feature: {
            magicType: {
              show: true,
              type: ['pie', 'funnel'],
              option: {
                funnel: {
                  x: '25%',
                  width: '50%',
                  funnelAlign: 'right',
                  max: 1548
                }
              }
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: true,
        series: [{
			radius : '50%',
          name: '',
          type: 'pie',
          
          data: data.data['chartdata7']
        }]
      });

	  
	var echartPie = echarts.init(document.getElementById('bar-chart33'), theme);
    echartPie.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: ['No. of Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata3name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimated Time'],
          type: 'bar',
          data: data.data['esttotal'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
        {
          name: ['Actual Time'],
          type: 'bar',
          data: data.data['actualtime'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
        ]
      });
		
		  var echartBar = echarts.init(document.getElementById('bar-chart44'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        
        },
        legend: {
          data: ['No. of Projects']
        },
       toolbox: {
          show: true,
          
          feature: {
          	
		   magicType: {
		   	
              show: true,
              title: {
              	
                line: 'Line',
                bar: 'Bar'
              },
              
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        
        xAxis: [{
        	
          type: 'category',
		  axisLabel:{
			  show:true,
			  interval:0,
			  rotate:60,
			  margin:8,
			  formatter:null
		  },
          data: data.data['chartdata4name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Team Members'],
          type: 'bar',
          data: data.data['chartdata4total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }]
      });
	  
	  
	   var echartBar = echarts.init(document.getElementById('bar-chart22'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
          data: data.data['chartdata2name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimate hours'],
          type: 'bar',
          data: data.data['chartdata2totalest'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
        {
          name: ['Logged hours'],
          type: 'bar',
          data: data.data['chartdata2loggedtotal'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
        ]
      });
    	
	var echartBar = echarts.init(document.getElementById('bar-chart55'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
		  axisLabel:{
			  show:true,
			  interval:0,
			  rotate:60,
			  margin:8,
			  formatter:null
		  },
          data: data.data['chartdata5name']
		 
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimated Time'],
          type: 'bar',
          data: data.data['chartdata5total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
		{
          name: ['Actual Time'],
          type: 'bar',
          data: data.data['chartdata5count'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
		]
      });
		
		var echartBar = echarts.init(document.getElementById('bar-chart66'), theme);

      echartBar.setOption({
        tooltip: {
        trigger: 'axis'
        },
        legend: {
          data: [' Projects']
        },
       toolbox: {
          show: true,
          feature: {
		   magicType: {
              show: true,
              title: {
                line: 'Line',
                bar: 'Bar'
              },
              type: ['line', 'bar']
            },
            restore: {
              show: true,
              title: "Restore"
            },
            saveAsImage: {
              show: true,
              title: "Save Image"
            }
          }
        },
        calculable: false,
        xAxis: [{
          type: 'category',
		  axisLabel:{
			  show:true,
			  interval:0,
			  margin:8,
			  formatter:null
		  },
          data: data.data['chartdata6name']
        }],
        yAxis: [{
          type: 'value'
        }],
        series: [{
          name: ['Estimated Time'],
          type: 'bar',
          data: data.data['chartdata6total'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        },
		{
          name: ['Actual Time'],
          type: 'bar',
          data: data.data['chartdata6count'],
          markPoint: {
            data: [{
              type: 'max',
              name: 'Maximun'
            }, {
              type: 'min',
              name: 'Minimum'
            }]
          },
          markLine: {
            data: [{
              type: 'average',
              name: 'Average'
            }]
          }
        }
		]
      });
		
		$scope.hastrue=false;
		//auto_save_pdf();
			}
			else{
					errorMessage(data.errorMsg);
					}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
			$scope.hastrue=false;
	}
	
	var
	form = $('.form'),
	cache_width = form.width(),
	a3  =[ 841.89, 1190.55];  // for a4 size paper width and height
	
	$scope.save_pdf=function()
	{
		getCanvas().then(function(canvas){
		var
		img = canvas.toDataURL("image/png"),
		doc = new jsPDF({
          unit:'px',
          format:'a3'
        });
        doc.addImage(img, 'JPEG', 20, 20);
		
		//window.open(img);
		/* console.log(doc.output('datauri')); */

		var pdfencoded=doc.output('blob');
		//alert($scope.mails);
		var mails=$scope.mails;
		//alert(pdfencoded);
		var fd = new FormData();     // To carry on your data  
		fd.append('mypdf',pdfencoded);
		fd.append('mail',mails);
		$http({
			url: path+'report/showpdf',
			method: "POST",
			data: fd,
			 headers: { 'Content-Type': undefined }
		}).success(function (data, status, headers, config) {
			//errorMessage( $scope.leavevalidsts);
			if(data.status){
				successMessage(data.successMsg);
			   $scope.hastrue=false;				
			}else{
				errorMessage(data.errorMsg);
				 
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
       // doc.save('Employee_dashboard.pdf');
        form.width(cache_width);
	});
	}
	
function getCanvas(){
	
	form.width((a3[0]*1.33333) -80).css('max-width','none');
	return html2canvas(form,{
    	imageTimeout:2000,
    	removeContainer:true
		
    });
}
	
});
/////////////////Clients Controller Start From Here/////////
app.controller('clientCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.clientid=0;
	$scope.employername="";
	$scope.clientmanager="";
		$scope.contactperson="";
		$scope.emailaddress='';
		$scope.contactnumber='';
		$scope.address='';
		$scope.descriptions='';
		$scope.website='';
		$scope.country='';
		$scope.city='';
		$scope.currency='';
		$scope.currencyarr=[];
		$scope.countryList=[];
		$scope.cityList=[];
		$scope.projectstatus1="";
		$scope.startdate="";
		$scope.enddate="";
		onfetch('other',5);
		onfetch('leave/getallleaveemployee',4);
		onfetch('country/getallcountry',15);
		onfetch('currency/getall',2);
		onfetch('client/getallclients',8);
		function onfetch($val, $id) {
		$scope.hastrue=true;
		var xsrf = $.param({employeeid: $scope.employeeid});
		$http({
			url: path+$val,
			method: "POST", data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==2){
					$scope.currencyarr=[];
					$scope.currencyarr=data.data;
				}
				else if($id==4){
					$scope.employeearray=[];
					$scope.employeearray=data.data;
				}else if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray=[];
					$scope.cityarray=data.data;
				}else if($id==8){
						$scope.clientarray=[];
						$scope.clientarray=data.data;
				}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						$scope.projectstatus=$scope.otherarray[0]['id'];
				}
			}
			$timeout(function() {
						$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);   
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	
	/*$scope.getdata = function($id){
		//alert($id);
		$scope.startdate=$('#startdate').val();
		$scope.enddate=$('#enddate').val();
		//alert($scope.startdate);
		$scope.hastrue=true;
		var xsrf = $.param({client: $scope.client,startdate:$scope.startdate,enddate:$scope.enddate});
		//alert(xsrf);
		$http({
			url: path+'client/getdata/'+$id,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//alert(data);
				
					
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}*/
	$scope.getdata=function($id)
	{   
	     
		$scope.startdate=$('#startdate').val();
		$scope.enddate=$('#enddate').val();
		$scope.hastrue=true;
		var xsrf = $.param({client: $scope.client,startdate:$scope.startdate,enddate:$scope.enddate});
		
		$http({
			url: path+'client/getdata/'+$id,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
		  	    
				if(data.status){
					$scope.clientdashboard=[];
					$scope.clientdashboard=data.data['chartdata1'];
					console.log(data.data['chartdata1']);
					// BAR CHART
        			var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, stacked:true,
						 xLabelAngle: -90, //ymax:100,
					 // xLabels: 'projectname', postUnits:'%',
					 // xLabelAngle: -90, ymax:100,
					  data: data.data['chartdata1'],
					  barColors: ['#306aa0','#669baa','#a3a2a8'],
					  xkey: 'projectname',
					  ykeys: ['totalestimatedtime','totalactualtime'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Estimated Hours','Logged Hours'],
					 // gridTextSize: 10,
					  hideHover: 'auto'
					});
				}
				else{
				//errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.getcity = function($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.country,$val);
		}
	}
	$scope.getcurrency = function($countryid) {
		$scope.hastrue=true;
		var xsrf = $.param({countryid: $countryid});
		$http({
			url: path+'currency/index',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			
				console.log(data[0]['id']);
				$scope.currency=data[0]['id'];
				
					
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	
	}
	function getcity1($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.country,$val);
		}
	}
	$scope.onfetchclientDetail =function($id,$val) {
	$scope.hastrue=true;
	var xsrf = $.param({clientid: $id});
	$http({
        url: path+'client/getaclient',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.clientid=data.data[0]['id'];
				$scope.employername=data.data[0]['name'];
				$scope.clientmanager=data.data[0]['clientmanager'];
				$scope.contactperson=data.data[0]['cperson'];
				$scope.emailaddress=data.data[0]['email'];
				$scope.contactnumber=data.data[0]['cnumber'];
				$scope.address=data.data[0]['address'];
				$scope.projectsts=data.data[0]['projectsts'];
				
				//$scope.landmark=data.data[0]['landmark'];
				//$scope.zipcode=data.data[0]['zipcode'];
				$scope.country=data.data[0]['countryid'];
				$scope.city=data.data[0]['cityid'];
				$scope.currency=data.data[0]['currency'];
				$scope.descriptions=data.data[0]['aboutcompany'];
				$scope.website=data.data[0]['companywebsite'];
				getcity1(16);
				if($val==1){
					$timeout(function(){$scope.GetClientDashboard($id);}, timeo);
					
				}
			}
		
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	/* $scope.getfilterClient = function()
	{
		
		$scope.startdate=$('#startdate').val();
		$scope.enddate=$('#enddate').val();	
	
		$scope.hastrue=true;
		var xsrf = $.param({ fromdate:$scope.from,startdate:$scope.startdate});
		$http({
			url: path+'client/'+$val,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				
				$scope.show=true;
				var fromdate=data.startdate;
				$scope.from=fromdate;
				var to=data.enddate;
				
				$scope.currentmonth = fromdate;
				console.log($scope.currentmonth);
			
				if($val==22)
				$('#currentmonth').text($scope.currentmonth);
				$scope.leavereportarr=data.data;
				if($val==1)
				document.getElementById('output').innerHTML=$scope.leavereportarr;
				
			}else{
				data.show=false;
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
           			$scope.hastrue=false;
		});

	} 
 */
	$scope.GetClientDashboard=function($id){
		$scope.hastrue=true;
		$scope.startdate=$('#startdate').val();
		$scope.enddate=$('#enddate').val();
		var xsrf = $.param({clientid: $id,projectstatus: $scope.projectstatus1,startdate:$scope.startdate,enddate:$scope.enddate});
		
		$http({
			url: path+"client/GetClientDashboard",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		  	//alert(data);
			if(data.status){
				$scope.clientdashboard=[];
				$scope.clientdashboard=data.data['chartdata1'];
				//console.log($scope.clientdashboard);
				$scope.startdate=data.startdate;
				$scope.enddate=data.enddate;
				var start = moment($scope.startdate);
				var end = moment($scope.enddate);
				function cb(start, end) {
					$('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
				}
				$('#reportrange').daterangepicker({
					startDate: start,
					endDate: end,
					ranges: {
					'Today': [moment(), moment()],
					'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
					'Last 7 Days': [moment().subtract(6, 'days'), moment()],
					'Last 30 Days': [moment().subtract(29, 'days'), moment()],
					'This Month': [moment().startOf('month'), moment().endOf('month')],
					'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					}
					},cb);
					cb(start, end);
						 $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
						$('#startdate').val(picker.startDate.format('YYYY-MM-DD'));
						$('#enddate').val(picker.endDate.format('YYYY-MM-DD'));
							
					});
					$('#reportrange').on('cancel.daterangepicker', function(ev, picker) {
					$('#startdate').val('');
						$('#enddate').val('');
					});	  
					// BAR CHART
					$("#bar-chart2").html("");
        			var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, stacked:true,
						 xLabelAngle: -90, //ymax:100,
					 // xLabels: 'projectname', postUnits:'%',
					 // xLabelAngle: -90, ymax:100,
					  data: data.data['chartdata1'],
					  barColors: ['#306aa0','#669baa','#a3a2a8'],
					  xkey: 'projectname',
					  ykeys: ['totalactualtime','totalestimatedtime'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Estimated Hours','Logged Hours'],
					 // gridTextSize: 10,
					  hideHover: 'auto'
					});
				}
				else{
				//errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.getId = function($id){
		$scope.clientid=$id;
	}
	//$scope.admlmt="";
	$scope.ondelete =function(){
		$scope.hastrue=true;
		$http({
			url: path+'client/deleteclient/'+$scope.clientid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				/* //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers; */$scope.hastrue=false;
		});
	}
	
	$scope.onchangeadmin =function($id){
		$scope.hastrue=true;
		$http({
			url: path+'client/changeclientstatus/'+$id,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				 //successMessage(data.successMsg);
				 table.draw();
			}else{
				//errorMessage(data.errorMsg);
			}
			$scope.userid=0;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				/* //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers; */$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({employername: $scope.employername, clientmanager: $scope.clientmanager, currency: $scope.currency, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber,  emailaddress: $scope.emailaddress,  country: $scope.country, city: $scope.city,website:$scope.website});
		$http({
			url: path+'client/createclient',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
				successMessage(data.successMsg);
				
				$scope.employername="";
				$scope.clientmanager="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.currency="";
				$scope.country="";
				$scope.city="";
				$scope.website="";
				$scope.clientid=0;
				if($val==1){
				$timeout(function(){window.open(path+"client/index", "_self");}, timeo);
				}if($val==2){
				
				}
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	$scope.onupdate = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({clientid: $scope.clientid, employername: $scope.employername,clientmanager: $scope.clientmanager, contactperson: $scope.contactperson, contactnumber: $scope.contactnumber, emailaddress: $scope.emailaddress,  country: $scope.country, city: $scope.city,  website:$scope.website, currency:$scope.currency });
		  $http({
				url: path+'client/updatedeclient',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			  }).success(function (data, status, headers, config) {
				
			if(data.status){
				//alert(data.successMsg);
				successMessage(data.successMsg);
				$scope.employername="";
				$scope.clientmanager="";
				$scope.contactperson="";
				$scope.emailaddress="";
				$scope.contactnumber="";
				$scope.currency="";
				$scope.country="";
				$scope.city="";
				$scope.website="";
				$scope.clientid=0;
				
				if($val==1){
					//window.open(path+"setup/employer", "_self");
					$timeout(function(){window.open(path+"client/index", "_self");}, timeo);
				}
				
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});
////////////////////////////////////////////// Start Project Type Controller //////////////////////////////////////////////
app.controller('ProjectTypeCtrl', function($scope, $http, $timeout) {
	 
	$scope.projecttypeid=0;
	$scope.projecttypename="";
	$scope.projecttypedescription="";
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
    $scope.milestonearray = [{milestoneid: 0, name:"", desc:""}];
	
	$scope.addmilestone = function($i){
		var len = $scope.milestonearray.length-1;
		if($scope.milestonearray[len]['name']==""){
			errorMessage("Please fill milestone name");
		}else{
			$scope.milestonearray.insert($i+1,{milestoneid:0, name:"", desc:""});
		}
	}
	
	$scope.removemilestone = function($i){
		$scope.milestonearray.remove($i);
		if($scope.milestonearray.length==0){
			$scope.milestonearray.insert($i,{milestoneid:0, name:"", desc:""});
		}
	}
	
	$scope.onfetch= function($projecttypeid){
		$scope.projecttypeid = $projecttypeid;
		$scope.hastrue=true;
		$http({
			url: path+"timesheet/getaProjectType/"+$projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.projecttypename=data.data[0].name;		
				$scope.projecttypedescription=data.data[0].desc;
				$scope.milestonearray=data.data[0].milestone;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val){
		var jsonData8 = angular.toJson($scope.milestonearray);
	
		$scope.hastrue=true;
		var xsrf = $.param({ milestone:jsonData8, projecttypename:$scope.projecttypename, projecttypedescription:$scope.projecttypedescription });
		$http({
			url: path+'timesheet/createProjectType',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$scope.projecttypeid=0;
					$scope.projecttypename="";
					$scope.projecttypedescription="";
					$scope.milestonearray = [{milestoneid:0, name:"", desc:""}];
						if($val==1)
						$timeout(function(){window.open(path+"timesheet/projecttypelist", "_self");}, timeo);
				}else{
					errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				$scope.hastrue=false;
		}); 
 }
 
 	$scope.onupdate = function($val)
	{	
		var jsonData8 = angular.toJson($scope.milestonearray);
			$scope.hastrue=true;
		var xsrf = $.param({ milestone:jsonData8, projecttypename:$scope.projecttypename, projecttypedescription:$scope.projecttypedescription, projecttypeid:$scope.projecttypeid });
		$http({
			url: path+'timesheet/updateProjectType',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);	
					//window.open(path+"salary/generatesalary", "_self");
					$scope.projecttypeid=0;
					$scope.projecttypename="";
					$scope.projecttypedescription="";
					$scope.milestonearray = [{milestoneid:0, name:"", desc:""}];
					if($val==1)
					$timeout(function(){window.open(path+"timesheet/projecttypelist", "_self");}, timeo);
				}
				else{
				errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	$scope.getId = function($id,$projecttypeid) {
		$scope.milestoneid=$id;
		$scope.projecttypeid=$projecttypeid;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'timesheet/deleteDefaultMilestone/'+$scope.milestoneid+'/'+$scope.projecttypeid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
});
///////////////////////////////////////////// Ending Project Type Controller ///////////////////////////////////////////////
app.controller('Timesheetctrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.TaskList=[];
	$scope.marks="";
	$scope.remark="";
	$scope.empList=[];
	$scope.totalmarks=0;
	$scope.date="";
	$scope.todate="";
	$scope.fromdate="";
	$scope.desc="";
	$scope.taskid=0;
	$scope.projectid=0;
	

    onfetch('profile/getallproject1',1);
    onfetch('profile/getalltask',2);

	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				if($id==1){
					$scope.projectarray=[];
					$scope.projectarray=data.data;
				}else if($id==2){
					$scope.taskarray=[];
					$scope.taskarray=data.data;
				}
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
	$scope.onfetchtimesheet =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({timesheetid: $id});
		$http({
			url: path+'timesheet/getatimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.projectid=data.data[0]['project_id'];
				$scope.fromdate=data.data[0]['start_date'];
				$scope.todate=data.data[0]['end_date'];
				$scope.desc=data.data[0]['description'];
				$scope.taskid=data.data[0]['task_id'];				
				$scope.total_time=data.data[0]['total_time'];				
				$scope.hastrue=false;		
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}else{
			$scope.hastrue=false;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	

});

app.controller('Milestonectrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.date="";
	$scope.desc="";
	$scope.title="";
	$scope.milestoneid=0;
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid="";
	$scope.fromdate="";
	$scope.durationminutes=0;
	$scope.durationday=0;
	$scope.durationhours=0;
	$scope.todate="";
	$scope.projectstartdate="";
	$scope.projectenddate="";
	$scope.milestonearray=[];
	//$scope.leavevalidsts=[];
	$scope.projectarray=[];
	$scope.setminutesvalue=function($index){
		var minutes= $("#"+$index+"durationminutes").val();
		console.log(minutes);
		if(minutes>=60){
		for(var j=0; j<$scope.newmilestonearr.length; j++){
			$scope.newmilestonearr[j].durationminutes=0;
			//$scope.setdate($projectid,j);
		}
		}
	}
	onfetchproject();
	
	function onfetchproject(){
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getallproject",
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
					$scope.projectarray=data.data;		
						$scope.getproject($scope.projectid);
						/* $timeout(function() {
						$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);  */  
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.newmilestonearr=[{projectid:"", title:"", durationday:0, durationhours:0,durationminutes:0, desc:""}];
	$scope.addmile = function($i){
		var len = $scope.newmilestonearr.length-1;
		if($scope.newmilestonearr[len]['projectid']==""  || $scope.newmilestonearr[len]['title']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.newmilestonearr.insert($i,{projectid:"", title:"",durationday:0, durationhours:0,durationminutes:0, desc:""});
			$scope.getproject($scope.projectid);
		}
	}
	$scope.removemile = function($i){
		$scope.newmilestonearr.remove($i);	
		 if($scope.newmilestonearr.length==0){
			$scope.newmilestonearr.insert($i,{projectid:"", title:"", durationday:0, durationhours:0,durationminutes:0, desc:""});
		} 
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};

	$scope.onfetchmilestoneDetail =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({milestoneid: $id});
		$http({
			url: path+'milestone/getmilestonedetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.newmilestonearr=[{projectid:"", title:"", durationday:0, durationhours:0,durationminutes:0, desc:""}];
				console.log(data.data.length);
				if(data.data.length>0){
						$scope.newmilestonearr=data.data;
					}
				//$scope.newmilestonearr= data.data;
				
				$scope.projectid=data.data[0]['projectid'];
				//console.log(data.data[0]['jobchild']);
				/* $scope.title=data.data[0]['title'];
				$scope.fromdate=data.data[0]['startdate'];
				$scope.todate=data.data[0]['enddate'];
				$scope.desc=data.data[0]['desc'];
				//$scope.desc=data.data[0]['assignee_id'];
			    $scope.projectid=data.data[0]['projectid']; */
			//	$scope.getproject($scope.projectid);
				$scope.getDefaultMilestoneByProject($scope.projectid);
				//$scope.setdate($scope.projectid);
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val){
		var milestone = angular.toJson($scope.newmilestonearr);

		$scope.hastrue=true;
		//var xsrf = $.param({ projectid: $scope.projectid , desc : $scope.desc,fromdate: $scope.fromdate , todate : $scope.todate ,  title : $scope.title});
		var xsrf = $.param({ milestone : milestone});
		$http({
			url: path+'milestone/createmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
			   
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					$timeout(function(){window.open(path+"milestone/milestonelist/1", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onupdate = function($val) { 
		$scope.hastrue=true;
		var milestone = angular.toJson($scope.newmilestonearr);	
		var xsrf = $.param({milestone : milestone , milestoneid:$scope.milestoneid});
		$http({
			url: path+'milestone/updatemilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                successMessage(data.successMsg);
				/* $scope.projectid=0;
				$scope.milestoneid=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
			   $scope.title=""; */
			   //$scope.milestonearray=[];
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					//$timeout(function(){window.open(path+"milestone/milestonelist", "_self");}, timeo);
					$timeout(function(){window.history.back();}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.getId = function($id) {
		$scope.milestoneid=$id;
	}
	$scope.ondelete =function(){
		//alert($scope.projectid);
		$http({
			url: path+'milestone/deletemilestone/'+$scope.milestoneid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.setdate =function($id,$index){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getprojectdate',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.projectstartdate=data.data[0]['start_date'];
				$scope.projectenddate=data.data[0]['completed_date'];
                $("#"+$index+"fromdate").datepicker("remove");
				$("#"+$index+"fromdate").datepicker({
					startDate: new Date($scope.projectstartdate),
					endDate: new Date($scope.projectenddate)
				});
				$("#"+$index+"todate").datepicker("remove");
				$("#"+$index+"todate").datepicker({
					startDate: new Date($scope.projectstartdate),
					endDate: new Date($scope.projectenddate)
				});
			}
			else{
				$scope.projectstartdate="";
				$scope.projectenddate="";
				 $("#"+$index+"fromdate").datepicker("remove");
				$("#"+$index+"fromdate").datepicker({
					startDate: new Date($scope.projectstartdate),
					endDate: new Date($scope.projectenddate)
				});
				$("#"+$index+"todate").datepicker("remove");
				$("#"+$index+"todate").datepicker({
					startDate: new Date($scope.projectstartdate),
					endDate: new Date($scope.projectenddate)
				});
			}			
			//$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/* $scope.timediffest = function($leaveto){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		fromdate.setDate(fromdate.getDate());
		$('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate,
			endDate: new Date($scope.projectenddate)
		});
	} */
	$scope.timediff = function($index){
		//alert($leaveto);
		//$scope.resumptiondate="";
		var fromdate=$("#"+$index+"fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#'+$index+'todate').datepicker("remove");
		$('#'+$index+'todate').datepicker({
			startDate: fromdate,
			endDate: new Date($scope.projectenddate)
		});
	}
	$scope.milestonedublicacy=function($milstoneid,$index){
		for(var i=0; i<$scope.newmilestonearr.length; i++){
			if($scope.newmilestonearr[i].title==$milstoneid && $index!=i && $scope.newmilestonearr[i].projectid==$scope.newmilestonearr[$index].projectid){
				alert("Already selected");
				$scope.newmilestonearr[$index].title="";
				$scope.newmilestonearr[$index].desc="";
			return;
			}
		}
	}
		
	$scope.setmilestoneDesc=function($milstoneid,$index){
		
		for(var i=0; i<$scope.milestonearray[$index].length; i++){
			console.log($scope.milestonearray[$index]);
			console.log($scope.milestonearray[$index][i].id);
			if($scope.milestonearray[$index][i].id==$milstoneid){
				console.log($scope.milestonearray[$index][i].id);
				console.log($scope.milestonearray[$index][i].Description);
				$scope.newmilestonearr[$index].desc=$scope.milestonearray[$index][i].Description;
			return;
			}
		}
	}
	$scope.getproject=function($projectid){
	
		for(var i=0; i<$scope.projectarray.length; i++){
			if($scope.projectarray[i].id==$projectid){
				for(var j=0; j<$scope.newmilestonearr.length; j++){
					$scope.newmilestonearr[j].projectid=$scope.projectarray[i].id;
					$scope.type=1;
					$scope.getDefaultMilestoneByProject($scope.projectarray[i].id,j);
					//$scope.setdate($projectid,j);
				}
			}
		} 
	}
	/////////////////get default milestones for project/////
	$scope.getDefaultMilestoneByProject= function($id,$index=0)
	{
		
		var xsrf = $.param({projectid: $id});
		$scope.hastrue=true;
		$http({
			url: path+"milestone/getDefaultMilestoneByProject",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.milestonearray[$index]=data.data;
		}else{
			$scope.milestonearray[$index]=[];
		}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

////////////////////////////// Default milestone controller ////////////////////////////////////////////////////

app.controller('DefaultMilestonectrl', function($scope, $http, $timeout) {
	
	$scope.milestone="";
	$scope.description="";
	$scope.successmessage="";
	$scope.errormessage="";
	
		$scope.onsavedefaultmilestone = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({ milestone: $scope.milestone , description: $scope.description});
		$http({
			url: path+'milestone/saveDefaultMilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
			   $scope.successmessage=data.successMsg;
			    $scope.milestone="";
			   $scope.description="";
			  
				$scope.errormessage="";
			 if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					window.open(path+"milestone/getDefaultMilestone", "_self");
				}else{
					 table.draw();
				}				
				$scope.hastrue=false;
			}else{
				$scope.hastrue=false;
				errorMessage(data.errorMsg);
				$scope.errormessage=data.errorMsg;
					$scope.successmessage="";
			}
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
	$scope.getId = function($id) {
		$scope.defaultmilestoneid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'milestone/deletedefaultmilestone/'+$scope.defaultmilestoneid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.projectid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
		$scope.fetchDefaultMilestone =function($id){ 
		$scope.milestoneid=$id;
		 $scope.errormessage="";
		$scope.successmessage="";
		$scope.hastrue=true;
		var xsrf = $.param({milestoneid: $id});
		$http({
			url: path+'milestone/getdefaultmilestonebyid',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.milestone=data.data[0]['name'];
				$scope.description=data.data[0]['description'];
			    //console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}else{
				
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


		$scope.onupdate = function($val)
	{ 
		$scope.hastrue=true;
		
		var xsrf = $.param({milestoneid:$scope.milestoneid,  name: $scope.milestone , description: $scope.description});
		$http({
			url: path+'milestone/updatedefaultmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
				successMessage(data.successMsg);
				$scope.successmessage=data.successMsg;
				$scope.milestoneid=0;
				$scope.description="";
				$scope.milestone="";
				$timeout(function(){$('#myModal').modal('show');}, 300);
				$scope.errormessage="";
				if($val==1){
					//window.open(path+"timesheet/leaveslist", "_self");
					window.open(path+"milestone/getDefaultMilestone", "_self");
				}			
				table.draw();
				$scope.hastrue=false;				
			}else{
				errorMessage(data.errorMsg);
				  $scope.errormessage=data.errorMsg;
				  $scope.successmessage="";
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.addingdefaultmilestone = function($id) {
		$scope.errormessage="";
		$scope.successmessage="";
		$scope.milestoneid=0;
		$scope.milestone="";
		$scope.description="";
		$timeout(function(){$('#myModal').modal('show');}, 300);
		}
	
	
});

////////////////////////////// Ending Default milestone controller ////////////////////////////////////////////////////
