/*! UBIPROJECT taskapp.js
 * ================
 *
 * @Author  Jaidev Sharma
 * @Email   <jaidev@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIPROJECT requires jQuery");
}
var app = angular.module('taskapp', []);
/* app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
}); */
app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});
app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Task Controller Starts From Here  ///////////////////////////////////

app.controller('taskCtrl', function($scope, $http, $timeout) {
	
	$scope.hastrue=false;
	$scope.taskid=0;
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid=0;
	$scope.milestoneid=0;
	$scope.assignto=0;
	$scope.desc="";
	$scope.title="";
	$scope.priority=0;
	$scope.taskstatus=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.projectstartdate="";
	$scope.projectenddate="";
	$scope.comment="";
	$scope.miscunduct=0;
	$scope.reopencount=0;
	$scope.rating=0;
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	//$scope.leavevalidsts=[];
	$scope.projectarray=[];
	$scope.projectarray1=[];
	$scope.otherarray=[];
	$scope.taskdocs=[];
	
	///////upload task files//////
	
		var table="";
	//an array of files selected
    $scope.files = [];
	 //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
	
	$scope.importFile = function() {
	$scope.model = {
        projectid: $scope.projectid,
        milestoneid: $scope.milestoneid,
		assignto: $scope.assignto,
		desc: $scope.desc,
		title: $scope.title,
		fromdate: $scope.fromdate,
		todate: $scope.todate,
		priority: $scope.priority,
		taskstatus: $scope.taskstatus,
		miscunduct: $scope.miscunduct
		
    };

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"tasks/uploadfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
					alert("successfully uploaded");
			}
			else{
					errorMessage(data.errorMsg);
					alert("problem while uploading");
			}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
	////////upload task files//////////
	
	
	onfetch("milestone/getAllRunningProject",1);
	onfetch("tasks/getother",2);
	onfetch("profile/getallproject",3);
	
	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				
					if($id==1)
					$scope.projectarray=data.data;
					if($id==2){
					$scope.otherarray=data.data;
					$scope.taskstatus=$scope.otherarray[0]['id'];
					}
				    if($id==3)
					$scope.projectarray1=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.getId = function($id) {
		$scope.taskid=$id;
	}
	$scope.ondelete =function(){
		$http({
			url: path+'tasks/deletetask/'+$scope.taskid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.taskid=0;
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	

		$scope.taskarray=[{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""}];
	$scope.addmile = function($i){
		var len = $scope.taskarray.length-1;
		if($scope.taskarray[len]['projectid']=="" || $scope.taskarray[len]['desc']=="" || $scope.taskarray[len]['assignempid']=="" ||$scope.taskarray[len]['title']=="" || $scope.taskarray[len]['fromdate']==""|| $scope.taskarray[len]['todate']=="" || $scope.taskarray[len]['projectstatus']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.taskarray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	}
	$scope.removemile = function($i){
		$scope.taskarray.remove($i);	
		if($scope.taskarray.length==0){
			$scope.taskarray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	$scope.commentarray = [];		
	$scope.onfetchcommenthistory =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'tasks/getcomment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.commentarray=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
		
	$scope.setdate =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getprojectdate',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.projectstartdate=data.data[0]['start_date'];
				$scope.projectenddate=data.data[0]['completed_date'];
                 $('#fromdate').datetimepicker("remove");
				$('#fromdate').datetimepicker({
			startDate: new Date($scope.projectstartdate),
				//endDate: new Date($scope.projectenddate)
				
		});
				  $('#todate').datetimepicker("remove");
				$('#todate').datetimepicker({
				startDate: new Date($scope.projectstartdate),
				//endDate: new Date($scope.projectenddate)
				
		});
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
	$scope.milestonearray = [];		
	$scope.onfetchmilestone =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getallmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.milestonearray=data.data;
				}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.employeearray=[];
	$scope.onfetchemployee =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getallemployee',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.employeearray=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.toggleSelection = function($x) {
	
	  if($scope.juniourarr[$x].vsts){		
		$scope.juniourarr[$x].vsts=false;
	  }else{
		$scope.juniourarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.juniourarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.juniourarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
	
	$scope.fetchtask = function($date){
		$scope.date=$date;
				table = $('#example1').DataTable({
				"bProcessing": true,
				"bServerSide": true,
				"stateSave": true,
				"deferRender": true,
				"sAjaxSource": path+"profile/getprofiletaskdatatable/"+$date,
				"columnDefs": [ {
					"searchable": false,
					"orderable": false,
					"targets"  : 'no-sort'
					}]
				
        });
	}
	
	
	$scope.popupcommentmodal =function(){
		
		
		$('#confirm1').modal('show');
		//alert($scope.rating);
		
	}
	
	//////////////////////////////// for profile //////////////////
	$scope.onfetchtask1 =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'profile/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				$scope.title=data.data[0]['task_title'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.projectid=data.data[0]['projectid'];
				$scope.milestoneid=data.data[0]['milestoneid'];
				$scope.assignto=data.data[0]['assignto'];
				$scope.desc=data.data[0]['desc'];
				$scope.priority=data.data[0]['priority'];
				$scope.taskstatus=data.data[0]['taskstatus'];
				$scope.miscunduct=data.data[0]['miscunduct'];
			
				if($scope.miscunduct==1){
					$('#miscunduct').prop('checked',true);
				}
				$scope.onfetchmilestone($scope.projectid);
				$scope.onfetchemployee($scope.projectid);
				$scope.onfetchcommenthistory($id);
				$scope.taskdocs=data.data[0]['taskdocs'];
				//console.print($scope.taskdocs);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	//////////////////////////////////for profile end/////////////////
	$scope.onfetchtask =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'tasks/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){			
				$scope.title=data.data[0]['task_title'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.projectid=data.data[0]['projectid'];
				$scope.milestoneid=data.data[0]['milestoneid'];
				$scope.assignto=data.data[0]['assignto'];
				$scope.desc=data.data[0]['desc'];
				$scope.priority=data.data[0]['priority'];
				$scope.taskstatus=data.data[0]['taskstatus'];
				$scope.miscunduct=data.data[0]['miscunduct'];
				$scope.reopencount=data.data[0]['reopencount'];
				$scope.rating=data.data[0]['rating'];
				$scope.taskdocs=data.data[0]['taskdocs'];
				$('#point').val($scope.rating);
				$('#star2').starrr({				
					rating:$scope.rating,
					readOnly: true
				});
				if($scope.miscunduct==1){
					$('#miscunduct').prop('checked',true);
				}
				$scope.onfetchmilestone($scope.projectid);
				$scope.onfetchemployee($scope.projectid);
				$scope.onfetchcommenthistory($id);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val) {
	$scope.model = {
        projectid: $scope.projectid,
        milestoneid: $scope.milestoneid,
		assignto: $scope.assignto,
		desc: $scope.desc,
		title: $scope.title,
		fromdate: $scope.fromdate,
		todate: $scope.todate,
		priority: $scope.priority,
		taskstatus: $scope.taskstatus,
		miscunduct: $scope.miscunduct
		
    };

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"tasks/createtask",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				$scope.taskdocs=[];
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"tasks/index", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
	$scope.rating=$('#point').val();
	//alert($scope.rating);
	if($('#miscunduct').prop('checked')) {
			$scope.miscunduct=1;

		} else {
			$scope.miscunduct=0;
		}
$scope.hastrue=true;
var xsrf = $.param({projectid: $scope.projectid, milestoneid: $scope.milestoneid, assignto: $scope.assignto, desc:$scope.desc, title:$scope.title, fromdate:$scope.fromdate, todate:$scope.todate, priority:$scope.priority, taskstatus:$scope.taskstatus, miscunduct:$scope.miscunduct, taskid:$scope.taskid,comment:$scope.comment,rating:$scope.rating});
  $http({
        url: path+'tasks/updatedtask',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				if($scope.files != ""){
					
					$scope.onupdatetaskfile();
					
				}
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"tasks/index", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	$scope.onupdatetaskfile = function() {
	$scope.model = {
       
				taskid:$scope.taskid
		
    };

	
        $http({
            method: 'POST',
            url: path+"tasks/updatetaskfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).success(function (data, status, headers, config) {
			if(data.status){
	
				
			}else{
				
			}
				
        }).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				
		});
}

$scope.onchangeadmin =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'tasks/addtaskstatus/'+$scope.taskid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				// table.draw();
				$timeout(function(){window.open(path+"profile/tasks", "_self");}, 400); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.taskid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.timediffest = function(){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datetimepicker( "getDate" );
		// fromdate.setDate(fromdate.getDate());
		
			$('#todate').datetimepicker("remove");
			$('#todate').datetimepicker({
				startDate: fromdate,
				format: 'dd/mm/yyyy hh:mm P'
				//endDate: new Date($scope.projectenddate)
			});
		
		
	}



});

