/*! UBIPROJECT taskapp.js
 * ================
 *
 * @Author  Jaidev Sharma
 * @Email   <jaidev@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIPROJECT requires jQuery");
}
var app = angular.module('taskapp', []);
/* app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
}); */
app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});
app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Task Controller Starts From Here  ///////////////////////////////////

app.controller('taskCtrl', function($scope, $http, $timeout) {
	
	$scope.hastrue=false;
	$scope.taskid=0;
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid="";
	$scope.milestoneid="";
	$scope.assignto="";
	$scope.desc="";
	$scope.title="";
	$scope.priority=0;
	$scope.taskstatus=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.projectstartdate="";
	$scope.projectenddate="";
	$scope.comment="";
	$scope.durationhours="";
	$scope.durationminutes="";
	$scope.miscunduct=0;
	$scope.reopencount=0;
	$scope.rating=0;
	$scope.type=0;
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	$scope.totalmarks=0;
	$scope.date="";
	$scope.timesheetid=0;
	$scope.hourssts=1;
	$scope.hoursshow=true;
	//$scope.leavevalidsts=[];
	$scope.projectarray=[];
	$scope.projectarray1=[];
	$scope.otherarray=[];
	$scope.taskdocs=[];
	$scope.employeearray=[];
	$scope.assignto1=0;
	 
	///////upload task files//////
	/* $scope.taskarray=[{projectid:"",milestoneid:"", assignto:"", title:"", fromdate:"", todate:"", priority:"", desc:"",originaldoc:""}];
	$scope.addTask = function(){
		var len = $scope.taskarray.length-1;
		if($scope.taskarray[len]['projectid']=="" || $scope.taskarray[len]['milestoneid']==""|| $scope.taskarray[len]['assignto']=="" || $scope.taskarray[len]['title']=="" || $scope.taskarray[len]['fromdate']=="" || $scope.taskarray[len]['todate']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.taskarray.insert($scope.taskarray.length,{projectid:"",milestoneid:"", assignto:"", title:"", fromdate:"", todate:"", priority:"", desc:"",originaldoc:""});
		}
	}
	$scope.removeTask= function($i){
		$scope.taskarray.remove($i);
		if($scope.taskarray.length==0){
			$scope.taskarray.insert($i,{projectid:"",milestoneid:"", assignto:"", title:"", fromdate:"", todate:"", priority:"", desc:"",originaldoc:""});
		}
	} */
	var table="";
	//an array of files selected
    $scope.files = [];
	 //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
		});
    });
	$scope.importFile = function() {
	$scope.model = {
        projectid: $scope.projectid,
        milestoneid: $scope.milestoneid,
		assignto: $scope.assignto,
		desc: $scope.desc,
		title: $scope.title,
		fromdate: $scope.fromdate,
		todate: $scope.todate,
		priority: $scope.priority,
		//taskstatus: $scope.taskstatus,
		miscunduct: $scope.miscunduct
	};
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"tasks/uploadfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
				alert("successfully uploaded");
			}
			else{
				errorMessage(data.errorMsg);
				alert("problem while uploading");
			}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
	////////upload task files//////////
	onfetch("milestone/getAllRunningProject",1);
	onfetch("tasks/getother",2);
	onfetch("profile/getallproject",3);
	$scope.setminutesvalue=function(){
		var minutes= $("#durationminutes").val();
		console.log(minutes);
		if(minutes>=60){
			$scope.durationminutes=0;
		}
	}
	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==1)
				$scope.projectarray=data.data;
				if($id==2){
					$scope.otherarray=data.data;
					$scope.taskstatus=$scope.otherarray[0]['id'];
				}
				if($id==3)
				$scope.projectarray1=data.data;
			} if($id==4){
					$scope.employeearray=[];
					$scope.employeearray=data.data;
					$timeout(function() {
					$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000); 
				}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.getId = function($id) {
		$scope.taskid=$id;
	}
	$scope.ondelete =function(){
		$http({
			url: path+'tasks/deletetask/'+$scope.taskid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$timeout(function(){window.open(path+"tasks/index/"+$scope.type, "_self");}, timeo); 
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.taskid=0;
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/* $scope.taskarray=[{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""}];
	$scope.addmile = function($i){
		var len = $scope.taskarray.length-1;
		if($scope.taskarray[len]['projectid']=="" || $scope.taskarray[len]['desc']=="" || $scope.taskarray[len]['assignempid']=="" ||$scope.taskarray[len]['title']=="" || $scope.taskarray[len]['fromdate']==""|| $scope.taskarray[len]['todate']=="" || $scope.taskarray[len]['projectstatus']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.taskarray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	}
	$scope.removemile = function($i){
		$scope.taskarray.remove($i);	
		if($scope.taskarray.length==0){
			$scope.taskarray.insert($i,{id:0,priority:1, projectid:"",desc:"", title:"", fromdate:"", todate:"",projectstatus:""});
		}
	} */
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	 $scope.employeenewarr = [];		
	$scope.onfetchdefaultemployee =function($val){ 
		$scope.hastrue=true;
		//var xsrf = $.param({taskid: $id});
		$http({
			url: path+'leave/getallleaveemployee',
			method: "POST",
			//data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.employeenewarr=data.data;
				if($val==1){
					 $scope.employeearray=data.data;
					 $timeout(function() {
					$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);
				}
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}	
	$scope.commentarray = [];		
	$scope.onfetchcommenthistory =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'tasks/getcomment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.commentarray=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.setdate =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getprojectdate',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.fromdate="";
				$scope.todate="";
				$scope.timeduration="";
				$scope.projectstartdate=data.data[0]['start_date'];
				$scope.projectenddate=data.data[0]['completed_date'];
                 $('#fromdate').datepicker("remove");
				$('#fromdate').datepicker({
					startDate: new Date($scope.projectstartdate),
					//endDate: new Date($scope.projectenddate)
				});
				$('#todate').datepicker("remove");
				$('#todate').datepicker({
					startDate: new Date($scope.projectstartdate),
					//endDate: new Date($scope.projectenddate)
				});
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.milestonearray = [];		
	$scope.onfetchmilestone =function($id,$index){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getallmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.milestonearray=data.data;
				}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.empprojectarr=[];
	$scope.getempproject =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'tasks/getEmpProject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.empprojectarr=data.data;
				
			}else{
			 $scope.empprojectarr=[ ];
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.employeearray=[];
	$scope.onfetchemployee =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getallemployee',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.employeearray=data.data;
				$timeout(function() {
					$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);
				
			}	else{
				 $scope.employeearray=[];
			}	
		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	////////////////Fetch task data for timesheet module//////////////////////////////
	$scope.getHoursType= function($val){
		if($val==1){
			$scope.hoursshow=true;
			$scope.startendshow=false;
		}
		else{
			$scope.startendshow=true;
			$scope.hoursshow=false;
		}
	}
	$scope.onfetchtask =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'tasks/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){			
				$scope.title=data.data[0]['task_title'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.projectid=data.data[0]['projectid'];
				//$scope.assignto=Number(data.data[0]['assignto']);
				 $timeout(function() {
					$('.selectpicker').selectpicker('refresh');
						//$('#competencytypeid').selectpicker('val', $scope.tests);
						//$('#tests').selectpicker('selectAll');                        
					}, 1000);
				console.log($scope.assignto);
				if($scope.projectid==0){
					$scope.projectid=0;
					$scope.onfetchdefaultemployee(1);
					$scope.assignto=Number(data.data[0]['assignto']);
					
				}
				$scope.milestoneid=data.data[0]['milestoneid'];
				if($scope.milestoneid==0){
					$scope.milestoneid=0;
				}
					
				
				$scope.desc=data.data[0]['desc'];
				$scope.priority=data.data[0]['priority'];
				$scope.durationhours=data.data[0]['durationhours'];
				$scope.durationminutes=data.data[0]['durationminutes'];
				$scope.taskstatus=data.data[0]['taskstatus'];
				//$scope.miscunduct=data.data[0]['miscunduct'];
				$scope.reopencount=data.data[0]['reopencount'];
				//$scope.rating=data.data[0]['rating'];
				if($scope.type==3){
					$scope.getempproject($scope.assignto);
				}
				$timeout(function(){
					$scope.onfetchmilestone($scope.projectid);
					if($scope.projectid!=0){
						$scope.assignto=data.data[0]['assignto'];
						$scope.onfetchemployee($scope.projectid);
					}
				}, 400); 
				
					$scope.taskdocs=data.data[0]['taskdocs'];
				//$scope.onfetchcommenthistory($id);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	/* $scope.toggleSelection = function($x) {
	
	  if($scope.juniourarr[$x].vsts){		
		$scope.juniourarr[$x].vsts=false;
	  }else{
		$scope.juniourarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.juniourarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.juniourarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   }; */
	
	
	$scope.popupcommentmodal =function(){
		$('#confirm1').modal('show');
		//alert($scope.rating);
	}
	
	//////////////////////////////// for profile //////////////////
	$scope.fetchtask = function($type){
		$scope.type=$type;
				table = $('#example1').DataTable({
				"bProcessing": true,
				"bServerSide": true,
				"stateSave": true,
				"deferRender": true,
				"sAjaxSource": path+"profile/getprofiletaskdatatable/"+$type,
				"columnDefs": [ {
					"searchable": false,
					"orderable": false,
					"targets"  : 'no-sort'
					}]
				
        });
	}
	$scope.onfetchtask1 =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'profile/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.title=data.data[0]['task_title'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.projectid=data.data[0]['projectid'];
				if($scope.projectid==0){
					$scope.projectid=0;
				}
				$scope.milestoneid=data.data[0]['milestoneid'];
				if($scope.milestoneid==0){
					$scope.milestoneid=0;
				}
				$scope.assignto=data.data[0]['assignto'];
				$scope.durationhours=data.data[0]['durationhours'];
				$scope.durationminutes=data.data[0]['durationminutes'];
				$scope.desc=data.data[0]['desc'];
				$scope.priority=data.data[0]['priority'];
				$scope.taskstatus=data.data[0]['taskstatus'];
				$scope.miscunduct=data.data[0]['miscunduct'];
			
				if($scope.miscunduct==1){
					$('#miscunduct').prop('checked',true);
				}
				$scope.onfetchmilestone($scope.projectid);
				$scope.onfetchemployee($scope.projectid);
				$scope.onfetchcommenthistory($id);
				$scope.taskdocs=data.data[0]['taskdocs'];
				//console.log($scope.taskdocs);
				//console.print($scope.taskdocs);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate1 = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $scope.projectid, milestoneid: $scope.milestoneid, desc:$scope.desc, title:$scope.title, fromdate:$scope.fromdate, todate:$scope.todate, priority:$scope.priority, durationhours: $scope.durationhours, durationminutes: $scope.durationminutes});
		$http({
			url: path+'profile/createtask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"profile/tasks/"+$scope.type, "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.addtimesheet = function($projectid, $id)	{
		$scope.startdate="";
		$scope.endtime="";
		$scope.starttime="";
		$scope.timeduration="";
		$scope.hourssts=1;
		$scope.desc="";
		$scope.errormessage="";
		$scope.projectid=$projectid;
		if($scope.projectid==0){
			$scope.projectid=0;
		}
		$scope.onfetchtaskprofile($scope.projectid);
		$scope.taskid=$id;
		//$scope.can_name=$can_name;
		$timeout(function(){$('#addtimesheet').modal('show');},100);
	}
	$scope.onfetchtaskprofile =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'profile/gettaskbyproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.taskarray=data.data;
				
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.gettotaltime= function($sdate,$edate) {
		//alert($sdate);alert($edate);
		var strt = $("#startdate").datetimepicker('getDate');
		var end = $("#enddate").datetimepicker('getDate');
		var a = new Date(strt);
		var b = new Date(end);
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		/* var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		var day = Math.floor((utc2 - utc1) / _MS_PER_DAY);
		 */
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
			$scope.timeduration1=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.timeduration=days1+':'+minutes;
		
	}
	$scope.timediffest1 = function(){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#startdate").datetimepicker( "getDate" );
		// fromdate.setDate(fromdate.getDate());
		 $('#enddate').datetimepicker("remove");
		$('#enddate').val("");
		$('#enddate').datetimepicker({
			startDate: fromdate,
			endDate: new Date()
		});
	}
	
	$scope.taskdone = function()	{
		//$scope.can_name=$can_name;
		if($scope.hourssts==1){
			$scope.starttime="";
			$scope.endtime="";
			$scope.timeduration=$("#timeduration").val();
		
			if($scope.timeduration==""){
				//console.log("fsdfsdf");
				alert("Filled Hours");
				return false;
			}
		}
		else if($scope.hourssts==2){
			$scope.timeduration="";
			$scope.starttime=$("#starttime").val();
			$scope.endtime=$("#endtime").val();
			if($scope.starttime=="" && $scope.endtime==""){
				alert("Filled Start Time and End Time");
				return false;
			}
		}
		$timeout(function(){$('#confirm1').modal('show');},100);
		 $(document).on('show.bs.modal', '.modal', function (event) {
            var zIndex = 1040 + (10 * $('.modal:visible').length);
            $(this).css('z-index', zIndex);
            // setTimeout(function() {
                // $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
            // }, 0);
        });
	}
	$scope.val="";
	$scope.onsavetimesheet = function($val) { 
	if($val==1){
		if($scope.hourssts==1){
			$scope.starttime="";
			$scope.endtime="";
			$scope.timeduration=$("#timeduration").val();
		
			if($scope.timeduration==""){
				//console.log("fsdfsdf");
				alert("Filled Hours");
				return false;
			}
		}
		else if($scope.hourssts==2){
			$scope.timeduration="";
			$scope.starttime=$("#starttime").val();
			$scope.endtime=$("#endtime").val();
			if($scope.starttime=="" && $scope.endtime==""){
				alert("Filled Start Time and End Time");
				return false;
			}
		}
	}
		$scope.hastrue=true;
		$scope.val=$val;
		var xsrf = $.param({projectid:$scope.projectid, taskid:$scope.taskid, startdate:$scope.startdate,hourssts:$scope.hourssts, timeduration:$scope.timeduration, starttime:$scope.starttime,  endtime:$scope.endtime, desc:$scope.desc,val:$scope.val});
		$http({
			url: path+'profile/addselftimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               
				if($val==1){
					 successMessage(data.successMsg);
					window.open(path+"profile/tasks/"+$scope.type, "_self");
				}else if($val==2){
					$scope.onchangeadmin();
				}
			}else{
				errorMessage(data.errorMsg);
				$scope.errormessage=data.errorMsg;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}	
	//////////////////////////////////for profile end/////////////////
	$scope.timediffest = function($fromdate){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 //fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
	}
	$scope.oncreate = function($val) {
		$scope.assignto=$('#assignto1').val();
		console.log($scope.assignto);
		if($scope.assignto==null){
			alert("select atleast one employee");
			return true;
		}
	$scope.model = {
        projectid: $scope.projectid,
        milestoneid: $scope.milestoneid,
		assignto: $scope.assignto1,
		desc: $scope.desc,
		title: $scope.title,
		fromdate: $scope.fromdate,
		todate: $scope.todate,	
		durationhours: $scope.durationhours,
		durationminutes: $scope.durationminutes,
		priority: $scope.priority,
		taskstatus: $scope.taskstatus,
		miscunduct: $scope.miscunduct
	};

	$scope.hastrue=true;
        $http({
            method: 'POST',
           url: path+"tasks/createtask",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				$scope.taskdocs=[];
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"tasks/index/"+$scope.type, "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
}

	$scope.onupdate = function($val) {
	$scope.rating=$('#point').val();
	//alert($scope.rating);
	if($('#miscunduct').prop('checked')) {
		$scope.miscunduct=1;
	} else {
		$scope.miscunduct=0;
	}
	$scope.hastrue=true;
	var xsrf = $.param({projectid: $scope.projectid, milestoneid: $scope.milestoneid, assignto: $scope.assignto, desc:$scope.desc, title:$scope.title, fromdate:$scope.fromdate, todate:$scope.todate, priority:$scope.priority, durationhours: $scope.durationhours, durationminutes: $scope.durationminutes, taskid:$scope.taskid});
  $http({
        url: path+'tasks/updatedtask',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				if($scope.files != ""){
					$scope.onupdatetaskfile();
				}
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"tasks/index/"+$scope.type, "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	$scope.onupdatetaskfile = function() {
	$scope.model = {
		taskid:$scope.taskid
	};
	$http({
            method: 'POST',
            url: path+"tasks/updatetaskfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).success(function (data, status, headers, config) {
			if(data.status){
	
				
			}else{
				
			}
				
        }).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				
		});
}

	$scope.onchangeadmin =function() {
	$scope.hastrue=true;
	$http({
        url: path+'tasks/addtaskstatus/'+$scope.taskid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				// table.draw();
				$timeout(function(){window.open(path+"profile/tasks/"+$scope.type, "_self");}, 400); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.taskid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

/* $scope.timediffest = function(){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datetimepicker( "getDate" );
		// fromdate.setDate(fromdate.getDate());
		$('#todate').datetimepicker("remove");
		$('#todate').datetimepicker({
			startDate: fromdate,
			format: 'dd/mm/yyyy hh:mm P'
			//endDate: new Date($scope.projectenddate)
		});
	} */

});

app.controller('taskapprovalbymailCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.taskid=0;
    $scope.userid=0;
    $scope.org_id=0;
	$scope.employeeleaveid=0;
	$scope.approverresult=0;
	$scope.comment="";
	$scope.result="";
	$scope.remarks="";
	$scope.approvaltext="";
	$scope.setminutesvalue=function(){
		var minutes= $("#durationminutes").val();
		console.log(minutes);
		if(minutes>=60){
			$scope.durationminutes=0;
		}
	}
	$scope.onfetchtask =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'approvalbymail/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){			
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.durationhours=data.data[0]['durationhours'];
				$scope.durationminutes=data.data[0]['durationminutes'];
				$scope.reopencount=data.data[0]['reopencount'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.timediffest = function($fromdate){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
	}
	
	$scope.onapprove = function() {
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ taskid:$scope.taskid, userid:$scope.userid, org_id:$scope.org_id,approverresult:$scope.approverresult, comment:$scope.comment});
		$http({
			url: path+'approvalbymail/approvetaskapproval',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	//successMessage(data.successMsg);
				$scope.result=data.successMsg;
				}else{
				//errorMessage(data.errorMsg);
				$scope.result=data.errorMsg;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetch = function($taskid,$userid,$org_id,$approverresult,$appSts){
	 $scope.userid=$userid;
    $scope.org_id=$org_id;
	//$scope.employeeleaveid=$employeeleaveid;
	$scope.approverresult=$approverresult;
	if($approverresult==5){
		$scope.remarks="Reassign task";
		$scope.approvaltext="Reassign";
		//$timeout(function(){
			//		$("#confirm").modal('show');
				//}, 2000);
	}
		if($approverresult==4){
			$scope.remarks="Remarks";
			$scope.approvaltext="Compeleted";
					//$timeout(function(){
						//$("#confirm").modal('show');
					//}, 2000);
		}
		if($appSts==5){
			$scope.result="Task has already been reassign";
			//$timeout(function(){
				//		$("#confirm").modal('show');
					//}, 2000);
		}
		if($appSts==4){
			$scope.result="Task has already been compeleted";
					//$timeout(function(){
						//$("#confirm").modal('show');
					//}, 2000);
		}
	}
	$scope.onupdate = function($val) {
	
	$scope.hastrue=true;
	var xsrf = $.param({taskid:$scope.taskid, userid:$scope.userid, org_id:$scope.org_id,approverresult:$scope.approverresult, fromdate:$scope.fromdate, todate:$scope.todate, durationhours: $scope.durationhours, durationminutes: $scope.durationminutes, desc:$scope.desc});
  $http({
        url: path+'approvalbymail/reassignTaskUpdated',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		if(data.status){
            	//successMessage(data.successMsg);
				$scope.result=data.successMsg;
				}else{
				//errorMessage(data.errorMsg);
				$scope.result=data.errorMsg;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}



});
