/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('setupapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Policy Controller Starts From Here  ///////////////////////////////////

app.controller('policyCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.policyid=0;
	$scope.policyname="";
	$scope.categoryid="";
	$scope.applydate="";
	$scope.category=[];
	
	$scope.getId = function($id) {
	$scope.policyid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletepolicy/'+$scope.policyid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.policyid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	//for get category
	function policycategory()
	{
		$scope.hastrue=true;
		var xsrf = $.param({typeid:6});
		$http({
			url: path+'setup/getallcategory',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	policycategory();
	$scope.onfetchpolicy =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({policyid: $id});
		$http({
			url: path+'setup/getpolicy',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.policyname=data.data[0]['policyname'];
				$('#policyname').data("wysihtml5").editor.setValue(data.data[0]['policyname']);
				$scope.categoryid=data.data[0]['categoryid'];
				$scope.applydate=data.data[0]['applydate'];
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		
		$scope.hastrue=true;
		var xsrf = $.param({policyname: document.getElementById('policyname').value, categoryid:$scope.categoryid, applydate:$scope.applydate});
		$http({
			url: path+'setup/createpolicy',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.policyname="";
					//$scope.categoryid="";
					//$scope.applydate="";			
					$scope.policyid=0;	
						
					if($val==1){
						//window.open(path+"setup/policy", "_self");
						$timeout(function(){window.open(path+"setup/policy", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({policyid: $scope.policyid, policyname: document.getElementById('policyname').value, categoryid:$scope.categoryid, applydate:$scope.applydate});
		$http({
			url: path+'setup/updatedpolicy',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
					successMessage(data.successMsg);
					$scope.policyname="";
					//$scope.categoryid="";
					//$scope.applydate="";			
					$scope.policyid=0;	
				if($val==1){
					//window.open(path+"setup/policy", "_self");
					$timeout(function(){window.open(path+"setup/policy", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});


/////////////////////////// Root Fare Controller Starts From Here  ///////////////////////////////////

app.controller('rootfareCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.rootfareid=0;
	$scope.country1="";
	$scope.country2="";
	$scope.city1="";
	$scope.city2="";
	$scope.tickettype="";
	$scope.ticketfare="";
	$scope.childticketfare="";
	$scope.infantticketfare="";
	
	$scope.tickettypearr=[];
	
	onfetchcountry();
	onfetchtickettype();
	
	
	$scope.getId = function($id) {
		$scope.rootfareid=$id;
	}

	$scope.ondelete =function()
	{
		$http({
			url: path+'setup/deleterootfare/'+$scope.rootfareid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					 successMessage(data.successMsg);
					 table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.rootfareid=0;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	
	function onfetchcountry()
	{ 
		$scope.countryarr=[];
		$http({
			url: path+'country',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				$scope.countryarr=data;	
					onfetchrootfare();
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.oncountry1 =function()
	{
		$scope.city1=0;
		onfetchcity1($scope.country1);
	}
	
	$scope.oncountry2 =function()
	{
		$scope.city2=0;
		onfetchcity2($scope.country2);
	}

	function onfetchtickettype()
	{
		$scope.tickettypearr=[];
		$scope.hastrue=true;
		$http({
			url: path+'other',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.tickettypearr=data.data;
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	function onfetchcity1($id)
	{
		$scope.cityarr=[];
		$scope.hastrue=true;
		var xsrf = $.param({countryid:$id });
		$http({
			url: path+'city',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				$scope.cityarr=data;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	function onfetchcity2($id)
	{
		$scope.cityarr2=[];
		$scope.hastrue=true;
		var xsrf = $.param({countryid:$id });
		$http({
			url: path+'city',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				$scope.cityarr2=data;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	function onfetchrootfare()
	{
		$scope.hastrue=true;
		var xsrf = $.param({rootfareid: $scope.rootfareid});
		$http({
			url: path+'setup/getarootfare',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				$scope.city1=data.data[0]['fromcity'];
				$scope.city2=data.data[0]['tocity'];
				$scope.country1=data.data[0]['fromcountry'];
				$scope.country2=data.data[0]['tocountry'];
				$scope.ticketfare=data.data[0]['fareamount'];
				$scope.tickettype=data.data[0]['tickettype'];
				$scope.childticketfare=data.data[0]['childfare'];
				$scope.infantticketfare=data.data[0]['infantfare'];
			}
			onfetchcity1($scope.country1);
			onfetchcity2($scope.country2);
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		
		$scope.hastrue=true;
		var xsrf = $.param({rootfare: $scope.ticketfare, fromcountry:$scope.country1, tocountry:$scope.country2, fromcity:$scope.city1, tocity:$scope.city2, tickettype:$scope.tickettype, childticketfare:$scope.childticketfare, infantticketfare:$scope.infantticketfare});
		$http({
			url: path+'setup/createrootfare',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.rootfarename="";
					//$scope.categoryid="";
					//$scope.applydate="";			
					$scope.rootfareid=0;	
					$scope.childticketfare="";
					$scope.infantticketfare="";
					if($val==1){
						//window.open(path+"setup/rootfare", "_self");
						$timeout(function(){window.open(path+"setup/rootfare", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({rootfareid: $scope.rootfareid, rootfare: $scope.ticketfare, fromcountry:$scope.country1, tocountry:$scope.country2, fromcity:$scope.city1, tocity:$scope.city2, tickettype:$scope.tickettype, childticketfare:$scope.childticketfare, infantticketfare:$scope.infantticketfare});
		$http({
			url: path+'setup/updatedrootfare',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
					successMessage(data.successMsg);
					$scope.rootfarename="";
					$scope.categoryid="";
					$scope.applydate="";	
					$scope.childticketfare="";
					$scope.infantticketfare="";					
					$scope.rootfareid=0;
				if($val==1){
					//window.open(path+"setup/rootfare", "_self");
					$timeout(function(){window.open(path+"setup/rootfare", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});	
	

/////////////////////////// Root Fare Import Controller Starts From Here  ///////////////////////////////////

app.controller('rootfareimportCtrl', function($scope, $http, $timeout) {
	
	$scope.hastrue=false;
	/*$scope.dpcity=-1;
	$scope.arcity=-1;
	$scope.adultfare=-1;
	$scope.infantfare=-1;
	$scope.childfare=-1;
	$scope.tickettype=-1;*/
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
   $scope.headnamearray=[]; 
    //the save method
    $scope.importFile = function() {
	

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/importheadersfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
					$scope.headnamearray=data.data;	
					
					
			}
			else{
					errorMessage(data.errorMsg);
				}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	$scope.repeatemp="";
	$scope.importemp="";
	
	$scope.importrootfaredata = function($val)
	{	
		$scope.hastrue=true;
		
		var xsrf = $.param({dpcity:$scope.dpcity, arcity:$scope.arcity, adultfare:$scope.adultfare, infantfare:$scope.infantfare, childfare:$scope.childfare, tickettype:$scope.tickettype});
		$http({
			url: path+'setup/importrootfaredata',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					//errorMessage(data.successMsg);
					$scope.importemp = data.importemp;
					$scope.repeatemp = data.repeatemp;					
					//window.open(path+"employee/onboard_employee_list", "_self");
				}else{
					
					//errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
});

///////////////////////////// Workflow Controller Starts From Here  ///////////////////////////////////

app.controller('workflowCtrl', function($scope, $http, $timeout) {

$scope.reportid=0;

$scope.hastrue=false;
$scope.tablen=0;
$scope.modulesarr = [];
$scope.columnsarr = [];
$scope.columndataarr = [];

$scope.actionarr = [{id:1, name:"Send Email"},{id:2, name:"Send Notification"}];

$scope.conditionarr = [{id:'OR', name:"OR"},{id:'AND', name:"AND"}];
$scope.conditionarr2 = [{id:'=', name:"is equal to", type:"int"},
						{id:'<', name:"is less than", type:"int"},
						{id:'>', name:"is greater than", type:"int"},
						{id:'<=', name:"is less than equal to", type:"int"},
						{id:'>=', name:"is greater than equal to", type:"int"},
						{id:'<>', name:"is not equal to", type:"int"},
						{id:'like', name:"is contains", type:"var"},
						{id:'like', name:"is not contains", type:"var"},
						{id:'like', name:"is starts with", type:"var"},
						{id:'like', name:"is ends with", type:"var"}
						];
						
$scope.filterarr = [{id:0, condition1:"AND", column:"", condition2:"", type:0, textvalue:"" }];

fetchmodel();
function fetchmodel()
{
	$scope.hastrue=true;
	$http({
        url: path+'other/getreportingmodule',
        method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulesarr=data.data;
				
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

 $scope.fetchmodelcolumn = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({tablename: $scope.modulename});
	$http({
        url: path+'setup/getchildname',
        method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.columnsarr=data.data;
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	$scope.onchangecolumn = function($val, $index)
	{
		//alert($filterindex+"  "+$index);
		var tablests=0;
		var len = $scope.columnsarr.length;
		for(var i=0; i<len; i++)
		{
			if($val == $scope.columnsarr[i]['id']){
				tablests = $scope.columnsarr[i]['tablests'];
				$scope.filterarr[$index].textvalue="";
				$scope.filterarr[$index].type=tablests;
				fetchcolumndata($scope.columnsarr[i]['tablename'], $index);
				break;
			}
		}
		
	}

 function fetchcolumndata($val, $index)
{
	$scope.hastrue=true;
	var xsrf = $.param({tablename: $val});
	$http({
        url: path+'setup/getselectedcolumndata',
        method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.columndataarr[$index]=data.data;
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.addfilter = function($i)
{
	$scope.filterarr.insert($i, {id:0, condition1:"AND", column:"", condition2:"", type:0, textvalue:"" });
}
$scope.removefilter = function($i)
{
	$scope.filterarr.remove($i);
}

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};

});
//////////////////////////Dashboard Ctrl///////////////////
app.controller('dashboardCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.customsts=0;
$scope.dashboardid=0;
$scope.fiscalview="";
$scope.hastrue=false;
$scope.dashboardname="";
$scope.modulename="";
$scope.selectedcol="";
$scope.groupby1="";
$scope.groupby2="";

$scope.leftdisable=true;
$scope.rightdisable=true;

$scope.orderby1='asc';
$scope.orderby2='asc';
$scope.orderbytype='orderby';
$scope.modulesarr = [];
$scope.columnsarr = [];
$scope.groupcolumnsarr = [];
$scope.selectedcolumnsarr = [];
$scope.filtercolumn=[];
$scope.datefilterid=0;
$scope.datefilter=0;

$scope.fromdate=0;
$scope.todate=0;
$scope.tempar=[];
$scope.totalcolarr=[];
$scope.filtercolumnsarr=[];
$scope.dashboardype="";
$scope.totalcolumn="";
onfetch('setup/getalldivision',1);
$scope.orderarr = [{id:'asc', name:"Ascending"},{id:'desc', name:"Descending"}];
$scope.ordertypearr = [{id:'orderby', name:"Order By"},{id:'groupby', name:"Group By"}];
$scope.conditionarr = [{id:'OR', name:"OR"},{id:'AND', name:"AND"}];
$scope.conditionarr2 = [];
$scope.filterarr = [{id:0, condition1:"AND", column:"", condition2:"", textvalue:"" }];

/////////////////////////////
$scope.getId = function($id) {
	$scope.dashboardid=$id;
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletedashboard/'+$scope.dashboardid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				
				errorMessage(data.errorMsg);
			}
			$scope.dashboardid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.fetchmodel = function($tabid)
{
	
	$scope.hastrue=true;
	var xsrf = $.param({tabid: $tabid});
	$http({
        url: path+'leave/getdashboardingmodule',
        method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulesarr=data.data;
				
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.fetchmodelcolumn = function()
{	
	
	if($scope.modulename.length>2 && $scope.tabid!=5){
			
			errorMessage('Choose only 2 Modules..');
		
	}
	else{
		$scope.hastrue=true;
		var xsrf = $.param({tablename: $scope.modulename});
		$http({
			url: path+'employee/getcolumnname',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
					
					$scope.columnsarr=data.data;
					$scope.datefiltercolumn=[];
					$scope.filtercolumn=[];
					
					
					if($scope.filterarr.length == 0){
					$scope.filterarr = [{id:0, condition1:"AND", column:"", condition2:"", textvalue:"" }]; }
					$scope.selectedcolumnsarr=new Array();
					//$scope.groupcolumnsarr = data.data;
					//name: "EmployeeCode", label: "Employee Code", type: "var", colindex: ""
					for(var i=0;i<$scope.columnsarr.length;i++){
						
							$scope.filtercolumn.insert(i, {name: $scope.columnsarr[i]['name'], label: $scope.columnsarr[i]['label'], type: $scope.columnsarr[i]['type'], colindex:$scope.columnsarr[i]['colindex'],tablename:$scope.columnsarr[i]['tablename']});
						
					}
					for(var i=0;i<$scope.columnsarr.length;i++){
						if($scope.columnsarr[i]['type'] == 'dat'){
							$scope.datefiltercolumn.insert(i, {name: $scope.columnsarr[i]['name'], label: $scope.columnsarr[i]['label'], type: $scope.columnsarr[i]['type'], colindex:$scope.columnsarr[i]['colindex']});
						}
					}
					
					
				}	
							
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}	
}

$scope.onchangecol = function($val,$index){
	//alert($index+" "+$scope.filterarr[$index]['type']+" "+$val);
	
	for(var i=0;i<$scope.filtercolumn.length;i++){
		if($scope.filtercolumn[i]['name']==$val){
		
		$scope.filterarr[$index]['type']= $scope.filtercolumn[i]['type'];
		$scope.filterarr[$index]['tablename']= $scope.filtercolumn[i]['tablename'];
		}
	}
	
	if($scope.filterarr[$index]['type'] == 'var' || $scope.filterarr[$index]['type'] == 'tex' || $scope.filterarr[$index]['type'] == 'dat' || $scope.filterarr[$index]['type'] == 'int' || $scope.filterarr[$index]['type'] == 'tin'){
		$scope.conditionarr2[$index]=[];
		$scope.conditionarr2[$index] = [{id:'=', name:"is equal to"},{id:'<>', name:"is not equal to"}];
		$scope.filtercolumnsarr[$index]=[];
	}
	else if($scope.filterarr[$index]['type'] == 'flo' || $scope.filterarr[$index]['type'] == 'dou') {
	$scope.conditionarr2[$index]=[];
		$scope.conditionarr2[$index] = [{id:'=', name:"is equal to"},{id:'<', name:"is less than"},{id:'>', name:"is greater than"},{id:'<=', name:"is less than equal to"},{id:'>=', name:"is greater than equal to"},{id:'<>', name:"is not equal to"}];
		$scope.filtercolumnsarr[$index]=[];
	}
	
	
	if(($scope.filterarr[$index]['type'] == 'tin' || $scope.filterarr[$index]['type'] == 'int') ){
		if($scope.filterarr[$index]['tablename'] != ""){
			var xsrf = $.param({tablename: $scope.modulename,columnname:$val});
			$http({
				url: path+'leave/getcolumnvalues',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			  }).success(function (data, status, headers, config) {
					if(data.status){
						$scope.filtercolumnsarr[$index]=[];
						$scope.filtercolumnsarr[$index]=data.data;
					}			
					$scope.hastrue=false;
				}).error(function (data, status, headers, config) {
					errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
					$scope.hastrue=false;
				});
		}else{
			$scope.filterarr[$index]['type'] ="";
		}
	}
}
$scope.toggleSelection = function($x) {
	
	  if($scope.columnsarr[$x].vsts){		
		$scope.columnsarr[$x].vsts=false;
	  }else{
		$scope.columnsarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.columnsarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.columnsarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
$scope.toggleSelection1 = function($x) {
	
	  if($scope.selectedcolumnsarr[$x].vsts){		
		$scope.selectedcolumnsarr[$x].vsts=false;
	  }else{
		$scope.selectedcolumnsarr[$x].vsts=true;
	  }
	  $scope.rightdisable=true;
	  var len = $scope.selectedcolumnsarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedcolumnsarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
   };  
$scope.onAddSelection = function()
{
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	for ( var i=0; i<$scope.columnsarr.length; i++) {
			if ($scope.columnsarr[i].vsts){ 
				$scope.columnsarr[i].vsts=false;
				$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.columnsarr[i]);
				$scope.columnsarr[i].vsts=true;
				}
		  }
	for ( var i=$scope.columnsarr.length-1; i>=0; i--) {
			if ($scope.columnsarr[i].vsts){ 
				$scope.columnsarr.remove(i);
			}
	}
	for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			$scope.selectedcolumnsarr[i].vsts=false;
		  }
		  
		  $scope.totalcolarr=[];
		for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
			if($scope.selectedcolumnsarr[i].type=='int' || $scope.selectedcolumnsarr[i].type=='flo' || $scope.selectedcolumnsarr[i].type=='dou'){
				if($scope.selectedcolumnsarr[i].tablename=='')
				$scope.totalcolarr.push($scope.selectedcolumnsarr[i]);
			}
		}
		  $scope.groupcolumnsarr=[];
		for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
			/*if($scope.totalcolarr.length>0){
				for(var j=0;j<$scope.totalcolarr.length;j++){
					if($scope.selectedcolumnsarr[i].name != $scope.totalcolarr[j].name)
						$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
					}
				}
			else{
				
			}*/
			$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
		}
		
		
}

$scope.onRemoveSelection = function()
{
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			if ($scope.selectedcolumnsarr[i].vsts){ 
				$scope.selectedcolumnsarr[i].vsts=false;
				$scope.columnsarr.insert($scope.columnsarr.length,$scope.selectedcolumnsarr[i]);
				$scope.selectedcolumnsarr[i].vsts=true;
				}
		  }
	for ( var i=$scope.selectedcolumnsarr.length-1; i>=0; i--) {
			if ($scope.selectedcolumnsarr[i].vsts){ 
				$scope.selectedcolumnsarr.remove(i);
			}
	}
	for ( var i=0; i<$scope.columnsarr.length; i++) {
			$scope.columnsarr[i].vsts=false;
		  }
		 
		$scope.totalcolarr=[];
		for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
			if($scope.selectedcolumnsarr[i].type=='int' || $scope.selectedcolumnsarr[i].type=='flo' || $scope.selectedcolumnsarr[i].type=='dou'){
				if($scope.selectedcolumnsarr[i].tablename=='')
				$scope.totalcolarr.push($scope.selectedcolumnsarr[i]);
			}
		}
		$scope.groupcolumnsarr=[];
		for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
			/*if($scope.totalcolarr.length>0){
				for(var j=0;j<$scope.totalcolarr.length;j++){
					if($scope.selectedcolumnsarr[i].name != $scope.totalcolarr[j].name)
						$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
					}
				}
			else{
				$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
			}*/
			
			$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
		}		
}
	var move = function (origin, destination) {
        var temp = $scope.selectedcolumnsarr[destination];
        $scope.selectedcolumnsarr[destination] = $scope.selectedcolumnsarr[origin];
        $scope.selectedcolumnsarr[origin] = temp;
    };
 
    $scope.moveUp = function(){ 
		
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			if ($scope.selectedcolumnsarr[i].vsts){ 
				if(i != 0){
					move(i, i - 1);
					}
					//break;
					$scope.selectedcolumnsarr[i].vsts=false;
				}
				
		  }
    };
	
    $scope.moveDown = function(){  
		
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			if ($scope.selectedcolumnsarr[i].vsts){ 
				if(i < $scope.selectedcolumnsarr.length-1){
					
					move(i, i + 1);
					
				}
				$scope.selectedcolumnsarr[i].vsts=false;
				break;
			}
		 } 
    };
$scope.addfilter = function($i)
{	
	var len = $scope.filterarr.length-1;
	if($scope.filterarr[len]['column'] == "" || $scope.filterarr[len]['condition2'] == "" || $scope.filterarr[len]['textvalue'] == ""){
		errorMessage("Fill all the fields");
	}else{
		$scope.filterarr.insert($i, {id:0, condition1:"AND", column:"", condition2:"", textvalue:"" });
	}
}
$scope.removefilter = function($i)
{
	
	$scope.filterarr.remove($i);
	if($scope.filterarr.length == 0)
	{
		$scope.filterarr.insert($i, {id:0, condition1:"AND", column:"", condition2:"", textvalue:"" });
	}
}

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
$scope.onfetchdashboard =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({dashboardid: $id});
	$http({
        url: path+'leave/getadashboard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.todaydate=data.date;
				$scope.dashboardname=data.data[0]['name'];
				$scope.dashboardype=data.data[0]['dashboardype'];
				$scope.totalcolumn=data.data[0]['totalcolumn'];
				$scope.customsts = data.data[0]['customsts'];
				if(data.data[0]['module'] != ""){
				$scope.modulename=data.data[0]['module'].split(',');
				$scope.fetchmodelcolumn();
				}
				var temparr= data.data[0]['selectedcol'];
				
				$timeout(function(){
				
					for ( var x=0; x<temparr.length; x++){
						for ( var i=0; i<$scope.columnsarr.length; i++){
							if ($scope.columnsarr[i].name == temparr[x]){ 
								$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.columnsarr[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.columnsarr.remove(i);
							}
						}
					}
					
					
					for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
						if($scope.selectedcolumnsarr[i].type=='int' || $scope.selectedcolumnsarr[i].type=='flo' || $scope.selectedcolumnsarr[i].type=='dou'){
							if($scope.selectedcolumnsarr[i].tablename=='')
							$scope.totalcolarr.push($scope.selectedcolumnsarr[i]);
						}
					}
					
					for(var i=0;i<$scope.selectedcolumnsarr.length;i++){
						/*if($scope.totalcolarr.length>0){
							for(var j=0;j<$scope.totalcolarr.length;j++){
								if($scope.selectedcolumnsarr[i].name != $scope.totalcolarr[j].name)
								$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
							}
						}
						else{
							
						}*/
						$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
						
					}
				
				
				if(data.data[0]['groupby'] != ""){
					if((data.data[0]['groupby']).indexOf (',') > -1){
						var gru=data.data[0]['groupby'].split(' ');
						var groupby1=gru[0].split(' ');
						var groupby2=gru[1].split(' ');
						
						$scope.groupby1=gru[0];
						$scope.orderby1=gru[1].replace(",",'');
						$scope.groupby2=gru[2];
						$scope.orderby2=gru[3];
						$scope.orderbytype=gru[4];
					}
					else{
						var gru=data.data[0]['groupby'].split(' ');
						$scope.groupby1=gru[0];
						$scope.orderby1=gru[1];
						$scope.orderbytype=gru[2];
					}
				}
				
				
				var temp=data.data[0]['dashboardfilter'];	
				
				if(temp.length == 0){
					$scope.filterarr.insert(0, {id:0, condition1:"AND", column:"", condition2:"", textvalue:"" });
				}else{
					 if(temp[0]['condition2'] == 'between'){
							$scope.datefilterid=temp[0]['id'];
							$scope.datefilter = temp[0]['column'];
							$scope.datecondition = temp[0]['condition2'];
							if(temp[0]['textvalue'] != ""){
								var a=temp[0]['textvalue'].split("'AND'");
								$scope.fromdate = a[0].replace(/'/g, "");
								$scope.todate = a[1].replace(/'/g, "");
								
							}
							
						}
						else if(temp[0]['type'] == 'dat' || temp[0]['type'] == ''){
							$scope.datefilterid=temp[0]['id'];
							$scope.datefilter = temp[0]['column'].replace( /(^.*\(|\).*$)/g, '' );
							if(temp[0]['textvalue'] == 'YEAR(NOW()) AND MONTH(DOL)= MONTH(NOW())-1')
							$scope.datecondition = 'lmonth';
							else if(temp[0]['textvalue'] == 'YEAR(NOW()) AND MONTH(DOL)= MONTH(NOW())')
							$scope.datecondition = 'tmonth';
							else if(temp[0]['textvalue'] == 'CURDATE()' )
							$scope.datecondition = 'today';
							else if(temp[0]['textvalue'] == 'CURDATE() + INTERVAL 1 DAY' )
							$scope.datecondition = 'tomorrow';
							else if(temp[0]['textvalue'] == 'CURDATE() - INTERVAL 1 DAY' )
							$scope.datecondition = 'yesterday';
							else if(temp[0]['textvalue'] == '(CURDATE() - INTERVAL 1 WEEK) and CURDATE()' )
							$scope.datecondition = 'lweek';
							else if(temp[0]['textvalue'] == 'WEEKOFYEAR(NOW()) and YEAR('+$scope.datefilter+')=YEAR(NOW())' )
							$scope.datecondition = 'tweek';
							else if(temp[0]['textvalue'] == '(CURDATE() + INTERVAL 1 WEEK) and (CURDATE() + INTERVAL 2 WEEK)' )
							$scope.datecondition = 'nweek';
							else if(temp[0]['textvalue'] == 'YEAR(NOW()) AND MONTH('+$scope.datefilter+')= MONTH(NOW())' )
							$scope.datecondition = 'tmonth';
							else if(temp[0]['textvalue'] == 'DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH), "%Y-%m-01") and LAST_DAY(NOW() - INTERVAL 1 MONTH)' )
							$scope.datecondition = 'lmonth';
							else if(temp[0]['textvalue'] == 'DATE_FORMAT(DATE_ADD(CURDATE(), INTERVAL 1 MONTH), \"%Y-%m-01\") and LAST_DAY(CURDATE() + INTERVAL 1 MONTH)' )
							$scope.datecondition = 'nmonth';
							else if(temp[0]['textvalue'] == 'YEAR(NOW())' )
							$scope.datecondition = 'tyear';
							else if(temp[0]['textvalue'] == 'YEAR(NOW())-1' )
							$scope.datecondition = 'lyear';
							else if(temp[0]['textvalue'] == 'YEAR(NOW())+1' )
							$scope.datecondition = 'nyear';
							
							$scope.onchangecondition();
							
						}
						
						if(temp.length>1){
							$scope.filterarr=data.data[0]['dashboardfilter'];	
							$scope.filterarr.remove(0);
							for(var i=0;i<$scope.filterarr.length;i++)
							{
								$scope.onchangecol($scope.filterarr[i].column,i);
								
							}		
						}
				}
				
				}, timeo); 
				
			}
				
				$scope.todaydate=data.date;
				$scope.dateformat=data.dateformat;
				
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
			
		});
}

$scope.onfetchdashboard1 =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({dashboardid: $id});
	$http({
        url: path+'setup/getadashboard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				var dashboardname=data.data[0]['name'].charAt(0).toUpperCase() + data.data[0]['name'].slice(1);
				
				var aryColTableChecked = data.data[0]['dashboardcolumns'];
				$scope.customsts = data.data[0]['customsts'];
				
				var org=data.orgdetails[0]['org']+"<br>"+data.orgdetails[0]['email']+"<br>"+data.orgdetails[0]['phone']+"<br>"+data.orgdetails[0]['city']+"<br>"+data.orgdetails[0]['country'];
				var img ="<img src='"+data.orgdetails[0]['image']+"' id='img1' />";
				
				
				$('#header').html("<div class='row'><div class='col-xs-3'>"+img+"</div><div class='col-xs-5' style='text-align:center' ><h3>"+dashboardname+"</h3></div><div class='col-xs-4' id='org' style='text-align:right;padding-right:20px'>"+org+"</div></div>"); 
				 
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangecondition = function()
{
	$scope.tempar=new Array();
	var currentDate = new Date($scope.todaydate);
	var tomorrow = new Date($scope.todaydate);
	
	if($scope.datecondition == 'today'){
		$( "#fromdate" ).datepicker( "option", "dateFormat", $scope.dateformat );
		$scope.fromdate=currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.todate=currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'=', textvalue: 'CURDATE()' });
		
		
		
	}
	else if($scope.datecondition == 'tomorrow'){
		$scope.fromdate=currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
		tomorrow.setDate(tomorrow.getDate() + 1);
		$scope.todate=tomorrow.getDate() +'/'+ (tomorrow.getMonth()+1) +'/'+ tomorrow.getFullYear() ;
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'=', textvalue: 'CURDATE() + INTERVAL 1 DAY' });
		
		
	}
	else if($scope.datecondition == 'yesterday'){
		
		tomorrow.setDate(tomorrow.getDate() - 1);
		
		$scope.fromdate=tomorrow.getDate() +'/'+ (tomorrow.getMonth()+1) +'/'+ tomorrow.getFullYear() ;
		$scope.todate=currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'=', textvalue: 'CURDATE() - INTERVAL 1 DAY' });
		
		
	}
	else if($scope.datecondition == 'tweek'){
		
		tomorrow.setDate(tomorrow.getDate() - tomorrow.getDay());	
		$scope.fromdate=tomorrow.getDate() +'/'+ (tomorrow.getMonth()+1) +'/'+ tomorrow.getFullYear() ;
		$scope.todate= (currentDate.getDate() - currentDate.getDay() + 6) +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:'WEEKOFYEAR('+$scope.datefilter+')', condition2:'=', textvalue: 'WEEKOFYEAR(NOW()) and YEAR('+$scope.datefilter+')=YEAR(NOW())' });
		
		
	}
	else if($scope.datecondition == 'lweek'){
	
		tomorrow.setDate(tomorrow.getDate() - tomorrow.getDay() -7);	
		$scope.fromdate=tomorrow.getDate() +'/'+ (tomorrow.getMonth()+1) +'/'+ tomorrow.getFullYear() ;
		currentDate.setDate(tomorrow.getDate() + 6 );
		$scope.todate= currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'BETWEEN', textvalue: '(CURDATE() - INTERVAL 1 WEEK) and CURDATE()' });
		
		
	}
	else if($scope.datecondition == 'nweek'){
	
		tomorrow.setDate(tomorrow.getDate() - tomorrow.getDay() +7);	
		$scope.fromdate=tomorrow.getDate() +'/'+ (tomorrow.getMonth()+1) +'/'+ tomorrow.getFullYear() ;
		currentDate.setDate(tomorrow.getDate() + 6 );
		$scope.todate= currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'BETWEEN', textvalue: '(CURDATE() + INTERVAL 1 WEEK) and (CURDATE() + INTERVAL 2 WEEK)' });
		
		
	}
	else if($scope.datecondition == 'tmonth'){
		currentDate.setMonth(currentDate.getMonth()+1 ,0);
		$scope.fromdate  = 1  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:'YEAR('+$scope.datefilter+')', condition2:'=', textvalue: 'YEAR(NOW()) AND MONTH('+$scope.datefilter+')= MONTH(NOW())' });
		
		
	}
	else if($scope.datecondition == 'lmonth'){
		currentDate.setMonth(currentDate.getMonth() ,0);
		$scope.fromdate  = 1  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'BETWEEN', textvalue: 'DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH), "%Y-%m-01") and LAST_DAY(NOW() - INTERVAL 1 MONTH)' });
		
		
	}
	else if($scope.datecondition == 'nmonth'){
		currentDate.setMonth(currentDate.getMonth()+2 ,0);
		$scope.fromdate  = 1  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:'BETWEEN', textvalue: 'DATE_FORMAT(DATE_ADD(CURDATE(), INTERVAL 1 MONTH), "%Y-%m-01") and LAST_DAY(CURDATE() + INTERVAL 1 MONTH)' });
		
		
	}
	else if($scope.datecondition == 'tyear'){
		currentDate.setFullYear(currentDate.getFullYear(),11,31);
		
		$scope.fromdate  = 1  +'/'+ 1 +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:'YEAR('+$scope.datefilter+')', condition2:'=', textvalue: 'YEAR(NOW())' });
		
		
	}
	else if($scope.datecondition == 'lyear'){
		currentDate.setFullYear(currentDate.getFullYear()-1,11,31);
		$scope.fromdate  = 1  +'/'+ 1 +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:'YEAR('+$scope.datefilter+')', condition2:'=', textvalue: 'YEAR(NOW())-1' });
		
		
	}
	else if($scope.datecondition == 'nyear'){
		currentDate.setFullYear(currentDate.getFullYear()+1,11,31);
		$scope.fromdate  = 1  +'/'+ 1 +'/'+ currentDate.getFullYear();
		$scope.todate = currentDate.getDate()  +'/'+ (currentDate.getMonth()+1) +'/'+ currentDate.getFullYear();
		
			$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:'YEAR('+$scope.datefilter+')', condition2:'=', textvalue: 'YEAR(NOW())+1' });
		
	}
	else if($scope.datecondition == 'between'){
		$scope.fromdate="";
		$scope.todate="";
	}else{
		$scope.fromdate="";
		$scope.todate="";
		$scope.tempar=[{id:$scope.datefilterid, condition1:0, column:0, condition2:"", textvalue: 0 }];
	}

}

$scope.onfetchtable=function($val){

$( "#refresh_div" ).show();
	$scope.hastrue=true;
	var xsrf = $.param({dashboardid:$scope.dashboardid, fromdate:$scope.from, todate:$scope.to,division:$scope.division});
  $http({
        url: path+'leave/daterangedashboard/'+$val,
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				//var dashboardid=data.dashboardid;
				var from=data.startdate;
				var to=data.enddate;
				var fiscalview='['+from+' - '+to+']';
				$('#fiscalview').text(fiscalview);
				$scope.leavedashboardarr=data.data;
				if($val==1)
				document.getElementById('output').innerHTML=$scope.leavedashboardarr;
				//$scope.table.draw();
				//$timeout(function(){window.open(path+"leave/viewdashboard/"+dashboardid, '_self');}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});

}

$scope.onfetchtable1=function($val){

$( "#refresh_div" ).show();
	$scope.hastrue=true;
	var xsrf = $.param({dashboardid:$scope.dashboardid, division:$scope.division,fromdate:$scope.from, todate:$scope.to});
  $http({
        url: path+'employee/divisionwisedashboard/'+$val,
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				var from=data.startdate;
				var to=data.enddate;
				var fiscalview='['+from+' - '+to+']';
				$('#fiscalview').text(fiscalview);
				$scope.leavedashboardarr=data.data;
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});

}

$scope.oncreate = function($val)
{
if($scope.dashboardype==1)
{
	if($scope.totalcolumn == "")
	{
		errorMessage("Choose summary column");
		return;
	}
}

$scope.hastrue=true;
	if($scope.datecondition == 'between'){
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:$scope.datecondition, textvalue:$scope.fromdate+" 'AND' "+$scope.todate });
	}else{
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:0, column:0, condition2:0, textvalue:0 });
	}
var jsonData2=angular.toJson($scope.tempar);

var groupby ="";
if($scope.groupby1 != "" && $scope.groupby1 != null && $scope.groupby2 == ""){
 
	groupby=$scope.groupby1+" "+$scope.orderby1+" "+$scope.orderbytype;
}
else if($scope.groupby1 == "" && $scope.groupby2 != "" && $scope.groupby2 != null){
 
	groupby=$scope.groupby2+" "+$scope.orderby2+" "+$scope.orderbytype;
}
else if($scope.groupby1 != "" && $scope.groupby1 != null && $scope.groupby2 != ""  && $scope.groupby2 != null){
 	groupby=$scope.groupby1+" "+$scope.orderby1+", "+$scope.groupby2+" "+$scope.orderby2+" "+$scope.orderbytype;
}
else{
	groupby="";
}
$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
var jsonData1=angular.toJson($scope.filterarr);

var xsrf = $.param({dashboardname:$scope.dashboardname, modulename:$scope.modulename, selectcol:$scope.selectedcol,selectcrit:$scope.selectedcriteria, groupby:groupby,filter:jsonData1,dashboardype:$scope.dashboardype,totalcolumn:$scope.totalcolumn,datefilter: jsonData2,tabid:$scope.tabid});
  $http({
        url: path+'setup/createdashboard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.filterarr = [{id:0, condition1:"AND", column:"", condition2:"", textvalue:"" }];
				var dashboardid=data.dashboardid;
				if($val==11){
					$timeout(function(){window.open(path+"employee/dashboard", "_self");}, timeo);
					$timeout(function(){window.open(path+"employee/viewdashboard/"+dashboardid, '');}, timeo);
					
				}
				if($val==22){
					$timeout(function(){window.open(path+"attendance/dashboard", "_self");}, timeo);
					$timeout(function(){window.open(path+"attendance/viewdashboard/"+dashboardid, "");}, timeo);
					
				}
				if($val==33){
					$timeout(function(){window.open(path+"leave/dashboard", "_self");}, timeo);
					$timeout(function(){window.open(path+"leave/viewdashboard/"+dashboardid, "");}, timeo);
					
				}
				if($val==44){
					$timeout(function(){window.open(path+"salary/dashboard", "_self");}, timeo);
					$timeout(function(){window.open(path+"salary/viewdashboard/"+dashboardid, "");}, timeo);
					
				}
				if($val==55){
					$timeout(function(){window.open(path+"setup/dashboard", "_self");}, timeo);
					$timeout(function(){window.open(path+"setup/viewdashboard/"+dashboardid, "");}, timeo);
					
				}
				
				if($val==1){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"employee/dashboard", "_self");}, timeo);
				}
				else if($val==2){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"attendance/dashboard", "_self");}, timeo);
				}
				else if($val==3){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"leave/dashboard", "_self");}, timeo);
				}
				else if($val==4){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"salary/dashboard", "_self");}, timeo);
				}
				else if($val==5){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"setup/dashboard", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{



if($scope.dashboardype==1)
{
	if($scope.totalcolumn == "")
	{
		errorMessage("Choose summary column");
		return;
	}
}else{
	$scope.totalcolumn = "";
}
$scope.hastrue=true;

	if($scope.datecondition == 'between'){
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:"AND", column:$scope.datefilter, condition2:$scope.datecondition, textvalue:$scope.fromdate+"'AND'"+$scope.todate });
	}else{
		$scope.tempar.insert (0,{id:$scope.datefilterid, condition1:0, column:0, condition2:0, textvalue:0 });
	}

var groupby ="";
if($scope.groupby1 != "" && $scope.groupby1 != null && $scope.groupby2 == ""){
 
	groupby=$scope.groupby1+" "+$scope.orderby1+" "+$scope.orderbytype;
}
else if($scope.groupby1 == "" && $scope.groupby2 != "" && $scope.groupby2 != null){
 
	groupby=$scope.groupby2+" "+$scope.orderby2+" "+$scope.orderbytype;
}
else if($scope.groupby1 != "" && $scope.groupby1 != null && $scope.groupby2 != ""  && $scope.groupby2 != null){
 	groupby=$scope.groupby1+" "+$scope.orderby1+", "+$scope.groupby2+" "+$scope.orderby2+" "+$scope.orderbytype;
}
else{
	groupby="";
}

$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
var jsonData1=angular.toJson($scope.filterarr);
var jsonData2=angular.toJson($scope.tempar);

var xsrf = $.param({dashboardid: $scope.dashboardid,dashboardname: $scope.dashboardname, modulename:$scope.modulename, selectcol:$scope.selectedcol,selectcrit:$scope.selectedcriteria, groupby:groupby,filter:jsonData1,dashboardype:$scope.dashboardype,totalcolumn:$scope.totalcolumn,datefilter: jsonData2, tabid:$scope.tabid,customsts:$scope.customsts});
  $http({
        url: path+'setup/updateddashboard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				var dashboardid=data.dashboardid;
				
				if($val==11){
					
					$timeout(function(){window.open(path+"employee/viewdashboard/"+dashboardid, '_blank');}, timeo);
					$timeout(function(){window.open(path+"employee/editdashboard/"+dashboardid, '_self');}, timeo);
					
				}
				if($val==22){
					$timeout(function(){window.open(path+"attendance/viewdashboard/"+dashboardid, '_blank');}, timeo);
					$timeout(function(){window.open(path+"attendance/editdashboard/"+dashboardid, '_self');}, timeo);
				}
				if($val==33){
					$timeout(function(){window.open(path+"leave/viewdashboard/"+dashboardid, '_blank');}, timeo);
					$timeout(function(){window.open(path+"leave/editdashboard/"+dashboardid, '_self');}, timeo);
				}
				if($val==44){
					$timeout(function(){window.open(path+"salary/viewdashboard/"+dashboardid, '_blank');}, timeo);
					$timeout(function(){window.open(path+"salary/editdashboard/"+dashboardid, '_self');}, timeo);
				}
				if($val==55){
					$timeout(function(){window.open(path+"setup/viewdashboard/"+dashboardid, '_blank');}, timeo);
					$timeout(function(){window.open(path+"setup/editdashboard/"+dashboardid, '_self');}, timeo);
				}
				
				if($val==1){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"employee/dashboard", "_self");}, timeo);
				}
				else if($val==2){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"attendance/dashboard", "_self");}, timeo);
				}
				else if($val==3){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"leave/dashboard", "_self");}, timeo);
				}
				else if($val==4){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"salary/dashboard", "_self");}, timeo);
				}
				else if($val==5){
					//window.open(path+"leave/dashboard", "_self");
					$timeout(function(){window.open(path+"setup/dashboard", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

 function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==1){
						$scope.divisionarray=[];
						$scope.divisionarray=data.data;
						$scope.divisionarray.insert(0,{id:0,name:"------All-------"});
                                               
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}


});

/////////////////////////// Personnel requisition Controller Starts From Here  ///////////////////////////////////

app.controller('personnel_requisitionCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.perid=0;
	$scope.postitle=0;
	$scope.totalvacancy=0;
	$scope.nationality=0;
	$scope.minage="";
	$scope.maxage="";
	$scope.minsal="";
	$scope.maxsal="";
	$scope.gender=0;
	$scope.newpostion=0;
	$scope.emptype=0;
	$scope.qualification=0;
	$scope.minexperience="";
	$scope.maxexperience="";
	$scope.budgetapp=0;
	$scope.deadline=0;
	
	$scope.getId = function($id) {
	$scope.perid=$id;
}
Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletepersonnel_requisition/'+$scope.perid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.perid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
onfetch('setup/getalldesignation',1);
onfetch('tabledata/index/NationalityMaster',2);
onfetch('employee/getallqualification',3);
onfetch('other',4);
onfetch('employee/getallemptype',5);

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.desigarray=[];
					$scope.desigarray=data.data;
					//$scope.divisionarray.insert(0,{id:0,name:"Select Division"});
				}else if($id==2){
					$scope.nationarray=[];
					$scope.nationarray=data.data;
				}else if($id==3){
					$scope.qualarray=[];
					$scope.qualarray=data.data;
				}else if($id==4){
					$scope.otherarray=[];
					$scope.otherarray=data.data;
					$scope.otherarray.insert(83, {id:"188", type:"Gender", name:"Both", value:"3"});
					console.log($scope.otherarray);
				}else if($id==5){
					$scope.emptypearray=[];
					$scope.emptypearray=data.data;
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}	
	
	$scope.onfetchpersonnel_requisition =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({perid: $id});
		$http({
			url: path+'setup/getpersonnel_requisition',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				$('#msg1').data("wysihtml5").editor.setValue(data.data[0]['desc']);
				$scope.perid=data.data[0]['id'];	
				$scope.postitle=data.data[0]['designationid'];
				$scope.totalvacancy=data.data[0]['vacancy'];
				$scope.nationality=data.data[0]['nationality'];
				if(data.data[0]['agelimit'] != "")
				{
					var agelimit=data.data[0]['agelimit'].split(',');
					$scope.minage=Number(agelimit[0]);
					$scope.maxage=Number(agelimit[1]);
				}
				if(data.data[0]['salaryrange'] != "")
				{
					var agelimit=data.data[0]['salaryrange'].split(',');
					$scope.minsal=Number(agelimit[0]);
					$scope.maxsal=Number(agelimit[1]);
				}
				
				if(data.data[0]['experience'] != "")
				{
					var agelimit=data.data[0]['experience'].split(',');
					$scope.minexperience=Number(agelimit[0]);
					$scope.maxexperience=Number(agelimit[1]);
				}
				$scope.gender=data.data[0]['gender'];
				$scope.newpostion=data.data[0]['position'];
				$scope.emptype=data.data[0]['emptype'];
				$scope.qualification=data.data[0]['qualification'];
				
				$scope.budgetapp=data.data[0]['budgetapp'];
				$scope.deadline=data.data[0]['deadline'];	
				
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onaddcomment = function($id)
	{
		
		 $('#comment').modal('show');
		 $scope.approverresult=$id;
		 
		 
	}
	$scope.onapprove = function($val)
	{ 
		
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ perid:$scope.perid, approverresult:$scope.approverresult, comment:$scope.comment });
		$http({
			url: path+'setup/approvepersonnel_requisition',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"setup/personnel_requisition", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val)
	{	
		
		$scope.hastrue=true;
		var xsrf = $.param({designationid:$scope.postitle,totalvacancy:$scope.totalvacancy,salaryrange:$scope.minsal+','+$scope.maxsal,nationality:$scope.nationality,gender:$scope.gender,agelimit:$scope.minage+','+$scope.maxage,position:$scope.newpostion,emptype:$scope.emptype,qualification:$scope.qualification,experience:$scope.minexperience+','+$scope.maxexperience,budgetapp:$scope.budgetapp,deadline:$scope.deadline,jobdesc:document.getElementById('msg1').value});
		$http({
			url: path+'setup/createpersonnel_requisition',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.personnel_requisitionname="";
					//$scope.categoryid="";
					//$scope.applydate="";			
					$scope.perid=0;	
					$scope.postitle=0;
					$scope.totalvacancy=0;
					$scope.nationality=0;
					$scope.minage="";
					$scope.maxage="";
					$scope.minsal="";
					$scope.maxsal="";
					$scope.gender=0;
					$scope.newpostion=0;
					$scope.emptype=0;
					$scope.qualification=0;
					$scope.minexperience="";
					$scope.maxexperience="";
					$scope.budgetapp=0;
					$scope.deadline=0;	
					document.getElementById('msg1').value="";
					if($val==1){
						//window.open(path+"setup/personnel_requisition", "_self");
						$timeout(function(){window.open(path+"setup/personnel_requisition", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({perid: $scope.perid, designationid:$scope.postitle,totalvacancy:$scope.totalvacancy,salaryrange:$scope.minsal+','+$scope.maxsal,nationality:$scope.nationality,gender:$scope.gender,agelimit:$scope.minage+','+$scope.maxage,position:$scope.newpostion,emptype:$scope.emptype,qualification:$scope.qualification,experience:$scope.minexperience+','+$scope.maxexperience,budgetapp:$scope.budgetapp,deadline:$scope.deadline,jobdesc:document.getElementById('msg1').value});
		$http({
			url: path+'setup/updatedpersonnel_requisition',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
					successMessage(data.successMsg);
					$scope.personnel_requisitionname="";
					//$scope.categoryid="";
					//$scope.applydate="";			
					$scope.perid=0;	
					$scope.postitle=0;
					$scope.totalvacancy=0;
					$scope.nationality=0;
					$scope.minage="";
					$scope.maxage="";
					$scope.minsal="";
					$scope.maxsal="";
					$scope.gender=0;
					$scope.newpostion=0;
					$scope.emptype=0;
					$scope.qualification=0;
					$scope.minexperience="";
					$scope.maxexperience="";
					$scope.budgetapp=0;
					$scope.deadline=0;	
					document.getElementById('msg1').value="";
				if($val==1){
					//window.open(path+"setup/personnel_requisition", "_self");
					$timeout(function(){window.open(path+"setup/personnel_requisition", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});

