/*! UBIHRM faq.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('resignapi', ['ngSanitize']);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


app.directive('myPostRepeatDirective', function() {
  return function(scope, element, attrs) {
    if (scope.$last){
      // iteration is complete, do whatever post-processing
      // is necessary
	 
		jQuery.fn.multiselect = function() {
			$(this).each(function() {
				var checkboxes = $(this).find("input:checkbox");
				checkboxes.each(function() {
					var checkbox = $(this);
					// Highlight pre-selected checkboxes
					if (checkbox.prop("checked"))
						checkbox.parent().addClass("multiselect-on");
		 
					// Highlight checkboxes that the user selects
					checkbox.click(function() {
						if (checkbox.prop("checked"))
							checkbox.parent().addClass("multiselect-on");
						else
							checkbox.parent().removeClass("multiselect-on");
					});
				});
			});
		};
		
		$(function() {
			 $(".multiselect").multiselect();
		});
    }
  };
});

app.filter('unique', function() {

  return function (arr, field) {
    var o = {}, i, l = arr.length, r = [];
	
    for(i=0; i<l;i++) {
	if(arr[i]['id']==field)
	
      o[arr[i]['name'] ]= arr[i];
    }
    for(i in o) {
      r.push(o[i]);
    }
    return r;
  };
})

	
app.controller('resignationCtrl', function($scope, $http, $timeout) {

$scope.subject="";
$scope.msg="";
$scope.resignsts='';
$scope.sts=false;
$scope.msglength=0;
	
		
	$scope.onfetchresignation= function()
	{

	$scope.hastrue=true;

	  $http({
		url: path+'profile/getemployeeresignation',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	      }).success(function (data, status, headers, config) {
				if(data.status)
				{
					
					$scope.subject=data.data[0]['subject'];	
					$scope.msg=data.data[0]['message'];
					document.getElementById('msg').value=data.data[0]['message'];
					$scope.resignsts=data.data[0]['resignsts'];
					$scope.sts=true;
				}
				else{
					
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
		    errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	
	$scope.onresignation = function($val)
	{	
		var msg1 = document.getElementById('msg').value;
		//alert('hello');
		if(msg1=='')
		{
			errorMessage("Message can not be left blank.");
			//document.getElementById('msg').focus();
			return false;
		}
		if(!confirm("Are you sure want to apply for your resignation ?"))
		{
			return false;
		}
		
		//return false;
		$scope.hastrue=true;
		var xsrf = $.param({subject:$scope.subject, msg:msg1});
		$http({
			url: path+'profile/employeeresignation',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
										
					if($val==1){
						//window.open(path+"profile/change_password", "_self");
						$timeout(function(){window.open(path+"profile/resignation", "_self");}, timeo);
					}
					
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	

	
});
