/*! UBIPROJECT project.js
 * ================
 *
 * @Author  Jaidev Sharma
 * @Email   <jaidev@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIPROJECT requires jQuery");
}

var app = angular.module('projectapp', ['ui.bootstrap', 'xeditable', 'ngSanitize']);
app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});

app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Project Controller Starts From Here  ///////////////////////////////////

app.controller('projectCtrl', function($scope, $http) {
$scope.maxSize = 5;
$scope.totalItems = 0;
$scope.currentPage = 1;
$scope.itemPerPage =10;

onLoadGetProjectsData();

function onLoadGetProjectsData()
{
$scope.hastrue=true;
  $http({
        url: path+'projects/getallprojects',
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.totalItems=data.length;
			getprojectsdata();
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
}

$scope.getallprojects=function(){
	getprojectsdata();
}

function getprojectsdata()
{
var limit =$scope.itemPerPage;
var offset=limit*($scope.currentPage-1);

$scope.projects=[];
$scope.hastrue=true;

var xsrf = $.param({limit: limit, offset:offset});
  $http({
        url: path+'projects/getallprojects',
        method: "POST",
        data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.projects = data; // assign  $scope.persons here as promise is resolved here 
			//alert($scope.names);
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error");//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
        });
};	

$scope.pageChanged = function() {
    //alert($scope.currentPage);
	getprojectsdata();
};

});


/////////////////////////// Project Details Controller Starts From Here  ///////////////////////////////////

app.controller('projectDetailCtrl', function($scope, $http, $interval) {

$scope.project = [];
$scope.tasks = [];
$scope.newtaskchart = [];

$scope.bugs = [];
$scope.users = [];
$scope.milestone=[];

$scope.projectid=0;
$scope.taskstart=0;
$scope.taskend=0;
$scope.currdate=0;
$scope.tasksts=0;
$scope.jsdata="";
$scope.taskchart=0;
$scope.bugchart=0;
$scope.totalbug=0;
//$scope.project_status="";

$scope.statusarr=[];
$scope.p_id=0;
$scope.projectcomment='';

$scope.milestonetask =[];
$scope.projectarray=[];
$scope.task = [];
$scope.milestonearray=[];
$scope.projectmilestonearray=[];

$scope.sec=0;
			  $scope.min=0;
			  $scope.hour=0;
			  $scope.timer="";
			  $scope.progressvalue = 0;
			  $scope.minuspval=0;
			  
$scope.comments = [];
$scope.project_status="";
$scope.hastrue=false;
$scope.isDisabled = true;
$scope.togglebutton=function(){
	if($scope.commentbox==""){
	$scope.isDisabled = true;
	}else{
		$scope.isDisabled = false;
	}
}




$scope.onload= function($id){
	$scope.projectid=$id;
	//alert($scope.projectid);
	onLoadGetCommentData();
	onLoadGetProjectData();

	onLoadGetProgressProjectData();

}

////////////////////////////////Project Milestone Data/////////////////////////////////////

function onLoadGetProgressProjectData()
{
$scope.hastrue=true;
$scope.milestonearray = [];

var xsrf = $.param({ id:$scope.projectid});
  $http({
        url: path+'projects/GetProgressProjectData',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.milestonearray=data;
			//alert(data[0]['totaltasks']);			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


/////////////////////////////////////////////////////////////////////

function settingsonload($stdate, $endate, $curdate, $sts){
	
	$scope.tasksts=$sts;
	if($stdate!="0000-00-00 00:00:00" && $endate!="0000-00-00 00:00:00"){
		$scope.taskstart=$stdate;
		$scope.taskend=$endate;
		$scope.currdate=$curdate;
	}
}
function onLoadGetProjectData()
{
$scope.hastrue=true;
$scope.project = [];
$scope.tasks = [];
$scope.bugs = [];
$scope.users = [];
$scope.newtaskchart = [];

  $http({
        url: path+'projects/getProjectDetail/'+$scope.projectid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	  //alert(data+" "+data.length);
			$scope.project = data[0]['projects']; // assign  $scope.persons here as promise is resolved here 
			$scope.tasks = data[0]['tasks'];
			$scope.bugs = data[0]['bugs'];
			$scope.users = data[0]['users'];
			$scope.newtaskchart = data[0]['newtaskchart'];

			
			//jQuery.parseJSON($scope.newtaskchart);
			//alert(jQuery.parseJSON(data[0]['newtaskchart']));
			//alert("End Date "+$scope.newtaskchart[0]['enddate']);

			//var obj = jQuery.parseJSON( '{ "name": "John" }' );
			//alert( obj.name === "John" );

			////////////////////////Code to eleminate "" from date///////////////////////////
			//alert($scope.newtaskchart[0]['startdate']);
			//alert($scope.newtaskchart[0]['enddate']);

			/////////////////////////////////////////////////////////////////////////////////

			var tcolor=[];
			var bcolor=[];
			for(var i=0; i<((data[0]['tasks']).length); i++)
			{
				
				if($scope.taskchart==0){
					$scope.taskchart= data[0]['tasks'][i].totalp;
				}else{
					$scope.taskchart+= ","+data[0]['tasks'][i].totalp;
				}
				
				//set task chart colors statuswise by jaidev on 8 Dec 2016
				if(data[0]['tasks'][i].statusid==13)
				{
					tcolor.push('#dd4b39');
				}
				if(data[0]['tasks'][i].statusid==15)
				{
					tcolor.push('#0073b7');
				}
				if(data[0]['tasks'][i].statusid==16)
				{
					tcolor.push('#f39c12');
				}
				if(data[0]['tasks'][i].statusid==18)
				{
					tcolor.push('#00a65a');
				}
				if(data[0]['tasks'][i].statusid==19)
				{
					tcolor.push('#d2d6de');
				}
				if(data[0]['tasks'][i].statusid==20)
				{
					tcolor.push('#00c0ef');
				}
				if(data[0]['tasks'][i].statusid==21)
				{
					tcolor.push('#39cccc');
				}
				if(data[0]['tasks'][i].statusid==22)
				{
					tcolor.push('#605ca8');
				}
				if(data[0]['tasks'][i].statusid==23)
				{
					tcolor.push('#f012be');
				}

			}
			for(var i=0; i<((data[0]['bugs']).length); i++)
			{
				$scope.totalbug=$scope.totalbug+parseInt(data[0]['bugs'][i].totalp);
				if($scope.bugchart==0){
					$scope.bugchart= data[0]['bugs'][i].totalp;
				}else{
					$scope.bugchart+= ","+data[0]['bugs'][i].totalp;
				}
				//set bug chart colors statuswise by jaidev on 8 Dec 2016
				if(data[0]['bugs'][i].statusid==13)
				{
					bcolor.push('#dd4b39');
				}
				if(data[0]['bugs'][i].statusid==15)
				{
					bcolor.push('#0073b7');
				}
				if(data[0]['bugs'][i].statusid==16)
				{
					bcolor.push('#f39c12');
				}
				if(data[0]['bugs'][i].statusid==18)
				{
					bcolor.push('#00a65a');
				}
				if(data[0]['bugs'][i].statusid==19)
				{
					bcolor.push('#d2d6de');
				}
				if(data[0]['bugs'][i].statusid==20)
				{
					bcolor.push('#00c0ef');
				}
				if(data[0]['bugs'][i].statusid==21)
				{
					bcolor.push('#39cccc');
				}
				if(data[0]['bugs'][i].statusid==22)
				{
					bcolor.push('#605ca8');
				}
				if(data[0]['bugs'][i].statusid==23)
				{
					bcolor.push('#f012be');
				}
			}
			if($scope.taskchart!=0){
			 //INITIALIZE SPARKLINE CHARTS
				document.getElementById('div1').innerHTML=$scope.taskchart;
				
			}
			if($scope.bugchart!=0){
			 //INITIALIZE SPARKLINE CHARTS
				document.getElementById('div2').innerHTML=$scope.bugchart;
				
			}
			
			/*if($scope.newtaskchart!=0){

				document.getElementById('jqChart').innerHTML=$scope.newtaskchart;
			}*/
			
			/*$(".sparkline").each(function () {
				  var $this = $(this);
				  $this.sparkline('html', $this.data());
				
				});*/
			//alert(new Date(2016,10,7));
			var i=0;
			$('.sparkline').each(function () {
			    var $this = $(this);
			    var setcolor=[];
				if(i++==0)
				{setcolor=tcolor;}
				else{setcolor=bcolor;}
			    $this.sparkline('html', {
			      type: 'pie',
			      height: $this.data('height') ? $this.data('height') : '90',
			      sliceColors: setcolor//$this.data('color') //['red','green','yellow']
			    });
			  });

				
			if(data.length>0){
				settingsonload(data[0]['projects'][0].startdate1, data[0]['projects'][0].enddate1, data[0]['projects'][0].currdate, data[0]['projects'][0].status1);
				$scope.randomStacked();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onLoadGetCommentData()
{
$scope.hastrue=true;
$scope.comments = [];
var xsrf = $.param({id: $scope.projectid, type:"PROJECT"});
  $http({
        url: path+'tasks/getallcomment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	  //alert(data+" "+data.length);
			$scope.comments =data;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.addcomment = function(){

$scope.hastrue=true;
	var xsrf = $.param({id: $scope.projectid, message:$scope.commentbox, type:"PROJECT"});
	if($scope.commentbox!="" && $scope.commentbox!="undefined"){
			$http({
				url: path+'tasks/addComment',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			  }).success(function (data, status, headers, config) {
					onLoadGetCommentData();
					$scope.hastrue=false;
					$scope.commentbox=""
				}).error(function (data, status, headers, config) {
					//alert("error: "+$scope.status);
					$scope.hastrue=false;
				});
		}else{
			$scope.hastrue=false;
		}
  };
 
 $scope.savestatus = function()
{	

	var xsrf = $.param({id: $scope.projectid, project_status:$scope.project_status});
  	$http({
				url: path+'projects/editprojectstatus',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				
				window.open(path+'projects/details/'+$scope.projectid, '_self');
			}
			
       }).error(function (data, status, headers, config) {
            //$scope.status = status + ' ' + headers;
			
	});
}

///////////////////Edited to add change status/////////////////////////
/*
 $scope.oneditstatus= function($id)
{	

	$scope.project_status=$id;

	$('#confirm1').modal('show');
} 
*/

///fetch all status
$scope.onfetchallstatus= function()
{
	//alert($scope.p_id);
	$http({
		url: path+'setting/getallstatus',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.statusarr=data;
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.onviewprojectplan = function()
{	
	$('#projectModal').modal('show');
}

$scope.viewprojectplan = function()
{
	var i=0;
	if(document.getElementById('chktask').checked==true)
	{
		i=1;
	}
	if(document.getElementById('chkbug').checked==true)
	{
		i=2;
	}
	if(document.getElementById('chktask').checked==true && document.getElementById('chkbug').checked==true)
	{
		i=3;
	}
	
	//$('#projectModal').modal('hide');
	window.open(path+'report/viewprojectplanreport/'+$scope.projectid+'/'+i, '_blank');
}

 $scope.oneditstatus= function()
{	

	$('#myModal').modal('show');
} 

$scope.saveprojectstatus = function()
{	
	
//alert($scope.p_id);
//return false;
	if($scope.p_id=='0')
{
	
	document.getElementById('pid').style.border='1px solid #d73925';
	return false;
}
else
{
	document.getElementById('pid').style.border='';
}
if($scope.projectcomment=='')
{
	document.getElementById('pcomment').style.border='1px solid #d73925';
	return false;
}
else
{
	document.getElementById('pcomment').style.border='';
}

	var xsrf = $.param({id: $scope.projectid, project_status:$scope.p_id, project_comment:$scope.projectcomment});
  	$http({
        url: path+'projects/editprojectstatus1',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				
				window.open(path+'projects/details/'+$scope.projectid, '_self');
			}
			
       }).error(function (data, status, headers, config) {
            //$scope.status = status + ' ' + headers;
			
	});
}
////////////////////////////////////////////  

 		
/*		
$scope.savestatus = function($id){
$scope.hastrue=true;

    //alert($id+" "+$pr);
	var xsrf = $.param({pid: $scope.projectid, status:$id});
	if($id!="" && $id!=undefined){
		if (confirm("Are you sure to change the status of project?") == true) {
        // todo code for deletion
    
			$http({
				url: path+'projects/editprojectstatus',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			  }).success(function (data, status, headers, config) {
					alert("success");	
					$scope.hastrue=false;
					onLoadGetProjectData();
				}).error(function (data, status, headers, config) {
					alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
					$scope.statusid="";$scope.hastrue=false;
				});
		}else{
		$scope.statusid="";$scope.hastrue=false;
		}
	}else{
	$scope.hastrue=false;
	}
  };*/
  
  $scope.randomStacked = function() {
    $scope.stacked = [];
    var types = ['danger', 'primary', 'warning', 'success'];

	//var types = ['danger', 'success', 'warning', 'primary'];
	var len = $scope.tasks.length;
	var total=0;

	for (var i = 0; i < (len); i++) 
	{
	total=total+parseInt($scope.tasks[i].totalp);
	}


	$scope.dynamic =0;
	$scope.type ="info";
	$scope.showWarning ="("+total+")";
	$scope.totaltask= total;
			
	var myval='';

	//alert(((total*($scope.tasks[0].totalp/100))));
    for (var i = 0; i < (len); i++) 
    {
        var val = ((100/total)*$scope.tasks[i].totalp);
		//alert(val);
		//alert($scope.tasks[i].statusid);

		
		if($scope.tasks[i].statusid==15){
			$scope.dynamic =val;
			$scope.showWarning ="("+$scope.tasks[i].totalp+"/"+total+")";
		}

		if($scope.tasks[i].statusid==16)
		{
			myval = 'warning';
		}

		if($scope.tasks[i].statusid==13)
		{
			myval = 'danger';
		}

		if($scope.tasks[i].statusid==18)
		{
			myval = 'success';
		}
		//alert(val);
		//alert(myval);
		//alert($scope.tasks[i].statusid);

        $scope.stacked.push({
          value: (val),
          type: myval//types[i]
        });
	//alert(val);
	//alert(types[i]);
    }
  };



///////// function for fusion chart /////////
$scope.onfetchfusionchartdata= function($pid)
{

	var xsrf = $.param({id: $pid});
  	$http({
		url: path+'projects/getprojectcalendar',
        	method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {

        $('#calendar').fullCalendar({
          header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
          },
          buttonText: {
            today: 'today',
            month: 'month',
            week: 'week',
            day: 'day'
          },
          //Random default events
          events: data['milestone'],//[{title:'Milestone1', start: '2016-10-25 00:00:00', end: '2016-11-04 23:00:00', allDay: false, backgroundColor: "#f39c12",borderColor: "#f39c12" }],
	      eventRender: function(event, element) {
            element.attr('title', event.tip);
          },     
  		  editable: false,
          droppable: false
        });
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}
////////////////////////////////////////////
  
});

/////////////////////////// Project Details Controller Starts From Here  ///////////////////////////////////

app.controller('projectsCtrl', function($scope, $http, $interval) {

$scope.refarray=[];
$scope.docarray=[];
$scope.pid=0;
$scope.referencelinkname="";
$scope.refid=0;
$scope.filename="";

$scope.onfetchref= function($id)
{
	$scope.pid=$id;
	//return false;
	var xsrf = $.param({ projectid:$scope.pid });
  	$http({
        url: path+'projects/getaprojectreferences',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			$scope.refarray=data.data;
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.onfetchdoc= function($id)
{
	$scope.pid=$id;
	//return false;
	var xsrf = $.param({ projectid:$scope.pid });
  	$http({
        url: path+'projects/getaprojectdocuments',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			$scope.docarray=data.data;
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.addReference= function($id)
{
	
	if($scope.referencelinkname=="")
	{
		alert('Please enter reference link name.');
		return false;
	}
	var xsrf = $.param({ projectid:$id, referencelinkname:$scope.referencelinkname});
  	$http({
        url: path+'projects/createprojectreference',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				$scope.referencelinkname="";
				//alert(data.successMsg);
				$('#InsertRef').modal('hide');
				$scope.onfetchref($scope.pid);
				$('#confirm4').modal('show');
				//window.open(path+'projects/editProject/'+$scope.pid, '_self');
			}
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.updateReference= function($id)
{
	//alert($scope.pid);
	//return false;
	if($scope.ureferencelinkname=="")
	{
		alert('Please enter reference link name.');
		return false;
	}
	//return false;
	var xsrf = $.param({ refid:$id, referencelinkname:$scope.ureferencelinkname});
  	$http({
        url: path+'projects/updateprojectreference',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				$scope.ureferencelinkname="";
				//alert(data.successMsg);
				$('#UpdateRef').modal('hide');
				$scope.onfetchref($scope.pid);
				$('#confirm3').modal('show');
				//window.open(path+'projects/editProject/'+$scope.pid, '_self');
				
			}
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.deleteReference= function($id)
{
	//alert($scope.pid);
	//return false;
	var xsrf = $.param({ refid:$id });
  	$http({
        url: path+'projects/deleteprojectreference',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				
				//alert(data.successMsg);
				$scope.onfetchref($scope.pid);
				$('#confirm2').modal('show');
				//window.open(path+'projects/editProject/'+$scope.pid, '_self');
				
			}
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.oneditreference= function($id)
{
	
	var xsrf = $.param({ refid:$id });
  	$http({
        url: path+'projects/getareference',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				$scope.refid=data.data[0]['id'];
				$scope.ureferencelinkname=data.data[0]['referencelinkname'];
				//alert(status.successMsg);
				$('#UpdateRef').modal('show');
			}
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.ondeletereference= function($refid)
{
	$scope.refid=$refid;
	$('#confirm').modal('show');
}

$scope.ondeletedocument= function($refid)
{
	$scope.refid=$refid;
	$('#confirm1').modal('show');
}


$scope.deleteDocument= function($id)
{
	//alert($scope.document.length);
	//alert($id);
	//return false;
	var xsrf = $.param({ refid:$id });
  	$http({
        url: path+'projects/deletedocument',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				
				///alert(data.successMsg);
				$('#confirm1').modal('hide');
				$scope.onfetchdoc($scope.pid);
				$('#confirm6').modal('show');
				//window.open(path+'projects/editProject/'+$scope.pid, '_self');
				
			}
			
       }).error(function (data, status, headers, config) {
            //alert("error: "+status);//$scope.status = status + ' ' + headers;
			
	});
}

//////////////////document upload///////////////////
	
	$scope.document = [];

    //listen for the file selected event
    $scope.$on("documentSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
			
        });
    });
	
	
	$scope.uploadDocument = function($id) {
	
	if($scope.document.length==0)
	{
		alert('Please select document');
		return false;
	}
	//return false;
	var projectid=$id;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"projects/uploadProjectDocument",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//errorMessage(document.getElementById(i).name);
                }
		
		formData.append('project_id',projectid);
		//formData.append('doc_id',docid);
                
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.document }
        }).
        success(function (data, status, headers, config) {
			
			if(data.status)
			{
				//alert(data.successMsg);
				$('#InsertDoc').modal('hide');
				$scope.onfetchdoc($scope.pid);
				$('#confirm5').modal('show');
				//window.open(path+'projects/editProject/'+projectid, '_self');
			}
			else
			{
				alert(data.errorMsg);
				$scope.document=[];
			}
			
		}).
        error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }


});

/////////////////////////// Topbar Controller Starts From Here  ///////////////////////////////////

app.controller('topbarCtrl', function($scope, $http) {

$scope.tasks=[];
$scope.totaltasks=0;

$scope.bugs=[];
$scope.totalbugs=0;

onfetchallnewtasks();
onfetchallnewbugs();

function onfetchallnewtasks()
{
	$http({
		url: path+'tasks/getallnewtasks',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.tasks=data.data;
			$scope.totaltasks=data.count;
						
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

function onfetchallnewbugs()
{
	$http({
		url: path+'bug/getallnewbugs',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.bugs=data.data;
			$scope.totalbugs=data.count;
						
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.onreadtask= function($tid)
{
   
   //alert($tid);
   //return false;
   if($tid!=0)
   {
	
	var xsrf = $.param({task_id: $tid});
	$http({
		url: path+'tasks/updatetaskviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'tasks/details/'+$tid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}

$scope.onreadbug= function($bid)
{
   
   //alert($tid);
   //return false;
   if($bid!=0)
   {
	
	var xsrf = $.param({bug_id: $bid});
	$http({
		url: path+'bug/updatebugviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'bug/details/'+$bid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}

/////////////////////////////On Read Bug Owner Status///////////////////////////////////////////////////
$scope.onreadbugbyowner= function($bid)
{
   
   //alert($tid);
   //return false;
   if($bid!=0)
   {
	
	var xsrf = $.param({bug_id: $bid});
	$http({
		url: path+'bug/updateownerbugviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'bug/details/'+$bid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}
/////////////////////////////On Read Bug Owner Status///////////////////////////////////////////////////

/////////////////////////////On Read Task Owner Status///////////////////////////////////////////////////
$scope.onreadtaskbyowner= function($tid)
{
   
   //alert($tid);
   //return false;
   if($tid!=0)
   {
	
	var xsrf = $.param({task_id: $tid});
	$http({
		url: path+'tasks/updateownertaskviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'tasks/details/'+$tid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}
/////////////////////////////On Read Task Owner Status///////////////////////////////////////////////////

});
