/*! UBIHRM faq.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('policyapi', ['ngSanitize']);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});



app.filter('unique', function() {
	
  return function (arr, field) {
    var o = {}, i,  r = [];
	if(arr != undefined){
		var l = arr.length;
		for(i=0; i<l;i++) {
		if(arr[i]['id']==field)
		
		  o[arr[i]['name'] ]= arr[i];
		}
		for(i in o) {
		  r.push(o[i]);
		}
	}
    return r;
  };
})


app.filter('to_trusted', ['$sce', function($sce){
        return function(text) {
            return $sce.trustAsHtml(text);
        };
    }]);
/////////////////////////// faq Controller Starts From Here  ///////////////////////////////////

app.controller('policyCtrl', function($scope, $http) {

	var d =new Date();
	$scope.hastrue=false;
	
	$scope.policy=[];
	
	
	//for get category
	function policycategory()
	{
		$scope.hastrue=true;
		
		$http({
			url: path+'setup/getallpolicy',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	policycategory();
	
});
//////////////////////////////////////

/////////////////////////// timeline Controller Starts From Here  ///////////////////////////////////

app.controller('timelineCtrl', function($scope, $http) {

	var d =new Date();
	$scope.hastrue=false;
	
	$scope.timelinearr=[];
	
	
	//for get category
	function policycategory()
	{
		$scope.hastrue=true;
		
		$http({
			url: path+'profile/gettimeline',
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.timelinearr=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	policycategory();
	
});
////////////////////OFFICIAL Communication Controller OF SELF SERVICE//////////////////

app.controller('officialcommunicationCtrl', function($scope, $http, $timeout) {
$scope.employees=[];
$scope.onfetch =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({officialcommunicationid: $id});
	$http({
        url: path+'profile/getempofficialcommunication',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				$scope.employees=data.data1;
				if($scope.employees.length == 1 ){
					$scope.desc=data.data[0]['msg'];
				}
				else{
					
					$scope.desc=data.data[0]['msg'];
					$('#selectbox').modal('show');
				}
				
				$scope.officialcommunicationname = data.data[0]['name'];
				var len = data.data[0]['employeeid'].length;
				$scope.seniorsts=(data.data[0]['seniorsts']==1)?true:false;
				var empname="";
				var senior="";
				for(var x=0; x<len; x++)
				{
					if(empname=="")
						empname = data.data[0]['employeeid'][x]['name'];
					else
						empname += ", "+data.data[0]['employeeid'][x]['name'];
					
					if(senior=="")
						senior = data.data[0]['employeeid'][x]['senior'];
					else
						senior += ", "+data.data[0]['employeeid'][x]['senior'];
					
				}
				$scope.empto = empname;
				$scope.seniorid = senior;
				
			}
			
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.printDiv = function($desc) {
  var printContents = $desc;
  //console.log(printContents)
  var popupWin = window.open('', '_blank');
  popupWin.document.open();
  popupWin.document.write('<html><head><link rel="stylesheet" type="text/css" href="style.css" /></head><body onload="window.print()">' + printContents + '</body></html>');
  popupWin.document.close();
} 


$scope.onfetchemployee = function($val){
		$scope.hastrue=true;
		
	for(var i=0;i<$scope.employees.length;i++){
		if($scope.employees[i]['id']==$val)
		{
			
			var msg=$scope.desc;
			$scope.desc=msg.replace(/{firstname}/g,$scope.employees[i]['firstname']).replace(/{lastname}/g,$scope.employees[i]['lastname']).replace(/{dob}/g,$scope.employees[i]['dob']).replace(/{doj}/g,$scope.employees[i]['doj']).replace(/{doc}/g,$scope.employees[i]['doc']).replace(/{division}/g,$scope.employees[i]['div']).replace(/{department}/g,$scope.employees[i]['dept']).replace(/{designation}/g,$scope.employees[i]['desig']).replace(/{org}/g,$scope.employees[i]['org']);
			
		}
	}
}


});


/////////////////////////// Office Communication of employee Controller Starts From Here  ///////////////////////////////////

app.controller('officeCommunicationCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.officialcommunicationid=0;
$scope.selectedemployee=0;
$scope.seniorsts=false;
$scope.seniorid="";
$scope.mailsts="";
$scope.templates = [];
$scope.employees = [];
$scope.certificateid=0;

onfetchemployee();



	/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.officialcommunicationid=$id;
}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteofficialcommunication/'+$scope.officialcommunicationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.docreqid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetchtemplate=function()
{
	$scope.hastrue=true;
	//var xsrf = $.param({officialcommunicationid: $id});
	$http({
        url: path+'setup/getalltemplate',
        method: "POST",
		//data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.templates=data.data;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onselectemp = function()
{
	//alert($scope.selectedemployee);
	var len =$scope.selectedemployee.length;
	var id =$scope.selectedemployee[0];
	 var empname="";
		for(var x=0; x<$scope.employees.length; x++)
		{
			if($scope.employees[x].id==$scope.selectedemployee)
			{
				if(empname==""){
				empname = "<"+$scope.employees[x].name+">";
				$scope.seniorid=$scope.employees[x].empreport;
				}
				
				else
				empname += ", <"+$scope.employees[x].name+">";
				
				break;
			}
		}
	
	$scope.empto = empname;
}
function onfetchemployee()
{
	$scope.hastrue=true;
	$http({
        url: path+'employee/getallemployee',
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employees = data.data;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.printDiv = function($desc) {
  var printContents = $desc;
  //console.log(printContents)
  var popupWin = window.open('', '_blank');
  popupWin.document.open();
  popupWin.document.write('<html><head><link rel="stylesheet" type="text/css" href="style.css" /></head><body onload="window.print()">' + printContents + '</body></html>');
  popupWin.document.close();
} 
$scope.onfetch =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({officialcommunicationid: $id});
	$http({
        url: path+'employee/getaofficialcommunication',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.desc=data.data[0]['msg'];
				$scope.officialcommunicationname = data.data[0]['name'];
				var len = data.data[0]['employeeid'].length;
				$scope.seniorsts=(data.data[0]['seniorsts']==1)?true:false;
				var empname="";
				var senior="";
				for(var x=0; x<len; x++)
				{
					if(empname=="")
						empname = "<"+data.data[0]['employeeid'][x]['name']+">";
					else
						empname += ", <"+data.data[0]['employeeid'][x]['name']+">";
					
					if(senior=="")
						senior = "<"+data.data[0]['employeeid'][x]['senior']+">";
					else
						senior += ", <"+data.data[0]['employeeid'][x]['senior']+">";
					
				}
				$scope.empto = empname;
				$scope.seniorid = senior;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangesetdesc = function()
{
	for(var i=0; i<$scope.templates.length; i++)
	{
		if($scope.template==$scope.templates[i].id){
			//alert($scope.templates[i].name);
			//document.getElementById('desc').value = $scope.templates[i].name;
			$('#desc').data("wysihtml5").editor.setValue($scope.templates[i].desc);
			break;
		}
	}
}

$scope.onpreview =function()
{
	var val=$('#desc').val();
	//$scope.hastrue=true;
	var xsrf = $.param({empid: $scope.selectedemployee});
	$http({
        url: path+'employee/getemployeecertificatedata',
        method: "POST",
		data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				$scope.employeedata=data.data;
				for(var i=0;i<$scope.employeedata.length;i++){
					if($scope.employeedata[i].id == $scope.selectedemployee ){
						var empgender=$scope.employeedata[i]['empgender'];
						var salutation=" Mr ";
						var temp1=" he ";
						var temp2=" his ";
						var temp3=" him ";
						if(empgender==2)
						{
							salutation=" Ms/Mrs ";
							temp1=" she ";
							temp2=" her ";
							temp3=" her ";
						}
						$scope.description=val.replace(/{firstname}/g, $scope.employeedata[i]['firstname']).replace(/{lastname}/g, $scope.employeedata[i]['lastname']).replace(/{dob}/g, $scope.employeedata[i]['dob']).replace(/{doj}/g, $scope.employeedata[i]['doj']).replace(/{nationality}/g, $scope.employeedata[i]['empnat']).replace(/{doc}/g,$scope.employeedata[i]['empdoc']).replace(/{division}/g,$scope.employeedata[i]['empdivision']).replace(/{department}/g,$scope.employeedata[i]['empdepartment']).replace(/{designation}/g,$scope.employeedata[i]['empdesignation']).replace(/{org}/g,$scope.employeedata[i]['org']).replace(/{address}/g,$scope.employeedata[i]['address']).replace(/{contactno.}/g,$scope.employeedata[i]['contact']).replace(/{passport}/g,$scope.employeedata[i]['passport']).replace(/{reportsto}/g,$scope.employeedata[i]['reportingto']).replace(/{reportstodesignation}/g,$scope.employeedata[i]['reportingtodesig']).replace(/{bankname}/g,$scope.employeedata[i]['bank']).replace(/{bankno}/g,$scope.employeedata[i]['iban']).replace(/ his \/ her /g,temp2).replace(/ him \/ her /g,temp3).replace(/ Mr \/ Ms /g,salutation).replace(/ he \/ she /g,temp1).replace(/ He \/ She /g,temp1).replace(/{grossctc}/g, $scope.employeedata[i]['grossctc']);
						
						console.log($scope.description)
						$scope.desc=$scope.description;
						
					}
				}
				
				
			}
			
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.changetab=function(){
	$scope.description="";
}
$scope.oncreate = function($val)
{
	
	//alert($scope.selectedemployee) document.getElementById('desc').value;
	if($scope.seniorid != ""){
		$scope.seniorsts=true;
	}
	
	$scope.seniorsts=($scope.seniorsts == true)?1:0;
	$scope.hastrue=true;
	var xsrf = $.param({officialcommunicationname: $scope.officialcommunicationname, desc: $scope.desc, employeeid:$scope.selectedemployee,seniorsts:$scope.seniorsts,certificateid:$scope.certificateid,mailsts:$scope.mailsts});
	$http({
        url: path+'employee/createofficialcommunication',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.officialcommunicationname="";
				
				$scope.officialcommunicationid=0;
				
				if($val==1){
					//window.open(path+"employee/officialcommunication", "_self");
					$timeout(function(){window.open(path+"employee/officialcommunication", "_self");}, timeo); 
				}
				if($val==2){
					//window.open(path+"employee/officialcommunication", "_self");
					$timeout(function(){window.open(path+"employee/certificaterelease", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({officialcommunicationid:$scope.officialcommunicationid, officialcommunicationname: $scope.officialcommunicationname, desc: document.getElementById('desc').value, employeeid:"",seniorsts:$scope.seniorsts});
  $http({
        url: path+'employee/updatedofficialcommunication',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.officialcommunicationname="";
				$scope.officialcommunicationid=0;
				if($val==1){
					//window.open(path+"employee/officialcommunication", "_self");
					$timeout(function(){window.open(path+"employee/officialcommunication", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

//////////for certificate request preview//////////////
$scope.onfetchletter = function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({certificaterequestid: $scope.certificateapprovalid});
		$http({
			url: path+'employee/getcertificatedetails',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					$scope.certificateid=data.data[0]['id'];
					$scope.employeeid=data.data[0]['employeeid'];
					$scope.selectedemployee=data.data[0]['empid'];
					$scope.officialcommunicationname=data.data[0]['name'];
					$scope.reportingto=data.data[0]['reportingto'];
					$scope.reason=data.data[0]['reason'];
					$scope.addressto=data.data[0]['addressto'];
					if($scope.reportingto != ""){
						$scope.seniorsts=true;
					}
					//$scope.desc=data.data[0]['desc'];
					$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
					}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

	
});

/////////////////////////// Template Controller Starts From Here  ///////////////////////////////////

app.controller('templateCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.templatename="";
$scope.templateid=0;
$scope.templates = [];
$scope.emparr=[];

$scope.getId = function($id) {
	$scope.templateid=$id;
}

$scope.ondelete =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'setup/deletetemplate/'+$scope.templateid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.templateid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({templateid: $id});
	$http({
        url: path+'setup/getatemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.templatename=data.data[0]['name'];
				//document.getElementById('desc').value=data.data[0]['desc'];
				$scope.desc=data.data[0]['desc'];
				document.getElementById('output').innerHTML=$scope.desc;
				//$('#some-textarea').data("wysihtml5").editor.setValue(data.data[0]['desc']);
				$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
	
	$scope.hastrue=true;
	var xsrf = $.param({templatename: $scope.templatename, desc: document.getElementById('desc1').value});
	$http({
        url: path+'setup/createtemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.templatename="";
				$scope.desc1="";
				$scope.templateid=0;
				$('#addtemplate').modal('hide');
			//	onfetchtemplate();
				if($val==1){
					//window.open(path+"setup/template", "_self");
				//	$timeout(function(){window.open(path+"setup/template", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({templateid: $scope.templateid, templatename: $scope.templatename, desc: document.getElementById('desc').value});
  $http({
        url: path+'setup/updatedetemplate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.templatename="";
				$scope.desc="";
				$scope.templateid=0;
				
				if($val==1){
					//window.open(path+"setup/template", "_self");
					$timeout(function(){window.open(path+"setup/template", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


 $scope.cursorPosVal = -1;

    $scope.getCursorPos = function($event) {
    //alert("hello");
     //var myEl = $event.target;
    //alert($event);
    $scope.doGetCaretPosition($event);  
    }
    
    $scope.doGetCaretPosition = function(oField) {

    // Initialize
    var iCaretPos = 0;
//alert(oField.selectionStart);
    // IE Support
    if (document.selection) {

      // Set focus on the element
      oField.focus ();

      // To get cursor position, get empty selection range
      var oSel = document.selection.createRange ();

      // Move selection start to 0 position
      oSel.moveStart ('character', -oField.value.length);

      // The caret position is selection length
      iCaretPos = oSel.text.length;
      //alert(iCaretPos);
    }

    // Firefox support
    else if (oField.selectionStart || oField.selectionStart == '0')
      iCaretPos = oField.selectionStart;

    // Return results
    $scope.cursorPosVal = iCaretPos;
    
   }

$scope.onchangeemp=function()
{
	alert("hello");
	if($scope.empname=='')
	{
		return false;
	}
	insertAtCursor('desc', $scope.empname);
	
}

function insertAtCursor(myField, myValue) {

    
    if (document.selection) {
    
        document.getElementById(myField).focus();
        sel = document.selection.createRange();
        sel.text = myValue;
    }
    
    else if (document.getElementById(myField).selectionStart || document.getElementById(myField).selectionStart == '0') {
    //alert(document.getElementById(myField));
        var startPos = document.getElementById(myField).selectionStart;
        var endPos = document.getElementById(myField).selectionEnd;
        //alert(startPos+", "+endPos);
        document.getElementById(myField).value = document.getElementById(myField).value.substring(0, startPos)
            + myValue
            + document.getElementById(myField).value.substring(endPos, document.getElementById(myField).value.length);
    } else {
        document.getElementById(myField).value += myValue;
    }
}


});

app.controller('resignationCtrl', function($scope, $http, $timeout) {


$scope.resignationid="";
$scope.subject="";
$scope.msg="";
$scope.resignsts=0;
$scope.resignstatus='';
$scope.noticeperiod='';
$scope.fdate='';
$scope.tdate='';
$scope.sts=false;
$scope.msglength=0;
onfetch('profile/getResignationreasons',8);
onfetch('profile/getnoticeperiod',7);
	

function onfetch($val, $id)
	{
		$scope.hastrue=true;
		//var xsrf = $.param({leaveid: $scope.employeeleaveid});
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==8){
						$scope.severancereasonarr=[];
						$scope.severancereasonarr=data.data;
					}
					if($id==7){
						$scope.noticeperiod=data.noticeperiod;
						$scope.subject=data.lastworkingday;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}	
	$scope.onfetchresignation= function()
	{
	$scope.hastrue=true;
	  $http({
		url: path+'employee/getresignationdetails',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	      }).success(function (data, status, headers, config) {
				if(data.status)
				{
					$scope.resignationid=data.data[0]['id'];	
					//$scope.subject=data.data[0]['subject'];	
					$scope.msg=data.data[0]['reason'];
					$scope.reason=data.data[0]['reason1'];
					document.getElementById('msg').value=data.data[0]['reason'];
					$scope.resignsts=data.data[0]['resignsts'];
					$scope.noticeperiod=data.data[0]['noticeperiod'];
					$scope.subject=data.data[0]['effectdate'];
					$scope.fdate=data.data[0]['fdate'];
					$scope.tdate=data.data[0]['tdate'];
					if($scope.resignsts==1)
					{
						$scope.resignstatus="Rejected";
					}else if($scope.resignsts==2){
						$scope.resignstatus="Approved";
					}else if($scope.resignsts==3){
						$scope.resignstatus="Pending";
					}else if($scope.resignsts==4){
						$scope.resignstatus="Cancel";
					}else if($scope.resignsts==5){
						$scope.resignstatus="Withdraw";
					}
					$scope.sts=true;
					if($scope.resignsts==0){
						$scope.sts=false;
					}
				}
				else{
					//$scope.subject=data.lastworkday;
					var desc="<p>Dear (line manager name - eg., Mr Smith, or first name if appropriate)<br></p><p><span><u></u>&nbsp;<u></u></span></p><p><span>Please accept this as formal notice of my resignation from the position of (your job title and /department/division as applicable), with effect from (normally date of the application).<u></u><u></u></span></p><p><span><u></u>&nbsp;<u></u></span></p><p><span>In accordance with my contract of employment, I am happy to continue to work until (date that your employment ceases according to notice period, calculated from your stated effective date of resignation).<u></u><u></u></span></p><p><span><u></u>&nbsp;<u></u></span></p><p><span>Please let me know the arrangements for handing back company assets and handing over outstanding work and responsibilities.<u></u><u></u></span></p><p><span><u></u>&nbsp;<u></u></span></p><p><span><u></u>&nbsp;<u></u></span></p><p><span>Yours sincerely,<u></u><u></u></span></p><p><span><u></u>&nbsp;<u></u></span></p><p><span>(Job Holder)</span></p>";	
					//$('#msg').data("wysihtml5").editor.setValue(desc);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
		    //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	
	$scope.onresign = function($val)
	{
		if($val==1){
			var msg1 = document.getElementById('msg').value;
			//alert('hello');
			if(msg1=='')
			{
				errorMessage("Message can not be left blank.");
				$('#msg').data("wysihtml5").editor.focus();
				return false;
			}
			$('#confirm').modal('show');
		}
		else{
			$('#confirm1').modal('show');
		}
		//onresignation();
	}
	
	$scope.onchangests =function($val)
	{
	
	var xsrf = $.param({severanid:$scope.resignationid});
	$http({
        url: path+'employee/withdrawresignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 $timeout(function(){window.open(path+"profile/severance", "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.leaveid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onchangenoticeperiod =function()
	{
	
	var xsrf = $.param({noticeday:$scope.noticeperiod});
	$http({
        url: path+'profile/fetchlastworkingdate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.subject=data.data[0].value;
			
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
	$scope.onresignation = function($val)
	{	
		var msg1 = document.getElementById('msg').value;
				
		//return false;
		$scope.hastrue=true;
		var xsrf = $.param({message:msg1,noticeperiod:$scope.noticeperiod,lastworkday:$scope.subject,reason:$scope.reason});
		$http({
			url: path+'employee/createresigned',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
										
					if($val==1){
						//window.open(path+"profile/change_password", "_self");
						$timeout(function(){window.open(path+"profile/severance", "_self");}, timeo);
					}
					
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	

	
});


///////////////////////////// Resignation Controller Starts From Here  ///////////////////////////////////

app.controller('resignCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.resignationid=0;
$scope.empname="";
$scope.startdate="";
$scope.enddate="";
$scope.startdate1="";
$scope.enddate1="";
$scope.msg="";
$scope.subject="";
$scope.noticeperiod="";
$scope.designation="";
$scope.department="";
$scope.division="";
$scope.sts='';
$scope.resignstatus='';
onfetch('other',2);
//onfetch('employee/getallemployee',1);
//onfetch('setup/getallasset',2);

/////////////////////////////
$scope.getId = function($id) {
	$scope.resignationid=$id;
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteresignation/'+$scope.resignationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.resignationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetch($val, $id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({leaveid: $scope.employeeleaveid});
		$http({
			url: path+$val,
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==2){
						$scope.leavestsarray=[];
						$scope.leavestsarray=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
$scope.onfetchresignation =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({resignationid: $id});
	$http({
        url: path+'employee/getaresignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				//$scope.resignationid=data.data1[0]['id'];
				$scope.empname=data.data1[0]['empname'];
				$scope.division=data.data1[0]['division'];
				$scope.department=data.data1[0]['department'];
				$scope.designation=data.data1[0]['designation'];
				$scope.subject=data.data[0]['subject'];
				$scope.msg=data.data[0]['message'];
				$scope.noticeperiod=data.data[0]['noticeperiod'];
				$scope.startdate=data.data[0]['startdate'];
				$scope.enddate=data.data[0]['enddate'];
				$scope.startdate1=data.data[0]['startdate1'];
				$scope.enddate1=data.data[0]['enddate1'];
				//alert(data.data[0]['resignsts']);
				$scope.sts=data.data[0]['resignsts'];
				$scope.approvals=data.data[0]['Approvals'];
				//alert($scope.sts);
				if($scope.sts=='1')
				{
					$scope.resignstatus="Rejected";
				}else if($scope.sts=='2'){
					$scope.resignstatus="Approved";
				}else if($scope.sts=='3'){
					$scope.resignstatus="Pending";
				}else if($scope.sts=='4'){
					$scope.resignstatus="Cancel";
				}else if($scope.sts=='5'){
					$scope.resignstatus="Withdraw";
				}
				//alert($scope.resignstatus);
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({emp_id:$scope.emp_id,assetid:$scope.assetid,issue_date:$scope.issue_date,return_date:$scope.return_date,desc:$scope.desc});
  $http({
        url: path+'employee/createissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.assetid="";
				$scope.emp_id=""
				$scope.issue_date="";
				$scope.return_date="";
				$scope.desc="";
				$scope.issueassetid=0;
				
				if($val==1){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/issueasset", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onaddcomment = function($id)
	{
		 $('#comment').modal('show');
		 $scope.approverresult=$id;
	}

$scope.onupdate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({resignationid: $scope.resignationid, startdate:$scope.startdate1, enddate:$scope.enddate1, sts:$scope.approverresult, comment:$scope.comment});
  $http({
        url: path+'employee/updatedresignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.resignationid=0;
				$scope.startdate1=""
				$scope.enddate1="";
				if($val==1 || $val==2){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/resignation", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});


///////////////profile controller starts from here/////////////

app.controller('profileCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.listarray=[];
$scope.divisionarray=[];
$scope.gradearray=[];
$scope.departarray=[];
$scope.desigarray=[];
$scope.locationarray=[];
$scope.shiftarray=[];
$scope.empstatusarray=[];
$scope.otherarray=[];
$scope.bloodgarray=[];
$scope.nationalarray=[];
$scope.visaarray=[];
$scope.visacatarray=[];
$scope.langarray=[];
$scope.religionarray=[];
$scope.funcarray=[];
$scope.countryarray=[];
$scope.cityarray1=[];
$scope.cityarray2=[];
$scope.cityarray3=[];
$scope.cityarray4=[];
$scope.docarray=[];
$scope.cityarray=[];
$scope.workhalfdaysarray=[];
$scope.workfulldaysarray=[];
$scope.reportingtoarray=[];
$scope.realtionarray=[];
$scope.dependantarray=[];
$scope.skillarray=[];
$scope.bankarray=[];
$scope.empskillarray=[];
$scope.creditcardarray=[];
$scope.insurancearray=[];
$scope.emp_creditcardarray=[];
$scope.emp_insurancearray=[];
$scope.familyarray=[];
$scope.salaryarray=[];
$scope.bankloanarray=[{id:0, bankid:"", loan_amt:"",tenure:"",emi:""}];
$scope.emppic="";
$scope.emp_code="";
$scope.emp_dob="";
$scope.emp_report_to="";
$scope.emp_division="";
$scope.emp_grade="";
$scope.emp_depart="";
$scope.emp_desig="";
$scope.emp_location="";
$scope.emp_shift="";
$scope.emp_sts="";

$scope.chk8 = false;

$scope.emp_fname="";
$scope.emp_lname="";
$scope.emp_dob="";
$scope.emp_gender="";
$scope.emp_marital="";
$scope.emp_blood_group="";
$scope.emp_blood_group_view="";
$scope.emp_nationality="";
$scope.emp_nationality_view="";
$scope.emp_visa_type="";
$scope.emp_visa_type_view="";
$scope.emp_known_lang="";
$scope.emp_religion = "";
$scope.emp_religion_view = "";
$scope.emp_functional="";
$scope.emp_doj="";
$scope.emp_doc="";
$scope.emp_contact1="";
$scope.emp_email1="";
$scope.emp_address1="";
$scope.emp_country1="";
$scope.emp_country1_view="";
$scope.emp_city1="";
$scope.emp_zipcode1="";

$scope.emp_contact2="";
$scope.emp_email2="";
$scope.emp_address2="";
$scope.emp_country2="";
$scope.emp_country2_view="";
$scope.emp_city2="";
$scope.emp_zipcode2="";

$scope.emp_contact3="";
$scope.emp_email3="";
$scope.emp_address3="";
$scope.emp_country3="";
$scope.emp_country3_view="";
$scope.emp_city3="";
$scope.emp_zipcode3="";
$scope.employeeid=0;
$scope.emp_workdays="";
$scope.salaryctc="";
$scope.emp_type="";
$scope.paypattern="";
$scope.bankname="";
$scope.bankifsccode="";
$scope.bankaccountnumber="";
$scope.bankaddress="";
$scope.cmp_email="";
$scope.year=0;
$scope.month=0;

$scope.airport="";
$scope.immigration="";
$scope.visa="";
$scope.visacost="";
$scope.airticket="";
$scope.onceinyear="";
$scope.onceinmonth="";
$scope.ticketclass="";
$scope.iatafare="";
$scope.ticketamt="";
$scope.instructions="";
onfetch('setup/getalldivision',1);
//onfetch('setup/getallgrade',2);
onfetch('setup/getalldepartment',3);
onfetch('setup/getalldesignation',4);
//onfetch('setup/getalllocation',5);
//onfetch('attendance/getallshift',6);
//onfetch('employee/getallempstatus',7);
onfetch('other',8);
onfetch('employee/getallbloodgroup',9);
onfetch('tabledata/index/NationalityMaster',10);
onfetch('employee/getallvisa',11);
onfetch('employee/allvisacat',28);
onfetch('tabledata/index/LanguageMaster',12);
onfetch('other/getallreligion',13);
onfetch('employee/getallfunctionalarea',14);
onfetch('country/getallcountry',15);
onfetch('employee/getalldocument',19);
//onfetch('employee/getallemployee',20);
onfetch('other/getallrelation',21);
onfetch('employee/getallskill',22);
onfetch('employee/getallcreditcard',23);
onfetch('employee/getallinsurance',24);
onfetch('employee/getallbank',25);
onfetch('employee/getallqualification',26);
Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};

$('input').on('ifChecked', function(event){
  
   if(event.target.name=='in')
	$scope.chk8=event.target.value;
	
   else if(event.target.name=='ticket'){
	$scope.chk9=event.target.value;
	$timeout(function(){$scope.chk9=event.target.value}, 100);
}

  
  
});

$scope.workarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addwork = function($i){
	var len = $scope.workarray.length-1;
	if($scope.workarray[len]['name']=="" || $scope.workarray[len]['desig']=="" || $scope.workarray[len]['fdate']=="" || $scope.workarray[len]['tdate']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.workarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
	
}
$scope.removework = function($i){
	$scope.workarray.remove($i);	
}

$scope.qualificationarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addqualification = function($i){
	var len = $scope.qualificationarray.length-1;
	if($scope.qualificationarray[len]['name']=="" || $scope.qualificationarray[len]['desig']=="" || $scope.qualificationarray[len]['fdate']=="" || $scope.qualificationarray[len]['tdate']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.qualificationarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
	
}
$scope.removequalification = function($i){
	$scope.qualificationarray.remove($i);
	
}

$scope.documentarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:""}];
$scope.adddocument = function($i){
	var len = $scope.documentarray.length-1;
	if($scope.documentarray[len]['name']=="" || $scope.documentarray[len]['desig']=="" || $scope.documentarray[len]['fdate']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.documentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:""});
	}
}
$scope.removedocument = function($i){
	$scope.documentarray.remove($i);
	
}

$scope.dependantarray=[{id:0, relate:"", fname:"", lname:"",  nominee:0,contact:""}];
$scope.adddependant = function($i){
	var len = $scope.dependantarray.length-1;

	if($scope.dependantarray[len]['relate']=="" || $scope.dependantarray[len]['fname']=="" || $scope.dependantarray[len]['nominee']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.dependantarray.insert($i,{id:0, relate:"", fname:"", lname:"",  nominee:0,contact:""});
	}
}
$scope.removedependant = function($i){
	$scope.dependantarray.remove($i);
	
}

$scope.empskillarray=[{id:0, skill:0, desc:""}];
$scope.addskill = function($i){
	var len = $scope.empskillarray.length-1;

	if($scope.empskillarray[len]['skill']==0 || $scope.empskillarray[len]['desc']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.empskillarray.insert($i,{id:0, skill:0, desc:""});
	}
}
$scope.removeskill = function($i){
	$scope.empskillarray.remove($i);
	
}

$scope.emp_creditcardarray=[{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""}];
$scope.addemp_creditcard = function($i){
	var len = $scope.emp_creditcardarray.length-1;

	if($scope.emp_creditcardarray[len]['creditcardid']==0 || $scope.emp_creditcardarray[len]['bankid']=="" || $scope.emp_creditcardarray[len]['credit_issuedate']=="" || $scope.emp_creditcardarray[len]['credit_validdate']==""  ||  $scope.emp_creditcardarray[len]['creditcard_no']=="" || $scope.emp_creditcardarray[len]['credit_limit']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.emp_creditcardarray.insert($i,{id:0, creditcardid:"", bankid:"",creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
	}
}
$scope.removeemp_creditcard = function($i){
	$scope.emp_creditcardarray.remove($i);
	if($scope.emp_creditcardarray.length==0){
		$scope.emp_creditcardarray.insert(0,{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
	}	
}

$scope.emp_insurancearray=[{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_nominee:""}];
$scope.addemp_insurance = function($i){
	var len = $scope.emp_insurancearray.length-1;

	if($scope.emp_insurancearray[len]['insuranceid']==0 || $scope.emp_insurancearray[len]['insurance_period']=="" || $scope.emp_insurancearray[len]['insured_amt']=="" || $scope.emp_insurancearray[len]['premium_amt']=="" || $scope.emp_insurancearray[len]['insurance_validdate']==""   ){
		errorMessage("Please fill all fields");
	}else{
		$scope.emp_insurancearray.insert($i,{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_nominee:""});
	}
}
$scope.removeemp_insurance = function($i){
	$scope.emp_insurancearray.remove($i);
	
}
$scope.emp_bankarray=[{id:0, bankid:"", iban_no:"",swiftcode:"",branch:""}];
$scope.addemp_bank = function($i){
	var len = $scope.emp_bankarray.length-1;

	if($scope.emp_bankarray[len]['bankid']==0 || $scope.emp_bankarray[len]['iban_no']=="" || $scope.emp_bankarray[len]['branch']=="" || $scope.emp_bankarray[len]['swiftcode']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.emp_bankarray.insert($i,{id:0, bankid:"", iban_no:"",swiftcode:"",branch:""});
	}
}
$scope.removeemp_bank = function($i){
	$scope.emp_bankarray.remove($i);
	if($scope.emp_bankarray.length==0){
		$scope.emp_bankarray.insert(0,{id:0, bankid:"", iban_no:"",swiftcode:"",branch:""});
	}	
}

$scope.addbankloan = function($i){
	var len = $scope.bankloanarray.length-1;
	if($scope.bankloanarray[len]['bankid']==0 || $scope.bankloanarray[len]['loan_amt']=="" || $scope.bankloanarray[len]['tenure']=="" || $scope.bankloanarray[len]['emi']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.bankloanarray.insert($i,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
	}
}
$scope.removebankloan = function($i){
	$scope.bankloanarray.remove($i);
	if($scope.bankloanarray.length==0){
		$scope.bankloanarray.insert(0,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
	}	
}

$scope.datediff=function($index){
	if($scope.familyarray[$index]['bdate']!="" ){
	
		var date1=$scope.familyarray[$index]['bdate'].split('/');
		var dob=date1[2]+'-'+date1[1]+'-'+date1[0];
		//dob= new Date(dob);
		var birthDay=date1[0];
		var birthMonth=date1[1];
		var birthYear=date1[2];
		var  today = new Date();
		var currentDay=today.getUTCDate();
		var currentMonth=today.getUTCMonth() + 1;
		var currentYear=today.getFullYear();
		var yearAge = currentYear - birthYear;

		  if (currentMonth >= birthMonth)
			var monthAge = currentMonth - birthMonth;
		  else {
			yearAge--;
			var monthAge = 12 + currentMonth -birthMonth;
		  }
		  
		//calculate the age in months:
		if(monthAge == 0)
		var age = yearAge; 
		else
		var age = yearAge+'.'+monthAge; 
		
		$scope.familyarray[$index]['age'] = age;
		
	}
}

$scope.dayDiff = function($index){
	if($scope.documentarray[$index]['fdate']!="" && $scope.documentarray[$index]['tdate']!=""){
		var date2 = new Date($scope.documentarray[$index]['fdate']);
		var date1 = new Date($scope.documentarray[$index]['tdate']);
		if(date2<date1){
			var timeDiff = Math.abs(date2.getTime() - date1.getTime());   
			var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
			$scope.documentarray[$index]['desc'] = diffDays;
		}
	}
}

$scope.getcity = function($val)
{
	if($val==16){
		onfetch('city/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('city/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('city/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==27){
		onfetch('city/getallcity/'+$scope.emp_country4,$val);
	}
}

$scope.onchangebank=function($val,$i){

	for(var i=0;i<$scope.bankarray.length;i++)
	{
		if($scope.bankarray[i].id == $val)
		{
			$scope.emp_bankarray[$i].swiftcode=$scope.bankarray[i].code;
			$scope.emp_bankarray[$i].branch=$scope.bankarray[i].branch;
		}
	}
}

  function getcity1($val)
{
	if($val==16){
		onfetch('city/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('city/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('city/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==27){
		onfetch('city/getallcity/'+$scope.emp_country4,$val);
	}
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.divisionarray=[];
					$scope.divisionarray=data.data;
					//$scope.divisionarray.insert(0,{id:0,name:"Select Division"});
				}else if($id==2){
					$scope.gradearray=[];
					$scope.gradearray=data.data;
				}else if($id==3){
					$scope.departarray=[];
					$scope.departarray=data.data;
				}else if($id==4){
					$scope.desigarray=[];
					$scope.desigarray=data.data;
				}else if($id==5){
					$scope.locationarray=[];
					$scope.locationarray=data.data;
				}else if($id==6){
					$scope.shiftarray=[];
					$scope.shiftarray=data.data;
				}else if($id==7){
					$scope.empstatusarray=[];
					$scope.empstatusarray=data.data;
				}else if($id==8){
					$scope.otherarray=[];
					$scope.otherarray=data.data;
				}else if($id==9){
					$scope.bloodgarray=[];
					$scope.bloodgarray=data.data;
				}else if($id==10){
					$scope.nationalarray=[];
					$scope.nationalarray=data.data;
				}else if($id==11){
					$scope.visaarray=[];
					$scope.visaarray=data.data;
				}else if($id==12){
					$scope.langarray=[];
					$scope.langarray=data.data;
				}else if($id==13){
					$scope.religionarray=[];
					$scope.religionarray=data.data;
				}else if($id==14){
					$scope.funcarray=[];
					$scope.funcarray=data.data;
				}else if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray1=[];
					$scope.cityarray1=data.data;
					
				}else if($id==17){
					$scope.cityarray2=[];
					$scope.cityarray2=data.data;
				}else if($id==18){
					$scope.cityarray3=[];
					$scope.cityarray3=data.data;
					
				}else if($id==19){
					$scope.docarray=[];
					$scope.docarray=data.data;
					
				}
				else if($id==20){
					$scope.reportingtoarray=[];
					$scope.reportingtoarray=data.data;
					
				}else if($id==21){
					$scope.realtionarray=[];
					$scope.realtionarray=data.data;;
				}
				else if($id==22){
					$scope.skillarray=[];
					$scope.skillarray=data.data;
				}
				else if($id==23){
					$scope.creditcardarray=[];
					$scope.creditcardarray=data.data;
				}
				else if($id==24){
					$scope.insurancearray=[];
					$scope.insurancearray=data.data;
				}
				else if($id==25){
					$scope.bankarray=[];
					$scope.bankarray=data.data;
				}
				else if($id==26){
					$scope.qualarray=[];
					$scope.qualarray=data.data;
				}

				else if($id==27){
					$scope.cityarray4=[];
					$scope.cityarray4=data.data;
					$timeout(function(){
					var con= $( "#emp_country4 option:selected" ).text();
					var city= $( "#emp_city4 option:selected" ).text();
					$('#airport').val(city+', '+con);
					
					}, 2000); 
				}else if($id==28){
					$scope.visacatarray=[];
					$scope.visacatarray=data.data;
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

$scope.nomineepercent=function(){
var total=0;
	for(var i=0;i<$scope.dependantarray.length;i++){
		total =Number(total) + Number($scope.dependantarray[i]['nominee']);
	}
	//total=Number(total)+Number($val);
	if(total > 100){
		//var len = $scope.dependantarray.length;
		//$scope.dependantarray[len]['nominee']=0;
		errorMessage("Nominee % of benefit should be 100 %");
	}
}

$scope.setdefaultbank = function ($index) {
    
	for(var i=0;i<$scope.emp_bankarray.length;i++)
	{
		if(i == $index){
			$scope.emp_bankarray[i]['status']=1;
		}else{
			$scope.emp_bankarray[i]['status']=0;
		}
	}
};

function callafterfetchdetail()
{
	$scope.hastrue=true;
	var xsrf = $.param({employeeid: $scope.employeeid, gradeid: $scope.emp_grade, grossalary: $scope.salaryctc, incentive:$scope.incentive, experience: $scope.tyear});
	$http({
        url: path+'employee/getemployeesalary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.salaryarray=[];
				$scope.salaryarray=data.data;
				var len = $scope.salaryarray.length;
				for(var i=0; i<len; i++)
				{
					for(var s=0; s<$scope.salaryarray.length; s++)
					{
						if(parseInt($scope.salaryarray[s]['amount'])==0){
							$scope.salaryarray.remove(s);
							break;
						}
					}
				}
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchfare =function()
{
	
	$scope.hastrue=true;
	var xsrf = $.param({fromcity: 1922,tocity: $scope.emp_city4,ticketclass:$scope.ticketclass});
	$http({
        url: path+'setup/getrootfare',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				//$scope.iatafare=data.data[0]['fareamount'];				
				if($scope.chk9==2){
					var adultfare = data.data[0]['fareamount'] * $scope.adult;
					var childfare = data.data[0]['childfareamount'] * $scope.child;
					var infantfare = data.data[0]['infantfareamount'] * $scope.infant;
					$scope.iatafare = adultfare + childfare + infantfare;
				}else if($scope.chk9==1){
					$scope.iatafare = data.data[0]['fareamount'];
					$scope.adult = 0;
					$scope.child = 0;
					$scope.infant =0;
					
				}else{
					$scope.iatafare =0;
				}
				
			}else{
				$scope.iatafare=0;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
$scope.emp_leave=0;

////////////////////////////////////////////
$scope.onfetchemployeedata =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getaemployeedata',
        method: "POST",
		
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.personal_no=data.data[0]['personal_no'];
				$scope.desc=data.data[0]['jobdesc'];
				$scope.emppic=data.data[0]['emppic'];
				$scope.employeeid=data.data[0]['id'];
				$scope.emp_code=data.data[0]['empcode'];
				$scope.emp_report_to=data.data[0]['empreport'];
				$scope.emp_division=data.data[0]['empdivision'];
				$scope.emp_grade=data.data[0]['empgrade'];
				$scope.emp_depart=data.data[0]['empdept'];
				$scope.emp_channel=data.data[0]['empchannel'];
				$scope.emp_desig=data.data[0]['empdesig'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.emp_location=data.data[0]['emplocation'];
				$scope.emp_shift=data.data[0]['empshift'];
				$scope.emp_sts=data.data[0]['empsts'];
				$scope.emp_type=data.data[0]['emptype'];
				$scope.emp_fname=data.data[0]['empfname'];
				$scope.emp_lname=data.data[0]['emplname'];
				$scope.emp_mname=data.data[0]['empmname'];
				$scope.emp_dob=data.data[0]['empdob'];
				$scope.emp_gender=data.data[0]['empgender'];
				$scope.emp_marital=data.data[0]['empmarists'];
				$scope.emp_blood_group=data.data[0]['empbloodgroup'];
				$scope.emp_nationality=data.data[0]['empnation'];
				$scope.emp_visa_type=data.data[0]['empvisa'];
				$scope.emp_known_lang=data.data[0]['emplang'].split(',');
				$scope.emp_religion = data.data[0]['empreligion'];
				$scope.emp_functional=data.data[0]['empfuncarea'];
				$scope.emp_doj=data.data[0]['empdoj'];
				$scope.emp_doc=data.data[0]['empdoc'];
				$scope.emp_contact1=data.data[0]['empcnumber'];
				$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_address1=data.data[0]['empcaddres'];
				$scope.emp_country1=data.data[0]['empccountry'];
				$scope.emp_city1=data.data[0]['empccity'];
				$scope.emp_zipcode1=data.data[0]['empczip'];
				$scope.emp_contact2=data.data[0]['emphnumber'];
				$scope.emp_email2=data.data[0]['emphemail'];
				$scope.emp_address2=data.data[0]['emphaddres'];
				$scope.emp_country2=data.data[0]['emphcountry'];
				$scope.emp_city2=data.data[0]['emphcity'];
				$scope.emp_zipcode2=data.data[0]['emphzip'];
				$scope.emp_contact3=data.data[0]['empenumber'];
				$scope.emp_email3=data.data[0]['empeemail'];
				if(data.data[0]['empeaddress']!=""){
					var a=data.data[0]['empeaddress'].split(',');
					$scope.emr_name=a[0];
					$scope.emp_address3=a[1];
					if($scope.emp_address3 == 'undefined')
					{
						$scope.emp_address3=" ";
					}
				}
				$scope.emp_country3=data.data[0]['empecountry'];
				$scope.emp_city3=data.data[0]['empecity'];
				$scope.emp_zipcode3=data.data[0]['empezip'];
				$scope.gradebenefits=data.data[0]['gradebenefits'];
				$scope.salaryctc=data.data[0]['salaryctc'];
				//$scope.paypattern=data.data[0]['empepaypattern'];
				$scope.bankname=data.data[0]['empebankname'];
				$scope.bankifsccode=data.data[0]['empebankcode'];
				$scope.bankaccountnumber=data.data[0]['empebankaccount'];
				$scope.bankaddress=data.data[0]['empebankaddress'];
				$scope.emp_experience=data.data[0]['empexp'];
				$scope.cmp_email=data.data[0]['cmpemail'];
				$scope.provision=Number(data.data[0]['provision']);
				$scope.ticketclass=data.data[0]['ticketclass'];
				$scope.ticketamt=data.data[0]['ticketamt'];
				$scope.iatafare=data.data[0]['iatafare'];
				$scope.instructions=data.data[0]['instructions'];
				$scope.onceinmonth=Number(data.data[0]['oncein'] );
				$scope.emp_leave=data.data[0]['annualleave'];
				$scope.salarytype=data.data[0]['salarytype'];
				
				if(data.data[0]['nearestairport'] !=""){
					var n=data.data[0]['nearestairport'].split(',');
					$scope.emp_city4=n[0];
					$scope.emp_country4=n[1];
				}
				else{
					$scope.emp_city4="";
					$scope.emp_country4="";
				}
				
				if(data.data[0]['airticket'] !=""){
				var airticket=data.data[0]['airticket'];
					$('#chk24').iCheck((airticket=="0")?'check':'uncheck'); 
					$('#chk25').iCheck((airticket=="1")?'check':'uncheck');
					$('#chk26').iCheck((airticket=="2")?'check':'uncheck');
				}
				
				if(data.data[0]['familydetails'] != "" || data.data[0]['familydetails'] != null){
				var a=data.data[0]['familydetails'].split(',');
				$scope.adult=a[0];
				$scope.child=a[1];
				$scope.infant=a[2];
				}
				
				$scope.workarray = data.data[0]['empwork'];
				if($scope.workarray.length==0){
					$scope.workarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.qualificationarray = data.data[0]['empqual'];
				if($scope.qualificationarray.length==0){
					$scope.qualificationarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.documentarray = data.data[0]['empdocarray'];
				for(var j=0; j<$scope.documentarray.length; j++)
					{
						$scope.documentarray[j]['originaldoc']=($scope.documentarray[j]['originaldoc']==1)?true:false;
						
					}
				if($scope.documentarray.length==0){
					$scope.documentarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.dependantarray = data.data[0]['empdepenarray'];
				if($scope.dependantarray.length==0){
					$scope.dependantarray.insert(0,{id:0, relate:"",fname:"", lname:"", bdate:"", nominee:"",age:"",gender:""});
				}
				$scope.empskillarray = data.data[0]['empskills'];
				if($scope.empskillarray.length==0){
					$scope.empskillarray.insert(0,{id:0, skill:0,desc:""});
				}
				$scope.emp_insurancearray = data.data[0]['empinsurance'];
				if($scope.emp_insurancearray.length==0){
					$scope.emp_insurancearray.insert(0,{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_desc:"",insurance_nominee:""});
				}
				$scope.emp_creditcardarray = data.data[0]['empcreditcard'];
				if($scope.emp_creditcardarray.length==0){
					$scope.emp_creditcardarray.insert(0,{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
				}
				
				$scope.emp_bankarray = data.data[0]['empbank'];
				if($scope.emp_bankarray.length==0){
					$scope.emp_bankarray.insert(0,{id:0, bankid:"", iban_no:"",swiftcode:"",branch:""});
				}
				$scope.bankloanarray = data.data[0]['empbankloan'];
				if($scope.bankloanarray.length==0){
					$scope.bankloanarray.insert(0,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
				}
				$scope.familyarray = data.data[0]['empltadetails'];
				for(var i=0;i<$scope.familyarray.length;i++){
					$scope.datediff(i);
				}
				if($scope.familyarray.length==0){
					$scope.familyarray.insert(0,{id:0, relate:"",fname:"", lname:"", bdate:"", nominee:"",contact:""});
				}
				$scope.workhalfdaysarray = data.data[0]['empworkhalfday'];
				$scope.workfulldaysarray = data.data[0]['empworkfullday'];
				
				getcity1(16);
				getcity1(17);
				getcity1(18);
				getcity1(27);
				
				if(data.data[0]['empepaypattern']!="")
				{
					var a = data.data[0]['empepaypattern'];
					$('#chk8').iCheck((a=="1")?'check':'uncheck');
					$('#chk9').iCheck((a=="2")?'check':'uncheck');
					
				}
				$scope.curmonth=data.data[0]['curmonth'];
				$scope.curyear=data.data[0]['curyear'];
				if(data.data[0]['empexp']!=""){
					var empexp = (data.data[0]['empexp']).split(",");
					$scope.year= Number(empexp[0]);
					$scope.month=Number(empexp[1]);
				}
				if(data.data[0]['totalexp']!=""){
					var empexp = (data.data[0]['totalexp']).split(",");
					$scope.tyear= Number(empexp[0]);
					$scope.tmonth=Number(empexp[1]);
				}
			}
			callafterfetchdetail();
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.uploadqualificationdoc = function($val) {
	
	
	var emp=$scope.employeeid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadQualificationDocument",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                				
				//now add all of the assigned files
               var i=0;
				while(i < $scope.qualificationarray.length) {
                    if(document.getElementById(i).value!=""){
				//		console.log($scope.qualificationarray[i]['desig'].value);
				//		console.log($scope.qualificationarray[i]['desig']);
				//	var qualificationdocid=document.getElementById(i).desig;
					var qualificationdocid=$scope.qualificationarray[i]['desig'];
				//	console.log(qualificationdocid);
					formData.append('qualificationdocid' + i,qualificationdocid);
					formData.append("file" + i, $("#"+i).prop("files")[0]);
					}
					i++;
                }
				formData.append('emp_id',emp);
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.qualificationdoc }
        }).
        success(function (data, status, headers, config) {
			$scope.success=true;
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }


/////////////////////////////////////////////////////////////////////
 $scope.onfetchemployee =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({employeeid:$id});
	$http({
        url: path+'profile/getaemployee',
        method: "POST",
		data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.personal_no=data.data[0]['personal_no'];
				$scope.desc=data.data[0]['jobdesc'];
				$scope.emppic=data.data[0]['emppic'];
				$scope.employeeid=data.data[0]['id'];
				$scope.emp_code=data.data[0]['empcode'];
				$scope.emp_report_to=data.data[0]['empreport'];
				$scope.emp_division=data.data[0]['empdivision'];
				$scope.emp_grade=data.data[0]['empgrade'];
				$scope.emp_depart=data.data[0]['empdept'];
				$scope.emp_channel=data.data[0]['empchannel'];
				$scope.emp_desig=data.data[0]['empdesig'];
				$scope.emp_location=data.data[0]['emplocation'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.emp_shift=data.data[0]['empshift'];
				$scope.emp_sts=data.data[0]['empsts'];
				$scope.emp_type=data.data[0]['emptype'];
				$scope.emp_fname=data.data[0]['empfname'];
				$scope.emp_lname=data.data[0]['emplname'];
				$scope.emp_mname=data.data[0]['empmname'];
				$scope.emp_dob=data.data[0]['empdob'];
				$scope.emp_gender=data.data[0]['empgender'];
				$scope.emp_marital=data.data[0]['empmarists'];
				$scope.emp_blood_group=data.data[0]['empbloodgroup'];
				$scope.emp_blood_group_view=data.data[0]['empbloodgroupforview'];
				$scope.emp_nationality=data.data[0]['empnation'];
				$scope.emp_nationality_view=data.data[0]['empnationforview'];
				//$scope.emp_visa_type=data.data[0]['empvisa'];
				$scope.emp_visa_type_view=data.data[0]['empvisaforemployee'];
				//$scope.emp_known_lang=data.data[0]['emplang'].split(',');
				$scope.emp_religion = data.data[0]['empreligion'];
				$scope.emp_religion_view = data.data[0]['empreligionforview'];
				//$scope.emp_functional=data.data[0]['empfuncarea'];
				$scope.emp_doj=data.data[0]['empdoj'];
				$scope.emp_doc=data.data[0]['empdoc'];
				$scope.emp_dol=data.data[0]['empdol'];
				$scope.emp_contact1=data.data[0]['empcnumber'];
				$scope.emp_contact2=data.data[0]['emphnumber'];
				$scope.emp_contact3=data.data[0]['empenumber'];
				$scope.uidno=data.data[0]['uidno'];
				$scope.fileno=data.data[0]['fileno'];
				/* $scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_address1=data.data[0]['empcaddres'];
				
				if(data.data[0]['empcemail'] != 0){	
					$scope.emp_email1=data.data[0]['empcemail'];
				}else{
					$scope.emp_email1="";
				}
				
				if(data.data[0]['empcaddres'] != 0){	
					$scope.emp_address1=data.data[0]['empcaddres'];
				}else{
					$scope.emp_address1="";
				} */
				
				if(data.data[0]['empccountry'] != 0){	
					$scope.emp_country1=data.data[0]['empccountry'];
				}else{
					$scope.emp_country1="";
				}
				
				if(data.data[0]['empccountryforview'] != 0){	
					$scope.emp_country1_view=data.data[0]['empccountryforview'];
				}else{
					$scope.emp_country1_view="";
				}
				
				if(data.data[0]['empccity'] != 0){	
					$scope.emp_city1=data.data[0]['empccity'];
				}else{
					$scope.emp_city1="";
				}
				
				if(data.data[0]['emphcountry'] != 0){	
					$scope.emp_country2=data.data[0]['emphcountry'];
				}else{
					$scope.emp_country2="";
				}
				
				if(data.data[0]['emphcountryforview'] != 0){	
					$scope.emp_country2_view=data.data[0]['emphcountryforview'];
				}else{
					$scope.emp_country2_view="";
				}
				
				if(data.data[0]['emphcity'] != 0){
					$scope.emp_city2=data.data[0]['emphcity'];
				}else{
					$scope.emp_city2="";
				}
				
				if(data.data[0]['empecountry'] != 0){	
					$scope.emp_country3=data.data[0]['empecountry'];
				}else{
					$scope.emp_country3="";
				}
				
				if(data.data[0]['empecountryforview'] != 0){	
					$scope.emp_country3_view=data.data[0]['empecountryforview'];
				}else{
					$scope.emp_country3_view="";
				}
				
				if(data.data[0]['empecity'] != 0){	
					$scope.emp_city3=data.data[0]['empecity'];
				}else{
					$scope.emp_city3="";
				}
				//$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_zipcode1=data.data[0]['empczip'];
				
				$scope.emp_email2=data.data[0]['emphemail'];
				$scope.emp_address2=data.data[0]['emphaddres'];
				
				
				$scope.emp_zipcode2=data.data[0]['emphzip'];
			
				$scope.emp_email3=data.data[0]['empeemail'];
				$scope.overtimepay=data.data[0]['overtimepay'];
				if(data.data[0]['empeaddress']!=""){
				var a=data.data[0]['empeaddress'].split(',');
				$scope.emr_name=a[0];
				$scope.emp_address3=a[1];
				if($scope.emp_address3 == 'undefined')
					{
						$scope.emp_address3=" ";
					}
				
				}
				$scope.emp_address1=data.data[0]['empcaddres'];
				$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_zipcode3=data.data[0]['empezip'];
				$scope.gradebenefits=data.data[0]['gradebenefits'];
				$scope.salaryctc=data.data[0]['salaryctc'];
				$scope.paypattern=data.data[0]['empepaypattern'];
				$scope.bankname=data.data[0]['empebankname'];
				$scope.bankifsccode=data.data[0]['empebankcode'];
				$scope.salarytype=data.data[0]['salarytype'];
				$scope.bankaddress=data.data[0]['empebankaddress'];
				$scope.emp_experience=data.data[0]['empexp'];
				$scope.cmp_email=data.data[0]['cmpemail'];
				$scope.provision=Number(data.data[0]['provision']);
				$scope.ticketclass=data.data[0]['ticketclass'];
				$scope.ticketamt=data.data[0]['ticketamt'];
				$scope.iatafare=data.data[0]['iatafare'];
				$scope.instructions=data.data[0]['instructions'];
				$scope.onceinmonth=Number(data.data[0]['oncein'] );
				$scope.emp_leave=data.data[0]['annualleave'];
					/* for(var i=0;i<$scope.nationalarray.length;i++){
						if($scope.nationalarray[i]['id'] == data.data[0]['empnation'])
						{
							
							$scope.emp_nationality=$scope.nationalarray[i]['name'];
						}
					} */
					
					/* for(var i=0;i<$scope.religionarray.length;i++){
						if($scope.religionarray[i]['id'] == data.data[0]['empreligion'])
						{
							
							$scope.emp_religion=$scope.religionarray[i]['name'];
						}
					} */
					
					 for(var i=0;i<$scope.visaarray.length;i++){
						if($scope.visaarray[i]['id'] == data.data[0]['empvisa'])
						{
							
							$scope.emp_visa_type=$scope.visaarray[i]['name'];
						}
					} 
					
					 for(var i=0;i<$scope.visacatarray.length;i++){
						if($scope.visacatarray[i]['id'] == data.data[0]['empvisacat'])
						{
							
							$scope.emp_visa_cat=$scope.visacatarray[i]['name'];
						}
					} 
					
					for(var i=0;i<$scope.funcarray.length;i++){
						if($scope.funcarray[i]['id'] == data.data[0]['empfuncarea'])
						{
							
							$scope.emp_functional=$scope.funcarray[i]['name'];
						}
					}
					
					/* for(var i=0;i<$scope.bloodgarray.length;i++){
						if($scope.bloodgarray[i]['id'] == data.data[0]['empbloodgroup'])
						{
							
							$scope.emp_blood_group=$scope.bloodgarray[i]['name'];
						}
					} */
					
				if(data.data[0]['nearestairport'] !=""){
					var n=data.data[0]['nearestairport'].split(',');
					$scope.emp_city4=n[0];
					$scope.emp_country4=n[1];
					
				}
				else{
					$scope.emp_city4="";
					$scope.emp_country4="";
				}
				$scope.chk9=data.data[0]['airticket'];
				
				
				if(data.data[0]['familydetails'] != "" || data.data[0]['familydetails'] != null){
				var a=data.data[0]['familydetails'].split(',');
				$scope.adult=a[0];
				$scope.child=a[1];
				$scope.infant=a[2];
				}
				$scope.workarray = data.data[0]['empwork'];
				if($scope.workarray.length==0){
					$scope.workarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				
				$scope.qualificationarray = data.data[0]['empqual'];
				if($scope.qualificationarray.length==0){
					$scope.qualificationarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				//$scope.workarray = data.data[0]['empwork'];
				
				//$scope.qualificationarray = data.data[0]['empqual'];
				
				$scope.documentarray = data.data[0]['empdocarray'];
				
				
				$scope.dependantarray = data.data[0]['empdepenarray'];
				$scope.empskillarray = data.data[0]['empskills'];
				if($scope.empskillarray.length==0){
					$scope.empskillarray.insert(0,{id:0, skill:0,desc:""});
				}
				//$scope.empskillarray = data.data[0]['empskills'];
				
				$scope.emp_insurancearray = data.data[0]['empinsurance'];
				
				$scope.emp_creditcardarray = data.data[0]['empcreditcard'];
					if($scope.emp_creditcardarray.length==0){
					$scope.emp_creditcardarray.insert(0,{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
				}
				
				$scope.emp_bankarray = data.data[0]['empbank'];
				if($scope.emp_bankarray.length==0){
					$scope.emp_bankarray.insert(0,{id:0, bankid:"", iban_no:"",swiftcode:"",branch:""});
				}
				$scope.bankloanarray = data.data[0]['empbankloan'];
			
				if($scope.bankloanarray.length==0){
					$scope.bankloanarray.insert(0,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
				}
				
				$scope.workhalfdaysarray = data.data[0]['empworkhalfday'];
				$scope.workfulldaysarray = data.data[0]['empworkfullday'];
				$scope.familyarray = data.data[0]['empltadetails'];
				for(var i=0;i<$scope.familyarray.length;i++){
					$scope.datediff(i);
				}
				getcity1(16);
				getcity1(17);
				getcity1(18);
				//getcity1(27);
				
				$scope.chk8=data.data[0]['empepaypattern'];
				
				$scope.curmonth=data.data[0]['curmonth'];
				$scope.curyear=data.data[0]['curyear'];
				if(data.data[0]['empexp']!=""){
					var empexp = (data.data[0]['empexp']).split(",");
					$scope.year= Number(empexp[0]);
					$scope.month=Number(empexp[1]);
				}
				if(data.data[0]['totalexp']!=""){
					var empexp = (data.data[0]['totalexp']).split(",");
					$scope.tyear= Number(empexp[0]);
					$scope.tmonth=Number(empexp[1]);
				}
				
					
					/* for(var i=0;i<$scope.countryarray.length;i++){
						if($scope.countryarray[i]['id'] == data.data[0]['empccountry'])
						{
							
							$scope.emp_country1=$scope.countryarray[i]['name'];
						}
					} */
					/* for(var i=0;i<$scope.countryarray.length;i++){
						if($scope.countryarray[i]['id'] == data.data[0]['emphcountry'])
						{
							
							$scope.emp_country2=$scope.countryarray[i]['name'];
						}
					}
					for(var i=0;i<$scope.countryarray.length;i++){
						if($scope.countryarray[i]['id'] == data.data[0]['empecountry'])
						{
							
							$scope.emp_country3=$scope.countryarray[i]['name'];
						}
					} */
					
			}
			callafterfetchdetail();
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchnotification =function($id)
	{
	   
		$scope.hastrue=true;
		var xsrf = $.param({notificationid: $id});
		$http({
			url: path+'profile/getanotification',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.empids='';
					onfetch('employee/getallemployee',20);
					$scope.notificationname=data.data[0]['notificationname'];
					$scope.message=data.data[0]['message'];
					//$scope.division=Number(data.data[0]['division']);
					//$scope.department=Number(data.data[0]['department']);
					//$scope.designation=Number(data.data[0]['designation']);
					
					$scope.startdate=data.data[0]['startdate'];
					$scope.enddate=data.data[0]['enddate'];
					$scope.priority=data.data[0]['priority'];
					$scope.createdby=data.data[0]['createdby'];
					//$scope.appsts=data.data[0]['appsts'];
					for(var i=0;i<$scope.divisionarray.length;i++){
						if($scope.divisionarray[i]['id'] == data.data[0]['division'])
						{
							$scope.division=$scope.divisionarray[i]['name'];
						}
					}
					
					for(var i=0;i<$scope.desigarray.length;i++){
						if($scope.desigarray[i]['id'] == data.data[0]['designation'])
						{
							$scope.designation=$scope.desigarray[i]['name'];
						}
					}
					
					for(var i=0;i<$scope.departarray.length;i++){
						if($scope.departarray[i]['id'] == data.data[0]['department'])
						{
							$scope.department=$scope.departarray[i]['name'];
						}
					}
					
					setTimeout(function(){
						if(data.data[0]['employeeids'] != "" ){
							$scope.employees=[];
							var temparr =data.data[0]['employeeids'];
							for ( var x=0; x<temparr.length; x++){
								for ( var i=0; i<$scope.reportingtoarray.length; i++){
										
									if ($scope.reportingtoarray[i].id == temparr[x]){ 
										
										$scope.employees.push($scope.reportingtoarray[i].name);
										
										}
									}
							}
							$scope.empids=$scope.employees.toString();
						//console.log($scope.empids)
						}
					}, 1000);
					
					
					
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}


////////////////////////////// profile update../////////////////////

$scope.onprofileupdate = function($val)
{

$scope.hastrue=true;
	var total=0;
	for(var i=0;i<$scope.dependantarray.length;i++){
		total =Number(total) + Number($scope.dependantarray[i]['nominee']);
	}
	if( total!=0){
		if( total!=100){
			errorMessage("Nominee % in nominee details should be 100 %");
			$scope.hastrue=false;
			return;
		}
	}

var jsonData1=angular.toJson($scope.workarray);
var jsonData2=angular.toJson($scope.qualificationarray);
var jsonData3=angular.toJson($scope.documentarray);
var jsonData4 = angular.toJson($scope.dependantarray);
var jsonData5 = angular.toJson($scope.empskillarray);
var jsonData6 = angular.toJson($scope.emp_creditcardarray);
var jsonData7 = angular.toJson($scope.emp_insurancearray);
var jsonData8 = angular.toJson($scope.emp_bankarray);
var jsonData9 = angular.toJson($scope.bankloanarray);

var xsrf = $.param({emp_id:$scope.employeeid, emp_fname:$scope.emp_fname, emp_lname:$scope.emp_lname,emp_mname:$scope.emp_mname,  emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital,emp_dob:$scope.emp_dob, emp_blood_group:$scope.emp_blood_group, emp_gender:$scope.emp_gender, emp_religion:$scope.emp_religion, emp_known_lang:$scope.emp_known_lang,  emp_visa_type:$scope.emp_visa_type,  emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3,emp_functional:$scope.emp_functional,  emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3, bankname:$scope.bankname, bankifsccode:$scope.bankifsccode, bankaccount:$scope.bankaccountnumber,pay_pattern:$scope.chk8,bankaddress:$scope.bankaddress, emp_dependant:jsonData4,emp_skill:jsonData5,emp_creditcard:jsonData6,emp_insurance:jsonData7,emp_exp:$scope.year+','+$scope.month, visa:$scope.visa,emp_bank:jsonData8, emp_bankloan:jsonData9});

  $http({
        url: path+'profile/updateemployeeprofile',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				
				if($scope.files != ""){
					
					$scope.uploadFile($val);
					
				}
				if($scope.document != ""){
					
					$scope.uploadDocument($val);
					
				}
				else{
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					}
					
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


	
	///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.employeeid;

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeImage",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
				if(data.status){
				//errorMessage(data.successMsg);
						
				
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
			
				$scope.hastrue=false;
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
		  $scope.hastrue=false;
    };
	
	/////////////////document upload///////////////////////////////

$scope.document = [];

    //listen for the file selected event
    $scope.$on("documentSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
			
        });
    });

$scope.uploadDocument = function($val) {
	
	
	var emp=$scope.employeeid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeDocument/1",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//errorMessage(document.getElementById(i).name);
                }
				for (var i = 0; i < $scope.documentarray.length; i++) {
                    if(document.getElementById(i).value!=""){
					var docid=document.getElementById(i).name;
					}
                }
				
				
				formData.append('emp_id',emp);
				formData.append('doc_id',docid);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.document }
        }).
        success(function (data, status, headers, config) {
			
				if(data.status){
				//errorMessage(data.successMsg);
						
				
				
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					}
			}
			else{
				errorMessage(data.errorMsg);
			}
			
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }



////////////////////////////////// On update employee personal information ///////////////////////////////////////////////

$scope.onupdate = function($val)
{
 
$scope.hastrue=true;
	
		var age=0;
		var adult = 0;
		var child = 0;
		var infant = 0;
		for(var i=0;i<$scope.familyarray.length;i++){
			age =$scope.familyarray[i].age;
			if(age<=2 && age>=0){
				infant++;
			}
			else if(age>2 && age<18){
				child++	;
			}
			else if(age>=18){
				adult++;	
			}
		}
		var family=adult+','+child+','+infant;
	if($scope.chk9!=2){
		$scope.familyarray=[{id:0,  fname:"", passportno:"",emiratesid:"",bdate:"",  age:0}];
		family="0,0,0";
	}
	var jsonData1=angular.toJson($scope.workarray);
	var jsonData2=angular.toJson($scope.qualificationarray);
	//var jsonData3=angular.toJson($scope.documentarray);
//	var jsonData4 = angular.toJson($scope.dependantarray);
	var jsonData5 = angular.toJson($scope.empskillarray);
	var jsonData6 = angular.toJson($scope.emp_creditcardarray);
//	var jsonData7 = angular.toJson($scope.emp_insurancearray);
	var jsonData8 = angular.toJson($scope.emp_bankarray);
	var jsonData9 = angular.toJson($scope.bankloanarray);
	//var jsonData10 = angular.toJson($scope.familyarray);
	//var jsonData11 = angular.toJson($scope.salaryarray);
	//var jsonData12 = angular.toJson($scope.referencearray);
	var nearestairport="";

	if($scope.emp_city4 !="" && $scope.emp_country4 !="" && $scope.emp_city4 !=null && $scope.emp_country4 !=null){
	 nearestairport=$scope.emp_city4+','+$scope.emp_country4;
	}
	var xsrf = $.param({emp_id:$scope.employeeid,emp_code:$scope.emp_code, emp_fname:$scope.emp_fname,emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_doj:$scope.emp_doj, emp_doc:$scope.emp_doc, emp_visa_type:$scope.emp_visa_type, emp_gender:$scope.emp_gender, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_qualificationarray:jsonData2, bankname:$scope.bankname, bankifsccode:$scope.bankifsccode, bankaddress:$scope.bankaddress,emp_workarray:jsonData1, emp_skill:jsonData5, emp_creditcard:jsonData6,emp_bank:jsonData8,emp_bankloan:jsonData9,personal_no:$scope.personal_no});

	  $http({
			url: path+'profile/updateemployeeprofile',
			method: "POST",
			headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
			data: xsrf
				
		  }).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);
					$( "#test" ).removeAttr('src');
					if($scope.files != ""){
						
						$scope.uploadFile($val);
						
					}
					if($scope.document != ""){
						
						$scope.uploadDocument($val);
						
					}
					if($scope.qualificationdoc != ""){
					$scope.uploadqualificationdoc($val);
					}
					/* if($scope.visadoc != ""){
						
						$scope.uploadVisa($val);
						
					} */
					/* if($scope.passport != ""){
						
						$scope.uploadPassport($val);
						
					} */
					//else{
					if($val==1){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					//}
						
					}
					$scope.callout=0;
					$scope.emppic="";
					$scope.emp_code="";
					$scope.files="";
					$scope.emp_report_to="";
					$scope.emp_division="";
					$scope.emp_grade="";
					$scope.emp_depart="";
					$scope.emp_desig="";
					$scope.emp_location="";
					$scope.emp_shift="";
					$scope.emp_sts="";
					$scope.chk1 = false; 
					$scope.chk2 = false;
					$scope.chk3 = false;
					$scope.chk4 = false; 
					$scope.chk5 = false;
					$scope.chk6 = false;
					$scope.chk7 = false;
					$scope.emp_fname="";
					$scope.emp_lname="";
					$scope.emp_dob="";
					$scope.emp_gender="";
					$scope.emp_marital="";
					$scope.emp_blood_group="";
					$scope.emp_nationality="";
					$scope.emp_visa_type="";
					$scope.emp_known_lang="";
					$scope.emp_religion = "";
					$scope.emp_functional="";
					$scope.emp_doj="";
					$scope.emp_doc="";
					$scope.emp_contact1="";
					$scope.emp_email1="";
					$scope.emp_address1="";
					$scope.emp_country1="";
					$scope.emp_city1="";
					$scope.emp_zipcode1="";

					$scope.emp_contact2="";
					$scope.emp_email2="";
					$scope.emp_address2="";
					$scope.emp_country2="";
					$scope.emp_city2="";
					$scope.emp_zipcode2="";

					$scope.emp_contact3="";
					$scope.emp_email3="";
					$scope.emp_address3="";
					$scope.emp_country3="";
					$scope.emp_city3="";
					$scope.emp_zipcode3="";
					$scope.salaryctc="";
					$scope.paypattern="";
					$scope.bankname="";
					$scope.bankifsccode="";
					$scope.bankaccountnumber="";
					$scope.bankaddress="";
					$scope.emp_type="";
					$scope.cmp_email="";
					$scope.emp_experience="";
					$scope.employeeid=0;
					
					$scope.airport="";
					$scope.immigration="";
					$scope.visa="";
					$scope.visacost="";
					$scope.airticket="";
					$scope.onceinyear="";
					$scope.onceinmonth="";
					$scope.ticketclass="";
					$scope.iatafare="";
					$scope.ticketamt="";
					$scope.instructions="";
					$scope.provision="";
						$scope.hastrue=false;
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
		$scope.hastrue=false;
}

///////////////////////////////// End updating employee personal information ///////////////////////////////////////////


	
	
	
});


////////////////////////////// severance by mail approval controller /////////////////////////


app.controller('severanceapprovalbymailCtrl', function($scope, $http, $timeout) {
	
	$scope.hastrue=false;
    $scope.userid=0;
    $scope.org_id=0;
	$scope.employeeseveranceid=0;
	$scope.approverresult=0;
	$scope.comment="";
	$scope.result="";
	$scope.remarks="";	
	$scope.onapprove = function()
	{
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ userid:$scope.userid, org_id:$scope.org_id,employeeseveranceid:$scope.employeeseveranceid,approverresult:$scope.approverresult, comment:$scope.comment});
		$http({
			url: path+'approvalbymail/approveseveranceapproval',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
				//successMessage(data.successMsg);
				$scope.result=data.successMsg;
			}else{
			//errorMessage(data.errorMsg);
			$scope.result=data.errorMsg;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.onfetch = function($userid,$org_id,$employeeseveranceid,$approverresult,$appSts){
		$scope.userid=$userid;
		$scope.org_id=$org_id;
		$scope.employeeseveranceid=$employeeseveranceid;
		$scope.approverresult=$approverresult;
		
		if($approverresult==1){
			$scope.remarks="Remark for rejecting severance";
		}
		
		if($approverresult==2){
			$scope.remarks="Remark for approving severance";
		}
		
		if($appSts==1){
			$scope.result="Severance has already been rejected";
		}
		
		if($appSts==2){
			$scope.result="Severance has already been approved";
		}
	}
	

	
});

////////////////////////////// ending severance by mail approval controller /////////////////////////




/////////////////////////// Severance Controller Starts From Here  ///////////////////////////////////

app.controller('severanceCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.severancereason ="";
$scope.severanceid=0;
$scope.empid=0;
$scope.applyfrom="";
$scope.noticeperiod="";
$scope.subject="";
$scope.message="";
$scope.approversts=false;
$scope.employee=[];
$scope.approverlist=[];
$scope.statusarr=[{id:"1", name:"Resignation"},{id:"2", name:"Termination"},{id:"3", name:"Absconding"}];
$scope.approved =0;

$scope.onapprover = function($id) {
	$scope.approved=$id;
	$("#comment").modal("show");
}
$scope.onupdateapprover =function()
{
	var xsrf = $.param({severanceid: $scope.severanceid, empid: $scope.empid, comments:$scope.approvercomment, severansts:$scope.approved,lastworkingday:$scope.applyfrom});
	$http({
        url: path+'employee/changeseverancests',
        method: "POST", data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$timeout(function(){window.open(path+"employee/severance", "_self");}, timeo); 
				 successMessage(data.successMsg);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.resignationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onchangeseverancetype = function() {
	onfetchemployee('employee/getTurnoverreasons',7);
	
}

$scope.getId = function($id) {
	$scope.severanceid=$id;
	
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteseverance/'+$scope.severanceid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.resignationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
	
$scope.onfetch=function(){
	if($scope.severanceid!=0){onfetchemployee("employee/getorganizationemployee",8);}
	else{onfetchemployee("employee/getallemployee",8);}
	//onfetchemployee('employee/getTurnoverreasons',7);
}
function onfetchemployee($val, $index)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 if($index==8){
					$scope.employee=data.data;
				}else if($index==7){
					$scope.turnoverreasonarr=[];
					var temp=data.data;
					for(var i=0;i<temp.length;i++){
						
						if($scope.empstatus==1){
							if(temp[i].value < 20 && temp[i].value != 0){
								$scope.turnoverreasonarr.insert($scope.turnoverreasonarr.length,{id:temp[i].id,name:temp[i].name,value:temp[i].value});
							}
						}
						else if($scope.empstatus==2){
							if(temp[i].value >= 20){
								$scope.turnoverreasonarr.insert($scope.turnoverreasonarr.length,{id:temp[i].id,name:temp[i].name,value:temp[i].value});
							}
						}
						else if($scope.empstatus==3){
							if(temp[i].value == 0){
								$scope.turnoverreasonarr.insert($scope.turnoverreasonarr.length,{id:temp[i].id,name:temp[i].name,value:temp[i].value});
							}
							
						}
					}
					console.log($scope.turnoverreasonarr)
					console.log($scope.empstatus)
				}				
					
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}	
$scope.onchangeempcombo = function()
{
	if($scope.employeeidmodel != undefined)
	{
		if($scope.employeeidmodel.length>1)
		{
			errorMessage("Select only one Employee");
			$scope.employeeidmodel=[];
			return;
		}	
		else
			$scope.empid=parseInt($scope.employeeidmodel.toString());
	}
	$scope.employeeidmodel=undefined;
	for(var j=0; j<$scope.employee.length; j++)
	{
		if($scope.employee[j].id==$scope.empid)
		{
			$scope.empdepart = $scope.employee[j].empdepartment;
			$scope.empdesig = $scope.employee[j].empdesignation;
			$scope.empdivision = $scope.employee[j].empdivision;
			$scope.empreport= $scope.employee[j].empreport;
			
		}
	}
}
	
	$scope.onchangedate =function()
	{
	
	var xsrf = $.param({type:$scope.noticeperiod,severandate:$scope.subject});
	$http({
        url: path+'employee/fetchlastworkingdate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.applyfrom=data.data[0].value;
			
			}else{
				$scope.applyfrom="";
			
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
		
	
$scope.onfetchseverance =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({severanceid: $id});
	$http({
        url: path+'employee/getaseverance',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.severanceid = data.data[0]['id'];
				$scope.empid=data.data[0]['empid'];
				$scope.empname=data.data[0]['empname'];
				$scope.empdivision=data.data[0]['empdivision'];
				$scope.empdept=data.data[0]['empdept'];
				$scope.empreport=data.data[0]['empreport'];
				$scope.applyfrom=data.data[0]['applyfrom'];
				$scope.noticeperiod=data.data[0]['noticeperiod'];
				$scope.subject = data.data[0]['severancedate'];
				$scope.approverlist = data.data[0]['Approvals'];
				$scope.reason=data.data[0]['reason1'];
				$scope.message=data.data[0]['message'];
				$scope.attachment=data.data[0]['attachment'];
				$scope.empstatus=data.data[0]['empsts'];
				$scope.stsname=data.data[0]['empsts1'];
				$scope.approversts = data.data[0]['approversts'];
				$scope.severancereason = data.data[0]['severancereason'];
				$scope.turnoverreason = data.data[0]['turnoverreason'];
				$scope.onchangeseverancetype();
				$timeout(function(){if($scope.employee.length>0){$scope.onchangeempcombo();}}, timeo);
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({empid: $scope.empid,applyfrom: $scope.applyfrom,noticeperiod: $scope.noticeperiod,subject: $scope.subject,message: $scope.message, empstatus:$scope.empstatus,turnoverreason:$scope.turnoverreason });
  $http({
        url: path+'employee/createseverance',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.empid=data.data;
				if($scope.files!=""){
					$scope.uploadFile($val);
				}
				$scope.empstatus=0;
				$scope.applyfrom="";
				$scope.noticeperiod="";
				$scope.subject="";
				$scope.message="";
				
				if($val==1){
					//window.open(path+"severance/severance", "_self");
					$timeout(function(){window.open(path+"employee/severance", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({severanceid: $scope.severanceid, empid: $scope.empid,applyfrom: $scope.applyfrom,noticeperiod: $scope.noticeperiod,subject: $scope.subject,message: $scope.message, empstatus:$scope.empstatus,turnoverreason:$scope.turnoverreason });
  $http({
        url: path+'employee/updatedeseverance',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				if($scope.files!=""){
					$scope.uploadFile($val);
				}
				$scope.empid=0;
				$scope.applyfrom="";
				$scope.noticeperiod="";
				$scope.subject="";
				$scope.message="";
				$scope.empstatus=0;
				if($val==1){
					//window.open(path+"severance/severance", "_self");
					$timeout(function(){window.open(path+"employee/severance", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

///////////////////////////////////////letter upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	
	var emp=$scope.empid;
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeLetter",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/severance", "_self");}, timeo);
				}
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/severance", "_self");}, timeo);
				}
			}
			else{
				errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
});


/////////////////////////// Medical Insurance Controller Starts From Here  ///////////////////////////////////

app.controller('medicalCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.claim =0;
$scope.familymembers ="";

onfetch('country/getallcountry',1);
//onfetch('profile/getFamilyMembers',3);
$scope.getcity = function()
{
		onfetch('city/getallcity/'+$scope.tcountry,2);
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.countryarr=[];
					$scope.countryarr=data.data;
				}else if($id==2){
					$scope.cityarr=[];
					$scope.cityarr=data.data;
					
				}else if($id==3){
					$scope.familyarray=[];
					$scope.familyarray=data.data;
					
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

////////////////////////////////////////////
$scope.onfetchemployeedata =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getselfdata',
        method: "POST",
		
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeeid=data.data[0]['id'];
				onfetch('profile/getFamilyMembers/'+$scope.employeeid,3);
				$scope.name=data.data[0]['name'];
				$scope.age=data.data[0]['age'];
				$scope.gender=data.data[0]['gender'];
				$scope.maritalstatus=data.data[0]['maritalstatus'];
				$scope.nationality=data.data[0]['nationality'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////////////////////
$scope.onfetchclaimdata =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getmedicalclaimdata/'+$scope.claimid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.claim=data.data[0]['claim'];
				$scope.familymembers=data.data[0]['familymembers'];
				if($scope.claim==2){
					$scope.getFamilyDetails();
				}
				$scope.fmobile=parseInt(data.data[0]['fmobile']);
				$scope.minsuranceno=data.data[0]['minsuranceno'];
				$scope.tcountry=data.data[0]['tcountry'];
				onfetch('city/getallcity/'+$scope.tcountry,2);
				$scope.tcity=data.data[0]['tcity'];
				$scope.thospital=data.data[0]['thospital'];
				$scope.tsymptoms=data.data[0]['tsymptoms'];
				$scope.tspeciality=data.data[0]['tspeciality'];
				$scope.trefdoctor=data.data[0]['trefdoctor'];
				$scope.tdetails=data.data[0]['tdetails'];
				$scope.tdiagnosis=data.data[0]['tdiagnosis'];
				$scope.tprognosis=data.data[0]['tprognosis'];
				$scope.reqamount=parseInt(data.data[0]['reqamount']);
				$scope.sancamount=parseInt(data.data[0]['sancamount']);
				$scope.leavefrom=data.data[0]['leavefrom'];
				$scope.leaveto=data.data[0]['leaveto'];
				$scope.docattach=data.data[0]['docattach'];
				$scope.approvests=data.data[0]['approvests'];
				//$scope.releasests=data.data[0]['releasests'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////////////////////
$scope.getFamilyDetails =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getFamilyDetails/'+$scope.familymembers,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.fname=data.data[0]['name'];
				$scope.fage=data.data[0]['age'];
				$scope.frelation=data.data[0]['relation'];
				$scope.fpassport=data.data[0]['passport'];
			}
			else{
				$scope.fname="";
				$scope.fage="";
				$scope.frelation="";
				$scope.fpassport="";
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onCreate = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({claim: $scope.claim, employeeid: $scope.employeeid,  familymembers: $scope.familymembers, fmobile:$scope.fmobile,minsuranceno:$scope.minsuranceno,tcountry:$scope.tcountry,tcity:$scope.tcity, thospital:$scope.thospital, tsymptoms:$scope.tsymptoms, tspeciality:$scope.tspeciality, trefdoctor:$scope.trefdoctor, tdetails:$scope.tdetails, tdiagnosis:$scope.tdiagnosis, tprognosis:$scope.tprognosis, reqamount:$scope.reqamount, leavefrom:$scope.leavefrom, leaveto:$scope.leaveto});
	$http({
        url: path+'profile/createMedicalClaim',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.claimid=data.claimid;
				if($scope.files!=""){
					$scope.uploadFile();
				}
				$timeout(function(){window.open(path+"profile/medicalclaim", "_self");}, timeo); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onUpdate = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({claim: $scope.claim, employeeid: $scope.employeeid,  familymembers: $scope.familymembers, fmobile:$scope.fmobile,minsuranceno:$scope.minsuranceno,tcountry:$scope.tcountry,tcity:$scope.tcity, thospital:$scope.thospital, tsymptoms:$scope.tsymptoms, tspeciality:$scope.tspeciality, trefdoctor:$scope.trefdoctor, tdetails:$scope.tdetails, tdiagnosis:$scope.tdiagnosis, tprognosis:$scope.tprognosis, reqamount:$scope.reqamount, leavefrom:$scope.leavefrom, leaveto:$scope.leaveto, claimid:$scope.claimid});
	$http({
        url: path+'profile/updateMedicalClaim',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				if($scope.files!=""){
					$scope.uploadFile();
				}
				$timeout(function(){window.open(path+"profile/medicalclaim", "_self");}, timeo); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

  //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function() {
	
	var claimid=$scope.claimid;
	console.log($scope.claimid);
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"profile/uploadMedicalDocument",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				formData.append('claimid', claimid);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"profile/medicalclaim", "_self");}, timeo);
			}
			else{
				//errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
});

/////////////////////////// HR Medical Insurance Controller Starts From Here  ///////////////////////////////////

app.controller('hrmedicalCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.claim =1;
$scope.familymembers ="";

onfetch('country/getallcountry',1);
onfetch('employee/getFinanceDeptEmp',4);
$scope.getcity = function()
{
		onfetch('city/getallcity/'+$scope.country,2);
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.countryarr=[];
					$scope.countryarr=data.data;
				}else if($id==2){
					$scope.cityarr=[];
					$scope.cityarr=data.data;
					
				}else if($id==3){
					$scope.familyarray=[];
					$scope.familyarray=data.data;
					
				}else if($id==4){
					$scope.financearr=[];
					$scope.financearr=data.data;
					
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

////////////////////////////////////////////
$scope.onfetchemployeedata =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getselfdata',
        method: "POST",
		
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeeid=data.data[0]['id'];
				$scope.name=data.data[0]['name'];
				$scope.age=data.data[0]['age'];
				$scope.gender=data.data[0]['gender'];
				$scope.maritalstatus=data.data[0]['maritalstatus'];
				$scope.nationality=data.data[0]['nationality'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

////////////////////////////////////////////
$scope.getFamilyDetails =function()
{
	$scope.hastrue=true;
	
	$http({
        url: path+'profile/getFamilyDetails/'+$scope.familymembers,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.fname=data.data[0]['name'];
				$scope.fage=data.data[0]['age'];
				$scope.frelation=data.data[0]['relation'];
				$scope.fpassport=data.data[0]['passport'];
			}
			else{
				$scope.fname="";
				$scope.fage="";
				$scope.frelation="";
				$scope.fpassport="";
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchclaimdata =function()
{
	$scope.hastrue=true;
	$http({
        url: path+'employee/getmedclaimdetails/'+$scope.claimid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeeid=data.data[0]['employeeid'];
				onfetch('profile/getFamilyMembers/'+$scope.employeeid,3);
				$scope.employeename=data.data[0]['employeename'];
				$scope.claim=data.data[0]['claim'];
				$scope.familymembers=data.data[0]['familymembers'];
				if($scope.claim==2){
					$scope.getFamilyDetails();
				}
				$scope.fmobile=parseInt(data.data[0]['fmobile']);
				$scope.minsuranceno=data.data[0]['minsuranceno'];
				$scope.tcountry=data.data[0]['tcountry'];
				//onfetch('city/getallcity/'+$scope.tcountry,2);
				$scope.tcity=data.data[0]['tcity'];
				$scope.thospital=data.data[0]['thospital'];
				$scope.tsymptoms=data.data[0]['tsymptoms'];
				$scope.tspeciality=data.data[0]['tspeciality'];
				$scope.trefdoctor=data.data[0]['trefdoctor'];
				$scope.tdetails=data.data[0]['tdetails'];
				$scope.tdiagnosis=data.data[0]['tdiagnosis'];
				$scope.tprognosis=data.data[0]['tprognosis'];
				$scope.reqamount=parseInt(data.data[0]['reqamount']);
				$scope.sancamount=parseInt(data.data[0]['sancamount']);
				$scope.leavefrom=data.data[0]['leavefrom'];
				$scope.leaveto=data.data[0]['leaveto'];
				$scope.docattach=data.data[0]['docattach'];
				$scope.approvests=data.data[0]['approvests'];
				$scope.entitled=data.data[0]['entitled'];
				$scope.remark=data.data[0]['remark'];
				//$scope.releasests=data.data[0]['releasests'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onApprove = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({sancamount:$scope.sancamount, entitled:$scope.entitled, financeby:$scope.financeby, remarks:$scope.remarks, claimid:$scope.claimid});
	$http({
        url: path+'employee/updateApproveClaim',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"employee/medicalclaim", "_self");}, timeo); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onRelease = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({fremark:$scope.fremark, claimid:$scope.claimid});
	$http({
        url: path+'employee/updateReleaseClaim',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"employee/medicalclaim", "_self");}, timeo); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onReject = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({claimid:$scope.claimid});
	$http({
        url: path+'employee/rejectClaim',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"employee/medicalclaim", "_self");}, timeo); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


});

