/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('performanceapp', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});
app.directive('myPostRepeatDirective', function() {
  return function(scope, element, attrs) {
    if (scope.$last){
      // iteration is complete, do whatever post-processing
      // is necessary
		jQuery.fn.multiselect = function() {
			$(this).each(function() {
				var checkboxes = $(this).find("input:checkbox");
				checkboxes.each(function() {
					var checkbox = $(this);
					// Highlight pre-selected checkboxes
					if (checkbox.prop("checked"))
						checkbox.parent().addClass("multiselect-on");
		 
					// Highlight checkboxes that the user selects
					checkbox.click(function() {
						if (checkbox.prop("checked"))
							checkbox.parent().addClass("multiselect-on");
						else
							checkbox.parent().removeClass("multiselect-on");
					});
				});
			});
		};
		
		$(function() {
			 $(".multiselect").multiselect();
		});
    }
  };
});
/////////////////////////// objective Controller Starts From Here  ///////////////////////////////////

app.controller('objectiveCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.desig="";
$scope.period="";
$scope.objectiveid=0;
$scope.variablepaysts=0;
$scope.designationarray=[];
$scope.quadrantarray=[];
$scope.traineecriteria=0;

onfetch('setup/getCompetencyDesignation',1);
onfetch('performanceold/getBehaviouralQuadrant',2);
onfetch('performance/getallKpi',3);
$scope.getId = function($id) {
		$scope.objectiveid=$id;
}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deleteobjective/'+$scope.objectiveid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.objectiveid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.designationarray=[];
					$scope.designationarray=data.data;
				
				}
				else if($id==2){
					$scope.quadrantarr=[];
					$scope.quadrantarr=data.data;
				
				}
				else if($id==3){
					$scope.kpiarr=[];
					$scope.kpiarr=data.data;
				
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}	

$scope.objectivearray=[{id:0, quadrant:0,objective:"", desc:"", weightage:""}];
$scope.addquadrant = function($i){

	var len = $scope.objectivearray.length-1;
	if($scope.objectivearray[len]['quadrant']=="" || $scope.objectivearray[len]['objective']=="" || $scope.objectivearray[len]['weightage']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.objectivearray.insert($i,{id:0, quadrant:0,objective:"",desc:"", weightage:""});
	}
	
}
$scope.removequadrant = function($i){
	
	$scope.objectivearray.remove($i);	
	if($scope.objectivearray.length == 0){
		$scope.objectivearray.insert(0,{id:0, quadrant:0,objective:"",desc:"", weightage:""});
	}
}
$scope.onaddlevel = function($id,$index)
   {
		//console.log($index)
		var temp ="";
		for(var i=0;i<$scope.designationarray1.length;i++){
			if($scope.designationarray1[i].id == $id){
				
				temp=$scope.designationarray1[i].name;
				$scope.designationlevel[$index].dname=temp;
				$scope.designationlevel[$index].dnamecheck=false;
				$scope.designationlevel[$index].desiglevel=Number($scope.designationarray1[i].id);
				//console.log($scope.designationlevel[$index]['desiglevel'])
				var level=$scope.designationarray1[i]['level'];
				var desig=$scope.designationarray1.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray1.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray1[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray1.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		//console.log($scope.designationlevel)
		/* if($scope.designationarray1.length>=1){
			$scope.designationlevel.insert($scope.designationlevel.length,{desiglevel:""});	
		} */
		
		
   }
$scope.designationlevel=[{desiglevel:""}];
$scope.addlevel = function($id,$index)
   {
		//console.log($index)
		var temp ="";
		for(var i=0;i<$scope.designationarray1.length;i++){
			if($scope.designationarray1[i].id == $id){
				
				temp=$scope.designationarray1[i].name;
				$scope.designationlevel[$index].dname=temp;
				$scope.designationlevel[$index].dnamecheck=false;
				$scope.designationlevel[$index].desiglevel=Number($scope.designationarray1[i].id);
				//console.log($scope.designationlevel[$index]['desiglevel'])
				var level=$scope.designationarray1[i]['level'];
				var desig=$scope.designationarray1.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray1.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray1[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray1.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		//console.log($scope.designationlevel)
		if($scope.designationarray1.length>=1){
			$scope.designationlevel.insert($scope.designationlevel.length,{desiglevel:""});	
		}
		
		
   }
   $scope.removelevel = function($id,$index)
   {
	
		$scope.designationarray1=[];
		for(var i=0;i<$scope.desigarray.length;i++){
			if($scope.desigarray[i].id == $id){
				if($scope.designationlevel.length>1){
					var temp=$scope.designationlevel[$index-1].desiglevel;
					var level=$scope.desigarray[i]['level'];
					var desig=$scope.desigarray.length;
					for(var j=0;j<desig;j++){
						if($scope.desigarray[j].id == temp){
							for(var x=j;x<desig-1;x++){
								$scope.designationarray1.insert(x,{id:$scope.desigarray[x].id,name:$scope.desigarray[x].name,level:$scope.desigarray[x].level});
							}
						}
					}	
				}
			}	
		}
			
	
	
	$scope.designationlevel.remove($index);
	if($scope.designationlevel.length ==0){
		$scope.designationlevel.insert(0,{desiglevel:""});
	}
	if($scope.designationlevel[0].desiglevel ==""){
		$scope.onchangedesig();
	}
	
   }
$scope.checkmarks=function($val){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	console.log(weightage)
	if($val > weightage){
		//errorMessage("Entered range should not be greater than "+weightage);
	}
}
$scope.resultarray=[{id:0, minmarks:0,maxmarks:100,rating:0,result:"",amt:0,tcriteria:false}];
$scope.addresult = function($i){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	var len = $scope.resultarray.length-1;
	
	if($scope.resultarray[len]['maxmarks']=="" || $scope.resultarray[len]['result']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.resultarray.insert($i,{id:0, minmarks:($scope.resultarray[len]['maxmarks']+1),maxmarks:100,rating:($scope.resultarray[len]['rating']+1),result:"",amt:0,tcriteria:false});
	}
	
}
$scope.removevariablepayrange = function($i){
	
	$scope.variablepayarr.remove($i);	
	if($scope.variablepayarr.length == 0){
		$scope.variablepayarr.insert(0,{id:0, minmarks:0,maxmarks:0,amount:""});
	}
}

$scope.variablepayarr=[{id:0, minmarks:0,maxmarks:100,rating:0,result:""}];
$scope.addvariablepayrange = function($i){
	
	var len = $scope.variablepayarr.length-1;
	
	if($scope.variablepayarr[len]['maxmarks']=="" || $scope.variablepayarr[len]['result']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.variablepayarr.insert($i,{id:0, minmarks:($scope.variablepayarr[len]['maxmarks']+1),maxmarks:0,amount:""});
		
	}
	
}
$scope.removeresult = function($i){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	$scope.resultarray.remove($i);	
	if($scope.resultarray.length == 0){
		$scope.resultarray.insert(0,{id:0, minmarks:0,maxmarks:weightage,rating:0,result:"",amt:0,tcriteria:false});
	}
}
Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};	
Array.prototype.remove = function (index) {
	this.splice(index,1);
};

$scope.objectdesc="";
$scope.onchangedesig =function()
{
	$scope.designationlevel=[{desiglevel:""}];	
	var xsrf = $.param({designationid: $scope.desig});
	$http({
        url: path+'performanceold/getseniordesig',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       $scope.desigarray=[{id:"",name:""}];
		        $scope.designationarray1=data.data; 
		        $scope.objectdesc=data.data1 ; 
			    for(var j=0;j<$scope.designationarray1.length;j++){
					$scope.desigarray.insert(j,{id:Number($scope.designationarray1[j].id),name:$scope.designationarray1[j].name,level:$scope.designationarray1[j].level});
				}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.getobjectdesc = function(){
	$timeout(function(){
	$scope.object=$scope.objectdesc;
	console.log($scope.object);
	},500);
}
$scope.onupdaterating = function($i,$str){
	$scope.resultarray[$i]['rating']=$str;
}

/* $scope.gettraineecriteria = function($val){
	$scope.traineecriteria=$val;
} */

$scope.onupdate= function($val)
{
if($scope.variablepaysts)
	$scope.variablepaysts=1;
$scope.hastrue=true;
var weightage =0;
for(var i=0;i<$scope.objectivearray.length;i++){
	weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
}
/* if(weightage != 100){
	errorMessage('Weightage should be 100%');
	$scope.hastrue=false;
}
else{ */
	var jsonData1=angular.toJson($scope.objectivearray);
	var jsonData2=angular.toJson($scope.resultarray);
	var jsonData3=angular.toJson($scope.designationlevel);
	var jsonData4=angular.toJson($scope.variablepayarr);
	var xsrf = $.param({objectiveid:$scope.objectiveid, desig:$scope.desig, jobdesc:$scope.object, period:$scope.period,objective:jsonData1,result:jsonData2,desiglevel:jsonData3,overachieve:jsonData4,rate:$scope.rate, threshholdscore:$scope.threshholdscore, achieveingamt:$scope.achieveingamt, variablepaysts:$scope.variablepaysts});
	  $http({
			url: path+'performanceold/updateobjective',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.objectiveid=0;
					$scope.objectivearray=[{id:0, quadrant:0,objective:"",desc:"", weightage:""}];				
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/objective", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	/* } */	
}
$scope.oncreate= function($val)
{
if($scope.variablepaysts)
	$scope.variablepaysts=1;
$scope.hastrue=true;
var weightage =0;
for(var i=0;i<$scope.objectivearray.length;i++){
	weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
}
/* if(weightage != 100){
	errorMessage('Total Weightage should be 100%');
	$scope.hastrue=false;
}
else{ */
	var jsonData1=angular.toJson($scope.objectivearray);
	var jsonData2=angular.toJson($scope.resultarray);
	var jsonData3=angular.toJson($scope.designationlevel);
	var jsonData4=angular.toJson($scope.variablepayarr);
	var xsrf = $.param({ desig:$scope.desig, period:$scope.period,objective:jsonData1,result:jsonData2,desiglevel:jsonData3,rate:$scope.rate,overachieve:jsonData4,threshholdscore:$scope.threshholdscore, achieveingamt:$scope.achieveingamt, variablepaysts:$scope.variablepaysts,jobdesc:$scope.object});
	  $http({
			url: path+'performanceold/createobjective',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.objectiveid=0;				
					$scope.objectivearray=[{id:0, quadrant:0,objective:"", weightage:""}];	
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/objective", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	/* } */	
}

$scope.onfetchobjective=function($val)
{ 
$scope.hastrue=true;
var xsrf = $.param({objectiveid: $val});
	$http({
        url: path+'performanceold/getaobjective',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		        $scope.desig=data.data[0]['desig']; 
		        $scope.designame=data.data[0]['designame']; 
		        $scope.object=data.data[0]['jobdesc']; 
		        //$scope.traineecriteria=data.data[0]['traineecriteria']; 
			    $scope.period=data.data[0]['period'];
			    $scope.threshholdscore=data.data[0]['threshholdscore'];
			    $scope.achieveingamt=data.data[0]['achievingamt'];
			    $scope.variablepaysts=data.data[0]['variablepaysts'];
				if($scope.variablepaysts==1)
						$scope.variablepaysts=true;
				$scope.onchangedesig();
				$timeout(function(){
				
					if(data.data[0]['desiglevel'].length>0){
					var temp=data.data[0]['desiglevel'];
					var tempcheck=data.data[0]['desiglevelcheck'];
					
						for(var i=0; i<temp.length; i++)
						{
							for(var j=0;j<$scope.designationarray1.length;j++){
							//console.log(data.data[0]['desiglevel'][i])
									if($scope.designationarray1[j].id == temp[i]){
										if(tempcheck[i]=="1"){
											tempcheck[i]=true;}
										else{
											tempcheck[i]=false;}
										$scope.designationlevel.insert(i,{desiglevel:Number($scope.designationarray1[j].id),dname:$scope.designationarray1[j].name,dnamecheck:tempcheck[i]});
										$scope.designationarray1.remove(j);
									}
								}
						}	
						$scope.designationarray1=[];
						$scope.designationlevel.remove(temp.length);
					}
				},2000);
		        $scope.objectivearray=data.data[0]['objective'];
			    if($scope.objectivearray.length == 0){
					$scope.objectivearray.insert(0,{id:0, quadrant:0,objective:"", weightage:""});
				}
				$scope.resultarray=data.data[0]['result'];
			    if($scope.resultarray.length == 0){
					$scope.resultarray.insert(0,{id:0, minmarks:0,maxmarks:100,result:"",amt:0,tcriteria:false});
				}
				$scope.variablepayarr=data.data[0]['overachieve'];
			    if($scope.variablepayarr.length == 0){
					$scope.variablepayarr.insert(0,{id:0, minmarks:0,maxmarks:100,amount:""});
				}
				
			}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.getobjdesc=function($val,$id)
{
 for(var i=0;i<$scope.kpiarr.length;i++){
	 if($scope.kpiarr[i].id==$id){
		 $scope.objectivearray[$val].desc=$scope.kpiarr[i].desc;
	 }
 }	
}
});


/////////////////////////// Performance Dashboard Controller Starts From Here  ///////////////////////////////////

app.controller('performancedashCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.performancedasharr1=[]; 
$scope.objectivedasharr1=[];
$scope.filscalid=0;
//onfetch();
	$scope.onfetch=function($val,$type="")
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid: $scope.filscalid});
		
		$http({
			url: path+"performanceold/getPerformanceDashboard/"+$val+'/'+$type,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.performancedasharr1=[];
					$scope.performancedasharr1=data.data['performance'];
					$scope.fiscalformat=data.fiscal_format;
					$scope.filscalid=data.filscalid;
					//$scope.objectivedasharr1=[];
					//$scope.objectivedasharr1=data.data['objective'];
					
					//DONUT CHART
					var donut = new Morris.Donut({
					  element: 'bar-chart1',
					  resize: true,
					 // colors: ["#3399FF", "#FF0000", "#009933"],
					  data: $scope.performancedasharr1,
					  hideHover: 'auto',
					   formatter: function (y, data) { return   ''} 
					});
					
					// BAR CHART
        			var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, stacked:true,
					  xLabels: 'name', postUnits:'%',
					  xLabelAngle: -90, ymax:100,
					  data: data.data['objectivesales']['data'],
					  barColors: data.data['objectivesales']['quadcolor'],
					  xkey: 'name',
					  ykeys: data.data['objectivesales']['ykey'],//ykeys: ['a', 'b', 'c'],
					  labels: data.data['objectivesales']['label'],
					 // gridTextSize: 10,
					  hideHover: 'auto'
					});
					
					// BAR CHART
        			var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true, stacked:true,
					  xLabels: 'name', postUnits:'%',
					  xLabelAngle: -90, ymax:100,
					  data: data.data['objectivenonsales']['data'],
					  barColors: data.data['objectivenonsales']['quadcolor'],
					  xkey: 'name',
					  ykeys: data.data['objectivenonsales']['ykey'],//ykeys: ['a', 'b', 'c'],
					  labels: data.data['objectivenonsales']['label'],
					 // gridTextSize: 10,
					  hideHover: 'auto'
					});
					
					// BAR CHART
        			/*var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true, 
					  xLabels: 'name', postUnits:'%',
					  xLabelAngle: -90, ymax:100,
					  data: data.data['performancescore'],
					  barColors: ['#552366'],
					  xkey: 'label',
					  ykeys: ['value'],//ykeys: ['a', 'b', 'c'],
					  labels:['Score'],
					  
					  hideHover: 'auto'
					});*/
					
					// BAR CHART
					var i=1;
        				var bar = new Morris.Line({
					  element: 'bar-chart4',
					  resize: true, 
					  xLabels: 'labels', postUnits:'%',
					   ymax:100, axes:true,
					  data: data.data['performancedistribution']['data'],
					  lineColors: ['#867D7D','#7979DF'],
					  xkey: 'key', 
					  ykeys: ['value1','value'],//ykeys: ['a', 'b', 'c'],
					  labels:['Ideal Bell Curve','Actual values'],
					  hideHover: 'auto',
					  xLabelFormat:function (x) { return i++ },
					});
					
					// BAR CHART
					var i=1;
        				var bar = new Morris.Line({
					  element: 'bar-chart5',
					  resize: true, 
					  xLabels: 'key',postUnits:'%',
					   ymax:100,
					  data: data.data['performancedistributionsales']['data'],
					  lineColors: ['#867D7D','#E98A74'],
					  xkey: 'key',
					  ykeys: ['value1','value'],//ykeys: ['a', 'b', 'c'],
					  labels:['Ideal Bell Curve','Actual values'],
					  hideHover: 'auto',
					   xLabelFormat:function (x) { return i++ },
					   });
					   
					  var donut = new Morris.Donut({
					  element: 'bar-chart6',
					  resize: true,
					 // colors: ["#3399FF", "#FF0000", "#009933"],
					  data: data.data['skillgapcompetency']['data'],
					  hideHover: 'auto',
					  formatter: function (y, data) { return   ''} 
					}).on('click', function (i, row) { 
							//console.log(row)
						   //$('#bar-chart6').modal({ show: true });
						});
					var i=1;
        				var bar = new Morris.Line({
					  element: 'bar-chart7',
					  resize: true, 
					  xLabels: 'key',postUnits:'%',
					   ymax:100,
					  data: data.data['performancedistributionnonsales']['data'],
					  lineColors: ['#867D7D','#557C0A'],
					  xkey: 'key',
					  ykeys: ['value1','value'],//ykeys: ['a', 'b', 'c'],
					  labels:['Ideal Bell Curve','Actual values'],
					  hideHover: 'auto',
					   xLabelFormat:function (x) { return i++ },
					   });
					
					var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true, 
					  xLabels: 'name', //postUnits:'%',
					  xLabelAngle: -90, //ymax:100,
					  data: data.data['performancedistribution']['data'],
					  barColors: ['#552366'],
					  xkey: 'key1',
					  ykeys: ['nvalue'],//ykeys: ['a', 'b', 'c'],
					  labels:['Total Employee'],
					  
					  hideHover: 'auto'
					});
					
					var donut = new Morris.Donut({
					  element: 'bar-chart9',
					  resize: true,
					 // colors: ["#3399FF", "#FF0000", "#009933"],
					  data: data.data['competencytype']['data'],
					  hideHover: 'auto',
					  formatter: function (y, data) { return   ''} 
					}).on('click', function (i, row) { 
							//console.log(row)
						   //$('#bar-chart6').modal({ show: true });
						});
					
				  
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
});

///////////////////////////quadrant controller starts from here //////////////////////

app.controller('quadrantCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.quadrant="";
$scope.quadrantid=0;
$scope.qcolor="";
$scope.getId = function($id) {
	$scope.quadrantid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deletequadrant/'+$scope.quadrantid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.quadrantid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

		setTimeout(function(){ 
			var value=$("#quadrantcolor").val();
			if(value != ""){
			$("#cp").css('backgroundColor',value);
			}
			else{
			$("#cp").css('backgroundColor','#000000');
			}
			$("#cp").css('backgroundColor',$scope.quadrantcolor);
		 }, 500);
		

		$scope.setdefaultcolor= function()
		{
			
			if($scope.quadrantcolor == "")
			{
				$("#cp").css('backgroundColor',$scope.qcolor);
				
			}
			else{
				$("#cp").css('backgroundColor',$scope.quadrantcolor);
				
			}
		}
		
$scope.onupdate= function($val)
{

$scope.hastrue=true;

var xsrf = $.param({quadrantid:$scope.quadrantid, quadrantname:$scope.quadrant, color:$scope.quadrantcolor});
  $http({
        url: path+'performanceold/updatequadrant',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				$scope.quadrant="";	
				$scope.quadrantcolor="";				
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/quadrant", "_self");}, timeo);
				}	
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var xsrf = $.param({ quadrantname:$scope.quadrant,color:$scope.quadrantcolor});
  $http({
        url: path+'performanceold/createquadrant',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/quadrant", "_self");}, timeo);
				}	
				$scope.quadrant="";	
				$scope.quadrantcolor="";
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchquadrant=function($val)
{ 

$scope.hastrue=true;
var xsrf = $.param({quadrantid: $val});
	$http({
        url: path+'performanceold/getaquadrant',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		       $scope.quadrant=data.data[0]['name']; 
		       $scope.quadrantcolor=data.data[0]['color']; 
		       $scope.qcolor=data.data[0]['color']; 
			}
			$('.my-colorpicker2').colorpicker({color:$scope.quadrantcolor}).on('changeColor.colorpicker', function(event){
			$("#quadrantcolor").focus();
			var e = jQuery.Event("change");
			e.keyCode = 32;                     
			$("#quadrantcolor").trigger(e); 
			
			});
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		$scope.hastrue=false;
}

    
    
});

//////////////////////////////////////

app.controller('assessmentCtrl', function($scope, $http, $timeout) {
$scope.policy=[];
$scope.employeeid=0;
$scope.assessmentid=0;
$scope.empname="";
$scope.assessmenttype="";
$scope.assessmenttypeid=0;
$scope.designation="";
$scope.division="";
$scope.department="";
$scope.fromdate="";
$scope.todate="";
$scope.totalscorearr=[];		
$scope.achievements="";
$scope.issues="";
$scope.slider=0;
$scope.totalscore=0;

onfetch("setup/getalldivision",1);
onfetch("setup/getalldepartment",2);
onfetch("setup/getalldesignation",3);
onfetch("setup/getallgrade",4);
$scope.getId = function($id) {
		$scope.assessmentid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deleteassessment/'+$scope.assessmentid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.objectiveid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==1){
						$scope.divisionarray=[];
						$scope.divisionarray=data.data;
						//$scope.divisionarray.insert(0,{id:0,name:"------All-------"});
                                               
					}
					else if($id==2){
						$scope.departarray=[];
						$scope.departarray=data.data;
						//$scope.departarray.insert(0,{id:0,name:"------All-------"});
                                               
					}
					else if($id==3){
						$scope.desigarray=[];
						$scope.desigarray=data.data;
						//$scope.desigarray.insert(0,{id:0,name:"------All-------"});
                                               
					}
					else if($id==4){
						$scope.gradearray=[];
						$scope.gradearray=data.data;
						//$scope.gradearray.insert(0,{id:0,name:"------All-------"});
                                               
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	
	$scope.fetchobjective =function($val)
	{
		
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'performanceold/getempassessment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				var t1=[] ,t2=0, rate=0,
				 weightage=0,
					 score1=0,
					 rate=0,
					 $i=0,
					 $s=0,
					 $s1=0;
						
				for(var i=0;i<$scope.policy.length;i++){
					t1=$scope.policy[i].results;
					t2=t1.length;
					$scope.policy[i].score=0;
					if(t2!=0){
						$scope.policy[i].sliderval=parseInt(t1[t2-1].score);
						$scope.policy[i].score=$scope.policy[i].sliderval;
					}
					
				}
				
				$timeout(function(){
					for(var i=0;i<$scope.policy.length;i++){
						t1=$scope.policy[i].results;
						t2=t1.length;
						if(t2!=0){
						rate=parseInt(t1[t2-1].rating);
						//console.log(rate)
						$(".rating"+i).text(rate);
						}
					}
					
					$(".slider").slider({
						//value: 25,
						//tooltip: 'always',
						
						
						formatter: function(value) {
							return 'Current value: ' + value + ' %';
						}
						});
						
					$( ".slider" ).on( "slide", function( event ) {
						
					
						for(var i=0;i<$scope.policy.length;i++){
						if(i == event.delegateTarget.name)
							$scope.policy[i].score=event.value;
						}
						var weightage=0;
						var score1=0;
						var rate=0;
						var $i=0;
						var $s=0;
						var $s1=0;
						for(var i=0;i<$scope.policy.length;i++){
							if(i == event.delegateTarget.name){
								$s1=(($scope.policy[i].weightage)/($scope.policy[i].highrating));
								$s=$s1;
								var ratingarr=$scope.policy[i].ratingarr;
								for(var $j=0;$j<ratingarr.length;$j++){
								
									if(((event.value)>=ratingarr[$j].min) && ((event.value)<=ratingarr[$j].max))
									{
										console.log(ratingarr[$j].rate)
										rate=ratingarr[$j].rate;
										if($i>=$scope.policy[i].weightage)
										{
											//rate=1;
										}
										$(".rating"+i).text(rate);
										//$scope.policy[i].rating=rate;
										//console.log('rating='+rate);
										break;
									}
								$i=$s;
								$s=$i+$s1;
								
								}
								
							}	
						}
					});

				}, 1000);
				
				//$scope.assessmentid=data.data1[0]['id'];
				$scope.filepath=data.filepath;
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.potentials=data.data1[0]['potentials'];
				$scope.variablepay=data.data1[0]['variablepay'];
				$scope.desc=data.data1[0]['desc'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				$scope.totalscorearr=data.data2;
				
			}
			else{
				
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
				
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var jsonData=angular.toJson($scope.policy);
var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid,achievements:$scope.achievements,issues:$scope.issues,potentials:$scope.potentials,variablepay:$scope.variablepay,desc:$scope.desc});
  $http({
        url: path+'performanceold/createassessment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				if($scope.files.length>0)
				{
					$scope.uploadFile($val);
				}
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/assessment", "_self");}, timeo);
				}		
				$scope.policy=[];
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};

///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.employeeid;
	var date=$scope.fromdate;

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"performanceold/uploadAssessmentDoc",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('emp_id', emp);
				formData.append('assess_date', date);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
			if(data.status){
				//errorMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/assessment", "_self");}, timeo);
				}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };

});

///////////////////////////competency type controller starts from here //////////////////////

app.controller('competencytypeCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.comptype="";
$scope.competencytypeid=0;
$scope.compcolor="";
$scope.getId = function($id) {
	$scope.competencytypeid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deletecompetencytype/'+$scope.competencytypeid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.competencytypeid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}



		setTimeout(function(){ 
			var value=$("#quadrantcolor").val();
			if(value != ""){
			$("#cp").css('backgroundColor',value);
			}
			else{
			$("#cp").css('backgroundColor','#000000');
			}
			$("#cp").css('backgroundColor',$scope.compcolor);
		 }, 500);
		

		$scope.setdefaultcolor= function()
		{
			
			if($scope.quadrantcolor == "")
			{
				$("#cp").css('backgroundColor',$scope.qcolor);
				
			}
			else{
				$("#cp").css('backgroundColor',$scope.compcolor);
				
			}
		}
		
$scope.onupdate= function($val)
{

$scope.hastrue=true;

var xsrf = $.param({competencytypeid:$scope.competencytypeid, comptype:$scope.comptype,compcolor:$scope.compcolor});
  $http({
        url: path+'performanceold/updatecompetencytype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				$scope.comptype="";	
				$scope.compcolor="";				
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/competencytype", "_self");}, timeo);
				}	
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var xsrf = $.param({ comptype:$scope.comptype,compcolor:$scope.compcolor});
  $http({
        url: path+'performanceold/createcompetencytype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/competencytype", "_self");}, timeo);
				}	
				$scope.comptype="";	
				$scope.compcolor="";
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchquadrant=function($val)
{ 

$scope.hastrue=true;
var xsrf = $.param({competencytypeid: $val});
	$http({
        url: path+'performanceold/getacompetencytype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		       $scope.comptype=data.data[0]['name']; 
		       $scope.compcolor=data.data[0]['color']; 
		       $scope.qcolor=data.data[0]['color']; 
			}
			$('.my-colorpicker2').colorpicker({color:$scope.compcolor}).on('changeColor.colorpicker', function(event){
			$("#compcolor").focus();
			var e = jQuery.Event("change");
			e.keyCode = 32;                     
			$("#compcolor").trigger(e); 
			
			});
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		$scope.hastrue=false;
}

    
    
});

///////////////////////////competency type controller starts from here //////////////////////

app.controller('competencyCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.ctype="";
$scope.competencyid=0;
$scope.name="";
$scope.competencylevelarray=[];
onfetch("performanceold/getallcompetencytype",1);


$scope.getId = function($id) {
	$scope.competencyid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deletecompetency/'+$scope.competencyid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.competencyid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.comptypearray=[];
					$scope.comptypearray=data.data;
					
				}
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}	
$scope.competencylevelarray=[{id:0, level:"",desc:""}];

$scope.addlevel = function($i){

	var len = $scope.competencylevelarray.length-1;
	if($scope.competencylevelarray[len]['level']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.competencylevelarray.insert($i,{ id:0, level:"",desc:""});
	}
	
}
$scope.removelevel = function($i){
	
	$scope.competencylevelarray.remove($i);	
	if($scope.competencylevelarray.length == 0){
		$scope.competencylevelarray.insert(0,{ id:0, level:"",desc:""});
	}
}
	Array.prototype.insert = function (index, item) {
		this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
		this.splice(index,1);
	};
		
$scope.onupdate= function($val)
{

$scope.hastrue=true;
var jsonData=angular.toJson($scope.competencylevelarray);
var xsrf = $.param({competencyid:$scope.competencyid, name:$scope.name,ctype:$scope.ctype,competencylevel:jsonData});
  $http({
        url: path+'performanceold/updatecompetency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				$scope.ctype="";
				$scope.competencyid=0;
				$scope.name="";
				$scope.competencylevelarray=[{id:0, level:"",desc:""}];				
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/competency", "_self");}, timeo);
				}	
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate= function($val)
{

$scope.hastrue=true;
var jsonData=angular.toJson($scope.competencylevelarray);
var xsrf = $.param({ name:$scope.name,ctype:$scope.ctype,competencylevel:jsonData});
  $http({
        url: path+'performanceold/createcompetency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/competency", "_self");}, timeo);
				}	
				$scope.competencyid=0;
				$scope.name="";
				$scope.competencylevelarray=[{id:0, level:"",desc:""}];	
								

			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchcompetency=function($val)
{ 

$scope.hastrue=true;
var xsrf = $.param({competencyid: $val});
	$http({
        url: path+'performanceold/getacompetency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		       $scope.name=data.data[0]['name']; 
		       $scope.ctype=data.data[0]['ctype']; 
		       $scope.competencylevelarray=data.data[0]['competencylevel']; 
			   if($scope.competencylevelarray.length==0){
				$scope.competencylevelarray.insert(0,{id:0, level:"",desc:""})
			   }
			   
			}		
			
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		$scope.hastrue=false;
}

    
    
});

/////////////////////////// competencyanalysis Controller Starts From Here  ///////////////////////////////////

app.controller('competencyanalysisCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.desig="";
$scope.period="";
$scope.competencyanalysisid=0;

$scope.designationarray=[];
$scope.levelarr=[];	
$scope.competencyarr=[];
onfetch('setup/getalldesignation',1);
onfetch('performanceold/getallcompetency',2);
onfetch('performanceold/getallcompetencytype',3);
$scope.getId = function($id) {
		$scope.competencyanalysisid=$id;
	}
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deletecompetencyanalysis/'+$scope.competencyanalysisid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.competencyanalysisid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	$scope.onchangecombo =function($field,$val,$index)
	{
		if($val==1){
		//console.log($index)
			onfetchcombo("performanceold/getcombodata/"+$field+'/'+$val,$val,$index);
		}else if($val==2){
			for(var i=0; i<$scope.competencyanalysisarray.length; i++)
			{
				if($scope.competencyanalysisarray[i].comp==$field && $scope.competencyanalysisarray[i].ctype==$scope.competencyanalysisarray[$index].ctype && $index!=i){
					alert("Already selected");
					$scope.competencyanalysisarray[$index].comp="";
					$scope.competencyanalysisarray[$index].ctype="";
					
					return;
				}

			}
			onfetchcombo("performanceold/getcombodata/"+$field+'/'+$val,$val,$index);
				
			//onfetchcombo("performanceold/getcombodata/"+$field+'/'+$val,$val,$index);
		}else if($val==3){
		//console.log($index)
		$timeout(function() {
			var temp=$scope.levelarr[$index];
			if(temp.length>0){
				for(var i=0;i<(temp.length);i++){
					if($scope.competencyanalysisarray[$index].level == temp[i].id)
					$scope.competencyanalysisarray[$index].desc=temp[i].desc;
				}
			}
			},1000);
		}
	}

	function onfetchcombo($val, $id,$index)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					//$scope.competencyarr=[];
					$scope.competencyarr[$index]=data.data;
					
				
				}
				else if($id==2){
					//$scope.levelarr=[];
					$scope.levelarr[$index]=data.data;
				
				}
				
				
			}
			else{
				$scope.competencyarr[$index]=[];
				$scope.levelarr[$index]=[];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}	
function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	 		if(data.status){
				if($id==1){
					$scope.designationarray=[];
					$scope.designationarray=data.data;
				}
				else if($id==2){
					$scope.competencyarr=[];
					//$scope.competencyarr=data.data;
				}
				else if($id==3){
					$scope.competencytypearr=[];
					$scope.competencytypearr=data.data;
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}	

$scope.competencyanalysisarray=[{id:0, ctype:"",comp:"", level:"",desc: ""}];
$scope.addquadrant = function($i){

	var len = $scope.competencyanalysisarray.length-1;
	if($scope.competencyanalysisarray[len]['ctype']=="" || $scope.competencyanalysisarray[len]['comp']=="" || $scope.competencyanalysisarray[len]['level']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.competencyanalysisarray.insert($i,{id:0, ctype:"",comp:"", level:"",desc: ""});
	}
}
$scope.removequadrant = function($i){
	$scope.competencyanalysisarray.remove($i);	
	if($scope.competencyanalysisarray.length == 0){
		$scope.competencyanalysisarray.insert(0,{id:0, ctype:"",comp:"", level:"",desc: ""});
	}
}

$scope.designationlevel=[{desiglevel:""}];
$scope.addlevel = function($id,$index)
   {
		var temp ="";
		for(var i=0;i<$scope.designationarray1.length;i++){
			if($scope.designationarray1[i].id == $id){
				
				temp=$scope.designationarray1[i].name;
				$scope.designationlevel[$index].dname=temp;
				$scope.designationlevel[$index].desiglevel=String($id);
				//console.log($scope.designationarray[i]['level'])
				var level=$scope.designationarray1[i]['level'];
				var desig=$scope.designationarray1.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray1.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray1[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray1.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		
		if($scope.designationarray1.length>=1){
			$scope.designationlevel.insert($scope.designationlevel.length,{desiglevel:""});	
		}
		
			
   }
   $scope.removelevel = function($id,$index)
   {
	
	$scope.designationarray1=[];
		for(var i=0;i<$scope.desigarray.length;i++){
			if($scope.desigarray[i].id == $id){
				if($scope.designationlevel.length>1){
					var temp=$scope.designationlevel[$index-1].desiglevel;
					var level=$scope.desigarray[i]['level'];
					var desig=$scope.desigarray.length;
					for(var j=0;j<desig;j++){
						if($scope.desigarray[j].id == temp){
							for(var x=j;x<desig-1;x++){
								$scope.designationarray1.insert(x,{id:$scope.desigarray[x].id,name:$scope.desigarray[x].name,level:$scope.desigarray[x].level});
							}
						}
					}	
				}
			}	
		}
			
	
	
	$scope.designationlevel.remove($index);
	
	if($scope.designationlevel.length ==0){
		$scope.designationlevel.insert(0,{desiglevel:""});
	}
	if($scope.designationlevel[0].desiglevel ==""){
		$scope.onchangedesig();
	}
	
   }


Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};	
Array.prototype.remove = function (index) {
	this.splice(index,1);
};


$scope.onchangedesig =function()
{
	$scope.designationlevel=[{desiglevel:""}];	
	$scope.hastrue=true;
	var xsrf = $.param({designationid: $scope.desig});
	$http({
        url: path+'setup/getseniordesig',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
				$scope.desigarray=[{id:"",name:""}];
		        $scope.designationarray1=data.data;
				for(var j=0;j<$scope.designationarray1.length;j++){
					$scope.desigarray.insert(j,{id:Number($scope.designationarray1[j].id),name:$scope.designationarray1[j].name,level:$scope.designationarray1[j].level});
				}				
		         
			
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	
	
}

$scope.onupdate= function($val)
{

$scope.hastrue=true;

	var jsonData1=angular.toJson($scope.competencyanalysisarray);
	var jsonData2=angular.toJson($scope.designationlevel);
	
	var xsrf = $.param({competencyanalysisid:$scope.competencyanalysisid, desig:$scope.desig, period:$scope.period,competencyanalysis:jsonData1,desiglevel:jsonData2});
	  $http({
			url: path+'performanceold/updatecompetencyanalysis',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.competencyanalysisid=0;
					$scope.designationlevel=[{desiglevel:""}];
					$scope.competencyanalysisarray=[{id:0, ctype:"",comp:"", level:"",desc: ""}];				
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/competencyanalysis", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	
}

$scope.oncreate= function($val)
{

$scope.hastrue=true;
var weightage =0;

	var jsonData1=angular.toJson($scope.competencyanalysisarray);
	var jsonData2=angular.toJson($scope.designationlevel);
	var xsrf = $.param({ desig:$scope.desig, period:$scope.period,competencyanalysis:jsonData1,desiglevel:jsonData2});
	  $http({
			url: path+'performanceold/createcompetencyanalysis',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.competencyanalysisid=0;	
					$scope.designationlevel=[{desiglevel:""}];					
					$scope.competencyanalysisarray=[{id:0, ctype:"",comp:"", level:"",desc: ""}];	
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/competencyanalysis", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
		
}

$scope.onfetchcompetencyanalysis=function($val)
{ 

$scope.hastrue=true;
var xsrf = $.param({competencyanalysisid: $val});
	$http({
        url: path+'performanceold/getacompetencyanalysis',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		        $scope.desig=data.data[0]['desig']; 
			    $scope.period=data.data[0]['period'];
				$scope.onchangedesig();
				$timeout(function(){
					
					if(data.data[0]['desiglevel'].length>0){
					var temp=data.data[0]['desiglevel'];
						for(var i=0; i<temp.length; i++)
						{
							for(var j=0;j<$scope.designationarray1.length;j++){
							//console.log(data.data[0]['desiglevel'][i])
									if($scope.designationarray1[j].id == temp[i]){
										$scope.designationlevel.insert(i,{desiglevel:Number($scope.designationarray1[j].id),dname:$scope.designationarray1[j].name});
										$scope.designationarray1.remove(j);
									}
								}
						}	
						$scope.designationarray1=[];
						$scope.designationlevel.remove(temp.length);
					}
					
				},2000);
		        $scope.competencyanalysisarray=data.data[0]['competencyanalysis'];
				for(var i=0;i<$scope.competencyanalysisarray.length;i++){
						$scope.onchangecombo($scope.competencyanalysisarray[i].ctype,1,i);
						$scope.onchangecombo($scope.competencyanalysisarray[i].comp,2,i);
						$scope.onchangecombo($scope.competencyanalysisarray[i].level,3,i);
					}
			    if($scope.competencyanalysisarray.length == 0){
					$scope.competencyanalysisarray.insert(0,{id:0, ctype:"",comp:"", level:"",desc: ""});
				}
				
				}
			
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});


////////////////////////SKILL GAP ASSESSMENT CONTROLLER//////////////

app.controller('skillgapassessmentCtrl', function($scope, $http, $timeout) {
$scope.policy=[];
$scope.employeeid=0;
$scope.assessmentid=0;
$scope.empname="";
$scope.assessmenttype="";
$scope.assessmenttypeid=0;
$scope.designation="";
$scope.division="";
$scope.department="";
$scope.fromdate="";
$scope.todate="";
$scope.totalscorearr=[];		
$scope.achievements="";
$scope.issues="";
$scope.slider=0;
$scope.totalscore=0;

$scope.onchangelevel=function($val,$index){
	var gap=0;
	//console.log($val + $index)
	for(var i=0;i<$scope.policy.length;i++){
	var temp=$scope.policy[i].competencylevel1;
	
		if(i == $index){
			for(var j=0;j<temp.length;j++){
				if($val==temp[j].level)
				{
					$scope.policy[i].indicator1=temp[j].indicator;	
				}
			}
			gap=($scope.policy[i].level)-($val);
			if(gap<0){
				gap=0;
			}
			$scope.policy[i].gap=gap;
			//$(".rating"+i).text(gap);
		}
	}
	
	


}
	
	$scope.fetchobjective =function($val)
	{
		
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'performanceold/getskillgapassessment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				
				//$scope.assessmentid=data.data1[0]['id'];
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				$scope.editpermission=data.data1[0]['editpermission'];
				/*$scope.totalscorearr=data.data2;
				if(data.data1[0]['desiglevel'] != "" ){
					$scope.desiglevel=data.data1[0]['desiglevel'].split(',');
					for(var i=0;i<$scope.desiglevel.length;i++){
						if($scope.loginempdesig == $scope.desiglevel[i]){
							
							if($scope.totalscorearr.length == i){
							//console.log($scope.totalscorearr.length);
								$scope.slider=1;
							}
						}
					}
				}*/
				
						
				
			}
			else{
				
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
				
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	
	$scope.fetchresult =function($val)
	{
		
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'performanceold/getskillgapresult',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				
				//$scope.assessmentid=data.data1[0]['id'];
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				/*$scope.totalscorearr=data.data2;
				if(data.data1[0]['desiglevel'] != "" ){
					$scope.desiglevel=data.data1[0]['desiglevel'].split(',');
					for(var i=0;i<$scope.desiglevel.length;i++){
						if($scope.loginempdesig == $scope.desiglevel[i]){
							
							if($scope.totalscorearr.length == i){
							//console.log($scope.totalscorearr.length);
								$scope.slider=1;
							}
						}
					}
				}*/
				
						
				
			}
			else{
				
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
				
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var jsonData=angular.toJson($scope.policy);
var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid});
  $http({
        url: path+'performanceold/createskillgapassessment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/skillgapassessment", "_self");}, timeo);
				}		
				$scope.policy=[];
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};

});

/////////////////////////// Performance Comparision Controller Starts From Here  ///////////////////////////////////

app.controller('comparisionCtrl', function($scope, $http, $timeout) {

$scope.searchon=0;
$scope.hastrue=false;
$scope.designations=[];
$scope.employees=[];


onfetch();
function onfetch()
{

$scope.hastrue=true;
  $http({
        url: path+'performanceold/getemployeedesignationdata',
        method: "POST",
		//data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				$scope.designations=[];
				$scope.designations=data.data;
			}		

			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.fetchemployee = function($val)
{
	$scope.hastrue=true;
	$scope.desig=$val;
	var xsrf = $.param({designationid:$val});
  $http({
        url: path+'performanceold/getemployeedata',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				$scope.employees=[];
				$scope.employees=data.data;
			}else{
				errorMessage("No employee found");
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onload= function($val)
{

$scope.hastrue=false;
var xsrf = $.param({employeeid:$scope.employeeid, dtfrom:$scope.fromdatepicker, dtto:$scope.datepicker});
  $http({
        url: path+'performanceold/getcomparisiondata',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				$scope.searchon=$val;
				$timeout(function(){
				// BAR CHART
        				var bar = new Morris.Bar({
					  element: 'bar-chart',
					  resize: true, stacked:true,
					  xLabels: 'name', postUnits:'%',
					  xLabelAngle: 40, ymax:100,
					  data: data.data,
					  //barColors: data.data['competencylevel']['quadcolor'],
					  xkey: 'name',
					  ykeys: ['total'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Score'],
					  gridTextSize: 10,
					  hideHover: 'auto'
					});
				}, 100);	
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});
/////////////Performance Indicator Ctrl ///////////
app.controller('IndicatorCtrl', function($scope, $http, $timeout) {
	$scope.indicateid=0;
	$scope.attributes="";
	$scope.marks="";

	$scope.onadd = function($id) {
		$scope.indicateid=0;
		$scope.attributes="";
		$scope.marks="";
	}
	$scope.onfecthindicator = function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({indicateid: $id});
		$http({
			url: path+'performanceold/getindicator',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			
			if(data.status){
				$scope.attributes=data.data[0]['attributes'];
				
				$scope.marks=parseInt(data.data[0]['marks']);
				$scope.indicateid=data.data[0]['id'];
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	$scope.getId = function($id) {
		$scope.indicateid=$id;
	}
	$scope.ondelete =function()
	{
		$scope.hastrue=true;
		$http({
			url: path+'performanceold/deleteindicator/'+$scope.indicateid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.indicateid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
	$scope.oncreate= function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({attributes:$scope.attributes,marks:$scope.marks});
		$http({
			url: path+'performanceold/createindicator',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/indicatorattribute", "_self");}, timeo);
				}		
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate= function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({attributes:$scope.attributes,marks:$scope.marks,indicateid:$scope.indicateid});
		$http({
			url: path+'performanceold/updateindicator',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/indicatorattribute", "_self");}, timeo);
				}		
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});
/////////////Performance Assign Indicator Ctrl ///////////
app.controller('assignindicatorCtrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.IndicatorList=[];
	$scope.marks="";
	$scope.remark="";
	$scope.empList=[];
	$scope.totalmarks=0;
	

	$scope.onfetchemployee = function() {
		$scope.hastrue=true;
		$http({
			url: path+'employee/getemployeehierarchydata',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//console.log(data.data);
			if(data.status){
				$scope.empList=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	$scope.getdesignation = function($id) {
		
		//alert($id);
		for(var i=0; i<$scope.empList.length; i++){
			if($scope.empList[i]['id']==$id)
			{
				$scope.desig=$scope.empList[i]['empdesignation'];
			}
		}
	}
	$scope.onfetchindicator = function() {
		$scope.hastrue=true;
		$http({
			url: path+'performanceold/getAllindicator',
			method: "POST",
			//data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//console.log(data.data);
			if(data.status){
				$scope.IndicatorList=data.data;
				$scope.totalmarks=data.totalmarks;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	$scope.checkinstamt = function() {
		var total=0;
		for(var i=0;i<$scope.IndicatorList.length;i++){
			if($scope.IndicatorList[i]['obtainmarks'] == undefined){
				$scope.IndicatorList[i]['obtainmarks']=0;
			}
			total =Number(total) + Number($scope.IndicatorList[i]['obtainmarks']);
		}
		$scope.totalamt=Number(total);
	}
		$scope.onfecthassessindicator = function($id) {
		$scope.assignid=$id;
		$scope.hastrue=true;
		$http({
			url: path+'performanceold/getAllassessdata/'+$scope.assignid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//console.log(data.data);
			if(data.status){
				$timeout(function(){
				$scope.emp_id=parseInt(data.data[0]['emp_id']);
				//alert($scope.emp_id);
				$scope.getdesignation($scope.emp_id);
				$scope.month=data.data[0]['month'];
				var cdate=new Date($scope.month);
				$( "#month" ).datepicker('setDate', cdate);
				$scope.assignid=data.data[0]['id'];
				$scope.totalamt=data.data[0]['obtain_marks'];
				$scope.IndicatorList=data.assigndata;
				//console.log(data.assigndata);
				}, 150);
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	$scope.getId = function($id) {
		$scope.assignid=$id;
	}
	$scope.ondelete =function()
	{
		$scope.hastrue=true;
		$http({
			url: path+'performanceold/deleteAssignindicator/'+$scope.assignid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.indicateid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
	$scope.oncreate= function($val)
	{
		var dateTime=$( "#month" ).datepicker( 'getDate' );

		var strDateTime =  dateTime.getFullYear() + "-" + (dateTime.getMonth()+1) + "-" + dateTime.getDate();
		var jsonData1=angular.toJson($scope.IndicatorList);
		
		$scope.hastrue=true;
		 var xsrf = $.param({emp_id:$scope.emp_id, month:strDateTime, totalmarks:$scope.totalmarks, totalamt:$scope.totalamt,remark:$scope.remark,Indicator:jsonData1});
		$http({
			url: path+'performanceold/createAssignindicator',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/assessindicator", "_self");}, timeo);
				}		
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		}); 
	}
	$scope.onupdate= function($val)
	{
		$scope.hastrue=true;
		var jsonData1=angular.toJson($scope.IndicatorList);
		$scope.hastrue=true;
		 var xsrf = $.param({totalamt:$scope.totalamt,remark:$scope.remark,Indicator:jsonData1, assignid:$scope.assignid});
		$http({
			url: path+'performanceold/updateAssignindicator',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/assessindicator", "_self");}, timeo);
				}		
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});
/////////////////////////// objective Controller Starts From Here  ///////////////////////////////////

app.controller('skillobjectiveCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.desig="";
$scope.period="";
$scope.objectiveid=0;
$scope.variablepaysts=0;
$scope.designationarray=[];
$scope.quadrantarray=[];
$scope.selectedarr=[];
$scope.availablearr=[];
$scope.traineecriteria=0;
onfetch('setup/getSkillGapDesignation',1);
onfetch('performanceold/getfunctionalQuadrant/',2);
onfetch('performance/getallFuncKpi',3);
onfetch('performanceold/getAllDesiredlevels',4);
$scope.getId = function($id) {
	$scope.objectiveid=$id;
}

$scope.toggleSelection = function($x) {
	for (var i=0; i<$scope.availablearr.length; i++) {
			if ($scope.availablearr[i].objective==$x){
				if($scope.availablearr[i].vsts){		
					$scope.availablearr[i].vsts=false;
				  }else{
					$scope.availablearr[i].vsts=true;
				  } 
				  break;
				}
		  }
	  $scope.leftdisable=true;
	  var len = $scope.availablearr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.availablearr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
	  
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	for (var i=0; i<$scope.availablearr.length; i++) {
			if ($scope.availablearr[i].vsts){ 
				$scope.availablearr[i].vsts=false;
				$scope.selectedarr.insert($scope.selectedarr.length,$scope.availablearr[i]);
				$scope.availablearr[i].vsts=true;
				}
		  }
	for ( var i=$scope.availablearr.length-1; i>=0; i--) {
			if ($scope.availablearr[i].vsts){ 
				$scope.availablearr.remove(i);
			}
	}
	for ( var i=0; i<$scope.selectedarr.length; i++) {
			$scope.selectedarr[i].vsts=false;
		  }
		  
		 /*  $scope.totalcolarr=[];
		    for(var i=0;i<$scope.selectedarr.length;i++){
			if($scope.selectedarr[i].type=='int' || $scope.selectedarr[i].type=='flo' || $scope.selectedarr[i].type=='dou' || $scope.selectedarr[i].label=='Time spent' || $scope.selectedarr[i].type=='tim'){
				if($scope.selectedarr[i].tablename=='')
				$scope.totalcolarr.push($scope.selectedarr[i]);
			}
		} */
		  $scope.groupcolumnsarr=[];
		for(var i=0;i<$scope.selectedarr.length;i++){
			$scope.groupcolumnsarr.push($scope.selectedarr[i]);
		}
	
	  
   };
$scope.toggleSelection1 = function($x) {
	for (var i=0; i<$scope.selectedarr.length; i++) {
			if ($scope.selectedarr[i].objective==$x){
				if($scope.selectedarr[i].vsts){		
					$scope.selectedarr[i].vsts=false;
				  }else{
					$scope.selectedarr[i].vsts=true;
				  }
				  break;
				}
		  }
	  
	  $scope.rightdisable=true;
	  var len = $scope.selectedarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
	  
	  $scope.leftdisable=true;
	$scope.rightdisable=true;
	for ( var i=0; i<$scope.selectedarr.length; i++) {
			if ($scope.selectedarr[i].vsts){ 
				$scope.selectedarr[i].vsts=false;
				$scope.availablearr.insert($scope.availablearr.length,$scope.selectedarr[i]);
				$scope.selectedarr[i].vsts=true;
				}
		  }
	for ( var i=$scope.selectedarr.length-1; i>=0; i--) {
			if ($scope.selectedarr[i].vsts){ 
				$scope.selectedarr.remove(i);
			}
	}
	for ( var i=0; i<$scope.availablearr.length; i++) {
			$scope.availablearr[i].vsts=false;
		  }
		 
		/* $scope.totalcolarr=[];
		for(var i=0;i<$scope.selectedarr.length;i++){
			if($scope.selectedarr[i].type=='int' || $scope.selectedarr[i].type=='flo' || $scope.selectedarr[i].type=='dou' || $scope.selectedarr[i].label=='Time spent' || $scope.selectedarr[i].type=='tim'){
				if($scope.selectedarr[i].tablename=='')
				$scope.totalcolarr.push($scope.selectedarr[i]);
			}
		} */
		$scope.groupcolumnsarr=[];
		for(var i=0;i<$scope.selectedarr.length;i++){
			/*if($scope.totalcolarr.length>0){
				for(var j=0;j<$scope.totalcolarr.length;j++){
					if($scope.selectedcolumnsarr[i].name != $scope.totalcolarr[j].name)
						$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
					}
				}
			else{
				$scope.groupcolumnsarr.push($scope.selectedcolumnsarr[i]);
			}*/
			
			$scope.groupcolumnsarr.push($scope.selectedarr[i]);
		}	
	  
   };  
	
	$scope.ondelete =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deleteSkillObjective/'+$scope.objectiveid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.objectiveid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.designationarray=[];
					$scope.designationarray=data.data;
				
				}
				else if($id==2){
					$scope.quadrantarr=[];
					$scope.quadrantarr=data.data;
				
				}
				else if($id==3){
					$scope.kpiarr=[];
					$scope.kpiarr=data.data;
					$scope.availablearr=data.data;
				
				}
				else if($id==4){
					$scope.dlevelarr=[];
					$scope.dlevelarr=data.data;
				
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}	

$scope.objectivearray=[{id:0, quadrant:0,objective:"", desc:"", weightage:""}];
$scope.addquadrant = function($i){
	console.log($scope.selectedarr);
	var len = $scope.objectivearray.length-1;
	if($scope.objectivearray[len]['quadrant']==0 || $scope.objectivearray[len]['objective']=="" || $scope.objectivearray[len]['weightage']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.objectivearray.insert($i,{id:0, quadrant:0,objective:"",desc:"", weightage:""});
	}
	
}
$scope.removequadrant = function($i){
	
	$scope.objectivearray.remove($i);	
	if($scope.objectivearray.length == 0){
		$scope.objectivearray.insert(0,{id:0, quadrant:0,objective:"",desc:"", weightage:""});
	}
}
$scope.onaddlevel = function($id,$index)
   {
		//console.log($index)
		var temp ="";
		for(var i=0;i<$scope.designationarray1.length;i++){
			if($scope.designationarray1[i].id == $id){
				
				temp=$scope.designationarray1[i].name;
				$scope.designationlevel[$index].dname=temp;
				$scope.designationlevel[$index].dnamecheck=false;
				$scope.designationlevel[$index].desiglevel=Number($scope.designationarray1[i].id);
				//console.log($scope.designationlevel[$index]['desiglevel'])
				var level=$scope.designationarray1[i]['level'];
				var desig=$scope.designationarray1.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray1.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray1[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray1.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		
   }
$scope.designationlevel=[{desiglevel:""}];
$scope.addlevel = function($id,$index)
   {
		//console.log($index)
		var temp ="";
		for(var i=0;i<$scope.designationarray1.length;i++){
			if($scope.designationarray1[i].id == $id){
				
				temp=$scope.designationarray1[i].name;
				$scope.designationlevel[$index].dname=temp;
				$scope.designationlevel[$index].dnamecheck=false;
				$scope.designationlevel[$index].desiglevel=Number($scope.designationarray1[i].id);
				//console.log($scope.designationlevel[$index]['desiglevel'])
				var level=$scope.designationarray1[i]['level'];
				var desig=$scope.designationarray1.length;
				for(var x=0;x<desig;x++){
					for(var j=0;j<$scope.designationarray1.length;j++){
						if(parseInt(level) >= parseInt($scope.designationarray1[j]['level']))
						{
							//console.log($scope.designationarray[j]['level'])
							$scope.designationarray1.remove(j);
							break;
						}
					
					}
				}
				break;
			}
		}
		//console.log($scope.designationlevel)
		if($scope.designationarray1.length>=1){
			$scope.designationlevel.insert($scope.designationlevel.length,{desiglevel:""});	
		}
		
		
   }
   $scope.removelevel = function($id,$index)
   {
	
		$scope.designationarray1=[];
		for(var i=0;i<$scope.desigarray.length;i++){
			if($scope.desigarray[i].id == $id){
				if($scope.designationlevel.length>1){
					var temp=$scope.designationlevel[$index-1].desiglevel;
					var level=$scope.desigarray[i]['level'];
					var desig=$scope.desigarray.length;
					for(var j=0;j<desig;j++){
						if($scope.desigarray[j].id == temp){
							for(var x=j;x<desig-1;x++){
								$scope.designationarray1.insert(x,{id:$scope.desigarray[x].id,name:$scope.desigarray[x].name,level:$scope.desigarray[x].level});
							}
						}
					}	
				}
			}	
		}
			
	
	
	$scope.designationlevel.remove($index);
	if($scope.designationlevel.length ==0){
		$scope.designationlevel.insert(0,{desiglevel:""});
	}
	if($scope.designationlevel[0].desiglevel ==""){
		$scope.onchangedesig();
	}
	
   }
$scope.checkmarks=function($val){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	console.log(weightage)
	if($val > weightage){
		//errorMessage("Entered range should not be greater than "+weightage);
	}
}
/* $scope.resultarray=[{id:0, minmarks:0,maxmarks:100,rating:0,result:"",amt:0,tcriteria:false}];
$scope.addresult = function($i){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	var len = $scope.resultarray.length-1;
	
	if($scope.resultarray[len]['maxmarks']=="" || $scope.resultarray[len]['result']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.resultarray.insert($i,{id:0, minmarks:($scope.resultarray[len]['maxmarks']+1),maxmarks:100,rating:($scope.resultarray[len]['rating']+1),result:"",amt:0,tcriteria:false});
	}
	
} */
/* $scope.removevariablepayrange = function($i){
	
	$scope.variablepayarr.remove($i);	
	if($scope.variablepayarr.length == 0){
		$scope.variablepayarr.insert(0,{id:0, minmarks:0,maxmarks:0,amount:""});
	}
}

$scope.variablepayarr=[{id:0, minmarks:0,maxmarks:100,rating:0,result:""}];
$scope.addvariablepayrange = function($i){
	
	var len = $scope.variablepayarr.length-1;
	
	if($scope.variablepayarr[len]['maxmarks']=="" || $scope.variablepayarr[len]['result']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.variablepayarr.insert($i,{id:0, minmarks:($scope.variablepayarr[len]['maxmarks']+1),maxmarks:0,amount:""});
		
	}
	
}
$scope.removeresult = function($i){
	var weightage=0;
	for(var i=0;i<$scope.objectivearray.length;i++){
		weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
	}
	$scope.resultarray.remove($i);	
	if($scope.resultarray.length == 0){
		$scope.resultarray.insert(0,{id:0, minmarks:0,maxmarks:weightage,rating:0,result:"",amt:0,tcriteria:false});
	}
} */
Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};	
Array.prototype.remove = function (index) {
	this.splice(index,1);
};

$scope.objectdesc="";
$scope.onchangedesig =function()
{
//onfetch('performanceold/getfunctionalQuadrant/'+$scope.desig,2);
	$scope.designationlevel=[{desiglevel:""}];	
	var xsrf = $.param({designationid: $scope.desig});
	$http({
        url: path+'performanceold/getonlyseniordesig',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       $scope.desigarray=[{id:"",name:""}];
		        $scope.designationarray1=data.data; 
		        $scope.objectdesc=data.data1 ; 
			    for(var j=0;j<$scope.designationarray1.length;j++){
					$scope.desigarray.insert(j,{id:Number($scope.designationarray1[j].id),name:$scope.designationarray1[j].name,level:$scope.designationarray1[j].level});
				}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.getobjectdesc = function(){
	$timeout(function(){
	$scope.object=$scope.objectdesc;
	console.log($scope.object);
	},500);
}
/* $scope.onupdaterating = function($i,$str){
	$scope.resultarray[$i]['rating']=$str;
}
 */
/* $scope.gettraineecriteria = function($val){
	$scope.traineecriteria=$val;
} */

$scope.onupdate= function($val)
{
if($scope.variablepaysts)
	$scope.variablepaysts=1;
$scope.hastrue=true;
/* var weightage =0;
for(var i=0;i<$scope.objectivearray.length;i++){
	weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
} */
/* if(weightage != 100){
	errorMessage('Weightage should be 100%');
	$scope.hastrue=false;
}
else{ */
	//var jsonData1=angular.toJson($scope.objectivearray);
	var jsonData1=angular.toJson($scope.selectedarr);
	/* var jsonData2=angular.toJson($scope.resultarray); */
	console.log(jsonData1)
	var jsonData3=angular.toJson($scope.designationlevel);
	var jsonData4=angular.toJson($scope.variablepayarr);
	var xsrf = $.param({objectiveid:$scope.objectiveid, desig:$scope.desig, jobdesc:$scope.object, period:$scope.period,objective:jsonData1,desiglevel:jsonData3,overachieve:jsonData4,rate:$scope.rate, threshholdscore:$scope.threshholdscore, achieveingamt:$scope.achieveingamt, variablepaysts:$scope.variablepaysts});
	  $http({
			url: path+'performanceold/updateSkillObjective',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.objectiveid=0;
					$scope.objectivearray=[{id:0, quadrant:0,objective:"",desc:"", weightage:""}];				
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/skillObjective", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	/* } */	
}
$scope.oncreate= function($val)
{
if($scope.variablepaysts)
	$scope.variablepaysts=1;
$scope.hastrue=true;
/* var weightage =0;
for(var i=0;i<$scope.objectivearray.length;i++){
	weightage=Number(weightage) + Number($scope.objectivearray[i]['weightage']);
} */
/* if(weightage != 100){
	errorMessage('Total Weightage should be 100%');
	$scope.hastrue=false;
}
else{ */
	var jsonData1=angular.toJson($scope.selectedarr);
	//var jsonData1=angular.toJson($scope.objectivearray);
	//var jsonData2=angular.toJson($scope.resultarray);
	var jsonData3=angular.toJson($scope.designationlevel);
	var jsonData4=angular.toJson($scope.variablepayarr);
	var xsrf = $.param({ desig:$scope.desig, period:$scope.period,objective:jsonData1,desiglevel:jsonData3,rate:$scope.rate,overachieve:jsonData4,threshholdscore:$scope.threshholdscore, achieveingamt:$scope.achieveingamt, variablepaysts:$scope.variablepaysts,jobdesc:$scope.object});
	  $http({
			url: path+'performanceold/createSkillObjective',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status)
				{
					successMessage(data.successMsg);
					$scope.desig="";
					$scope.period="";
					$scope.objectiveid=0;				
					$scope.objectivearray=[{id:0, quadrant:0,objective:"", weightage:""}];	
					if($val==1){
						$timeout(function(){window.open(path+"performanceold/skillObjective", "_self");}, timeo);
					}	
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	/* } */	
}

$scope.onfetchskillobjective=function($val)
{ 
$scope.hastrue=true;
var xsrf = $.param({objectiveid: $val});
	$http({
        url: path+'performanceold/getaSkillObjective',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		        $scope.desig=data.data[0]['desig']; 
		        $scope.designame=data.data[0]['designame']; 
		        $scope.object=data.data[0]['jobdesc']; 
		        //$scope.traineecriteria=data.data[0]['traineecriteria']; 
			    $scope.period=data.data[0]['period'];
			    $scope.threshholdscore=data.data[0]['threshholdscore'];
			    $scope.achieveingamt=data.data[0]['achievingamt'];
			    $scope.variablepaysts=data.data[0]['variablepaysts'];
				if($scope.variablepaysts==1)
					$scope.variablepaysts=true;
				$scope.onchangedesig();
				$timeout(function(){
					if(data.data[0]['desiglevel'].length>0){
					var temp=data.data[0]['desiglevel'];
					var tempcheck=data.data[0]['desiglevelcheck'];
						for(var i=0; i<temp.length; i++)
						{
							for(var j=0;j<$scope.designationarray1.length;j++){
							//console.log(data.data[0]['desiglevel'][i])
									if($scope.designationarray1[j].id == temp[i]){
										if(tempcheck[i]=="1"){
											tempcheck[i]=true;}
										else{
											tempcheck[i]=false;}
										$scope.designationlevel.insert(i,{desiglevel:Number($scope.designationarray1[j].id),dname:$scope.designationarray1[j].name,dnamecheck:tempcheck[i]});
										$scope.designationarray1.remove(j);
									}
								}
						}	
						$scope.designationarray1=[];
						$scope.designationlevel.remove(temp.length);
					}
				},2000);
		        $scope.objectivearray=data.data[0]['objective'];
				var temparr= data.data[0]['objective'];
				for ( var x=0; x<temparr.length; x++){
					for ( var i=0; i<$scope.availablearr.length; i++){
						if ($scope.availablearr[i].objective == temparr[x].objective){ 
							$scope.selectedarr.insert($scope.selectedarr.length,temparr[x]);
							//$scope.selectedcolumnsarr.sort();
							$scope.availablearr.remove(i);
						}
					}
				}
				console.log($scope.selectedarr);
			    if($scope.objectivearray.length == 0){
					$scope.objectivearray.insert(0,{id:0, quadrant:0,objective:"", weightage:""});
				}
				/* $scope.resultarray=data.data[0]['result'];
			    if($scope.resultarray.length == 0){
					$scope.resultarray.insert(0,{id:0, minmarks:0,maxmarks:100,result:"",amt:0,tcriteria:false});
				} */
				/* $scope.variablepayarr=data.data[0]['overachieve'];
			    if($scope.variablepayarr.length == 0){
					$scope.variablepayarr.insert(0,{id:0, minmarks:0,maxmarks:100,amount:""});
				} */
				
			}
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.getobjdesc=function($val,$id)
{
 for(var i=0;i<$scope.kpiarr.length;i++){
	 if($scope.kpiarr[i].id==$id){
		 $scope.objectivearray[$val].desc=$scope.kpiarr[i].desc;
	 }
 }	
}
});
///////////////////////////competency type controller starts from here //////////////////////

app.controller('desiredlevelCtrl', function($scope, $http, $timeout) {
$scope.hastrue=false;
$scope.ctype="";
$scope.competencyid=0;
$scope.name="";
$scope.competencylevelarray=[];
/* onfetch("performanceold/getallcompetencytype",1);


$scope.getId = function($id) {
	$scope.competencyid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'performanceold/deletecompetency/'+$scope.competencyid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.competencyid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.comptypearray=[];
					$scope.comptypearray=data.data;
					
				}
				
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}	 */
$scope.competencylevelarray=[{id:0, level:"",desc:""},{id:0, level:"",desc:""},{id:0, level:"",desc:""},{id:0, level:"",desc:""}];

$scope.addlevel = function($i){

	var len = $scope.competencylevelarray.length-1;
	if($scope.competencylevelarray[len]['level']=="" ){
		errorMessage("Please fill all fields");
	}else{
		$scope.competencylevelarray.insert($i,{ id:0, level:"",desc:""});
	}
	
}
$scope.removelevel = function($i){
	
	$scope.competencylevelarray.remove($i);	
	if($scope.competencylevelarray.length == 0){
		$scope.competencylevelarray.insert(0,{ id:0, level:"",desc:""});
	}
}
	Array.prototype.insert = function (index, item) {
		this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
		this.splice(index,1);
	};
	
$scope.onupdate= function($val)
{
$scope.hastrue=true;
var jsonData=angular.toJson($scope.competencylevelarray);
var xsrf = $.param({competencylevel:jsonData});
  $http({
        url: path+'performanceold/updateDesiredLevel',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				$scope.competencylevelarray=[{id:0, level:"",desc:""}];				
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/desiredlevel", "_self");}, timeo);
				}	
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate= function($val)
{

$scope.hastrue=true;
var jsonData=angular.toJson($scope.competencylevelarray);
var xsrf = $.param({ name:$scope.name,ctype:$scope.ctype,competencylevel:jsonData});
  $http({
        url: path+'performanceold/createcompetency',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performanceold/competency", "_self");}, timeo);
				}	
				$scope.competencyid=0;
				$scope.name="";
				$scope.competencylevelarray=[{id:0, level:"",desc:""}];	
								

			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdesiredlevel=function()
{ 
$scope.hastrue=true;
//var xsrf = $.param({competencyid: $val});
	$http({
        url: path+'performanceold/getDesiredLevel',
        method: "POST",
		//data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		       if(data.status){
		      // $scope.name=data.data[0]['name']; 
		       //$scope.ctype=data.data[0]['ctype']; 
		       $scope.competencylevelarray=data.data; 
			   console.log(data.data);
			   if($scope.competencylevelarray.length==0){
				$scope.competencylevelarray.insert(0,{id:0, level:"",desc:""})
			   }
			}	
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		$scope.hastrue=false;
}

    
    
});
