/*! UBIPROJECT milestoneapp.js
 * ================
 *
 * @Author  Jaidev Sharma
 * @Email   <jaidev@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIPROJECT requires jQuery");
}

var app = angular.module('milestoneapp', ['ui.bootstrap', 'xeditable', 'ngSanitize']);
app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});

/////////////////////////// Milestone Controller Starts From Here  ///////////////////////////////////

app.controller('milestoneCtrl', function($scope, $http, $timeout) {
$scope.maxSize = 5;
$scope.totalItems = 0;
$scope.currentPage = 1;
$scope.itemPerPage =10;
$scope.users=[];
$scope.projects=[];
$scope.milestones=[];
//$scope.projectid=0;
$scope.username=0;
//$scope.enddate=''
$scope.milestoneid='';
$scope.milestone_name='';
$scope.startdate='';
$scope.enddate='';
$scope.description='';
$scope.empid="";
$scope.pro_enddate='';
$scope.taskname='';
$scope.projectid=0;
$scope.proid="";
//$scope.projectid='All';
//$scope.taskids=[];
$scope.onClickFilter= function()
{


	onLoadGetMilestonesData();
}
	
onLoadGetMilestonesData();

/*	
	$scope.onClickFilter= function()
{
	onLoadGetMilestonesData();
}

$scope.onClickRefresh=function(){
	onLoadGetMilestonesData();
}
*/
function onLoadGetMilestonesData()
{	
$scope.currentPage = 1;
$scope.hastrue=true;
var xsrf = $.param({ userid:$scope.userid, projectid:$scope.projectid});
  $http({
        url: path+'milestone/getallmilestones',
        method: "POST",
        data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.totalItems=data.length;
			getmilestonesdata();
        }).error(function (data, status, headers, config) {
           // alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
}

$scope.getallmilestones=function(){	
	getmilestonesdata();
}

function getmilestonesdata()
{
var limit =$scope.itemPerPage;
var offset=limit*($scope.currentPage-1);
//alert($scope.projectid);
$scope.milestones=[];
$scope.hastrue=true;

var xsrf = $.param({limit:limit, offset:offset, projectid:$scope.projectid});
  $http({
        url: path+'milestone/getallmilestones',
        method: "POST",
        data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {			
			$scope.milestones=data;
			$scope.hastrue=false;
			
        }).error(function (data, status, headers, config) {
           // alert("error");//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
        });
};	

$scope.pageChanged = function() {
    //alert($scope.currentPage);
	getmilestonesdata();
};

	
onfetchallprojects();
function onfetchallprojects()
{
	$http({
		url: path+'milestone/getallproject',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.projects=data.data;
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.onchangeproject= function($pid)
{
	//alert($pid);
	var xsrf = $.param({project_id: $pid});
	$http({
		url: path+'milestone/getallassignedusers',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.users=data.data;
			$scope.pro_enddate=data.penddate;
					//alert(data.penddate);
			//alert($scope.empid);
			if($scope.empid!="")
			{
				$timeout( function(){ 
					$scope.username=$scope.empid;
					
					//$scope.projectid=$scope.proid; 
				}, 500);
				
			} 

			//test();
			
			
	}).error(function (data, status, headers, config) {
			alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}



$scope.onfetch= function($mid)
{
	if($mid!=0)
	{
	//return false;
	var xsrf = $.param({milestone_id: $mid});
	$http({
		url: path+'milestone/getaprojectdetail',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.empid=data.data[0]['emp_id'];			
			//$scope.projectid=data.data[0]['projectid'];
			//$scope.proid=data.data[0]['projectid'];
			$scope.milestone_name=data.data[0]['milestone_name'];
			$scope.startdate=data.data[0]['startdate'];
			$scope.enddate=data.data[0]['enddate'];
			$scope.description=data.data[0]['description'];
			//$scope.taskids=data.data[0]['taskids'];
//alert(data.data[0]['description']);
			$("#startdate").datepicker('setDate', $scope.startdate);
			$("#enddate").datepicker('setDate', $scope.enddate);
			$scope.onchangeproject(data.data[0]['projectid']);
			$scope.projectid=data.data[0]['projectid'];
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
	}
	else
	{
				var d=new Date();
		var mydate = d.getFullYear()+'-'+(d.getMonth()+1)+'-'+d.getDate();
		//alert($tid);
		$scope.startdate=mydate;
		$scope.enddate=mydate;
		
	}
}

$scope.create = function()
{	
	//alert($scope.taskids.length);
	//return false;	
	if($scope.projectid==0 || $scope.projectid=='')
	{
		document.getElementById("messageBody").innerHTML="Please select project.";
		document.getElementById('projectid').style.border='1px solid #d73925';
		$('#alertMessageBox').modal('show');
		return false;
	}
	else
	{
		document.getElementById('projectid').style.border='';
	}
	/*
	if($scope.bugcomment=='')
{
	document.getElementById('bcomment').style.border='1px solid #d73925';
	return false;
}
else
{
	document.getElementById('bcomment').style.border='';
}
*/
	
	if($scope.username==0 || $scope.username=='')
	{
		document.getElementById("messageBody").innerHTML="Please select user.";
		document.getElementById("username").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');
		return false;
	}
	else
	{
		document.getElementById('username').style.border='';
	}
	
	if($scope.milestone_name=="")
	{
		document.getElementById("messageBody").innerHTML="Milestone name can not be left blank.";
		document.getElementById('milestone_name').style.border='1px solid #d73925';
		$('#alertMessageBox').modal('show');
		return false;
	}
	
	else
	{
		document.getElementById('milestone_name').style.border='';
	}
/*
	if($scope.taskids.length==0)
	{
		document.getElementById("messageBody").innerHTML="Please Select Task";
		$('#alertMessageBox').modal('show');
		return false;
	}
	*/

	
	if($scope.startdate=="")
	{
		document.getElementById("messageBody").innerHTML="Start date can not be left blank.";
		document.getElementById("startdate").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');		
		return false;
	}
	
	else
	{
		document.getElementById('startdate').style.border='';
	}
	if($scope.enddate=="")
	{
		document.getElementById("messageBody").innerHTML="Estimated end date can not be left blank.";
		document.getElementById("enddate").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');
		return false;
	}
	
	else
	{
		document.getElementById('enddate').style.border='';
	}

	if(startdate!="" && enddate!="")
	{

		var s_date = new Date($scope.startdate);
		var e_date = new Date($scope.enddate);

		if(s_date > e_date)
		{
			document.getElementById("messageBody").innerHTML="Start date cannot be greater than end date";
			document.getElementById("enddate").style.border='1px solid #dd4b39';	
			$('#alertMessageBox').modal('show');
			return false;
		}
	}
	
	
	//alert($scope.pro_enddate);
	//return false;
	if($scope.pro_enddate!='')
	{
		var milestone_end_date = new Date($scope.enddate);
		var project_end_date = new Date($scope.pro_enddate);
			//alert(milestone_end_date);
			//return false;
		if(milestone_end_date > project_end_date)
			{
				document.getElementById("messageBody").innerHTML="Milestone end date cannot be greater than project end date";
				document.getElementById("enddate").style.border='1px solid #dd4b39';	
				$('#alertMessageBox').modal('show');
				return false;
			}
	}
	
	else
	{
		document.getElementById('enddate').style.border='';
	}
	
$scope.description=document.getElementById('description').value;

	var xsrf = $.param({ milestone_name:$scope.milestone_name, startdate:$scope.startdate, enddate:$scope.enddate, empid:$scope.username, projectid:$scope.projectid, description:$scope.description});
  	$http({
        url: path+'milestone/create',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{				
				window.open(path+'milestone', '_self');
			}			
			
       }).error(function (data, status, headers, config) {
            //$scope.status = status + ' ' + headers;
			
	});
}

$scope.update = function($mid)
{	
	/*alert($mid);
	alert($scope.projectid);
	alert($scope.username);
	alert($scope.milestone_name);
	alert($scope.startdate);
	alert($scope.enddate);
	alert($scope.description);
	return false;*/
	if($scope.projectid==0 || $scope.projectid=='')
	{
		document.getElementById("messageBody").innerHTML="Please select project.";
		document.getElementById('projectid').style.border='1px solid #d73925';
		$('#alertMessageBox').modal('show');
		return false;
	}
	else
	{
		document.getElementById('projectid').style.border='';
	}
	/*
	if($scope.bugcomment=='')
{
	document.getElementById('bcomment').style.border='1px solid #d73925';
	return false;
}
else
{
	document.getElementById('bcomment').style.border='';
}
*/
	
	if($scope.username==0 || $scope.username=='')
	{
		document.getElementById("messageBody").innerHTML="Please select user.";
		document.getElementById("username").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');
		return false;
	}
	else
	{
		document.getElementById('username').style.border='';
	}
	
	if($scope.milestone_name=="")
	{
		document.getElementById("messageBody").innerHTML="Milestone name can not be left blank.";
		document.getElementById('milestone_name').style.border='1px solid #d73925';
		$('#alertMessageBox').modal('show');
		return false;
	}
	
	else
	{
		document.getElementById('milestone_name').style.border='';
	}
/*
	if($scope.taskids.length==0)
	{
		document.getElementById("messageBody").innerHTML="Please Select Task";
		$('#alertMessageBox').modal('show');
		return false;
	}
	*/

	
	if($scope.startdate=="")
	{
		document.getElementById("messageBody").innerHTML="Start date can not be left blank.";
		document.getElementById("startdate").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');		
		return false;
	}
	
	else
	{
		document.getElementById('startdate').style.border='';
	}
	if($scope.enddate=="")
	{
		document.getElementById("messageBody").innerHTML="Estimated end date can not be left blank.";
		document.getElementById("enddate").style.border='1px solid #dd4b39';	
		$('#alertMessageBox').modal('show');
		return false;
	}
	
	else
	{
		document.getElementById('enddate').style.border='';
	}

	if(startdate!="" && enddate!="")
	{

		var s_date = new Date($scope.startdate);
		var e_date = new Date($scope.enddate);

		if(s_date > e_date)
		{
			document.getElementById("messageBody").innerHTML="Start date cannot be greater than end date";
			document.getElementById("enddate").style.border='1px solid #dd4b39';	
			$('#alertMessageBox').modal('show');
			return false;
		}
	}
	
	
	//alert($scope.pro_enddate);
	//return false;
	if($scope.pro_enddate!='')
	{
		var milestone_end_date = new Date($scope.enddate);
		var project_end_date = new Date($scope.pro_enddate);
			//alert(milestone_end_date);
			//return false;
		if(milestone_end_date > project_end_date)
			{
				document.getElementById("messageBody").innerHTML="Milestone end date cannot be greater than project end date";
				document.getElementById("enddate").style.border='1px solid #dd4b39';	
				$('#alertMessageBox').modal('show');
				return false;
			}
	}
	
	else
	{
		document.getElementById('enddate').style.border='';
	}
	
	
$scope.description=document.getElementById('description').value;	
	var xsrf = $.param({ milestone_id:$mid, milestone_name:$scope.milestone_name, startdate:$scope.startdate, enddate:$scope.enddate, empid:$scope.username, projectid:$scope.projectid, description:$scope.description});
  	$http({
        url: path+'milestone/update',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{				
				window.open(path+'milestone', '_self');
			}
			else
			{
				window.open(path+'milestone', '_self');
				//alert(data.errorMsg);
			}
			
       }).error(function (data, status, headers, config) {
            //$scope.status = status + ' ' + headers;
			
	});
}

$scope.delete = function()
{	
	$('#confirm').modal('hide');
	$scope.hastrue=true;
	var xsrf = $.param({ milestoneid:$scope.milestoneid });
  	$http({
        url: path+'milestone/deletemilestone',
        method: "POST",
	data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
       }).success(function (data, status, headers, config) {
			
			if(data.status)
			{
				window.open(path+'milestone', '_self');
			}
			
       }).error(function (data, status, headers, config) {
            //$scope.status = status + ' ' + headers;
			
	});
}



$scope.ondeletemilestone= function($mid)
{	
	$scope.milestoneid=$mid;
	$('#confirm').modal('show');
}
	
	
	
});


/////////////////////////// Milestone Details Controller Starts From Here  ///////////////////////////////////

app.controller('milestoneDetailCtrl', function($scope, $http, $interval) {

$scope.milestones=[];


$scope.milestonebug =[];
$scope.milestonetask =[];

$scope.task = 0;
$scope.bug = 0;
$scope.taskstart=0;
$scope.taskend=0;
$scope.currdate=0;
$scope.tasksts=0;
$scope.jsdata="";
$scope.taskchart=0;
$scope.bugchart=0;
$scope.totalbug=0;
$scope.totaltask=0;
$scope.milestoneid=0;
$scope.milestonestart=0;
$scope.milestoneend=0;
$scope.userid=0;
$scope.milestoneid=0;
$scope.taskarray=[];
$scope.bugarray=[];
$scope.milestonetaskarray=[];
$scope.task=[];
$scope.bug=[];
//onLoadGetDashboardData();
//$scope.milestonests=0;
$scope.alltasks=[];
$scope.allbugs=[];
$scope.tasksarr=[];

$scope.tstatus=0;
$scope.taskstatusarr=[	{id:13,name:'OPEN'},
			{id:15,name:'HOLD'}, 
			{id:16,name:'COMPLETE'}, 
			{id:18,name:'NEW'}, 
			{id:19,name:'WON\'T DO'}, 
			{id:20,name:'REOPEN'},
			{id:21,name:'NOT REPRODUCE'},
			{id:22,name:'DONE'}
		     ];

$scope.onload= function($id){
	$scope.milestoneid=$id;
	//alert($scope.milestoneid);
	onLoadGetMilestoneData();
	onLoadGetProgressMilestoneData();
	onLoadGetAllTaskandBugData();
	}
	
function onLoadGetMilestonesData()
{	
$scope.currentPage = 1;
$scope.hastrue=true;
var xsrf = $.param({ userid:$scope.userid, projectid:$scope.projectid});
  $http({
        url: path+'milestone/getallmilestones',
        method: "POST",
        data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.totalItems=data.length;
			getmilestonesdata();
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
		});
}
function onLoadGetProgressMilestoneData()
{
$scope.hastrue=true;
$scope.milestones = [];
$scope.task = [];
$scope.bug = [];
$scope.users = [];
var xsrf = $.param({ id:$scope.milestoneid});
  $http({
        url: path+'milestone/GetProgressMilestoneData',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.taskarray=data;
			$scope.bugarray=data;
			$scope.milestonetaskarray=data
			$scope.task = data[0].task;
			
			$scope.bug = data[0].bug;
			$scope.milestonebug =data[0].milestonebug;
			//alert($scope.task);
			$scope.milestonetask =data[0].milestonetask;
			//alert($scope.task);
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
           // alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onLoadGetAllTaskandBugData()
{

$scope.hastrue=true;
$scope.alltasks = [];
$scope.allbugs = [];

var xsrf = $.param({ id:$scope.milestoneid});
  $http({
        url: path+'milestone/GetAllTaskandBugData',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
			$scope.alltasks=data.tasks;
			$scope.allbugs=data.bugs;
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			//$scope.hastrue=false;
		});
}

////////////////////////////////////////////////////////////////////////////////////////////////



function onLoadGetMilestoneData()
{
$scope.hastrue=true;
$scope.milestones = [];


  $http({
        url: path+'milestone/getMilestoneDetail/'+$scope.milestoneid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	  //alert(data+" "+data.length);
			$scope.milestones = data.data; // assign  $scope.persons here as promise is resolved here 
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			//$scope.hastrue=false;
		});
}
	

function settingsonload($startdate, $enddate){
	
	$scope.milestonests=$sts;
	if($startdate!="0000-00-00 00:00:00" && $enddate!="0000-00-00 00:00:00"){
		$scope.milestonestart=$startdate;
		$scope.milestoneend=$enddate;
		
	}
}
function onfetchallprojects()
{
	$http({
		url: path+'milestone/getallproject',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.projects=data.data;
			//$scope.users=data.data1;
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.onchangeproject= function($pid)
{
	//alert($pid);
	//return false;
	var xsrf = $.param({project_id: $pid});
	$http({
		url: path+'milestone/getallassignedusers',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.users=data.data;
			//$timeout( function(){ $scope.users=data.data; }, 3000);
			if($scope.empid!="")
			{
				//$timeout( function(){ $scope.user_assign=$scope.empid; }, 500);
				//$scope.user_assign=$scope.empid;
				//alert($scope.user_assign);
			}
			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

$scope.getRefreshCalendar = function()
{
	$scope.hastrue=true;
	//alert($scope.milestoneid);
	//alert($scope.tstatus);
	window.open(path+'milestone/details/'+$scope.milestoneid+'/'+$scope.tstatus, '_self');
	//$scope.onfetchfusionchartdata($scope.milestoneid, $scope.tstatus);
	//$scope.onfetchfusionchartdata;
	//$scope.$apply();
}

///////// function for fusion chart /////////
$scope.onfetchfusionchartdata= function($mid,$sts)
{
		
	var xsrf = $.param({id: $mid, sts: $sts});
  	$http({
		url: path+'milestone/getmilestonecalendar',
        	method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
	  //$scope.tasksarr=  data['tasks'];
		$scope.tstatus=data['sts'];
		$('#calendar').fullCalendar({
		  header: {
		    left: 'prev,next today',
		    center: 'title',
		    right: 'month,agendaWeek,agendaDay'
		  },
		  buttonText: {
		    today: 'today',
		    month: 'month',
		    week: 'week',
		    day: 'day'
		  },
		  //Random default events
		  events: data['tasks'],
		  eventRender: function(event, element) {
            element.attr('title', event.tip);
          }, 
		  editable: false,
		  droppable: false
		});
		$scope.hastrue=false;	
		 //callback(events);
		//$('#calendar').fullCalendar( 'refresh' );
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}


});


/////////////////////////// Topbar Controller Starts From Here  ///////////////////////////////////

app.controller('topbarCtrl', function($scope, $http) {

$scope.tasks=[];
$scope.totaltasks=0;

$scope.bugs=[];
$scope.totalbugs=0;

onfetchallnewtasks();
onfetchallnewbugs();

function onfetchallnewtasks()
{
	$http({
		url: path+'tasks/getallnewtasks',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.tasks=data.data;
			$scope.totaltasks=data.count;
						
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}

function onfetchallnewbugs()
{
	$http({
		url: path+'bug/getallnewbugs',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
			
			$scope.bugs=data.data;
			$scope.totalbugs=data.count;
						
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
}



$scope.onreadtask= function($tid)
{
   
   //alert($tid);
   //return false;
   if($tid!=0)
   {
	
	var xsrf = $.param({task_id: $tid});
	$http({
		url: path+'tasks/updatetaskviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'tasks/details/'+$tid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}

$scope.onreadbug= function($bid)
{
   
   //alert($tid);
   //return false;
   if($bid!=0)
   {
	
	var xsrf = $.param({bug_id: $bid});
	$http({
		url: path+'bug/updatebugviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'bug/details/'+$bid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}

/////////////////////////////On Read Bug Owner Status///////////////////////////////////////////////////
$scope.onreadbugbyowner= function($bid)
{
   
   //alert($tid);
   //return false;
   if($bid!=0)
   {
	
	var xsrf = $.param({bug_id: $bid});
	$http({
		url: path+'bug/updateownerbugviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'bug/details/'+$bid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}
/////////////////////////////On Read Bug Owner Status///////////////////////////////////////////////////

/////////////////////////////On Read Task Owner Status///////////////////////////////////////////////////
$scope.onreadtaskbyowner= function($tid)
{
   
   //alert($tid);
   //return false;
   if($tid!=0)
   {
	
	var xsrf = $.param({task_id: $tid});
	$http({
		url: path+'tasks/updateownertaskviewstatus',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	  }).success(function (data, status, headers, config) {
						
				if(data.status)
				{
					window.open(path+'tasks/details/'+$tid, '_self');
				}			
			
	}).error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
	});
   }
}
/////////////////////////////On Read Task Owner Status///////////////////////////////////////////////////

});
