/*! UBIHRM faq.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('faqapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


app.directive('myPostRepeatDirective', function() {
  return function(scope, element, attrs) {
    if (scope.$last){
      // iteration is complete, do whatever post-processing
      // is necessary
	 
		jQuery.fn.multiselect = function() {
			$(this).each(function() {
				var checkboxes = $(this).find("input:checkbox");
				checkboxes.each(function() {
					var checkbox = $(this);
					// Highlight pre-selected checkboxes
					if (checkbox.prop("checked"))
						checkbox.parent().addClass("multiselect-on");
		 
					// Highlight checkboxes that the user selects
					checkbox.click(function() {
						if (checkbox.prop("checked"))
							checkbox.parent().addClass("multiselect-on");
						else
							checkbox.parent().removeClass("multiselect-on");
					});
				});
			});
		};
		
		$(function() {
			 $(".multiselect").multiselect();
		});
    }
  };
});

app.filter('unique', function() {

  return function (arr, field) {
    var o = {}, i, l = arr.length, r = [];
	
    for(i=0; i<l;i++) {
	if(arr[i]['id']==field)
	
      o[arr[i]['name'] ]= arr[i];
    }
    for(i in o) {
      r.push(o[i]);
    }
    return r;
  };
});
///////////////////////////time off controller starts from here ///////////////////////////////
/*
	app.controller('timeoffCtrl', function($scope, $http, $timeout) {
	$scope.timeoffdate="";
	$scope.fromtime="";
	$scope.totime="";
	$scope.timeoffreason="";


	$scope.oncreatetimeoff = function()
	{	
		
		
		var xsrf = $.param({timeoffdate:$scope.timeoffdate,fromtime:$scope.fromtime,totime:$scope.totime,timeoffreason:$scope.timeoffreason});
		
		$http({
			url: path+'profile/createtimeoff',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
								
					$scope.timeoffdate="";
					$scope.fromtime="";
					$scope.totime="";
					$scope.timeoffreason="";
					$timeout(function(){window.open(path+"profile/leaves", "_self");}, timeo);
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
);

}
*/
/////////////////////////// leave Controller Starts From Here  ///////////////////////////////////

app.controller('leaveCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.leaveid=0;
	$scope.leavetypeid="";
	$scope.leavefrom="";
	$scope.leaveto="";
	$scope.leavetotal=0;
	$scope.leavetotalused=0;
	$scope.leavereason="";
	$scope.resumptiondate="";
	$scope.dayseligible=0;
	$scope.fromdaytype=1;
	$scope.todaytype=1;
	$scope.timeoffrom=1;
	$scope.timeofto=1;
	$scope.empleave=[];
	$scope.empleavedetail=[];
	$scope.employees=[];
	$scope.timeoffdate="";
	$scope.fromtime="";
	$scope.totime="";
	$scope.timeoffreason="";
	$scope.timeoffstatus="";
	$scope.timeoffid="";
	$scope.leaveat="";
	$scope.onfetch=function(){
	onfetch('profile/getDepartmentEmployeeData',1);
	onfetch('profile/getselectedemployeeleave',2);
	///////Fetching all substitute emp means all seniors and juniors of logined person/////
	onfetch('profile/getleavesubstituteemp',5);
	}
	
	$scope.getId = function($id) {
		$scope.leaveid=$id;
	}
	$scope.getTimeoffId = function($id) {
		$scope.timeoffid=$id;
	}
	$scope.onchangetimeoffsts =function()
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'profile/changetimeoffsts/'+$scope.timeoffid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){			
				 successMessage(data.successMsg);
				 $timeout(function(){window.open(path+"profile/time_off", "_self");}, timeo);
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.timeoffid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	$scope.checkutilizedleave=function($val){
		for(var i=0; i<$scope.leavetypearray.length;i++){
			if($scope.leavetypearray[i]['id']==$scope.leavetypeid){
				if($scope.leavetypearray[i]['leftleave']<$scope.dayseligible){
					$("#showleavemsg").modal('show');
				}else{
					$scope.oncreate(2);
				}
			}
		}
		
	}
	$scope.onchangests =function($val)
	{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'profile/changeleavests/'+$scope.leaveid+'/'+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.leaveid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
	
	$scope.oncreate = function($val)
	{	
		if($scope.fromdaytype==1){
			$scope.timeoffrom=0;
		}
		if($scope.todaytype==1){
			$scope.timeofto=0;
		}
		if($scope.leavefrom==$scope.leaveto)
		{
			if($scope.fromdaytype==2)
			{
				if($scope.timeoffrom != $scope.timeofto){
					//$scope.todaytype=2;
					//$scope.timeofto=$scope.timeoffrom;
					errorMessage("You cannot choose diffrent half day for same day");
					return;
				}
				
			}
		}
		$scope.hastrue=true;
		var xsrf = $.param({leavetypeid:$scope.leavetypeid,leavefrom:$scope.leavefrom,leaveto:$scope.leaveto,leavereason:$scope.leavereason,resumptiondate:$scope.resumptiondate,substitute:$scope.emp_subs, emergencycontact:$scope.emergencycontact,dayseligible:$scope.dayseligible,fromdaytype:$scope.fromdaytype,todaytype:$scope.todaytype,timeoffrom:$scope.timeoffrom,timeofto:$scope.timeofto});
		
		$http({
			url: path+'profile/createleave',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
				if($scope.files != ""){
					$scope.leaveid=data.leaveid;
					$scope.uploadFile($val);
					
				}					
					$scope.leavetypeid="";
					$scope.leavefrom="";
					$scope.leaveto="";
					$scope.leavereason="";
					$scope.resumptiondate="";
						
					//if($val==1){
						//window.open(path+"profile/leaves", "_self");
						$timeout(function(){window.open(path+"profile/leaves", "_self");}, timeo);
					//}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	///For time offf
	
	$scope.oncreatetimeoff = function($id)
	{	
		$scope.hastrue=true;
		if($id==0){
		var xsrf = $.param({timeoffdate:$scope.timeoffdate,fromtime:$scope.fromtime,totime:$scope.totime,timeoffreason:$scope.timeoffreason});
		
		$http({
			url: path+'profile/createtimeoff',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					
					successMessage(data.successMsg);
					$scope.timeoffdate="";
					$scope.fromtime="";
					$scope.totime="";
					$scope.timeoffreason="";
					$timeout(function(){window.open(path+"profile/time_off", "_self");}, timeo);
					}
				else{
					
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}else{
	var xsrf = $.param({timeoffdate:$scope.timeoffdate,fromtime:$scope.fromtime,totime:$scope.totime,timeoffreason:$scope.timeoffreason,timeoffid:$id});
		
		$http({
			url: path+'profile/updatedtimeoff',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
				
					successMessage(data.successMsg);
					$scope.timeoffdate="";
					$scope.fromtime="";
					$scope.totime="";
					$scope.timeoffreason="";
					$timeout(function(){window.open(path+"profile/time_off", "_self");}, timeo);
					}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	}
	
	$scope.onupdate = function($val)
	{	
		if($scope.fromdaytype==1){
			$scope.timeoffrom=0;
		}
		if($scope.todaytype==1){
			$scope.timeofto=0;
		}
		if($scope.leavefrom==$scope.leaveto)
		{
			if($scope.fromdaytype==2)
			{
				if($scope.timeoffrom != $scope.timeofto){
					//$scope.todaytype=2;
					//$scope.timeofto=$scope.timeoffrom;
					errorMessage("You cannot choose diffrent half day for same day");
					return;
				}
				
			}
		}
		$scope.hastrue=true;
		var xsrf = $.param({leaveid:$scope.leaveid, leavetypeid:$scope.leavetypeid,leavefrom:$scope.leavefrom,leaveto:$scope.leaveto,leavereason:$scope.leavereason,resumptiondate:$scope.resumptiondate,substitute:$scope.emp_subs, emergencycontact:$scope.emergencycontact,dayseligible:$scope.dayseligible,fromdaytype:$scope.fromdaytype,todaytype:$scope.todaytype,timeoffrom:$scope.timeoffrom,timeofto:$scope.timeofto});
		
		$http({
			url: path+'profile/updatedeleave',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
				if($scope.files != ""){
					
					$scope.uploadFile($val);
					
				}					
					$scope.leavetypeid="";
					$scope.leavefrom="";
					$scope.leaveto="";
					$scope.leavereason="";
					$scope.resumptiondate="";
					$scope.emp_subs="";
					$scope.emergencycontact="";
					
					//if($val==1){
						//window.open(path+"profile/leaves", "_self");
						$timeout(function(){window.open(path+"profile/leaves", "_self");}, timeo);
					//}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					 if($id==1){
						$scope.employees=[];
						$scope.employees=data.data;
					}
					if($id==2){
						$scope.leavetypearray=[];
						$scope.leavetypearray=data.data;
						/*for(var i=0; i<$scope.leaves.length; i++){
							$scope.leavetotal=$scope.leavetotal+parseInt($scope.leaves[i]['days']);
							$scope.leavetotalused=$scope.leavetotalused+parseInt($scope.leaves[i]['usedleave']);
						}*/
					}else if($id==5){
						$scope.substituteemp=[];
						$scope.substituteemp=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});			
	}
	
	$scope.onfetchleavetype= function()
	{
		$scope.hastrue=true;
		
		$http({
			url: path+'profile/getselectedemployeeleave',
			//method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.leavetypearray=[];
					$scope.totaldays=0;
					$scope.totalusedleave=0;
					$scope.totalleftleave=0;
					$scope.leavetypearray=data.data;
					var bar = new Morris.Bar({
					  element: 'leave-chart',
					  resize: true, stacked:false,
					  axes:true,
					  // postUnits:'%',		
					  numLines: 6,					  
					  data: $scope.leavetypearray,
					  barColors: ['#1434DF', '#FC3943', '#18B100'],
					  xkey: 'name', //xLabelAngle: -90,
					  //gridTextColor:'black',
					 // gridTextSize:14, 
					  ykeys: ['days','leftleave','usedleave'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Leave entitled','Balance leave','Leave utilized'],
					  hideHover: 'auto',
					  barGap:0, 
					  
					  
					});
					$scope.startdate=data.fiscaldata[0].startdate;
					$scope.enddate=data.fiscaldata[0].enddate;
					for(var i=0;i<$scope.leavetypearray.length;i++){
						$scope.totaldays=$scope.leavetypearray[i].days;
						$scope.totalusedleave=$scope.leavetypearray[i].usedleave;
						$scope.totalleftleave=$scope.leavetypearray[i].leftleave;
					}
					
					
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchleave =function($id)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({employeeleaveid:$id});
		$http({
			url: path+"profile/getemployeeleave",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					$scope.leavetypeid=data.data[0]['leavetypeid'];
					$scope.leavefrom=data.data[0]['fromdate'];
					$scope.leaveto=data.data[0]['todate'];
					$scope.leavereason=data.data[0]['leavereason'];
					$scope.resumptiondate=data.data[0]['resumptiondate'];
					$scope.emp_subs=data.data[0]['substituteid'];
					$scope.emergencycontact=data.data[0]['emergencycontact'];
					$scope.fromdaytype=data.data[0]['fromdaytype'];
					$scope.todaytype=data.data[0]['todaytype'];
					$scope.timeoffrom=data.data[0]['timeoffrom'];
					$scope.timeofto=data.data[0]['timeofto'];
					$scope.leaveat=data.data[0]['leaveattachment'];
					gettimediff();
				}else{
					if($id>0)
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchtimeoff =function($id)
	{
		$('#timeoffdate').datepicker({
						startDate: '+0d'
					});
		$scope.hastrue=true;
		var xsrf = $.param({timeoffid:$id});
		$http({
			url: path+"profile/getemployeetimeoff",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					$scope.timeoffdate=data.data[0]['timeoffdate'];
					$scope.fromtime=data.data[0]['timefrom'];
					$scope.totime=data.data[0]['timeto'];
					$scope.timeoffreason=data.data[0]['reason'];
					$scope.timeoffstatus=data.data[0]['sts'];
					
				}else{
					
					if($id>0)
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onchangeleavetype = function(){
	var sts=0;
	$('#leavefrom').datepicker("remove");
	$('#leaveto').datepicker("remove");
	$scope.leavests=false;
	//$('#resumption').datepicker("remove");
		for(var i=0;i<$scope.leavetypearray.length;i++)
		{
			if($scope.leavetypearray[i].id==$scope.leavetypeid)
			{
				sts=$scope.leavetypearray[i].sts;
				if(sts==1){
					$scope.leavests=false;
					$('#leavefrom').datepicker({
						startDate: '+0d'
					});
					$('#leaveto').datepicker({
						startDate: '+0d'
					});
					
				}else{
					$scope.leavests=true;
					$('#leavefrom').datepicker({
						startDate: '-7d'
					});
					$('#leaveto').datepicker({
						startDate: '-7d'
					});
				
				}
			}
		}
	
	}
	
	$scope.timediff = function($val){
		
		if($val==1)
		{
			if($scope.leavefrom != ""){
				var fromdate=$( '#leavefrom' ).datepicker( "getDate" );
				$scope.resumptiondate="";
				$scope.leaveto="";
				$('#leaveto').datepicker("remove");
				$('#leaveto').datepicker({
					startDate: fromdate
				});
				
			}
			
		}
		if($val==2)
		{
			
			if($scope.leaveto != ""){
				$scope.resumptiondate="";
				var todate=$( '#leaveto' ).datepicker( "getDate" );
				$('#resumption').datepicker("remove");
				 $('#resumption').datepicker({
					startDate: todate,
					
				});
			}
		}
		
			if($scope.leavefrom==$scope.leaveto)
			{
				if($scope.fromdaytype==2)
				{
					$scope.todaytype=2;
					$scope.timeofto=$scope.timeoffrom;
				}else{
					$scope.todaytype=1;
				}
			}
		
		gettimediff();
		
	}
	function gettimediff(){
	var xsrf = $.param({leavefrom:$scope.leavefrom,leaveto:$scope.leaveto,leavefromtype:$scope.fromdaytype,leavetotype:$scope.todaytype,leavetype:$scope.leavetypeid, leavetimeofto:$scope.timeofto});
	$scope.hastrue=true;
		$http({
			url: path+"profile/getLeaveDaysDiff",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.dayseligible=data.totaldays;
					$scope.empleavedetail=data.data;
					$scope.resumptiondate=data.resumptiondate;
					$scope.onchangeleavetype();
				}else{
					$scope.dayseligible=0;
				}				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
}

	///////////////////////////////////////image upload///////////////////////////////
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.leaveid;
//alert(emp);
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"profile/uploadLeaveAttachment",
            
            headers: { 'Content-Type': undefined },
            
            transformRequest: function (data) {
                var formData = new FormData();
                
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('leave_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
			if(data.status){
				
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/leaves", "_self");}, timeo);
					}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
		}).
        error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
		
});

/////////////////////////// Salary Controller Starts From Here  ///////////////////////////////////

app.controller('salaryCtrl', function($scope, $http) {

	
	$scope.hastrue=false;
	$scope.emptotal="";
	$scope.empmonth="";
	$scope.empdays="";
	$scope.empctc="";
	$scope.totaldeduction=0;
	$scope.netsalary=0;
	$scope.salaryid=0;
	$scope.previous="";
	$scope.nextmonth="";
	$scope.salarydetail=[];
	//onfetchsalarydetails();
	$scope.onfetchsalarydetails = function($val){
		$scope.hastrue=true;

		var xsrf = $.param({monthview:$val});
		$http({
			url: path+'profile/getasalary',
			method: "POST", data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.empmonth=data.data[0]['empmonthname'];
				$scope.empdays=data.data[0]['emppaiddays'];
				$scope.empctc=data.data[0]['empctc'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.emptotal=data.data[0]['emptotal'];
				$scope.netsalary=data.data[0]['emptotal'];
				$scope.totaldeduction=data.data[0]['emptotaldeduction'];
				$scope.salarydetail=data.data[0]['salarydetail'];
				$scope.previous=data.data[0]['previousmonth'];
				$scope.nextmonth=data.data[0]['nextmonth'];
				$scope.salaryid=data.data[0]['salaryid1'];
				
				$scope.netsalary = parseInt($scope.emptotal) - $scope.totaldeduction;
				$scope.hastrue=false;
			}else{
				errorMessage(data.errorMsg);
				$scope.hastrue=false;
			}
			
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	
	
});

/////////////////////////// attendance Controller Starts From Here  ///////////////////////////////////

app.controller('attCtrl', function($scope, $http) {

	
$scope.hastrue=false;
$scope.attendance=[];
$scope.monthview ="";
$scope.holidaycount=0;
$scope.presentcount=0;
$scope.absentcount=0;
$scope.leavecount=0;
$scope.weekoffcount=0;
$scope.totaldays=0;
$scope.summary="";
$scope.onfetchattendence = function()
{	
	onloaddata();
}
function onloaddata()
{
	//return false;
		
	$scope.hastrue=true;
	//var xsrf = $.param({leavetypeid:$scope.leavetypeid, leavefrom:$scope.leavefrom,leaveto:$scope.leaveto, leavereason:$scope.leavereason, resumptiondate:$scope.resumptiondate});
	var xsrf = $.param({monthview:$scope.monthview});
	$http({
		url: path+'profile/getallevents',
		method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				var event1=[];
				//$scope.summary=data.summary;
				if(data.status){
					$scope.attendance=data.data;
					$scope.holidaycount=data.holidaycount;
					$scope.presentcount=data.presentcount;
					$scope.absentcount=data.absentcount;
					$scope.leavecount=data.leavecount;
					$scope.weekoffcount=data.weekoffcount;
					$scope.halfdaycount=data.halfdaycount;
					$scope.totaldays=data.totaldays;
					
					for(var i=0; i<data.data.length; i++)
					{
							
							
						event1.push({
							title:data.data[i]['name'],
							start:data.data[i]['datefrom'],
							end:data.data[i]['dateto'],
							description: 'long description3',
							backgroundColor: data.data[i]['backcolor'], 
							borderColor: data.data[i]['backcolor'] 
						});
					}
					//$('#calendar').fullCalendar( 'removeEvents').fullCalendar('removeEventSources'); 
					if($('#calendar').fullCalendar( 'clientEvents') != "") { 
						//$('#calendar').fullCalendar( 'removeEvents').fullCalendar('removeEventSources'); 
						$('#calendar').fullCalendar( 'removeEvents', function(e){
							return true;
							}); 
					}
					$('#calendar').fullCalendar( 'addEventSource', event1);
					
				}
				//calenderupdate(event1);
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
}

$('body').on('click', 'button.fc-prev-button', function() {
				var b = $('#calendar').fullCalendar('getDate');
				$scope.monthview = b.format('YYYY-MM-DD');								
				onloaddata();
			});
			$('body').on('click', 'button.fc-next-button', function() {
				var b = $('#calendar').fullCalendar('getDate');
				$scope.monthview = b.format('YYYY-MM-DD');
				onloaddata();
			});
			$('body').on('click', 'button.fc-today-button', function() {
				alert("today");
			});	
});

///////////////////profile change password//////////////////////////

	
app.controller('passwordCtrl', function($scope, $http, $timeout) {

$scope.old_pwd="";
$scope.new_pwd="";
$scope.confirm_pwd="";
	
	$scope.changepwd = function($val)
	{	
		
		$scope.hastrue=true;
		var xsrf = $.param({old_pwd:$scope.old_pwd, new_pwd:$scope.new_pwd, confirm_pwd:$scope.confirm_pwd});
		$http({
			url: path+'profile/employeechangepassword',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					
					
					if($val==1){
						//window.open(path+"profile/change_password", "_self");
						$timeout(function(){window.open(path+"profile/change_password", "_self");}, timeo);
					}
					$scope.old_pwd="";
					$scope.new_pwd="";
					$scope.confirm_pwd="";
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	

	
});	
////////////////////dashboard controller//////////////////

app.controller('dashboardCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.showdiv=false;
$scope.attendance=[];
$scope.reportingtoarray=[];	
$scope.notificationarray=[];
$scope.approvalarray=[];
$scope.forthcomingevents=[];
$scope.leavesummary=[];
$scope.totaleave=0;
$scope.usedleave=0;
$scope.totalsickleave=0;
$scope.usedsickleave=0;
//checkfiscal();

$scope.empper=false;
$scope.onLoadDashboard = function()
	{	
	//alert("hello");
		$scope.hastrue=true;
		$http({
			url: path+'profile/getselfservicedashboard',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					//$scope.attendance=data.data['attandance'];
					$scope.reportingtoarray=[];	
					$scope.reportingtoarray=data.data['reportto'];
					
					$scope.colleaguesarray=[];	
					$scope.colleaguesarray=data.data['colleagues'];
					$scope.juniorsarray=[];	
					$scope.juniorsarray=data.data['juniors'];
					$scope.taskarray=[];	
					$scope.taskarray=data.data['tasksheet'];
					$scope.empper=data.availemp;
					if($scope.empper==false){
						$scope.showdiv=true;
					}
					////////////Team Members Treeview/////////////////
					$('#treeview').treeview({
							expandIcon: 'glyphicon glyphicon-chevron-up',
							collapseIcon: 'glyphicon glyphicon-chevron-down',
							emptyIcon: 'glyphicon',
						//	nodeIcon: '',
							//selectedIcon: 'true',
							selected:'true',
							onhoverColor: 'rgb(240, 245, 210)' ,
							selectedBackColor: 'rgb(240, 245, 210)',
							highlightSelected:true,
							showBorder:false,
							enableLinks: true,
							data:$scope.juniorsarray
						});
						$('#treeview').treeview('collapseAll', { silent: true });
					//$scope.date=data.data['tasksheet'][0]['date'];
					/////  BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'attendance-chart',
					  resize: true,
					  xLabels: 'month',
					 // postUnits:'%',ymax:100,
					 // xLabelAngle: -90,
					  data: data.data['attandance'],
					  barColors: [ '#199B19', '#FF5733','#4A7CF3'],
					  xkey: 'month',
					  ykeys: ['totalpresent', 'totalabsent', 'totalleave'],
					  labels: ['Total Present', 'Total Absent', 'Total Leave'],
					  hideHover: 'auto'
					});
					
					///// SKILL GAP CHART /////////
					 var bar = new Morris.Bar({
						element: 'skillgap-chart',
						resize: true,  xLabelAngle: 0,
						stacked:false, axes:false,
						ymax:5,
						numLines: 6,
						onlyIntegers: true,
						//xLabels: 'competency',
						data: data.data['skillgap']['data'],
						xkey: 'competency',
						ykeys: ['desirelevel','assesslevel'],//ykeys: ['a', 'b', 'c'],
						labels: ['Desired Level','Assessed Level'],
						barColors: ['#FF6400','#008700'],
						hideHover: 'auto',
						barGap:0
						
					  });
					  
					  ///// ASSESSMENT CHART /////////
					 var bar = new Morris.Bar({
						element: 'performance-chart',
						resize: true,  xLabelAngle: -90,
						stacked:false, axes:false,
						postUnits:'%',
						ymax:100,
						//xLabels: 'competency',
						data: data.data['empassessment']['data'],
						xkey: 'quadrant',
						ykeys: data.data['empassessment']['ykey'],//ykeys: ['a', 'b', 'c'],
						labels: data.data['empassessment']['labels'],
						//lineWidth: 2,
						//barColors: ['blue','green','red','grey'],
						hideHover: 'auto',
						barGap:0
						
					  });
					  ///// MONTHLY BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'leave-chart',
					  resize: true, stacked:false,
					  
					  // postUnits:'%',		
					  numLines: 6,				  
					  data: data.data['leavesummary']['data'],
					  barColors: ['#1434DF', '#FC3943', '#18B100'],
					  xkey: 'name', //xLabelAngle: -90,
					  ykeys: ['days','balance','used'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Leave entitled','Balance leave','Leave utilized'],
					  hideHover: 'auto',
					  barGap:0
					});
					  
					  //DONUT CHART
					/*var donut = new Morris.Donut({
					  element: 'leave-summary',
					  resize: true,
					  colors: ["#3399FF", "#FF0000", "#009933"],
					  data: data.data['leavesummary'],
					  hideHover: 'auto'
					});*/
					  $scope.notificationarray=[];
					  $scope.notificationarray=data.data['notification'];
					  
					  $scope.approvalarray=[];
					  $scope.approvalarray=data.data['approvals'];
					  
					  $scope.forthcomingevents=[];
					  $scope.forthcomingevents=data.data['forthcomingevents'];
					  
					 
					  
					  
					 /*$timeout(function(){
						$(".knob").knob({        
						  draw: function () {
							// "tron" case
							if (this.$.data('skin') == 'tron') {
							  var a = this.angle(this.cv)  // Angle
									  , sa = this.startAngle          // Previous start angle
									  , sat = this.startAngle         // Start angle
									  , ea                            // Previous end angle
									  , eat = sat + a                 // End angle
									  , r = true;
							  return false;
							}
						  }
						});
					}, 200);*/
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	

function checkfiscal()
	{	
		
		$scope.hastrue=true;
		
		$http({
			url: path+'profile/checkfiscalyearexit',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					$("#salarymonth").modal("show");
				}
				else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}




	function fetchnotify(targetId)
	{	
		
		//$scope.hastrue=true;
		
		$http({
			url: path+'profile/getallnotifications',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					
						/*notification(data.data[i]['title'],data.data[i]['message'], 'warning',data.data[i]['id']);
						$scope.setnotifysts(data.data[i]['id'],0);*/
						var htmlContent="";
						var htmlContent1="";
						var notification=data.data['notification'];
						var approvals=data.data['approvals'];
						$scope.count=notification.length;
						$scope.count+=approvals.length;
						
						 $('#alert-box').slimScroll({
							height: '190px'
						  });
						  $('#approval-box').slimScroll({
							height: '190px'
						  });
							if (notification != "") {
							
								var sp = notification;
								for ( var i = 0; i < sp.length; i++) {
									htmlContent += '<div class="item" ><img src="'+sp[i].image+'" alt="user image" class="online"/><p class="message"><a href="'+path+sp[i].link+'" class="name"><small class="text-muted pull-right"><i class="fa fa-clock-o"></i> '+sp[i].time+'</small><span  class="product-description" title="'+sp[i].title+'"> '+sp[i].title+'</span></a><a ="message"><a href="'+path+sp[i].link+'" class="product-description" title="'+sp[i].message+'" style="color:black"> '+sp[i].message+' </a></p></div></div>';
									
									document.getElementById(targetId).innerHTML = htmlContent;
								}
								
								//setCookie("notification", sp.toString(), 30);
							}
					
							if (approvals != "") {
							
								var sp = approvals;
								for ( var i = 0; i < sp.length; i++) {
									htmlContent1 += '<div class="item" ><img  alt="user image" class="online" style="width:0px;visibility:hidden"/><p class="message" style="margin-left:10px"><a href="'+path+sp[i].link+'" class="name"><small class="text-muted pull-right"><i class="fa fa-clock-o"></i> '+sp[i].time+'</small><span  class="product-description" title="'+sp[i].name+'"> '+sp[i].name+'</span></a<a ="message"><a href="'+path+sp[i].link+'" class="product-description" title="'+sp[i].message+'" style="color:black"> '+sp[i].message+' </a></p></div></div>';
									
									document.getElementById('pagelinks3').innerHTML = htmlContent1;
								}
								
								//setCookie("notification", sp.toString(), 30);
							}
					//$scope.notifyarr=data.data;
				}
				else{
				errorMessage(data.errorMsg);
			}
				//$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	
$scope.setnotifysts=function($id,$sts)
	{	
		
		$scope.hastrue=true;
		
		$http({
			url: path+'profile/setnotificationsts/'+$id+'/'+$sts,
			method: "POST",
			
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			
				table.draw();
				
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
		
	
});

/////////////////////////// Salary advance Controller Starts From Here  ///////////////////////////////////

app.controller('salaryadvanceCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.salaryadvanceid=0;
	$scope.employeeid="";
	$scope.advanceamount="";
	$scope.installmentamt="";
	$scope.approvedby="";
	$scope.applydate="";
	$scope.emp=[];
	$scope.remarks="";
	$scope.applymonth1="";
	$scope.installmentarr=[];
	$scope.empgratuity=0;
	$scope.outstanding=0;	
Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
$scope.onchangeamt = function(){
$scope.installmentarr=[];
}
	$scope.onchangemonth = function(){
		
		$scope.installmentarr=[];
		/*var monthNames = ["January", "February", "March", "April", "May", "June","July", "August", "September", "October", "November", "December"];
		var temp=$scope.applymonth.split('/');
		temp=temp[2]+'-'+temp[1]+'-'+temp[0];
		var applymonth=new Date(temp);
		var months=applymonth.getMonth();
		var year=applymonth.getFullYear();*/
		var temp1=parseInt($scope.advanceamount/$scope.installmentamt);
		
		var rem=parseInt($scope.advanceamount%$scope.installmentamt);
		var first=Number(temp1)+Number(rem);
		
		$scope.installmentarr.insert(0,{id:0,month:"First Instalment",instamt:first});
		if($scope.installmentamt>1){
		$scope.installmentarr.insert(1,{id:0,month:"Subsequent Instalments",instamt:temp1});
		}
	}
	
	$scope.totalamt=0;
	$scope.onchangeemi = function(){
		$scope.installmentarr=[];
		//console.log($scope.applymonth1)
		var monthNames = ["January", "February", "March", "April", "May", "June","July", "August", "September", "October", "November", "December"];
		var temp=$scope.applymonth.split('/');
		temp=$scope.applymonth1;
		var applymonth=new Date(temp);
		var months=applymonth.getMonth();
		var year=applymonth.getFullYear();
		/*var temp1=($scope.advanceamount/$scope.installmentamt);
		var instamt=Number(Math.round(temp1+"e2")+"e-2");
		var total=Number($scope.advanceamount)+Number(instamt);
		
		*/
		var totalamt=0;
		var temp1=parseInt($scope.advanceamount/$scope.installmentamt);
		
		var rem=parseInt($scope.advanceamount%$scope.installmentamt);
		var first=Number(temp1)+Number(rem);
		
		if($scope.installmentamt>0){
			for(var i=0;i<$scope.installmentamt;i++){
			
				//total=total-instamt;
				//if(i==($scope.installmentamt-1)){
					//instamt=Number(Math.round(total+"e2")+"e-2");
				//}
				
				//$scope.installmentarr.insert(i,{id:0,instmonth:'1/'+(months+1)+'/'+year,month:monthNames[months]+" "+year,instamt:instamt});
				if(i==0){
					$scope.installmentarr.insert(0,{id:0,month:monthNames[months]+" "+year,instamt:first});
					totalamt=totalamt+Number(first);
				}else{
					$scope.installmentarr.insert(i,{id:0,month:monthNames[months]+" "+year,instamt:temp1});
					totalamt=totalamt+Number(temp1);
				}
				months++;
				if(months == 12)
				{
				months =0;
				year++;
				}
			}
		
		}
		
		$scope.totalamt=totalamt;
	}
	
	$scope.onfetchsalaryadvance =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({salaryadvanceid: $id});
		$http({
			url: path+'salary/getasalaryadvance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.advanceamount=data.data[0]['advanceamount'];
				$scope.installmentamt=data.data[0]['installmentamt'];
				$scope.approvedby=data.data[0]['approvedby'];
				$scope.remarks=data.data[0]['remarks'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.applymonth=data.data[0]['applymonth'];
				$scope.outstandingamt=data.data[0]['outstandingamt'];
				$scope.recoveramt=data.data[0]['recoveramt'];
				$scope.installmentarr=data.data[0]['installmentdetails'];
				//var onchangeinst();
				$scope.onchangemonth();
				//$scope.installmentarr.insert(0,{id:installmentarr[0].id,month:"First Instalment",instamt:Number(installmentarr[0].instamt)});
				//$scope.installmentarr.insert(1,{id:installmentarr[1].id,month:"Subsequent Instalments",instamt:Number(installmentarr[1].instamt)});
			}
			else{
				
				$scope.applymonth=data.month;
				$scope.applymonth1=data.month1;
				$scope.outstandingamt=data.outstanding;
				
			}
			$scope.empgratuity=data.empgratuity;
			$scope.netbalance=parseFloat($scope.empgratuity)-parseFloat($scope.outstandingamt);
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		var total=0;
		for(var i=0;i<$scope.installmentamt;i++)
		{
			if(i == 0){
				total+=($scope.installmentarr[0].instamt);
			}else{
				total+=($scope.installmentarr[1].instamt);
			}
		
		}
		if(total == $scope.advanceamount)
		{
			var JsonData1=angular.toJson($scope.installmentarr);
			$scope.hastrue=true;
			var xsrf = $.param({  advanceamount:$scope.advanceamount,  installmentamt:$scope.installmentamt, approvedby:$scope.approvedby, remarks: $scope.remark,applymonth:$scope.applymonth1 ,installmentdetails:JsonData1,applysts:""});
			$http({
				url: path+'profile/createsalaryadvance',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
					if(data.status){
						successMessage(data.successMsg);			
						$scope.employeeid="";
						$scope.advanceamount="";
						$scope.installmentamt="";
						$scope.approvedby="";			
						$scope.salaryadvanceid=0;	
						$scope.remarks="";
						$scope.applymonth="";					
						$scope.installmentarr.length=0;
						if($val==2){
							//window.open(path+"salary/salaryadvance", "_self");
							$timeout(function(){window.open(path+"profile/salaryadvance", "_self");}, timeo);
						}
					}
					else{
					errorMessage(data.errorMsg);
				}
					$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
					////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
					$scope.hastrue=false;
			});
		}
		else{
			errorMessage("Please refresh repayment details");
		}	
				
		
			
	}

	$scope.onupdate = function($val)
	{
		
		var total=0;
		for(var i=0;i<$scope.installmentamt;i++)
		{
			if(i == 0){
				total+=($scope.installmentarr[0].instamt);
			}else{
				total+=($scope.installmentarr[1].instamt);
			}
		
		}
		if(total == $scope.advanceamount)
		{
			var JsonData1=angular.toJson($scope.installmentarr);
			$scope.hastrue=true;
			var xsrf = $.param({ salaryadvanceid: $scope.salaryadvanceid, advanceamount:$scope.advanceamount, installmentamt:$scope.installmentamt,approvedby:$scope.approvedby, remarks: $scope.remark,applymonth:$scope.applymonth1,installmentdetails:JsonData1,applysts:""});
			$http({
				url: path+'profile/updatedesalaryadvance',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);			
						$scope.employeeid="";
						$scope.advanceamount="";
						$scope.installmentamt="";
						$scope.approvedby="";			
						$scope.salaryadvanceid=0;	
						$scope.remarks="";	
						$scope.applymonth="";	
						$scope.installmentarr.length=0;
						if($val==2){
							//window.open(path+"salary/salaryadvance", "_self");
							$timeout(function(){window.open(path+"profile/salaryadvance", "_self");}, timeo);
						}					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
		}
		else{
			errorMessage("Please refresh repayment details");
		}	
				
		
	}
});
/////////////////////////// Salary advance Loan Controller Starts From Here  ///////////////////////////////////

app.controller('salaryadvanceloanCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.salaryadvanceid=0;
	$scope.employeeid="";
	$scope.advanceamount="";
	$scope.installmentamt="";
	$scope.approvedby="";
	$scope.applydate="";
	$scope.emp=[];
	$scope.remarks="";
	$scope.applymonth1="";
	$scope.installmentarr=[];
	$scope.empgratuity=0;
	$scope.outstanding=0;	
Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
$scope.onchangeamt = function(){
$scope.installmentarr=[];
}
	$scope.onchangemonth = function(){
		
		$scope.installmentarr=[];
		/*var monthNames = ["January", "February", "March", "April", "May", "June","July", "August", "September", "October", "November", "December"];
		var temp=$scope.applymonth.split('/');
		temp=temp[2]+'-'+temp[1]+'-'+temp[0];
		var applymonth=new Date(temp);
		var months=applymonth.getMonth();
		var year=applymonth.getFullYear();*/
		var temp1=parseInt($scope.advanceamount/$scope.installmentamt);
		
		var rem=parseInt($scope.advanceamount%$scope.installmentamt);
		var first=Number(temp1)+Number(rem);
		
		$scope.installmentarr.insert(0,{id:0,month:"First Instalment",instamt:first});
		if($scope.installmentamt>1){
		$scope.installmentarr.insert(1,{id:0,month:"Subsequent Instalments",instamt:temp1});
		}
	}
	
	$scope.totalamt=0;
	$scope.onchangeemi = function(){
		$scope.installmentarr=[];
		//console.log($scope.applymonth1)
		var monthNames = ["January", "February", "March", "April", "May", "June","July", "August", "September", "October", "November", "December"];
		var temp=$scope.applymonth.split('/');
		temp=$scope.applymonth1;
		var applymonth=new Date(temp);
		var months=applymonth.getMonth();
		var year=applymonth.getFullYear();
		/*var temp1=($scope.advanceamount/$scope.installmentamt);
		var instamt=Number(Math.round(temp1+"e2")+"e-2");
		var total=Number($scope.advanceamount)+Number(instamt);
		
		*/
		var totalamt=0;
		var temp1=parseInt($scope.advanceamount/$scope.installmentamt);
		
		var rem=parseInt($scope.advanceamount%$scope.installmentamt);
		var first=Number(temp1)+Number(rem);
		
		if($scope.installmentamt>0){
			for(var i=0;i<$scope.installmentamt;i++){
			
				//total=total-instamt;
				//if(i==($scope.installmentamt-1)){
					//instamt=Number(Math.round(total+"e2")+"e-2");
				//}
				
				//$scope.installmentarr.insert(i,{id:0,instmonth:'1/'+(months+1)+'/'+year,month:monthNames[months]+" "+year,instamt:instamt});
				if(i==0){
					$scope.installmentarr.insert(0,{id:0,month:monthNames[months]+" "+year,instamt:first});
					totalamt=totalamt+Number(first);
				}else{
					$scope.installmentarr.insert(i,{id:0,month:monthNames[months]+" "+year,instamt:temp1});
					totalamt=totalamt+Number(temp1);
				}
				months++;
				if(months == 12)
				{
				months =0;
				year++;
				}
			}
		
		}
		
		$scope.totalamt=totalamt;
	}
	
	$scope.onfetchsalaryadvance =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({salaryadvanceid: $id});
		$http({
			url: path+'salaryadvanceloan/getasalaryadvance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.advanceamount=data.data[0]['advanceamount'];
				$scope.installmentamt=data.data[0]['installmentamt'];
				$scope.approvedby=data.data[0]['approvedby'];
				$scope.remarks=data.data[0]['remarks'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.applymonth=data.data[0]['applymonth'];
				$scope.outstandingamt=data.data[0]['outstandingamt'];
				$scope.recoveramt=data.data[0]['recoveramt'];
				$scope.installmentarr=data.data[0]['installmentdetails'];
				//var onchangeinst();
				$scope.onchangemonth();
				//$scope.installmentarr.insert(0,{id:installmentarr[0].id,month:"First Instalment",instamt:Number(installmentarr[0].instamt)});
				//$scope.installmentarr.insert(1,{id:installmentarr[1].id,month:"Subsequent Instalments",instamt:Number(installmentarr[1].instamt)});
			}
			else{
				
				$scope.applymonth=data.month;
				$scope.applymonth1=data.month1;
				$scope.outstandingamt=data.outstanding;
				
			}
			$scope.empgratuity=data.empgratuity;
			$scope.netbalance=parseFloat($scope.empgratuity)-parseFloat($scope.outstandingamt);
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		var total=0;
		for(var i=0;i<$scope.installmentamt;i++)
		{
			if(i == 0){
				total+=($scope.installmentarr[0].instamt);
			}else{
				total+=($scope.installmentarr[1].instamt);
			}
		
		}
		if(total == $scope.advanceamount)
		{
			var JsonData1=angular.toJson($scope.installmentarr);
			$scope.hastrue=true;
			var xsrf = $.param({  advanceamount:$scope.advanceamount,  installmentamt:$scope.installmentamt, approvedby:$scope.approvedby, remarks: $scope.remark,applymonth:$scope.applymonth1 ,installmentdetails:JsonData1,applysts:""});
			$http({
				url: path+'profile/createsalaryadvanceloan',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
					if(data.status){
						successMessage(data.successMsg);			
						$scope.employeeid="";
						$scope.advanceamount="";
						$scope.installmentamt="";
						$scope.approvedby="";			
						$scope.salaryadvanceid=0;	
						$scope.remarks="";
						$scope.applymonth="";					
						$scope.installmentarr.length=0;
						if($val==2){
							//window.open(path+"salary/salaryadvance", "_self");
							$timeout(function(){window.open(path+"profile/salaryadvanceloan", "_self");}, timeo);
						}
					}
					else{
					errorMessage(data.errorMsg);
				}
					$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
					////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
					$scope.hastrue=false;
			});
		}
		else{
			errorMessage("Please refresh repayment details");
		}	
				
		
			
	}

	$scope.onupdate = function($val)
	{
		
		var total=0;
		for(var i=0;i<$scope.installmentamt;i++)
		{
			if(i == 0){
				total+=($scope.installmentarr[0].instamt);
			}else{
				total+=($scope.installmentarr[1].instamt);
			}
		
		}
		if(total == $scope.advanceamount)
		{
			var JsonData1=angular.toJson($scope.installmentarr);
			$scope.hastrue=true;
			var xsrf = $.param({ salaryadvanceid: $scope.salaryadvanceid, advanceamount:$scope.advanceamount, installmentamt:$scope.installmentamt,approvedby:$scope.approvedby, remarks: $scope.remark,applymonth:$scope.applymonth1,installmentdetails:JsonData1,applysts:""});
			$http({
				url: path+'profile/updatedesalaryadvanceloan',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);			
						$scope.employeeid="";
						$scope.advanceamount="";
						$scope.installmentamt="";
						$scope.approvedby="";			
						$scope.salaryadvanceid=0;	
						$scope.remarks="";	
						$scope.applymonth="";	
						$scope.installmentarr.length=0;
						if($val==2){
							//window.open(path+"salary/salaryadvance", "_self");
							$timeout(function(){window.open(path+"profile/salaryadvanceloan", "_self");}, timeo);
						}					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
		}
		else{
			errorMessage("Please refresh repayment details");
		}	
				
		
	}
});

/////////////////////////// Document Request Controller Starts From Here  ///////////////////////////////////

app.controller('documentrequestCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.claimid=0;
	$scope.employeeid="";
	
	$scope.applydate="";
	$scope.documentrequestsarr=[];
	
	$scope.remarks="";

	onfetch("profile/getdocumentlist",1);

	Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};
		
	$scope.timediff = function($releasefrom){
		
		$scope.releaseto="";
		 var m=$releasefrom.split('/');
		 $('#releaseto').datepicker({
			startDate: new Date(m[2], m[1]-1, ++m[0])
		});
	}
		
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 7});
		$http({
			url: path+$val,
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.documentrequestsarr=[];
						$scope.documentrequestsarr=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.onfetchdocumentrequest =function($id)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({documentrequestid: $id});
		$http({
			url: path+'profile/getadocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				//$scope.employeeid=data.data[0]['employeeid'];
				$scope.releasefrom=data.data[0]['releasefrom'];
				$scope.timediff($scope.releasefrom);
				$scope.releaseto=data.data[0]['releaseto'];
				$scope.reason=data.data[0]['reason'];
				$scope.appsts=data.data[0]['appsts'];
				var temp=data.data[0]['docs'];
				for(var i=0;i<temp.length;i++){
					$scope.documentrequestsarr.insert(i,{id:temp[i].id,document:temp[i].name});
				
				}
				if(data.data[0]['requestdocid'] != ""){
					$scope.selecteddoc=data.data[0]['requestdocid'].split(',');
				}
					
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		var requestdocids=$scope.selecteddoc.toString();
		
		
		$scope.hastrue=true;
		var xsrf = $.param({  releasefrom:$scope.releasefrom,  releaseto:$scope.releaseto, reason:$scope.reason,requestdocid:requestdocids});
		$http({
			url: path+'profile/createdocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";
						
					
					if($val==2){
						//window.open(path+"salary/documentrequest", "_self");
						$timeout(function(){window.open(path+"profile/documentrequest", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		var requestdocids=$scope.selecteddoc.toString();
		
		
		$scope.hastrue=true;
		var xsrf = $.param({ documentrequestid: $scope.documentrequestid, releasefrom:$scope.releasefrom,  releaseto:$scope.releaseto, reason:$scope.reason,requestdocid:requestdocids,appsts:$scope.appsts});
		$http({
			url: path+'profile/updatededocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";			
					$scope.documentrequestid=0;	
						
					
					if($val==2){
						//window.open(path+"salary/documentrequest", "_self");
						$timeout(function(){window.open(path+"profile/documentrequest", "_self");}, timeo);
					}					
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});

/////////////////////////GRIEVANCE///////////////


app.controller('grievanceCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;

	$scope.notificationid=0;
	$scope.notificationname="";
	$scope.message="";
	$scope.division="";
	$scope.department="";
	$scope.designation="";
	$scope.employeeids="";
	$scope.startdate="";
	$scope.enddate="";
	$scope.priority="";
	
	$scope.employees=[];
	$scope.selection=[];
	$scope.priorityarray=[];
	

	
	//onfetch('employee/getallemployee',4);
	onfetch('employee/getallsenioremployee',4);
	onfetch('other',5);
	
	
		
	
	
	$scope.toggleSelection = function($idx) {
		//errorMessage($idx);
	 //var idx = $scope.employees[$index].id;
	 //var result = $.grep($scope.selection, function(e){ return e.id == idx; });
	 var flg=true;
	 var x=0;
	 for ( var i=0; i<$scope.selection.length; i++) {
		if ($scope.selection[i].id == $idx){ 
			flg = false;x=i;
			break;
			}
	  }
	 
	  if(flg){
		var x=0;
		for ( var i=0; i<$scope.employees.length; i++) {
			if ($scope.employees[i].id == $idx){ 
				x=i;
				break;
				}
		  }
		  
		$scope.selection.insert($scope.selection.length,$scope.employees[x]);
		$scope.employees[x].sts=1;
	  }else{
		$scope.selection.remove(x);
		$scope.employees[x].sts=0;
	  }
				if($scope.selection.length != 0){
					
					$("#empid").css('border-color', '#2A7C41');
				}
				else{
				
				$("#empid").css('border-color', 'maroon');
				}
   };
   
   
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					 if($id==4){
						$scope.employees=[];
						$scope.employees=data.data;
						
					}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchgrievance =function($id)
	{
	   
		$scope.hastrue=true;
		var xsrf = $.param({notificationid: $id});
		$http({
			url: path+'employee/getagrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.notificationname=data.data[0]['notificationname'];
					$scope.message=data.data[0]['message'];
					var temparr =data.data[0]['employeeids'];
					$scope.startdate=data.data[0]['startdate'];
					$scope.enddate=data.data[0]['enddate'];
					$scope.priority=data.data[0]['priority'];
					$scope.appsts=data.data[0]['appsts'];
					$scope.approverlist=data.data[0]['approverlist'];
					for ( var x=0; x<temparr.length; x++){
					for ( var i=0; i<$scope.employees.length; i++){
						if ($scope.employees[i].id == temparr[x]){ 
							$scope.selection.insert($scope.selection.length,$scope.employees[i]);
							$scope.employees[i].sts=1;
							break;
							}
						}
					}
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.oncreategrievance = function($val)
	{

	$scope.hastrue=true;
	
	var jsonData1=angular.toJson($scope.selection);
	var xsrf = $.param({notificationname: $scope.notificationname, message: $scope.message,  employeeids:jsonData1, priority:$scope.priority});
	  $http({
			url: path+'profile/creategrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					
					
					
					if($val==1){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"employee/grievance", "_self");}, timeo);
					}
					if($val==2){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"profile/grievances", "_self");}, timeo);
					}
					$scope.notificationname="";
					$scope.message="";
					$scope.employeeids="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationtype="";
					$scope.notificationid=0;
					$scope.selection=0;
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.onupdategrievance = function($val)
	{

	
	$scope.hastrue=true;
	var jsonData1=angular.toJson($scope.selection);
	var xsrf = $.param({notificationid: $scope.notificationid, notificationname: $scope.notificationname, message: $scope.message, priority:$scope.priority, employeeids:jsonData1  });
	  $http({
			url: path+'profile/updatedgrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);
					
					
					if($val==1){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"employee/grievance", "_self");}, timeo);
					}
					if($val==2){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"profile/grievances", "_self");}, timeo);
					}
					$scope.notificationname="";
					$scope.message="";
					$scope.employeeids="";
					$scope.selection=0;
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationid=0;
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	
	});


////////////////////////SKILL GAP ASSESSMENT CONTROLLER//////////////

app.controller('skillgapassessmentCtrl', function($scope, $http, $timeout) {
$scope.policy=[];
$scope.employeeid=0;
$scope.assessmentid=0;
$scope.empname="";
$scope.assessmenttype="";
$scope.assessmenttypeid=0;
$scope.designation="";
$scope.division="";
$scope.department="";
$scope.fromdate="";
$scope.todate="";
$scope.totalscorearr=[];		
$scope.achievements="";
$scope.issues="";
$scope.slider=0;
$scope.totalscore=0;

$scope.onchangelevel=function($val,$index){
	var gap=0;
	//console.log($val + $index)
	for(var i=0;i<$scope.policy.length;i++){
	var temp=$scope.policy[i].competencylevel1;
	
		if(i == $index){
			for(var j=0;j<temp.length;j++){
				if($val==temp[j].level)
				{
					$scope.policy[i].indicator1=temp[j].indicator;	
				}
			}
			gap=($scope.policy[i].level)-($val);
			if(gap<0){
				gap=0;
			}
			$scope.policy[i].gap=gap;
			//$(".rating"+i).text(gap);
		}
	}
	
	


}
	
	$scope.fetchobjective =function($val)
	{
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'profile/getskillgapassessment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				
				//$scope.assessmentid=data.data1[0]['id'];
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				$scope.editpermission=data.data1[0]['editpermission'];
				/*$scope.totalscorearr=data.data2;
				if(data.data1[0]['desiglevel'] != "" ){
					$scope.desiglevel=data.data1[0]['desiglevel'].split(',');
					for(var i=0;i<$scope.desiglevel.length;i++){
						if($scope.loginempdesig == $scope.desiglevel[i]){
							
							if($scope.totalscorearr.length == i){
							//console.log($scope.totalscorearr.length);
								$scope.slider=1;
							}
						}
					}
				}*/
				
						
				
			}
			else{
				
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
				
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	
	$scope.fetchresult =function($val)
	{
		
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'performance/getskillgapresult',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				
				//$scope.assessmentid=data.data1[0]['id'];
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				/*$scope.totalscorearr=data.data2;
				if(data.data1[0]['desiglevel'] != "" ){
					$scope.desiglevel=data.data1[0]['desiglevel'].split(',');
					for(var i=0;i<$scope.desiglevel.length;i++){
						if($scope.loginempdesig == $scope.desiglevel[i]){
							
							if($scope.totalscorearr.length == i){
							//console.log($scope.totalscorearr.length);
								$scope.slider=1;
							}
						}
					}
				}*/
				
						
				
			}
			else{
				
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
				
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var jsonData=angular.toJson($scope.policy);
var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid});
  $http({
        url: path+'performance/createskillgapassessment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"performance/skillgapassessment", "_self");}, timeo);
				}		
				$scope.policy=[];
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
Array.prototype.insert = function (index, item) {
	this.splice(index, 0, item);
};

});	
	
	

/////////////////////////////////////

app.controller('assessmentCtrl', function($scope, $http, $timeout) {
$scope.policy=[];
$scope.employeeid=0;
$scope.empname="";
$scope.assessmenttype="";
$scope.assessmenttypeid=0;
$scope.designation="";
$scope.division="";
$scope.department="";
$scope.fromdate="";
$scope.todate="";
$scope.totalscorearr=[];		
$scope.achievements="";
$scope.issues="";
$scope.totalscore=0;
$scope.slider=0;	
$scope.ratinga=[];
	$scope.fetchobjective =function($val)
	{
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'profile/getempassessmentold',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				$timeout(function(){
					$(".slider").slider({
						formatter: function(value) {
							return 'Current value: ' + value + ' %';
						}
						});
					$( ".slider" ).on( "slide", function( event ) {
						for(var i=0;i<$scope.policy.length;i++){
							
						if(i == event.delegateTarget.name)
							
							$scope.policy[i].score=event.value;

						}
						//alert($scope.policy);
						
						var weightage=0;
						var score1=0;
						var rate=0;
						var $i=0;
						var $s=0;
						var $s1=0;
						
					
						console.log($scope.policy[0].ratingarr[0]['max']);
						for(var i=0;i<$scope.policy.length;i++){
								
							if(i == event.delegateTarget.name){
								
								$s1=(($scope.policy[i].weightage)/($scope.policy[i].highrating));
								console.log($s1);
								$s=$s1;
								 $scope.ratingar=$scope.policy[i]['ratingarr'];
								
								
								for(var r=0;r<$scope.ratingar.length;r++)
								{
									if($scope.ratingar[r]['min']<=event.value && $scope.ratingar[r]['max']>=event.value)
										$(".rating"+i).text($scope.ratingar[r]['rate']);
									
								}
								/*for(var $j=($scope.policy[i].highrating);$i<=$scope.policy[i].weightage;$j--){
									
									//console.log($i+"i value");	
								if(((event.value)>$i) && ((event.value)<=$s))
									//console.log($i+"i value");
									//console.log($s+"s value");
									   {
											//console.log($j);
											rate=$j;
											//console.log(rate+" rate");
											$(".rating"+i).text(rate);
											break;
										}
									
								
									
								$i=$s;
								$s=$i+$s1;
								}*/
							}	
						}
					});
				}, 1000);
				$scope.filepath=data.filepath;
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.achievements=data.data1[0]['achievements'];
				$scope.issues=data.data1[0]['issues'];
				$scope.desigid=data.data1[0]['designationid'];
				$scope.variablepay=data.data1[0]['variablepay'];
				$scope.totalscorearr=data.data2;
				if(data.data1[0]['desiglevel'] != ''){
					$scope.desiglevel=data.data1[0]['desiglevel'].split(',');
					if($scope.desigid == $scope.desiglevel[0]){
						if($scope.totalscorearr.length==0){
						$scope.slider=1;
						}
					}
				}
			}
			else{
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
			}
			
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	

$scope.oncreate= function($val)
{

$scope.hastrue=true;

var jsonData=angular.toJson($scope.policy);
var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid,achievements:$scope.achievements,issues:$scope.issues,potentials:$scope.potentials});
  $http({
        url: path+'profile/createassessmentold',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				$scope.uploadFile($val);
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"profile/assessment", "_self");}, timeo);
				}		
				$scope.policy=[];
				$scope.achievements="";
				$scope.issues="";
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.employeeid;
	var date=$scope.fromdate;

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"performance/uploadAssessmentDoc",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('emp_id', emp);
				formData.append('assess_date', date);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
				if(data.status){
				//errorMessage(data.successMsg);
						
				
				if($val==1){
					$timeout(function(){window.open(path+"profile/assessment", "_self");}, timeo);
				}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	

});	
	
	/////////////////////////////////////

app.controller('assessmentkpiCtrl', function($scope, $http, $timeout) {

$scope.policy=[];
$scope.employeeid=0;
$scope.empname="";
$scope.assessmenttype="";
$scope.assessmenttypeid=0;
$scope.designation="";
$scope.division="";
$scope.department="";
$scope.fromdate="";
$scope.todate="";
$scope.totalscorearr=[];		
$scope.achievements="";
$scope.issues="";
$scope.improvements="";
$scope.totalscore=0;
$scope.slider=0;	
	$scope.quadleveldata=[];
	$scope.fetchobjective =function($val)
	{
		$scope.hastrue=true;
		var xsrf=$.param({assessmentid:$val});
		$http({
			url: path+'profile/getempassessment',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.policy=data.data;
				$scope.levelarr=data.levelarr;
				$scope.leveldata=data.data2[0];
				$scope.quadleveldata=data.data2[1];
				$scope.employeeid=data.data1[0]['employeeid'];
				$scope.empname=data.data1[0]['name'];
				$scope.assessmenttype=data.data1[0]['assessmentype'];
				$scope.assessmenttypeid=data.data1[0]['typeid'];
				$scope.designation=data.data1[0]['empdesignation'];
				$scope.division=data.data1[0]['empdivision'];
				$scope.department=data.data1[0]['empdepartment'];
				$scope.fromdate=data.data1[0]['fromdate'];
				$scope.todate=data.data1[0]['todate'];
				$scope.fromdate1=data.data1[0]['fromdate1'];
				$scope.todate1=data.data1[0]['todate1'];
				$scope.totalmarks=data.data1[0]['TotalMarks'];
				$scope.totalamt=data.data1[0]['ObtainedMarks'];
				$scope.ratings=data.data1[0]['Rating'];
				$scope.remark=data.data1[0]['Result'];
				$scope.summary=data.data1[0]['desc'];
				$scope.improvements=data.data1[0]['improvements'];
				$scope.loginempdesig=data.data1[0]['loginempdesig'];
				$scope.checkinstamt();
				//$scope.totalscorearr=data.data2;
			}
			else{
				$scope.policy=[];
				$scope.assessmenttype="";
				$scope.fromdate="";
				$scope.todate="";
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
$scope.checkinstamt = function() {
		var total=0; var totalamt=0;  	$scope.totalper=0;
		$scope.ratings =0;
		$scope.remark ="";
		$scope.totalamt=0;
		$scope.count=0
		for(var i=0;i<$scope.policy.length;i++){
			$scope.criteria=$scope.policy[i]['ratingarr'];
			
			break;
		}
		for(var i=0;i<$scope.leveldata.length;i++){
			if($scope.leveldata[i]['includedesg'] == 1){
				total =Number(total) + Number($scope.leveldata[i]['score']);
				totalamt =Number(totalamt) + Number($scope.leveldata[i]['marks']);
				$scope.count++;
			}
		}
		if(totalamt!=0){
		$scope.totalamt=Number(totalamt)/Number($scope.count);
		$scope.totalamt=parseFloat($scope.totalamt).toFixed(0);
		}
		if(total!=0){
		$scope.totalper =Number(total)/Number($scope.count);
		
		
		//alert(totalper);
		//console.log($scope.criteria);
		for(var i=0;i<$scope.criteria.length;i++){
			if($scope.totalper >= $scope.criteria[i].min && $scope.totalper<=$scope.criteria[i].max ){
				
				$scope.ratings=$scope.criteria[i].rate;
				$scope.remark=$scope.criteria[i].result;
			}
			
		}
		$scope.totalper =Number($scope.totalper).toFixed(2);
		}
	} 
		
$scope.checkinstamtold = function() {
		var total=0;  	/*$scope.totalper=0;
		 $scope.ratings =0;
		$scope.remark ="";
		$scope.totalamt=0; */
		for(var i=0;i<$scope.policy.length;i++){
			//$scope.criteria=$scope.policy[i]['ratingarr'];
			if($scope.policy[i]['score'] == undefined){
				$scope.policy[i]['score']=0;
			}
			total =Number(total) + Number($scope.policy[i]['score']);
		}
		$scope.totalamt1=Number(total);
		/* $scope.totalper =(($scope.totalamt/$scope.totalmarks)*100);
		$scope.totalper =parseFloat($scope.totalper).toFixed(2);
		//alert(totalper);
		for(var i=0;i<$scope.criteria.length;i++){
			if($scope.totalper >= $scope.criteria[i].min && $scope.totalper<=$scope.criteria[i].max ){
				//alert($scope.criteria[i].id);
				$scope.ratings=$scope.criteria[i].rate;
				$scope.remark=$scope.criteria[i].result;
			}
			
		} */
		
	} 
		
$scope.getrange = function(count){
	//console.log(count);
	var levels = []; 
	for (var i = 0; i <= count; i++) { 
	levels.push(i+1); 
	} 
	//console.log(levels);
	return levels;
}	
		
$scope.range = function(count){
		var ratings = []; 
		for (var i = 0; i < count; i++) { 
		ratings.push(i) 
		} 
		return ratings;
	}
	
$scope.oncreate= function($val)
{
	console.log($scope.policy);
	//return false;
	$scope.hastrue=true;
	var jsonData=angular.toJson($scope.policy);
	var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid,totalmarks:$scope.totalmarks,totalamt:$scope.totalamt,rating:$scope.ratings,result:$scope.remark,desc:$scope.summary,improvements:$scope.improvements});
	$http({
        url: path+'profile/createassessment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"profile/assessmentkpi", "_self");}, timeo);
				}		
				$scope.policy=[];
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		}); 
}
/* 
$scope.oncreate= function($val)
{
$scope.hastrue=true;

var jsonData=angular.toJson($scope.policy);
var xsrf = $.param({assessmentid:$scope.assessmentid,employeeid:$scope.employeeid,fromdate:$scope.fromdate,todate:$scope.todate,assessmentarr:jsonData,assessmenttype:$scope.assessmenttypeid,totalmarks:$scope.totalmarks,totalamt:$scope.totalamt,rating:$scope.ratings,result:$scope.remark,desc:$scope.summary,improvements:$scope.improvements});
  $http({
        url: path+'profile/createassessment',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status)
			{
				//$scope.uploadFile($val);
				successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"profile/assessment", "_self");}, timeo);
				}		
				$scope.policy=[];
				
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
} */
///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.employeeid;
	var date=$scope.fromdate;

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"performance/uploadAssessmentDoc",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				formData.append('emp_id', emp);
				formData.append('assess_date', date);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
				if(data.status){
				//errorMessage(data.successMsg);
						
				
				if($val==1){
					$timeout(function(){window.open(path+"profile/assessment", "_self");}, timeo);
				}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	

});

	///////////////////profile change password//////////////////////////

	
app.controller('resignationCtrl', function($scope, $http, $timeout) {

$scope.subject="";
$scope.msg="";
$scope.resignsts='';
$scope.sts=false;
$scope.msglength=0;
	
		
	$scope.onfetchresignation= function()
	{



	$scope.hastrue=true;

	  $http({
		url: path+'profile/getemployeeresignation',
		method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
	      }).success(function (data, status, headers, config) {
				if(data.status)
				{
					
					$scope.subject=data.data[0]['subject'];	
					$scope.msg=data.data[0]['message'];
					document.getElementById('msg').value=data.data[0]['message'];
					$scope.resignsts=data.data[0]['resignsts'];
					$scope.sts=true;
				}
				else{
					
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
		    ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	
	$scope.onresignation = function($val)
	{	
		var msg1 = document.getElementById('msg').value;
		//alert('hello');
		if(msg1=='')
		{
			errorMessage("Message can not be left blank.");
			//document.getElementById('msg').focus();
			return false;
		}
		if(!confirm("Are you sure want to apply for your resignation ?"))
		{
			return false;
		}
		
		//return false;
		$scope.hastrue=true;
		var xsrf = $.param({subject:$scope.subject, msg:msg1});
		$http({
			url: path+'profile/employeeresignation',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
										
					if($val==1){
						//window.open(path+"profile/change_password", "_self");
						$timeout(function(){window.open(path+"profile/resignation", "_self");}, timeo);
					}
					
					
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	

	
});

/////////////////////////// Certificate Request Controller Starts From Here  ///////////////////////////////////

app.controller('certificaterequestCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.claimid=0;
	$scope.employeeid="";
	
	$scope.applydate="";
	$scope.certificaterequestsarr=[];
	
	$scope.remarks="";

	onfetch("employee/getallcertificate",1);

	
	
		
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.certificaterequestsarr=[];
						$scope.certificaterequestsarr=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.onfetchcertificaterequest =function($id)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({certificaterequestid: $id});
		$http({
			url: path+'profile/getacertificaterequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				//$scope.employeeid=data.data[0]['employeeid'];
				
				$scope.reason=data.data[0]['reason'];
				$scope.address=data.data[0]['address'];
				$scope.selecteddoc=data.data[0]['requestdocid'];
				
					
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		
		
		$scope.hastrue=true;
		var xsrf = $.param({  address:$scope.address, reason:$scope.reason,requestdocid:$scope.selecteddoc});
		$http({
			url: path+'profile/createcertificaterequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";
					$scope.address="";	
					
					if($val==2){
						//window.open(path+"salary/certificaterequest", "_self");
						$timeout(function(){window.open(path+"profile/certificaterequest", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		
		$scope.hastrue=true;
		var xsrf = $.param({ certificaterequestid: $scope.certificaterequestid, reason:$scope.reason,address:$scope.address,requestdocid:$scope.selecteddoc});
		$http({
			url: path+'profile/updatedecertificaterequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";	
					$scope.address="";	
					$scope.certificaterequestid=0;	
						
					
					if($val==2){
						//window.open(path+"salary/certificaterequest", "_self");
						$timeout(function(){window.open(path+"profile/certificaterequest", "_self");}, timeo);
					}					
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});

/////////////////////////// Claims Controller Starts From Here  ///////////////////////////////////

app.controller('claimCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.claimid=0;
	$scope.employeeid="";
	
	$scope.applydate="";
	$scope.claimsarr=[];
	$scope.claimchildarray=[{id:0,date:'',desc:"",head:'',claimamt:''}];
	$scope.totalclaimamt=0;
	$scope.remarks="";
	
	onfetch("profile/getallclaimhead",1);

	$scope.addclaim = function($i){
		var len = $scope.claimchildarray.length-1;
		if($scope.claimchildarray[len]['date']==""  || $scope.claimchildarray[len]['claimamt']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.claimchildarray.insert($i,{id:0,date:'',desc:"",head:'',claimamt:''});
		}
	
	}
	$scope.removeclaim = function($i){
		$scope.claimchildarray.remove($i);	
	}		
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
		
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.claimsarr=[];
						$scope.claimsarr=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.onfetchclaim =function($id)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({claimid: $id});
		$http({
			url: path+'profile/getaclaim',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.claimid=data.data[0]['id'];
				$scope.starttrip=data.data[0]['fromdate'];
				$scope.endtrip=data.data[0]['todate'];
				$scope.purpose=data.data[0]['purpose'];
				$scope.totalclaimamt=data.data[0]['totalclaim'];
				$scope.claimchildarray=data.data[0]['claimarr'];
				
					
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.calculatetotal = function($val)
	{
		var totalamt=0;
		for(var i=0;i<$scope.claimchildarray.length;i++)
		{
			totalamt=parseFloat(totalamt)+parseFloat($scope.claimchildarray[i].claimamt);
		}
		$scope.totalclaimamt=totalamt;
	}
	$scope.oncreate = function($val)
	{	
		
		var jsonData=angular.toJson($scope.claimchildarray);
		$scope.hastrue=true;
		var xsrf = $.param({   fromdate:$scope.starttrip,todate:$scope.endtrip,purpose:$scope.purpose,claimarr:jsonData,claimamt:$scope.totalclaimamt});
		$http({
			url: path+'profile/createclaim',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					$scope.employeeid=data.employeeid;
					$scope.claimid=data.claimid;
					if($scope.files.length>0){
						$scope.uploadFile($val);
					}
					successMessage(data.successMsg);			
										
					if($val==2){
						//window.open(path+"salary/claim", "_self");
						$timeout(function(){window.open(path+"profile/claims", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		
		$scope.hastrue=true;
		var jsonData=angular.toJson($scope.claimchildarray);
		var xsrf = $.param({ claimid: $scope.claimid, fromdate:$scope.starttrip,todate:$scope.endtrip,purpose:$scope.purpose,claimarr:jsonData,claimamt:$scope.totalclaimamt});
		$http({
			url: path+'profile/updatedeclaim',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);			
					if($scope.files.length>0){
						$scope.uploadFile($val);
					}
					if($val==2){
						//window.open(path+"salary/claim", "_self");
						$timeout(function(){window.open(path+"profile/claims", "_self");}, timeo);
					}					
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	var emp=$scope.employeeid;
	var claimid=$scope.claimid;
	//var date=$scope.fromdate;

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"profile/uploadClaimDoc",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				for (var i = 0; i < $scope.claimchildarray.length; i++) {
                    if(document.getElementById(i).value!=""){
					var docid=document.getElementById(i).name;
					}
                }
				
				
				formData.append('emp_id',emp);
				formData.append('doc_id',docid);
				formData.append('claimid',claimid);
				//formData.append('assess_date', date);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
				if(data.status){
				//errorMessage(data.successMsg);
						
				
				if($val==2){
					$timeout(function(){window.open(path+"profile/claims", "_self");}, timeo);
				}
			}
			else{
			
				errorMessage(data.errorMsg);
			}
			
			
		}).
        error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	
});



/////////////////////////// Project Controller Starts From Here  ///////////////////////////////////
app.controller('projectCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	//$scope.leavevalidsts=[];
    onfetch('profile/getallproject',1);
    onfetch('profile/getalltask',2);
	onfetch('other',5);
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					if($id==1){
						$scope.projectarray=[];
						$scope.projectarray=data.data;
					}else if($id==2){
						$scope.taskarray=[];
						$scope.taskarray=data.data;
					}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
					}
					
					
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

	$scope.timesheetarray=[{id:0,priority:1 ,taskid:"", assignto:"", sdate:"", edate:"",totaltime:""}];
	$scope.addtask = function($i){
		var len = $scope.timesheetarray.length-1;
		if($scope.timesheetarray[len]['projectid']=="" || $scope.timesheetarray[len]['taskid']=="" || $scope.timesheetarray[len]['assignto']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.timesheetarray.insert($i,{id:0,priority:1, projectid:"",taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	$scope.removetask = function($i){
		$scope.timesheetarray.remove($i);	
		if($scope.timesheetarray.length==0){
			$scope.timesheetarray.insert($i,{id:0,priority:1,taskid:"", assignto:"", sdate:"", edate:"",totaltime:""});
		}
	}
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	/* $scope.fillassignto = function($id) {
		//alert($id);
		$scope.assigntoarr=new Array();
		//console.log($id);
		var arr=$id;
		for(var j=0;j<arr.length;j++){
			for(var i=0;i<$scope.juniourarr.length;i++){
				if(arr[j]==$scope.juniourarr[i]['id'])
				$scope.assigntoarr.insert(j,{id:$scope.juniourarr[i]['id'],name:$scope.juniourarr[i]['name']});
			}
		}
		//console.log($scope.assigntoarr);
	} */
	$scope.getId = function($id) {
		$scope.projectid=$id;
	}
	
	/* Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	}; */
	$scope.juniourarr=[]; 
	$scope.selectedcolumnsarr = [];	
	$scope.onfetchjuniours =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'employee/getEmployeeListbyreport',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.juniourarr=data.data;
				$scope.selectedcolumnsarr=new Array();	
			}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	///////////Check employee  available selected box //////////
	$scope.toggleSelection = function($x) {
	
	  if($scope.juniourarr[$x].vsts){		
		$scope.juniourarr[$x].vsts=false;
	  }else{
		$scope.juniourarr[$x].vsts=true;
	  }
	  $scope.leftdisable=true;
	  var len = $scope.juniourarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.juniourarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
   ///////////Check employee  selected box //////////
   $scope.toggleSelection1 = function($x) {
	
	  if($scope.selectedcolumnsarr[$x].vsts){		
		$scope.selectedcolumnsarr[$x].vsts=false;
	  }else{
		$scope.selectedcolumnsarr[$x].vsts=true;
	  }
	  $scope.rightdisable=true;
	  var len = $scope.selectedcolumnsarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.selectedcolumnsarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
   };
///////////end check checkbox ////////////   
   //////////left right move function//////////////
	$scope.onAddSelection = function()
	{
		$scope.leftdisable=true;
		$scope.rightdisable=true;
		for (var i=0; i<$scope.juniourarr.length; i++) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr[i].vsts=false;
					$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
					$scope.juniourarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.juniourarr.length-1; i>=0; i--) {
				if ($scope.juniourarr[i].vsts){ 
					$scope.juniourarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
			$scope.selectedcolumnsarr[i].vsts=false;
		 }
	}
	$scope.onRemoveSelection = function()
	{
		$scope.leftdisable=true;
		$scope.rightdisable=true;
		for ( var i=0; i<$scope.selectedcolumnsarr.length; i++) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr[i].vsts=false;
					$scope.juniourarr.insert($scope.juniourarr.length,$scope.selectedcolumnsarr[i]);
					$scope.selectedcolumnsarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.selectedcolumnsarr.length-1; i>=0; i--) {
				if ($scope.selectedcolumnsarr[i].vsts){ 
					$scope.selectedcolumnsarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.juniourarr.length; i++) {
				$scope.juniourarr[i].vsts=false;
		}
			
	}
	///////////end left right move function/////////////
	///////disable date //////////////
	$scope.timediff = function($leaveto){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#"+$leaveto+"actstart").datetimepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#'+$leaveto+'actend').datetimepicker("remove");
		$('#'+$leaveto+'actend').datetimepicker({
			startDate: fromdate
		});
	}
	$scope.timediffest = function($leaveto){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
		
		
	}
//////////////end date disable ///////////////////	
	$scope.onfetchproject =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'profile/getprojectdetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.timesheetarray=[{id:0,priority:1, taskid:"", assignto:"", sdate:"", edate:"",totaltime:""}];
				if(data.data[0]['jobchild'].length>0){
				$scope.timesheetarray=data.data[0]['jobchild'];
				}
				$scope.title=data.data[0]['project_title'];
				$scope.fromdate=data.data[0]['start_date'];
				$scope.todate=data.data[0]['completed_date'];
				$scope.ownerid=data.data[0]['owner_id'];
				$scope.projectstatus=data.data[0]['project_status'];
				$scope.onfetchjuniours($scope.ownerid);
				$scope.desc=data.data[0]['project_desc'];
				//$scope.assignempid=data.data[0]['assigned_to'];
				var temparr= data.data[0]['assigned_to'];
				$timeout(function(){
				
					for ( var x=0; x<temparr.length; x++){
						for ( var i=0; i<$scope.juniourarr.length; i++){
							if ($scope.juniourarr[i].id == temparr[x]){ 
								$scope.selectedcolumnsarr.insert($scope.selectedcolumnsarr.length,$scope.juniourarr[i]);
								//$scope.selectedcolumnsarr.sort();
								$scope.juniourarr.remove(i);
							}
						}
					}
					
					
					//$scope.fillassignto($scope.assignempid);
				
				}, 1000); 
				
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchtimesheet =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'profile/gettimesheetdetail',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log(data.data[0]['jobchild']);
				$scope.timesheetarray=data.data[0]['jobchild'];
				
				$scope.title=data.data[0]['project_title'];
				$scope.fromdate=data.data[0]['start_date'];
				$scope.todate=data.data[0]['completed_date'];
				$scope.ownerid=data.data[0]['owner_id'];
				$scope.onfetchjuniours($scope.ownerid);
				$scope.desc=data.data[0]['project_desc'];
				$scope.assignempid=data.data[0]['assigned_to'];
				$timeout(function(){$scope.fillassignto($scope.assignempid);}, 300);
				//console.log($scope.timesheetarray);
               // $scope.juniourarr=data.data;
			}		
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val)
	{
		var json = angular.toJson($scope.timesheetarray);
		$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
		$scope.hastrue=true;
		var xsrf = $.param({ ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title,projectstatus : $scope.projectstatus, assignempid:$scope.selectedcol ,timesheet:json});
		$http({
			url: path+'profile/createproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/project", "_self");}, timeo);
								
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val)
	{ 
		$scope.hastrue=true;
		var json = angular.toJson($scope.timesheetarray);
		$scope.selectedcol=angular.toJson($scope.selectedcolumnsarr);
		var xsrf = $.param({project_id:$scope.projectid,  ownerid: $scope.ownerid , fromdate: $scope.fromdate , todate : $scope.todate , desc : $scope.desc, title : $scope.title,projectstatus : $scope.projectstatus, assignempid:$scope.selectedcol ,timesheet:json});
		$http({
			url: path+'profile/updateproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/project", "_self");}, timeo);
							
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdatetimesheet = function($val)
	{ 
		$scope.hastrue=true;
		var json = angular.toJson($scope.timesheetarray);
		var xsrf = $.param({project_id:$scope.projectid,  ownerid: $scope.ownerid , timesheet:json});
		$http({
			url: path+'profile/updatetimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/project", "_self");}, timeo);
							
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	/////////////////upload leave attachment in the case of sick timesheet/////
	$scope.settotaltime= function($index)
	{
		//alert($index);//alert($edate);
		
		var strt = $("#"+$index+"actstart").datetimepicker('getDate');
		var end = $("#"+$index+"actend").datetimepicker('getDate');
		
		var a = new Date(strt);
		var b = new Date(end);
		
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		/* var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		var day = Math.floor((utc2 - utc1) / _MS_PER_DAY);
		 */
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
		//console.log($scope.TaskList);
		for(var i=0;i<$scope.timesheetarray.length;i++){
			if($index == i){
			$scope.timesheetarray[i]['totaltime1']=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.timesheetarray[i]['totaltime']=days1+':'+minutes;
			}
		
		}
	}
});
app.controller('timesheetCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.timesheetid=0;
	$scope.employeeid="";
	
	$scope.applydate="";
	$scope.timesheetsarr=[];
	$scope.timesheetchildarray=[{id:0,date:'',desc:"",head:'',timesheetamt:''}];
	$scope.totaltimesheetamt=0;
	$scope.remarks="";
	
	onfetch("profile/getallproject",1);

	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.projectarr=[];
						$scope.projectarr=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.onfetchtasks =function($projectid)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $projectid});
		$http({
			url: path+'profile/getalltask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.taskarr=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchtimesheet =function($id)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({timesheetid: $id});
		$http({
			url: path+'profile/getatimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.timesheetid=data.data[0]['id'];
				$scope.starttrip=data.data[0]['fromdate'];
				$scope.endtrip=data.data[0]['todate'];
				$scope.purpose=data.data[0]['purpose'];
				$scope.totaltimesheetamt=data.data[0]['totaltimesheet'];
				$scope.timesheetchildarray=data.data[0]['timesheetarr'];
				
					
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val)
	{	
		
		var jsonData=angular.toJson($scope.timesheetchildarray);
		$scope.hastrue=true;
		var xsrf = $.param({   fromdate:$scope.starttrip,todate:$scope.endtrip,purpose:$scope.purpose,timesheetarr:jsonData,timesheetamt:$scope.totaltimesheetamt});
		$http({
			url: path+'profile/createtimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					$scope.employeeid=data.employeeid;
					$scope.timesheetid=data.timesheetid;
					if($scope.files.length>0){
						$scope.uploadFile($val);
					}
					successMessage(data.successMsg);			
										
					if($val==2){
						//window.open(path+"salary/timesheet", "_self");
						$timeout(function(){window.open(path+"profile/timesheet", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		$scope.hastrue=true;
		var jsonData=angular.toJson($scope.timesheetchildarray);
		var xsrf = $.param({ timesheetid: $scope.timesheetid, fromdate:$scope.starttrip,todate:$scope.endtrip,purpose:$scope.purpose,timesheetarr:jsonData,timesheetamt:$scope.totaltimesheetamt});
		$http({
			url: path+'profile/updatedetimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);			
					if($scope.files.length>0){
						$scope.uploadFile($val);
					}
					if($val==2){
						//window.open(path+"salary/timesheet", "_self");
						$timeout(function(){window.open(path+"profile/timesheet", "_self");}, timeo);
					}					
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
});
app.controller('Timesheetctrl', function($scope, $http, $timeout) {
	$scope.assignid=0;
	$scope.TaskList=[];
	$scope.marks="";
	$scope.remark="";
	$scope.desc="";
	$scope.empList=[];
	$scope.totalmarks=0;
	$scope.date="";
	$scope.timesheetid=0;
	$scope.taskid="";
	$scope.taskarray=[];
	$scope.hastrue=false;
	$scope.hourssts=1;
	$scope.hoursshow=true;
	$scope.totalmarks=0;
	$scope.date="";
	$scope.addtimesheet = function()	{
		$scope.startdate="";
		$scope.endtime="";
		$scope.starttime="";
		$scope.timeduration="";
		$scope.hourssts=1;
		$scope.desc="";
		$scope.errormessage="";
		$scope.projectid="";
		$scope.taskid="";
		
	}
	onfetch('profile/getallproject',1);
    $scope.getHoursType= function($val){
		if($val==1){
			$scope.hoursshow=true;
			$scope.startendshow=false;
		}
		else{
			$scope.startendshow=true;
			$scope.hoursshow=false;
		}
	}
	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==1){
						$scope.projectarray=[];
						$scope.projectarray=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

	$scope.onfetchtask =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'profile/gettaskbyproject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.taskarray=data.data;
				
			}else
				$scope.taskarray=[];				
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.fetchtask = function($type) {
		$scope.hastrue=true;
		var xsrf = $.param({date:$scope.date});
		$http({
			url: path+'profile/getAlltimesheet/'+$type,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//console.log(data.data);
			
			if(data.status){
				$scope.TaskList=data.data;
				$scope.date=data.datetime;
				//console.log($scope.date);
			}
			$scope.TaskList=data.data;
			$scope.date=data.datetime;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
	$scope.onupdatetimesheet = function($val)
	{ 
		$scope.hastrue=true;
		var json = angular.toJson($scope.TaskList);
		var xsrf = $.param({timesheet:json});
		$http({
			url: path+'profile/updatetimesheet1',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                successMessage(data.successMsg);
				if($val==2){
					$timeout(function(){window.open(path+"profile/unassigntimesheet", "_self");}, timeo);	
				}else{
				$timeout(function(){window.open(path+"profile/timesheet", "_self");}, timeo);
				}			
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}	
	$scope.fetchunassigntask = function($type) {
		$scope.hastrue=true;
		var xsrf = $.param({date:$scope.date});
		$http({
			url: path+'profile/getunassigntimesheet/'+$type,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//console.log(data.data);
			
			if(data.status){
				$scope.TaskList=data.data;
				$scope.date=data.datetime;
				//console.log($scope.date);
			}
			$scope.TaskList=data.data;
			$scope.date=data.datetime;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
	            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	$scope.taskdone = function()	{
		//$scope.can_name=$can_name;
		$timeout(function(){$('#confirm1').modal('show');},100);
		 $(document).on('show.bs.modal', '.modal', function (event) {
            var zIndex = 1040 + (10 * $('.modal:visible').length);
            $(this).css('z-index', zIndex);
            // setTimeout(function() {
                // $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
            // }, 0);
        });
	}
	$scope.onchangeadmin =function() {
	$scope.hastrue=true;
	$http({
        url: path+'tasks/addtaskstatus/'+$scope.taskid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				// table.draw();
				$timeout(function(){window.open(path+"profile/unassigntimesheet", "_self");}, 400); 
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.taskid="";
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	$scope.getId = function($id) {
		$scope.timesheetid=$id;
	}
	$scope.ondelete =function(){
		$http({
			url: path+'profile/deletetimesheet/'+$scope.timesheetid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
						window.open(path+"profile/unassigntimesheet", "_self");
					//table.draw();
				}else{
					errorMessage(data.errorMsg);
					window.open(path+"profile/unassigntimesheet", "_self");
					//table.draw();
				}
				$scope.taskid=0;
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.settotaltime= function($index)
	{
		//alert($sdate);alert($edate);
		
		var strt = $("#"+$index+"sstartdate").datetimepicker('getDate');
		var end = $("#"+$index+"senddate").datetimepicker('getDate');
		var a = new Date(strt);
		var b = new Date(end);
		
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		/* var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		var day = Math.floor((utc2 - utc1) / _MS_PER_DAY);
		 */
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
		//console.log($scope.TaskList);
		for(var i=0;i<$scope.TaskList.length;i++){
			if($index == i){
			$scope.TaskList[i]['totaltime1']=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.TaskList[i]['totaltime']=days1+':'+minutes;
			}
		
		}
	}
	
	/* $scope.gettotaltime= function($sdate,$edate)
	{
		//alert($sdate);alert($edate);
		var strt = $("#startdate").datetimepicker('getDate');
		var end = $("#enddate").datetimepicker('getDate');
		var a = new Date(strt);
		var b = new Date(end);
		//var _MS_PER_DAY = 1000 * 60 * 60 * 24;
		// Discard the time and time-zone information.
		  // var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
		// var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());
		// var day = Math.floor((utc2 - utc1) / _MS_PER_DAY); 
		
		var date1_ms = a.getTime();
		var date2_ms = b.getTime();
		
		var difference_ms = date2_ms - date1_ms;
		 difference_ms = difference_ms/1000;
		
		var seconds = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60;
		
		var minutes = Math.floor(difference_ms % 60);
		difference_ms = difference_ms/60; 
			
		var hours = Math.floor(difference_ms % 24);
		
		var days = Math.floor(difference_ms/24);
		var days1 = Math.floor(difference_ms);
			$scope.timeduration1=days + ' days, ' + hours + ' hours, ' + minutes + ' minutes';
			$scope.timeduration=days1+':'+minutes;
		
	}
	 */
	$scope.onsavetimesheet = function($val)
	{ 
		if($scope.hourssts==1){
			$scope.starttime="";
			$scope.endtime="";
			$scope.timeduration=$("#timeduration").val();
			//console.log($scope.timeduration);
			if($scope.timeduration==""){
			//	console.log("fsdfsdf");
				alert("Filled Hours");
				return false;
			}
		}
		else if($scope.hourssts==2){
			$scope.timeduration="";
			$scope.starttime=$("#starttime").val();
			$scope.endtime=$("#endtime").val();
			if($scope.starttime=="" && $scope.endtime==""){
				alert("Filled Start Time and End Time");
				return false;
			}
		}
		//console.log($scope.timeduration);
		$scope.hastrue=true;
		var xsrf = $.param({projectid:$scope.projectid, taskid:$scope.taskid, startdate:$scope.startdate,hourssts:$scope.hourssts, timeduration:$scope.timeduration, starttime:$scope.starttime,  endtime:$scope.endtime, desc:$scope.desc});
		$http({
			url: path+'profile/addselftimesheet',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
                successMessage(data.successMsg);
				if($val==1){
					window.open(path+"profile/unassigntimesheet", "_self");
				}else if($val==2){
					$scope.onchangeadmin();
				}			
			}else{
				errorMessage(data.errorMsg);
				$scope.errormessage=data.errorMsg;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}	
	
	$scope.timediffest = function(){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#startdate").datetimepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#enddate').datetimepicker("remove");
		 $('#enddate').val("");
		$('#enddate').datetimepicker({
			startDate: fromdate,
			endDate: new Date()
		});
	}
});
app.controller('taskCtrl', function($scope, $http, $timeout) {
	
	$scope.hastrue=false;
	$scope.taskid=0;
	$scope.hastrue=false;
    $scope.employeeid="";
	$scope.projectid="";
	$scope.milestoneid="";
	$scope.assignto=0;
	$scope.desc="";
	$scope.title="";
	$scope.priority=0;
	$scope.taskstatus=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.durationhours="";
	$scope.durationminutes="";
	$scope.totalmarks=0;
	$scope.date="";
	$scope.projectarray1=[];
	$scope.otherarray=[];
	
	////////upload task files//////////
	onfetch("milestone/getAllRunningProject",1);
	onfetch("tasks/getother",2);
	onfetch("profile/getallproject",3);

	function onfetch($val, $id){
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==2){
					$scope.otherarray=data.data;
					$scope.taskstatus=$scope.otherarray[0]['id'];
				}
				if($id==3)
				$scope.projectarray1=data.data;
			} 
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	 $scope.employeenewarr = [];		
	
	$scope.milestonearray = [];		
	$scope.onfetchmilestone =function($id,$index){ 
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $id});
		$http({
			url: path+'tasks/getallmilestone',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.milestonearray=data.data;
				}		
			$scope.changests=data.changestatus;
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.empprojectarr=[];
	$scope.getempproject =function($id){ 
		$scope.hastrue=true;
		var xsrf = $.param({empid: $id});
		$http({
			url: path+'tasks/getEmpProject',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
                $scope.empprojectarr=data.data;
				
			}else{
			 $scope.empprojectarr=[ ];
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
	$scope.onfetchtask =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({taskid: $id});
		$http({
			url: path+'tasks/getatask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){			
				$scope.title=data.data[0]['task_title'];
				$scope.fromdate=data.data[0]['fromdate'];
				$scope.todate=data.data[0]['todate'];
				$scope.projectid=data.data[0]['projectid'];
				
				if($scope.projectid==0){
					$scope.projectid=0;
					$scope.onfetchdefaultemployee(1);
					$scope.assignto=Number(data.data[0]['assignto']);
				}
				$scope.milestoneid=data.data[0]['milestoneid'];
				if($scope.milestoneid==0){
					$scope.milestoneid=0;
				}
					
				
				$scope.desc=data.data[0]['desc'];
				$scope.priority=data.data[0]['priority'];
				$scope.durationhours=data.data[0]['durationhours'];
				$scope.durationminutes=data.data[0]['durationminutes'];
				$scope.taskstatus=data.data[0]['taskstatus'];
				//$scope.miscunduct=data.data[0]['miscunduct'];
				$scope.reopencount=data.data[0]['reopencount'];
				//$scope.rating=data.data[0]['rating'];
				if($scope.type==3){
					$scope.getempproject($scope.assignto);
				}
				$timeout(function(){
					$scope.onfetchmilestone($scope.projectid);
					if($scope.projectid!=0){
						$scope.assignto=data.data[0]['assignto'];
						$scope.onfetchemployee($scope.projectid);
					}
				}, 400); 
				
					$scope.taskdocs=data.data[0]['taskdocs'];
				//$scope.onfetchcommenthistory($id);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate1 = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({projectid: $scope.projectid, milestoneid: $scope.milestoneid, desc:$scope.desc, title:$scope.title, fromdate:$scope.fromdate, todate:$scope.todate, priority:$scope.priority, durationhours: $scope.durationhours, durationminutes: $scope.durationminutes});
		$http({
			url: path+'profile/createtask',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.title="";
				$scope.taskid=0;
				$scope.projectid=0;
				$scope.milestoneid=0;
				$scope.assignto=0;
				$scope.desc="";
				$scope.fromdate="";
				$scope.todate="";
				$scope.priority="";
				$scope.taskstatus="";
				$scope.miscunduct=0;
				$scope.comment="";
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					//$timeout(function(){window.open(path+"profile/tasks/"+$scope.type, "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.timediffest = function($fromdate){
		//alert('#'+$leaveto+'actstart');
		//$scope.resumptiondate="";
		var fromdate=$("#fromdate").datepicker( "getDate" );
		 fromdate.setDate(fromdate.getDate());
		 $('#todate').datepicker("remove");
		$('#todate').datepicker({
			startDate: fromdate
		});
	}
});

/////////////Performance Assign Indicator Ctrl ///////////

app.controller('Feedbackctrl', function($scope, $http, $timeout) {
	$scope.marks="";
	$scope.remark="";
	$scope.employees=[];
	$scope.SendmsgList=[];
	$scope.ReceivemsgList=[];
	$scope.rating=0;
	$scope.date="";
	$scope.emp_subs="";
	$scope.catid=0;
	$scope.category=[];
	$scope.color="grey";
	$scope.color1="grey";
	$scope.showskills=0;
	$scope.onfetch=function(){
	onfetch('profile/getemployeehierarchy',1);
    onfetch('profile/getsendmsg',2);
	onfetch('profile/getreceivemsg',3);
	//onfetch('profile/getfeedbacktemplate',4);
	onfetch('profile/getexternalfeedback',5);
	}
    $('.starrr').starrr({
 
	change: function(e, value){
		//alert('new rating is ' + value)
	$scope.rating=value;
	
 }
})

	$scope.showskill=function($val){
		var values= $("#hide_"+$val).attr('value');
		if(values==$val){
			var elem = document.getElementById("hide_"+$val);
			if (elem.style.display != 'none') { 
				elem.style.display = 'none';
				$("#div_"+$val).text('View details>>');
			}else{
				elem.style.display  = 'block';
				$("#div_"+$val).text('Hide details>>');
			}
		
	
		}
	}
$scope.skills=[{name:""}];
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	$scope.addskill = function($i) {	
		var len = $scope.skills.length-1;
		if($scope.skills[len]['name']=="" ){
			errorMessage("please enter skill");
		}else{
			$scope.skills.insert($i, {name:"" });
		}
	}
    $scope.removeskill = function($i){
		$scope.skills.remove($i);
		if($scope.skills.length == 0) {
			$scope.skills.insert($i, { name:"" });
		}
	}
	$scope.catvalue = function ( $val )
	{//alert($val);
		if($val==1)
		{
			$scope.color="#5ef241";
			$scope.color1="grey";
			$scope.category="Reward";
		}else
		{
			$scope.color="grey";
			$scope.color1="#f63759";
			$scope.category="Penalty";
		}
	}
	
	$scope.onfetchcat =function()
	{
		$scope.category=[];
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 8});
		$http({
			url: path+'setup/getallcategory',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.employees=[];
						$scope.employees=data.data;
						
					}else if($id==2){
						$scope.SendmsgList=[];
						$scope.SendmsgList=data.data;
						//console.log($scope.SendmsgList);
					}else if($id==3){
						$scope.ReceivemsgList=[];
						$scope.ReceivemsgList=data.data;
						//console.log($scope.ReceivemsgList);
					}
					else if($id==4){
						$scope.feedbacksubject=data.data[0]['name'];
						$scope.feedbackmsg=data.data[0]['desc'];
						$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
						//console.log($scope.ReceivemsgList);
					}
					else if($id==5){
						$scope.feedbackarr=data.data;
						
						//console.log($scope.ReceivemsgList);
					}
					var $msg = "Hii sir/mam,<br><br><br>Hope all is going well. Kindly share your feedback for {empname}.<br>Below mention the feedback link. This will help us to evaluate employee's performance.<br><br>{feedbacklink} <br><br> Thanks and Regards <br>{org}";
					$('#desc').data("wysihtml5").editor.setValue($msg);
					
				}				
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});			
	}
	///////////Repeat Rating /////////
	$scope.range = function(count){
		var ratings = []; 
		for (var i = 0; i < count; i++) { 
		ratings.push(i) 
		} 
		return ratings;
	}
	
	$scope.oncreate = function($val)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({ emp_subs: $scope.emp_subs , catid : $scope.catid , rating : $scope.rating, msg : $scope.msg});
		$http({
			url: path+'profile/createfeedback',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/feedback", "_self");}, timeo);
								
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onsendfeedback = function()
	{
		$scope.hastrue=true;
		var JsonData1=angular.toJson($scope.skills);
		var xsrf = $.param({ email: $scope.mailto , name : $scope.name , desig : $scope.desig, company : $scope.company, feedbacksubject : $scope.feedbacksubject, feedbackmsg : document.getElementById('desc').value , datefrom:$scope.datefrom, dateto:$scope.dateto, skills:JsonData1});
		$http({
			url: path+'profile/sendfeedbackrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/feedback", "_self");}, timeo);
								
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onshowdetails = function($id)
	{
		$scope.hastrue=true;
		
		var xsrf = $.param({ id: $id });
		$http({
			url: path+'profile/getfeedbackdetails',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
				$scope.feedbackdata=data.data;
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

app.controller('Feedbackcategoryctrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.categoryname="";
$scope.categoryid=0;
$scope.typeid=8;
//onfetch();
$scope.category=[];
onfetchtype();
$scope.getId = function($id) {
	$scope.categoryid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletecategory/'+$scope.categoryid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.categoryid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


function onfetchtype()
{
	$scope.category=[];
	$scope.hastrue=true;
	
	$http({
        url: path+'setup/getalltype',
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({categoryid: $id});
	$http({
        url: path+'setup/getacategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.categoryname=data.data[0]['name'];
				$scope.desc=data.data[0]['desc'];
				$scope.typeid=data.data[0]['typeid'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/createcategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;				
				$('#categorymodel').modal('hide');
				if($val==1){
			//		window.open(path+"employee/addqualification", "_self");
			//		$timeout(function(){window.open(path+"employee/addqualification", "_self");}, timeo);
				}
				//$timeout(function(){window.open(path+"profile/feedback", "_self");}, timeo);
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({categoryid: $scope.categoryid, categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/updatedecategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;
				
				if($val==1){
					//window.open(path+"setup/category", "_self");
					$timeout(function(){window.open(path+"setup/category", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});

