/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('empapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('documentUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////////////////// Employee Controller Starts From Here  ///////////////////////////////////

app.controller('empformCtrl', function($scope, $http , $timeout) {

$scope.hastrue=false;
$scope.listarray=[];
$scope.otherarray=[];
$scope.bloodgarray=[];
$scope.nationalarray=[];
//$scope.visaarray=[];
$scope.langarray=[];
$scope.religionarray=[];
$scope.funcarray=[];
$scope.countryarray=[];
$scope.cityarray1=[];
$scope.cityarray2=[];
$scope.cityarray3=[];
$scope.cityarray4=[];
$scope.docarray=[];
$scope.cityarray=[];
$scope.realtionarray=[];
$scope.dependantarray=[];
$scope.skillarray=[];
$scope.bankarray=[];
$scope.empskillarray=[];
$scope.familyarray=[];
$scope.rolearray=[];
$scope.trainingarray=[];
$scope.referencearray=[];

$scope.error=false;
$scope.success=false;


$scope.emppic="";
$scope.emp_code="";
$scope.emp_fname="";
$scope.emp_mname="";
$scope.emp_lname="";
$scope.emp_dob="";
$scope.emp_gender="";
$scope.emp_marital="";
$scope.emp_blood_group="";
$scope.emp_nationality="";
$scope.emp_visa_type="";
$scope.emp_known_lang="";
$scope.emp_religion = "";
$scope.emp_functional="";
$scope.emp_contact1="";
$scope.emp_email1="";
$scope.emp_address1="";
$scope.emp_country1="";
$scope.emp_city1="";
$scope.emp_zipcode1="";

$scope.emp_contact2="";
$scope.emp_email2="";
$scope.emp_address2="";
$scope.emp_country2="";
$scope.emp_city2="";
$scope.emp_zipcode2="";

$scope.emp_contact3="";
$scope.emp_email3="";
$scope.emp_address3="";
$scope.emp_country3="";
$scope.emp_city3="";
$scope.emp_zipcode3="";

$scope.emp_country4="";
$scope.emp_city4="";

$scope.employeeid=0;
$scope.emp_experience="";
$scope.airport="";
$scope.emr_name="";
$scope.emr_rel="";
$scope.emr_add="";
$scope.emr_landmark="";
$scope.emr_contact="";
$scope.emr_email="";
$scope.court="";
$scope.sdate="";
$scope.explaination="";
$scope.emp_pos="";
$scope.emailid="";
$scope.orgid=0;
$scope.year=0;
$scope.month=0;
$timeout(function(){
	onfetch('employmentform/other',8);
	onfetch('employmentform/getallbloodgroup',9);
	onfetch('employmentform/index1/NationalityMaster',10);
	//onfetch('employee/getallvisa',11);
	onfetch('employmentform/index1/LanguageMaster',12);
	onfetch('employmentform/getallreligion',13);
	onfetch('employmentform/getallfunctionalarea/'+$scope.orgid,14);
	onfetch('employmentform/getallcountry',15);
	onfetch('employmentform/getalldocument/'+$scope.orgid,19);
	onfetch('employmentform/getallskill/'+$scope.orgid,22);	
}, 1000); 
//onfetch('setup/getalldivision',1);
//onfetch('setup/getallgrade',2);
//onfetch('setup/getalldepartment',3);
//onfetch('setup/getalldesignation',4);
//onfetch('setup/getalllocation',5);
//onfetch('attendance/getallshift',6);
//onfetch('employee/getallempstatus',7);

//onfetch('employmentform/getallemployee',20);
//onfetch('employmentform/getallrelation',21);

//onfetch('employee/getallcreditcard',23);
//onfetch('employee/getallbank',25);
//onfetch('setup/getallrole1',26);

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};

$('input').on('ifToggled', function(event){
  
  if(event.target.name=='chk1')
	$scope.chk1=event.target.checked;
  else if(event.target.name=='chk2')
	$scope.chk2=event.target.checked;
  else if(event.target.name=='chk3')
	$scope.chk3=event.target.checked;
  else if(event.target.name=='chk4')
	$scope.chk4=event.target.checked;
  else if(event.target.name=='chk5')
	$scope.chk5=event.target.checked;
  else if(event.target.name=='chk6')
	$scope.chk6=event.target.checked;
  else if(event.target.name=='chk7')
	$scope.chk7=event.target.checked;
  else if(event.target.name=='in')
	$scope.chk8=event.target.value;
 
});

$scope.workarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addwork = function($i){
	var len = $scope.workarray.length-1;
	if($scope.workarray[len]['name']=="" || $scope.workarray[len]['desig']=="" || $scope.workarray[len]['fdate']=="" || $scope.workarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.workarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
}
$scope.removework = function($i){
	$scope.workarray.remove($i);	
}

$scope.qualificationarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addqualification = function($i){
	var len = $scope.qualificationarray.length-1;
	if($scope.qualificationarray[len]['name']=="" || $scope.qualificationarray[len]['desig']=="" || $scope.qualificationarray[len]['fdate']=="" || $scope.qualificationarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.qualificationarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
	
}
$scope.removequalification = function($i){
	$scope.qualificationarray.remove($i);
	
}

$scope.documentarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.adddocument = function($i){
	var len = $scope.documentarray.length-1;
	if($scope.documentarray[len]['name']=="" || $scope.documentarray[len]['desig']=="" || $scope.documentarray[len]['fdate']=="" || $scope.documentarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.documentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
}
$scope.removedocument = function($i){
	$scope.documentarray.remove($i);
	
}

$scope.empskillarray=[{id:0, skill:0, desc:""}];
$scope.addskill = function($i){
	var len = $scope.empskillarray.length-1;

	if($scope.empskillarray[len]['skill']==0 || $scope.empskillarray[len]['desc']=="" ){
		alert("Please fill all fields");
	}else{
		$scope.empskillarray.insert($i,{id:0, skill:0, desc:""});
	}
}
$scope.removeskill = function($i){
	$scope.empskillarray.remove($i);
	
}

$scope.trainingarray=[{id:0, name:"", fdate:"", tdate:"",certificate:"", desc:""}];
$scope.addtraining = function($i){
	var len = $scope.trainingarray.length-1;
	if($scope.trainingarray[len]['name']=="" || $scope.trainingarray[len]['certificate']=="" || $scope.trainingarray[len]['fdate']=="" || $scope.trainingarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.trainingarray.insert($i,{id:0, name:"", fdate:"", tdate:"",certificate:"", desc:""});
	}
}
$scope.removetraining = function($i){
	$scope.trainingarray.remove($i);
	
}

if($scope.referencearray.length==0){
	$scope.referencearray.insert(0,{id:0, name:"", email:"", contact:"", company:""});
	$scope.referencearray.insert(1,{id:0, name:"", email:"", contact:"", company:""});
}

$scope.dayDiff = function($index){
	if($scope.documentarray[$index]['fdate']!="" && $scope.documentarray[$index]['tdate']!=""){
		var date2 = new Date($scope.documentarray[$index]['fdate']);
		var date1 = new Date($scope.documentarray[$index]['tdate']);
		if(date2<date1){
			var timeDiff = Math.abs(date2.getTime() - date1.getTime());   
			var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
			$scope.documentarray[$index]['desc'] = diffDays;
		}
	}
}

$scope.getcity = function($val)
{
	if($val==16){
		onfetch('employmentform/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('employmentform/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('employmentform/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==23){
		onfetch('employmentform/getallcity/'+$scope.emp_country4,$val);
	}
}
function getcity1($val)
{
	if($val==16){
		onfetch('employmentform/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('employmentform/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('employmentform/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==23){
		onfetch('employmentform/getallcity/'+$scope.emp_country4,$val);
	}
}
  

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				 if($id==8){
					$scope.otherarray=[];
					$scope.otherarray=data.data;
				}else if($id==9){
					$scope.bloodgarray=[];
					$scope.bloodgarray=data.data;
				}else if($id==10){
					$scope.nationalarray=[];
					$scope.nationalarray=data.data;
				}else if($id==11){
					$scope.visaarray=[];
					$scope.visaarray=data.data;
				}else if($id==12){
					$scope.langarray=[];
					$scope.langarray=data.data;
				}else if($id==13){
					$scope.religionarray=[];
					$scope.religionarray=data.data;
				}else if($id==14){
					$scope.funcarray=[];
					$scope.funcarray=data.data;
				}else if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray1=[];
					$scope.cityarray1=data.data;
					
				}else if($id==17){
					$scope.cityarray2=[];
					$scope.cityarray2=data.data;
				}else if($id==18){
					$scope.cityarray3=[];
					$scope.cityarray3=data.data;
				}else if($id==19){
					$scope.docarray=[];
					$scope.docarray=data.data;
				}else if($id==21){
					$scope.relationarray=[];
					$scope.relationarray=data.data;
				}
				else if($id==22){
					$scope.skillarray=[];
					$scope.skillarray=data.data;
				}
				else if($id==23){
					$scope.cityarray4=[];
					$scope.cityarray4=data.data;
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}


$scope.onfetchemployee =function()
{
	$scope.hastrue=true;
	
	//alert($scope.emailid);
	var xsrf = $.param({email:$scope.emailid});
	$http({
        url: path+'employmentform/getaemployee',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.updatests=data.data[0]['updatests'];
				if($scope.updatests == 2){
					$scope.update=true;
				}
				$scope.orgpic=data.data[0]['orglogo'];
				$scope.emppic=data.data[0]['emppic'];
				$scope.emp_fname=data.data[0]['empfname'];
				$scope.emp_mname=data.data[0]['empmname'];
				$scope.emp_lname=data.data[0]['emplname'];
				$scope.emp_dob=data.data[0]['empdob'];
				$scope.emp_gender=data.data[0]['empgender'];
				$scope.emp_marital=data.data[0]['empmarists'];
				$scope.emp_blood_group=data.data[0]['empbloodgroup'];
				$scope.emp_nationality=data.data[0]['empnation'];
				//$scope.emp_visa_type=data.data[0]['empvisa'];
				$scope.emp_known_lang=(data.data[0]['emplang']).split(",");
				$scope.emp_religion = data.data[0]['empreligion'];
				$scope.emp_functional=data.data[0]['empfuncarea'];
				if((data.data[0]['empairport'])!=""){
				var a=data.data[0]['empairport'].split(",");
				$scope.emp_country4=a[0];
				$scope.emp_city4=a[1];
				}
				$scope.emp_contact1=data.data[0]['empcnumber'];
				$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_address1=data.data[0]['empcaddres'];
				$scope.emp_country1=data.data[0]['empccountry'];
				$scope.emp_city1=data.data[0]['empccity'];
				$scope.emp_zipcode1=data.data[0]['empczip'];

				$scope.emp_contact2=data.data[0]['emphnumber'];
				$scope.emp_email2=data.data[0]['emphemail'];
				$scope.emp_address2=data.data[0]['emphaddres'];
				$scope.emp_country2=data.data[0]['emphcountry'];
				$scope.emp_city2=data.data[0]['emphcity'];
				$scope.emp_zipcode2=data.data[0]['emphzip'];

				$scope.emp_contact3=data.data[0]['empenumber'];
				$scope.emp_email3=data.data[0]['empeemail'];
				
				
				$scope.emp_country3=data.data[0]['empecountry'];
				$scope.emp_city3=data.data[0]['empecity'];
				$scope.emp_zipcode3=data.data[0]['empezip'];
				

				getcity1(16);
				getcity1(17);
				getcity1(18);
				getcity1(23);
				
				
					if((data.data[0]['empexp'])!=""){
					var empexp = (data.data[0]['empexp']).split(",");
					$scope.year= Number(empexp[0]);
					$scope.month=Number(empexp[1]);
					}
					
				
				$scope.workarray = data.data[0]['empwork'];
				if($scope.workarray.length==0){
					$scope.workarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.qualificationarray = data.data[0]['empqual'];
				if($scope.qualificationarray.length==0){
					$scope.qualificationarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.documentarray = data.data[0]['empdocarray'];
				if($scope.documentarray.length==0){
					$scope.documentarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				
				$scope.empskillarray = data.data[0]['empskills'];
				if($scope.empskillarray.length==0){
					$scope.empskillarray.insert(0,{id:0, skill:0,desc:""});
				}
				$scope.referencearray = data.data[0]['empreference'];
				if($scope.referencearray.length==0){
					$scope.referencearray.insert(0,{id:0, name:"", email:"", contact:"", company:""});
					$scope.referencearray.insert(1,{id:0, name:"", email:"", contact:"", company:""});
				}
				
				if((data.data[0]['empeaddress']) != null){
					var a1=data.data[0]['empeaddress'].split(',');
					$scope.emr_name=a1[0];
					$scope.emp_address3=a1[1];
				}
				
			}else{
			$scope.error=true;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
////////////////////////////////////////////

$scope.onupdate = function($val)
{
 
$scope.hastrue=true;

var jsonData1=angular.toJson($scope.workarray);
var jsonData2=angular.toJson($scope.qualificationarray);
var jsonData3=angular.toJson($scope.documentarray);
//var jsonData4 = angular.toJson($scope.dependantarray);
var jsonData5 = angular.toJson($scope.empskillarray);
//var jsonData6 = angular.toJson($scope.trainingarray);
var jsonData7 = angular.toJson($scope.referencearray);
//var jsonData8 = angular.toJson($scope.familyarray);

var xsrf = $.param({ emp_fname:$scope.emp_fname, emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang,   emp_gender:$scope.emp_gender,emp_functional:$scope.emp_functional, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3,emp_skill:jsonData5,reference_person:jsonData7,emp_experience:$scope.year+','+$scope.month,airport:$scope.emp_country4+','+$scope.emp_city4});

  $http({
        url: path+'employmentform/updatedeemployee',
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
		data: xsrf
            
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				alert(data.successMsg);
				$scope.success=true;
				
				if($scope.files != ""){
					
					$scope.uploadFile($val);
					
				}
				if($scope.document != ""){
					
					$scope.uploadDocument($val);
					
				}
				
				
				
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


////////on create employee////////
$scope.oncreate = function($val)
{
if($scope.documentarray.length < 2){
	alert("Please fill two document details...");
}
else{	
$scope.hastrue=true;	
var jsonData1=angular.toJson($scope.workarray);
var jsonData2=angular.toJson($scope.qualificationarray);
var jsonData3=angular.toJson($scope.documentarray);
//var jsonData4 = angular.toJson($scope.dependantarray);
var jsonData5 = angular.toJson($scope.empskillarray);
//var jsonData6 = angular.toJson($scope.trainingarray);
var jsonData7 = angular.toJson($scope.referencearray);
//var jsonData8 = angular.toJson($scope.familyarray);
//console.log($scope.candid);
var xsrf = $.param({emp_fname:$scope.emp_fname, emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang,   emp_gender:$scope.emp_gender,emp_functional:$scope.emp_functional, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3,emp_skill:jsonData5,reference_person:jsonData7,emp_experience:$scope.year+','+$scope.month,airport:$scope.emp_country4+','+$scope.emp_city4, orgid:$scope.orgid,onboard:3});

  $http({
        url: path+'employmentform/createdeemployee',
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
		data: xsrf
            
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				//alert(data.successMsg);
				$scope.success=true;
				
				if($scope.files != ""){
					$scope.uploadFile($val);
				}
				if($scope.document != ""){
					$scope.uploadDocument($val);
				}
				alert(data.successMsg);
				location.reload(); 
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
}
	//////////////////image upload///////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	
	var emp=$scope.emailid;
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employmentform/uploadEmployeeImage",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
						$scope.success=true;
				
			
			
		}).
        error(function (data, status, headers, config) {
			alert("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	//////////////////document upload///////////////////
	
	$scope.document = [];

    //listen for the file selected event
    $scope.$on("documentSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
			
        });
    });
	
	
	$scope.uploadDocument = function($val) {
	
	
	var emp=$scope.emailid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employmentform/uploadEmployeeDocument",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//alert(document.getElementById(i).name);
                }
				for (var i = 0; i < $scope.documentarray.length; i++) {
                    if(document.getElementById(i).value!=""){
					var docid=document.getElementById(i).name;
						if(docid!=0){
						formData.append('doc_id'+ i,docid);
						}
						else{
							return;
						}
					}
					
                }
				
				formData.append('emp_id',emp);
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.document }
        }).
        success(function (data, status, headers, config) {
			
						
				$scope.success=true;
			
			
		}).
        error(function (data, status, headers, config) {
			alert("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
});
app.controller('empformCtrl1', function($scope, $http) {

$scope.hastrue=false;
$scope.listarray=[];
$scope.otherarray=[];
$scope.bloodgarray=[];
$scope.nationalarray=[];
//$scope.visaarray=[];
$scope.langarray=[];
$scope.religionarray=[];
$scope.funcarray=[];
$scope.countryarray=[];
$scope.cityarray1=[];
$scope.cityarray2=[];
$scope.cityarray3=[];
$scope.cityarray4=[];
$scope.docarray=[];
$scope.cityarray=[];
$scope.realtionarray=[];
$scope.dependantarray=[];
$scope.skillarray=[];
$scope.bankarray=[];
$scope.empskillarray=[];
$scope.familyarray=[];
$scope.rolearray=[];
$scope.trainingarray=[];
$scope.referencearray=[];

$scope.error=false;
$scope.success=false;


$scope.emppic="";
$scope.emp_code="";
$scope.emp_fname="";
$scope.emp_mname="";
$scope.emp_lname="";
$scope.emp_dob="";
$scope.emp_gender="";
$scope.emp_marital="";
$scope.emp_blood_group="";
$scope.emp_nationality="";
$scope.emp_visa_type="";
$scope.emp_known_lang="";
$scope.emp_religion = "";
$scope.emp_functional="";
$scope.emp_contact1="";
$scope.emp_email1="";
$scope.emp_address1="";
$scope.emp_country1="";
$scope.emp_city1="";
$scope.emp_zipcode1="";

$scope.emp_contact2="";
$scope.emp_email2="";
$scope.emp_address2="";
$scope.emp_country2="";
$scope.emp_city2="";
$scope.emp_zipcode2="";

$scope.emp_contact3="";
$scope.emp_email3="";
$scope.emp_address3="";
$scope.emp_country3="";
$scope.emp_city3="";
$scope.emp_zipcode3="";

$scope.emp_country4="";
$scope.emp_city4="";

$scope.employeeid=0;
$scope.emp_experience="";
$scope.airport="";
$scope.emr_name="";
$scope.emr_rel="";
$scope.emr_add="";
$scope.emr_landmark="";
$scope.emr_contact="";
$scope.emr_email="";
$scope.court="";
$scope.sdate="";
$scope.explaination="";
$scope.emp_pos="";
$scope.emailid="";

$scope.year=0;
$scope.month=0;

//onfetch('setup/getalldivision',1);
//onfetch('setup/getallgrade',2);
//onfetch('setup/getalldepartment',3);
//onfetch('setup/getalldesignation',4);
//onfetch('setup/getalllocation',5);
//onfetch('attendance/getallshift',6);
//onfetch('employee/getallempstatus',7);
onfetch('employmentform/other',8);
onfetch('employmentform/getallbloodgroup',9);
onfetch('employmentform/index1/NationalityMaster',10);
//onfetch('employee/getallvisa',11);
onfetch('employmentform/index1/LanguageMaster',12);
onfetch('employmentform/getallreligion',13);
onfetch('employmentform/getallfunctionalarea',14);
onfetch('employmentform/getallcountry',15);
onfetch('employmentform/getalldocument',19);
//onfetch('employmentform/getallemployee',20);
//onfetch('employmentform/getallrelation',21);
onfetch('employmentform/getallskill',22);
//onfetch('employee/getallcreditcard',23);
//onfetch('employee/getallbank',25);
//onfetch('setup/getallrole1',26);

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};

$('input').on('ifToggled', function(event){
  
  if(event.target.name=='chk1')
	$scope.chk1=event.target.checked;
  else if(event.target.name=='chk2')
	$scope.chk2=event.target.checked;
  else if(event.target.name=='chk3')
	$scope.chk3=event.target.checked;
  else if(event.target.name=='chk4')
	$scope.chk4=event.target.checked;
  else if(event.target.name=='chk5')
	$scope.chk5=event.target.checked;
  else if(event.target.name=='chk6')
	$scope.chk6=event.target.checked;
  else if(event.target.name=='chk7')
	$scope.chk7=event.target.checked;
  else if(event.target.name=='in')
	$scope.chk8=event.target.value;
  
  
  
});

$scope.workarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addwork = function($i){
	var len = $scope.workarray.length-1;
	if($scope.workarray[len]['name']=="" || $scope.workarray[len]['desig']=="" || $scope.workarray[len]['fdate']=="" || $scope.workarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.workarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
}
$scope.removework = function($i){
	$scope.workarray.remove($i+1);	
}

$scope.qualificationarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
$scope.addqualification = function($i){
	var len = $scope.qualificationarray.length-1;
	if($scope.qualificationarray[len]['name']=="" || $scope.qualificationarray[len]['desig']=="" || $scope.qualificationarray[len]['fdate']=="" || $scope.qualificationarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.qualificationarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
	
}
$scope.removequalification = function($i){
	$scope.qualificationarray.remove($i+1);
	
}

$scope.documentarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
//$scope.documentarray.insert(1,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
$scope.adddocument = function($i){
	var len = $scope.documentarray.length-1;
	if($scope.documentarray[len]['name']=="" || $scope.documentarray[len]['desig']=="" || $scope.documentarray[len]['fdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.documentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
	}
}
$scope.removedocument = function($i){
	$scope.documentarray.remove($i+1);
}



$scope.empskillarray=[{id:0, skill:0, desc:""}];
$scope.addskill = function($i){
	var len = $scope.empskillarray.length-1;

	if($scope.empskillarray[len]['skill']==0 || $scope.empskillarray[len]['desc']=="" ){
		alert("Please fill all fields");
	}else{
		$scope.empskillarray.insert($i,{id:0, skill:0, desc:""});
	}
}
$scope.removeskill = function($i){
	$scope.empskillarray.remove($i);
	
}

$scope.trainingarray=[{id:0, name:"", fdate:"", tdate:"",certificate:"", desc:""}];
$scope.addtraining = function($i){
	var len = $scope.trainingarray.length-1;
	if($scope.trainingarray[len]['name']=="" || $scope.trainingarray[len]['certificate']=="" || $scope.trainingarray[len]['fdate']=="" || $scope.trainingarray[len]['tdate']==""){
		alert("Please fill all fields");
	}else{
		$scope.trainingarray.insert($i,{id:0, name:"", fdate:"", tdate:"",certificate:"", desc:""});
	}
}
$scope.removetraining = function($i){
	$scope.trainingarray.remove($i+1);
	
}

$scope.dayDiff = function($index){
	if($scope.documentarray[$index]['fdate']!="" && $scope.documentarray[$index]['tdate']!=""){
		var date2 = new Date($scope.documentarray[$index]['fdate']);
		var date1 = new Date($scope.documentarray[$index]['tdate']);
		if(date2<date1){
			var timeDiff = Math.abs(date2.getTime() - date1.getTime());   
			var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
			$scope.documentarray[$index]['desc'] = diffDays;
		}
	}
}

$scope.getcity = function($val)
{
	if($val==16){
		onfetch('employmentform/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('employmentform/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('employmentform/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==23){
		onfetch('employmentform/getallcity/'+$scope.emp_country4,$val);
	}
}
function getcity1($val)
{
	if($val==16){
		onfetch('employmentform/getallcity/'+$scope.emp_country1,$val);
	}else if($val==17){
		onfetch('employmentform/getallcity/'+$scope.emp_country2,$val);
	}else if($val==18){
		onfetch('employmentform/getallcity/'+$scope.emp_country3,$val);
	}
	else if($val==23){
		onfetch('employmentform/getallcity/'+$scope.emp_country4,$val);
	}
}
  

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				 if($id==8){
					$scope.otherarray=[];
					$scope.otherarray=data.data;
				}else if($id==9){
					$scope.bloodgarray=[];
					$scope.bloodgarray=data.data;
				}else if($id==10){
					$scope.nationalarray=[];
					$scope.nationalarray=data.data;
				}else if($id==11){
					$scope.visaarray=[];
					$scope.visaarray=data.data;
				}else if($id==12){
					$scope.langarray=[];
					$scope.langarray=data.data;
				}else if($id==13){
					$scope.religionarray=[];
					$scope.religionarray=data.data;
				}else if($id==14){
					$scope.funcarray=[];
					$scope.funcarray=data.data;
				}else if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray1=[];
					$scope.cityarray1=data.data;
					
				}else if($id==17){
					$scope.cityarray2=[];
					$scope.cityarray2=data.data;
				}else if($id==18){
					$scope.cityarray3=[];
					$scope.cityarray3=data.data;
				}else if($id==19){
					$scope.docarray=[];
					$scope.docarray=data.data;
				}else if($id==21){
					$scope.relationarray=[];
					$scope.relationarray=data.data;
				}
				else if($id==22){
					$scope.skillarray=[];
					$scope.skillarray=data.data;
				}
				else if($id==23){
					$scope.cityarray4=[];
					$scope.cityarray4=data.data;
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}


$scope.onfetchemployee =function()
{
	$scope.hastrue=true;
	//alert($scope.emailid);
	var xsrf = $.param({email:$scope.emailid});
	$http({
        url: path+'employmentform/getaemployee',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.updatests=data.data[0]['updatests'];
				if($scope.updatests == 2){
					$scope.update=true;
				}
				$scope.orgpic=data.data[0]['orglogo'];
				$scope.emppic=data.data[0]['emppic'];
				$scope.emp_fname=data.data[0]['empfname'];
				$scope.emp_mname=data.data[0]['empmname'];
				$scope.emp_lname=data.data[0]['emplname'];
				$scope.emp_dob=data.data[0]['empdob'];
				$scope.emp_gender=data.data[0]['empgender'];
				$scope.emp_marital=data.data[0]['empmarists'];
				$scope.emp_blood_group=data.data[0]['empbloodgroup'];
				$scope.emp_nationality=data.data[0]['empnation'];
				//$scope.emp_visa_type=data.data[0]['empvisa'];
				$scope.emp_known_lang=(data.data[0]['emplang']).split(",");
				$scope.emp_religion = data.data[0]['empreligion'];
				$scope.emp_functional=data.data[0]['empfuncarea'];
				if((data.data[0]['empairport'])!=""){
				var a=data.data[0]['empairport'].split(",");
				$scope.emp_country4=a[0];
				$scope.emp_city4=a[1];
				}
				$scope.emp_contact1=data.data[0]['empcnumber'];
				$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_address1=data.data[0]['empcaddres'];
				$scope.emp_country1=data.data[0]['empccountry'];
				$scope.emp_city1=data.data[0]['empccity'];
				$scope.emp_zipcode1=data.data[0]['empczip'];

				$scope.emp_contact2=data.data[0]['emphnumber'];
				$scope.emp_email2=data.data[0]['emphemail'];
				$scope.emp_address2=data.data[0]['emphaddres'];
				$scope.emp_country2=data.data[0]['emphcountry'];
				$scope.emp_city2=data.data[0]['emphcity'];
				$scope.emp_zipcode2=data.data[0]['emphzip'];

				$scope.emp_contact3=data.data[0]['empenumber'];
				$scope.emp_email3=data.data[0]['empeemail'];
				
				
				$scope.emp_country3=data.data[0]['empecountry'];
				$scope.emp_city3=data.data[0]['empecity'];
				$scope.emp_zipcode3=data.data[0]['empezip'];
				getcity1(16);
				getcity1(17);
				getcity1(18);
				getcity1(23);
					if((data.data[0]['empexp'])!=""){
					var empexp = (data.data[0]['empexp']).split(",");
					$scope.year= Number(empexp[0]);
					$scope.month=Number(empexp[1]);
					}
					
				
				$scope.workarray = data.data[0]['empwork'];
				if($scope.workarray.length==0){
					$scope.workarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.qualificationarray = data.data[0]['empqual'];
				if($scope.qualificationarray.length==0){
					$scope.qualificationarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.documentarray = data.data[0]['empdocarray'];
				if($scope.documentarray.length==0){
					$scope.documentarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				
				$scope.empskillarray = data.data[0]['empskills'];
				if($scope.empskillarray.length==0){
					$scope.empskillarray.insert(0,{id:0, skill:0,desc:""});
				}
				$scope.referencearray = data.data[0]['empreference'];
				if($scope.referencearray.length==0){
					$scope.referencearray.insert(0,{id:0, name:"", email:"", contact:"", company:""});
					$scope.referencearray.insert(1,{id:0, name:"", email:"", contact:"", company:""});
				}
				
				if((data.data[0]['empeaddress']) != null){
					var a1=data.data[0]['empeaddress'].split(',');
					$scope.emr_name=a1[0];
					$scope.emp_address3=a1[1];
				}
				
			}else{
			$scope.error=true;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	if($scope.referencearray.length==0){
	$scope.referencearray.insert(0,{id:0, name:"", email:"", contact:"", company:""});
	$scope.referencearray.insert(1,{id:0, name:"", email:"", contact:"", company:""});
	}
////////////////////////////////////////////

$scope.onupdate = function($val)
{
 
$scope.hastrue=true;

var jsonData1=angular.toJson($scope.workarray);
var jsonData2=angular.toJson($scope.qualificationarray);
var jsonData3=angular.toJson($scope.documentarray);
//var jsonData4 = angular.toJson($scope.dependantarray);
var jsonData5 = angular.toJson($scope.empskillarray);
//var jsonData6 = angular.toJson($scope.trainingarray);
var jsonData7 = angular.toJson($scope.referencearray);
//var jsonData8 = angular.toJson($scope.familyarray);

var xsrf = $.param({ emp_fname:$scope.emp_fname, emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang,   emp_gender:$scope.emp_gender,emp_functional:$scope.emp_functional, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3,emp_skill:jsonData5,reference_person:jsonData7,emp_experience:$scope.year+','+$scope.month,airport:$scope.emp_country4+','+$scope.emp_city4});

  $http({
        url: path+'employmentform/updatedeemployee',
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
		data: xsrf
      }).success(function (data, status, headers, config) {
			if(data.status){
				//alert("success");
				$scope.success=true;
				if($scope.files != ""){
					$scope.uploadFile($val);
				}
				if($scope.document != ""){
					$scope.uploadDocument($val);
				}
			}else{
				//alert("dfds");
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


////////on create employee////////
$scope.oncreate = function($val)
{
if($scope.documentarray.length < 2){
	alert("Please fill two document details...");
}
else{	
$scope.hastrue=true;	
var jsonData1=angular.toJson($scope.workarray);
var jsonData2=angular.toJson($scope.qualificationarray);
var jsonData3=angular.toJson($scope.documentarray);
//var jsonData4 = angular.toJson($scope.dependantarray);
var jsonData5 = angular.toJson($scope.empskillarray);
//var jsonData6 = angular.toJson($scope.trainingarray);
var jsonData7 = angular.toJson($scope.referencearray);
//var jsonData8 = angular.toJson($scope.familyarray);
console.log($scope.candid);
var xsrf = $.param({emp_fname:$scope.emp_fname, emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang,   emp_gender:$scope.emp_gender,emp_functional:$scope.emp_functional, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3,emp_skill:jsonData5,reference_person:jsonData7,emp_experience:$scope.year+','+$scope.month,airport:$scope.emp_country4+','+$scope.emp_city4,candidateid:$scope.candid,onboard:1});

  $http({
        url: path+'employmentform/createdeemployee',
        method: "POST",
        headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
		data: xsrf
            
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				//alert(data.successMsg);
				$scope.success=true;
				
				if($scope.files != ""){
					$scope.uploadFile($val);
				}
				if($scope.document != ""){
					$scope.uploadDocument($val);
				}
				
				
				
			}else{
				alert(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            alert("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
}
	
	//////////////////image upload///////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	
	var emp=$scope.emailid;
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employmentform/uploadEmployeeImage",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			
						$scope.success=true;
				
			
			
		}).
        error(function (data, status, headers, config) {
			alert("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	//////////////////document upload///////////////////
	
	$scope.document = [];

    //listen for the file selected event
    $scope.$on("documentSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
			
        });
    });
	
	
	$scope.uploadDocument = function($val) {
		
	var emp=$scope.emailid;
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employmentform/uploadEmployeeDocument",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//alert(document.getElementById(i).name);
                }
				for (var i = 0; i < $scope.documentarray.length; i++) {
                    if(document.getElementById(i).value!=""){
					var docid=document.getElementById(i).name;
						if(docid!=0){
						formData.append('doc_id'+ i,docid);
						}
						else{
							return;
						}
					}
					
					
                }
				
				
				formData.append('emp_id',emp);
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.document }
        }).
        success(function (data, status, headers, config) {
			
						
				$scope.success=true;
			
			
		}).
        error(function (data, status, headers, config) {
			alert("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
});