/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('empapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('myPostRepeatDirective', function() {
	return function(scope, element, attrs) {
		if (scope.$last){
			// iteration is complete, do whatever post-processing
			// is necessary
			jQuery.fn.multiselect = function() {
				$(this).each(function() {
					var checkboxes = $(this).find("input:checkbox");
					checkboxes.each(function() {
						var checkbox = $(this);
						// Highlight pre-selected checkboxes
						if (checkbox.prop("checked"))
						checkbox.parent().addClass("multiselect-on");
						// Highlight checkboxes that the user selects
						checkbox.click(function() {
							if (checkbox.prop("checked"))
							checkbox.parent().addClass("multiselect-on");
							else
							checkbox.parent().removeClass("multiselect-on");
						});
					});
				});
			};
			$(function() {
				 $(".multiselect").multiselect();
			});
		}
	};
});

app.directive('fileUpload', function () {
	return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('documentUpload', function () {
	return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("documentSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('companyUpload', function () {
	return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("companySelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('visaUpload', function () {
	return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("visaSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});
app.directive('passportUpload', function () {
	return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("passportSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

app.directive('myPostRepeatDirective', function() {
	return function(scope, element, attrs) {
		if (scope.$last){
			// iteration is complete, do whatever post-processing
			// is necessary
			jQuery.fn.multiselect = function() {
				$(this).each(function() {
					var checkboxes = $(this).find("input:checkbox");
					checkboxes.each(function() {
						var checkbox = $(this);
						// Highlight pre-selected checkboxes
						if (checkbox.prop("checked"))
						checkbox.parent().addClass("multiselect-on");
						// Highlight checkboxes that the user selects
						checkbox.click(function() {
							if (checkbox.prop("checked"))
							checkbox.parent().addClass("multiselect-on");
							else
							checkbox.parent().removeClass("multiselect-on");
						});
					});
				});
			};
			$(function() {
				 $(".multiselect").multiselect();
			});
		}
	};
});
/////////////////////////// Skill Controller Starts From Here  ///////////////////////////////////
app.controller('skillCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.category=[];
	$scope.skillid=0;
	$scope.catid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.skillid=$id;
	}
	$scope.ondelete =function(){
		//$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deleteskill/'+$scope.skillid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.skillid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	function log(text){
        //$('#consoleOutput').append('<p>'+text+'</p>')
    }
	$scope.onfetchcat =function() {
		$scope.category=[];
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 2});
		$http({
			url: path+'setup/getallcategory',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchskill =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({skillid: $id});
		$http({
			url: path+'employee/getaskill',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.skillname=data.data[0]['name'];
				$scope.skillcode=data.data[0]['code'];
				$scope.catid=data.data[0]['catid'];
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({skillname: $scope.skillname, catid: $scope.catid, skillcode:$scope.skillcode});
		$http({
			url: path+'employee/createskill',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.skillcode="";
				$scope.skillname="";
				$scope.catid=0;
				$scope.skillid=0;
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"employee/skill", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({skillid: $scope.skillid, skillname: $scope.skillname, catid: $scope.catid, skillcode:$scope.skillcode});
		$http({
			url: path+'employee/updatedeskill',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.skillname="";
				$scope.skillcode="";
				$scope.catid=0;
				$scope.skillid=0;
				if($val==1){
					//window.open(path+"employee/skill", "_self");
					$timeout(function(){window.open(path+"employee/skill", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Employee Status Controller Starts From Here  ///////////////////////////////////
app.controller('empstatusCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.empstatusid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.empstatusid=$id;
	}
	$scope.ondelete =function(){
		$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deleteempstatus/'+$scope.empstatusid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.empstatusid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchempstatus =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({empstatusid: $id});
		$http({
			url: path+'employee/getaempstatus',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.empstatusname=data.data[0]['name'];
				$scope.empstatuscode=data.data[0]['code'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({empstatusname: $scope.empstatusname, empstatuscode:$scope.empstatuscode});
		$http({
			url: path+'employee/createempstatus',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.empstatusname="";
				$scope.empstatuscode="";
				$scope.empstatusid=0;
				if($val==1){
					//window.open(path+"employee/empstatus", "_self");
					$timeout(function(){window.open(path+"employee/empstatus", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({empstatusid: $scope.empstatusid, empstatusname: $scope.empstatusname, empstatuscode:$scope.empstatuscode});
		$http({
			url: path+'employee/updatedeempstatus',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.empstatusname="";
				$scope.empstatuscode="";
				$scope.empstatusid=0;
				if($val==1){
					//window.open(path+"employee/empstatus", "_self");
					$timeout(function(){window.open(path+"employee/empstatus", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Qualification Controller Starts From Here  //////////////////////
app.controller('qualificationCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.category=[];
	$scope.qualificationid=0;
	$scope.catid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.qualificationid=$id;
	}
	$scope.ondelete =function() {
		$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletequalification/'+$scope.qualificationid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.qualificationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchcat =function(){
		$scope.category=[];
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 3});
		$http({
			url: path+'setup/getallcategory',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchqualification =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({qualificationid: $id});
		$http({
			url: path+'employee/getaqualification',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.qualificationname=data.data[0]['name'];
				$scope.qualificationcode=data.data[0]['code'];
				$scope.catid=data.data[0]['catid'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({qualificationname: $scope.qualificationname, catid: $scope.catid, qualificationcode: $scope.qualificationcode});
		$http({
			url: path+'employee/createqualification',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.qualificationcode="";
				$scope.qualificationname="";
				$scope.catid=0;
				$scope.qualificationid=0;
				if($val==1){
					//window.open(path+"employee/qualification", "_self");
					$timeout(function(){window.open(path+"employee/qualification", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({qualificationid: $scope.qualificationid, qualificationname: $scope.qualificationname, catid: $scope.catid, qualificationcode:$scope.qualificationcode});
		$http({
			url: path+'employee/updatedequalification',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.qualificationname="";
				$scope.qualificationcode="";
				$scope.catid=0;
				$scope.qualificationid=0;
				if($val==1){
					//window.open(path+"employee/qualification", "_self");
					$timeout(function(){window.open(path+"employee/qualification", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Document Controller Starts From Here  /////////////////////////
app.controller('documentCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.doc_type=0;
	$scope.documentid=0;
	$scope.doctypearray=[];
	$scope.issuedate="";
	$scope.expiredate="";
	/////////////////////////////
	onfetch();
	function onfetch(){
		//$scope.hastrue=true;
		$http({
			url: path+'employee/getDocType',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				 //successMessage(data.successMsg);
				 //table.draw();
				 $scope.doctypearray=data.data;
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.getId = function($id) {
		$scope.documentid=$id;
	}
	$scope.ondelete =function() {
		$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletedocument/'+$scope.documentid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.documentid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchdocument =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({documentid: $id});
		$http({
			url: path+'employee/getadocument',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.documentname=data.data[0]['name'];
				$scope.documentcode=data.data[0]['code'];
				$scope.doc_type=data.data[0]['doctype'];
				$scope.issuedate=data.data[0]['issuedate'];
				$scope.expiredate=data.data[0]['expiredate'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val,$doctypefind) {
		$scope.hastrue=true;
		//alert($doctypefind);
		$scope.doctypefind=$doctypefind;
		if($scope.doctypefind=='emp'){
			//$scope.issuedate="";
			//$scope.expiredate="";
			$scope.doc_type=1;
		}else if($scope.doctypefind=='org'){
			$scope.doc_type=2;
		}
		var xsrf = $.param({documentname: $scope.documentname, documentcode: $scope.documentcode, doctype: $scope.doc_type,issuedate: $scope.issuedate,expiredate: $scope.expiredate});
		$http({
			url: path+'employee/createdocument',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.documentname="";
				$scope.documentcode="";
				$scope.documentid=0;
				if($val==0){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0; 
				}if($val==1){
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/companydoclibrary", "_self");}, timeo); 
				}if($val==2){
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/document", "_self");}, timeo); 
				}if($val==3){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0;
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdateemp = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({documentid: $scope.documentid, documentname: $scope.documentname, documentcode: $scope.documentcode, doctype: $scope.doc_type});
		$http({
			url: path+'employee/updatededocumentemp',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				//$scope.documentname="";
				//$scope.documentcode="";
				//$scope.documentid=0;
				if($val==1){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0;
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/companydoclibrary", "_self");}, timeo); 
				}if($val==2){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0;
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/document", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({documentid: $scope.documentid, documentname: $scope.documentname, documentcode: $scope.documentcode, doctype: $scope.doc_type, issuedate:$scope.issuedate, expiredate:$scope.expiredate});
		$http({
			url: path+'employee/updatededocument',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				//$scope.documentname="";
				//$scope.documentcode="";
				//$scope.documentid=0;
				//$scope.issuedate="";
				//$scope.expiredate="";
				if($val==1){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0;
					$scope.issuedate="";
					$scope.expiredate="";
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/companydoclibrary", "_self");}, timeo); 
				}if($val==2){
					$scope.documentname="";
					$scope.documentcode="";
					$scope.documentid=0;
					$scope.issuedate="";
					$scope.expiredate="";
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/document", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Visa Controller Starts From Here  /////////////////////////////
app.controller('visaCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.visaid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.visaid=$id;
	}
	$scope.ondelete =function() {
		$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletevisa/'+$scope.visaid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.visaid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.deletecat =function() {
		$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletevisacat/'+$scope.visaid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.visaid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchvisa =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({visaid: $id});
		$http({
			url: path+'employee/getavisa',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.visaname=data.data[0]['name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchvisacat =function($id){
		$scope.hastrue=true;
		var xsrf = $.param({visaid: $id});
		$http({
			url: path+'employee/getvisacat',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.visaname=data.data[0]['name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({visaname: $scope.visaname});
		$http({
			url: path+'employee/createvisa',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.visaname="";
				$scope.visaid=0;
				if($val==1){
					//window.open(path+"employee/visa", "_self");
					$timeout(function(){window.open(path+"employee/visa", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.createvisacat = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({visaname: $scope.visaname});
		$http({
			url: path+'employee/createvisacat',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//alert(data.status);
			if(data.status){
				successMessage(data.successMsg);
				$scope.visaname="";
				$scope.visaid=0;
				if($val==1){
					//window.open(path+"employee/visa", "_self");
					$timeout(function(){window.open(path+"employee/visaCategory", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({visaid: $scope.visaid, visaname: $scope.visaname});
		$http({
			url: path+'employee/updatedevisa',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.visaname="";
				$scope.visaid=0;
				if($val==1){
					$timeout(function(){window.open(path+"employee/visa", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
			$scope.hastrue=false;
		});
	}
	$scope.onupdatecat = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({visaid: $scope.visaid, visaname: $scope.visaname});
		$http({
			url: path+'employee/updatevisacat',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.visaname="";
				$scope.visaid=0;
				if($val==1){
					$timeout(function(){window.open(path+"employee/visaCategory", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
			$scope.hastrue=false;
		});
	}
});
/////////////////////Functionalarea Controller Starts From Here  ///////////////
app.controller('functionalareaCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.functionalareaid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.functionalareaid=$id;
	}
	$scope.ondelete =function() {
		//$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletefunctionalarea/'+$scope.functionalareaid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.functionalareaid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchfunctionalarea =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({functionalareaid: $id});
		$http({
			url: path+'employee/getafunctionalarea',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.functionalareaname=data.data[0]['name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val)	{
		$scope.hastrue=true;
		var xsrf = $.param({functionalareaname: $scope.functionalareaname});
		$http({
			url: path+'employee/createfunctionalarea',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.functionalareaname="";				
				$scope.functionalareaid=0;
				if($val==1){
					//window.open(path+"employee/functionalarea", "_self");
					$timeout(function(){window.open(path+"employee/functionalarea", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({functionalareaid: $scope.functionalareaid, functionalareaname: $scope.functionalareaname});
		$http({
			url: path+'employee/updatedefunctionalarea',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.functionalareaname="";
				$scope.functionalareaid=0;
				if($val==1){
					//window.open(path+"employee/functionalarea", "_self");
					$timeout(function(){window.open(path+"employee/functionalarea", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Relation Controller Starts From Here  ////////////////////////
app.controller('relationCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.relationid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.relationid=$id;
	}
	$scope.ondelete =function() {
		//$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deleterelation/'+$scope.relationid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.relationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchrelation =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({relationid: $id});
		$http({
			url: path+'employee/getarelation',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.relationname=data.data[0]['name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val)	{
		if($scope.relationname=="") {
			errorMessage("Field cannot left blank");
			return false;
		}
		$scope.hastrue=true;
		var xsrf = $.param({relationname: $scope.relationname});
		$http({
			url: path+'employee/createrelation',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.relationname="";
				$scope.relationid=0;
				if($val==1){
					//window.open(path+"employee/relation", "_self");
					$timeout(function(){window.open(path+"employee/relation", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({relationid: $scope.relationid, relationname: $scope.relationname});
		$http({
			url: path+'employee/updatederelation',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.relationname="";
				$scope.relationid=0;
				if($val==1){
					//window.open(path+"employee/relation", "_self");
					$timeout(function(){window.open(path+"employee/relation", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Credit Card Controller Starts From Here  ///////////////////
app.controller('CreditcardCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.creditcardid=0;
	$scope.onfetchcreditcard =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({creditcardid: $id});
		$http({
			url: path+'employee/getacreditcard',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.creditcardname=data.data[0]['name'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({creditcardname: $scope.creditcardname});
  $http({
        url: path+'employee/createcreditcard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.creditcardname="";				
				$scope.creditcardid=0;
				
				if($val==1){
					//window.open(path+"employee/creditcard", "_self");
					$timeout(function(){window.open(path+"employee/creditcard", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({creditcardid: $scope.creditcardid, creditcardname: $scope.creditcardname});
  $http({
        url: path+'employee/updatedecreditcard',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.creditcardname="";
				$scope.creditcardid=0;
				if($val==1){
					//window.open(path+"employee/creditcard", "_self");
					$timeout(function(){window.open(path+"employee/creditcard", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});
/////////////////////////// BANK Controller Starts From Here  //////////////////////////
app.controller('BankCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.bankid=0;
	////////////////////////////
	$scope.getId = function($id) {
		$scope.bankid=$id;
	}
	$scope.ondelete =function() {
		//$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deletebank/'+$scope.bankid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.bankid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchbank =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({bankid: $id});
		$http({
			url: path+'employee/getabank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.bankname=data.data[0]['name'];
				$scope.bankcode=data.data[0]['code'];
				$scope.bank_desc=data.data[0]['description'];
				$scope.agent_id=data.data[0]['agent_id'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({bankname: $scope.bankname,bank_desc: $scope.bank_desc, bankcode:$scope.bankcode, agent_id:$scope.agent_id});
		$http({
			url: path+'employee/createbank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.bankname="";
				$scope.bankcode="";
				$scope.bankid=0;
				if($val==1){
					//window.open(path+"employee/bank", "_self");
					$timeout(function(){window.open(path+"employee/bank", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val){
		$scope.hastrue=true;
		var xsrf = $.param({bankid: $scope.bankid, bankname: $scope.bankname,bank_desc: $scope.bank_desc, bankcode:$scope.bankcode, agent_id:$scope.agent_id});
		$http({
			url: path+'employee/updatedebank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.bankname="";
				$scope.bankid=0;
				$scope.bankcode="";
				$scope.bank_desc="";
				$scope.agent_id="";
				if($val==1){
					//window.open(path+"employee/bank", "_self");
					$timeout(function(){window.open(path+"employee/bank", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Insurance Controller Starts From Here  /////////////////
app.controller('InsuranceCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.insuranceid=0;
	/////////////////////////////
	$scope.getId = function($id) {
		$scope.insuranceid=$id;
	}
	$scope.ondelete =function() {
		//$scope.rolearr=[];
		//$scope.hastrue=true;
		$http({
			url: path+'employee/deleteinsurance/'+$scope.insuranceid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.insuranceid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchinsurance =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({insuranceid: $id});
		$http({
			url: path+'employee/getainsurance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.insurancename=data.data[0]['name'];
				$scope.insurance_desc=data.data[0]['description'];
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.oncreate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({insurancename: $scope.insurancename,insurance_desc: $scope.insurance_desc});
		$http({
			url: path+'employee/createinsurance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.insurancename="";
				$scope.insuranceid=0;
				if($val==1){
					//window.open(path+"employee/insurance", "_self");
					$timeout(function(){window.open(path+"employee/insurance", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onupdate = function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({insuranceid: $scope.insuranceid, insurancename: $scope.insurancename,insurance_desc: $scope.insurance_desc});
		$http({
			url: path+'employee/updatedeinsurance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.insurancename="";
				$scope.insuranceid=0;
				$scope.insurance_desc="";
				if($val==1){
					//window.open(path+"employee/insurance", "_self");
					$timeout(function(){window.open(path+"employee/insurance", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});
/////////////////////////// Employee fiter Controller Starts From Here  /////////////////
app.controller('employeeFilter', function($scope, $http, $timeout) {
	$scope.divisionarray=[];
	$scope.gradearray=[];
	$scope.departarray=[];
	$scope.channelarray=[];
	$scope.desigarray=[];
	$scope.divisionsupplierarray=[];
	$scope.locationarray=[];
	$scope.costcenterarray=[];
	$scope.cocenterarray=[];
	/*$scope.division=0;
    $scope.department=0;
	$scope.channel=0;
	$scope.designation=0;
	$scope.grade=0;*/
	
	onfetch('setup/getalldivision',1);
	onfetch('setup/getallgrade',2);
	onfetch('setup/getalldepartment',3);
	onfetch('setup/getalldesignation',4);
	onfetch('setup/getallchannel',5);
	onfetch('setup/getalllocation',6);
	onfetch('setup/getallcostcentre',7);
	onfetch('setup/getallcocentre',8);


	
	////////////QR Code////////////
	$scope.getEmpDetailQRCode= function($empid) {
		
		//$scope.onfetchuser($UserId);
		//alert($empid);
		$scope.GetEmpDetailsQRCode($empid);
	}
	/////////// Generate QR Code with details //////
$scope.GetEmpDetailsQRCode =function($empid)
{
	$scope.hastrue=true;
	var xsrf = $.param({empid: $empid});
	$http({
        url: path+'employee/getasalary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.companyname=data.data[0]['companyname'];
				$scope.name=data.data[0]['name'];
				$scope.empdesig=data.data[0]['empdesig'];
				$scope.empdept=data.data[0]['empdept'];
				$scope.empcode=data.data[0]['empcode'];
				$scope.empshift=data.data[0]['empshift'];
				$scope.shiftTimein=data.data[0]['shiftTimein'];
				$scope.shiftTimeout=data.data[0]['shiftTimeout'];
				$scope.passwordenc=data.data[0]['passwordenc'];
				$scope.usermob=data.data[0]['usermob'];
				$timeout(function(){
					
					var userpass=$scope.passwordenc;
				var usermob1=$scope.usermob;
				console.log($scope.usermob);
				console.log($scope.passwordenc);
				$('#qrCode').attr('src',"https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl="+$scope.usermob+""+$scope.passwordenc+"&choe=UTF-8");
				$("#genQR").modal('show');
				}, 500);
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$scope.getId = function($id) {
	//alert($id);
	$scope.restoreid=$id;
	$scope.deleteid=$id;
	$scope.emppermanentdeleteid=$id;
}

$scope.empRestore =function()
{
	//alert($scope.restoreid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/restoreemployee/'+$scope.restoreid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.restoreid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.deleteemployee =function()
{
	//alert($scope.deleteid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteemployee/'+$scope.deleteid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
				  window.location.href = path+'employee/deleteEmpList';
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.deleteid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.empDeletePermanent =function()
{
	//alert($scope.emppermanentdeleteid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/empDeletePermanent/'+$scope.emppermanentdeleteid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.emppermanentdeleteid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
///////////////////////////////////////////////////////////////////////////////////////////
	
	function onfetch($val, $id) {
		
	$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==1){
					$scope.divisionarray=[];
					$scope.divisionarray=data.data;
					//$scope.divisionarray.insert(0,{id:0,name:"------All-------"});
					//$scope.divisionarray.insert(0,{id:0,name:"Select Division"});
				}else if($id==2){
					$scope.gradearray=[];
					$scope.gradearray=data.data;
				//	$scope.gradearray.insert(0,{id:0,name:"------All-------"});

				}else if($id==3){
					$scope.departarray=[];
					$scope.departarray=data.data;
				//	$scope.departarray.insert(0,{id:0,name:"------All-------"});

				}else if($id==4){
					$scope.desigarray=[];
					$scope.desigarray=data.data;
				//	$scope.desigarray.insert(0,{id:0,name:"------All-------"});

				}else if($id==5){
					$scope.channelarray=[];
					$scope.channelarray=data.data;
				//	$scope.channelarray.insert(0,{id:0,name:"------All-------"});

				}else if($id==6){
					$scope.locationarray=[];
					$scope.locationarray=data.data;
				//	$scope.channelarray.insert(0,{id:0,name:"------All-------"});

				}else if($id==7){
					$scope.costcenterarray=[];
					$scope.costcenterarray=data.data;
				//	$scope.channelarray.insert(0,{id:0,name:"------All-------"});

				}else if($id==8){
					$scope.cocenterarray=[];
					$scope.cocenterarray=data.data;
				//	$scope.channelarray.insert(0,{id:0,name:"------All-------"});

				}
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onchangedate = function() {
		var datefrom=$( '#gratuitymonth' ).datepicker( "getDate" );
		var temp= new Date(datefrom);
		var gDay=temp.getDate();
		var gMonth=temp.getMonth()+1;
		var gYear=temp.getFullYear();
		$scope.gratuitydate=gYear+"-"+gMonth+"-"+gDay;
	}
});



/////////////////////////// Employee Controller Starts From Here  //////////////////////
app.controller('employeeCtrl', function($scope, $http, $timeout) {
	$scope.hastrue=false;
	$scope.listarray=[];
	$scope.divisionarray=[];
	$scope.gradearray=[];
	$scope.departarray=[];
	$scope.costcentrearray=[];
	$scope.channelarray=[];
	$scope.desigarray=[];
	$scope.locationarray=[];
	$scope.shiftarray=[];
	$scope.empstatusarray=[];
	$scope.otherarray=[];
	$scope.bloodgarray=[];
	$scope.nationalarray=[];
	$scope.visaarray=[];
	$scope.visacatarray=[];
	$scope.langarray=[];
	$scope.religionarray=[];
	$scope.funcarray=[];
	$scope.countryarray=[];
	$scope.cityarray1=[];
	$scope.cityarray2=[];
	$scope.cityarray3=[];
	$scope.cityarray4=[];
	$scope.docarray=[];

	$scope.cityarray=[];
	$scope.workdaysarray=[];
	$scope.reportingtoarray=[];
	$scope.realtionarray=[];

	$scope.skillarray=[];
	$scope.bankarray=[];
	$scope.empskillarray=[];
	$scope.creditcardarray=[];
	$scope.insurancearray=[];
	$scope.referencearray=[];
	$scope.familyarray=[];
	$scope.rolearray=[];
	$scope.salaryarray=[];
	$scope.modepayarray=[];
	$scope.geocenterarray=[];
	$scope.salarytypedetails=[];

	$scope.notificationtype="";
	$scope.emppic="";
	$scope.emp_code="";
	$scope.emp_report_to="";
	$scope.emp_division="";
	$scope.emp_grade="";
	$scope.emp_depart="";
	$scope.emp_channel="";
	$scope.emp_desig="";
	$scope.emp_location="";
	$scope.emp_shift="";
	$scope.emp_sts="";
	$scope.emp_leave="";
	$scope.chk1 = false; 
	$scope.chk2 = false;
	$scope.chk3 = false;
	$scope.chk4 = false; 
	$scope.chk5 = false;
	$scope.chk6 = false;
	$scope.chk7 = false;
	$scope.chk8 = false;
	$scope.chk9 = false;

	$scope.emp_fname="";
	$scope.emp_lname="";
	$scope.emp_dob="";
	$scope.emp_gender="";
	$scope.emp_marital="";
	$scope.emp_blood_group="";
	$scope.emp_nationality="";
	$scope.emp_visa_type="";
	$scope.emp_visa_cat="";
	$scope.emp_known_lang="";
	$scope.emp_religion = "";
	$scope.emp_functional="";
	$scope.emp_doj="";
	$scope.emp_doc="";
	$scope.emp_contact1="";
	$scope.emp_email1="";
	$scope.emp_address1="";
	$scope.emp_country1="";
	$scope.emp_city1="";
	$scope.emp_zipcode1="";

	$scope.emp_contact2="";
	$scope.emp_email2="";
	$scope.emp_address2="";
	$scope.emp_country2="";
	$scope.emp_city2="";
	$scope.emp_zipcode2="";

	$scope.emp_contact3="";
	$scope.emp_email3="";
	$scope.emp_address3="";
	$scope.emp_country3="";
	$scope.emp_city3="";
	$scope.emp_zipcode3="";
	$scope.emr_name="";

	$scope.emp_country4="";
	$scope.emp_city4="";
	$scope.employeeid=0;
	$scope.emp_workdays="";
	$scope.salaryctc=0;
	$scope.paypattern="";
	$scope.bankname="";
	$scope.agent_id="";
	$scope.bankifsccode="";
	$scope.bankaccountnumber="";
	$scope.bankaddress="";
	$scope.emp_type="";
	$scope.creditcardid="";
	$scope.creditcard_no="";
	$scope.credit_issuedate="";
	$scope.credit_validdate="";
	$scope.credit_limit="";
	$scope.credit_desc="";
	$scope.insuranceid="";
	$scope.insurance_period="";
	$scope.issue_amt="";
	$scope.premium_amt="";
	$scope.insurance_validdate="";
	$scope.insurance_desc="";
	$scope.emp_experience="";
	$scope.cmp_email="";
	$scope.emp_role="";
	$scope.personal_no="";

	$scope.airport="";
	$scope.immigration="";
	$scope.visa="";
	$scope.visacost="";
	$scope.airticket="";
	$scope.onceinyear="";
	$scope.onceinmonth=0;
	$scope.ticketclass="";
	$scope.iatafare=0;
	$scope.ticketamt="";
	$scope.adult=0;
	$scope.child=0;
	$scope.infant=0;
	$scope.instructions="";
	$scope.provision=0;
	$scope.validdate="";
	$scope.nomonths="";
	$scope.salincreamentper="";
	$scope.issuedate="";
	$scope.year=0;
	$scope.month=0;
	$scope.fromdate="";
	$scope.todate="";
	$scope.emp_costcentre=0;
	$scope.costcentre=0;
	
	$scope.localjobtitle="";
	$scope.localempcode="";
	

	onfetch('setup/getalldivision',1);
	onfetch('setup/getallgrade',2);
	onfetch('setup/getalldepartment',3);
	onfetch('setup/getalldesignation',4);
	onfetch('setup/getalllocation',5);
	onfetch('attendance/getallshift',6);
	onfetch('employee/getallempstatus',7);
	onfetch('other',8);
	onfetch('employee/getallbloodgroup',9);
	onfetch('tabledata/index/NationalityMaster',10);
	onfetch('employee/getallvisa',11);
	
	//onfetch('tabledata/index/LanguageMaster',12);
	onfetch('other/getallreligion',13);
	onfetch('employee/getallfunctionalarea',14);
	onfetch('country/getallcountry',15);
	onfetch('employee/getalldocument',19);
	//onfetch('employee/getallemployee',20);
	onfetch('other/getallrelation',21);
	onfetch('employee/getallskill',22);
	onfetch('employee/getallcreditcard',23);
	onfetch('employee/getallinsurance',24);
	onfetch('employee/getallbank',25);
	onfetch('employee/getallqualification',28);
	onfetch('employee/getallemptype',30);
	onfetch('salary/getallsalarytype',31);
	onfetch('salary/getallModePayment',34);
	onfetch('setup/getallchannel',32);
	onfetch('setup/getallcostcentre',33);
	onfetch('setup/getallcocentre',35);
	onfetch('employee/allvisacat',36);
	onfetch('attendance/getallgeocenter',37);
	//onfetch('employee/getemployeesalary',29);

	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};

	$('input').on('ifChecked', function(event){
		if(event.target.name=='chk1')
		$scope.chk1=event.target.value;
	  else if(event.target.name=='chk2')
		$scope.chk2=event.target.value;
	  else if(event.target.name=='chk3')
		$scope.chk3=event.target.value;
	  else if(event.target.name=='chk4')
		$scope.chk4=event.target.value;
	  else if(event.target.name=='chk5')
		$scope.chk5=event.target.value;
	  else if(event.target.name=='chk6')
		$scope.chk6=event.target.value;
	  else if(event.target.name=='chk7')
		$scope.chk7=event.target.value;
	  else if(event.target.name=='in')
		$scope.chk8=event.target.value;
		//else if(event.target.name=='status')
		//$scope.status=event.target.value;
		else if(event.target.name=='ticket'){
		$scope.chk9=event.target.value;
		$timeout(function(){$scope.chk9=event.target.value}, 100);
	}
else if(event.target.name=='overtime')
	$scope.chk10=event.target.value;
  
});

	$scope.workarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
	$scope.addwork = function($i){
		var len = $scope.workarray.length-1;
		if($scope.workarray[len]['name']=="" || $scope.workarray[len]['desig']=="" || $scope.workarray[len]['fdate']=="" || $scope.workarray[len]['tdate']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.workarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
		}
	}
	$scope.removework = function($i){
		$scope.workarray.remove($i);	
		if($scope.workarray.length==0){
			$scope.workarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
		}
	}

	$scope.qualificationarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""}];
	$scope.addqualification = function($i){
		var len = $scope.qualificationarray.length-1;
		if($scope.qualificationarray[len]['name']=="" || $scope.qualificationarray[len]['desig']=="" || $scope.qualificationarray[len]['fdate']=="" || $scope.qualificationarray[len]['tdate']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.qualificationarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
		}
	}
	$scope.removequalification = function($i){
		$scope.qualificationarray.remove($i);
		if($scope.qualificationarray.length==0){
			$scope.qualificationarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
		}
	}
	/* Personal Documents */
	$scope.documentarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"",doctype:1}];
	$scope.adddocument = function($i){
		var len = $scope.documentarray.length-1;
		if($scope.documentarray[len]['name']=="" || $scope.documentarray[len]['desig']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.documentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"",doctype:1});
		}
	}
	$scope.removedocument = function($i){
		$scope.documentarray.remove($i);
		if($scope.documentarray.length==0){
			$scope.documentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"",doctype:1});
		}
	}
	/* Comany Documents */
	$scope.companydocumentarray=[{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"", doctype:2}];
	$scope.addcompanydocument = function($i){
		var len = $scope.companydocumentarray.length-1;
		if($scope.companydocumentarray[len]['name']=="" || $scope.companydocumentarray[len]['desig']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.companydocumentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"", doctype:2});
		}
	}
	$scope.removecompanydocument = function($i){
		$scope.companydocumentarray.remove($i);
		if($scope.companydocumentarray.length==0){
			$scope.companydocumentarray.insert($i,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",originaldoc:"", doctype:2});
		}
	}
	/* ///employee-->employee list-->edit-->personel */
	$scope.timediff = function($val){
		if($val==1) {
			if($scope.emp_doj != ""){
				var datefrom=$( '#emp_doj' ).datepicker( "getDate" );
				//$scope.resumptiondate="";
				$scope.emp_doc="";
				$('#emp_doc').datepicker("remove");
				$('#emp_doc').datepicker({
					startDate: datefrom
				});
			}
		}
		if($val==2) {
			if($scope.emp_doc != ""){
				//$scope.resumptiondate="";
				var dateto=$( '#emp_doc' ).datepicker( "getDate" );  
				$('#emp_doc').datepicker("remove");
				$('#emp_doc').datepicker({
					startDate: dateto
				});
			}
		}
	}
	////Bank detail---> credit card
	$scope.diffdate = function($val,$index){
		if($val==1) {
			var issuedate=$( "#"+$index+"issuedate" ).datepicker( "getDate" );
			if(issuedate != "") {
				//$scope.resumptiondate="";
				$scope.validdate="";
				$("#"+$index+"validdate").datepicker("remove");
				$("#"+$index+"validdate").datepicker({
					startDate: issuedate
				});
			}
		}
		if($val==2) {
			if(validdate != "") {
				//$scope.resumptiondate="";
				var validdate=$( "#"+$index+"validdate"  ).datepicker( "getDate" );
				$("#"+$index+"validdate").datepicker("remove");
				 $("#"+$index+"validdate").datepicker ({
					startDate: validdate
				});
			}
		}
	}
	/* if($val==1) {
			alert("hello");
			var ifromdate=$( "#"+$index+"issuedate" ).datepicker( "getDate" );
			if(ifromdate != ""){
				//$scope.resumptiondate="";
				$scope.validdate="";
				$("#"+$index+"validdate").datepicker("remove");
				$("#"+$index+"validdate").datepicker({
					startDate: ifromdate
				});
			}
		}
		if($val==2) {
			if($scope.credit_validdate != ""){
				//$scope.resumptiondate="";
				var vtodate=$( "#"+$index+"validdate" ).datepicker( "getDate" );
				$("#"+$index+"validdate").datepicker("remove");
				 $("#"+$index+"validdate").datepicker({
					startDate: vtodate
					
				});
			}
		}
	} */
	//////experience
	$scope.dated = function($val,$index){
		if($val==1) {
			var fromdate=$( "#"+$index+"fromdate" ).datepicker( "getDate" );
			if(fromdate != "") {
				//alert(fromdate);
				//$scope.resumptiondate="";
				$scope.todate="";
				$("#"+$index+"todate").datepicker("remove");
				$("#"+$index+"todate").datepicker({
					startDate: fromdate
				});
			}
		}
		if($val==2) {
			if($scope.todate != "") {
				alert("hello");
				//$scope.resumptiondate="";
				var todate=$( "#"+$index+"todate"  ).datepicker( "getDate" );
				$("#"+$index+"todate").datepicker("remove");
				 $("#"+$index+"todate").datepicker ({
					startDate: todate
				});
			}
		}
	}
	/////Document
	$scope.datdoc = function($val,$index){
		if($val==1) {
			var fromdate=$( "#"+$index+"fromdoc" ).datepicker( "getDate" );
			if(fromdate != "") {
				//$scope.resumptiondate="";
				$scope.tdate="";
				$("#"+$index+"todoc").datepicker("remove");
				$("#"+$index+"todoc").datepicker({
					startDate: fromdate
				});
			}
		}
		if($val==2)	{
			var todate=$( "#"+$index+"todoc"  ).datepicker( "getDate" );
			if(todate != "") {
				//alert("hello");
				//$scope.resumptiondate="";
				$("#"+$index+"todoc").datepicker("remove");
				 $("#"+$index+"todoc").datepicker ({
					startDate: todate
				});
			}
		}
	}
	$scope.dependantarray=[{id:0, relate:"", fname:"", lname:"",  nominee:0,contact:""}];
	$scope.adddependant = function($i){
		var len = $scope.dependantarray.length-1;
		if($scope.dependantarray[len]['relate']=="" || $scope.dependantarray[len]['fname']=="" || $scope.dependantarray[len]['nominee']==0 ){
				errorMessage("Please fill all fields");
		}else{
			var total=0;
			for(var i=0;i<$scope.dependantarray.length;i++){
				total =Number(total) + Number($scope.dependantarray[i]['nominee']);
			}
			if(total == 100 ){
				errorMessage("Nominee % is already 100 %");
				$scope.hastrue=false;
			}else{
				$scope.dependantarray.insert($i,{id:0, relate:"", fname:"", lname:"",  nominee:0,contact:""});
			}
		}
	}
	$scope.removedependant = function($i){
		$scope.dependantarray.remove($i);
		if($scope.dependantarray.length==0){
			$scope.dependantarray.insert($i,{id:0, relate:"", fname:"", lname:"",  nominee:0,contact:""});
		}
	}
	$scope.familyarray=[{id:0,  fname:"", passportno:"",emiratesid:"",bdate:"",  age:0, familyuidno:"",familyfileno:""}];
	$scope.addfamily = function($i){
	var len = $scope.familyarray.length-1;
		if($scope.familyarray[len]['passportno']=="" || $scope.familyarray[len]['emiratesid']=="" || $scope.familyarray[len]['fname']=="" || $scope.familyarray[len]['bdate']==0 ){
				errorMessage("Please fill all fields");
		}else{
			$scope.familyarray.insert($i,{id:0,   fname:"", passportno:"",emiratesid:"",bdate:"",   familyuidno:"",familyfileno:""});
		}
	}
	$scope.removefamily = function($i){
		$scope.familyarray.remove($i);
		if($scope.familyarray.length==0){
			$scope.familyarray.insert($i,{id:0,   fname:"", passportno:"",emiratesid:"",bdate:"",  age:0, familyuidno:"",familyfileno:""});
		}
	}
	$scope.empskillarray=[{id:0, skill:0, desc:""}];
	$scope.addskill = function($i){
		var len = $scope.empskillarray.length-1;
		if($scope.empskillarray[len]['skill']==0 || $scope.empskillarray[len]['desc']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.empskillarray.insert($i,{id:0, skill:0, desc:""});
		}
	}
	$scope.removeskill = function($i){
		$scope.empskillarray.remove($i);
		if($scope.empskillarray.length==0){
			$scope.empskillarray.insert($i,{id:0, skill:0, desc:""});
		}
	}
	$scope.referencearray=[{id:0 ,name:"", company:"", email:"",contact:""}];
	$scope.addref = function($i){
		var len = $scope.referencearray.length-1;
		if($scope.referencearray[len]['name']=="" || $scope.referencearray[len]['company']=="" ||$scope.referencearray[len]['email']=="" ||  $scope.referencearray[len]['contact']=="" ){
			errorMessage("Please fill all fields");
		}else{
			$scope.referencearray.insert($i,{id:0 ,name:"", company:"", email:"",contact:""});
		}
	}
	$scope.removeref = function($i){
		$scope.referencearray.remove($i);
		if($scope.referencearray.length==0){
			$scope.referencearray.insert($i,{name:"", company:"", email:"",contact:""});
		}
	}
	$scope.emp_creditcardarray=[{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""}];
	$scope.addemp_creditcard = function($i){
		var len = $scope.emp_creditcardarray.length-1;
		if($scope.emp_creditcardarray[len]['creditcardid']==0 || $scope.emp_creditcardarray[len]['bankid']=="" || $scope.emp_creditcardarray[len]['credit_issuedate']=="" || $scope.emp_creditcardarray[len]['credit_validdate']==""  ||  $scope.emp_creditcardarray[len]['creditcard_no']=="" || $scope.emp_creditcardarray[len]['credit_limit']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.emp_creditcardarray.insert($i,{id:0, creditcardid:"", bankid:"",creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
		}
	}
	$scope.removeemp_creditcard = function($i){
		$scope.emp_creditcardarray.remove($i);
		if($scope.emp_creditcardarray.length==0){
			$scope.emp_creditcardarray.insert($i,{id:0, creditcardid:"", bankid:"",creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
		}
	}
	$scope.emp_insurancearray=[{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_nominee:""}];
	$scope.addemp_insurance = function($i){
		var len = $scope.emp_insurancearray.length-1;
		if($scope.emp_insurancearray[len]['insuranceid']==0 || $scope.emp_insurancearray[len]['insurance_period']=="" || $scope.emp_insurancearray[len]['insured_amt']=="" || $scope.emp_insurancearray[len]['premium_amt']=="" || $scope.emp_insurancearray[len]['insurance_validdate']==""   ){
			errorMessage("Please fill all fields");
		}else{
			$scope.emp_insurancearray.insert($i,{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_nominee:""});
		}
	}
	$scope.removeemp_insurance = function($i){
		$scope.emp_insurancearray.remove($i);
		if($scope.emp_insurancearray.length==0){
			$scope.emp_insurancearray.insert($i,{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_nominee:""});
		}
	}
	$scope.emp_bankarray=[{id:0, bankid:"", iban_no:"",swiftcode:"",agent_id:"",countryid:"",branch:"",address:"",clearingcode:"",status:0}];
	$scope.addemp_bank = function($i){
		var len = $scope.emp_bankarray.length-1;
		if($scope.emp_bankarray[len]['bankid']==0 || $scope.emp_bankarray[len]['iban_no']=="" || $scope.emp_bankarray[len]['branch']=="" || $scope.emp_bankarray[len]['swiftcode']==""|| $scope.emp_bankarray[len]['agent_id']==""|| $scope.emp_bankarray[len]['countryid']==""|| $scope.emp_bankarray[len]['address']==""|| $scope.emp_bankarray[len]['clearingcode']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.emp_bankarray.insert($i,{id:0, bankid:"", iban_no:"",swiftcode:"",agent_id:"",countryid:"",branch:"",address:"",clearingcode:"",status:0});
		}
	}
	$scope.removeemp_bank = function($i){
		$scope.emp_bankarray.remove($i);
		if($scope.emp_bankarray.length==0){
			$scope.emp_bankarray.insert($i,{id:0, bankid:"", iban_no:"",swiftcode:"",agent_id:"",countryid:"",branch:"",address:"",clearingcode:"",status:0});
		}
	}
	$scope.bankloanarray=[{id:0, bankid:"", loan_amt:"",tenure:"",emi:""}];
	$scope.addbankloan = function($i){
		var len = $scope.bankloanarray.length-1;
		if($scope.bankloanarray[len]['bankid']==0 || $scope.bankloanarray[len]['loan_amt']=="" || $scope.bankloanarray[len]['tenure']=="" || $scope.bankloanarray[len]['emi']==""){
			errorMessage("Please fill all fields");
		}else{
			$scope.bankloanarray.insert($i,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
		}
	}
	$scope.removebankloan = function($i){
		$scope.bankloanarray.remove($i);
		if($scope.bankloanarray.length==0){
			$scope.bankloanarray.insert(0,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
		}
	}
	$scope.datediff=function($index){
		if($scope.familyarray[$index]['bdate']!="" ){
			var dob=$( '#dob_'+$index ).datepicker( "getDate" );
			//console.log(dob)
			if(dob == 'Invalid Date'){
				var date1=$scope.familyarray[$index]['bdate1'];
				//var dob=date1[2]+'-'+date1[1]+'-'+date1[0];
				dob= new Date(date1);
			}
			var birthDay=dob.getDate();
			var birthMonth=dob.getMonth()+1;
			var birthYear=dob.getFullYear();
			var  today = new Date();
			var currentDay=today.getUTCDate();
			var currentMonth=today.getUTCMonth() + 1;
			var currentYear=today.getFullYear();
			var yearAge = currentYear - birthYear;
			console.log(yearAge)
			console.log(birthMonth)
			console.log(currentMonth)
			if(birthMonth>=currentMonth) {
				var monthAge =  parseInt(birthMonth) - parseInt(currentMonth);
			}else{
				yearAge--;
				var monthAge=12-parseInt(currentMonth)+parseInt(birthMonth)
			}
			//calculate the age in months:
			if(monthAge == 0)
			var age = yearAge; 
			else
			var age = yearAge+'.'+monthAge; 
			if(age<0)
			age=0		
			$scope.familyarray[$index]['age'] = age;
		}
	}

	$scope.dayDiff = function($index){
		if($scope.documentarray[$index]['fdate']!="" && $scope.documentarray[$index]['tdate']!=""){
			var date2 = new Date($scope.documentarray[$index]['fdate']);
			var date1 = new Date($scope.documentarray[$index]['tdate']);
			if(date2<date1){
				var timeDiff = Math.abs(date2.getTime() - date1.getTime());   
				var diffDays = Math.ceil(timeDiff / (1000 * 3600 * 24)); 
				$scope.documentarray[$index]['desc'] = diffDays;
			}
		}
	}
	$scope.getcity = function($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.emp_country1,$val);
		}else if($val==17){
			onfetch('city/getallcity/'+$scope.emp_country2,$val);
		}else if($val==18){
			onfetch('city/getallcity/'+$scope.emp_country3,$val);
		}
		else if($val==27){
			onfetch('city/getallcity/'+$scope.emp_country4,$val);
		}
	}
	function getcity1($val) {
		if($val==16){
			onfetch('city/getallcity/'+$scope.emp_country1,$val);
		}else if($val==17){
			onfetch('city/getallcity/'+$scope.emp_country2,$val);
		}else if($val==18){
			onfetch('city/getallcity/'+$scope.emp_country3,$val);
		}
		else if($val==27){
			onfetch('city/getallcity/'+$scope.emp_country4,$val);
		}
	}
	$scope.onfetchempchecklist =function($emp) {
		$scope.hastrue=true;
		var xsrf = $.param({employeeid: $emp});
		$http({
			url: path+'employee/getemployeechecklist',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.step=2;
				$scope.checklistarray=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	function onfetch($val, $id) {
		
		$scope.hastrue=true;
		var xsrf = $.param({employeeid: $scope.employeeid});
		$http({
			url: path+$val,
			method: "POST", data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				if($id==1){
					$scope.divisionarray=[];
					$scope.divisionarray=data.data;
					//$scope.divisionarray.insert(0,{id:0,name:"Select Division"});
				}else if($id==2){
					$scope.gradearray=[];
					$scope.gradearray=data.data;
				}else if($id==3){
					$scope.departarray=[];
					$scope.departarray=data.data;
				}else if($id==4){
					$scope.desigarray=[];
					$scope.desigarray=data.data;
				}else if($id==5){
					$scope.locationarray=[];
					$scope.locationarray=data.data;
				}else if($id==6){
					$scope.shiftarray=[];
					$scope.shiftarray=data.data;
				}else if($id==7){
					$scope.empstatusarray=[];
					$scope.empstatusarray=data.data;
				}else if($id==8){
					$scope.otherarray=[];
					$scope.otherarray=data.data;
				}else if($id==9){
					$scope.bloodgarray=[];
					$scope.bloodgarray=data.data;
				}else if($id==10){
					$scope.nationalarray=[];
					$scope.nationalarray=data.data;
				}else if($id==11){
					
					$scope.visaarray=[];
					$scope.visaarray=data.data;
				}else if($id==12){
					$scope.langarray=[];
					$scope.langarray=data.data;
				}else if($id==13){
					$scope.religionarray=[];
					$scope.religionarray=data.data;
				}else if($id==14){
					$scope.funcarray=[];
					$scope.funcarray=data.data;
				}else if($id==15){
					$scope.countryarray=[];
					$scope.countryarray=data.data;
				}else if($id==16){
					$scope.cityarray1=[];
					$scope.cityarray1=data.data;
				}else if($id==17){
					$scope.cityarray2=[];
					$scope.cityarray2=data.data;
				}else if($id==18){
					$scope.cityarray3=[];
					$scope.cityarray3=data.data;
				}else if($id==19){
					$scope.docarray=[];
					$scope.docarray=data.data;
				}else if($id==20){
					$scope.reportingtoarray=[];
					$scope.reportingtoarray=data.data;
					//$scope.gradebenefits=data.benefit;
				}else if($id==21){
					$scope.realtionarray=[];
					$scope.realtionarray=data.data;
				}else if($id==22){
					$scope.skillarray=[];
					$scope.skillarray=data.data;
				} else if($id==23){
					$scope.creditcardarray=[];
					$scope.creditcardarray=data.data;
				} else if($id==24){
					$scope.insurancearray=[];
					$scope.insurancearray=data.data;
				} else if($id==25){
					$scope.bankarray=[];
					$scope.bankarray=data.data;
				}	else if($id==26){
					$scope.rolearray=[];
					$scope.rolearray=data.data;
				} else if($id==27){
					$scope.cityarray4=[];
					$scope.cityarray4=data.data;
					$timeout(function(){
					var con= $( "#emp_country4 option:selected" ).text();
					var city= $( "#emp_city4 option:selected" ).text();
					$('#airport').val(city+', '+con);
					}, 2000); 
				} else if($id==28){
					
					$scope.qualarray=[];
					$scope.qualarray=data.data;
				} else if($id==30){
					$scope.emptypearray=[];
					$scope.emptypearray=data.data;
				} else if($id==31){
					$scope.salarytypearray=[];
					$scope.salarytypearray=data.data;
					$scope.salarytypearray.insert(0,{id:0,name:"Select Salary Type"});
				} else if($id==32){
					$scope.channelarray=[];
					$scope.channelarray=data.data;
				} else if($id==33){
					$scope.costcentrearray=[];
					$scope.costcentrearray=data.data;
				} else if($id==34){
					$scope.modepayarray=[];
					$scope.modepayarray=data.data;
				} else if($id==35){
					
					$scope.cocentrearray=[];
					$scope.cocentrearray=data.data;
				} 
				 else if($id==36){
				
					$scope.visacatarray=[];
					$scope.visacatarray=data.data;
				}
				else if($id==37){
					$scope.geocenterarray=[];
					$scope.geocenterarray=data.data;
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
	}
	/*$scope.onfetchnominee = function($val,$index) {
		for(var i=0;i<$scope.nomineearray.length;i++){
		if($index==i){
			continue;
		}if($val==$scope.nomineearray[i]['fname']){
			errorMessage('already exists');
			return;
			}
		}
		for(var i=0;i<$scope.dependantarray.length;i++){
			if($val==i){
			$scope.nomineearray[$index]['id']=$scope.dependantarray[$val]['id'];
			$scope.nomineearray[$index]['relate']=$scope.dependantarray[$val]['relate'];
			$scope.nomineearray[$index]['bdate']=$scope.dependantarray[$val]['bdate'];
			//$scope.nomineearray[$index]['nominee']=$scope.dependantarray[$val]['nominee'];
			}
		}
	}
	$scope.onchangedesig =function($val) {
		for(var i=0;i<$scope.desigarray.length;i++){
			if($scope.desigarray[i]['id']==$val){
				$scope.emp_grade=$scope.desigarray[i]['grade'];	
				var roleid=$scope.desigarray[i]['role'];
			}
		} 
		if(roleid==0){
			$scope.reportingtoarray="";
		}else{
			onfetch('employee/getreportingto/'+roleid,20);
		}
	}*/
	
	/////Made by Pratibha for confirming employee really want to move in severance////
	$scope.onchangemovetoseverance = function($val)
	{	
		if($val==1 || $val==2 || $val==3 )
		{
			$("#confirm_status").modal('show');
		}
		else 
		{
			return $val;
		}
	}
	$scope.movetoseverance = function($id)
	{
		$scope.empid = $id;
		window.open(path+'employee/addseverance/'+$scope.empid, "_self");
	}

	$scope.onchangegrade =function($val){
		onfetch('employee/getreportingto/'+$val+'/'+$scope.employeeid,20);
	}
	$scope.changenearestairport =function() {
		var con= $( "#emp_country4 option:selected" ).text();
		var city= $( "#emp_city4 option:selected" ).text();
		$('#airport').val(city+', '+con);
	}
	$scope.onfetchsalarydetail =function(){
		callafterfetchdetail();
	}
	$scope.calculatetotal = function() {	
		var totaldeduct=0;var totaladd=0;
		for(var i=0; i<$scope.salaryarray.length; i++) {
			if(parseInt($scope.salaryarray[i].headtype)==3 || parseInt($scope.salaryarray[i].headtype)==0){
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaldeduct += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}else {
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaladd += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}
		}
		$scope.emptotal=totaladd;
		$scope.totaldeduction=totaldeduct;
		//errorMessage($scope.emptotal+"  "+totaladd+"  "+totaldeduct);
		$scope.salaryctc =  (totaladd - totaldeduct);
		//$scope.netsalary = parseInt($scope.netsalary);
		//if($val!=null && $val!=undefined){
			//$scope.employees[$index].emptotal +=$val;			
		//}
	}
	$scope.getBonus = function($gradeid) {	
		for(var i=0; i<$scope.gradearray.length; i++) {
			if($scope.gradearray[i].id==$gradeid){
				var nomonths=$scope.gradearray[i].NoOfMonths;
				var salincreamentper=$scope.gradearray[i].SalaryIncreament;
				$timeout(function(){	
				$scope.nomonths=nomonths;
				$scope.salincreamentper=salincreamentper;}, 100);	
			}else{
				$scope.nomonths="";
				$scope.salincreamentper="";
			}
		}
	}
	
	$scope.onchangesalarytype = function($saltype) {	
		$scope.salarytypedetails=[];
		for(var i=0;i<$scope.salarytypearray.length;i++)  {
			if($scope.salarytypearray[i].id == $saltype)
			{
				$scope.salarytypedetails=$scope.salarytypearray[i].salarytypedetails;
			}
		}
		for(var j=0; j<$scope.salarytypedetails.length; j++) {
			for(var i=0; i<$scope.salaryarray.length; i++) {
				if($scope.salaryarray[i].id == $scope.salarytypedetails[j].salaryheadid)	{
					console.log($scope.salarytypedetails[j].salarypercent)
					var amount=(($scope.salaryctc*$scope.salarytypedetails[j].salarypercent)/100);
					$scope.salaryarray[i].amount=amount;
				}
			}
		}
	}
	$scope.fetchsalary = function() 	{	
		$scope.hastrue=true;
		var exp=$scope.tyear+','+$scope.tmonth;
		var xsrf = $.param({division:$scope.emp_division, gradeid: $scope.emp_grade, designation: $scope.emp_desig, department:$scope.emp_depart, experience: exp});
		$http({
			url: path+'employee/getemployeesalarytype',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.salaryarray=[];
				$scope.salaryarray=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	function callafterfetchdetail() {
		//$scope.hastrue=true;
		var xsrf = $.param({employeeid: $scope.employeeid, gradeid: $scope.emp_grade, grossalary: $scope.salaryctc, incentive:$scope.paypattern, experience: $scope.tyear,division:$scope.emp_division,department:$scope.emp_depart,preexp:$scope.year});
		$http({
			url: path+'employee/getemployeesalary',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.salaryarray=[];
				$scope.salaryarray=data.data;
				$scope.salaryctc=data.grosssalary;
				//$scope.salarytype=data.salarytype;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.onfetchfare =function() {
		$scope.hastrue=true;
		var xsrf = $.param({fromcity: $scope.emp_city1,tocity: $scope.emp_city4,ticketclass:$scope.ticketclass});
		$http({
			url: path+'setup/getrootfare',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				//console.log($scope.chk9)
				//$scope.iatafare=data.data[0]['fareamount'];	
				$scope.iatafare =0;				
				if($scope.chk9==2){
					var age=0;
					$scope.infant=0;
					$scope.child=0;
					$scope.adult=1;
					for(var i=0;i<$scope.familyarray.length;i++){
						if($scope.familyarray[i].bdate==undefined || $scope.familyarray[i].bdate==""){
							errorMessage("Enter family details first");
							$scope.hastrue=false;
							return;
						}else{
							age =parseFloat($scope.familyarray[i].age);
							//console.log(age)
							if(age<=2 && age>=0){
								$scope.infant++;
							} else if(age>2 && age<13){
								$scope.child++	;
							} else if(age>=13){
								$scope.adult++;	
							}
						}
					}
					var adultfare = data.data[0]['fareamount'] * $scope.adult;
					var childfare = data.data[0]['childfareamount'] * $scope.child;
					var infantfare = data.data[0]['infantfareamount'] * $scope.infant;
					$scope.iatafare = parseFloat(adultfare) + parseFloat(childfare) + parseFloat(infantfare);
				}else if($scope.chk9==1){
					$scope.iatafare = data.data[0]['fareamount'];
					$scope.adult = 0;
					$scope.child = 0;
					$scope.infant =0;					
				}else{
					$scope.iatafare =0;
				}
			}else{
				$scope.iatafare=0;
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.setdefaultbank = function ($index) {
		for(var i=0;i<$scope.emp_bankarray.length;i++) {
			if(i == $index){
				$scope.emp_bankarray[i]['status']=1;
				
			}else{
				$scope.emp_bankarray[i]['status']=0;
				
			}
		}
	}
	/*$scope.setdefaultbank =function($val) {
		$scope.hastrue=true;
		var xsrf = $.param({empbankid:$val,emp_id:$scope.employeeid});
		$http({
			url: path+'employee/setdefaultbank',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					for(var i=0;i<$scope.emp_bankarray.length;i++){
						if($val == $scope.emp_bankarray[i].id){
							$scope.emp_bankarray[i].status=1;
						}
						else{
							$scope.emp_bankarray[i].status=0;
						}
					}
				}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}*/
	
	$scope.checkval=function($val,$i){
		if($val==undefined){
			if($i==1){
				$scope.salaryctc=0;
			}
			if($i==2){
				$scope.year=0;
			}
			if($i==3){
				$scope.month=0;
			}
		}else{
			$scope.onchangesalarytype($scope.salarytype);
		}
	}
	$scope.onchangebank=function($val,$i){
		for(var i=0;i<$scope.bankarray.length;i++) {
			if($scope.bankarray[i].id == $val) {
				$scope.emp_bankarray[$i].swiftcode=$scope.bankarray[i].code;
				$scope.emp_bankarray[$i].branch=$scope.bankarray[i].branch;
				$scope.emp_bankarray[$i].agent_id=$scope.bankarray[i].agent_id;
			}
		}
	}
	$scope.nomineepercent=function(){
		var total=0;
		for(var i=0;i<$scope.dependantarray.length;i++){
			total =Number(total) + Number($scope.dependantarray[i]['nominee']);
		}
		if(total > 100){
			//var len = $scope.dependantarray.length;
			//$scope.dependantarray[len]['nominee']=0;
			errorMessage("Nominee % of benefit should be 100 %");
		}
	}
	$scope.leavests =false;
	$scope.onfetchemployee =function($id) {
		$scope.hastrue=true;
		var xsrf = $.param({employeeid: $id});
		$http({
			url: path+'employee/getaemployee',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.callout=1;
				if($scope.val!=0){
					$scope.callout=0;
				}
				$scope.leavests =true;
				$scope.emp_code=data.data[0]['empcode'];
					$scope.localjobtitle=data.data[0]['localjobtitle'];
						$scope.localempcode=data.data[0]['localempcode'];
				$scope.emp_report_to=data.data[0]['empreport'];
				$scope.emp_division=Number(data.data[0]['empdivision']);
				$scope.emp_grade=Number(data.data[0]['empgrade']);
				$scope.emp_depart=Number(data.data[0]['empdepartment']);
				$scope.emp_channel=Number(data.data[0]['empchannel']);
				$scope.emp_costcentre=Number(data.data[0]['empcostcentre']);
				$scope.costcenter=Number(data.data[0]['cocenter']);
				
				$scope.emp_desig=data.data[0]['empdesignation'];
				$scope.emp_currency=data.data[0]['empcurency'];
				$scope.emp_location=data.data[0]['emplocation'];
				$scope.emp_shift=data.data[0]['empshift'];
				$scope.geo_center=data.data[0]['geo_center'];
				$scope.emp_sts=data.data[0]['empsts'];
				$scope.emppic=data.data[0]['emppic'];
				$scope.salaryctc=data.data[0]['salaryctc'];
				$scope.emp_type=data.data[0]['emptype'];
				$scope.curmonth=data.data[0]['curmonth'];
				$scope.curyear=data.data[0]['curyear'];
				$scope.provision=Number(data.data[0]['provision']);
				$scope.gradebenefits=data.data[0]['gradebenefit'];
				callafterfetchdetail();
				$scope.emp_leave=data.data[0]['annualleave'];
				if(data.data[0]['empworkday']!=""){
					var a = (data.data[0]['empworkday']).split(",");				
					$('#chk23').iCheck((a[0]=="1")?'check':'uncheck');
					$('#chk3').iCheck((a[1]=="1")?'check':'uncheck'); 
					$('#chk6').iCheck((a[2]=="1")?'check':'uncheck');
					$('#chk11').iCheck((a[3]=="1")?'check':'uncheck');
					$('#chk14').iCheck((a[4]=="1")?'check':'uncheck');
					$('#chk17').iCheck((a[5]=="1")?'check':'uncheck');
					$('#chk20').iCheck((a[6]=="1")?'check':'uncheck');
					$('#chk24').iCheck((a[7]=="1")?'check':'uncheck');
					
					$('#chk22').iCheck((a[0]=="2")?'check':'uncheck');
					$('#chk2').iCheck((a[1]=="2")?'check':'uncheck'); 
					$('#chk5').iCheck((a[2]=="2")?'check':'uncheck');
					$('#chk10').iCheck((a[3]=="2")?'check':'uncheck');
					$('#chk13').iCheck((a[4]=="2")?'check':'uncheck');
					$('#chk16').iCheck((a[5]=="2")?'check':'uncheck');
					$('#chk19').iCheck((a[6]=="2")?'check':'uncheck');
					
					$('#chk21').iCheck((a[0]=="3")?'check':'uncheck');
					$('#chk1').iCheck((a[1]=="3")?'check':'uncheck'); 
					$('#chk4').iCheck((a[2]=="3")?'check':'uncheck');
					$('#chk7').iCheck((a[3]=="3")?'check':'uncheck');
					$('#chk12').iCheck((a[4]=="3")?'check':'uncheck');
					$('#chk15').iCheck((a[5]=="3")?'check':'uncheck');
					$('#chk18').iCheck((a[6]=="3")?'check':'uncheck');
				}else{
					$('#chk1').iCheck('uncheck');
					$('#chk2').iCheck('uncheck');
					$('#chk3').iCheck('uncheck');
					$('#chk4').iCheck('uncheck');
					$('#chk5').iCheck('uncheck');
					$('#chk6').iCheck('uncheck');
					$('#chk7').iCheck('uncheck');
				}
				$scope.emp_fname=data.data[0]['empfname'];
				$scope.emp_lname=data.data[0]['emplname'];
				$scope.emp_mname=data.data[0]['empmname'];
				$scope.emp_dob=data.data[0]['empdob'];
				$scope.emp_gender=data.data[0]['empgender'];
				$scope.emp_marital=data.data[0]['empmarists'];
				$scope.emp_blood_group=data.data[0]['empbloodgroup'];
				$scope.emp_nationality=data.data[0]['empnation'];
				$scope.emp_visa_type=data.data[0]['empvisa'];
				$scope.emp_visa_cat=data.data[0]['empvisacat'];
				//$scope.emp_known_lang=data.data[0]['emplang'].split(',');
				$scope.emp_religion = data.data[0]['empreligion'];
				$scope.emp_functional=data.data[0]['empfuncarea'];
				$scope.emp_doj=data.data[0]['empdoj'];
				$scope.emp_doc=data.data[0]['empdoc'];
				$scope.emp_contact1=data.data[0]['empcnumber'];
				
				$scope.emp_email1=data.data[0]['empcemail'];
				$scope.emp_address1=data.data[0]['empcaddres'];
				$scope.emp_country1=data.data[0]['empccountry'];
				$scope.emp_city1=data.data[0]['empccity'];
				$scope.emp_zipcode1=data.data[0]['empczip'];
				$scope.emp_contact2=data.data[0]['emphnumber'];
				$scope.emp_email2=data.data[0]['emphemail'];
				$scope.emp_address2=data.data[0]['emphaddres'];
				$scope.emp_country2=data.data[0]['emphcountry'];
				$scope.emp_city2=data.data[0]['emphcity'];
				$scope.emp_zipcode2=data.data[0]['emphzip'];
				$scope.emp_contact3=data.data[0]['empenumber'];
				$scope.emp_email3=data.data[0]['empeemail'];
				$scope.personal_no=data.data[0]['personal_no'];
				if(data.data[0]['empeaddress']!=null && data.data[0]['empeaddress']!=""){
					var a=data.data[0]['empeaddress'].split(',');
					$scope.emr_name=a[0];
					$scope.emp_address3=a[1];
					if($scope.emp_address3 == 'undefined') {
						$scope.emp_address3=" ";
					}
				}
				$scope.emp_country3=data.data[0]['empecountry'];
				$scope.emp_city3=data.data[0]['empecity'];
				$scope.emp_zipcode3=data.data[0]['empezip'];
				$scope.bankname=data.data[0]['empebankname'];
				$scope.agent_id=data.data[0]['agent_id'];
				$scope.bankifsccode=data.data[0]['empebankcode'];
				$scope.salarytype=data.data[0]['salarytype'];
				$scope.modepayment=data.data[0]['modepayment'];
				$scope.bankaddress=data.data[0]['empebankaddress'];
				$scope.cmp_email=data.data[0]['cmpemail'];
				$scope.uidno=data.data[0]['uidno'];
				$scope.fileno=data.data[0]['fileno'];
				/*if($scope.cmp_email == ""){
					$("#cmp_email").prop("disabled", false);
				}else{
					$("#cmp_email").prop("disabled", true);
				}*/
				$scope.ticketclass=data.data[0]['ticketclass'];
				$scope.ticketamt=data.data[0]['ticketamt'];
				$scope.iatafare=data.data[0]['iatafare'];
				$scope.instructions=data.data[0]['instructions'];
				$scope.onceinmonth=Number(data.data[0]['oncein']);
				$scope.nomonths=data.data[0]['nomonths'];
				$scope.salincreamentper=data.data[0]['salincreamentper'];
				if(data.data[0]['nearestairport'] !=""){
					var n=data.data[0]['nearestairport'].split(',');
					$scope.emp_city4=n[0];
					$scope.emp_country4=n[1];
					if($scope.emp_country4!=0)
					getcity1(27);
				}
				if(data.data[0]['familydetails'] != null && data.data[0]['familydetails'] != ""){
					var a=data.data[0]['familydetails'].split(',');
					$scope.adult=a[0];
					$scope.child=a[1];
					$scope.infant=a[2];
				}
				if(data.data[0]['airticket'] !=""){
					var airticket=data.data[0]['airticket'];
					$('#chk24').iCheck((airticket=="0")?'check':'uncheck'); 
					$('#chk25').iCheck((airticket=="1")?'check':'uncheck');
					$('#chk26').iCheck((airticket=="2")?'check':'uncheck');
				}
				getcity1(16);
				getcity1(17);
				getcity1(18);
				if(data.data[0]['overtimepay'] !=""){
					var a = data.data[0]['overtimepay'];
					$('#ot1').iCheck((a=="1")?'check':'uncheck');
					$('#ot2').iCheck((a=="0")?'check':'uncheck');
				}
				if(data.data[0]['empepaypattern']!="") {
					var a = data.data[0]['empepaypattern'];
					$('#chk8').iCheck((a=="1")?'check':'uncheck');
					$scope.paypattern= a;					
				}
				if(data.data[0]['empexp']!=""){
					var empexp = (data.data[0]['empexp']).split(",");
					$scope.year= Number(empexp[0]);
					$scope.month=Number(empexp[1]);
				}
				if(data.data[0]['totalexp']!=""){
					var empexp = (data.data[0]['totalexp']).split(",");
					$scope.tyear= Number(empexp[0]);
					$scope.tmonth=Number(empexp[1]);
				}
				$scope.workarray = data.data[0]['empwork'];
				if($scope.workarray.length==0){
					$scope.workarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				$scope.qualificationarray = data.data[0]['empqual'];
				if($scope.qualificationarray.length==0){
					$scope.qualificationarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:""});
				}
				/* Fetching for personal documents details */
				$scope.documentarray = data.data[0]['empdocarray'];
				for(var j=0; j<$scope.documentarray.length; j++) {
					$scope.documentarray[j]['originaldoc']=($scope.documentarray[j]['originaldoc']==1)?true:false;
				}
				if($scope.documentarray.length==0){
					$scope.documentarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",doctype:1});
				}
				/* Fetching for company document details */
				$scope.companydocumentarray = data.data[0]['companydocarray'];
				for(var j=0; j<$scope.companydocumentarray.length; j++){
					$scope.companydocumentarray[j]['originaldoc']=($scope.companydocumentarray[j]['originaldoc']==1)?true:false;
				}
				if($scope.companydocumentarray.length==0){
					$scope.companydocumentarray.insert(0,{id:0, name:"",desig:"", fdate:"", tdate:"", desc:"",doctype:2});
				}
				$scope.dependantarray = data.data[0]['empdepenarray'];
				if($scope.dependantarray.length==0){
					$scope.dependantarray.insert(0,{id:0, relate:"",fname:"", lname:"", bdate:"", nominee:"",contact:""});
				}
				$scope.empskillarray = data.data[0]['empskills'];
				if($scope.empskillarray.length==0){
					$scope.empskillarray.insert(0,{id:0, skill:0,desc:""});
				}
				$scope.emp_insurancearray = data.data[0]['empinsurance'];
				if($scope.emp_insurancearray.length==0){
					$scope.emp_insurancearray.insert(0,{id:0, insuranceid:"", insurance_period:"",insured_amt:"",premium_amt:"",insurance_validdate:"",insurance_desc:"",insurance_nominee:""});
				}
				$scope.emp_creditcardarray = data.data[0]['empcreditcard'];
				if($scope.emp_creditcardarray.length==0){
					$scope.emp_creditcardarray.insert(0,{id:0, creditcardid:"", bankid:'',creditcard_no:"",credit_issuedate:"",credit_validdate:"",credit_limit:""});
				}
				$scope.emp_bankarray = data.data[0]['empbank'];
				//alert($scope.emp_bankarray);
				if($scope.emp_bankarray.length==0){
					$scope.emp_bankarray.insert(0,{id:0, bankid:"", iban_no:"",swiftcode:"",agent_id:"",countryid:"",branch:"",address:"",clearingcode:"",status:0});
				}
				$scope.bankloanarray = data.data[0]['empbankloan'];
				if($scope.bankloanarray.length==0){
					$scope.bankloanarray.insert(0,{id:0, bankid:"", loan_amt:"",tenure:"",emi:""});
				}
				$scope.familyarray = data.data[0]['ltadetails'];
				if($scope.familyarray.length==0){
					$scope.familyarray.insert(0,{id:0, relate:"",fname:"", lname:"", bdate:"", nominee:"",contact:"", familyuidno:"",familyfileno:""});
				}
				$scope.referencearray = data.data[0]['referencearr'];
				if($scope.referencearray.length==0){
					$scope.referencearray.insert(0,{id:0 ,name:"",company:"", email:"",contact:""});
				}
				//////////////////////////
				$scope.onchangegrade($scope.emp_desig);
			}
			else{
				$scope.callout=1;
				callafterfetchdetail();
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


	
	///////////////////////////////////////////
	$scope.oncreate = function($val) {
		
		$scope.hastrue=true;
		var age=0;
		var adult = 0;
		var child = 0;
		var infant = 0;
		for(var i=0;i<$scope.familyarray.length;i++){
			age =$scope.familyarray[i].age;
			if(age<=2 && age>=0){
				infant++;
			}else if(age>2 && age<18){
				child++	;
			} else if(age>=18){
				adult++;	
			}
		}
		var family=adult+','+child+','+infant;
		if($scope.chk9!=2){
			$scope.familyarray=[{id:0,  fname:"", passportno:"",emiratesid:"",bdate:"",  age:0, familyuidno:"",familyfileno:""}];
			family="0,0,0";
		}
		$scope.myConcatenatedDocumentArray=[];
		$scope.myConcatenatedDocumentArray=$scope.companydocumentarray.concat($scope.documentarray);
		var jsonData1 = angular.toJson($scope.workarray);
		var jsonData2 = angular.toJson($scope.qualificationarray);
		var jsonData3 = angular.toJson($scope.myConcatenatedDocumentArray);
		var jsonData4 = angular.toJson($scope.dependantarray);
		var jsonData5 = angular.toJson($scope.empskillarray);
		var jsonData6 = angular.toJson($scope.emp_creditcardarray);
		var jsonData7 = angular.toJson($scope.emp_insurancearray);
		var jsonData8 = angular.toJson($scope.emp_bankarray);
		var jsonData9 = angular.toJson($scope.bankloanarray);
		var jsonData10 = angular.toJson($scope.familyarray);
		var jsonData11 = angular.toJson($scope.salaryarray);
		var jsonData12 = angular.toJson($scope.referencearray);
		var jsonData13 = angular.toJson($scope.channelarray);
		var nearestairport="";
		if($scope.emp_city4 !="" && $scope.emp_country4 !="" && $scope.emp_city4 !=null && $scope.emp_country4 !=null){
			nearestairport=$scope.emp_city4+','+$scope.emp_country4;
		}
				
		var xsrf = $.param({emp_code: $scope.emp_code,   localjobtitle:$scope.localjobtitle, localempcode:$scope.localempcode,    emp_fname:$scope.emp_fname,emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang, emp_doj:$scope.emp_doj, emp_doc:$scope.emp_doc, emp_visa_type:$scope.emp_visa_type, emp_gender:$scope.emp_gender, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_report_to:$scope.emp_report_to, emp_division:$scope.emp_division, emp_depart:$scope.emp_depart, emp_desig:$scope.emp_desig, emp_location:$scope.emp_location, emp_shift:$scope.emp_shift, emp_sts:$scope.emp_sts, emp_grade:$scope.emp_grade, emp_workdays:$scope.chk7+','+$scope.chk1+','+$scope.chk2+','+$scope.chk3+','+$scope.chk4+','+$scope.chk5+','+$scope.chk6, emp_functional:$scope.emp_functional , salaryctc:$scope.salaryctc,emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3, paypattern:$scope.chk8, bankname:$scope.bankname, agent_id:$scope.agent_id, bankifsccode:$scope.bankifsccode, salarytype:$scope.salarytype, modepayment:$scope.modepayment, bankaddress:$scope.bankaddress, emp_dependant:jsonData4,emp_type:$scope.emp_type,emp_skill:jsonData5,emp_creditcard:jsonData6,emp_insurance:jsonData7,cmp_email:$scope.cmp_email,emp_experience:$scope.emp_experience,  airticket:$scope.chk9, oncein:$scope.onceinmonth,ticketclass:$scope.ticketclass, nearestairport:$scope.emp_city4+','+$scope.emp_country4, iatafare:$scope.iatafare, ticketamt:$scope.ticketamt, instructions:$scope.instructions ,  nomonths:$scope.nomonths ,  salincreamentper:$scope.salincreamentper , emp_bank:jsonData8, emp_bankloan:jsonData9,provision:$scope.provision,familydetails:family,emp_ltadetails:jsonData10,personal_no:$scope.personal_no, emp_salarydetails:jsonData11,overtimepay:$scope.chk10,referencearray:jsonData12, emp_channel:$scope.emp_channel, emp_costcentre:$scope.emp_costcentre, cocenter:$scope.costcenter, emp_visa_cat:$scope.emp_visa_cat, fileno:$scope.fileno, uidno:$scope.uidno });
		$http({
			url: path+'employee/createemployee',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				if($scope.files != ""){
					$scope.employeeid=data.emp_id;
					$scope.uploadFile($val);
				}
				if($scope.document != ""){
					$scope.employeeid=data.emp_id;
					$scope.uploadDocument($val);
				}
				if($scope.visadoc != ""){
					$scope.employeeid=data.emp_id;
					$scope.uploadVisa($val);
				}
				if($scope.passport != ""){
					$scope.employeeid=data.emp_id;
					$scope.uploadPassport($val);
				}
				else{
					if($val==1){
						$timeout(function(){window.open(path+"employee/employeelist", "_self");}, 12000);
					}
				}
				$scope.emppic="";
				$scope.emp_code="";
				$scope.emp_report_to="";
				$scope.emp_division="";
				$scope.emp_grade="";
				$scope.emp_depart="";
				$scope.costcenter="";
				$scope.emp_channel="";
				$scope.emp_desig="";
				$scope.emp_location="";
				$scope.emp_shift="";
				$scope.emp_sts="";
				$scope.chk1 = false; 
				$scope.chk2 = false;
				$scope.chk3 = false;
				$scope.chk4 = false; 
				$scope.chk5 = false;
				$scope.chk6 = false;
				$scope.chk7 = false;
				$scope.emp_fname="";
				$scope.emp_lname="";
				$scope.emp_dob="";
				$scope.emp_gender="";
				$scope.emp_marital="";
				$scope.emp_blood_group="";
				$scope.emp_nationality="";
				$scope.emp_visa_type="";
				$scope.emp_known_lang="";
				$scope.emp_religion = "";
				$scope.emp_functional="";
				$scope.emp_doj="";
				$scope.emp_doc="";
				$scope.emp_contact1="";
				$scope.emp_email1="";
				$scope.emp_address1="";
				$scope.emp_country1="";
				$scope.emp_city1="";
				$scope.emp_zipcode1="";

				$scope.emp_contact2="";
				$scope.emp_email2="";
				$scope.emp_address2="";
				$scope.emp_country2="";
				$scope.emp_city2="";
				$scope.emp_zipcode2="";

				$scope.emp_contact3="";
				$scope.emp_email3="";
				$scope.emp_address3="";
				$scope.emp_country3="";
				$scope.emp_city3="";
				$scope.emp_zipcode3="";
				$scope.salaryctc="";
				$scope.nomonths="";
				$scope.salincreamentper="";
				$scope.paypattern="";
				$scope.bankname="";
				$scope.agent_id="";
				$scope.bankifsccode="";
				$scope.bankaccountnumber="";
				$scope.bankaddress="";
				$scope.cmp_email="";
				$scope.emp_experience="";
				$scope.employeeid=0;
			}else{
				errorMessage(data.errorMsg);
			}
			$timeout(function(){
				$scope.hastrue=false;
				}, 12000);
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			
			$scope.hastrue=false;
		});
}
	$scope.onupdate = function($val) {
		
		$scope.hastrue=true;
		var total=0;
		for(var i=0;i<$scope.dependantarray.length;i++){
			total =Number(total) + Number($scope.dependantarray[i]['nominee']);
		}
		if( total!=0){
			if( total!=100){
				errorMessage("Nominee % in nominee details should be 100 %");
				$scope.hastrue=false;
				return;
			}
		}
		var age=0;
		var adult = 0;
		var child = 0;
		var infant = 0;
		for(var i=0;i<$scope.familyarray.length;i++){
			age =$scope.familyarray[i].age;
			if(age<=2 && age>=0){
				infant++;
			}else if(age>2 && age<18){
				child++	;
			}else if(age>=18){
				adult++;	
			}
		}
		var family=adult+','+child+','+infant;
		/* if($scope.chk9!=2){
			$scope.familyarray=[{id:0,  fname:"", passportno:"",emiratesid:"",bdate:"",  age:0}];
			family="0,0,0";
		} */
		$scope.myConcatenatedDocumentArray=[];
		$scope.myConcatenatedDocumentArray=$scope.companydocumentarray.concat($scope.documentarray);
		//angular.extend($scope.myConcatenatedDocumentArray, $scope.documentarray, $scope.companydocumentarray);
		//console.log($scope.myConcatenatedDocumentArray);
		var jsonData1=angular.toJson($scope.workarray);
		var jsonData2=angular.toJson($scope.qualificationarray);
		var jsonData3=angular.toJson($scope.myConcatenatedDocumentArray);
		var jsonData4 = angular.toJson($scope.dependantarray);
		var jsonData5 = angular.toJson($scope.empskillarray);
		var jsonData6 = angular.toJson($scope.emp_creditcardarray);
		var jsonData7 = angular.toJson($scope.emp_insurancearray);
		var jsonData8 = angular.toJson($scope.emp_bankarray);
		var jsonData9 = angular.toJson($scope.bankloanarray);
		var jsonData10 = angular.toJson($scope.familyarray);
		var jsonData11 = angular.toJson($scope.salaryarray);
		var jsonData12 = angular.toJson($scope.referencearray);
		var nearestairport="";
		if($scope.emp_city4 !="" && $scope.emp_country4 !="" && $scope.emp_city4 !=null && $scope.emp_country4 !=null){
			nearestairport=$scope.emp_city4+','+$scope.emp_country4;
		}
		var xsrf = $.param({emp_id:$scope.employeeid,  localjobtitle:$scope.localjobtitle, localempcode:$scope.localempcode ,  emp_code:$scope.emp_code, emp_fname:$scope.emp_fname,emp_mname:$scope.emp_mname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_marital:$scope.emp_marital, emp_religion:$scope.emp_religion, emp_blood_group:$scope.emp_blood_group, emp_known_lang:$scope.emp_known_lang, emp_doj:$scope.emp_doj, emp_doc:$scope.emp_doc, emp_visa_type:$scope.emp_visa_type, emp_gender:$scope.emp_gender, emp_contact1:$scope.emp_contact1, emp_email1:$scope.emp_email1, emp_address1:$scope.emp_address1, emp_country1:$scope.emp_country1, emp_city1:$scope.emp_city1, emp_zipcode1:$scope.emp_zipcode1, emp_contact2:$scope.emp_contact2, emp_email2:$scope.emp_email2, emp_address2:$scope.emp_address2, emp_country2:$scope.emp_country2, emp_city2:$scope.emp_city2, emp_zipcode2:$scope.emp_zipcode2, emp_contact3:$scope.emp_contact3, emp_email3:$scope.emp_email3, emp_address3:$scope.emr_name+','+$scope.emp_address3, emp_country3:$scope.emp_country3, emp_city3:$scope.emp_city3, emp_zipcode3:$scope.emp_zipcode3, emp_report_to:$scope.emp_report_to, emp_division:$scope.emp_division, emp_depart:$scope.emp_depart, emp_desig:$scope.emp_desig, emp_location:$scope.emp_location, emp_shift:$scope.emp_shift, emp_sts:$scope.emp_sts, emp_grade:$scope.emp_grade, emp_workdays:$scope.chk7+','+$scope.chk1+','+$scope.chk2+','+$scope.chk3+','+$scope.chk4+','+$scope.chk5+','+$scope.chk6, emp_functional:$scope.emp_functional , salaryctc:$scope.salaryctc ,  emp_workarray:jsonData1, emp_qualificationarray:jsonData2, emp_documentarray:jsonData3, paypattern:$scope.chk8, bankname:$scope.bankname, agent_id:$scope.agent_id, bankifsccode:$scope.bankifsccode, salarytype:$scope.salarytype,modepayment:$scope.modepayment, bankaddress:$scope.bankaddress, emp_dependant:jsonData4,emp_type:$scope.emp_type,emp_skill:jsonData5,emp_creditcard:jsonData6,emp_insurance:jsonData7,cmp_email:$scope.cmp_email,emp_experience:$scope.year+','+$scope.month,  airticket:$scope.chk9, oncein:$scope.onceinmonth,ticketclass:$scope.ticketclass, nearestairport:nearestairport, iatafare:$scope.iatafare, ticketamt:$scope.ticketamt,nomonths:$scope.nomonths , salincreamentper:$scope.salincreamentper , instructions:$scope.instructions,emp_ltadetails:jsonData10,emp_bank:jsonData8,emp_bankloan:jsonData9,provision:$scope.provision,familydetails:family,personal_no:$scope.personal_no ,emp_salarydetails:jsonData11,overtimepay:$scope.chk10,referencearray:jsonData12, emp_channel:$scope.emp_channel, emp_costcentre:$scope.emp_costcentre, cocentre:$scope.costcenter, emp_visa_cat:$scope.emp_visa_cat, fileno:$scope.fileno, uidno:$scope.uidno,geo_center:$scope.geo_center});
		$http({
			url: path+'employee/updatedeemployee',
			method: "POST",
			headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
			data: xsrf
				
		}).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$( "#test" ).removeAttr('src');
				if($scope.files != ""){
					$scope.uploadFile($val);
				}
				if($scope.document != ""){
					$scope.uploadDocument($val);
				}
				if($scope.visadoc != ""){
					$scope.uploadVisa($val);
				}
				if($scope.passport != ""){
					$scope.uploadPassport($val);
				}else{
					if($val==1){
						//window.open(path+"employee/employeelist", "_self");
						$timeout(function(){window.open(path+"employee/employeelist", "_self");}, 4000);
					}
				}
					$scope.callout=0;
					$scope.emppic="";
					$scope.emp_code="";
					$scope.files="";
					$scope.emp_report_to="";
					$scope.emp_division="";
					$scope.emp_grade="";
					$scope.emp_depart="";
					$scope.costcenter="";
					$scope.emp_channel="";
					$scope.emp_desig="";
					$scope.emp_location="";
					$scope.emp_shift="";
					$scope.geo_center="";
					$scope.emp_sts="";
					$scope.chk1 = false; 
					$scope.chk2 = false;
					$scope.chk3 = false;
					$scope.chk4 = false; 
					$scope.chk5 = false;
					$scope.chk6 = false;
					$scope.chk7 = false;
					$scope.emp_fname="";
					$scope.emp_lname="";
					$scope.emp_dob="";
					$scope.emp_gender="";
					$scope.emp_marital="";
					$scope.emp_blood_group="";
					$scope.emp_nationality="";
					$scope.emp_visa_type="";
					$scope.emp_known_lang="";
					$scope.emp_religion = "";
					$scope.emp_functional="";
					$scope.emp_doj="";
					$scope.emp_doc="";
					$scope.emp_contact1="";
					$scope.emp_email1="";
					$scope.emp_address1="";
					$scope.emp_country1="";
					$scope.emp_city1="";
					$scope.emp_zipcode1="";

					$scope.emp_contact2="";
					$scope.emp_email2="";
					$scope.emp_address2="";
					$scope.emp_country2="";
					$scope.emp_city2="";
					$scope.emp_zipcode2="";

					$scope.emp_contact3="";
					$scope.emp_email3="";
					$scope.emp_address3="";
					$scope.emp_country3="";
					$scope.emp_city3="";
					$scope.emp_zipcode3="";
					$scope.salaryctc="";
					$scope.paypattern="";
					$scope.modepayment="";
					$scope.bankname="";
					$scope.bankifsccode="";
					$scope.bankaccountnumber="";
					$scope.bankaddress="";
					$scope.emp_type="";
					$scope.cmp_email="";
					$scope.emp_experience="";
					$scope.employeeid=0;
					
					$scope.airport="";
					$scope.immigration="";
					$scope.visa="";
					$scope.visacost="";
					$scope.airticket="";
					$scope.onceinyear="";
					$scope.onceinmonth="";
					$scope.ticketclass="";
					$scope.iatafare="";
					$scope.ticketamt="";
					$scope.instructions="";
					$scope.provision="";
					
				}else{
					errorMessage(data.errorMsg);
				}
				
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
		$scope.hastrue=false;
}

//////////////save checklist /////////////////

$scope.onsavechecklist = function($val)
{

$scope.hastrue=true;
//var employeeid=$("[name='type']").val();

var json=angular.toJson($scope.checklistarray);				
var xsrf = $.param({employeeid:$scope.employeeid, checklist:json});
  $http({
        url: path+'employee/saveChecklist',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	  
			
			if(data.status){
				successMessage(data.successMsg);
				
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/employeelist", "_self");}, timeo);
					}
				
				
			}else{
				errorMessage(data.errorMsg);
				//window.open(path+"employee/onboard_employee_list", "_self");
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


	
	///////////////////////////////////////image upload///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    
    //the save method
    $scope.uploadFile = function($val) {
	
	var emp=$scope.employeeid;
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeImage",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
				formData.append('emp_id', emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/employeelist", "_self");}, timeo);
				}
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
				}
			}
			else{
				errorMessage(data.errorMsg);
			}
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	//////////////////document upload///////////////////
	
	$scope.document = [];

    //listen for the file selected event
    $scope.$on("documentSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
        });
    });
	
	$scope.$on("companySelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.document.push(args.file);
        });
    });
	
	
	$scope.uploadDocument = function($val) {
	
	var emp=$scope.employeeid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeDocument/1",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //now add all of the assigned files
               //console.log($scope.myConcatenatedDocumentArray);
			   var i=0;
				while(i < $scope.documentarray.length) {//console.log(document.getElementById(i).value);
                    if(document.getElementById(i).value!=""){console.log('sdgghs');
              //      if($scope.documentarray[i].value!=""){//console.log('sdgghs');
				//	var docid=document.getElementById(i).name;
					var docid=$scope.documentarray[i]['name'];
					console.log(docid);
					formData.append('doc_id' + i,docid);
					formData.append("file" + i, $("#"+i).prop("files")[0]);
				//	formData.append("file" + i, $("#"+i).prop("files")[0]);

					}
					i++;
                }
				var j=0;
				j=i;
				for (var i = 0; i < $scope.companydocumentarray.length; i++) {
					var cdoc=i+'cdoc';
                    if(document.getElementById(cdoc).value!=""){
					var docid=document.getElementById(cdoc).name;
					formData.append('doc_id' + j,docid);
					formData.append("file" + j, $("#"+cdoc).prop("files")[0]);
					}
					j++;
                }
				formData.append('emp_id',emp);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.document }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
			//		$timeout(function(){window.open(path+"employee/employeelist", "_self");}, 11000);
				}
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, 1000);
					} 
			}
			else{
				errorMessage(data.errorMsg);
			}
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
	//////////////////visa upload///////////////////
	
	$scope.visadoc = [];

    //listen for the file selected event
    $scope.$on("visaSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.visadoc.push(args.file);
			
        });
    });
	
	
	$scope.uploadVisa = function($val) {
	
	
	var emp=$scope.employeeid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeDocument/2",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//errorMessage(visadoc.getElementById(i).name);
                }
				for (var i = 0; i < $scope.familyarray.length; i++) {
				   if(document.getElementById(i+1).value!=""){
					var docid=document.getElementById(i+1).name;
					
					}
                }
				
				
				formData.append('emp_id',emp);
				formData.append('doc_id',docid);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.visadoc }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/employeelist", "_self");}, timeo);
				}
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					}
			}
			else{
				errorMessage(data.errorMsg);
			}
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
	$scope.uploaddoc = function()
	{
		
		for (var i = 0; i < $scope.documentarray.length; i++) {
            if(document.getElementById(i).value!=""){
				var docid=document.getElementById(i).name;
				var file_data=$("#"+i).prop("files")[0];
				var form_data=new FormData();
				form_data.append("file0",file_data);
				form_data.append("emp_id",$scope.employeeid);
				form_data.append("docarray",$scope.documentarray[i]);
				$.ajax({
					type:"POST",
					url: path+"employee/uploadEmployeeDocument/1",
					datatype:'script',
					cache:false,
					contentType:false,
					processData:false,
					data:form_data,
					success:function(data){
						//console.log(data)
						//$scope.selectbackground(data);
					},
					error:function(){
					//----------
					}
				});
			}
        }
			
	}	
	//////////////////passport upload///////////////////
	
	$scope.passport = [];

    //listen for the file selected event
    $scope.$on("passportSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.passport.push(args.file);
			
        });
    });
	
	
	$scope.uploadPassport = function($val) {
	
	
	var emp=$scope.employeeid;
	
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/uploadEmployeeDocument/3",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
					//errorMessage(passport.getElementById(i).name);
                }
				for (var i = 0; i < $scope.familyarray.length; i++) {
					
                    if(document.getElementById(i).value!=""){
					var docid=document.getElementById(i).name;
					
					}
                }
				
				
				formData.append('emp_id',emp);
				formData.append('doc_id',docid);
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: {  files: $scope.passport }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
						
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/employeelist", "_self");}, timeo);
				}
				if($val==2){
					//window.open(path+"profile/personal_detail", "_self");
					$timeout(function(){window.open(path+"profile/personal_detail", "_self");}, timeo);
					}
			}
			else{
				errorMessage(data.errorMsg);
			}
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    }
	
	////////////new joinee checklist////////////////
	
	$scope.onfetchchecklist =function()
	{
	   
		$scope.hastrue=true;
		
		$http({
			url: path+'employee/getnewjoineechecklist',
			method: "POST",
			//data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					
					$scope.checklistarray=data.data;
					console.log($scope.checklistarray.length);
					
					if($scope.checklistarray.length==0){$scope.newoncreate(1);}
					$timeout(function(){$scope.step=2;}, timeo);
					
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	///////////new joinings oncreate//////////////
	
	
$scope.newoncreate = function($val)
{

$scope.hastrue=true;
//var employeeid=$("[name='type']").val();

var json=angular.toJson($scope.checklistarray);				
var xsrf = $.param({employeeid:$scope.employeeids, emp_code: $scope.emp_code,  emp_report_to:$scope.emp_report_to, emp_division:$scope.emp_division, emp_depart:$scope.emp_depart, emp_desig:$scope.emp_desig, emp_location:$scope.emp_location, emp_shift:$scope.emp_shift, emp_sts:$scope.emp_sts, emp_grade:$scope.emp_grade, emp_workdays:$scope.chk7+','+$scope.chk1+','+$scope.chk2+','+$scope.chk3+','+$scope.chk4+','+$scope.chk5+','+$scope.chk6,salaryctc:$scope.salaryctc,emp_type:$scope.emp_type,emp_doj:$scope.emp_doj,emp_role:$scope.emp_role,probation:$scope.provision,checklist:json});



  $http({
        url: path+'employee/createNewemployee',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				if($val==1){
					//window.open(path+"employee/employeelist", "_self");
					$timeout(function(){window.open(path+"employee/employeelist", "_self");}, timeo);
					}
				
				
			}else{
				$scope.step=1;
				errorMessage(data.errorMsg);
				$timeout(function(){window.open(path+"employee/onboard_employee_list/2");}, timeo);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}



});	
	
	/////////////////////////// Notification Controller Starts From Here  ///////////////////////////////////

app.controller('notificationCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;

	$scope.notificationid=0;
	$scope.notificationname="";
	$scope.message="";
	$scope.fileattach="";
	
	$scope.sendmailsts="";
	$scope.division="";
	$scope.department="";
	$scope.designation="";
	$scope.employeeids="";
	$scope.startdate="";
	$scope.enddate="";
	$scope.priority="";
	
	$scope.employees=[];
	$scope.selection=[];
	$scope.priorityarray=[];
	

	onfetch('setup/getalldivision',1);
	onfetch('setup/getalldepartment',2);
	onfetch('setup/getalldesignation',3);
	onfetch('employee/getallemployee',4);
	//onfetch('employee/getallsenioremployee',4);
	onfetch('other',5);
	
	/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.notificationid=$id;
}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletenotification/'+$scope.notificationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.notificationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
		
		$('.type').iCheck({
          radioClass: 'iradio_square-blue',
		  checkboxClass: 'icheckbox_square-blue',
          increaseArea: '20%' // optional
        });
		
        $('#sendmailsts').on('ifChecked', function(event){
			$scope.sendmailsts="1";
		});
		
		$('.type').on('ifChecked', function(event){	
		
			if(event.target.value=="1"){
				$('#personal2').removeClass("fade in active");
				$('#personal1').addClass("fade in active");
				$scope.togglevalue=1;
				
				}
			if(event.target.value=="2"){
				$('#personal1').removeClass("fade in active");
				$('#personal2').addClass("fade in active");
				$scope.togglevalue=2;
				$scope.division=0;
				$scope.department=0;
				$scope.designation=0;
				
				if($scope.selection.length != 0){
					$("#update").prop("disabled", false);
					$("#update1").prop("disabled", false);
					$("#create").prop("disabled", false);
					$("#create1").prop("disabled", false);
					$("#empid").css('border-color', '#2A7C41');
				}
				
				
								
			}
		});	
		
	
	$scope.toggleSelection = function($idx) {
		//errorMessage($idx);
	 //var idx = $scope.employees[$index].id;
	 //var result = $.grep($scope.selection, function(e){ return e.id == idx; });
	 var flg=true;
	 var x=0;
	 for ( var i=0; i<$scope.selection.length; i++) {
		if ($scope.selection[i].id == $idx){ 
			flg = false;x=i;
			break;
			}
	  }
	 
	  if(flg){
		var x=0;
		for ( var i=0; i<$scope.employees.length; i++) {
			if ($scope.employees[i].id == $idx){ 
				x=i;
				break;
				}
		  }
		  
		$scope.selection.insert($scope.selection.length,$scope.employees[x]);
		$scope.employees[x].sts=1;
	  }else{
		$scope.selection.remove(x);
		$scope.employees[x].sts=0;
	  }
				if($scope.selection.length != 0){
					
					$("#empid").css('border-color', '#2A7C41');
				}
				else{
				
				$("#empid").css('border-color', 'maroon');
				}
   };
   
   
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==1){
						$scope.divisionarray=[];
						$scope.divisionarray=data.data;
						$scope.divisionarray.insert(0,{id:0,name:"-------- All --------"});
					}else if($id==2){
						$scope.departarray=[];
						$scope.departarray=data.data;
						$scope.departarray.insert(0,{id:0,name:"-------- All ---------"});
					}else if($id==3){
						$scope.desigarray=[];
						$scope.desigarray=data.data;
						$scope.desigarray.insert(0,{id:0,name:"-------- All --------"});
					}else if($id==4){
						$scope.employees=[];
						$scope.employees=data.data;
						$scope.onfetchnotification($scope.notificationid);
						
					}
					else if($id==6){
						$scope.channelarray=[];
						$scope.channelarray=data.data;
						$scope.channelarray.insert(0,{id:0,name:"-------- All --------"});
					}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	
	$scope.onfetchnotification =function($id)
	{
	   
		$scope.hastrue=true;
		var xsrf = $.param({notificationid: $id});
		$http({
			url: path+'employee/getanotification',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.notificationname=data.data[0]['notificationname'];
					$scope.message=data.data[0]['message'];
					$scope.fileattach=data.data[0]['fileattach'];
					$scope.division=Number(data.data[0]['division']);
					$scope.department=Number(data.data[0]['department']);
					$scope.channel=Number(data.data[0]['channel']);
					$scope.designation=Number(data.data[0]['designation']);
					var temparr =data.data[0]['employeeids'];
					$scope.startdate=data.data[0]['startdate'];
					$scope.enddate=data.data[0]['enddate'];
					$scope.priority=data.data[0]['priority'];
					$scope.togglevalue=data.data[0]['toggle'];
					$('#allemp').iCheck(($scope.togglevalue=="1")?'check':'uncheck');
					$('#spcemp').iCheck(($scope.togglevalue=="2")?'check':'uncheck');
					//$scope.appsts=data.data[0]['appsts'];
					for ( var x=0; x<temparr.length; x++){
					for ( var i=0; i<$scope.employees.length; i++){
						if ($scope.employees[i].id == temparr[x]){ 
							$scope.selection.insert($scope.selection.length,$scope.employees[i]);
							$scope.employees[i].sts=1;
							break;
							}
						}
					}
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });

	$scope.oncreate = function($val)
	{

	$scope.hastrue=true;
	
	$scope.employeeids=angular.toJson($scope.selection);
/*	var xsrf = $.param({notificationname: $scope.notificationname, message: $scope.message, fileattach: $scope.fileattach, division: $scope.division, department: $scope.department,designation: $scope.designation, employeeids: $scope.employeeids, startdate: $scope.startdate, enddate: $scope.enddate, priority: $scope.priority, toggle:  $scope.togglevalue, sendmailsts: $scope.sendmailsts}); */
	  $http({
			url: path+'employee/createnotification',
			method: "POST",
	//		data: xsrf,
            headers: { 'Content-Type': undefined },
			transformRequest: function (data) {
			 var formData = new FormData();
			  for (var i = 0; i < data.files.length; i++) {
                //    add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
			 	  formData.append('notificationid', $scope.notificationid);
			 	  formData.append('notificationname', $scope.notificationname);
			 	  formData.append('message', $scope.message);
			 	  formData.append('division', $scope.division);
			 	  formData.append('department', $scope.department);
			 	  formData.append('designation', $scope.designation);
			 	  formData.append('priority', $scope.priority);
			 	  formData.append('employeeids', $scope.employeeids);
			 	  formData.append('startdate', $scope.startdate);
			 	  formData.append('enddate', $scope.enddate);
			 	  formData.append('toggle', $scope.togglevalue);
			 	  formData.append('sendmailsts', $scope.sendmailsts);
				  return formData;
            },
            data: { files: $scope.files }

		  }).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					
					$scope.notificationname="";
					$scope.message="";
					$scope.division="";
					$scope.fileattach="";
					$scope.department="";
					$scope.designation="";
					$scope.employeeids="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationtype="";
					$scope.notificationid=0;
					
					if($val==1){
						//window.open(path+"employee/notification", "_self");
						$timeout(function(){window.open(path+"employee/notification", "_self");}, timeo);
					}
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	
	
	$scope.onupdate = function($val)
	{
	$scope.hastrue=true;
	var jsonData1=angular.toJson($scope.selection);
/*	var xsrf = $.param({notificationid: $scope.notificationid, notificationname: $scope.notificationname, message: $scope.message, fileattach: $scope.fileattach, division: $scope.division, department: $scope.department,designation: $scope.designation,priority:$scope.priority, employeeids:jsonData1 , startdate: $scope.startdate, enddate: $scope.enddate,toggle:$scope.togglevalue}); */
	
			
	  $http({
			url: path+'employee/updatednotification',
			method: "POST",
	//		data: xsrf,
            headers: { 'Content-Type': undefined },
			
			 transformRequest: function (data) {
			 var formData = new FormData();
			  for (var i = 0; i < data.files.length; i++) {
                //    add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
			 	  formData.append('notificationid', $scope.notificationid);
			 	  formData.append('notificationname', $scope.notificationname);
			 	  formData.append('message', $scope.message);
			 	  formData.append('division', $scope.division);
			 	  formData.append('department', $scope.department);
			 	  formData.append('designation', $scope.designation);
			 	  formData.append('priority', $scope.priority);
			 	  formData.append('employeeids', jsonData1);
			 	  formData.append('startdate', $scope.startdate);
			 	  formData.append('enddate', $scope.enddate);
			 	  formData.append('toggle', $scope.togglevalue);
				  formData.append('sendmailsts', $scope.sendmailsts);

				  return formData;
            },
            data: { files: $scope.files }

			}).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);
					
					$scope.notificationname="";
					$scope.message="";
					$scope.division="";
					$scope.fileattach="";
					$scope.department="";
					$scope.selection="";
					$scope.designation="";
					$scope.employeeids="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationid=0;
					if($val==1){
						//window.open(path+"employee/notification", "_self");
						$timeout(function(){window.open(path+"employee/notification", "_self");}, timeo);
					}
					
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
});
app.controller('grievanceCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;

	$scope.notificationid=0;
	$scope.notificationname="";
	$scope.message="";
	$scope.division="";
	$scope.department="";
	$scope.designation="";
	$scope.employeeids="";
	$scope.startdate="";
	$scope.enddate="";
	$scope.priority="";
	
	$scope.employees=[];
	$scope.selection=[];
	$scope.priorityarray=[];
	
$scope.onfetch=function(){
onfetch('other',5);
onfetch('employee/getallsenioremployee',4);

}
	
	//onfetch('employee/getallemployee',4);
	
	
		/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.notificationid=$id;
}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletegrievance/'+$scope.notificationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.notificationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
		
	
	
	$scope.toggleSelection = function($idx) {
		//errorMessage($idx);
	 //var idx = $scope.employees[$index].id;
	 //var result = $.grep($scope.selection, function(e){ return e.id == idx; });
	 var flg=true;
	 var x=0;
	 for ( var i=0; i<$scope.selection.length; i++) {
		if ($scope.selection[i].id == $idx){ 
			flg = false;x=i;
			break;
			}
	  }
	 
	  if(flg){
		var x=0;
		for ( var i=0; i<$scope.employees.length; i++) {
			if ($scope.employees[i].id == $idx){ 
				x=i;
				break;
				}
		  }
		  
		$scope.selection.insert($scope.selection.length,$scope.employees[x]);
		$scope.employees[x].sts=1;
	  }else{
		$scope.selection.remove(x);
		$scope.employees[x].sts=0;
	  }
				if($scope.selection.length != 0){
					
					$("#empid").css('border-color', '#2A7C41');
				}
				else{
				
				$("#empid").css('border-color', 'maroon');
				}
   };
   
   
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					
					 if($id==4){
						$scope.employees=[];
						$scope.employees=data.data;
						
					}else if($id==5){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
						
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchgrievance =function($id)
	{
	   
		$scope.hastrue=true;
		var xsrf = $.param({notificationid: $id});
		$http({
			url: path+'employee/getagrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					$scope.notificationname=data.data[0]['notificationname'];
					$scope.message=data.data[0]['message'];
					var temparr =data.data[0]['employeeids'];
					$scope.startdate=data.data[0]['startdate'];
					$scope.enddate=data.data[0]['enddate'];
					$scope.priority=data.data[0]['priority'];
					$scope.appsts=data.data[0]['appsts'];
					$scope.applydate=data.data[0]['applydate'];
					/*$timeout(function(){
						for ( var x=0; x<temparr.length; x++){
							for ( var i=0; i<$scope.employees.length; i++){
							if ($scope.employees[i].id == temparr[x]){ 
								$scope.selection.insert($scope.selection.length,$scope.employees[i]);
								$scope.employees[i].sts=1;
								break;
								}
							}
						}
					}, 1000);*/
					$scope.loginid=data.data[0]['loginid'];
					$scope.empname=data.data[0]['empname'];
					$scope.approverlist=data.data[0]['approverlist'];
					
						
				}
				
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.oncreategrievance = function($val)
	{

	$scope.hastrue=true;
	
	var jsonData1=angular.toJson($scope.selection);
	var xsrf = $.param({notificationname: $scope.notificationname, message: $scope.message,  employeeids:jsonData1, startdate: $scope.startdate, enddate: $scope.enddate,priority:$scope.priority,appsts:$scope.appsts});
	  $http({
			url: path+'employee/creategrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					
					
					
					if($val==1){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"employee/grievance", "_self");}, timeo);
					}
					if($val==2){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"profile/grievances", "_self");}, timeo);
					}
					$scope.notificationname="";
					$scope.message="";
					$scope.employeeids="";
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationtype="";
					$scope.notificationid=0;
					$scope.selection=0;
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.onupdategrievance = function($val)
	{

	
	$scope.hastrue=true;
	var jsonData1=angular.toJson($scope.selection);
	var xsrf = $.param({notificationid: $scope.notificationid, notificationname: $scope.notificationname, message: $scope.message, priority:$scope.priority, employeeids:jsonData1  ,appsts:$scope.appsts});
	  $http({
			url: path+'employee/updatedgrievance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);
					
					
					if($val==1){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"employee/grievance", "_self");}, timeo);
					}
					if($val==2){
						//window.open(path+"employee/grievance", "_self");
						$timeout(function(){window.open(path+"profile/grievances", "_self");}, timeo);
					}
					$scope.notificationname="";
					$scope.message="";
					$scope.employeeids="";
					$scope.selection=0;
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationid=0;
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	$scope.oncomment = function($val)
	{
	$scope.hastrue=true;
	
	var xsrf = $.param({notificationid: $scope.notificationid, comments: $scope.comment, forwardto: $scope.forwardto,type:$val});
	  $http({
			url: path+'employee/grievanceapproval',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
			
				if(data.status){
					successMessage(data.successMsg);
					
					$timeout(function(){window.open(path+"employee/grievance", "_self");}, timeo);
										
					$scope.notificationname="";
					$scope.message="";
					$scope.employeeids="";
					$scope.selection=0;
					$scope.startdate="";
					$scope.enddate="";
					$scope.priority="";
					$scope.notificationid=0;
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}

	
	});
///////////////////////////// Issue asset Controller Starts From Here  ///////////////////////////////////

app.controller('issueassetCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.issueassetid=0;
$scope.emp_id="";
$scope.assetid="";
$scope.issue_date="";
$scope.return_date="";
$scope.desc="";
$scope.employeearray=[];
$scope.assetarray=[];

onfetch('employee/getallemployee',1);
onfetch('setup/getallasset',2);

/////////////////////////////
$scope.getId = function($id) {
	$scope.issueassetid=$id;
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteissueasset/'+$scope.issueassetid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.issueassetid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.employeearray=[];
					$scope.employeearray=data.data;
					
				}else if($id==2){
					$scope.assetarray=[];
					$scope.assetarray=data.data;
				}
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}


$scope.onfetchissueasset =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({issueassetid: $id});
	$http({
        url: path+'employee/getaissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.emp_id=data.data[0]['emp'];
				$scope.assetid=data.data[0]['asset'];
				$scope.issue_date=data.data[0]['issuedate'];
				$scope.return_date=data.data[0]['returndate'];
				$scope.desc=data.data[0]['desc'];
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({emp_id:$scope.emp_id,assetid:$scope.assetid,issue_date:$scope.issue_date,return_date:$scope.return_date,desc:$scope.desc});
  $http({
        url: path+'employee/createissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.assetid="";
				$scope.emp_id=""
				$scope.issue_date="";
				$scope.return_date="";
				$scope.desc="";
				$scope.issueassetid=0;
				
				if($val==1){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/issueasset", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({issueassetid: $scope.issueassetid, return_date:$scope.return_date});
  $http({
        url: path+'employee/updatedissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.assetid="";
				$scope.emp_id=""
				$scope.issue_date="";
				$scope.return_date="";
				$scope.desc="";
				$scope.issueassetid=0;
				if($val==1){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/issueasset", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});




//////////////////////////////////// Dashboard Controller Starts From Here  ///////////////////////////////////

app.controller('dashboardCtrl', function($scope, $http) {

$scope.hastrue=false;

$scope.issueassetid=0;
$scope.emp_id="";
$scope.assetid="";
$scope.issue_date="";
$scope.return_date="";
$scope.desc="";
$scope.previous="";
$scope.nextmonth="";
$scope.filscalid=0;
$scope.onfetchdashboard= function($val,$type=""){
	if($val ==1)
	{
		onfetch('employee/getbirthdaydashboard',1,$type);
	}else{
		onfetch('employee/getbirthdaydashboard',2,$type);
	}

}

//onfetch('employee/getnewjoiningdashboard',2);

function onfetch($val, $id, $type)
{
	$scope.hastrue=true;
	var xsrf = $.param({fiscalid: $scope.filscalid});
	$http({
        url: path+$val+'/'+$id+'/'+$type,
        method: "POST",
        data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				$scope.fiscalformat=data.fiscal_format;
				$scope.filscalid=data.filscalid;
				if($id==1){
				
				///// MONTHLY NEW JOININGS BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart1',
					  resize: true, stacked:false,
					  xLabels: 'months', 
					  xLabelAngle: -90,
					  data: data.data['newjoinings'],
					  barColors: ['#FF0000'],
					  xkey: 'months',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE BY AGING BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyage'],
					  barColors: ['#46BD00'],
					  xkey: 'name',
					  ykeys: ['count'],//data.data['employeebyage']['ykey'],
					  labels: ['Total Employee'],//data.data['employeebyage']['label'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE BY QUALIFICATION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyqualify'],
					  barColors: ['#A500BC'],
					  xkey: 'name',
					  ykeys: ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
				
				///// EMPLOYEE TRANSFER BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart4',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['totaltransfer'],
					  barColors: ['#FF9C00'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE PROMOTION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart5',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['totalpromotion'],
					  barColors: ['#ff3399'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE BY SKILLS BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart6',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyskills'],
					  barColors: ['#3399FF'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
				
				///// OVERALL TURNOVER BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart7',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['overallturnover'],
					  barColors: ['#00CCFF','#FB749F','#FFCE6D'],
					  xkey: 'name',
					  ykeys:  ['1','2','3'],
					  labels: ['Resigned','Terminated','Absconded'],
					  hideHover: 'auto'
					});	
				
				///// TURNOVER BY REASON BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['turnoverbyreason'],
					  barColors: ['#FFE609'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
				
				///// TURNOVER BY DIVISION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart9',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['turnoverbydivision'],
					  barColors: ['#FFB3AD','#9BBA8E','#7F88CA'],
					  xkey: 'name',
					  ykeys:  ['1','2','3'],
					  labels: ['Resigned','Terminated','Absconded'],
					  hideHover: 'auto'
					});	
				
				}else if($id==2){
					///// MONTHLY NEW JOININGS BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart1',
					  resize: true, stacked:false,
					  xLabels: 'months', 
					  xLabelAngle: -90,
					  data: data.data['newjoinings'],
					  barColors: ['#FF0000'],
					  xkey: 'months',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE BY AGING BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart2',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyage'],
					  barColors: ['#46BD00'],
					  xkey: 'name',
					  ykeys: ['count'],//data.data['employeebyage']['ykey'],
					  labels: ['Total Employee'],//data.data['employeebyage']['label'],
					  hideHover: 'auto'
					});	
					
				///// EMPLOYEE BY QUALIFICATION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyqualify'],
					  barColors: ['#A500BC'],
					  xkey: 'name',
					  ykeys: ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
				
					$scope.employeebytransfer=data.data['totaltransfer'];
					$scope.employeebypromotion=data.data['totalpromotion'];
					
					///// EMPLOYEE BY SKILLS BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart4',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['employeebyskills'],
					  barColors: ['#3399FF'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
					///// OVERALL TURNOVER BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart7',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['overallturnover'],
					  barColors: ['#00CCFF','#FB749F','#FFCE6D'],
					  xkey: 'name',
					  ykeys:  ['1','2','3'],
					  labels: ['Resigned','Terminated','Absconded'],
					  hideHover: 'auto'
					});	
				
				///// TURNOVER BY REASON BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['turnoverbyreason'],
					  barColors: ['#FFE609'],
					  xkey: 'name',
					  ykeys:  ['count'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});	
				
				///// TURNOVER BY DIVISION BAR CHART  ////////////
					var bar = new Morris.Bar({
					  element: 'bar-chart9',
					  resize: true, stacked:false,
					  xLabels: 'name', 
					  xLabelAngle: -90,
					  data: data.data['turnoverbydivision'],
					  barColors: ['#FFB3AD','#9BBA8E','#7F88CA'],
					  xkey: 'name',
					  ykeys:  ['1','2','3'],
					  labels: ['Resigned','Terminated','Absconded'],
					  hideHover: 'auto'
					});	
				
				}
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

});

///////////////////import controller/////////////////

app.controller('importCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.emp_fname=0;
$scope.emp_lname=2;
$scope.emp_mname=1;
$scope.emp_ctc=4;
$scope.emp_dob=3;
$scope.emp_nationality=5;
$scope.emp_maritalstatus=6;
$scope.emp_religion = 7;
$scope.emp_bloodgroup=8;
$scope.emp_doj=9;
$scope.emp_doc=10;
$scope.emp_gender=11;
$scope.emp_contact_no=12;
$scope.emp_email=13;
$scope.emp_address=14;
$scope.emp_country=15;
$scope.emp_city=16;
$scope.emp_zipcode=17;


///////////////////////////////////////file upload/import for new joinings////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
   $scope.headnamearray=[]; 
    //the save method
    $scope.importFile = function() {
	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/importheadersfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
					$scope.headnamearray=data.data;	
					
					
			}
			else{
					errorMessage(data.errorMsg);
				}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	
	$scope.repeatemp="";
	$scope.importemp="";
	$scope.insertheaders = function($val)
	{	
		$scope.hastrue=true;
		
		var xsrf = $.param({emp_fname:$scope.emp_fname, emp_lname:$scope.emp_lname, emp_dob:$scope.emp_dob, emp_nationality:$scope.emp_nationality, emp_maritalstatus:$scope.emp_maritalstatus, emp_religion:$scope.emp_religion, emp_bloodgroup:$scope.emp_bloodgroup,  emp_doj:$scope.emp_doj, emp_doc:$scope.emp_doc,  emp_gender:$scope.emp_gender, emp_contact_no:$scope.emp_contact_no, emp_email:$scope.emp_email, emp_address:$scope.emp_address, emp_country:$scope.emp_country, emp_city:$scope.emp_city, emp_zipcode:$scope.emp_zipcode,emp_mname:$scope.emp_mname,emp_ctc:$scope.emp_ctc });
		$http({
			url: path+'employee/insertheaders',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					//errorMessage(data.successMsg);
					$scope.importemp = data.importemp;
					$scope.repeatemp = data.repeatemp;					
					//window.open(path+"employee/onboard_employee_list", "_self");
				}else{
					
					//errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
onfetch("employee/getallnewemployee",1);	
	
function onfetch($val, $id)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			
	 		if(data.status){
				if($id==1){
					$scope.newemployeearray=[];
					$scope.newemployeearray=data.data;
					//$scope.divisionarray.insert(0,{id:0,name:"Select Division"});
				}
				
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}
function b64EncodeUnicode(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-Z]{8})/g, function(match, p1) {
        return String.fromCharCode('0x' + p1);
    }));
}	
	$scope.click = function()
	{	$scope.hastrue=true;
		 //alert(selected)
		var employeeids=selected.toString();
		if(employeeids==""){
			errorMessage("Select Employee");
			$scope.selected=0;
			return false;
		}else{
			$scope.selected=employeeids;
			return;
		}
		//employeeids=b64EncodeUnicode(employeeids);
				/*var xsrf = $.param({employeeid:employeeids});

				$http({
				url: path+'employee/onboard_company_details',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
				}).success(function (data, status, headers, config) {
					window.open(path+'employee/onboard_company_details1/'+employeeids);
					
					$scope.hastrue=false;
				}).error(function (data, status, headers, config) {
					//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
					$scope.hastrue=false;
				});*/
	
	}
	$scope.EmpRemain=true;
$scope.getEmpLimit = function()
{
	$scope.hastrue=true;
	$http({
        url: path+"profile/getEmpLimit",
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	 		if(data.status){
					$scope.EmpRemain=data.data;
					}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

$scope.onsend = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({mailto:$scope.mailto, subject:$scope.subject, msg:$scope.msg });
		$http({
			url: path+'employee/sendonboardlink',
			method: "POST",
			data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
	 		if(data.status){
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"employee/onboard_employee_list/2", "_self");}, timeo);
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		
}

});


///////////////////import All Data controller/////////////////

app.controller('importdataCtrl', function($scope, $http) {

$scope.hastrue=false;

$scope.modulesarr = [];
$scope.columnsarr = [];

fetchmodel();

function fetchmodel()
{
	$scope.hastrue=true;
	$http({
        url: path+'employee/getmodules',
        method: "POST",
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.modulesarr=data.data;
				
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

 $scope.fetchmodelcolumn = function()
{
	$scope.hastrue=true;
	var xsrf = $.param({tablename: $scope.modulename});
	$http({
        url: path+'employee/getcolumnname',
        method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.columnsarr=data.data;
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

 $scope.importfiledata = function()
{
var temparr = angular.toJson($scope.columnsarr);

	$scope.hastrue=true;
	var xsrf = $.param({tablename: $scope.modulename, columnsdata: temparr});
	$http({
        url: path+'employee/importfiledata',
        method: "POST",
		data: xsrf,
		headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
			}else{
				errorMessage(data.errorMsg);
			}			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

///////////////////////////////////////file upload/import for new joinings////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
   $scope.headnamearray=[]; 
    //the save method
    $scope.importFile = function() {	

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"employee/importheadersfile",
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
					$scope.headnamearray=data.data;					
			}
			else{
					errorMessage(data.errorMsg);
				}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
			
		}).
        error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	
	$scope.repeatemp="";
	$scope.importemp="";
	
});

/////////////////////////// emphierarchy Controller Starts From Here  ///////////////////////////////////

app.controller('emphierarchyCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.roles=[];
$scope.rol=[];
//onloadtreeview();
$scope.empid=0;
/////////////////////////////////////////

$scope.onloadtreeview = function($val)
{
	$scope.rol=[];
	$scope.hastrue=true;
var xsrf = $.param({empid: $val});
	$http({
        url: path+'employee/getemployeehierarchy',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			$scope.hastrue=false;
			if(data.status){
				$scope.rol=data.data;
				//alert($scope.rol);
												
				var org_chart = $('#orgChart').orgChart({
				    data: $scope.rol,
				    showControls: true,
				    allowEdit: false,
				    onAddNode: false,
				    onDeleteNode: false,
				    onClickNode: function(node){
				    //alert("click on node");
					//log('Clicked node '+node.data.id);
				    }

				});
				
			}
			
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});




/////////////////////////// Job Modification Controller Starts From Here  ///////////////////////////////////

app.controller('jobmodificationCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.jobmodificationid=0;
$scope.modtype=1;
$scope.ptype=0;
$scope.applyfrom="";
$scope.empstsarr=[];
 $scope.approverresult=3;
$scope.modtypearr=[{id:1, name:"Promotion"}, {id:2, name:"Demotion"}, {id:3, name:"Salary Increment"}, {id:4, name:"Salary decrement"}, {id:5, name:"Grade Change"}];
/*{id:5, name:"Termination Date" , type:4}, {id:6, name:"Date of Confirmation"},*/
$scope.fieldarr=[{id:1, name:"Division", type:3}, {id:2, name:"Cost Centre",type:3},  {id:3, name:"Designation",type:2}, {id:4, name:"Grade",type:2},{id:5, name:"Location" , type:3}, {id:7, name:"Gross Salary", type:2}, {id:6, name:"Confirmation Date", type:4}, {id:8, name:"Employee Status", type:4},{id:3, name:"Designation" , type:3}];
$scope.fieldarrvalue=[];
$scope.employee=[];

$scope.jobmodifyarr=[];

//onfetchemployee("employee/getallemployee",8);
//onfetchemployee("other",9);

/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.jobmodificationid=$id;
}
////////Approved/Reject Jobmodification////////
$scope.onaddcomment = function($id)
	{
		$('#comment').modal('show');
		 $scope.approverresult=$id;
		 console.log($scope.approverresult);
	}
	////////onfetch approval follow/////////
	$scope.onfetchApprover = function($id)
	{console.log($id);
		$scope.hastrue=true;
		var xsrf = $.param({jobmodificationid: $id});
		$http({
			url: path+'employee/getalljobmodificationapprover',
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					$scope.employeearray=[];
						$scope.employeearray=data.data;
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onapprove = function($val){ 
		
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ jobmodificationid:$scope.jobmodificationid, approverresult:$scope.approverresult, comment:$scope.comment });
		$http({
			url: path+'employee/approvejobmodiapproval',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"employee/jobmodification/"+$scope.modtype, "_self");}, timeo); 
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletejobmodification/'+$scope.jobmodificationid+"/"+$scope.modtype,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.jobmodificationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetch=function(){
	onfetchemployee("employee/getallemployee",8);
}
/* $scope.onfetch=function(){
	onfetchemployee("employee/getnotterminateemployee",8);
} */
function onfetchemployee($val, $index)
{
	$scope.hastrue=true;
	$http({
        url: path+$val,
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				if($index<6){
					$scope.fieldarrvalue[$index]=data.data;
				}else if($index==8){
					$scope.employee=data.data;
					if($scope.modtype<4){
						$scope.jobmodifyarr=[{id:1, name:"", oldvalue:"", newvalue:""}];
					}else{
						$scope.jobmodifyarr.insert(0,{id:5, name:"", oldvalue:"", newvalue:""});
						$scope.jobmodifyarr.insert(1,{id:8, name:"", oldvalue:"", newvalue:""});
						$scope.onchangeempcombo();
					}
				}else if($index==9){
					$scope.empstsarr=data.data;
				}
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchjobdetail =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({jobmodificationid: $id,modtype:$scope.modtype});
	$http({
        url: path+'employee/getajobmodification',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
					$scope.jobmodifyarr=data.data[0]['jobchild'];
					
					$scope.empid=data.data[0]['empid'];
					$scope.modifytype=data.data[0]['modifytype'];
					$scope.applyfrom=data.data[0]['applyfrom'];
					$scope.remarks=data.data[0]['remarks'];
					$scope.ptype=data.data[0]['promotiontype'];
					$scope.empname = data.data[0]['empname'];
					$scope.empdepart = data.data[0]['department'];
					$scope.empdesig = data.data[0]['designation'];
					$scope.empdivision = data.data[0]['division'];
						
					//$scope.onchangeempcombo();
			}		
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.empsts=false;


$scope.onchangeempcombo = function()
{
	
	//console.log($scope.employeeidmodel)
	if($scope.employeeidmodel != undefined)
	{
		if($scope.employeeidmodel.length>1)
		{
			errorMessage("Select only one Employee");
			$scope.employeeidmodel=[];
			return;
		}	
		else
			$scope.empid=parseInt($scope.employeeidmodel.toString());
	}
	$scope.employeeidmodel=undefined;
	for(var j=0; j<$scope.employee.length; j++)
	{
		if($scope.employee[j].id==$scope.empid)
		{
			if($scope.employee[j].empsts1 ==1 || $scope.employee[j].empsts1 ==2)
			{
				errorMessage("This Employee is not eligible for any employment changes");
				$scope.empdepart = "";
				$scope.empdesig = "";
				$scope.empdoj="";
				$scope.empsts=true;
				return;
			}else{
				$scope.empsts=false;
			}
			$scope.empdepart = $scope.employee[j].empdepartment;
			$scope.empdesig = $scope.employee[j].empdesignation;
			$scope.empdoj = $scope.employee[j].doj;
		//	alert($scope.empdoj);

			if($scope.empdoj!=""){
				//var datefrom=$($scope.empdoj).datepicker( "getDate" );
				//$scope.resumptiondate="";
				//$scope.empdoj= $filter('#applyfrom')(scope.empdoj, format('YYYY-MM-DD HH:mm:ss');
				//startDate: $scope.empdoj
			
				$scope.applyfrom="";
				$('#applyfrom').datepicker("remove");
				$('#applyfrom').datepicker({
				//startDate: datefrom
				startDate: $scope.empdoj
				//startDate: newdate($scope.empdoj)
				});
		}
		 
			for(var i=0; i<$scope.jobmodifyarr.length; i++)
			{
				var val = $scope.jobmodifyarr[i].name;
				if(val==1){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empdivision;
				}else if(val==2){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empdepartment;
				}else if(val==3){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empdesignation;
				}else if(val==4){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empgrade;
				}else if(val==6){
					//$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empdoc;
				}else if(val==7){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].salaryctc;
				}else if(val==8){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].empsts;
				}else if(val==5){
					$scope.jobmodifyarr[i].oldvalue=$scope.employee[j].emplocation;
				}
				
				break;
			}
		}
	}
}

$scope.calculatetotal = function()
	{	
		var totaldeduct=0;var totaladd=0;
		for(var i=0; i<$scope.salaryarray.length; i++)
		{
			if(parseInt($scope.salaryarray[i].headtype)==3 || parseInt($scope.salaryarray[i].headtype)==0){
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaldeduct += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}else {
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaladd += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}
		}
		$scope.emptotal=totaladd;
		$scope.totaldeduction=totaldeduct;
		//errorMessage($scope.emptotal+"  "+totaladd+"  "+totaldeduct);
		var salaryctc =  (totaladd - totaldeduct);
		for(var i=0; i<$scope.jobmodifyarr.length; i++)
		{
			//alert($scope.jobmodifyarr[i].name+"=="+$val)
			if($scope.jobmodifyarr[i].name==7){
				$scope.jobmodifyarr[i].newvalue=salaryctc;
				return;
			}
		}
		
	}

function onfetchsalarydetails()
{
	$scope.hastrue=true;
	var xsrf = $.param({employeeid: $scope.empid, gradeid: $scope.emp_grade, grossalary: $scope.salaryctc, incentive:0, experience: 0});
	$http({
        url: path+'employee/getemployeesalary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.salaryarray=[];
				$scope.salaryarray=data.data;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchcombo = function($val, $index)
{
	//$scope.jobmodifyarr[$index].newvalue="";
	//
	//$scope.salaryarray=[];
	var temp=0;
	for(var i=0; i<$scope.jobmodifyarr.length; i++)
	{
		//alert($scope.jobmodifyarr[i].name+"=="+$val)
		if($scope.jobmodifyarr[i].name==$val && $index!=i){
			alert("Already selected");
			$scope.fieldarrvalue[$index]=[];
			$scope.jobmodifyarr[$index].name="";
			return;
		}else if($scope.jobmodifyarr[i].name == 7){
				temp++;
			}
	}
	if(temp==0)
	{
		$scope.salaryarray=[];
	}
	
	if($val==1)
	onfetchemployee("setup/getalldivision",$index);
	else if($val==2)
	onfetchemployee('setup/getalldepartment',$index);
	else if($val==3)
	onfetchemployee('setup/getalldesignation',$index);
	else if($val==4)
	onfetchemployee('setup/getallgrade',$index);
	else if($val==6)
	$scope.fieldarrvalue[$index]=$index;
	else if($val==7)
	$scope.fieldarrvalue[$index]=$index;
	else if($val==8)
	onfetchemployee('employee/getallempstatus',$index);
	else if($val==5)
	onfetchemployee('setup/getalllocation',$index);
	
	for(var i=0; i<$scope.employee.length; i++)
	{
		if($scope.employee[i].id==$scope.empid){
			if($val==1){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empdivision;
				break;
			}else if($val==2){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empdepartment;
				break;
			}else if($val==3){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empdesignation;
				break;
			}else if($val==4){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empgrade;
				
				break;
			}else if($val==6){
				//$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empdoc;
				break;
			}else if($val==7){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].salaryctc;
				$scope.salaryctc=$scope.employee[i].salaryctc;
				$scope.emp_grade=$scope.employee[i].empgrade;
				onfetchsalarydetails();
				break;
			}else if($val==8){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].empsts;
				break;
			}else if($val==5){
				$scope.jobmodifyarr[$index].oldvalue=$scope.employee[i].emplocation;
				break;
			}else{
				$scope.jobmodifyarr[$index].oldvalue="";
			}
		}
	}
}

Array.prototype.insert = function (index, item) {
  this.splice(index, 0, item);
};
Array.prototype.remove = function (index) {
  this.splice(index,1);
};

$scope.addjob = function($i){

	var len = $scope.jobmodifyarr.length-1;
	if($scope.jobmodifyarr[len]['name']=="" || $scope.jobmodifyarr[len]['oldvalue']=="" || $scope.jobmodifyarr[len]['newvalue']==""){
		errorMessage("Please fill all fields");
	}else{
		$scope.jobmodifyarr.insert($i,{id:($i+1), name:"", oldvalue:"", newvalue:""});
	}
}
$scope.removejob = function($i){
	$scope.jobmodifyarr.remove($i);	
}

$scope.oncreate = function($val)
{
	
	var totaldeduct=0;var totaladd=0;
		for(var i=0; i<$scope.salaryarray.length; i++)
		{
			if(parseInt($scope.salaryarray[i].headtype)==3 || parseInt($scope.salaryarray[i].headtype)==0){
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaldeduct += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}else {
				if($scope.salaryarray[i].amount!="" && $scope.salaryarray[i].amount!=null){
					$scope.salaryarray[i].amount = parseFloat($scope.salaryarray[i].amount);
					totaladd += parseFloat($scope.salaryarray[i].amount);
				}else{
					$scope.salaryarray[i].amount=0;
				}
			}
		}
		$scope.emptotal=totaladd;
		$scope.totaldeduction=totaldeduct;
		//errorMessage($scope.emptotal+"  "+totaladd+"  "+totaldeduct);
		var salaryctc =  (totaladd - totaldeduct);
	
	if($scope.modtype==2)
	{
		if($scope.ptype==0)
		{
			errorMessage("Please select Modification type");
			return;
		}
	}
	var temp="";
	for(var i=0;i<$scope.jobmodifyarr.length;i++){
		if($scope.jobmodifyarr[i].name==7){
			if($scope.jobmodifyarr[i].oldvalue == $scope.jobmodifyarr[i].newvalue){
				errorMessage("previous value should not be same as current value");
				return;
			}else if(salaryctc != $scope.jobmodifyarr[i].newvalue){
				errorMessage("Salary Component should be equal to the new salary");
				return;
			}else{
				continue;
			}
		}else{
			temp=$scope.fieldarrvalue[i];
			for(var j=0;j<(temp.length);j++){
				if($scope.jobmodifyarr[i].newvalue == temp[j].id){
					if($scope.jobmodifyarr[i].oldvalue == temp[j].name){
						errorMessage("previous value should not be same as current value");
						return;
					}else{
						continue;
					}
				}
			}
		}
	
	}
var json = angular.toJson($scope.jobmodifyarr);
var json1 = angular.toJson($scope.salaryarray);

$scope.hastrue=true;
var xsrf = $.param({empid:$scope.empid, modtype:$scope.modtype, remarks:$scope.remarks, applyfrom:$scope.applyfrom, json:json,promotiontype:$scope.ptype,emp_salarydetails:json1});
  $http({
        url: path+'employee/createjobmodification',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.jobmodificationname="";
				
				$scope.jobmodificationid=0;
				
				if($val==1){
					//window.open(path+"employee/jobmodification", "_self");
					$timeout(function(){window.open(path+"employee/jobmodification/"+$scope.modtype, "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});






/////////////////////////// timeline Controller Starts From Here  ///////////////////////////////////

app.controller('timelineCtrl', function($scope, $http) {

	var d =new Date();
	$scope.hastrue=false;
	
	$scope.timelinearr=[];
	
	
	//for get category
	$scope.onfetchtimeline= function($val)
	{
	
		$scope.hastrue=true;
		var xsrf = $.param({empid:$val});
		$http({
			url: path+'employee/gettimeline',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.timelinearr=data.data;
				$scope.username=data.username;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
});
//////////////////////////////////////

//////////////document release request/////////////
app.controller('documentrequestCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.claimid=0;
	$scope.employeeid="";
	
	$scope.leftdisable=true;
	$scope.rightdisable=true;
	
	$scope.applydate="";
	$scope.documentrequestsarr=[];
	$scope.availdocarr=[];
	$scope.releasedocarr=[];
	$scope.remarks="";
	$scope.employeearray=[];
	//onfetch("profile/getdocumentlist",1);
	onfetch("other",2);
	onfetch('employee/getallemployee',3);
	
	$scope.docreqid=0;
	/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.docreqid=$id;
}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletedocumentrequest/'+$scope.docreqid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.docreqid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 7});
		$http({
			url: path+$val,
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==2){
						$scope.otherarray=[];
						$scope.otherarray=data.data;
					}
					else if($id==3){
						$scope.employeearray=[];
						$scope.employeearray=data.data;
						setempdetail();					
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
	$scope.onfetchdocumentrequest =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({documentrequestid: $id});
		$http({
			url: path+'employee/getadocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				
				$scope.employeeid=data.data[0]['employee'];
				$scope.fromdate=data.data[0]['releasefrom'];
				$scope.fromdate1=data.data[0]['releasefrom1'];
				$scope.todate=data.data[0]['releaseto'];
				$scope.leavereason=data.data[0]['reason'];
				$scope.leavestatus=data.data[0]['appsts'];
				
				$scope.applydate=data.data[0]['applydate'];
				$scope.designame=data.data[0]['designation'];
				$scope.departname=data.data[0]['department'];	
				$scope.docs=[];
				$scope.docs= data.data[0]['docs'];	
				if($scope.fromdate!="-"){
					$scope.timediff($scope.fromdate1);
				}else{
					$("#releasedate").datepicker({ startDate:"+1"});
				}
				//$scope.documentrequestsarr=data.data[0]['docs'];
				
				/*$scope.onfetchdoc($scope.employeeid);
				$timeout(function(){
					if(data.data[0]['requestdocid'] != ""){
					
						var temp=data.data[0]['requestdocid'].split(',');
						for(var i=0;i<temp.length;i++){
							for ( var s=0; s<$scope.availdocarr.length; s++) {
								if ($scope.availdocarr[s].id==temp[i]){ 
									$scope.releasedocarr.insert($scope.releasedocarr.length,$scope.availdocarr[s]);
									
									break;
								}
							  }
						}
						for(var i=0;i<temp.length;i++){
							for ( var s=0; s<$scope.availdocarr.length; s++) {
								if ($scope.availdocarr[s].id==temp[i]){ 
									$scope.availdocarr.remove(s);break;
								}
							  }
						}
					}
				},1000);*/
				}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.timediff = function($leaveto){
		console.log($leaveto)
		$scope.releasedate="";
		 var m=$leaveto.split('-');
		 var rdate=new Date(parseInt(m[0]), parseInt(m[1])-1, parseInt(m[2]));
		 rdate.setDate(rdate.getDate());
		 
		 $('#releasedate').datepicker({
			startDate: rdate
		});
		
	}
	
	$scope.onaddcomment = function($id)
	{
		 $('#comment').modal('show');
		 $scope.approverresult=$id;
	}
	
	$scope.onapprove = function($val,$res)
	{
		if($res==1){
			$scope.releasedate="";
		}
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ documentrequestid:$scope.documentrequestid, approverresult:$res, releasedate:$scope.releasedate ,val:$val});
		$http({
			url: path+'employee/documentrelease',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"employee/documentrequest/"+$val, "_self");}, timeo);
				}	
				if($val==2){
					$timeout(function(){window.open(path+"employee/documentrequest/"+$val, "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	function setempdetail()
	{
		for(var i=0;i<$scope.employeearray.length;i++){
		 	if($scope.employeearray[i].id == $scope.employeeid)
			{
				$scope.empdepart =$scope.employeearray[i].empdepartment;
				$scope.empdesig =$scope.employeearray[i].empdesignation;
				break;
			}
		
		}
	}
	$scope.onfetchdoc =function($id)
	{
		$scope.hastrue=true;
		//$scope.empdesig = data.data[];
		setempdetail();
		var xsrf = $.param({employeeid: $id});
		$http({
			url: path+'employee/getdocumentlist',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			$scope.availdocarr=[];
			$scope.releasedocarr=[];
			$scope.documentrequestsarr=[];
			
			if(data.status){
				$scope.documentrequestsarr=data.data;
				$scope.availdocarr=[];
				$scope.availdocarr=data.data;	
				//$scope.documentrequestsarr=data.data;
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.oncreate = function($val)
	{	
		var requestdocids="";
		for(var i=0;i<$scope.releasedocarr.length;i++){
		 
			requestdocids +=$scope.releasedocarr[i].id+ ',';
		
		}
		requestdocids =requestdocids.substr(0, requestdocids.length-1);
		
		$scope.hastrue=true;
		var xsrf = $.param({  releasefrom:$scope.releasefrom,  releaseto:$scope.releaseto, reason:$scope.reason,requestdocid:requestdocids,employeeid:$scope.employeeid,appsts:3});
		$http({
			url: path+'employee/createdocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";
					$scope.employeeid="";		
					$scope.appsts="";	
					$scope.employeeid="";	
					$scope.documentrequestid=0;	
					
					if($val==1){
						//window.open(path+"salary/documentrequest", "_self");
						$timeout(function(){window.open(path+"employee/documentrequest", "_self");}, timeo);
					}
				}
				else{
				errorMessage(data.errorMsg);
			}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
		
		var requestdocids="";
		for(var i=0;i<$scope.releasedocarr.length;i++){		 
			requestdocids +=$scope.releasedocarr[i].id+ ',';		
		}
		requestdocids =requestdocids.substr(0, requestdocids.length-1);
		
		$scope.hastrue=true;
		var xsrf = $.param({ documentrequestid: $scope.documentrequestid, releasefrom:$scope.releasefrom,  releaseto:$scope.releaseto, reason:$scope.reason,requestdocid:requestdocids,appsts:$scope.appsts});
		$http({
			url: path+'employee/updatededocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);			
					$scope.releasefrom="";
					$scope.releaseto="";
					$scope.reason="";	
					$scope.employee="";		
					$scope.employeeid="";	
					$scope.documentrequestsarr.length=0;
					$scope.appsts="";		
							
					$scope.documentrequestid=0;	
						
					
					if($val==1){
						//window.open(path+"salary/documentrequest", "_self");
						$timeout(function(){window.open(path+"employee/documentrequest", "_self");}, timeo);
					}					
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	$scope.toggleSelection = function($x) {
	
	  if($scope.availdocarr[$x].vsts){		
		$scope.availdocarr[$x].vsts=false;
	  }else{
		$scope.availdocarr[$x].vsts=true;
	  }
	  
	  $scope.leftdisable=true;
	  var len = $scope.availdocarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.availdocarr[i].vsts){		
			$scope.leftdisable=false;
			break;
		  }
	  }
   };
	$scope.toggleSelection1 = function($x) {
	
	  if($scope.releasedocarr[$x].vsts){		
		$scope.releasedocarr[$x].vsts=false;
	  }else{
		$scope.releasedocarr[$x].vsts=true;
	  }
	  
	  $scope.rightdisable=true;
	  var len = $scope.releasedocarr.length;
	  for(var i=0; i<len; i++)
	  {
		if($scope.releasedocarr[i].vsts){		
			$scope.rightdisable=false;
			break;
		  }
	  }
   };  
   
	$scope.onAddSelection = function()
	{
		$scope.leftdisable=true;
	$scope.rightdisable=true;
		for ( var i=0; i<$scope.availdocarr.length; i++) {
				if ($scope.availdocarr[i].vsts){ 
					$scope.availdocarr[i].vsts=false;
					$scope.releasedocarr.insert($scope.releasedocarr.length,$scope.availdocarr[i]);
					$scope.availdocarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.availdocarr.length-1; i>=0; i--) {
				if ($scope.availdocarr[i].vsts){ 
					$scope.availdocarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.releasedocarr.length; i++) {
				$scope.releasedocarr[i].vsts=false;
			  }
	}
	$scope.onRemoveSelection = function()
	{
		$scope.leftdisable=true;
	$scope.rightdisable=true;
		for ( var i=0; i<$scope.releasedocarr.length; i++) {
				if ($scope.releasedocarr[i].vsts){ 
					$scope.releasedocarr[i].vsts=false;
					$scope.availdocarr.insert($scope.availdocarr.length,$scope.releasedocarr[i]);
					$scope.releasedocarr[i].vsts=true;
					}
			  }
		for ( var i=$scope.releasedocarr.length-1; i>=0; i--) {
				if ($scope.releasedocarr[i].vsts){ 
					$scope.releasedocarr.remove(i);
				}
		}
		for ( var i=0; i<$scope.availdocarr.length; i++) {
				$scope.availdocarr[i].vsts=false;
			  }
	}

});


//////////////////////// Document Approval Controller///////////////////////

app.controller('documentapprovalCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.documentapprovalid=0;
    $scope.approverresult=3;
	$scope.docs=[];
    onfetch('other',2);
	
   function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==2){
						$scope.leavestsarray=[];
						$scope.leavestsarray=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchApprover = function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({documentapprovalid: $scope.documentapprovalid});
		$http({
			url: path+'employee/getalldocumentapprover',
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					$scope.employeearray=[];
						$scope.employeearray=data.data;
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

  $scope.onfetchdocumentapproval =function($id)
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({documentrequestid: $id});
		$http({
			url: path+'employee/getadocumentrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){                
				$scope.employeeid=data.data[0]['employee'];
				$scope.fromdate=data.data[0]['releasefrom'];
				$scope.todate=data.data[0]['releaseto'];
				$scope.leavereason=data.data[0]['reason'];
				$scope.leavestatus=data.data[0]['appsts'];
				$scope.leavevalidsts=data.data[0]['leavevalidsts'];
				$scope.applydate=data.data[0]['applydate'];
				$scope.designame=data.data[0]['designation'];
				$scope.departname=data.data[0]['department'];	
				$scope.docs=[];
				$scope.docs= data.data[0]['docs'];	
			}else{
				errorMessage(data.errorMsg);
			}			
 
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onaddcomment = function($id)
	{
		 $('#comment').modal('show');
		 $scope.approverresult=$id;
	}
	
	$scope.onapprove = function($val)
	{ 
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ documentapprovalid:$scope.documentapprovalid, approverresult:$scope.approverresult, comment:$scope.comment });
		$http({
			url: path+'employee/documentapprovalresult',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"employee/documentapproval", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});


/////////////////////////// Document Library Controller Starts From Here  ///////////////////////////////////

app.controller('doclibraryCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.employees = [];
$scope.doclibraryid=0;
$scope.empid=0;
onfetchemployee();

/////////////////////////////
$scope.getId = function($id) {
	//alert($id);
	$scope.doclibraryid=$id;
}

$scope.ondelete =function()
{
	//alert($scope.notificationid);
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletedoclibrary/'+$scope.doclibraryid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.doclibraryid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

function onfetchemployee()
{
	$scope.hastrue=true;
	$http({
        url: path+'employee/getallemployee',
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employees = data.data;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
$scope.onfetchdoclibrary =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({doclibraryid: $id});
	$http({
        url: path+'employee/getadoclibrary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.doclibraryname=data.data[0]['name'];
				$scope.empid=data.data[0]['employee'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({doclibraryname: $scope.doclibraryname, empid:$scope.empid});
  $http({
        url: path+'employee/createdoclibrary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.doclibraryname="";
				$scope.empid=0
				$scope.doclibraryid=0;
				
				if($val==1){
					//window.open(path+"employee/doclibrary", "_self");
					$timeout(function(){window.open(path+"employee/companydoclibrary", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({doclibraryid: $scope.doclibraryid, doclibraryname: $scope.doclibraryname, empid:$scope.empid});
  $http({
        url: path+'employee/updatededoclibrary',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.doclibraryname="";
				$scope.doclibraryid=0;
				if($val==1){
					//window.open(path+"employee/doclibrary", "_self");
					$timeout(function(){window.open(path+"employee/companydoclibrary", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


///////////////////////////// Resignation Controller Starts From Here  ///////////////////////////////////

app.controller('resignationCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.resignationid=0;
$scope.empname="";
$scope.startdate="";
$scope.enddate="";
$scope.startdate1="";
$scope.enddate1="";
$scope.msg="";
$scope.subject="";
$scope.noticeperiod="";
$scope.designation="";
$scope.department="";
$scope.division="";
$scope.sts='';
$scope.resignstatus='';

//onfetch('employee/getallemployee',1);
//onfetch('setup/getallasset',2);

/////////////////////////////
$scope.getId = function($id) {
	$scope.resignationid=$id;
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteresignation/'+$scope.resignationid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.resignationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.onfetchresignation =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({resignationid: $id});
	$http({
        url: path+'employee/getaresignation',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				
				$scope.empname=data.data1[0]['empname'];
				$scope.division=data.data1[0]['division'];
				$scope.department=data.data1[0]['department'];
				$scope.designation=data.data1[0]['designation'];
				
				$scope.subject=data.data[0]['subject'];
				$scope.msg=data.data[0]['message'];
				$scope.noticeperiod=data.data[0]['noticeperiod'];
				$scope.startdate=data.data[0]['startdate'];
				$scope.enddate=data.data[0]['enddate'];
				$scope.startdate1=data.data[0]['startdate1'];
				$scope.enddate1=data.data[0]['enddate1'];
				//alert(data.data[0]['resignsts']);
				$scope.sts=data.data[0]['resignsts'];
				//alert($scope.sts);
				if($scope.sts=='1')
				{
					$scope.resignstatus="Rejected";
				}else if($scope.sts=='2'){
					$scope.resignstatus="Approved";
				}else if($scope.sts=='3'){
					$scope.resignstatus="Pending";
				}else if($scope.sts=='4'){
					$scope.resignstatus="Cancel";
				}else if($scope.sts=='5'){
					$scope.resignstatus="Withdraw";
				}
				//alert($scope.resignstatus);
				
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({emp_id:$scope.emp_id,assetid:$scope.assetid,issue_date:$scope.issue_date,return_date:$scope.return_date,desc:$scope.desc});
  $http({
        url: path+'employee/createissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.assetid="";
				$scope.emp_id=""
				$scope.issue_date="";
				$scope.return_date="";
				$scope.desc="";
				$scope.issueassetid=0;
				
				if($val==1){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/issueasset", "_self");}, timeo);
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({issueassetid: $scope.issueassetid, return_date:$scope.return_date});
  $http({
        url: path+'employee/updatedissueasset',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.assetid="";
				$scope.emp_id=""
				$scope.issue_date="";
				$scope.return_date="";
				$scope.desc="";
				$scope.issueassetid=0;
				if($val==1){
					//window.open(path+"employee/issueasset", "_self");
					$timeout(function(){window.open(path+"employee/issueasset", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

});
/////////////////////////// City Controller Starts From Here  ///////////////////////////////////

app.controller('cityCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.cityid=0;
$scope.country="";
$scope.city="";
onfetch('country/getallcountry',1);
function onfetch($val, $id)
	{
		$scope.hastrue=true;
		
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.countryarray=[];
						$scope.countryarray=data.data;
					}
					
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	
$scope.onfetchcity =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({cityid: $id});
	$http({
        url: path+'city/getacity',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.city=data.data[0]['name'];
				$scope.country=data.data[0]['country'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({city: $scope.city,country: $scope.country});
  $http({
        url: path+'city/createcity',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.cityname="";
				
				$scope.cityid=0;
				
				if($val==1){
					//window.open(path+"city/city", "_self");
					$timeout(function(){window.open(path+"city/city", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({cityid: $scope.cityid, city: $scope.city,country: $scope.country});
  $http({
        url: path+'city/updatedecity',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.cityname="";
				$scope.cityid=0;
				if($val==1){
					//window.open(path+"city/city", "_self");
					$timeout(function(){window.open(path+"city/city", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});



/////////////////////////// Document Controller Starts From Here  ///////////////////////////////////

app.controller('certificateCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.certificateid=0;
$scope.documentname="";
$scope.templatename="";

/////////////////////////////
$scope.getId = function($id) {
	$scope.certificateid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletecertificate/'+$scope.certificateid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.certificateid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchdocument =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({certificateid: $id});
	$http({
        url: path+'employee/getacertificate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.documentname=data.data[0]['name'];
				$scope.documentcode=data.data[0]['code'];
				//$scope.desc=data.data[0]['desc'];
				$('#desc').data("wysihtml5").editor.setValue(data.data[0]['desc']);
				if($scope.val != 0){
				$('#desc').data('wysihtml5').editor.composer.disable();
				}
				$scope.templateid=data.data[0]['templateid'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
$scope.desc=document.getElementById('desc').value;
$scope.hastrue=true;
var xsrf = $.param({documentname: $scope.documentname, documentcode: $scope.documentcode,desc: $scope.desc});
  $http({
        url: path+'employee/createcertificate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.documentname="";
				$scope.documentcode="";
				$scope.certificateid=0;
				$scope.templatename="";
				if($val==1){
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/certificate", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{
$scope.desc=document.getElementById('desc').value;
$scope.hastrue=true;
var xsrf = $.param({certificateid: $scope.certificateid, documentname: $scope.documentname, documentcode: $scope.documentcode,desc: $scope.desc,templateid:$scope.templateid});
  $http({
        url: path+'employee/updatedecertificate',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.documentname="";
				$scope.documentcode="";
				$scope.templatename="";
				$scope.certificateid=0;
				if($val==1){
					//window.open(path+"employee/document", "_self");
					$timeout(function(){window.open(path+"employee/certificate", "_self");}, timeo); 
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});

//////////////////////// Document Approval Controller///////////////////////

app.controller('certificateapprovalCtrl', function($scope, $http, $timeout) {

	$scope.hastrue=false;
    $scope.certificateapprovalid=0;
    $scope.approverresult=3;
	$scope.docs=[];
    onfetch('other',2);
	
	$scope.getId = function($id) {
	$scope.certificateapprovalid=$id;
}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deletecertificaterequest/'+$scope.certificateapprovalid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.resignationid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	
   function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					if($id==2){
						$scope.leavestsarray=[];
						$scope.leavestsarray=data.data;
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	
	$scope.onfetchApprover = function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({certificateapprovalid: $scope.certificateapprovalid});
		$http({
			url: path+'employee/getallcertificateapprover',
			method: "POST",data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				
				if(data.status){
					$scope.employeearray=[];
						$scope.employeearray=data.data;
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}

  $scope.onfetchcertificateapproval =function($id)
	{ 

		$scope.hastrue=true;
		var xsrf = $.param({certificaterequestid: $id});
		$http({
			url: path+'employee/getacertificaterequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){                
				$scope.employeeid=data.data[0]['employeeid'];
				$scope.leavereason=data.data[0]['reason'];
				$scope.leavestatus=data.data[0]['sts'];
				$scope.applydate=data.data[0]['applydate'];
				$scope.designame=data.data[0]['designation'];
				$scope.departname=data.data[0]['department'];	
				$scope.addressto=data.data[0]['addressto'];	
				$scope.docs=[];
				$scope.docs= data.data[0]['docs'];	
			}else{
				errorMessage(data.errorMsg);
			}			
 
			$scope.hastrue=false;
			
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onaddcomment = function($id)
	{
		 $('#comment').modal('show');
		 $scope.approverresult=$id;
	}
	
	$scope.onapprove = function($val)
	{ 
		$scope.hastrue=true;
		$('#comment').modal('hide');
		var xsrf = $.param({ certificateapprovalid:$scope.certificateapprovalid, approverresult:$scope.approverresult, comment:$scope.comment });
		$http({
			url: path+'employee/certificateapprovalresult',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
            	successMessage(data.successMsg);
				if($val==1){
					$timeout(function(){window.open(path+"employee/certificateapproval", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

/////////////////////////// Employee Status Controller Starts From Here  ///////////////////////////////////

app.controller('emptypeCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;

$scope.emptypeid=0;

/////////////////////////////
$scope.getId = function($id) {
	$scope.emptypeid=$id;
}
$scope.ondelete =function()
{
	$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'employee/deleteemptype/'+$scope.emptypeid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}

      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.emptypeid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.type = type + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetchemptype =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({emptypeid: $id});
	$http({
        url: path+'employee/getaemptype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.emptypename=data.data[0]['name'];
				$scope.emptypecode=data.data[0]['code'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.type = type + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({emptypename: $scope.emptypename, emptypecode:$scope.emptypecode});
  $http({
        url: path+'employee/createemptype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				
				$scope.emptypename="";
				$scope.emptypecode="";
				$scope.emptypeid=0;
				
				if($val==1){
					//window.open(path+"employee/emptype", "_self");
					$timeout(function(){window.open(path+"employee/emptype", "_self");}, timeo); 
				}
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.type = type + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({emptypeid: $scope.emptypeid, emptypename: $scope.emptypename, emptypecode:$scope.emptypecode});
  $http({
        url: path+'employee/updatedeemptype',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.emptypename="";
				$scope.emptypecode="";
				$scope.emptypeid=0;
				if($val==1){
					//window.open(path+"employee/emptype", "_self");
					$timeout(function(){window.open(path+"employee/emptype", "_self");}, timeo); 
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.type = type + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


/////////////////////////// Insurance Controller Starts From Here  ///////////////////////////////////

app.controller('confirmCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.employeearray = [];
$scope.employeeid=0;
$scope.confirm=0;
$scope.confirmdate="";

/////////////////////////////

$scope.onfetchemployee =function($id)
{
	$scope.hastrue=true;
	var xsrf = $.param({employeeid: $id});
	$http({
        url: path+'employee/getConfirmDetails',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.employeearray = [];
				$scope.employeearray = data.data;
				$scope.confirmdate=data.data[0].doc1;
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncallpopup = function($id)
{
	$scope.confirm=$id;
	$('#comment').modal('show');
}


$scope.onupdate = function()
{

$scope.hastrue=true;
var xsrf = $.param({employeeid: $scope.employeeid, confirm: $scope.confirm, confirmdate:$scope.confirmdate});
  $http({
        url: path+'employee/updateConfirmDetails',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$timeout(function(){window.open(path+"employee/confirmemployee", "_self");}, timeo);
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
 
});



/////////////////////////// Category Controller Starts From Here  ///////////////////////////////////

app.controller('categoryCtrl', function($scope, $http, $timeout) {

$scope.hastrue=false;
$scope.categoryname="";
$scope.categoryid=0;
$scope.typeid=2;
//onfetch();
$scope.category=[];
onfetchtype();
$scope.getId = function($id) {
	$scope.categoryid=$id;
}

$scope.ondelete =function()
{
	$http({
        url: path+'setup/deletecategory/'+$scope.categoryid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.categoryid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


function onfetchtype()
{
	$scope.category=[];
	$scope.hastrue=true;
	
	$http({
        url: path+'setup/getalltype',
        method: "POST",
	    headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onfetch =function($id)
{
	$scope.hastrue=true;
var xsrf = $.param({categoryid: $id});
	$http({
        url: path+'setup/getacategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				$scope.categoryname=data.data[0]['name'];
				$scope.desc=data.data[0]['desc'];
				$scope.typeid=data.data[0]['typeid'];
			}
			
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.oncreate = function($val)
{
$scope.hastrue=true;
var xsrf = $.param({categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/createcategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;				
				$('#categorymodel').modal('hide');
				if($val==1){
			//		window.open(path+"employee/addqualification", "_self");
			//		$timeout(function(){window.open(path+"employee/addqualification", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

$scope.onupdate = function($val)
{

$scope.hastrue=true;
var xsrf = $.param({categoryid: $scope.categoryid, categoryname: $scope.categoryname, desc: $scope.desc, typeid: $scope.typeid});
  $http({
        url: path+'setup/updatedecategory',
        method: "POST",
		data: xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.categoryname="";
				$scope.desc="";
				$scope.typeid="";
				$scope.categoryid=0;
				
				if($val==1){
					//window.open(path+"setup/category", "_self");
					$timeout(function(){window.open(path+"setup/category", "_self");}, timeo);
				}
				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
});


app.controller('Feedbackctrl', function($scope, $http, $timeout) {
	$scope.marks="";
	$scope.remark="";
	$scope.employees=[];
	$scope.SendmsgList=[];
	$scope.ReceivemsgList=[];
	$scope.rating=0;
	$scope.date="";
	$scope.emp_subs="";
	$scope.catid=0;
	$scope.category=[];
	$scope.color="grey";
	$scope.color1="grey";
	$scope.showskills=0;
	$scope.fromdate1="";
	$scope.todate1="";
	$scope.empid="";
	$scope.onfetch=function(){
		onfetch('profile/getemployeehierarchy',1);
		onfetch('employee/getallfeedback',2);
		//onfetch('employee/getreceivemsg',3);
		onfetch('employee/getallexternalfeedback',5);
		
	}
    $('.starrr').starrr({
 
	change: function(e, value){
		//alert('new rating is ' + value)
	$scope.rating=value;
	
 }
})
$scope.viewname="View";

$scope.showskill=function($val){
	$scope.val=$val
	console.log();
	
	if($scope.val==0){
		if($scope.showskills==1){
			$scope.showskills=0;
			$scope.viewname="View";
		}else if($scope.showskills==0){
			$scope.showskills=1;
			$scope.viewname="Hide";
		}
		
	}
}
$scope.skills=[{name:""}];
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	$scope.addskill = function($i) {	
		var len = $scope.skills.length-1;
		if($scope.skills[len]['name']=="" ){
			errorMessage("please enter skill");
		}else{
			$scope.skills.insert($i, {name:"" });
		}
	}
    $scope.removeskill = function($i){
		$scope.skills.remove($i);
		if($scope.skills.length == 0) {
			$scope.skills.insert($i, { name:"" });
		}
	}
	$scope.catvalue = function ( $val )
	{//alert($val);
		if($val==1)
		{
			$scope.color="#5ef241";
			$scope.color1="grey";
			$scope.category="Reward";
		}else
		{
			$scope.color="grey";
			$scope.color1="#f63759";
			$scope.category="Penalty";
		}
	}
	
	$scope.onfetchcat =function()
	{
		$scope.category=[];
		$scope.hastrue=true;
		var xsrf = $.param({typeid: 8});
		$http({
			url: path+'setup/getallcategory',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.category=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.filterfeedback=function(){
		$scope.hastrue=true;
		var xsrf = $.param({fromdate:$scope.fromdate1,todate:$scope.todate1,empid:$scope.empid});
		$http({
			url: path+'employee/getallfeedback',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.ReceivemsgList=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.clearfiltter=function($val){
		$scope.fromdate="";
		$scope.todate="";
		$scope.empid1="";
		$scope.filterfeedback1($val);
	}
	$scope.filterfeedback1=function($val){
		$scope.hastrue=true;
		var xsrf = $.param({fromdate:$scope.fromdate,todate:$scope.todate,empid:$scope.empid1,val:$val});
		$http({
			url: path+'employee/getallexternalfeedback',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.feedbackarr=data.data;
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	function onfetch($val, $id)
	{
		
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					if($id==1){
						$scope.employees=[];
						$scope.employees=data.data;
						
					}else if($id==2){
						$scope.ReceivemsgList=[];
						$scope.ReceivemsgList=data.data;
						//console.log($scope.ReceivemsgList);
					}
					
					else if($id==5){
						$scope.feedbackarr=data.data;
						var $msg = "Hii sir/mam,<br><br><br>Hope all is going well. Kindly share your feedback for {empname}.<br>Below mention the feedback link. This will help us to evaluate employee's performance.<br><br>{feedbacklink} <br><br> Thanks and Regards <br>{org}";
						$('#desc').data("wysihtml5").editor.setValue($msg);
						//console.log($scope.ReceivemsgList);
					}
					$timeout(function(){$('.selectpicker').selectpicker('refresh');}, 1000);
				}				
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});			
	}
	///////////Repeat Rating /////////
	$scope.range = function(count){
		var ratings = []; 
		for (var i = 0; i < count; i++) { 
		ratings.push(i) 
		} 
		return ratings;
	}
	
	$scope.oncreate = function($val)
	{
		
		$scope.hastrue=true;
		var xsrf = $.param({ emp_subs: $scope.emp_subs , catid : $scope.catid , rating : $scope.rating, msg : $scope.msg});
		$http({
			url: path+'profile/createfeedback',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/feedback", "_self");}, timeo);
								
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onsendfeedback = function()
	{
		$scope.hastrue=true;
		var JsonData1=angular.toJson($scope.skills);
		var xsrf = $.param({ emp: $scope.emp ,email: $scope.mailto , name : $scope.name , desig : $scope.desig, company : $scope.company, feedbacksubject : $scope.feedbacksubject, feedbackmsg : document.getElementById('desc').value , datefrom:$scope.datefrom, dateto:$scope.dateto, skills:JsonData1});
		$http({
			url: path+'employee/sendfeedbackrequest',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
               successMessage(data.successMsg);
				$timeout(function(){window.open(path+"profile/feedback", "_self");}, timeo);
								
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onshowdetails = function($id)
	{
		$scope.hastrue=true;
		
		var xsrf = $.param({ id: $id });
		$http({
			url: path+'profile/getfeedbackdetails',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		 //errorMessage( $scope.leavevalidsts);
			if(data.status){
				$scope.feedbackdata=data.data;
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            ////errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

