/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Jaidev Sharma
 * @Email   <jaidev@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('attendanceapi_daily', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
		link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Shift Controller Starts From Here  ///////////////////////////////////

app.controller('attendanceCtrl', function($scope, $http,$timeout) {

	$scope.hastrue=false;
	$scope.attendancearray=[];
	$scope.name='';
	$scope.code='';
	$scope.id='';
	$scope.shiftId='';
	$scope.punchFor='';
	$scope.aid=0;
	$scope.onfetchattendance=function()
	{
		//alert('hello');
			onfetchattandance();
		
	}
	
	function onfetchattandance()
	{
	//alert(path);
		$scope.hastrue=true;
		$http({
			url: path+'attendance_daily/getAllEmployee',
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				$scope.attendancearray=data.data;
				$timeout(function() {
				$("#example1").dataTable();
				}, 500)
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.getValidateEmp = function($empid,$sts)
	{
		if($sts==2){
			alert("You have already imposed today's attendance.");
		}
		else{
			var tid = prompt('Please enter your password:');
			if(tid=='12345')
			{
				window.open(path+"attendance_daily/punch/"+$empid,"_self");
			}
			else
			{
				alert('Invalid attendance password');
				return false;
			}
		}
	
	}
	
	$scope.img='';
	$scope.saveAttandence = function()
	{
	
		if($('#file-upload').val()=='')
		{
			alert('Please capture the image');
			return false;
		}
		else
		{
	//	alert("Attendance Saved");
		//	window.open(path+"attendance_daily/","_self");
		}
	}
	
	
	///////////////////////////////////////image upload///////////////////////////////
	

  //an array of files selected
    $scope.files = [];
	$scope.addr='';
    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
  
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    $scope.addr='';
    //the save method
    $scope.uploadFile1 = function($empid,$shiftId,$aid) {
		
		$scope.hastrue=true;
	
		var arr1=[];
		arr1[0]=$empid;
		arr1[1]=$shiftId;
		//arr1[2]=$scope.addr;
		//arr1[2]=$act;
		arr1[2]=$aid;
		
		$scope.img=document.getElementById('file').value;
		$scope.model = {
			name: "",
			comments: "",
			img: $scope.img
			
		};
		 $http({
			method: 'POST',
			url: path+"attendance_daily/uploadUserImage/"+arr1,
	//		data: args,
			headers: { 'Content-Type': undefined },
			transformRequest: function (data) {
				var formData = new FormData();
				formData.append("model", angular.toJson(data.model));
				//now add all of the assigned files

				for (var i = 0; i < data.files.length; i++) {
					//add each file to the form data and iteratively name them
					if(i==0)
					{
						formData.append("file" + i, data.files[data.files.length-1]);
					}
				}
				return formData;
			},
			//Create an object that contains the model and files which will be transformed
			// in the above transformRequest method
			data: { model: $scope.model, files: $scope.files }
		}).
		success(function (data, status, headers, config) {

		//	if(data.status)
			if($aid==0)
				alert("Thanks. Your Time in is marked. Have a good day!");
			else
				alert("Thanks. Your Time out is marked. Hope your day was good!");
		//	else
		//		alert("No Check in found today");

			$scope.hastrue=false;
			window.open(path+"profile","_self");			

		}).
		error(function (data, status, headers, config) {
			//alert("error: "+$scope.status);
		   $scope.hastrue=false;
		});

       
    }
	
	$scope.uploadFile = function($empid,$shiftId,$aid) {
		
    $scope.hastrue=true;
	
	//var addr = document.getElementById("long").value; 
		var _url='';
	//	var x = document.getElementById("lat").value;
	//	var y = document.getElementById("long").value; 
	//	alert(x);
	//	alert(y);
		
		_url=document.getElementById('addr').value;
		
		
	$scope.addr='';	
	
		
	
	//	alert(_url);
		//https://maps.googleapis.com/maps/api/geocode/json?latlng=26.1876921,78.1997794&key=AIzaSyDYh77SKpI6kAD1jiILwbiISZEwEOyJLtM
		$http({
			url: _url,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//alert(data.results[0]['formatted_address']);
				$scope.addr=data.results[0]['formatted_address'];
				$scope.addr=$scope.addr.replace("'"," ");
			//=============
			//	alert($empid+" "+$shiftId+" "+$scope.addr+" "+$act);
			//	return false;
					var arr1=[];
					arr1[0]=$empid;
					arr1[1]=$shiftId;
					//arr1[2]=$scope.addr;
					//arr1[2]=$act;
					arr1[2]=$aid;
					
					$scope.img=document.getElementById('file').value;
				$scope.model = {
					name: "",
					comments: "",
					img: $scope.img
					
				};
				 $http({
					method: 'POST',
					url: path+"attendance_daily/uploadUserImage/"+arr1+"/"+$scope.addr,
			//		data: args,
					headers: { 'Content-Type': undefined },
					transformRequest: function (data) {
						var formData = new FormData();
						formData.append("model", angular.toJson(data.model));
						//now add all of the assigned files

						for (var i = 0; i < data.files.length; i++) {
							//add each file to the form data and iteratively name them
							if(i==0)
							{
								formData.append("file" + i, data.files[data.files.length-1]);
							}
						}
						return formData;
					},
					//Create an object that contains the model and files which will be transformed
					// in the above transformRequest method
					data: { model: $scope.model, files: $scope.files }
				}).
				success(function (data, status, headers, config) {

				//	if(data.status)
					if($aid==0)
						alert("Thanks. Your Time in is marked. Have a good day!");
					else
						alert("Thanks. Your Time out is marked. Hope your day was good!");
				//	else
				//		alert("No Check in found today");

					$scope.hastrue=false;
					window.open(path+"profile","_self");			

				}).
				error(function (data, status, headers, config) {
					//alert("error: "+$scope.status);
				   $scope.hastrue=false;
				});
			//=============
		
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		//alert("GeoLocation : "+$scope.addr);
		//return false;
	
       
    }
	
	////-----------------------------
	
	$scope.getEmpDetail=function($id)
	{
		$scope.hastrue=true;
		$http({
			url: path+'attendance_daily/getEmpDetail/'+$id,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				if(data.data.sts==2){
						
						alert("You have already imposed your attendance");
						window.open(path+"profile","_self");
						return false;
				}
				$scope.name=data.data.name;	
				$scope.code=data.data.code;
				$scope.id=data.data.id;
				$scope.shiftId=data.data.shiftId;
				$scope.punchFor=data.data.act;
				$scope.aid=data.data.aid;
				
				
			//	$scope.attendancearray=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	////-----------------------------
	////-----------------------------take pic
	$scope.takePicture=function($empid,$shiftId,$aid) //$act=1/2 1->Timein and 2 -> TimeOut
	{
		
		window.open(path+"attendance_daily/camera/"+$empid+"/"+$shiftId+"/"+$aid,"_self");
	}
	
	////-----------------------------/takepic
	
	
	
});

////////// Attendance Without Image Controller Starts From Here  ///////////

app.controller('attendancewithoutimageCtrl', function($scope, $http,$timeout) {

	$scope.hastrue=false;
	$scope.attendancearray=[];
	$scope.name='';
	$scope.code='';
	$scope.id='';
	$scope.shiftId='';
	$scope.punchFor='';
	$scope.aid=0;
	$scope.img='';
	
	
	///////////////////////////////////////image upload///////////////////////////////
	

  //an array of files selected
    $scope.files = [];
	$scope.addr='';
    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
  
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
			
        });
    });
    $scope.addr='';

	
	$scope.uploadFile = function($empid,$shiftId,$aid) {
		
    $scope.hastrue=true;
	
	//var addr = document.getElementById("long").value; 
		var _url='';
	//	var x = document.getElementById("lat").value;
	//	var y = document.getElementById("long").value; 
	//	alert(x);
	//	alert(y);
		
		_url=document.getElementById('addr').value;
		
		
	$scope.addr='';	
	
		
	
	//	alert(_url);
		//https://maps.googleapis.com/maps/api/geocode/json?latlng=26.1876921,78.1997794&key=AIzaSyDYh77SKpI6kAD1jiILwbiISZEwEOyJLtM
		$http({
			url: _url,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			//alert(data.results[0]['formatted_address']);
				$scope.addr=data.results[0]['formatted_address'];
				$scope.addr=$scope.addr.replace("'"," ");
			//=============
			//	alert($empid+" "+$shiftId+" "+$scope.addr+" "+$act);
			//	return false;
					var arr1=[];
					arr1[0]=$empid;
					arr1[1]=$shiftId;
					//arr1[2]=$scope.addr;
					//arr1[2]=$act;
					arr1[2]=$aid;
					
					/* $scope.img=document.getElementById('file').value;
				$scope.model = {
					name: "",
					comments: "",
					img: $scope.img
					
				}; */
				 $http({
					method: 'POST',
					url: path+"attendance_daily/updateAttendancewithoutimage/"+arr1+"/"+$scope.addr,
			//		data: args,
					headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' }
					/* transformRequest: function (data) {
						var formData = new FormData();
						formData.append("model", angular.toJson(data.model));
						//now add all of the assigned files

						for (var i = 0; i < data.files.length; i++) {
							//add each file to the form data and iteratively name them
							if(i==0)
							{
								formData.append("file" + i, data.files[data.files.length-1]);
							}
						}
						return formData;
					}, */
					//Create an object that contains the model and files which will be transformed
					// in the above transformRequest method
				//	data: { model: $scope.model, files: $scope.files }
				}).
				success(function (data, status, headers, config) {

				//	if(data.status)
					if($aid==0)
						alert("Thanks. Your Time in is marked. Have a good day!");
					else
						alert("Thanks. Your Time out is marked. Hope your day was good!");
				//	else
				//		alert("No Check in found today");

					$scope.hastrue=false;
					window.open(path+"profile","_self");			

				}).
				error(function (data, status, headers, config) {
					//alert("error: "+$scope.status);
				   $scope.hastrue=false;
				});
			//=============
		
		}).error(function (data, status, headers, config) {
			errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
		//alert("GeoLocation : "+$scope.addr);
		//return false;
	
       
    }
	
	////-----------------------------
	
	$scope.getEmpDetail=function($id)
	{
		$scope.hastrue=true;
		$http({
			url: path+'attendance_daily/getEmpDetail/'+$id,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
			
				if(data.data.sts==2){
						
						alert("You have already imposed your attendance");
						window.open(path+"profile","_self");
						return false;
				}
				$scope.name=data.data.name;	
				$scope.code=data.data.code;
				$scope.id=data.data.id;
				$scope.shiftId=data.data.shiftId;
				$scope.punchFor=data.data.act;
				$scope.aid=data.data.aid;
				
				
			//	$scope.attendancearray=data.data;
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

});

