/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIHRM requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('attendanceapi', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/

app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
		link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});


/////////////////////////// Shift Controller Starts From Here  ///////////////////////////////////

app.controller('attdashboardCtrl', function($scope, $http) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.shiftid=0;
	$scope.chart1date="";
	$scope.attendancearray=[];
	$scope.latecomerarray=[];
	$scope.filscalid=0;
	$scope.onfetchdashboard=function($val,$type="")
	{
		onfetchdashboard($val,$type)
	}
	/*function onfetchdashboard($val,$type)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid: $scope.filscalid,type:$type});
		$http({
			url: path+'attendance/getAttendanceDashboard1/'+$val,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.monthview=data.curmonth;
				$scope.fiscalview =data.data['financialyear'][0]['name'];
				$scope.chart1date = data.data['chartdata1date'];
				$scope.fiscalformat=data.fiscal_format;
				$scope.filscalid=data.filscalid;
				//console.log(data.data['chartdata1'])
				var donut = new Morris.Donut({
				  element: 'bar-chart1',
				  resize: true,
				  colors: ["#9fbd3a", "#A1F0A7", "#A8E9ED", "#F5D2BF"],
				  data: data.data['chartdata1'],
				  hideHover: 'auto',
				   
				  
				});
				var donut = new Morris.Donut({
				  element: 'bar-chart2',
				  resize: true,
				  colors: ["#3333FF", "#FF3300", "#009933", "#CC66FF"],
				  data: data.data['chartdata2'],
				  hideHover: 'auto',
				  formatter: function (y, data) { return  y + '%'} 
				});
				var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata3'],
					  barColors: ['#32E34C'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart4',
					  resize: true,
					  xLabels: 'name',
					  postUnits:'%',ymax:100,
					  xLabelAngle: -90,
					  data: data.data['chartdata4'],
					  barColors: [ '#29DB29', '#FF5733','#EEF34A'],
					  xkey: 'name',
					  ykeys: ['totalpresent', 'totalabsent', 'totalleave'],
					  labels: ['Total Present', 'Total Absent', 'Total Leave'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart5',
					  resize: true,
					  xLabels: 'name',
					  postUnits:'%',ymax:100,
					  xLabelAngle: -90,
					  data: data.data['chartdata5'],
					  barColors: ['#5F73F5'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart6',
					  resize: true,ymax:100,
					  xLabels: 'name',
					  postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata6'],
					  barColors: ['#F0163A', '#009933', '#FF0000'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart7',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  barGap:0.5,
					  xLabelAngle: -90,
					  data: data.data['chartdata7']['data'],
					  barColors: ['#F7B4E0', '#3788C6', '#66A966','#FF8A37'],
					  xkey: 'name',
					  ykeys: data.data['chartdata7']['ykeys'],//ykeys: ['a', 'b', 'c'],
					  labels: data.data['chartdata7']['labels'],
					  hideHover: 'auto',
					  //gridTextSize:10,
					  
					});	
				var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata8'],
					  barColors: ['#29DBDB'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Hours'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart9',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata9'],
					  barColors: ['#F5E15F', '#009933', '#FF0000'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Hours'],
					  hideHover: 'auto'
					});
				/*var line = new Morris.Line({
					  element: 'line-chart',
					
					  resize: true,
					  postUnits:'%',
					  ymax:100,  xLabelAngle: 40,
					  data: $scope.attendancearray,
					  gridTextFamily: "Open Sans",
					  gridTextSize: 10,
					  gridStrokeWidth: 0.4,
					  xkey: 'attendancedate',
					  ykeys: ['perc'],
					  labels: ['Item 1'],
					  lineColors: ['#3c8dbc'],
					  hideHover: 'auto'
					});*/
			/*}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}*/
	function onfetchdashboard($val,$type)
	{
		$scope.hastrue=true;
		var xsrf = $.param({fiscalid: $scope.filscalid,type:$type});
		$http({
			url: path+'attendance/getAttendanceDashboard1/'+$val,
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.monthview=data.curmonth;
				$scope.fiscalview =data.data['financialyear'][0]['name'];
				$scope.chart1date = data.data['chartdata1date'];
				$scope.fiscalformat=data.fiscal_format;
				$scope.filscalid=data.filscalid;
				//console.log(data.data['chartdata1'])
				var donut = new Morris.Donut({
				  element: 'bar-chart1',
				  resize: true,
				  colors: ["#8c9e51", "#8369b7", "#319aa0", "#d07e52"],
				  data: data.data['chartdata1'],
				  hideHover: 'auto',
				   
				  
				});
				var donut = new Morris.Donut({
				  element: 'bar-chart2',
				  resize: true,
				  colors: ["#4f4fbf", "#da5e3f", "#3fb165", "#9b70b1"],
				  data: data.data['chartdata2'],
				  hideHover: 'auto',
				  formatter: function (y, data) { return  y + '%'} 
				});
				var bar = new Morris.Bar({
					  element: 'bar-chart3',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata3'],
					  barColors: ['#329e42'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart4',
					  resize: true,
					  xLabels: 'name',
					  postUnits:'%',ymax:100,
					  xLabelAngle: -90,
					  data: data.data['chartdata4'],
					  barColors: [ '#29DB29', '#FF5733','#EEF34A'],
					  xkey: 'name',
					  ykeys: ['totalpresent', 'totalabsent', 'totalleave'],
					  labels: ['Total Present', 'Total Absent', 'Total Leave'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart5',
					  resize: true,
					  xLabels: 'name',
					  postUnits:'%',ymax:100,
					  xLabelAngle: -90,
					  data: data.data['chartdata5'],
					  barColors: ['#5F73F5'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart6',
					  resize: true,ymax:100,
					  xLabels: 'name',
					  postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata6'],
					  barColors: ['#F0163A', '#009933', '#FF0000'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Employee'],
					  hideHover: 'auto'
					});
					//console.log(data.data['chartdata7']['data'])
				/* var bar = new Morris.Bar({
					  element: 'bar-chart7',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  barGap:0.5,
					  xLabelAngle: -90,
					  data: data.data['chartdata7']['data'],
					  barColors: ['#F7B4E0', '#3788C6', '#66A966','#FF8A37'],
					  xkey: 'name',
					  ykeys: data.data['chartdata7']['ykeys'],//ykeys: ['a', 'b', 'c'],
					  labels: data.data['chartdata7']['labels'],
					  hideHover: 'auto',
					  //gridTextSize:10,
					  
					});	 */
				var bar = new Morris.Bar({
					  element: 'bar-chart8',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata8'],
					  barColors: ['#29DBDB'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Hours'],
					  hideHover: 'auto'
					});
				var bar = new Morris.Bar({
					  element: 'bar-chart9',
					  resize: true,
					  xLabels: 'name',
					  //postUnits:'%',
					  xLabelAngle: -90,
					  data: data.data['chartdata9'],
					  barColors: ['#F5E15F', '#009933', '#FF0000'],
					  xkey: 'name',
					  ykeys: ['count'],//ykeys: ['a', 'b', 'c'],
					  labels: ['Total Hours'],
					  hideHover: 'auto'
					});
				/*var line = new Morris.Line({
					  element: 'line-chart',
					
					  resize: true,
					  postUnits:'%',
					  ymax:100,  xLabelAngle: 40,
					  data: $scope.attendancearray,
					  gridTextFamily: "Open Sans",
					  gridTextSize: 10,
					  gridStrokeWidth: 0.4,
					  xkey: 'attendancedate',
					  ykeys: ['perc'],
					  labels: ['Item 1'],
					  lineColors: ['#3c8dbc'],
					  hideHover: 'auto'
					});*/
			}
			else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	
});


/////////////////////////// Shift Controller Starts From Here  ///////////////////////////////////

app.controller('shiftCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.shiftid=0;
	$scope.shiftname="";
	$scope.timein="";
	$scope.timeout="";
	$scope.timeingrace="";
	$scope.timeoutgrace="";
	$scope.shifttype="false";
	$scope.timeinbreak="";
	$scope.timeoutbreak="";
	$scope.breaktimeingrace="";
	$scope.breaktimeoutgrace="";
	$scope.SundayArr=[];
	$scope.MondayArr=[];
	$scope.TuesdayArr=[];
	$scope.WednesdayArr=[];
	$scope.ThursdayArr=[];
	$scope.FridayArr=[];
	$scope.SaturdayArr=[];
	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	$scope.getId = function($id) {
		$scope.shiftid=$id;
	}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'attendance/deleteshift/'+$scope.shiftid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.shiftid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
	$scope.onfetchshift =function($id)
	{
		$scope.hastrue=true;
		var xsrf = $.param({shiftid: $id});
		$http({
			url: path+'attendance/getashift',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.shiftname=data.data[0]['name'];
				$scope.timein=data.data[0]['timein'];
				$scope.timeout=data.data[0]['timeout'];
				$scope.timeingrace=data.data[0]['gracein'];
				$scope.timeoutgrace=data.data[0]['graceout'];
				$scope.timeinbreak=data.data[0]['breakin'];
				$scope.timeoutbreak=data.data[0]['breakout'];
				$scope.breaktimeingrace=data.data[0]['breakingrace'];
				$scope.breaktimeoutgrace=data.data[0]['breakoutgrace'];
				$scope.shifttype=data.data[0]['shifttype'];
				if(data.status1){
					var i=0;
					for(i=0; i<data.weekoff.length; i++){
                         //console.log( result1.data[i].day) ;
						if(data.weekoff[i].Day==1){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Sunday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
									//$("").find(".rb-tab").attr("[data-value=1]").addClass("rb-tab-active");
								}
								else if(j==2){
									$('#Sunday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Sunday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Sunday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==2){
						var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Monday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Monday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Monday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Monday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Monday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Monday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Monday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Monday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Monday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Monday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==3){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Tuesday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Tuesday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Tuesday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Tuesday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Tuesday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Tuesday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Tuesday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Tuesday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Tuesday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Tuesday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==4){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Wednesday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Wednesday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Wednesday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Wednesday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Wednesday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Wednesday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Wednesday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Wednesday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Wednesday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Wednesday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==5){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Thursday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Thursday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Thursday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Thursday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Thursday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Thursday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Thursday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Thursday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Thursday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Thursday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==6){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Friday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Friday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Friday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Friday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Friday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Friday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Friday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Friday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Friday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Friday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}else if(data.weekoff[i].Day==7){
							var weekday =  data.weekoff[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Saturday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Saturday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Saturday-2').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Saturday-2').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==2){
									$('#Saturday-3').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Saturday-3').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Saturday-4').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Saturday-4').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else{
									$('#Saturday-5').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Saturday-5').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}
					}	
			}
				
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		$scope.hastrue=true;
		var i=0;
		for (i=1; i<=5; i++) {
				var Sunday = "Sunday-" + i;
				var rbValue = parseInt($("#"+Sunday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SundayArr.insert(i-1,{week:rbValue});
				
				var Monday = "Monday-" + i;
				var rbValue = parseInt($("#"+Monday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.MondayArr.insert(i-1,{week:rbValue});
				
				var Tuesday = "Tuesday-" + i;
				var rbValue = parseInt($("#"+Tuesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.TuesdayArr.insert(i-1,{week:rbValue});
				
				var Wednesday = "Wednesday-" + i;
				var rbValue = parseInt($("#"+Wednesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.WednesdayArr.insert(i-1,{week:rbValue});
				
				var Thursday = "Thursday-" + i;
				var rbValue = parseInt($("#"+Thursday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.ThursdayArr.insert(i-1,{week:rbValue});
				
				var Friday = "Friday-" + i;
				var rbValue = parseInt($("#"+Friday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.FridayArr.insert(i-1,{week:rbValue});
				
				var Saturday = "Saturday-" + i;
				var rbValue = parseInt($("#"+Saturday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SaturdayArr.insert(i-1,{week:rbValue});
			  }
				// console.log($scope.SundayArr);
			
		var jsonSunday=angular.toJson($scope.SundayArr);
		var jsonMonday=angular.toJson($scope.MondayArr);
		var jsonTuesday=angular.toJson($scope.TuesdayArr);
		var jsonWednesday=angular.toJson($scope.WednesdayArr);
		var jsonThursday=angular.toJson($scope.ThursdayArr);
		var jsonFriday=angular.toJson($scope.FridayArr);
		var jsonSaturday=angular.toJson($scope.SaturdayArr);
				
		var xsrf = $.param({shifttype:$scope.shifttype,shiftname: $scope.shiftname, timein:$scope.timein,	timeout:$scope.timeout, timeingrace:$scope.timeingrace,	timeoutgrace:$scope.timeoutgrace, timeinbreak:$scope.timeinbreak, timeoutbreak:$scope.timeoutbreak, breaktimeingrace:$scope.breaktimeingrace, breaktimeoutgrace:$scope.breaktimeoutgrace,jsonSunday:jsonSunday,jsonMonday:jsonMonday,jsonTuesday:jsonTuesday,jsonWednesday:jsonWednesday,jsonThursday:jsonThursday,jsonFriday:jsonFriday,jsonSaturday:jsonSaturday});
		$http({
			url: path+'attendance/createshift',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);					
					$scope.shifttype="";
					$scope.shiftname="";
					$scope.timein="";
					$scope.timeout="";
					$scope.timeingrace="";
					$scope.timeoutgrace="";
					$scope.timeinbreak="";
					$scope.timeoutbreak="";	
					$scope.breaktimeingrace="";
					$scope.breaktimeoutgrace="";					
					$scope.shiftid=0;
					$scope.SundayArr=[];
					$scope.MondayArr=[];
					$scope.TuesdayArr=[];
					$scope.WednesdayArr=[];
					$scope.ThursdayArr=[];
					$scope.FridayArr=[];
					$scope.SaturdayArr=[];
					
					if($val==1){
						//window.open(path+"attendance/shift", "_self");
						$timeout(function(){window.open(path+"attendance/shift", "_self");}, timeo);  
					}
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{

		$scope.hastrue=true;
		var i=0;
		for (i=1; i<=5; i++) {
				var Sunday = "Sunday-" + i;
				var rbValue = parseInt($("#"+Sunday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SundayArr.insert(i-1,{week:rbValue});
				
				var Monday = "Monday-" + i;
				var rbValue = parseInt($("#"+Monday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.MondayArr.insert(i-1,{week:rbValue});
				
				var Tuesday = "Tuesday-" + i;
				var rbValue = parseInt($("#"+Tuesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.TuesdayArr.insert(i-1,{week:rbValue});
				
				var Wednesday = "Wednesday-" + i;
				var rbValue = parseInt($("#"+Wednesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.WednesdayArr.insert(i-1,{week:rbValue});
				
				var Thursday = "Thursday-" + i;
				var rbValue = parseInt($("#"+Thursday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.ThursdayArr.insert(i-1,{week:rbValue});
				
				var Friday = "Friday-" + i;
				var rbValue = parseInt($("#"+Friday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.FridayArr.insert(i-1,{week:rbValue});
				
				var Saturday = "Saturday-" + i;
				var rbValue = parseInt($("#"+Saturday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SaturdayArr.insert(i-1,{week:rbValue});
			  }
				// console.log($scope.SundayArr);
			
		var jsonSunday=angular.toJson($scope.SundayArr);
		var jsonMonday=angular.toJson($scope.MondayArr);
		var jsonTuesday=angular.toJson($scope.TuesdayArr);
		var jsonWednesday=angular.toJson($scope.WednesdayArr);
		var jsonThursday=angular.toJson($scope.ThursdayArr);
		var jsonFriday=angular.toJson($scope.FridayArr);
		var jsonSaturday=angular.toJson($scope.SaturdayArr);
		
		var xsrf = $.param({shiftid: $scope.shiftid, shifttype: $scope.shifttype, shiftname: $scope.shiftname, timein:$scope.timein,	timeout:$scope.timeout, timeingrace:$scope.timeingrace,	timeoutgrace:$scope.timeoutgrace, timeinbreak:$scope.timeinbreak, timeoutbreak:$scope.timeoutbreak, breaktimeingrace:$scope.breaktimeingrace, breaktimeoutgrace:$scope.breaktimeoutgrace, jsonSunday:jsonSunday,jsonMonday:jsonMonday,jsonTuesday:jsonTuesday,jsonWednesday:jsonWednesday,jsonThursday:jsonThursday,jsonFriday:jsonFriday,jsonSaturday:jsonSaturday});
		$http({
			url: path+'attendance/updatedeshift',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.shifttype="";
				$scope.shiftname="";
				$scope.timein="";
				$scope.timeout="";
				$scope.timeingrace="";
				$scope.timeoutgrace="";
				$scope.timeinbreak="";
				$scope.timeoutbreak="";
				$scope.shiftid=0;
				$scope.breaktimeingrace="";
				$scope.breaktimeoutgrace="";	
				$scope.SundayArr=[];
				$scope.MondayArr=[];
				$scope.TuesdayArr=[];
				$scope.WednesdayArr=[];
				$scope.ThursdayArr=[];
				$scope.FridayArr=[];
				$scope.SaturdayArr=[];
				if($val==1){
					//window.open(path+"attendance/shift", "_self");
					$timeout(function(){window.open(path+"attendance/shift", "_self");}, timeo);
				}				
				}else{
					errorMessage(data.errorMsg);
				}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});



/////////////////////////// Weekly Off Controller Starts From Here  ///////////////////////////////////

app.controller('WeeklyOffCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
	$scope.shiftid=0;
	$scope.shiftname="";
	$scope.timein="";
	$scope.timeout="";
	$scope.timeingrace="";
	$scope.timeoutgrace="";
	$scope.timeinbreak="";
	$scope.timeoutbreak="";
	$scope.breaktimeingrace="";
	$scope.breaktimeoutgrace="";
	$scope.SundayArr=[];
	$scope.MondayArr=[];
	$scope.TuesdayArr=[];
	$scope.WednesdayArr=[];
	$scope.ThursdayArr=[];
	$scope.FridayArr=[];
	$scope.SaturdayArr=[];

	
	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
	
	$scope.getId = function($id) {
		$scope.shiftid=$id;
	}
$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'attendance/deleteshift/'+$scope.shiftid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.shiftid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}
	
		$scope.onfetchweeklyoff =function()
		{
			$scope.hastrue=true;
			
			$http({
				url: path+'attendance/getOrganizationWeekOff',
				method: "POST",
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
				if(data.status){
					var i=0;
					for(i=0; i<data.data.length; i++){
                         //console.log( result1.data[i].day) ;
						if(data.data[i].Day==1){
							var weekday =  data.data[i].WeekOff.split(",");
							var j=0;
							for(j=0; j<weekday.length; j++){
								if(j==0){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==1){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
									//$("").find(".rb-tab").attr("[data-value=1]").addClass("rb-tab-active");
								}
								else if(j==2){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==3){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
								else if(j==4){
									$('#Sunday-1').parent().find(".rb-tab").removeClass("rb-tab-active");
									$('#Sunday-1').find('div[data-value='+ weekday[j] +']').addClass('rb-tab-active');
								}
							}
						}
					}	
				}//if close of status
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
		}
	
		$scope.hastrue=true;
		$scope.SundayArr=[];
		$scope.MondayArr=[];
		$scope.TuesdayArr=[];
		$scope.WednesdayArr=[];
		$scope.ThursdayArr=[];
		$scope.FridayArr=[];
		$scope.SaturdayArr=[];
		
		$scope.oncreate = function()
		{	
			 for (i=1; i<=5; i++) {
				var Sunday = "Sunday-" + i;
				var rbValue = parseInt($("#"+Sunday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SundayArr.insert(i-1,{week:rbValue});
				
				var Monday = "Monday-" + i;
				var rbValue = parseInt($("#"+Monday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.MondayArr.insert(i-1,{week:rbValue});
				
				var Tuesday = "Tuesday-" + i;
				var rbValue = parseInt($("#"+Tuesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.TuesdayArr.insert(i-1,{week:rbValue});
				
				var Wednesday = "Wednesday-" + i;
				var rbValue = parseInt($("#"+Wednesday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.WednesdayArr.insert(i-1,{week:rbValue});
				
				var Thursday = "Thursday-" + i;
				var rbValue = parseInt($("#"+Thursday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.ThursdayArr.insert(i-1,{week:rbValue});
				
				var Friday = "Friday-" + i;
				var rbValue = parseInt($("#"+Friday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.FridayArr.insert(i-1,{week:rbValue});
				
				var Saturday = "Saturday-" + i;
				var rbValue = parseInt($("#"+Saturday).find(".rb-tab-active").attr("data-value"));
				//Bidimensional array push:
				$scope.SaturdayArr.insert(i-1,{week:rbValue});
			  }
			
				var jsonSunday=angular.toJson($scope.SundayArr);
				var jsonMonday=angular.toJson($scope.MondayArr);
				var jsonTuesday=angular.toJson($scope.TuesdayArr);
				var jsonWednesday=angular.toJson($scope.WednesdayArr);
				var jsonThursday=angular.toJson($scope.ThursdayArr);
				var jsonFriday=angular.toJson($scope.FridayArr);
				var jsonSaturday=angular.toJson($scope.SaturdayArr);

			var xsrf = $.param({jsonSunday: jsonSunday, jsonMonday: jsonMonday, jsonTuesday: jsonTuesday, jsonWednesday: jsonWednesday, jsonThursday: jsonThursday, jsonFriday: jsonFriday, jsonSaturday: jsonSaturday});
			$http({
				url: path+'attendance/saveWeeklyOff',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function (data, status, headers, config) {
					if(data.status){
							successMessage(data.successMsg);					
							$scope.SundayArr=[];
							$scope.MondayArr=[];
							$scope.TuesdayArr=[];
							$scope.WednesdayArr=[];
							$scope.ThursdayArr=[];
							$scope.FridayArr=[];
							$scope.SaturdayArr=[];
					}else{
						errorMessage(data.errorMsg);
					}
					$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
					//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
					$scope.hastrue=false;
			});
		}

	$scope.onupdate = function($val)
	{

		$scope.hastrue=true;
		var xsrf = $.param({shiftid: $scope.shiftid, shiftname: $scope.shiftname, timein:$scope.timein,	timeout:$scope.timeout, timeingrace:$scope.timeingrace,	timeoutgrace:$scope.timeoutgrace, timeinbreak:$scope.timeinbreak, timeoutbreak:$scope.timeoutbreak, breaktimeingrace:$scope.breaktimeingrace, breaktimeoutgrace:$scope.breaktimeoutgrace});
		$http({
			url: path+'attendance/updatedeshift',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.shiftname="";
				$scope.timein="";
				$scope.timeout="";
				$scope.timeingrace="";
				$scope.timeoutgrace="";
				$scope.timeinbreak="";
				$scope.timeoutbreak="";
				$scope.shiftid=0;
				$scope.breaktimeingrace="";
				$scope.breaktimeoutgrace="";	
				
				if($val==1){
					//window.open(path+"attendance/shift", "_self");
					$timeout(function(){window.open(path+"attendance/shift", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});


/////////////////////////// Attendance Controller Starts From Here  ///////////////////////////////////

app.controller('attendanceCtrl', function($scope, $http, $timeout) {
	
	var d =new Date();
	$scope.hastrue=false;
	$scope.attendanceid=0;
	$scope.attendancename="";
	$scope.dept=0;
	$scope.desig=0;
	$scope.shift=0;
	$scope.division=0;
	$scope.department=0;
	$scope.designation=0;
	$scope.emp="";
	$scope.file="";
	$scope.attendancearray=[];
	$scope.departarray=[];
	$scope.desigarray=[];
	$scope.shiftarray=[];
	$scope.divisionarray=[];
	$scope.attandancestatus=[];
	$scope.attendancearray1=[];
	$scope.geoassignarray=[];
	$scope.remark1="";
	$scope.atttype=1;
	$scope.headtitle="Attendance List";
	//$scope.name="";
	//$scope.id="";
	//$scope.location="";
	//$scope.latlong="";
	//$scope.radius=0.250;
	
	$scope.callfunctions = function($atttype) {
		$scope.atttype=$atttype;
		onfetch('setup/getalldepartment',1);
		onfetch('setup/getalldesignation',2);
		onfetch('attendance/getallshift',3);
		onfetch('other',4);
		onfetch('setup/getalldivision',5);
		setTimeout(function(){$scope.attendancearray1=$scope.attendancearray;}, 1000);
		/* if($scope.atttype==1){
			
		$scope.headtitle="Attendance List";
		}else if($scope.atttype==2){
			$scope.headtitle="Employees - Present ";
		}else if($scope.atttype==3){
			$scope.headtitle="Employee List - Not Marked Attendance Today ";
		}else if($scope.atttype==4){
			$scope.headtitle="Employees - Late Comers";
		}else if($scope.atttype==5){
			$scope.headtitle="Employees - Early Leavers";
		}else if($scope.atttype==6){
			$scope.headtitle="Employee List - Not Marked Timeout";
		}else if($scope.atttype==7){
			$scope.headtitle="Attendance updated by Manager";
		}else if($scope.atttype==9){
			$scope.headtitle="Employees - Absent ";
		} */
		
		if($scope.atttype==1){
			$scope.headtitle="Overall Attendance";
		}else if($scope.atttype==2){
			$scope.headtitle="Present Employees ";
		}else if($scope.atttype==3){
			$scope.headtitle="No-Attendance Records ";
		}else if($scope.atttype==4){
			$scope.headtitle="Late Comers";
		}else if($scope.atttype==5){
			$scope.headtitle="Early Leavers";
		}else if($scope.atttype==6){
			$scope.headtitle=" No Time-Out Records";
		}else if($scope.atttype==7){
			$scope.headtitle="Updated by Manager ";
		}else if($scope.atttype==9){
			$scope.headtitle="Absent Employees ";
		}
		//onfetch('setup/getalldivision',5);
				
		/////////////Fetch employee list //////////////////
		////setTimeout(function(){$scope.attendancearray1=$scope.attendancearray;}, 1000);
	}
	/* $scope.addgeofence=function(){
		//alert('');
		var name=$scope.name;
		alert(name);
	} */
	
	$(document).on("click", "#submit", function (){
				var name1=$('#name').val().trim();
				//alert(name1);
				//var name=$scope.name;
				var id1=$('#id').val();
				//var id=$scope.id;
				var location1=$('#location').val().trim();
				//var location=$scope.location;
				var latlong1=$('#latlong').val();
				//var latlong=$scope.latlong;
				var radius1=$('#radius').val();
				//var radius=$scope.radius;
			     if(name1 == ""){
					    //$('#name').val(name);
			            $('#name').focus();
						errorMessage('Please enter the Geo Center Name.');
						return false;
                  } 
			 else if(latlong1==""){
                       $('#latlong').focus();
					   errorMessage('Latitude and Longitude can not be null.');
						return false;
			  
             }
			 else if(location1 == ""){
                        $('#location').focus();
                        //$('#location').val(location);
						errorMessage('Please enter the Geo Center Address .');
						return false;
             }
			 else if(radius1==""){
                        $('#radius').focus();
						errorMessage('Please enter Fence Radius .');
						return false;
             }
			 else if(radius1 < 0.5){
                        $('#radius').focus();
						errorMessage('Radius should be greater than 0.5');
						return false;
             }
			 
	var xsrf=$.param({id:id1,name:name1,location:location1,latlong:latlong1,radius:radius1})
	$http({
        url: path+'attendance/saveGeolocation',
        method: "POST",
		data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 //table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
			$timeout(function(){window.open(path+"attendance/geofence", "_self");}, timeo);
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	});
	$scope.getGeoDetail = function($id,$name,$status,$radius){
		$scope.id=$id;
		
		$scope.name=$name;
		$scope.sts=$status;
		$scope.radius=$radius;
		//alert($radius);
		$timeout(function(){	$('#myModal').modal('show');}, 500);
		
	}
	$scope.deleteGeoDetail = function($id,$name){
		$scope.id=$id;
		$scope.name=$name;
		$timeout(function(){	$('#confirm').modal('show');}, 500);

	}
	
	$scope.deleteGeofenceDetail =function()
	{
		$http({
        url: path+'attendance/deleteGeofenceDetail/'+$scope.id,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config){
				if(data.status){
				 successMessage(data.successMsg);
				}else{
				errorMessage(data.errorMsg);
				}
				$scope.id=0;
				$timeout(function(){window.open(path+"attendance/geofence", "_self");}, timeo);
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	// $scope.attdate="";
	// $("#daypicker").datepicker( {
		// todayHighlight:true
	// }).on('changeDate', function(e){ 
		// //alert(e.format('yyyy-mm-dd'))
		// var d = e.format('yyyy-mm-dd');
		// $scope.attdate=d;
		// $scope.getoutsideatt(0);
	// });
	$scope.getoutsideatt =function($val)
	{
		
		var xsrf=$.param({val:$val,attdate:$scope.attdate})
		$http({
        url: path+'attendance/getoutsideatt',
		data:xsrf,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config){
				if(data.status){
				 $scope.attdata=data.data;
				 $scope.dateview=data.dateview;
				 
				}else{
				//errorMessage(data.errorMsg);
				}
				
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	$scope.saveGeoDetail =function()
	{
		
		if($scope.name==""){
			errorMessage('Please enter the Geo-Center Name.');
			return false;
		}
		if($scope.radius<0.05)
		{
			errorMessage('Radius should be greater than 0.05 (km)');
			return false;
		}
		
		var xsrf=$.param({id:$scope.id, name:$scope.name,sts:$scope.sts,radius:$scope.radius})
		$http({
			url: path+'attendance/saveGeolocation',
			method: "POST",
			data:xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					 successMessage(data.successMsg);
					 //table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$timeout(function(){window.open(path+"attendance/geofence", "_self");}, timeo);
				//$scope.id=0;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				//errorMessage("Unable to connect API");
				$scope.hastrue=false;
			});
	}
	//assignGeo('attendance/assignGeo');
	//division('setup/getalldivision');
	
	/* function division($val)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {				
				if(data.status){
					//if($id==2){
						$scope.divisionarray=[];
						$scope.divisionarray=data.data;
						$scope.divisionarray.insert(0,{id:0, name:"---- All Division----"});
					//}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	} */
	$scope.selectdivision=function($id){
		//alert($id);
		//alert($scope.geoId);
		$scope.id=$id;
		//alert($scope.id);
		$scope.geoId;
		$scope.hastrue=true;
		var xsrf = $.param({id:$scope.id,geoId: $scope.geoId});
		$http({
			url: path+'attendance/geocenterempbydiv',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
				
		  }).success(function (data, status, headers, config) {
				if(data.status){
					 successMessage(data.successMsg);
					$scope.geoassignarray=data.data;
					 //table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.id=0;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	$scope.assignGeo=function($geoId)
	{
		//alert('');
		//$scope.geoassignarray=[];
		$scope.geoId=$geoId;
		$scope.hastrue=true;
		var xsrf = $.param({geoId: $scope.geoId});
		$http({
			url: path+'attendance/assignGeo',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config){
			if(data.status){
				//successMessage(data.successMsg);
				$scope.geoassignarray=data.data;
				//console.log($scope.geoassignarray);
				setTimeout(function(){
					$("#assignGeoModal").modal('show');
					//$timeout(function(){$scope.getrow();}, 500); 
				}, 1000);
				//$timeout(function(){$('#assignGeoModal').modal('show');}, 500);
			}else{
				$scope.attendancearray=[];
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	////////////List group item function ///////////////
	/* $scope.getrow= function ($index) {
		//alert($index);
		$('.list-group.checked-list-box .list-group-item').each(function () {
			// Settings
			var $widget = $(this),
			$checkbox = $('<input type="checkbox" class="hidden" value="'+$index+'" id="'+$index+'checked"/>'),
			color = ($widget.data('color') ? $widget.data('color') : "primary"),
			style = ($widget.data('style') == "button" ? "btn-" : "list-group-item-"),
			settings = {
				on: {
					icon: 'glyphicon glyphicon-check'
				},
				off:{
					icon: 'glyphicon glyphicon-unchecked'
				}
			};
            
			$widget.css('cursor', 'pointer')
			$widget.append($checkbox);

			// Event Handlers
			$widget.on('click', function () {
				$checkbox.prop('checked', !$checkbox.is(':checked'));
				$checkbox.triggerHandler('change');
				updateDisplay();
			});
			$checkbox.on('change', function () {
				updateDisplay();
			});
			// Actions
			function updateDisplay() {
				var isChecked = $checkbox.is(':checked');
				//console.log(isChecked);
				// Set the button's state
				$widget.data('state', (isChecked) ? "on" : "off");
				
				// Set the button's icon
				$widget.find('.state-icon')
                .removeClass()
                .addClass('state-icon ' + settings[$widget.data('state')].icon);

            // Update the button's color
				if (isChecked) {
					$widget.addClass(style + color + ' active');
				} else {
					$widget.removeClass(style + color + ' active');
				}
			}
			// Initialization
			function init() {
            
				if ($widget.data('checked') == true) {
					$checkbox.prop('checked', !$checkbox.is(':checked'));
				}	
            
				updateDisplay();

				// Inject the icon if applicable
				if ($widget.find('.state-icon').length == 0) {
					$widget.prepend('<span class="state-icon ' + settings[$widget.data('state')].icon + '"></span>');
				}
			}
			init();
		});
	}; */
	
	/////////////////Select Multiple Checkboxes/////////////////////
	$scope.selected=[];
	$scope.exist=function(itm){
		return $scope.selected.indexOf(itm) > -1;
	}
	$scope.toggleAll = function() {
		var toggleStatus = $scope.isAllSelected;
		angular.forEach($scope.geoassignarray, function(itm){ itm.selected = toggleStatus; });
	}
	$scope.optionToggled = function(){
		$scope.isAllSelected = $scope.geoassignarray.every(function(itm){ return itm.selected; })
	}
	
	/* $scope.selected=[];
	$scope.exist=function(item){
		return $scope.selected.indexOf(item) > -1;
	}
	$scope.toggleSelection=function(item){
		var idx= $scope.selected.indexOf(item);
		if(idx > -1){
			$scope.selected.splice(idx,1);
		}else{
			//alert(angular.toJson(item.sts));
			//alert();
			if(item.sts==0){
				item.sts=1;
				//$scope.geoassignarray[$index]['sts']=1;
				//alert('if');
			}
			$scope.selected.push(item);
		}
	}
	$scope.checkAll = function() {
		if($scope.selectAll){
			angular.forEach($scope.geoassignarray, function(item){ 
			var idx=$scope.selected.indexOf(item);
			if(idx >=0){
				return true;
			}else{
				if( item.sts==0 ){
					item.sts=1;
				}
				//console.log(angular.toJson(item.sts));
				$scope.selected.push(item);
			}
			})
			
		}else{
			$scope.selected=[];
		}
	} */
	
	
	/* $scope.getchecklistid=function($id){
		//alert($id);		//emp id
		var customInput =  $(".list-group-item.list-group-item-success.active").length;
		//alert(customInput);
			for(var i=0; i< $scope.geoassignarray.length;i++){
				if($scope.geoassignarray[i]['id']==$id){
					if(customInput==i){
						customInput +=1;
					}
					if(customInput==i){
						$scope.geoassignarray[i]['sts']=0;
						//console.log($scope.geoassignarray[i]['sts']);
					}else{
						$scope.geoassignarray[i]['sts']=1;
						//console.log($scope.geoassignarray[i]['sts']);
							//console.log($scope.checklistarray[i]['sts1']);
					}
				}
			}
			//alert(angular.toJson($scope.geoassignarray[$index]));
		if($scope.geoassignarray[$index]['sts']==0){
			$scope.geoassignarray[$index]['sts']=1;
			//alert('if');
		}else{
			//$scope.geoassignarray[$index]['sts']=0;
			//alert('else');
		}
		//alert($scope.geoassignarray[$index]['sts']);
	} */
	$scope.SaveAssignGeo=function($id){
		//alert($id);
		//var total= $("#check-list-box li").length;

		//var selectcheck= $(".list-group-item.list-group-item-success.active").length;
		//alert(selectcheck);
		/* $('.list-group.checked-list-box .list-group-item').each(function ($index) {
		var customInput = $(this).find("#"+$index+"checked");
		console.log(customInput);
		}); */
		//alert(total);alert(selectcheck);
		var selected =$('.chk:checked').length;
		
		if(selected!=0){
			var json=angular.toJson($scope.geoassignarray);	
			//alert(json);
			//console.log(json);
			//return false;		
			var xsrf = $.param({ geoId:$scope.geoId,geoemplist:json});
			$http({
				url: path+'attendance/SaveEmpGeoList',
				method: "POST",
				data: xsrf,
				headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
			}).success(function(data, status, headers, config){
					if(data.status){
						$('#myCheckbox').prop('checked', false);
						$('#assignGeoModal').modal('hide');
						// table1.draw();
						//doNotify('top','center',2,'Employee shift updated successfully.');
						successMessage(data.successMsg);
						//$timeout(function(){window.open(path+"attendance/geofence", "_self");}, timeo);
					}else{
						errorMessage(data.errorMsg);
					}
					$scope.hastrue = false;
				}).error(function(data, status, headers, config){
					/* errorMessage("error: "+$scope.status); */
					$scope.hastrue=false;
				});
		}else {
			alert("Select atleast one employee ");
			return false;
		}
	}
		$scope.showremarks = function($id,$remarks) {
		$scope.remark1=$remarks;
		console.log($scope.remark1);
		$scope.attendanceid=$id;
		$timeout(function(){	$('#remarkmodal').modal('show');}, 500);
		/* setTimeout(function(){
	
		
		}, 500); */
	}
	$scope.getId = function($id) {
		$scope.attendanceid=$id;
	}
	
	$scope.attnRestore =function()
	{
		//console.log();
		$http({
			url: path+'attendance/restoreAttendance/'+$scope.attendanceid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					 successMessage(data.successMsg);
					 table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.restoreid=0;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	$scope.attnPerDeletion =function()
	{
		$http({
			url: path+'attendance/perDelationAttendance/'+$scope.attendanceid,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {
				if(data.status){
					 successMessage(data.successMsg);
					 table.draw();
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.attendanceid=0;
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);/$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
	}
	$scope.showimg = function($id,$img) {
		$scope.imgname=$img;
		$scope.attendanceid=$id;
		setTimeout(function(){
		$('#myModal').modal('show');
		$("#changeimg").attr('src',$img);
		}, 500);
	}
	///////////Save Remarks ///////////////
$scope.SaveRemarks =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	var xsrf=$.param({remark:$scope.remark1, attendanceid:$scope.attendanceid})
	$http({
        url: path+'attendance/SaveRemarks',
        method: "POST",
		data:xsrf,
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.attendanceid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}


$scope.ondelete =function()
{
	//$scope.rolearr=[];
	//$scope.hastrue=true;
	$http({
        url: path+'attendance/deleteattendance/'+$scope.attendanceid,
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
      }).success(function (data, status, headers, config) {
			if(data.status){
			
				 successMessage(data.successMsg);
				 table.draw();
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.attendanceid=0;
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
}

	Array.prototype.insert = function (index, item) {
	  this.splice(index, 0, item);
	};
	
	Array.prototype.remove = function (index) {
	  this.splice(index,1);
	};
$scope.customefilter = function(item) {
        return (item.value==1 || item.value==2) && item.type=='AttendanceStatus';
    };
	$scope.removework = function($i){
		$scope.attendancearray.remove($i);	
	}

	$scope.checkovertime = function($i){
		
		var timein = new Date("01/01/1970 " + $scope.attendancearray[$i].timein);
		//console.log(timein+"time in");
		var timeout = new Date("01/01/1970 " + $scope.attendancearray[$i].timeout);
		var shifttimein = new Date("01/01/1970 " + $scope.attendancearray[$i].shifttimein).getTime();
		var shifttimeout = new Date("01/01/1970 " + $scope.attendancearray[$i].shifttimeout).getTime();
		var shifttimeinbreak = new Date("01/01/1970 " + $scope.attendancearray[$i].shifttimeinbreak).getTime();
		var shifttimeoutbreak = new Date("01/01/1970 " + $scope.attendancearray[$i].shifttimeoutbreak).getTime();
		
		var difference = new Date((timeout - timein)-(shifttimeoutbreak-shifttimeinbreak)).toUTCString().split(" ")[4];
		var difference2 = new Date((shifttimeout - shifttimein)-(shifttimeoutbreak-shifttimeinbreak)).toUTCString().split(" ")[4];
		
		var over1 = new Date((timeout - timein)-(shifttimeoutbreak-shifttimeinbreak));
		var over2 = new Date((shifttimeout - shifttimein)-(shifttimeoutbreak-shifttimeinbreak));
		
		if(difference>difference2){
			var difference1 = new Date(over1 - over2).toUTCString().split(" ")[4]; 
			var arr1 = difference1.split(":");
			$scope.attendancearray[$i].overtime= arr1[0]+":"+arr1[1];
		}else{
			var difference1 = new Date(over2 - over1).toUTCString().split(" ")[4]; 
			var arr1 = difference1.split(":");
			$scope.attendancearray[$i].overtime= "-"+arr1[0]+":"+arr1[1];
		}
		//alert( difference ); // shows: 00:07:03
		if(difference != undefined){
		var arr = difference.split(":");
		$scope.attendancearray[$i].totaltime= arr[0]+":"+arr[1];
		if($scope.attendancearray[$i].sts==5 || $scope.attendancearray[$i].sts==3)
		{
			$scope.attendancearray[$i].overtime= arr[0]+":"+arr[1];
		}
		
		}
		
	}
	
	function onfetch($val, $id)
	{
		$scope.hastrue=true;
		$http({
			url: path+$val,
			method: "POST",
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		  }).success(function (data, status, headers, config) {				
				if(data.status){
					if($id==1){
						$scope.departarray=[];
						$scope.departarray=data.data;
						$scope.departarray.insert(0,{id:0, name:"---- All Department----"});
					}else if($id==2){
						$scope.desigarray=[];
						$scope.desigarray=data.data;
						$scope.desigarray.insert(0,{id:0, name:"---- All Designation----"});						
					}else if($id==3){
						$scope.shiftarray=[];
						$scope.shiftarray=data.data;
						$scope.shiftarray.insert(0,{id:0, name:"---- All Shift----"});	
						$scope.shift=data.data[0].id;
						//onfetchattendance();						
					}else if($id==4){
						$scope.attandancestatus=[];
						$scope.attandancestatus=data.data;
						for (var i = 0; i<$scope.attandancestatus.length; i++) {
							$scope.attandancestatus[i].value= parseInt($scope.attandancestatus[i].value);
						}  
						//$scope.desigarray.insert(0,{id:0, name:"---- All ----"});						
					}else if($id==5){
						$scope.divisionarray=[];
						$scope.divisionarray=data.data;
						//$scope.divisionarray.insert(0,{id:0, name:"---- All Division----"});
					}
				}
				$scope.hastrue=false;
			}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
			});
			
	}
	
	$scope.onfetchemployee =function(){
		onloadCall();
	}
	
	
	function onloadCall()
	{
		$scope.hastrue=true;
		var xsrf = $.param({divisionid: $scope.division, deptid: $scope.dept, degid: $scope.desig, shiftid: $scope.shift, atdate: $scope.atdate,empname: $scope.empname});
		$http({
			url: path+'attendance/getallemployeebycondition',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.attendancearray=[];
				$scope.attendancearray=data.data;
					//$scope.attendancearray1=data.data;
					$scope.attendancearray1=data.data;
				setTimeout(function(){
					
					$(".timepicker").timepicker({ showInputs: false,showMeridian: false, minuteStep:1});
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', radioClass: 'iradio_square-blue',
          increaseArea: '20%'  });
					$('input').on('ifToggled', function(event){
  
					  //if(event.target.name=='chk1')
						$scope.attendancearray[event.target.name].sts=event.target.checked;
					 //errorMessage($scope.attendancearray[event.target.name].sts);
					});
					
					
				}, 1000);
			}else{
				$scope.attendancearray=[];
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$scope.onfetchattendance= function()
	{
		$scope.hastrue=true;
		var xsrf = $.param({attendanceid: $scope.attendanceid});
		$http({
			url: path+'attendance/getaattendance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.shift=data.data[0]['shiftid'];
				$scope.atdate=data.data[0]['atdate'];
				$scope.attendancearray=data.data;
				//$scope.attendancearray1=data.data;
				$scope.attendancearray1=data.data;
				setTimeout(function(){
					$(".timepicker").timepicker({ showInputs: false,showMeridian: false, minuteStep:1});
					
					$('input').iCheck({checkboxClass: 'icheckbox_square-blue', increaseArea: '20%'  });
					if(parseInt(data.data[0]['sts'])>0)
						$('input').iCheck("check");
					
					$('input').on('ifToggled', function(event){
						$scope.attendancearray[event.target.name].sts=event.target.checked;
					});
					
				}, 100);
			}else{
				if($scope.attendanceid==0){
					$scope.atdate = data.curdate;
					onloadCall();
				}
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		$scope.hastrue=true;
		var jsonData=angular.toJson($scope.attendancearray);
		
		var xsrf = $.param({shift: $scope.shift, atdate:$scope.atdate, jsonarr:jsonData});
		$http({
			url: path+'attendance/createattendance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);					
					$scope.attendancename="";					
					$scope.attendanceid=0;	
					$scope.attendancearray=[];					
					if($val==1){
						//window.open(path+"attendance/attendance", "_self");
						$timeout(function(){window.open(path+"attendance/attendance", "_self");}, timeo);
					}
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{

		$scope.hastrue=true;
		var jsonData=angular.toJson($scope.attendancearray);
		
		var xsrf = $.param({attendanceid: $scope.attendanceid, jsonarr:jsonData});
		$http({
			url: path+'attendance/updatedeattendance',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.attendancename="";
				$scope.attendanceid=0;
				$scope.attendancearray=[];
				if($val==1){
					//window.open(path+"attendance/attendance", "_self");
					$timeout(function(){window.open(path+"attendance/attendance", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	
	$("#filter1").click(function(){
		var condition ="";
		var division = $scope.division;
		//console.log($('#division').val())
		var department = $scope.department;
		var designation = $scope.designation;
		var shift = $scope.shift;
		//var grade = document.getElementById('grade').value;
		
		if(division!=0){ condition = " Division="+division;}
		if(department!=0){ 
			if(condition =="")
				condition = " Department="+department;	
			else
				condition = condition+" And Department="+department;	
		}
		if(designation!=0){ 
			
			if(condition =="")
				condition = " Designation="+designation;
			else
				condition = condition+" and Designation="+designation;
		}
		if(shift!=0){ 
			
			if(condition =="")
				condition = " Shift="+shift;
			else
				condition = condition+" and Shift="+shift;
		}
		
		if(condition!="")
			table.columns( 1 ).search( condition ).draw();
			
		
	});
	
	
	///////////////////////////////////////file upload/import///////////////////////////////
	
	$scope.model = {
        name: "",
        comments: ""
		
    };

    //an array of files selected
    $scope.files = [];

    //listen for the file selected event
    $scope.$on("fileSelected", function (event, args) {
        $scope.$apply(function () {            
            //add the file object to the scope's files collection
            $scope.files.push(args.file);
			
        });
    });
   $scope.headnamearray=[]; 
    //the save method
    $scope.importFile = function() {
	

	$scope.hastrue=true;
        $http({
            method: 'POST',
            url: path+"attendance/importheadersfile",
            //IMPORTANT!!! You might think this should be set to 'multipart/form-data' 
            // but this is not true because when we are sending up files the request 
            // needs to include a 'boundary' parameter which identifies the boundary 
            // name between parts in this multi-part request and setting the Content-type 
            // manually will not set this boundary parameter. For whatever reason, 
            // setting the Content-type to 'false' will force the request to automatically
            // populate the headers properly including the boundary parameter.
            headers: { 'Content-Type': undefined },
            //This method will allow us to change how the data is sent up to the server
            // for which we'll need to encapsulate the model data in 'FormData'
            transformRequest: function (data) {
                var formData = new FormData();
                //need to convert our json object to a string version of json otherwise
                // the browser will do a 'toString()' on the object which will result 
                // in the value '[Object object]' on the server.
                formData.append("model", angular.toJson(data.model));
                //now add all of the assigned files
                for (var i = 0; i < data.files.length; i++) {
                    //add each file to the form data and iteratively name them
                    formData.append("file" + i, data.files[i]);
                }
				
                return formData;
            },
            //Create an object that contains the model and files which will be transformed
            // in the above transformRequest method
            data: { model: $scope.model, files: $scope.files }
        }).
        success(function (data, status, headers, config) {
			if(data.status){
				//errorMessage(data.successMsg);
					$scope.headnamearray=data.data;	
					
					
			}
			else{
					errorMessage(data.errorMsg);
				}
				//window.open(path+"attendance/importattendance", "_self");
			$scope.hastrue=false;
			
		}).
        error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);
           $scope.hastrue=false;
        });
    };
	
	$scope.timeout=0;
	$scope.insertheaders = function($val)
	{	
		$scope.hastrue=true;
		
		var xsrf = $.param({emp: $scope.emp, atdate:$scope.atdate,timein:$scope.timein, timeout:$scope.timeout,attsts:$scope.attsts });
		$http({
			url: path+'attendance/insertheaders',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);
					$timeout(function(){window.open(path+"attendance/attendance", "_self");}, timeo);					
					
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}
	
});



/////////////////////////// Attendance Type Controller Starts From Here  ///////////////////////////////////

app.controller('attendancetypeCtrl', function($scope, $http, $timeout) {

	var d =new Date();
	$scope.hastrue=false;
        $scope.id="";
	$scope.attendancetypeid=0;
	$scope. name="";
	$scope.typecolor="";
                            /*$("#typecolor").click(function(){
				
                                 var typecolor = $(this).val();
                                 $scope.typecolor=typecolor;
                              
			 });*/
$( "button ").click(function() {
$( "#typecolor" ).click();
});
$( "#typecolor" ).click(function( ) {
var typecolor = $(this).val();
$scope.typecolor=typecolor;
});
  




	$scope.onfetchattendancetype =function($id)
	{        
		$scope.hastrue=true;
		var xsrf = $.param({attendancetypeid: $id});
		$http({
			url: path+'attendance/getaattendancetype',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
			if(data.status){
				$scope.name=data.data[0]['name'];
				$scope.typecolor=data.data[0]['typecolor'];
                        
			}
			$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}

	$scope.oncreate = function($val)
	{	
		$scope.hastrue=true;

		var xsrf = $.param({name : $scope.name, typecolor: $scope.typecolor});
		$http({
			url: path+'attendance/createattendancetype',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
				if(data.status){
					successMessage(data.successMsg);					
					$scope.name="";					
					$scope.typecolor="";
                                      		
		
					if($val==1){
						//window.open(path+"attendance/attendancetype", "_self");
						$timeout(function(){window.open(path+"attendance/attendancetype", "_self");}, timeo);
					}
				}else{
					errorMessage(data.errorMsg);
				}
				$scope.hastrue=false;
		}).error(function (data, status, headers, config) {
				//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
				$scope.hastrue=false;
		});
	}

	$scope.onupdate = function($val)
	{
       
		$scope.hastrue=true;
		var xsrf = $.param({name : $scope.name, typecolor: $scope.typecolor , attendancetypeid: $scope.attendancetypeid });
		$http({
			url: path+'attendance/updatedeattendancetype',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function (data, status, headers, config) {
		
			if(data.status){
				successMessage(data.successMsg);
				$scope.name="";
				$scope.typecolor="";
                               $scope.attendancetypeid="";
				if($val==1){
					//window.open(path+"attendance/attendancetype", "_self");
					$timeout(function(){window.open(path+"attendance/attendancetype", "_self");}, timeo);
				}				
			}else{
				errorMessage(data.errorMsg);
			}
			$scope.hastrue=false;
        }).error(function (data, status, headers, config) {
            //errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
});


