<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>UBIHRM | Approvals</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="<?php echo URL;?>public/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Font Awesome Icons -->
    <link href="<?php echo URL;?>public/font-awesome-4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="<?php echo URL;?>public/dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins 
         folder instead of downloading all of them to reduce the load. -->
    <link href="<?php echo URL;?>public/dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
	<?php include(VIEWS_PATH."_templates/sidebar.php");?>
  </head>
  <body class="skin-green" ng-app="ubiapp">
    <!-- Site wrapper -->
    <div class="wrapper"  ng-controller="approvalCtrl" ng-init="approvalid='<?= $this->approvalid ?>';onfetchdept(approvalid)">
      
      <header>
		<?php echo topmenu(5);?>
	  </header>

      <!-- =============================================== -->

      <!-- Left side column. contains the sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <?php echo sidemenu(5.52,5);?>
        <!-- /.sidebar -->
      </aside>

      <!-- =============================================== -->

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Approvals            
          </h1>
          <ol class="breadcrumb">
            
            <li><a href="<?php echo URL;?>setup"><i class="fa fa-building-o"></i> Organization</a></li>
            <li><a href="<?php echo URL;?>setup/approval"></i> Approvals</a></li>
            <li class="active"><span ng-show="approvalid == '0'">Add</span><span ng-show="approvalid != '0'">Edit</span>  </li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">

          <!-- Default box -->
          <div class="box box-solid">
            <div class="box-header with-border">
              <h3 class="box-title"><span ng-show="approvalid == '0'">Add</span><span ng-show="approvalid != '0'">Edit</span> </h3>
              <div class="box-tools pull-right">
				<button class="btn btn-box-tool" data-toggle="tooltip" title="Help"><i class="fa fa-question"></i></button>
              </div>
            </div>
			<div class="box-body">
							<form role="form" class="form-horizontal" name="myForm" novalidate>
								<div class="form-group">
									<label class="control-label col-sm-4" for="approvaltype">Approval Type</label>
									<div class="col-sm-4" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.approvaltype.$valid]">
										<select id="approvaltype" name="approvaltype" ng-model="approvaltype" class="form-control" required>
											<option value="0">ALL</option>
											<option value="1">Leave</option>
											<option value="2">Personal Loan</option>
											<option value="3">Document Request</option>
											<option value="4">Resignation</option>
											<option value="5">Termination</option>
											<option value="6">Personnel Requisition</option>
											<option value="7">Claims</option>
											<option value="8">Time off</option>
											<option value="9">Promotion/Demotion</option>
											<option value="10">Transfer/Redesignation</option>
											<option value="11">Salary Advance</option>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-sm-4" for="approvalfor">Approval for</label>
									<div class="col-sm-4" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.approvalfor.$valid]">
										<select id="approvalfor" name="approvalfor" ng-model="approvalfor" class="form-control"  ng-change="onchangedesig(1)"  required>
										<option value="0">ALL</option>
										<option ng-repeat="c in designations" value="{{c.id}}">{{c.name}}</option>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-sm-4" for="period">Escalation period</label>
									<div class="col-sm-2" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.period.$valid]">
										<div class="input-group">
										<input type="text" id="period" name="period" ng-model="period" class="form-control" required/>
										<div class="input-group-addon">
											Day(s)
										</div>
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-sm-4" for="period">HR Approval</label>
									<div class="col-sm-3" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.hrapproval.$valid]">
										<input type="checkbox" id="hrapproval" name="hrapproval" ng-model="hrapproval" value="FALSE"  style="margin-top: 8px;">
									</div>
								</div>
								<h4>Approval Levels</h4><hr>
								<!--<div class="form-group" >
									<label class="text-right col-sm-4" >Show Approvers&nbsp;&nbsp;</label>
									<div class="col-sm-1" >
										<input type="radio"  name="showapprovals" id="showapprovals" ng-model="showapprovals" value="0" ng-change="onchangedesig(0)" ng-click="alls">&nbsp;&nbsp;All
									</div>
									<div class="col-sm-2" >
										<input type="radio"  name="showapprovals" id="showapprovals" ng-model="showapprovals" value="1" ng-click="onchangedesig(1)" ng-checked="hier">&nbsp;&nbsp;By Hierarchy
									</div>
								</div>	-->
								<div class="form-group" ng-repeat="s in approvalbenefits" ng-show="showdesig==1">
									<label class="control-label col-sm-2" for="deptname"></label>
									<label class="control-label col-sm-2" for="deptname">Level&nbsp;&nbsp;{{$index+1}}&nbsp;&nbsp; </label>
									<div class="col-sm-4">
										<input type="text" class="form-control" readonly ng-model="s.dname" ng-show="s.dname">
										<select class="form-control" ng-model="s.benefit" ng-options="c.id as c.name for c in designationarray" ng-show="!s.dname" > </select>
										
									</div>
									<div class="col-sm-2">
										<button type="button" class="btn btn-primary" ng-show="approvalbenefits.length<=($index+1)"  ng-click="removesalary(s.benefit,$index)" ><i class="fa fa-minus"></i></button>
										<button type="button" class="btn btn-primary" ng-show="approvalbenefits.length==($index+1) && (designationarray.length>=1)"  ng-click="addsalary(s.benefit,$index);" ng-disabled="(designationarray.length==0)"><i class="fa fa-plus"></i></button>	
									</div>
								</div>
								<div ng-show="showuptolevel==1">
									<label class="control-label col-sm-2" for="deptname"></label>
									<label class="control-label col-sm-2" for="deptname">Approval upto&nbsp;&nbsp; </label>
									<div class="col-sm-1">
										<input type="number" min='0' max='4' class="form-control" ng-model="approvalupto" name="approvalupto" id="approvalupto" ng-change="CheckMaxVal(approvalupto)" value="0"> 
									</div>
									<label style="margin-top:8px"> Level</label>
								</div>
							</form>
                     <div class="clearfix"></div>
             </div><!-- /.box-body -->
			 <div class="overlay" ng-show="hastrue">
                  <i class="fa fa-refresh fa-spin"></i>
             </div>
			 <div class="box-footer text-center">
                    <button type="submit" class="btn btn-primary" ng-show="approvalid == '0'"  ng-click="oncreate(1)" ng-disabled="myForm.$invalid ">Save</button>
					<button type="submit" class="btn btn-primary" ng-show="approvalid == '0'" ng-click="oncreate(0)" ng-disabled="myForm.$invalid ">Save&nbsp;&amp;&nbsp;New</button>
					<button type="submit" class="btn btn-primary" ng-show="approvalid != '0'"  ng-click="onupdate(1)" ng-disabled="myForm.$invalid ">Save</button>
					<button type="submit" class="btn btn-primary" ng-show="approvalid != '0'" ng-click="onupdate(0)" ng-disabled="myForm.$invalid">Save&nbsp;&amp;&nbsp;New</button>
					<button type="button" class="btn btn-primary" onclick="window.location = '<?php echo URL;?>setup/approval'">Cancel</button>
             </div>
           <!-- /.box-footer-->
          </div><!-- /.box -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->

      <footer class="main-footer">
        <?php footertext();?>
      </footer>
    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.3 -->
    <script src="<?php echo URL;?>public/plugins/jQuery/jQuery-2.1.3.min.js"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="<?php echo URL;?>public/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
	<script src="<?php echo URL;?>public/angularjs/angular.min.js" type="text/javascript"></script>
	
  
	<script src="<?php echo URL;?>public/angularjs/ubiapp.js" type="text/javascript"></script>
    <script src="<?php echo URL;?>public/plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
    <!-- FastClick -->
    <script src='<?php echo URL;?>public/plugins/fastclick/fastclick.min.js'></script>
  <!---------------------------------------------------->

    
  </body>
</html>
