<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>UBIHRM | Salary Paid Days Setup</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="<?php echo URL;?>public/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Font Awesome Icons -->
    <link href="<?php echo URL;?>public/font-awesome-4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo URL;?>public/plugins/datepicker/datepicker3.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="<?php echo URL;?>public/dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins 
         folder instead of downloading all of them to reduce the load. -->
    <link href="<?php echo URL;?>public/dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
	<?php include(VIEWS_PATH."_templates/sidebar.php");?>
  </head>
 <body class="skin-green" ng-app="salaryapi">
    <!-- Site wrapper -->
    <div class="wrapper"  ng-controller="salarysetupCtrl" ng-init="onfetchsalarysetup(salarysetupid);">
      
      	<header>
		<?php echo topmenu(4);?>
	</header>

      <!-- =============================================== -->

      <!-- Left side column. contains the sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <?php echo sidemenu(4.51,4);?>
        <!-- /.sidebar -->
      </aside>

      <!-- =============================================== -->

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Salary            
          </h1>
          <ol class="breadcrumb">
            
            <li><a href="<?php echo URL;?>salary"><i class="fa fa-wrench"></i> Salary</a></li>
            <li><a href="<?php echo URL;?>setup/salarysetup"></i> Salary Paid Days Setup</a></li>
            <li class="active"><span ng-show="!salarysetupid">Add</span><span ng-show="salarysetupid">Edit</span> </li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">

          <!-- Default box -->
          <div class="box box-solid">
            	<div class="box-header with-border">
              		<h3 class="box-title"><span ng-show="salarysetupid==0">Add</span><span ng-show="salarysetupid==1">Edit</span><span ng-show="salarysetupid && val">View</span>  </h3>
              		<div class="box-tools pull-right">
             		</div>
            	</div>
				<div class="box-body" >
					<form role="form" class="form-horizontal" name="myForm" novalidate >
						<div class="row" >
							<div class="col-sm-7">
								<div class="form-group">
									<label class="control-label col-sm-5" for="dept">Pay Days in a month</label>
									<div class="col-sm-5" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.name.$valid]">
										<select name="name" class="form-control" ng-model="paydays"  required ng-disabled="val">
											<option value="">Select working days</option>
											<option value="20">20</option>
											<option value="21">21</option>
											<option value="22">22</option>
											<option value="23">23</option>
											<option value="24">24</option>
											<option value="25">25</option>
											<option value="26">26</option>
											<option value="27">27</option>
											<option value="28">28</option>
											<option value="29">29</option>
											<option value="30">30</option>
											<option value="31">31</option>
											<option value="1">Actual days in a month</option>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-sm-5" for="dept">Exclude Weekoffs</label>
									<div class="col-sm-6" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.name.$valid]">
										<label><input type="radio" name="weekoff" id="weekoff" ng-model="weekoff" value="1"> Yes </label>
										<label><input type="radio" name="weekoff" id="weekoff" ng-model="weekoff" value="0"> No </label>
										
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-sm-5" for="dept">Exclude Holidays</label>
									<div class="col-sm-6" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.name.$valid]">
										<label><input type="radio" name="holiday" id="holiday" ng-model="holiday" value="1"> Yes </label>
										<label><input type="radio" name="holiday" id="holiday" ng-model="holiday" value="0"> No </label>
										
									</div>
								</div>
								
							</div>
							<div class="col-sm-5">
								<div class="box box-solid" style="background-color:#EFEFF8;">
										<div class="box-header with-border">
										  <h4 class="box-title">&nbsp;&nbsp;&nbsp;&nbsp;Points to remember</h4>
										  
										</div> <!--box-header-->
										<div class="box-body">
										  <ul>
												<li>Calculation of number of days for a given pay period has significant impact when deducting salary for Loss of Pay due to Leave or other reason.<br>
												Ex: Loss of Pay for 1 day for an employee whose salary is Rs.30,000/month is calculated as below</li>
												<li>Loss of Pay when days = 30-> Rs.30,000/30 = Rs.1000</li>
												<li>Loss of Pay when days are calculated excluding Weekends.<br>
												Let’s say there are 8 Saturday & Sundays in month.<br>
												Effective days = 30-8 = 22 days<br>
												Loss of Pay = Rs.30,000/22 = Rs.1364.</li>
												
										  </ul>
										</div>
									 </div><!-- /.box -->
								
							</div>
							
						</div>
						
					</form>
				</div><!-- /.box-body -->
				<div class="overlay" ng-show="hastrue">
                  <i class="fa fa-refresh fa-spin"></i>
				</div>
				 <div class="box-footer text-center">
                    
					<button type="button" class="btn btn-primary"  ng-click="salaryPaidDaysSetup(1)" ng-disabled="myForm.$invalid || val">Save</button>
					
					<button type="button" class="btn btn-primary" onclick="window.location = '<?php echo URL;?>salary/salarysetup'">Cancel</button>
             </div>
           <!-- /.box-footer-->
          </div><!-- /.box -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->

      <footer class="main-footer">
        <?php footertext();?>
      </footer>
    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.3 -->
    <script src="<?php echo URL;?>public/plugins/jQuery/jQuery-2.1.3.min.js"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="<?php echo URL;?>public/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
	<script src="<?php echo URL;?>public/angularjs/angular.min.js" type="text/javascript"></script>
	<script src="<?php echo URL;?>public/angularjs/salary.js" type="text/javascript"></script>
     <!-- SlimScroll -->
    <script src="<?php echo URL;?>public/plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
    <!-- FastClick -->
    <script src='<?php echo URL;?>public/plugins/fastclick/fastclick.min.js'></script>
	<script src="<?php echo URL;?>public/plugins/datepicker/bootstrap-datepicker.js" type="text/javascript"></script>
  <!---------------------------------------------------->

    
  </body>
</html>
