<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>UBIHRM | Overtime Pay</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="<?php echo URL;?>public/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Font Awesome Icons -->
    <link href="<?php echo URL;?>public/font-awesome-4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo URL;?>public/plugins/datepicker/datepicker3.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="<?php echo URL;?>public/dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins 
         folder instead of downloading all of them to reduce the load. -->
    <link href="<?php echo URL;?>public/dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
	<link href="<?php echo URL;?>public/plugins/timepicker/bootstrap-timepicker.min.css" rel="stylesheet"/>
	<?php include(VIEWS_PATH."_templates/sidebar.php");?>

  </head>
 <body class="skin-green" ng-app="salaryapi">
  <?php $date = $_SESSION['ubihrm_dateformate1'];?>
    <!-- Site wrapper -->
    <div class="wrapper"  ng-controller="overtimepayCtrl" ng-init="overtimepayid=<?= $this->overtimepayid ?>;onfetchovertimepay(overtimepayid);">
      
      	<header>
		<?php echo topmenu(4);?>
	</header>

      <!-- =============================================== -->

      <!-- Left side column. contains the sidebar -->
      <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <?php echo sidemenu(4.44,4);?>
        <!-- /.sidebar -->
      </aside>

      <!-- =============================================== -->

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
            Salary            
          </h1>
          <ol class="breadcrumb">
            
            <li><a href="<?php echo URL;?>salary"><i class="fa fa-money"></i> Salary</a></li>
            <li><a href="<?php echo URL;?>salary/overtimepay"></i> Overtime Pay</a></li>
            <li class="active"><span ng-show="!overtimepayid">Add</span><span ng-show="overtimepayid && !val">Edit</span> <span ng-show="overtimepayid && val">View</span>   </li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">

          <!-- Default box -->
          <div class="box box-solid">
            	<div class="box-header with-border">
              		<h3 class="box-title"><span ng-show="!overtimepayid">Add</span><span ng-show="overtimepayid && !val">Edit</span> <span ng-show="overtimepayid && val">View</span>   </h3>
              		<div class="box-tools pull-right">
             		</div>
            	</div>
				<div class="box-body" ng-init="val=<?= $this->val ?>;">
					<form role="form" class="form-horizontal" name="myForm" novalidate >
						<div class='row' ng-show="!val && !overtimepayid" >
							<div class="col-sm-6">
								<div class="form-group">
									<label class="control-label col-sm-5" for="desig">Division</label>
									<div class="col-sm-6">
										<select class="form-control" id="division" name="division" ng-model="division" ng-options="c.id as c.name for c in divisionarray" ng-change="onfetchemployee()" >
										<option value="">All</option>
										</select>
									</div>
								</div>
							</div>
							<div class="col-sm-6" >
								<div class="form-group">
									<label class="control-label col-sm-5" for="dept">Department</label>
									<div class="col-sm-6">
										<select class="form-control" id="dept" name="dept" ng-model="dept" ng-options="c.id as c.name for c in departarray" ng-change="onfetchemployee()" >
										<option value="">All</option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row" ng-show="!val && !overtimepayid">
							
							<div class="col-sm-6">
								<div class="form-group">
									<label class="control-label col-sm-5" for="desig">Attendance month</label>
									<div class="col-sm-6" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.attendancemonth.$valid]">
									<input type="text" name="attendancemonth" class="form-control" ng-model="attendancemonth" placeholder="Date" data-provide="datepicker" data-date-autoclose="true"   id="attendancemonth" required ng-disabled="val"  ng-change="onfetchemployee()">
									</div>
								</div>
							</div>
							<div class="col-sm-6">
								<div class="form-group">
									<label class="control-label col-sm-5" for="desig">Salary month</label>
									<div class="col-sm-6" ng-class="{ true: 'has-success', false : 'has-error'  }[myForm.applydate.$valid]">
									<input type="text" name="applydate" class="form-control" ng-model="applydate" placeholder="Date" data-provide="datepicker" data-date-autoclose="true"   id="applymonth" required ng-disabled="val"  >
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							
							<div class="col-sm-6">
								<div class="form-group">
								</div>
							</div>	
						</div>
						<div class="row" ng-show="overtimearray.length>0">
								
								<div class="col-sm-3">
									<label class="control-label">Employee Name</label>
								</div>
								<div class="col-sm-2 " >
									<label class="control-label">Date</label>
								</div>
								<div class="col-sm-1p5 bootstrap-timepicker" >
									<label class="control-label">Overtime Hours</label>
								</div>
								<div class="col-sm-1 " >
									<label class="control-label">Hourly rate</label>
								</div>
								
								<div class="col-sm-1p5 ">
									<label class="control-label">Amount</label>
								</div>
								<div class="col-sm-2 ">
									<label class="control-label">Description</label>
								</div>
								<div class="col-sm-1">
									<label class="control-label">Action</label>
								</div>
								
								<hr>
						</div>
						
						<div class="row" ng-repeat="w in overtimearray">
								
								<div class="col-sm-3">
									<input type="text" class="form-control" placeholder="Employee Name" ng-model="w.name"  ng-disabled="overtimearray.length>0">
								</div>
								<div class="col-sm-2 " >
									<input type="text datepicker" class="form-control "  ng-model="w.applydate" data-provide="datepicker" data-date-autoclose="true" ng-disabled="val"data-date-format="<?php echo $_SESSION['ubihrm_dateformate1'];?>" readonly>
								</div>
								<div class="col-sm-1p5 bootstrap-timepicker">
									<input type="text" class="form-control timepicker "   ng-model="w.overtime" readonly >
								</div>								
								<div class="col-sm-1 " >
									<input type="text" class="form-control "  ng-model="w.hourlyrate" ng-disabled="val" ng-keyup="onchangerate(w.hourlyrate,$index)">
								</div>
								
								<div class="col-sm-1p5 " >
									<input type="text" class="form-control " placeholder="Amount" ng-model="w.amt" ng-disabled="val" >
								</div>
								<div class="col-sm-2 ">
									<input type="text" class="form-control" placeholder="Description"  ng-model="w.desc" ng-disabled="val">
									
								</div>
								<div class="col-sm-1">
									<button class="btn" ng-show="overtimearray.length>=1" data-toggle="tooltip" title="Remove" ng-click="removeovertime($index)" ng-disabled="val"><i class="fa fa-minus" ></i></button>
								</div>
								
								<hr>
						</div>
						<div class="row" ng-show="overtimearray.length==0">							
							<div class="col-sm-12">
								<div class="form-group">
									<label class="control-label col-sm-12 text-green" style="text-align:center" for="desig">No employee found for overtime.</label>
								</div>
							</div>	
						</div>
					</form>
				</div><!-- /.box-body -->
				<div class="overlay" ng-show="hastrue">
                  <i class="fa fa-refresh fa-spin"></i>
				</div>
				 <div class="box-footer text-center">
                    <button type="button" class="btn btn-primary"  ng-click="onupdate(1)" ng-disabled="myForm.$invalid || val " >Add</button>
					
					
					<button type="button" class="btn btn-primary" onclick="window.location = '<?php echo URL;?>salary/overtimepay'">Cancel</button>
             </div>
           <!-- /.box-footer-->
          </div><!-- /.box -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->

      <footer class="main-footer">
        <?php footertext();?>
      </footer>
    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.3 -->
    <script src="<?php echo URL;?>public/plugins/jQuery/jQuery-2.1.3.min.js"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="<?php echo URL;?>public/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
	<script src="<?php echo URL;?>public/angularjs/angular.min.js" type="text/javascript"></script>
	<script src="<?php echo URL;?>public/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
     <!-- SlimScroll -->
    <script src="<?php echo URL;?>public/plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
    <!-- FastClick -->
    <script src='<?php echo URL;?>public/plugins/fastclick/fastclick.min.js'></script>
	<script src="<?php echo URL;?>public/plugins/datepicker/bootstrap-datepicker.js" type="text/javascript"></script>
	
	<script src="<?php echo URL;?>public/angularjs/salary.js" type="text/javascript"></script>
  <!---------------------------------------------------->
<script>
	$("#applymonth").datepicker( {
		startView: "months", 
		minViewMode: "months",
		format: "MM yyyy",
		setDate:"yyyy-mm-dd"
	});
	$("#attendancemonth").datepicker( {
		startView: "months", 
		minViewMode: "months",
		format: "MM yyyy",
		setDate:"yyyy-mm-dd"
	});
	
	
</script>
    
  </body>
</html>
