<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>UBIHRM | Month Payroll</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="<?php echo URL;?>public/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Font Awesome Icons -->
    <link href="<?php echo URL;?>public/font-awesome-4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo URL;?>public/dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins 
         folder instead of downloading all of them to reduce the load. -->
    <link href="<?php echo URL;?>public/dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
	<?php include(VIEWS_PATH."_templates/sidebar.php");?>
    <!-- DATA TABLES -------->
	<!-- css for responsive -->
    <link rel="stylesheet" type="text/css" href="<?php echo URL;?>public/plugins/responsive/dataTables.responsive.css">
    <!------------------------>
	<link href="<?php echo URL;?>public/plugins/datepicker/datepicker3.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo URL;?>public/plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
	<link rel="stylesheet" type="text/css" href="<?php echo URL;?>public/plugins/table_pdf/semantic.min.css">
	
	<style>
	.datepicker{z-index:1151 !important}
	 [ng\:cloak],[ng-cloak],.ng-cloak{display:none !important}
	
	</style>
  </head>
  <body class="skin-green sidebar-collapse" >
    <!-- Site wrapper -->
    <div class="wrapper" >
      <?php 
		$salarydetails=$this->salarydetails['data'];
		$salaryheads=array();
		if(count($salarydetails)>0)
		$salaryheads=$salarydetails[0]['salarydetail'];
		
      ?>
      <!-- =============================================== -->

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
       

        <!-- Main content -->
        <section class="content">

          <!-- Default box -->
          <div class="box box-solid" >
            <div class="box-header with-border">
              <h3 class="box-title">Month Payroll</h3>
              <div class="box-tools pull-right">
               <!-- <button class="btn btn-box-tool" data-widget="refresh" id="refresh_" data-toggle="tooltip" title="Refresh"><i class="fa fa-refresh"></i></button>
				<button class="btn btn-box-tool" data-toggle="tooltip" title="Help"><i class="fa fa-question"></i></button>-->
			  </div>
            </div>
            <div class="box-body" >
			
			<div >
               <table id="datatable1" class="table table-bordered">
					
					<tr>
						<td ><img src="<?= $this->salarydetails['companylogo'];?>"/></td>
						<th colspan="<?=count($salaryheads);?>" class="text-center"><h3><?= $this->salarydetails['companyname'];?><br>
						Payroll details for the month of <?= $this->salarydetails['salarymonth'];?></h3>
						</th>
						<td  class="text-right">Date: <?= $this->salarydetails['currentdate'];?></td>
					</tr>
				</table>
				<label class="text-green text-right col-sm-12">*Note - Scroll right to see all values.</label>
				<label class="text-green text-right col-sm-12">  Currency of amount is <?=Utils::getcurrency();?></label>
				<table id="datatable" class="table table-bordered">
				<thead>
					<tr>
                        <td>Employee Name</td>
						<td>Division</td>
						<td>Salary Month</td>
						<td>Gross salary</td>
						<td>Payable days</td>
						<?php 
							
							for($i=0;$i<count($salaryheads);$i++)
							{
								echo "<td>".$salaryheads[$i]['name']."</td>";
							}

						?>
						
						<td>Total Earnings</td>
						<td>Total Deductions</td>
						<td>Net Payable</td>
					  </tr>
					</thead> 
				<tbody>
					<?php 
						for($i=0;$i<count($salarydetails);$i++)
						{
							echo "<tr><td>".$salarydetails[$i]['name']."</td>
									  <td>".$salarydetails[$i]['empdivision']."</td>
									  <td>".$salarydetails[$i]['empmonthname']."</td>
									  <td>".$salarydetails[$i]['empctc']."</td>
									  <td>".$salarydetails[$i]['emppaiddays']."</td>";
									  
							for($j=0;$j<count($salarydetails[$i]['salarydetail']);$j++)
							{
								echo "<td>".$salarydetails[$i]['salarydetail'][$j]['amount']."</td>";
							}
							echo"<td>".$salarydetails[$i]['emptotal']."</td>
								<td>".$salarydetails[$i]['emptotaldeduction']."</td>
								<td>".$salarydetails[$i]['netpay']."</td></tr>";
								
						}
					?>
					 
					</tbody>
                  </table>
				  
				  <table id="datatable2" class="table table-bordered hide">
				
					<tr>
                        <td><b>Employee Name</b></td>
						<td><b>Division</b></td>
						<td><b>Salary Month</b></td>
						<td><b>Gross salary</b></td>
						<td><b>Payable days</b></td>
						<?php 
							
							for($i=0;$i<count($salaryheads);$i++)
							{
								echo "<td><b>".$salaryheads[$i]['name']."</b></td>";
							}

						?>
						
						<td><b>Total Earnings</b></td>
						<td><b>Total Deductions</b></td>
						<td><b>Net Payable</b></td>
					  </tr>
					
				
					<?php 
						for($i=0;$i<count($salarydetails);$i++)
						{
							echo "<tr><td>".$salarydetails[$i]['name']."</td>
									  <td>".$salarydetails[$i]['empdivision']."</td>
									  <td>".$salarydetails[$i]['empmonthname']."</td>
									  <td>".$salarydetails[$i]['empctc']."</td>
									  <td>".$salarydetails[$i]['emppaiddays']."</td>";
									  
							for($j=0;$j<count($salarydetails[$i]['salarydetail']);$j++)
							{
								echo "<td>".$salarydetails[$i]['salarydetail'][$j]['amount']."</td>";
							}
							echo"<td>".$salarydetails[$i]['emptotal']."</td>
								<td>".$salarydetails[$i]['emptotaldeduction']."</td>
								<td>".$salarydetails[$i]['netpay']."</td></tr>";
								
						}
					?>
					 
					
                  </table>
				  
				 
				 </div> 
                </div><!-- /.box-body -->
				<div class="overlay" id="refresh">
                  <i class="fa fa-refresh fa-spin"></i>
                </div>
				<div class="box-footer text-center">
                  <a download="Monthly_Payroll_<?= $this->salarydetails['salarymonth'];?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'datatable2', 'Monthly Report');" class="btn btn-primary">Export to Excel</a>
                </div>
				
              </div><!-- /.box -->
           
        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->

      <footer class="main-footer">
        <?php footertext();?>
      </footer>
    </div><!-- ./wrapper -->
	
	
   <script type="text/javascript" src="<?php echo URL;?>public/plugins/responsive/jquery-1.11.1.min.js"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="<?php echo URL;?>public/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
   <!-- DATA TABES SCRIPT -->
   
    <!-- DATA TABES SCRIPT -->
   	
    <!-- SlimScroll -->
    <script src="<?php echo URL;?>public/plugins/slimScroll/jquery.slimScroll.min.js" type="text/javascript"></script>
	
	<script src="<?php echo URL;?>public/plugins/datepicker/bootstrap-datepicker.js" type="text/javascript"></script>
    <!-- FastClick -->
    <script src='<?php echo URL;?>public/plugins/fastclick/fastclick.min.js'></script>
	<script type="text/javascript" src="<?php echo URL;?>public/plugins/responsive/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="<?php echo URL;?>public/plugins/responsive/dataTables.responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo URL;?>public/plugins/responsive/dataTables.bootstrap.js"></script>
 <script src='<?php echo URL;?>public/plugins/table_pdf/excellentexport.js'></script>
  <!---------------------------------------------------->

 <script type="text/javascript">
    
     $(function(){
	//demo.remove();
	$("#refresh").show();
		var table1 = $('#datatable').DataTable({
				scrollY:        "400px", 
				scrollX:        true, searching:false,
				scrollCollapse: true, ordering:false,
				paging:         false,
				"columnDefs": [
					{ "visible": false, "targets": 1 }
				],
				"drawCallback": function ( settings ) {
					var api = this.api();
					var rows = api.rows( {page:'current'} ).nodes();
					var last=null;
		 
					api.column(1, {page:'current'} ).data().each( function ( group, i ) {
						if ( last !== group ) {
							$(rows).eq( i ).before(
								'<tr class="group"><td bgcolor="#6FFCDE" colspan="'+<?=count($salaryheads)+7;?>+'"><b>'+group+'</b></td></tr>'
							);
							last = group;
						}
					} );
				}
				
								
		});
		$("#refresh").hide();
	});
     
    
	$('body').tooltip({
		selector: '[rel=tooltip]'
	});	
	</script>
  </body>
</html>
