<?php

/**
 * RoleModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class UserprofileModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM Userprofile WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->UserName;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=PERMISSION_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
   
	public function getDetail($id, $orgid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$res1 = array();
		//$res1['rolename'] = $id;
		//$data[] = $res1;
		
        $sql = "SELECT * FROM UserProfile_permission WHERE Userprofileid = :id AND OrganizationId= :orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id, ':orgid' => $orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			//$res1 = array();
			//$res1['rolename'] = $id;
			//$data[] = $res1;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['rolename'] = $row->Userprofileid;
				$res['profilename'] = $this->getRoleName($row->Userprofileid);
				$res['modulename'] = $row->ModuleId;
				
				$res['name'] = $this->getModuleName($row->ModuleId, 'ModuleName');
				$res['label'] = $this->getModuleName($row->ModuleId, 'ModuleLabel');
				$res['vsts'] = (int)$row->ViewPermission;
				$res['ests'] = (int)$row->EditPermission;
				$res['dsts'] = (int)$row->DeletePermission;
				$res['asts'] = (int)$row->AddPermission;
				
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = PERMISSION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=PERMISSION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    
    public function getEmployee($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		
        $sql = "SELECT Id, CONCAT(FirstName, ' ', LastName) AS Name, EmployeeCode FROM EmployeeMaster WHERE OrganizationId = :id and Is_Delete=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			$res = array();
			$res['id'] = 0;
			$res['name'] = 'Select';
			$res['ecode'] ='';
			$data[] = $res;
			
			while($row = $query->fetch())
			{
				//$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['ecode'] = $row->EmployeeCode;
				
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function getRole($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		
        $sql = "SELECT * FROM RoleMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			$res = array();
			$res['id'] = 0;
			$res['name'] = 'Select';
			$data[] = $res;
			
			while($row = $query->fetch())
			{
				//$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=ROLE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    
    
    public function getModules()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $data1 = array();
		//$orgid = $request;
		$orgid=$_SESSION['ubihrm_org_id'];
       // $sql = "SELECT * FROM ModuleMaster where TabId<>0 and ModuleSts=1 order by SortOnTab";
	   ////////////this code belongs to found out modules according to organization package//////////////
        $sql = "SELECT *,m.id as moduleid FROM ModuleMaster m,OrgPermission o where m.id=o.ModuleId and m.TabId=o.TabId and OrgId=? and  m.TabId<>0 and ModuleSts=1 and ViewPermission=1 order by SortOnTab";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			//$res = array();
			//$res['id'] = 0;
			//$res['sts'] = false;
			//$data[] = $res;
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->moduleid;
				$res['tabid'] = $row->TabId;
				$res['tabname'] = ($row->TabId==1)?"Employee":(($row->TabId==2)?"Attendance":(($row->TabId==3)?"Leave":(($row->TabId==4)?"Salary":($row->TabId==5)?"Organization":($row->TabId==6)?"Performance":"Timesheet")));
				$res['name'] = $row->ModuleName;
				if($row->SubModule==""){
					$res['label'] = $row->ModuleLabel;
				}else{
					$res['label'] =$row->SubModule.' - '.$row->ModuleLabel;
				}
				$res['vsts'] = false;
				$res['ests'] = false;
				$res['asts'] = false;
				$res['dsts'] = false;
				
				$data[] = $res;
			}
			/////////find out the permitted tabs according to organization id////
			$sql = "SELECT *,m.id as moduleid FROM ModuleMaster m,OrgPermission o where m.id=o.ModuleId and m.TabId=o.TabId and OrgId=? and  m.TabId<>0 and ModuleSts=1 and ViewPermission=1 group by m.TabId";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->moduleid;
				$res['tabid'] = $row->TabId;
				$tabname="";
				if($row->TabId==1)
					$tabname="Employee";
				elseif($row->TabId==2)
					$tabname="Attendance";
				elseif($row->TabId==3)
					$tabname="Leave";
				elseif($row->TabId==4)
					$tabname="Salary";
				elseif($row->TabId==5)
					$tabname="Organization";
				elseif($row->TabId==6)
					$tabname="Performance";	
				else
					$tabname="Timesheet";		
				$res['tabname'] = $tabname;
				$res['name'] = strtolower($tabname);
				$data1[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=ROLE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["tabs"] =$data1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    public function getReportingModules($tabid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$con=" ";
		//$orgid = $request;
		if($tabid == 5){
			$con=" ";
		}
		else{
			$con="OR ModuleCode = 19";
		}
        $sql = "SELECT * FROM ModuleMaster where ReportSts=1 AND TabId = ? $con order by ModuleLabel";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($tabid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->ModuleName;
				$res['label'] = $row->ModuleLabel;
				
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=ROLE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    /**
     * Setter for a RoleMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$res = json_decode($request[2], true);
		$sql="update Userprofile set UserName=? , LastModifiedDate=?, 	LastModifiedById=? where Id=? ";
		$query=$this->db->prepare($sql);
		$query->execute(array($request[3],$mdate,$mid,$request[4]));
		$count=$query->rowCount();
		if($count==1){
			$sql1 = "DELETE FROM UserProfile_permission WHERE Userprofileid = ? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($request[4], $orgid));
			for($i=0; $i<count($res); $i++) {		
				$sql = "INSERT INTO UserProfile_permission (Userprofileid, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array($request[4], $res[$i]['id'], $res[$i]['vsts'], $res[$i]['ests'], $res[$i]['dsts'], $res[$i]['asts'], $orgid, $mdate, $mid, $mdate, $mid ));
					$count =  $query->rowCount();		
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			$msg="User Permission has been updated";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "User Permission", $msg, $orgid));
			$status =true;
			$successMsg = PERMISSION_MODULE_UPDATION_SUCCESS;
		}else {
			$status =false;
			$errorMsg=PERMISSION_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function Update1($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$res = json_decode($request[2], true);
		for($i=0; $i<count($res); $i++) {		
			$sql1 = "SELECT * FROM UserPermission WHERE RoleId = ? AND ModuleId=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array(Utils::decode5t($request[3]), $res[$i]['id'], $orgid));
				$count1 =  $query1->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count1>=1) {
				$sql = "UPDATE UserPermission SET ViewPermission=?, EditPermission=?, DeletePermission=?, AddPermission=?,  OrganizationId=?, LastModifiedDate=?, LastModifiedById=? WHERE RoleId=? AND ModuleId=? and OrganizationId=?";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array($res[$i]['vsts'], $res[$i]['ests'], $res[$i]['dsts'], $res[$i]['asts'], $orgid, $mdate, $mid, Utils::decode5t($request[3]), $res[$i]['id'], $orgid));			
					$count =  $query->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}else{
				$sql = "INSERT INTO UserPermission (RoleId, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array(Utils::decode5t($request[3]), $res[$i]['id'], $res[$i]['vsts'], $res[$i]['ests'], $res[$i]['dsts'], $res[$i]['asts'], $orgid, $mdate, $mid, $mdate, $mid, $mid ));
					$count =  $query->rowCount();		
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
		}
		if ($count >= 1) {
			//$empid=Utils::getName($did,'EmployeeIncentive','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="user Permission has been Updated";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "User Permission", $msg, $orgid));
			$status =true;
			$successMsg = PERMISSION_MODULE_UPDATION_SUCCESS;
		} else {
			$status =false;
			$errorMsg=PERMISSION_MODULE_UPDATION_FAILED;
		}
		//}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		 // default return
        return $result;
    }

   
    /**
     * Setter for a RoleMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
        $mdate = date("Y-m-d H:i:s");
		$res  = json_decode($request[2],true);
		$sql1 = "SELECT * FROM Userprofile WHERE UserName =? and OrganizationId= ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[3], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1) {
			$status =false;
			$errorMsg=PERMISSION_MODULE_CREATION_DUPLICATE;
		}else{
			$sql="insert into Userprofile(UserName, CreatedDate, CreatedById, OrganizationId)value(?,?,?,?)";
			$query= $this->db->prepare($sql);
			$query->execute(array($request[3],$mdate,$mid,$orgid));
			$count=$query->rowCount();
			$userprofileid=$this->db->lastInsertId();
			if($count>=1){
				foreach($res as $value){
					if($value['id']!=""){
						$sql = "INSERT INTO UserProfile_permission (Userprofileid, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,CreatedDate, CreatedById) VALUES (?,?,?,?,?,?,?,?,?)";
						try{
							$query = $this->db->prepare($sql);
							$query->execute(array($userprofileid, $value['id'],$value['vsts'], $value['ests'],$value['dsts'],$value['asts'], $orgid, $mdate, $mid));
							$count =  $query->rowCount();		
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					}
				}
				$msg="User Permission has been created ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "User Permission", $msg, $orgid));
				$status =true;
				$successMsg = PERMISSION_MODULE_CREATION_SUCCESS;
			}else {
				 $status =false;
				 $errorMsg=PERMISSION_MODULE_CREATION_FAILED;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		/*$sql1 = "SELECT * FROM UserMaster WHERE ParentRoleId = :id";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=USER_MODULE_DELETE_EXIST;
		}else{*/
		$sql = "DELETE FROM UserPermission WHERE Id = :id ";		
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			//$empid=Utils::getName($did,'EmployeeIncentive','EmployeeId',$this->db);
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="User Permission has been deleted";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "User Permission", $msg, $orgid));
			$status =true;
			$successMsg = PERMISSION_MODULE_DELETE_SUCCESS;
		}else {
			$status =false;
			$errorMsg=PERMISSION_MODULE_DELETE_FAILED;
		}
		//}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
    }
	
	public function getEmpName($id)
	{
		$name ="-";
		$sql = "SELECT CONCAT(FirstName,' ',LastName) AS Name FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getRoleName($id)
	{
		$name ="-";
		$sql = "SELECT * FROM Userprofile WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->UserName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getModuleName($id, $column)
	{
		$name ="-";
		$sql = "SELECT $column FROM ModuleMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getSelfservicemodules()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        $sql = "SELECT *,m.id as moduleid FROM ModuleMaster m,OrgPermission o where m.id=o.ModuleId and m.TabId=o.TabId and OrgId=? and  m.TabId<>0 and ModuleSts=1 and ViewPermission=1 and m.Id in (5, 446, 445, 185,  18, 66, 40, 292,  179,  71, 51, 139,  170, 191, 309, 253,184,223, 54,  126, 187) order by ModuleLabel asc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			//$res1 = array();
			//$res1['rolename'] = $id;
			//$data[] = $res1;
			
			while($row = $query->fetch())
			{
				$res = array();
				
				$res['modulename'] = $row->moduleid;
				
				
				$res['vsts'] = true;
				$res['ests'] = true;
				$res['dsts'] = true;
				$res['asts'] = true;
				
				$data[] = $res;
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = PERMISSION_MODULE_GETDETAIL_SUCCESS;
        } else {
			$sql = "SELECT * FROM Userprofile WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $id));
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['rolename'] = $row->UserName;
				$res['profilename'] = $row->UserName;
				$res['profiledesc'] = $row->Description;
				$res['profilests'] = $row->AdminSts;
				$data[] = $res;
			}	
           $status =true;
		   $errorMsg=PERMISSION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'Userprofile';
		$sIndexColumn = "Id";
		$aColumns = array('UserName' , 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'setup/editUserProfile/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					/*if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" data-href="'.URL.'setup/deleterelatedlist/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}		*/		
					
					$row[] =$edit;
				}
		/*		else if($aColumns[$i]=="RoleId")
				{
					$row[] = self::getRoleName($aRow->{$aColumns[$i]});
					
				} else if($aColumns[$i]=="HRSts")
				{
					if($aRow->{$aColumns[$i]}==1){
						$row[]=	"<span class='badge bg-red'>YES</span>";
					}
					else{
						$sts=$_SESSION['ubihrm_user_sts'];
						if($sts==1){
							$row[]=	'<a rel="tooltip"  title="Change to HR" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirmhr" href="#" ><span class="badge bg-aqua">NO</span></a>';
						}
						else{
							$row[]=	"<span class='badge bg-aqua'>NO</span>";
						}
					
					
					}
				} */else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
