<?php

/**
 * RoleModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class UserModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM UserMaster WHERE OrganizationId = ? and Id != ?";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid, $request[2]));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['parentid'] = $row->ParentRoleId;
				$res['desc'] = $row->Description;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=USER_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    //////////////////
    
    public function getAll1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM UserMaster WHERE OrganizationId = ?";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeename'] = $row->EmployeeId;
				$res['password'] = $row->Password;
				$res['username'] = Utils::decode5t($row->Username);
				$res['rolename'] = $row->RoleId;
				//$res['desc'] = $row->Description;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=USER_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
    
    //////////////////

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM UserMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['employeename'] = $row->EmployeeId;
				$res['profilename'] = $row->userprofile;
				$res['username'] = Utils::decode5t($row->Username);
				$res['usermob'] = Utils::decode5t($row->username_mobile);
				$res['password'] = Utils::decode5t( $row->Password);
				$res['adminsts'] = $row->AdminSts;
				$res['hrsts'] = $row->HRSts;
				$data[] = $res;
			}
        }
		if ($count == 1) {
           $status =true;
		   $successMsg = USER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=USER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
    
    
    public function getEmployee($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql ="";
		$userid = $_SESSION['ubihrm_user_id'];
		
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts==1){
			$sql = "SELECT Id, CONCAT(FirstName, ' ', LastName) AS Name, EmployeeCode, CompanyEmail, Designation, CurrentContactNumber FROM EmployeeMaster WHERE OrganizationId = :id and Is_Delete=0 order by FirstName, MiddleName, LastName";
		}else{
			$ids =Utils::getReportingIds($userid, $this->db);
			$sql = "SELECT Id, CONCAT(FirstName, ' ', LastName) AS Name, EmployeeCode, CompanyEmail, Designation, CurrentContactNumber FROM EmployeeMaster WHERE OrganizationId = :id and Id in ($ids) or Id = $userid and Is_Delete=0 order by FirstName, MiddleName, LastName";
		}
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				//$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".$row->Name;
				$res['ecode'] = $row->EmployeeCode;
				$res['companyemail'] = Utils::decode5t($row->CompanyEmail);
				$res['mobile_no'] = Utils::decode5t($row->CurrentContactNumber);
				$res['rolename'] = (int)$row->Designation;
				//$role =$this->getrole1( $desig);
				//$res['rolename'] = $role;
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function getRole($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		
        $sql = "SELECT * FROM RoleMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			$res = array();
			$res['id'] = 0;
			$res['name'] = 'Select';
			$data[] = $res;
			
			while($row = $query->fetch())
			{
				//$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }
		
	else {
           $status =false;
		   $errorMsg=EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a RoleMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION["ubihrm_org_id"];
        $sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$mdate = date("Y-m-d H:i:s");
		$where="";
		$userid=Utils::decode5t($request[6]);
		$mobile=Utils::encode5t($request[9]);
		$username= Utils::encode5t($request[4]);
		$sql1 = "SELECT * FROM UserMaster WHERE Id != ? AND (username_mobile=? or Username =? ) and (Username <>'' and username_mobile <>'')";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($userid,$mobile,$username));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=USER_MODULE_UPDATION_DUPLICATE;
		}else{
			if($sts==1 || $hrsts==1){
				$nosts =$this->noorgAdmin($orgid);
				$nouser = $this->nouserAdmin($orgid,$request[3],$userid);
				$changeadmin=$request[7];
				$changehr=$request[8];
				/* $sql = "Select AdminSts, userprofile from UserMaster WHERE OrganizationId =? and Id = ?";
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid, Utils::decode5t($request[6])));
				while($row = $query->fetch())
				{
					$admin=$row->AdminSts;
					$rid = $row->userprofile;
				} */
				
				/* if(($nouser>1 && $admin==1 && $request[7]==0) || $nouser<$nosts && $admin==0 && $request[7]==1){
					//$where=", AdminSts=$changeadmin";
				} */
				
				///////// IF ADMIN PROFILE ASSIGNED THEN, USER STATUS WILL CHANGE ACCORDINGLY///////////
				
				$profilests= Utils::getName($request[3],'Userprofile','AdminSts',$this->db);
				if($profilests == 1 && $nouser>=$nosts)
				{
					$result["data"] =$data;
					$result['status']=false;
					$result['successMsg']=$successMsg;
					$result['errorMsg']="You can not assign Admin profile to more than $nosts users.";
					
					// default return
					return $result;
				}
				$where=", AdminSts=0";
				if($profilests == 1 && $nouser<$nosts)
				{
					$where=", AdminSts=1";
				}
				if($request[8]==0){
					$where.=", HRSts=$changehr";
				}
			}
			$sql = "UPDATE UserMaster SET  Password=?, userprofile=?, Username=?,  LastModifiedDate=?, LastModifiedById=? ,username_mobile=? $where WHERE Id=?";
		
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array(Utils::encode5t( $request[5]), $request[3], Utils::encode5t(strtolower($request[4])), $mdate, $mid,Utils::encode5t($request[9]), Utils::decode5t($request[6]) ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				/* if($request[7]==1){
					$this->updatePermission($request[3], $request[7]);	
				} */	
				
				if($sts==1 || $hrsts==1){
				if($request[8]==1){
					$this->changeHR(Utils::decode5t($request[6]));
				}
				}
				//$empid=Utils::getName($did,'EmployeeLeave','EmployeeId',$this->db);
                $empname=Utils::getEmployeeName($request[2],$this->db);
				$msg="Profile of <b>$empname</b> has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Organization User", $msg, $orgid));
			   $status =true;
			   $successMsg = USER_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=USER_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
   
    /**
     * Setter for a RoleMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$mdate = date("Y-m-d H:i:s");
		$orgid= $_SESSION["ubihrm_org_id"];
		$sql1 = "SELECT * FROM UserMaster WHERE (EmployeeId=? or Username = ? or username_mobile = ?) and (Username <>'' or username_mobile <>'')";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],  Utils::encode5t($request[4]) , Utils::encode5t($request[8])));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status   = false;
			$errorMsg = USER_MODULE_CREATION_DUPLICATE;
		}else{
			/*check whetther user can make admin and hr or not according to their admin and hr status*/
			if($sts==1 || $hrsts==1 ){
				
			$nosts =$this->noorgAdmin($orgid);
			$nouser = $this->nouserAdmin($orgid);
			if($nouser>=$nosts && $request[6]==1){
				$request[6]=0;
			}
			$sql = "INSERT INTO UserMaster (EmployeeId, Password, Username,userprofile,  OrganizationId,AdminSts,  HRSts,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,username_mobile) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], Utils::encode5t( $request[5]), Utils::encode5t(strtolower($request[4])),$request[3],  $orgid,$request[6],0, $mdate, $mid, $mdate, $mid, $mid ,Utils::encode5t($request[8])));
				$id = $this->db->lastInsertId();
				$count =  $query->rowCount();	
				if($count>=1){
					if($sts==1 || $hrsts==1 ){
						if($request[7]==1){
							$this->changeHR($id);
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			}
			else{
				$sql = "INSERT INTO UserMaster (EmployeeId, Password, Username,userprofile,  OrganizationId,LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?,?,?,?,?,?,?,?,?,?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], Utils::encode5t( $request[5]), Utils::encode5t(strtolower($request[4])),$request[3],  $orgid, $mdate, $mid, $mdate, $mid, $mid ));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			}
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'EmployeeLeave','EmployeeId',$this->db);
                $empname=Utils::getEmployeeName($request[2],$this->db);
				$msg="<b>$empname</b> has been added as User ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Organization User", $msg, $orgid));
			   $status =true;
			   $successMsg = USER_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=USER_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	
	public function CreateAll($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		try{
			$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId=? and  DOL='0000-00-00' and Is_Delete=0";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid));
			while($row1=$query1->fetch()){
			
				if($row1->CompanyEmail != '' || $row1->CurrentContactNumber != ''){
					$sql2 = "SELECT * FROM UserMaster WHERE ( Username = ? or username_mobile = ?) and (Username <>'' or username_mobile <>'')";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($row1->CompanyEmail,$row1->CurrentContactNumber));
					$count1 =  $query2->rowCount();
					if($count1>=1)
					{
						/* $row=$query2->fetch();	
						$sql = "UPDATE UserMaster SET   Username=?, RoleId=? ,username_mobile=? WHERE Id=?";
						$query = $this->db->prepare($sql);
						$query->execute(array( $row1->CompanyEmail, $row1->Designation,$row1->CurrentContactNumber,   $row->Id )); */
						
						$sql = "UPDATE EmployeeMaster SET PersonalNo=? WHERE Id=?";
						$query = $this->db->prepare($sql);
						$query->execute(array( $row1->CurrentContactNumber,  $row1->Id)); 
					}else{
						$sql = "INSERT INTO UserMaster (EmployeeId, Password, Username,RoleId,  OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, username_mobile) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
						
						$query = $this->db->prepare($sql);
						$query->execute(array($row1->Id, Utils::encode5t( 'ubipass'), $row1->CompanyEmail,$row1->Designation,  $orgid, $mdate, $mid, $mdate, $mid, $mid ,$row1->CurrentContactNumber ));
					
						$count =  $query->rowCount();		
						
						
						if ($count == 1) {
							//$empid=Utils::getName($did,'EmployeeLeave','EmployeeId',$this->db);
							$empname=Utils::getEmployeeName($row1->Id,$this->db);
							$msg="<b>$empname</b> has been added as User ";
							$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($mid, "Organization User", $msg, $orgid));
						   $status =true;
						   $successMsg = USER_MODULE_CREATION_SUCCESS;
						} else {
						   $status =false;
						   $errorMsg=USER_MODULE_CREATION_FAILED;
						}
					}
				}	
			}	
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
			
			$sql = "DELETE FROM UserMaster WHERE Id = :id ";		
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			$mid = $_SESSION['ubihrm_user_id'];
			$orgid = $_SESSION['ubihrm_org_id'];
			if ($count == 1) {
				$empid=Utils::getName($did,'UserMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="A User of $empname has been deleted";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "User Model", $msg, $orgid));
			   $status =true;
			   $successMsg = USER_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=USER_MODULE_DELETE_FAILED;
			}
		//}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getEmpName($id)
	{
		$name ="-";
		$sql = "SELECT FirstName, LastName FROM EmployeeMaster WHERE Id = :id and Is_Delete=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function noorgAdmin($orgid)
	{
		$no_admin ="-";
		$sql = "SELECT no_admin FROM Organization WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$row = $query->fetch();
			$no_admin =$row->no_admin;
			
		}catch(Exception $e) {
			
		}
		return $no_admin;
	}
	public function nouserAdmin($orgid)
	{
		$no_admin ="-";
		$sql = "SELECT count(AdminSts) as Admin FROM UserMaster WHERE OrganizationId = :id and AdminSts=1;";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$row = $query->fetch();
			$no_admin =$row->Admin;
			
		}catch(Exception $e) {
			
		}
		return $no_admin;
	}
	public function getRoleName($id)
	{
		$name ="-";
		$sql = "SELECT * FROM DesignationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getrole1($id)
	{
		$name ="-";
		$sql = "SELECT * FROM DesignationMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->RoleId;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'UserMaster';
		$sIndexColumn = "Id";
		$aColumns = array('EmployeeId' , 'userprofile', 'Username','username_mobile','HRSts','VisibleSts', 'Id');
		$userid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$ids =Utils::getReportingIds($userid, $this->db);
		
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
		$sWhere = " WHERE  OrganizationId= $orgid AND EmployeeId in ($ids) and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="userprofile"){
					$sWhere .= " (userprofile in ( select Id from Userprofile where UserName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}elseif($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a data-toggle="tooltip" title="Edit" rel="tooltip" href="'.URL.'setup/edituser/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper ){
						$delete ='<a onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" rel="tooltip" title="Delete"><i class="fa fa-trash" rel="tooltip"></i></a>';
					}else{
						$delete = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="VisibleSts")
				{
						if($aRow->{$aColumns[$i]}==1){
							
							if($sts==1){
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirmsts' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-aqua'>Active</span></a>";
							}
							else{
								$row[]="<span class='badge bg-aqua'>Active</span>";
							}
						}
						else{
							if($sts==1)
							{
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirmsts' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-red'>Inactive</span></a>";
							}
							else
							{
								$row[]="<span class='badge bg-red'>Inactive</span>";
							}
						}
					
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = '<a href="'.URL.'setup/viewuser/'.Utils::encode5t($aRow->Id).'/1">'.self::getEmpName($aRow->{$aColumns[$i]}).'</a>';
				}
					else if($aColumns[$i]=="userprofile")
				{
					$row[] = self::getProfileName($aRow->{$aColumns[$i]}); 
				}
				else if($aColumns[$i]=="Password")
				{
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="Username" || $aColumns[$i]=="username_mobile")
				{
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
				}
				
				// else if($aColumns[$i]=="AdminSts")
				// {
					// $nosts =$this->noorgAdmin($orgid);
					// $nouser = $this->nouserAdmin($orgid);
					
					// if($aRow->{$aColumns[$i]}==1){
							
							// if($sts==1){
								// $row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-red'>SuperAdmin</span></a>";
							// }else{
								// $row[]=	"<span class='badge bg-red'>SuperAdmin</span>";
							// }
						// }
						// else{
							// if($sts==1){
							 // if($nosts!=$nouser){
								// $row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-aqua'>User</span></a>";
								// }
								// else{
								// $row[]=	"<a rel='tooltip' title='Change Status'  href='#' onclick=\"angular.element(this).scope().getadminvalue('".$nosts."')\" ><span class='badge bg-aqua'>User</span></a>";
							// }
							// }else{
								// $row[]=	"<span class='badge bg-aqua'>User</span>";
							// }
						// }
					
				// }
				else if($aColumns[$i]=="HRSts")
				{
					if($aRow->{$aColumns[$i]}==1){
						$row[]=	"<span class='badge bg-red'>YES</span>";
					}
					else{
						if($sts==1 || $hrsts==1){
							$row[]=	'<a rel="tooltip"  title="Change to HR" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirmhr" href="#" ><span class="badge bg-aqua">NO</span></a>';
						}
						else{
							$row[]=	"<span class='badge bg-aqua'>NO</span>";
						}
					}
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getProfileName($id)
	{
		$name ="-";
		$sql = "SELECT * FROM Userprofile WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->UserName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getDataTable1($editper, $deleteper)
	{
		$sTable = 'UserMaster';
		$sIndexColumn = "Id";
		$aColumns = array('EmployeeId' , 'RoleId', 'Username','Password' ,'username_mobile', 'VisibleSts', 'Id');
		//$userid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$sWhere = "";
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = " WHERE OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="RoleId"){
					$sWhere .= " (RoleId in ( select Id from DesignationMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				elseif($aColumns[$i]=="UserName"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		 $sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0; $sts=1;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a data-toggle="tooltip" title="Edit" rel="tooltip" href="'.URL.'setup/edituser/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper && ($aRow->VisibleSts==0)){
						$delete ='<a onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" rel="tooltip" title="Delete"><i class="fa fa-trash" rel="tooltip"></i></a>';
					}else{
						$delete = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] ="";  ///$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = '<a href="'.URL.'setup/viewuser/'.Utils::encode5t($aRow->Id).'/1">'.self::getEmpName($aRow->{$aColumns[$i]}).'</a>';
					
				}
				else if($aColumns[$i]=="RoleId")
				{
					$row[] = self::getRoleName($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="Password" || $aColumns[$i]=="Username" || $aColumns[$i]=="username_mobile")
				{
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
					
				}
				
				else if($aColumns[$i]=="VisibleSts")
				{
						if($aRow->{$aColumns[$i]}==1){
							
							if($sts==1){
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-red'>YES</span></a>";
							}else{
								$row[]=	"<span class='badge bg-red'>YES</span>";
							}
						}
						else{
							if($sts==1){
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><span class='badge bg-aqua'>NO</span></a>";
							}else{
								$row[]=	"<span class='badge bg-aqua'>NO</span>";
							}
						}
					
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getDataTable12($editper, $deleteper)
	{
		$sTable = 'UserMaster';
		$sIndexColumn = "Id";
		$aColumns = array('EmployeeId' , 'RoleId', 'Username','Password' ,'username_mobile', 'VisibleSts', 'OrganizationId');
		//$userid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$sWhere = "";
		$orgid=$_SESSION['ubihrm_org_id'];
		
		//$sWhere = " WHERE OrganizationId= $orgid  ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " where (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="RoleId"){
					$sWhere .= " (RoleId in ( select Id from DesignationMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				elseif($aColumns[$i]=="UserName"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		 $sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0; $sts=1;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a data-toggle="tooltip" title="Edit" rel="tooltip" href="'.URL.'setup/edituser/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper && ($aRow->VisibleSts==0)){
						$delete ='<a onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" rel="tooltip" title="Delete"><i class="fa fa-trash" rel="tooltip"></i></a>';
					}else{
						$delete = '<a href="#" data-toggle="tooltip" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] ="";  ///$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = self::getEmpName($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="RoleId")
				{
					$row[] = self::getRoleName($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="OrganizationId")
				{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'Organization','Name',$this->db);
				}
				else if($aColumns[$i]=="Password" || $aColumns[$i]=="Username" || $aColumns[$i]=="username_mobile")
				{
					$row[] = Utils::decode5t($aRow->{$aColumns[$i]});
					
				}
				
				else if($aColumns[$i]=="VisibleSts")
				{
						if($aRow->{$aColumns[$i]}==1){
							
							$row[]=	"<span class='badge bg-red'>YES</span>";
						}
						else{
							$row[]=	"<span class='badge bg-aqua'>NO</span>";
						}
					
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function AddUserStatus($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		$admin=0; $rid=0;
		$sql1 = "select AdminSts from UserMaster WHERE OrganizationId =? and AdminSts=1";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($request[0]));
		
		$sql = "select AdminSts, RoleId from UserMaster WHERE OrganizationId =? and Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[0], $request[1] ));
			while($row = $query->fetch())
			{
				$admin=$row->AdminSts;
				$rid = $row->RoleId;
			}
			
		if($query1->rowCount()==1 && $admin==1)
		{
			$status =false;
			$errorMsg="There must be atleast one admin user for an organisation.";
		}else{	
			$admin = ($admin==0) ? 1 : 0 ;
			$sql = "UPDATE UserMaster SET AdminSts = ? WHERE  Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $admin,$request[1] ));
			$count = $query->rowCount();
			/*if($count>0)
			{
				$sql = "UPDATE UserMaster SET AdminSts = ? WHERE OrganizationId =? AND Id <> ?";
				$query = $this->db->prepare($sql);
				$query->execute(array( 0,$request[0] ,$request[1]));
				$count = $query->rowCount();
			}*/
			if($count>=1)
			{
				$this->updatePermission($rid, $admin);				
				 $status =true;
				 $successMsg=USER_MODULE_UPDATION_SUCCESS;
			}	
			else {
			   $status =false;
			   $errorMsg=USER_MODULE_UPDATION_FAILED;
			}
		
			
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function OnChangeUserSts($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		$admin=0; $rid=0;
		$sql = "select VisibleSts from UserMaster WHERE OrganizationId =? and Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[0], $request[1] ));
			$row = $query->fetch();
			$admin=$row->VisibleSts;
			
			$admin = ($admin==0) ? 1 : 0 ;
			$sql = "UPDATE UserMaster SET VisibleSts = ? WHERE  Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $admin,$request[1] ));
			$count = $query->rowCount();
			/*if($count>0)
			{
				$sql = "UPDATE UserMaster SET AdminSts = ? WHERE OrganizationId =? AND Id <> ?";
				$query = $this->db->prepare($sql);
				$query->execute(array( 0,$request[0] ,$request[1]));
				$count = $query->rowCount();
			}*/
			if($count>=1)
			{			
				 $status =true;
				 $successMsg=USER_MODULE_UPDATION_SUCCESS;
			}	
			else {
			   $status =false;
			   $errorMsg=USER_MODULE_UPDATION_FAILED;
			}
		
			
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function updatePermission($rid, $sts)
	{
		$mdate = date("Y-m-d H:i:s");
		$mid   = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		
		$sql = "SELECT Id FROM ModuleMaster where ModuleSts=1";
		$query = $this->db->prepare($sql);
		$query->execute();
		try{		
		  while($row = $query->fetch()){		
			$modid = $row->Id;
			
			$sql1 = "SELECT * FROM UserProfile_permission WHERE Userprofileid = ? AND ModuleId=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($rid, $modid, $orgid));
			$count1 =  $query1->rowCount();
			if($count1>=1)
			{
				$sql2 = "UPDATE UserProfile_permission SET ViewPermission=?, EditPermission=?, DeletePermission=?, AddPermission=?,  OrganizationId=?, LastModifiedDate=?, LastModifiedById=? WHERE Userprofileid=? AND ModuleId=? and OrganizationId=?";
		
				$query2 = $this->db->prepare($sql2);				
				$query2->execute(array( $sts,  $sts,  $sts,  $sts, $orgid, $mdate, $mid, $rid, $modid, $orgid));			
				
			}else{
				//$sql2 = "INSERT INTO UserProfile_permission (Userprofileid, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				$sql2 = "INSERT INTO UserProfile_permission (Userprofileid, ModuleId, ViewPermission, EditPermission, DeletePermission, AddPermission, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($rid, $modid, $sts, $sts, $sts, $sts, $orgid, $mdate, $mid, $mdate, $mid, ));
				
			}
			
			}
		}catch(Exception $e) {
			//$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	public function adduserhrstatus($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql = "UPDATE UserMaster SET HRSts = ? WHERE  Id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array( 1,$request[1] ));
		if($query->rowCount()>0)
		{
			$sql1 = "UPDATE UserMaster SET HRSts = ? WHERE OrganizationId =? AND Id <> ?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( 0,$request[0] ,$request[1]));
			$status=true;
			$successMsg = DESIGNATION_MODULE_STATUSCHANGE;
		}else{
			$status=false;
			$errorMsg = DESIGNATION_MODULE_UPDATION_FAILED;
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function changeHR($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION["ubihrm_org_id"];
		$sql = "UPDATE UserMaster SET HRSts = ? WHERE  Id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array(1,$id));
		if($query->rowCount()>0)
		{
			$sql1 = "UPDATE UserMaster SET HRSts = ? WHERE OrganizationId =? AND Id <> ?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( 0,$orgid ,$id));
			$status=true;
			$successMsg = DESIGNATION_MODULE_STATUSCHANGE;
		}else{
			$status=false;
			$errorMsg = DESIGNATION_MODULE_UPDATION_FAILED;
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $status;
    }
}
