<?php

/**
 * LoginModel
 *
 * Handles the user's login / logout / registration stuff
 */


class UpdatefieldModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */


    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	public function UpdateField(){
		$sql = "SELECT Id,TimeZone FROM Organization";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{
				$timezone=$row->TimeZone;
				if($timezone != 0)
				{
					$sql1 = "SELECT Name FROM ZoneMaster where Id=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($timezone));
					if($r=$query1->fetch()){
						//define('TIMEZONE', Session::get('ubihrm_timezone'));
						date_default_timezone_set($r->Name);
						$now = new DateTime();
						$mins = $now->getOffset() / 60;
						$sgn = ($mins < 0 ? -1 : 1);
						$mins = abs($mins);
						$hrs = floor($mins / 60);
						$mins -= $hrs * 60;
						$offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
						try {
							$this->db->exec("SET time_zone='$offset'");				
						} catch (PDOException $e) {
							die('Database connection could not be established.');
						}	
					}
					$this->UpdateFieldsFirst($row->Id);
					$this->GenerateNotifications($row->Id);
					$this->GenerateLeaveHistory($row->Id);
					$this->ProbationEnding($row->Id);
					$this->WorkAnniversary($row->Id);
					$this->ApprovalEscalation($row->Id);
					$this->DeleteNotifications($row->Id); 
					$this->UpdateAttendance($row->Id);
					$this->UpdateAttendanceForAbsentee($row->Id);
					$this->UpdateTimeOut($row->Id);
					
					}
			
			}
				$this->TimeOutNotification();
				/* This function is used for setting time out if timeout is not marked */	
				//$this->SaveTimeOut(); 
				/* Automatic entry in attendence module , if leave is approved in leave module */	
				
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	public function UpdateField1(){
		$sql = "SELECT Id,TimeZone FROM Organization";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{
				$timezone=$row->TimeZone;
				if($timezone != 0)
				{
					$sql1 = "SELECT Name FROM ZoneMaster where Id=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($timezone));
					if($r=$query1->fetch()){
						//define('TIMEZONE', Session::get('ubihrm_timezone'));
						date_default_timezone_set($r->Name);
						
						$now = new DateTime();
						$mins = $now->getOffset() / 60;
						$sgn = ($mins < 0 ? -1 : 1);
						$mins = abs($mins);
						$hrs = floor($mins / 60);
						$mins -= $hrs * 60;
						$offset = sprintf('%+d:%02d', $hrs*$sgn, $mins);
						
						try {
							$this->db->exec("SET time_zone='$offset'");				
						} catch (PDOException $e) {
							die('Database connection could not be established.');
						}	
					}
				}	
				
					//$this->UpdateFieldsFirst($row->Id);
					//$this->GenerateNotifications($row->Id);
					$this->GenerateLeaveHistory($row->Id);
					$this->ProbationEnding($row->Id);
					$this->DeleteNotifications($row->Id);	
				
			
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}	
		
	}
	public function DeleteNotifications($orgid)
	{
		try{
			$date=date('Y-m-d');
			$sql1 = "DELETE FROM GenerateNotification WHERE NotifyDate<?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $date));
			
		}catch(Exception $e) {
			
		}
	
	}
	public function UpdateFieldsFirst($orgid)
	{
		/////////
		$mdate=date("Y-m-d H:i:s");
		//////////////code for change employee status according to severance////
		$sql = "SELECT * FROM SeveranceMaster WHERE OrganizationId = ? and SeveranceStatus=2 ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{			
			$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId = ? and Id=? and EmployeeStatus<>? and Is_Delete=0 ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $orgid, $row->EmployeeId, $row->EmployeeStatus));
			if($query1->rowCount()>0)
			{
				$sql2 = "update EmployeeMaster set EmployeeStatus=? where Id=? and OrganizationId=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row->EmployeeStatus, $row->EmployeeId, $orgid));
			}	
		}
		//////////////////////////////////////////
		//print_r($this->getHR($orgid));
		
		///////////  AUTO CREATING OF FISCAL YEAR AT THE END OF YEAR  //////////////
		$this->db->beginTransaction();	
		try{
		$sql = "SELECT Id, YEAR(Date_add(StartDate, Interval 12 month)) as newyear, Date_add(StartDate, Interval 12 month) as startdate, Date_add(EndDate, Interval 12 month) as enddate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1 and  date_sub(EndDate, Interval 3 month) <= CURDATE()";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{			
				$sql1 = "SELECT Id FROM FiscalMaster WHERE OrganizationId = ? and StartDate=? and EndDate=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $row->startdate, $row->enddate));
				if($query1->rowCount()==0)
				{
					$sql2 = "INSERT INTO FiscalMaster(Name, StartDate, EndDate, FiscalSts, OrganizationId) VALUES(?, ?, ?, ?, ?)";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( "Fiscal Year ".$row->newyear, $row->startdate, $row->enddate, 0, $orgid));
				}	
			}
		}catch(Exception $e) {
			
		}
		$sql = "SELECT Id FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=0 and CURDATE() between StartDate and EndDate";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count=$query->rowCount();
			$curyear=date('Y');
			$month = date('m');
			$fiscalstrt=date('Y-04-01',strtotime(date("Y-m-d")));
			$fiscalend=date('Y-03-31',strtotime("+ 1 year".date("Y-m-d")));
			if($month<=3)
			{
				$fiscalstrt=date('Y-04-01',strtotime("- 1 year".$fiscalstrt));
				$fiscalend=date('Y-03-31',strtotime("- 1 year".$fiscalend));
				$curyear=date('Y',strtotime($fiscalstrt));
			}	
			
			/* if($count==0)
			{
				$sql2 = "INSERT INTO FiscalMaster(Name, StartDate, EndDate, FiscalSts, OrganizationId) VALUES(?, ?, ?, ?, ?)";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( "Fiscal Year ".$curyear, $fiscalstrt, $fiscalend,1, $orgid));		
				
			}else{ */
				if($row = $query->fetch())
				{
					$sql2 = "UPDATE FiscalMaster SET FiscalSts=0 WHERE OrganizationId = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute();
					
					$sql2 = "UPDATE FiscalMaster SET FiscalSts=1 WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->Id ));
					
				}else{
						$sql2 = "SELECT Id FROM FiscalMaster WHERE OrganizationId = ? and StartDate = ? and EndDate = ?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $orgid, $fiscalstrt, $fiscalend ));
						$count=$query2->rowCount();
						 if($count==0)
						{
							$sql2 = "INSERT INTO FiscalMaster(Name, StartDate, EndDate, FiscalSts, OrganizationId) VALUES(?, ?, ?, ?, ?)";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array( "Fiscal Year ".$curyear, $fiscalstrt, $fiscalend,1, $orgid));		
							
						}
					
				}
				
			//}
		}catch(Exception $e) {
			
			}
		///////////// PENDING JOB MODIFICATION QUERY AUTO FIRING ON ADMIN LOGIN /////////////////
		
		$sql = "SELECT * FROM JobModificationMaster WHERE OrganizationId = ? and ApplySts=0 and ApplyFrom <= CURDATE()";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				//$title = "Job Modification";
				$empid=$row->EmployeeId;
				$createddate=$row->ApplyFrom;
				if($row->PromotionType==1)
					$title = "Promotion";
				elseif($row->PromotionType==2)
					$title = "Demotion";
				elseif($row->PromotionType==3)
					$title = "Salary Increment";
				else
					$title = "Transfer/Relocation";
					
				$sql1 = "SELECT * FROM JobModificationChild WHERE JobId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id ));
				while($row1 = $query1->fetch())
				{
					$sql2 = "UPDATE EmployeeMaster SET ".$row1->FieldName." = ".$row1->NewValue." WHERE Id = ?";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId ));					
					
					$msg = "";
					if($row1->FieldName=="EmployeeCTC"){
						$msg ="Gross Salary has been changed to ".$this->getcurrency($orgid)." ".$row1->NewValue;
						
						$sqlsalary ="select * from SalaryHistory where EmployeeId=? and OrganizationId=? and CreatedDate=?";
						$querysalary = $this->db->prepare($sqlsalary);
						$querysalary->execute(array($empid,$orgid,$createddate));
						if($querysalary->rowCount()>0){
							while($r=$querysalary->fetch())
							{
								$sqlwork = " UPDATE EmployeeSalaryDetails SET HeadAmount=?, HeadType=? Where HeadId=? and EmployeeId=? and OrganizationId=?";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute(array($r->HeadAmount,$r->HeadType, $r->HeadId,$empid,$orgid));
							}
						}
					}else if($row1->FieldName=="DOC"){
						$msg ="Your services are confirmed with effect from  ".date("d F, Y", strtotime($row1->NewValue));
					}else if($row1->FieldName=="EmployeeStatus"){
						$msg ="Employee Status has been changed to ".Utils::getName($row1->NewValue, 'EmploymentStatusMaster','Name',$this->db);
					}else if($row1->FieldName=="Division"){
						$msg ="Division has been changed to ".Utils::getName($row1->NewValue, 'DivisionMaster','Name',$this->db);
					}else if($row1->FieldName=="Department"){
						$msg ="Department has been changed to ".Utils::getName($row1->NewValue, 'DepartmentMaster','Name',$this->db);
					}else if($row1->FieldName=="Grade"){
						$msg ="Grade has been changed to ".Utils::getName($row1->NewValue, 'GradeMaster','Name',$this->db);
					}else if($row1->FieldName=="Designation"){
						$msg ="Designation has been changed to ".Utils::getName($row1->NewValue, 'DesignationMaster','Name',$this->db);
						
						$sql3 = "UPDATE  UserMaster SET  RoleId = ?, LastModifiedDate = ? WHERE EmployeeId = ? ";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $row1->NewValue, $mdate, $empid));
					}	
					$sql2 = "INSERT INTO EmployeeHistory(EmployeeId, Title, Message, EventDate, OrganizationId) VALUES(?, ?, ?, ?, ?)";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId, $title, $msg, $row->ApplyFrom, $orgid));
					
				}
				
				$sql2 = "UPDATE JobModificationMaster SET ApplySts=1 WHERE Id = ?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row->Id ));	
			}
		}catch(Exception $e) {
			
			}
			
			///////////// PENDING SEVERANCE QUERY AUTO FIRING ON ADMIN LOGIN /////////////////
		
		/*$sql = "SELECT * FROM SeveranceMaster WHERE OrganizationId = ? and EffectDate < CURDATE()";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$msg = "";
				$sts=Utils::getName($row->EmployeeStatus,'EmploymentStatusMaster','Name',$this->db);
				if($sts=='Terminated')
				{
					$title = "Termination";
					$msg ="You are Terminated";
				}else{
					$title = "Resignation";
					$msg ="You Resigned";
				}
				$empid=$row->EmployeeId;
				$empsts=$row->EmployeeStatus;
				$effectfrom=$row->EffectDate;	
				
				$sql2 = "UPDATE EmployeeMaster SET EmployeeStatus = ?, DOL=? WHERE Id = ?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $empsts,$effectfrom,$empid ));					
				
				
				$sql2 = "SELECT * from EmployeeHistory where EmployeeId =? and Title=? and Message=? and EventDate=?";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array( $row->EmployeeId, $title, $msg, $effectfrom));	
				if($query2->rowCount()==0){
					$sql2 = "INSERT INTO EmployeeHistory(EmployeeId, Title, Message, EventDate, OrganizationId) VALUES(?, ?, ?, ?, ?)";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row->EmployeeId, $title, $msg, $effectfrom, $orgid));
				}
				
			}
		}catch(Exception $e) {
			
			}*/
			
			///////////  AUTO CREATING OF EMPLOYEE ASSESSMENT   //////////////
		$provision=0;	
		$fromdate="";
		$todate="";
		$assessmentype=0;
		$ts3 = strtotime('now');
		$count = 0; $fiscalmonth=4;
		$desiglevel=""; $startyear="";
		$halfyear =""; $fullyear="";
		
		try{
			$sql = "SELECT Month(StartDate) as mnth, StartDate, EndDate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts = ? ";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid,1));
			while($row = $query->fetch())
			{
				$fiscalmonth=$row->mnth;
				$startyear=$row->StartDate;
				$halfyear =date("Y-m-t", strtotime("+5 month ".date($startyear)));
				$fullyear=$row->EndDate;
			}
		}catch(Exception $e) {			
			echo $e->getMessage();
		}
				
		$sql = "SELECT Id,Period,DesignationLevel, DesignationId FROM AssessmentObjective WHERE OrganizationId = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch())
		{
			$objectiveid=$row->Id;
			$assessmentype = $row->Period;
			$desigid = $row->DesignationId;
			$desiglevel = $row->DesignationLevel;
			if($desiglevel != ""){
				//$currdate =date("Y-m-d");
				$currdate =date("Y-m-d",strtotime("-1 month ".date("Y-m-d")));
				$stdate=$startyear;
				while($stdate<$currdate)
				{			
					if($assessmentype==4){				///// TYPE FOR MONTHLY ASSESSMENT /////////
						$fromdate=date("Y-m-01", strtotime(date($stdate)));
						$todate=date("Y-m-t", strtotime(date($stdate)));
						
					}elseif($assessmentype==1){			///// TYPE FOR YEARLY ASSESSMENT /////////
						//$fromdate=date("Y-m-d", strtotime("-1 year ".date($startyear)));
						//$todate=date("Y-m-d", strtotime("-1 year ".date($fullyear)));
						$fromdate=$startyear;
						$todate=$fullyear;
					}elseif($assessmentype==2){			///// TYPE FOR HALFYEARLY ASSESSMENT /////////
						if(($startyear<= $currdate) && ($halfyear>=$currdate)){
							//$fromdate=date("Y-m-d", strtotime("-6 month ".date($startyear)));
							//$todate=date("Y-m-t", strtotime("-6 month ".date($halfyear)));
							$fromdate=$startyear;
							$todate=$halfyear;
						}/*elseif((date("Y-m-01", strtotime("+1 month ".date($halfyear)))<= $currdate) && ($fullyear>=$currdate)){
							$fromdate=$startyear;
							$todate=$halfyear;
						}*/else{
							$fromdate=date("Y-m-01", strtotime("+1 month ".date($halfyear)));
							$todate=$fullyear;
						}
					}elseif($assessmentype==3){	
						///// TYPE FOR QUATERLY ASSESSMENT /////////
						
						if(($startyear<= $currdate) && (date("Y-m-t", strtotime("+2 month ".date($startyear)))>=$currdate)){
							//$fromdate=date("Y-m-d", strtotime("-3 month ".date($startyear)));
							//$todate=date("Y-m-t", strtotime("-1 month ".date($startyear)));
							$fromdate=$startyear;
							$todate=date("Y-m-t", strtotime("+2 month ".date($startyear)));
						}elseif((date("Y-m-01", strtotime("+3 month ".date($startyear)))<=$currdate) && ($halfyear>= $currdate)){
							//$fromdate=$startyear;
							//$todate=date("Y-m-t", strtotime("+2 month ".date($startyear)));
							$fromdate=date("Y-m-01", strtotime("+3 month ".date($startyear)));
							$todate=date("Y-m-t", strtotime("+5 month ".date($startyear)));
						}elseif((date("Y-m-01", strtotime("+1 month ".date($halfyear)))<=$currdate) && (date("Y-m-t", strtotime("+3 month ".date($halfyear)))>=$currdate)){
							//$fromdate=date("Y-m-01", strtotime("+3 month ".date($startyear)));
							//$todate=$halfyear;
							$fromdate=date("Y-m-01", strtotime("+6 month ".date($startyear)));
							$todate=date("Y-m-t", strtotime("+8 month ".date($startyear)));
						}else{
							$fromdate=date("Y-m-01", strtotime("+9 month ".date($startyear)));
							$todate=$fullyear;
						}
					}
					try{
					//echo $orgid."  ".$fromdate." == ".$todate."<br>";
						$sql1 = "SELECT Id, Designation, date_add(DOJ , Interval ProvisionPeriod month) as provisiondate FROM EmployeeMaster WHERE OrganizationId = ? and Designation=? and DOJ<? and DOL ='0000-00-00'  and Is_Delete=0 ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid, $desigid, $todate));			
						while($row1=$query1->fetch())
						{
							$emp = $row1->Id;
							if(date($row1->provisiondate)>date("Y-m-d"))
							{
								$fromdate=date("Y-m-01", strtotime(date($stdate)));
								$todate=date("Y-m-t", strtotime(date($stdate)));
							}
							$sqla = "SELECT Id FROM EmployeeAssessment WHERE EmployeeId =? and FromDate =? and ToDate = ?";
							$querya = $this->db->prepare($sqla);
							$querya->execute(array( $emp,$fromdate,$todate));
							$count =  $querya->rowCount();
							if($count==0){
								$sql2 = "INSERT INTO EmployeeAssessment (  EmployeeId, FromDate, ToDate, AssessmentType,  CreatedDate, OrganizationId, DesignationLevel) VALUES (?, ?, ?, ?, ?, ?, ?)";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array( $emp,$fromdate,$todate,$assessmentype,$mdate,$orgid,$desiglevel ));
								$aid=$this->db->lastInsertId();
								
								$senior=$this->getSeniorIds($emp,$orgid);
								$seniorids=implode(',',$senior).','.$emp;
								
									$sql3 = "SELECT Id,Designation from EmployeeMaster where Designation in ( $desiglevel) and Id in ($seniorids) order by FIELD (Designation,$desiglevel)";
									$query3 = $this->db->prepare($sql3);
									$query3->execute();
									$i=0;
									while($rowdesig=$query3->fetch()){
									
										$sqlapp="INSERT INTO EmployeeAssessmentApproval ( EmployeeAssessmentId, DesignationId, Level, EmployeeId) VALUES (?, ?, ?, ?)";
										$queryapp = $this->db->prepare($sqlapp);
										$queryapp->execute(array( $aid,$rowdesig->Designation,++$i,$rowdesig->Id ));
									}
									
									$desigid1=explode(',',$desiglevel);
									for($i=0;$i<count($desigid1);$i++){
										$sql4 = "SELECT Id from AssessmentObjectiveChild where AssessmentObjectiveId=? and VisibleSts=1";
										$query4 = $this->db->prepare($sql4);
										$query4->execute(array( $objectiveid ));
										while($rowgap=$query4->fetch()){
											$sqlgap="INSERT INTO EmployeeAssessmentChild ( EmployeeAssessmentId, ObjectiveId,  Level, DesignationLevel) VALUES (?, ?,?,?)";
											$querygap = $this->db->prepare($sqlgap);
											$querygap->execute(array( $aid,$rowgap->Id,$i+1,$desigid1[$i] ));
										}
										
									}
							
							}
								
						}
					}
					catch(Exception $e){
						$e->getMessage();
					}
					$stdate=date("Y-m-d",strtotime("+1 month".date($stdate)));				
				}
			}
		}
		
		
		$sql = "SELECT Id,Period, AssessmentLevel, Designation FROM CompetencyAnalysis WHERE OrganizationId = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid));
		while($row = $query->fetch())
		{
			$analysisid=$row->Id;
			$assessmentype = $row->Period;
			$desigid = $row->Designation;
			$desiglevel = $row->AssessmentLevel;
			
			
			$currdate =date("Y-m-d");	
			$stdate=$startyear;
			while($stdate<$currdate)
			{			
				if($assessmentype==4){				///// TYPE FOR MONTHLY ASSESSMENT /////////
					$fromdate=date("Y-m-01", strtotime(date($stdate)));
					$todate=date("Y-m-t", strtotime(date($stdate)));
					
				}elseif($assessmentype==1){			///// TYPE FOR YEARLY ASSESSMENT /////////
					//$fromdate=date("Y-m-d", strtotime("-1 year ".date($startyear)));
					//$todate=date("Y-m-d", strtotime("-1 year ".date($fullyear)));
					$fromdate=$startyear;
					$todate=$fullyear;
				}elseif($assessmentype==2){			///// TYPE FOR HALFYEARLY ASSESSMENT /////////
					if(($startyear<= $currdate) && ($halfyear>=$currdate)){
						//$fromdate=date("Y-m-d", strtotime("-6 month ".date($startyear)));
						//$todate=date("Y-m-t", strtotime("-6 month ".date($halfyear)));
						$fromdate=$startyear;
						$todate=$halfyear;
					}/*elseif((date("Y-m-01", strtotime("+1 month ".date($halfyear)))<= $currdate) && ($fullyear>=$currdate)){
						$fromdate=$startyear;
						$todate=$halfyear;
					}*/else{
						$fromdate=date("Y-m-01", strtotime("+1 month ".date($halfyear)));
						$todate=$fullyear;
					}
				}elseif($assessmentype==3){			///// TYPE FOR QUATERLY ASSESSMENT /////////
					if(($startyear<= $currdate) && (date("Y-m-t", strtotime("+2 month ".date($startyear)))>=$currdate)){
						//$fromdate=date("Y-m-d", strtotime("-3 month ".date($startyear)));
						//$todate=date("Y-m-t", strtotime("-1 month ".date($startyear)));
						$fromdate=$startyear;
						$todate=date("Y-m-t", strtotime("+2 month ".date($startyear)));
					}elseif((date("Y-m-01", strtotime("+3 month ".date($startyear)))<=$currdate) && ($halfyear>= $currdate)){
						//$fromdate=$startyear;
						//$todate=date("Y-m-t", strtotime("+2 month ".date($startyear)));
						date("Y-m-01", strtotime("+3 month ".date($startyear)));
						date("Y-m-t", strtotime("+5 month ".date($startyear)));
					}elseif((date("Y-m-01", strtotime("+1 month ".date($halfyear)))<=$currdate) && (date("Y-m-t", strtotime("+3 month ".date($halfyear)))>=$currdate)){
						//$fromdate=date("Y-m-01", strtotime("+3 month ".date($startyear)));
						//$todate=$halfyear;
						date("Y-m-01", strtotime("+6 month ".date($startyear)));
						date("Y-m-t", strtotime("+8 month ".date($startyear)));
					}else{
						$fromdate=date("Y-m-01", strtotime("+9 month ".date($startyear)));
						$todate=$fullyear;
					}
				}
				//echo $orgid."  ".$fromdate." == ".$todate."<br>";
				$sql1 = "SELECT Id, Designation, date_add(DOJ , Interval ProvisionPeriod month) as provisiondate FROM EmployeeMaster WHERE OrganizationId = ? and Designation=? and DOJ<? and DOL ='0000-00-00' and Is_Delete=0";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $desigid, $todate));			
				while($row1=$query1->fetch())
				{
					$emp = $row1->Id;
					if(date($row1->provisiondate)>date("Y-m-d"))
					{
						$fromdate=date("Y-m-01", strtotime(date($stdate)));
						$todate=date("Y-m-t", strtotime(date($stdate)));
					}
					$sqla = "SELECT Id FROM SkillGapAssessment WHERE EmployeeId =? and FromDate =? and ToDate = ?";
					$querya = $this->db->prepare($sqla);
					$querya->execute(array( $emp,$fromdate,$todate));
					$count =  $querya->rowCount();
					if($count==0){
						$sql2 = "INSERT INTO SkillGapAssessment (  EmployeeId, FromDate, ToDate, Period,  CreatedDate, OrganizationId, AssessmentLevel) VALUES (?, ?, ?, ?, ?, ?, ?)";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array( $emp,$fromdate,$todate,$assessmentype,$mdate,$orgid,$desiglevel ));
						$aid=$this->db->lastInsertId();
						
						////////insert data in skill gap child and approval according to employee designation and designation levels///////
						try{
						$senior=$this->getSeniorIds($emp,$orgid);
						$seniorids=implode(',',$senior);
						
							$sql3 = "SELECT Id,Designation from EmployeeMaster where Designation in( $desiglevel ) and Id in( $seniorids) order by FIELD (Designation,$desiglevel)";
							$query3 = $this->db->prepare($sql3);
							$query3->execute();
							$i=0;
							while($rowdesig=$query3->fetch()){
							
								$sqlapp="INSERT INTO SkillGapApproval ( SkillGapId, DesignationId, Level, EmployeeId) VALUES (?, ?, ?, ?)";
								$queryapp = $this->db->prepare($sqlapp);
								$queryapp->execute(array( $aid,$rowdesig->Designation,++$i,$rowdesig->Id ));
							}
						}
						catch(Exception $e){
							$e->getMessage();
						}					
						
						$desigid1=explode(',',$desiglevel);
						for($i=0;$i<count($desigid1);$i++){
							$sql4 = "SELECT Id from CompetencyAnalysisChild where AnalysisId=? and VisibleSts=1";
							$query4 = $this->db->prepare($sql4);
							$query4->execute(array( $analysisid ));
							while($rowgap=$query4->fetch()){
								$sqlgap="INSERT INTO SkillGapChild (  SkillGapId, AnalysisId,AssessedBy,Level) VALUES (?, ?,?,?)";
								$querygap = $this->db->prepare($sqlgap);
								$querygap->execute(array( $aid,$rowgap->Id,$desigid1[$i],$i+1 ));
							}
							
						}
						
					}
				}
				$stdate=date("Y-m-d",strtotime("+1 month".date($stdate)));				
			}
		}
		
		
		
		/*$sql = "SELECT Id,Designation FROM EmployeeMaster WHERE OrganizationId = ? and DOL ='0000-00-00' ";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid));
			
			while($row=$query->fetch())
			{
				
				$assessmentype=0;
				$emp=$row->Id;
				$desig=$row->Designation;
				////////ASSESSMENT FOR UNDER PROBATION EMPLOYEE/////////
				$sql1 = "SELECT ProvisionPeriod  FROM EmployeeMaster WHERE Id= ? and OrganizationId = ? and  DOL='0000-00-00' and CURDATE() BETWEEN  DOJ AND date_add(DOJ , Interval ProvisionPeriod month) and ProvisionPeriod <> 0";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($emp, $orgid ));
				
				if($query1->rowCount() >0){
					$row1=$query1->fetch();
					$provision=$row1->ProvisionPeriod;
					$fromdate=date('Y-m-1', strtotime("-1 months", $ts3));
					$todate=date('Y-m-t', strtotime("-1 months", $ts3));
					$assessmentype=4;
					$desiglevel=$row->Designation;
				}
				else{
				
						$sql1 = "SELECT Period,DesignationLevel FROM AssessmentObjective WHERE OrganizationId = ? and DesignationId = ? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid,$desig));
						while($r1=$query1->fetch()){
							$assessmentype=$r1->Period;
							$desiglevel=$r1->DesignationLevel;
						}
						$sql1 = "SELECT * FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts = ? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $orgid,1));
						while($row1 = $query1->fetch())
						{
							$ts1 = strtotime($row1->StartDate);
							$ts2 = strtotime($row1->EndDate);
							$ts3 = strtotime('now');
							
							if($assessmentype == 1){
								$fromdate=$row1->StartDate;
								$todate=$row1->EndDate;
							}
							elseif($assessmentype == 2){
								$sixMonthsLater = strtotime("+6 months", $ts1);
								if($ts3 > $sixMonthsLater){
								
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $sixMonthsLater;
									$todate= $row1->EndDate;
								}
								else{
								
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $row1->StartDate;
									$todate= $sixMonthsLater;
										
								}						
							}
							elseif($assessmentype == 3){
								$nineMonthsLater = strtotime("+9 months", $ts1);
								$sixMonthsLater = strtotime("+6 months", $ts1);
								$threeMonthsLater = strtotime("+3 months", $ts1);
								if($ts3 > $ts1 && $threeMonthsLater <= $ts1){
									$threeMonthsLater =date('Y-m-d', strtotime("+3 months", $ts1));
									$fromdate= $row1->StartDate;
									$todate= $threeMonthsLater;
								}
								elseif($ts3 > $threeMonthsLater && $sixMonthsLater <=$threeMonthsLater ){
									$threeMonthsLater =date('Y-m-d', strtotime("+3 months", $ts1));
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $threeMonthsLater;
									$todate=$sixMonthsLater;
								}
								elseif($ts3 > $sixMonthsLater && $nineMonthsLater <=$sixMonthsLater ){
									$nineMonthsLater =date('Y-m-d', strtotime("+9 months", $ts1));
									$sixMonthsLater =date('Y-m-d', strtotime("+6 months", $ts1));
									$fromdate= $sixMonthsLater;
									$todate=$nineMonthsLater;
								}
								elseif($ts3 >= $nineMonthsLater && $nineMonthsLater <= $ts2){
									$nineMonthsLater =date('Y-m-d', strtotime("+9 months", $ts1));
									$fromdate= $nineMonthsLater;
									$todate= $row1->EndDate;
								}
							}else{
								
								$fromdate=date('Y-m-1', strtotime("-1 months", $ts3));
								$todate=date('Y-m-t', strtotime("-1 months", $ts3));
							}							
						}
					}
					
					if($assessmentype != 0 ){			
						$sqla = "SELECT * FROM EmployeeAssessment WHERE EmployeeId =? and FromDate =? and ToDate = ?";
						$querya = $this->db->prepare($sqla);
						$querya->execute(array( $emp,$fromdate,$todate));
						$count =  $querya->rowCount();
						if($count==0){
							$sql2 = "INSERT INTO EmployeeAssessment (  EmployeeId, FromDate, ToDate, AssessmentType,  CreatedDate, OrganizationId, DesignationLevel) VALUES (?, ?, ?, ?, ?, ?, ?)";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array( $emp,$fromdate,$todate,$assessmentype,$mdate,$orgid,$desiglevel ));
						}
					}
			}
				
			
		}catch(Exception $e) {
				
			}*/
			$this->db->commit(); 
				 
				}catch(PDOException $e)
				{
					
					$this->db->rollBack();
					//$errorMsg = 'Message: ' .$e->getMessage();
				}
			
	}
	
	public function CreateNotification($title,$msg,$orgid, $empid)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE()";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count == 0){
					$sql1 = "INSERT INTO GenerateNotification (  EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
				
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $empid,$title,$msg,$mdate,$orgid ));
				}
				
			
		}
		catch(Exception $e){
		}
	
	}
	
	public function GenerateNotifications($orgid)
    {
		////////////find out if an employee not coming on resumption date after leave,for that we are finding out in attendance of employee on resumption date///////
		$mdate= date("Y-m-d H:i:s");
		$mdate1= date("Y-m-d 20:00:00");///execute after 8 pm
		$onedayback = strtotime("-1 day", strtotime($mdate1));
		$onedayback = date("Y-m-d", $onedayback);
		$resumptionbefore = $this->getLeadDays("ExecutionValue",10,$orgid);
		if($resumptionbefore==0)
			$resumptionbefore = "-1 day";
		else
			$resumptionbefore = "-".$resumptionbefore." day";
		
		$resumptionback = strtotime($resumptionbefore, strtotime($mdate1));
		$resumptionback = date("Y-m-d", $resumptionback);
		if(strtotime($mdate)>strtotime($mdate1)){
			$sql = "SELECT *,DATEDIFF('$resumptionback',ResumptionDate) as daysleft FROM EmployeeLeave WHERE OrganizationId = ? and ResumptionDate BETWEEN DATE_SUB('$resumptionback', INTERVAL 7 DAY) AND '$resumptionback' and LeaveStatus=2";
			
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($rowres=$query->fetch())
			{
				$resuptiondate=$rowres->ResumptionDate;
				$empid=$rowres->EmployeeId;
				
				$sql1 = "SELECT * FROM AttendanceMaster WHERE OrganizationId = ? and EmployeeId=? and AttendanceDate=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$resuptiondate ));
				if($query1->rowCount()==0)
				{
					///////////////   CREATING NOTIFICATION  /////////
					$title="Employee did not resume";	
					$name = Utils::getEmployeeName($rowres->EmployeeId, $this->db);
					$senior = $this->getSeniorId($rowres->EmployeeId, $orgid);
					$hr =  $this->getHR($orgid);
					$empids = implode($hr,",").",".$senior.",".$rowres->EmployeeId;
					
					$mid = $senior;
					/////////Finding out the gender of employee//////////
					
					$gender=Utils::getName($rowres->EmployeeId, 'EmployeeMaster', 'Gender', $this->db);
					$gen="He";
					if($gender==2)
						$gen="She";
					$dat = ($rowres->daysleft==0)?"yesterday":"on ".date("d F Y",strtotime($resuptiondate));
						
					$msg="$name's leave period is over. $gen did not resume the office $dat.";
					$empids =explode(",",$empids);
					$alert=$this->getLeadDays("NotifyAlert",10,$orgid);
					$mailsend=$this->getLeadDays("SendMail",10,$orgid);
					
						for($i=0;$i<count($empids);$i++)
						{
							if($alert){
							$this->CreateNotification($title,$msg,$orgid, $empids[$i]);
							}
							if($mailsend){
							$toemail=Utils::getName($empids[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
						}
					
					/* $sql1="select * from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($title, $msg, $empids, $orgid));
					if($query1->rowCount()==0){				
						$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2));
					} */
				}
			}
		}
		//////////////////////////
		$mdate= date("Y-m-d H:i:s");
		$count=0;		
		/* $probation=15; $joining=10; $birthday=1; $anniversary=1;  */
				
		$sWhere = "";
		$leave = "";
		
		$sWhere = " and  DOL='0000-00-00' ";
		$hrarr=$this->getHR($orgid);
		//print_r($hrarr);
		///////// FIND OUT NOTIFICATION SETTINGS FOR ORGANIZATION  ////////////////
		$probation = $this->getLeadDays("ExecutionValue",1,$orgid);
		$joining = $this->getLeadDays("ExecutionValue",2,$orgid);
		$birthday = $this->getLeadDays("ExecutionValue",3,$orgid);
		$anniversary = $this->getLeadDays("ExecutionValue",17,$orgid);
       /*  $sql = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and  SettingId in (1,2,3,4)";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		while($row = $query->fetch())
		{
			if($row->SettingId==1){
			$probation=$row->ExecutionValue;
			}elseif($row->SettingId==2){
			$joining=$row->ExecutionValue;
			}elseif($row->SettingId==3){
			$birthday=$row->ExecutionValue;
			}elseif($row->SettingId==10){
			$anniversary=$row->ExecutionValue;
			}
		} */
		$emparr = array();
		$sql = "SELECT EmployeeId FROM UserMaster WHERE  OrganizationId = ? ";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		$i=0;
		while($row=$query->fetch())
		{
			$emparr[$i]=$row->EmployeeId;
			$i++;
		}
		
		///////// NOTIFICATION FOR EMPLOYEE BIRTHDAY  ////////////////
		//$sql = "DELETE FROM GenerateNotification where NotifyDate<CURDATE()";
        //$query = $this->db->prepare($sql);
		//$query->execute();
		
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOB, datediff( DATE_ADD(dob, INTERVAL YEAR(CURDATE())-YEAR(dob)+ IF(DAYOFYEAR(CURDATE()) >= DAYOFYEAR(dob),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE OrganizationId=? and  DATE_ADD(dob,
        INTERVAL YEAR(CURDATE())-YEAR(dob) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(dob),1,0)YEAR)
         BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $birthday DAY) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$alert=$this->getLeadDays("NotifyAlert",3,$orgid);
			$mailsend=$this->getLeadDays("SendMail",3,$orgid);
			while($row = $query->fetch())
			{
				$temparr = $this->getSeniorIds($row->Id, $orgid);
				
				for($x=0; $x<count($emparr); $x++)
				{
					if(in_array($emparr[$x],$temparr))
					{	
						$msg="";$name ="";$title="";
						
						$name = ucwords(strtolower($row->FirstName." ".$row->LastName."'s"));
						$dat = ($row->diff==0)?"Today":(($row->diff==1)?"Tomorrow":date("d F", strtotime($row->DOB)));					
						$title = "Birthday Notification";
						if($emparr[$x]==$row->Id){
							$msg ="Happy Birthday! May you feel on the top of the world on your special day and all year through!";
						}else{
							if($row->diff>1){
								$msg = "It's ".$name." birthday on ".$dat;
							}else{
								$msg = "It's ".$name." birthday ".$dat;
							}
						}
						
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
						}
						if($mailsend){
						$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
							if($row->diff>1){
								$msg = "It's ".$name." birthday on ".$dat;
							}else{
								$msg = "It's ".$name." birthday ".$dat;
							}
						
						for($i=0;$i<count($hrarr);$i++){
							if($emparr[$x] != $hrarr[$i]){
								if($alert){
								$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
								}
								if($mailsend){
								$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
								Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
								}
							}
						
						}
					}
				}
				
			}
        }
		
		///////// FINDING PROBATION PERIOD ENDING DAYS ////////////////
		
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, ReportingTo, DOJ, datediff(DATE_ADD(DOJ, INTERVAL Provisionperiod month), curdate()) as daysleft FROM EmployeeMaster WHERE Provisionperiod<>0 and OrganizationId = ? and  DATE_ADD(DOJ, INTERVAL Provisionperiod month) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $probation DAY) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$alert=$this->getLeadDays("NotifyAlert",1,$orgid);
			$mailsend=$this->getLeadDays("SendMail",1,$orgid);
			while($row = $query->fetch())
			{
				$temparr = $row->ReportingTo;
				
				//for($x=0; $x<count($emparr); $x++)
				//{
					//if(in_array($emparr[$x],$temparr))
					//{				
						$msg="";$name ="";$title="";						
						$name = $row->EmployeeCode." ".ucwords(strtolower($row->FirstName." ".$row->LastName."'s"));
						$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." days");				
						$title = $row->daysleft." Days left in Probation";
						if($row->daysleft==0)
							$title =" Today is last day of Probation";
						
						$msg = "Your probation period is going to end ".$dat;
						
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $row->Id);
						}
						if($mailsend){
						$toemail=Utils::getName($row->Id, 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						$msg = $name." probation period is going to end ".$dat;
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $row->ReportingTo);
						}
						if($mailsend){
						$toemail=Utils::getName($row->ReportingTo, 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						$msg = $name." probation period is going to end ".$dat;
						
						for($i=0;$i<count($hrarr);$i++){
							if($alert){
							$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
							}
							if($mailsend){
							$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
						}	
						
					//}
				//}
			}
        }
		
		///////// FINDING NEW JOINING OF EMPLOYEE ////////////////
		
        $sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOJ, datediff( DOJ, curdate()) as daysleft FROM EmployeeMaster WHERE  OrganizationId = ? and (CURDATE() BETWEEN DATE_SUB(DOJ, INTERVAL $joining DAY) and DOJ) $sWhere ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$alert=$this->getLeadDays("NotifyAlert",2,$orgid);
			$mailsend=$this->getLeadDays("SendMail",2,$orgid);
			while($row = $query->fetch())
			{
				$temparr = $this->getSeniorIds($row->Id, $orgid);
				
				for($x=0; $x<count($emparr); $x++)
				{
					if(in_array($emparr[$x],$temparr))
					{	
						$msg="";$name ="";$title="";
						
						$name = ucwords(strtolower($row->FirstName));
						$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." day's");			
						$title = "New Joining Notification";
						if($emparr[$x]==$row->Id){
							$msg = "Welcome $name. Hope you will have a great time working with us.";
						}else{
							$msg = $name." joining ".$dat;
						}
						
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
						}
						
						if($mailsend){
						$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						
						$msg = $name." joining ".$dat;
						
						for($i=0;$i<count($hrarr);$i++){
							if($emparr[$x] != $hrarr[$i]){	
								if($alert){							
									$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
								}
								if($mailsend){
									$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
									Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
								}
							}
						}
												
					}
				}
			}
        }
		//////////////////  NOTIFICATION FOR EMPLOYEES WHO  ARE ON LEAVE TODAY  ////////////////
		
		$sql = "SELECT EmployeeId from EmployeeLeave where OrganizationId=? and LeaveStatus=2 and (curdate() between LeaveFrom and LeaveTo) $leave ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$alert=$this->getLeadDays("NotifyAlert",11,$orgid);
			$mailsend=$this->getLeadDays("SendMail",11,$orgid);
			while($row = $query->fetch())
			{
				$temparr = $this->getSeniorIds($row->EmployeeId, $orgid);
				
				for($x=0; $x<count($emparr); $x++)
				{
					if(in_array($emparr[$x],$temparr))
					{
						$msg="";$name ="";$title="";
						
						$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
						$title = "Employee on leave";
						if($emparr[$x]==$row->EmployeeId){
							$msg ="";
						}else{
							$msg = $name." on leave for today ";
							
							if($alert){
							$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
							}
							
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
								Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
						}
						$msg = $name." on leave for today ";
						
						for($i=0;$i<count($hrarr);$i++){
							if($row->EmployeeId != $hrarr[$i]){	
							if($alert){							
								$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
								}
								if($mailsend){
								$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
								Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
							}
						}	
						
					}
				}
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		/////////////  NOTIFICATION FOR DOCUMENT EXPIRED SOON ///////////////
		$docexpiredays = $this->getLeadDays("ExecutionValue",12,$orgid);
		$sql = "SELECT EmployeeId, DocumentTypeId, DATEDIFF(ExpiredOn,curdate()) as daysleft from EmployeeDocument where OrganizationId=? and ExpiredOn<>'0000-00-00' and(DATEDIFF(ExpiredOn,curdate()) between 0 and $docexpiredays) $leave";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$alert=$this->getLeadDays("NotifyAlert",12,$orgid);
			$mailsend=$this->getLeadDays("SendMail",12,$orgid);
			while($row = $query->fetch())
			{
				$temparr = $this->getSeniorIds($row->EmployeeId, $orgid);
				$msg="";$name ="";$title="";
				for($x=0; $x<count($emparr); $x++)
				{
					if(in_array($emparr[$x],$temparr))
					{
						$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
						$doc = 	Utils::getName($row->DocumentTypeId, 'DocumentMaster','Name',$this->db);
						$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Tomorrow":"within ".$row->daysleft." days");				
						$title = "Document Expiration Notice";
						if($emparr[$x]==$row->EmployeeId){
							$msg = "Your $doc is about to expire $dat";
						}else{
							$msg = "$name $doc is about to expire $dat";
						}
						
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
						}
						if($mailsend){
						$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						$msg = "$name $doc is about to expire $dat";
						
						for($i=0;$i<count($hrarr);$i++){
							if($emparr[$x] != $hrarr[$i]){	
								if($alert){
								$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
								}
								if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$this->db);
								Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
								}
							}
						}
												
					}
				}
			}
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		/////////////  NOTIFICATION FOR PENDING  PERFORMANCE ASSESSMENT ///////////////
		//$assessleftdays = $this->getLeadDays("ExecutionValue",13,$orgid);
		$sql = "SELECT Id, EmployeeId, AssessmentType, DesignationLevel, DATEDIFF(curdate(),ToDate) as daysleft from EmployeeAssessment where OrganizationId=? and AssessmentSts=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$alert=$this->getLeadDays("NotifyAlert",13,$orgid);
			$mailsend=$this->getLeadDays("SendMail",13,$orgid);
			while($row = $query->fetch())
			{
				$assesid=$row->Id;
				if($row->daysleft>=0)
				{
					$sql2 = "SELECT EmployeeId from EmployeeAssessmentApproval where  EmployeeAssessmentId=? and  AssessmentSts=0";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(  $assesid));
					while($row2=$query2->fetch())
					{
						
						$msg="";$name ="";$title="";
						$id=$row2->EmployeeId;
						$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
						$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Yesterday":$row->daysleft." days");				
						$title = "Performance Assessment";
						if($row->EmployeeId == $id){
							$msg = "Your self assessment is pending from $dat ";
						}else{
							$msg = "$name assessment is pending from $dat ";
						}	
						
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $id);
						}
						if($mailsend){
						$toemail=Utils::getName($id, 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						$empname=Utils::getEmployeeName($id, $this->db);
						$msg = "$name assessment is pending from $empname ";
						
						for($i=0;$i<count($hrarr);$i++){
							if($id != $hrarr[$i]){	
							if($alert){							
								$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
							}
							if($mailsend){
							$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
							}
						}
						
					}
				}	
			}	
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		/////////////  NOTIFICATION FOR PENDING  SKILL GAP ASSESSMENT ///////////////
		
		$sql = "SELECT Id, EmployeeId, Period, AssessmentLevel, DATEDIFF(curdate(),ToDate) as daysleft from SkillGapAssessment where OrganizationId=? and AssessmentSts=0";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$alert=$this->getLeadDays("NotifyAlert",14,$orgid);
			$mailsend=$this->getLeadDays("SendMail",14,$orgid);
						
			while($row = $query->fetch())
			{
				$assesid =$row->Id;
				//$empid=$row->EmployeeId;
				if($row->daysleft>=0)
				{	
					$sql2 = "SELECT EmployeeId from SkillGapApproval where  SkillGapId=? and  AssessmentSts=0";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(  $assesid));
					while($row2=$query2->fetch())
					{
						
						$msg="";$name ="";$title="";
						$id=$row2->EmployeeId;
						$name = Utils::getEmployeeName($row->EmployeeId, $this->db);
						$dat = ($row->daysleft==0)?"Today":(($row->daysleft==1)?"Yesterday":$row->daysleft." days");				
						$title = "Skill Gap Analysis";
						
						$msg = "$name skill gap analysis is pending from $dat ";
						if($alert){
						$this->CreateNotification($title,$msg,$orgid, $id);
						}
						if($mailsend){
							$toemail=Utils::getName($id, 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
						$empname=Utils::getEmployeeName($id, $this->db);
						$msg = "$name skill gap analysis is pending from $empname ";
						
						for($i=0;$i<count($hrarr);$i++){
							if($id != $hrarr[$i]){	
								if($alert){							
									$this->CreateNotification($title,$msg,$orgid, $hrarr[$i]);
								}
								if($mailsend){
									$toemail=Utils::getName($hrarr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
									Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
								}
							}
						}
						
					}
				}	
				
			}

		///////// NOTIFICATION FOR EMPLOYEE Complete 1 year  ////////////////
		/* $orgname=Utils::getName($orgid,'Organization','Name',$this->db);
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, DOJ, YEAR(curdate())-YEAR(DOJ) as completedyears, datediff( DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj)+ IF(DAYOFYEAR(CURDATE()) >= DAYOFYEAR(doj),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE OrganizationId=? and  DATE_ADD(doj,
        INTERVAL YEAR(CURDATE())-YEAR(doj) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(doj),1,0)YEAR)
         BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 0 DAY) and YEAR(curdate())-YEAR(DOJ) <> 0  and  DOL='0000-00-00'";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			
			while($row = $query->fetch())
			{
				$temparr = $this->getHR($orgid);
				
				for($x=0; $x<count($emparr); $x++)
				{
					if(in_array($emparr[$x],$temparr))
					{	
						$msg="";$name ="";$title="";
						
						$name = ucwords(strtolower($row->FirstName." ".$row->LastName.""));
						$dat = ($row->diff==0 || $row->diff==365)?"Today":(($row->diff==1)?"Tomorrow":date("d F", strtotime($row->DOJ)));
						Utils::Trace($row->Id.",".$emparr[$x]);
						$title = "Work Anniversary";
						if($emparr[$x]==$row->Id){
							
							$msg ="Dear ".$name.", Congratulations on completing ".$row->completedyears." years with us. Wish you continued success and many more years with us!";
						}else{
								$msg = $dat." is the work anniversary of  ".$name;
						}
						$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
						 	 
					}
					elseif($emparr[$x]==$row->Id)
					{
						$msg="";$name ="";$title="";
						
						$name = ucwords(strtolower($row->FirstName." ".$row->LastName.""));
						$dat = ($row->diff==0 || $row->diff==365)?"Today":(($row->diff==1)?"Tomorrow":date("d F", strtotime($row->DOJ)));
						Utils::Trace($row->Id.",".$emparr[$x]);
						$title = "Work Anniversary";
						$msg ="Dear ".$name.", Congratulations on completing ".$row->completedyears." years with us. Wish you continued success and many more years with us!";
						$this->CreateNotification($title,$msg,$orgid, $emparr[$x]);
					}
				}
				
			}
        } */

			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	
    }
	public function getHR($orgid)
	{
		$index=0;
		$ids=array(); $empids="";
		$sql = "select EmployeeMaster.Id as empid from DesignationMaster,EmployeeMaster where DesignationMaster.Id=EmployeeMaster.Designation and DesignationMaster.HrSts=1 and EmployeeMaster.OrganizationId=? and DesignationMaster.OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid,$orgid));
		while($r=$query->fetch()){
			$ids[] = $r->empid;
			if($empids == "")
				$empids = $r->empid;
			else
				$empids .= ", ".$r->empid;
		}
		
		////////////////// adding admin in hr array ////////////////// for sending the notifications to admins also /////////////////
		
		$sql = "select EmployeeId from UserMaster where AdminSts = 1 and OrganizationId=? and EmployeeId not in (?)";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid, $empids));
		while($r=$query->fetch()){
			$ids[] = $r->EmployeeId;
		}
		return $ids;
	}
	
	public function getcurrency( $orgid)
	{
		$name=0;
		
		$sql = "SELECT Currency FROM Organization WHERE Id = ? ";
				
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		
		while($row = $query->fetch())
		{
			$sql1 = "SELECT CurrencyCode FROM CurrencyMaster WHERE Id = ? ";
				
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Currency));
			
			while($row1 = $query1->fetch())
			{
				
				$name= Utils::getCurrencySymbolHex($row1->CurrencyCode);
								
			}	
			
				
		}
		
		return $name;
	}
	public function getLeadDays($col,$settingid,$orgid)
	{
		$name=0;
		
		$sql = "SELECT $col FROM SettingChild WHERE SettingId = ? and OrganizationId=?";
				
		$query = $this->db->prepare($sql);
		$query->execute(array($settingid,$orgid));
		
		while($row = $query->fetch())
		{
			$name= $row->$col;
		}
		
		return $name;
	}
	public function getSeniorIds($empid, $orgid)
	{
		$ids = array();
		$index=0;
		$ids[$index++] = $empid;
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->ReportingTo;
					}else{
						$parentid .= ", ".$row1->ReportingTo;
					}
					
					$ids[$index++] = $row1->ReportingTo;					
					
				}
				
			}
		}
			return $ids;
	}
	
	public function getSeniorId($empid, $orgid)
	{
		$seniorid = "0";
		$index=0;
		$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id = ?  and  DOL='0000-00-00' ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $orgid, $empid ));
		$parentid="";
		while($row1 = $query1->fetch())
		{
			$seniorid = $row1->ReportingTo;
				
		}
		return $seniorid;
	}
	
	public function getAssessmentDesignationEmployee($empid, $desigid, $orgid)
	{
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id, ReportingTo, Designation FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->ReportingTo;
					}else{
						$parentid .= ", ".$row1->ReportingTo;
					}
					
					if($row1->Designation==$desigid){
						return $row1->Id;					
					}
					
				}
				
			}
		}
			return 0;
	}
	
	////////////////CREATE LEAVE HISTORY OF EMPLOYEES////////////
	
	/*public function CreateLeaveHistory1($orgid)
	{
		
		$sql2 = "Select Id, StartDate, EndDate from FiscalMaster where FiscalSts=1 and OrganizationId=?";
		$query2 = $this->db->prepare($sql2);
		$query2->execute(array( $orgid));
			
		if($query2->rowCount()>0){
			
			$row2=$query2->fetch();
			//$fiscalid = $row2->Id;	
			$fiscalid = 1;	
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $religion=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $religionflg=false; $halfdays=0; $workingdays=0;
		$balance=0;
		try{
		$sql2 = "SELECT Id, MaritalStatus, Gender, Division, Department, Designation, Grade, Religion, TotalExp, WorkingDays FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00'";
        $query2 = $this->db->prepare($sql2);
		$query2->execute(array( $orgid));
		while($row1 = $query2->fetch())
		{
			$mid=$row1->Id;
			$division=$row1->Division;
			$department=$row1->Department; 
			$designation=$row1->Designation; 
			$grade=$row1->Grade; 
			$religion=$row1->Religion; 
			$gender=$row1->Gender; 
			$marital=$row1->MaritalStatus;
			$workingdays=$row1->WorkingDays;
			$workingdays=substr_count($workingdays, '1');
			$halfdays=	substr_count($row1->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);
		
		
			$annualid =0; $annualcount =0;
				
			
			$sql = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() AND WorkingDays= $workingdays and AnnualLeaveSts=1 ";
			$query = $this->db->prepare($sql);
			try{				
				$query->execute(array($orgid));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$e->getMessage();
			}
			if($count>=1)
			{
				$fiscaldata=array();
				while($row = $query->fetch())
				{
					$divisionflg=true;
					$departmentflg=true; 
					$designationflg=true; 
					$gradeflg=true; $religionflg=true;
					$genderflg=true; $maritalflg=true;
					
					//$fiscalid = Utils::getFiscalId(date('Y-m-d'), $this->db);
					
					$employeeusedleave=0;
					
					
					$sql3 = "Select * from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.PaySts=1 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array($row2->StartDate, $row2->EndDate, $orgid, $mid, $row->Id));
					while($row3=$query3->fetch()){
						if($row3->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					
					if($row->LeaveUsableSts==1){
						if($row->DivisionId>0){
							if($row->DivisionId==$division){
								$divisionflg=true;
							}else{$divisionflg=false;}
						}
						if($row->DepartmentIds>0){
							if($row->DepartmentIds==$department){
								$departmentflg=true; 
							}else{$departmentflg=false; }
						}
						if($row->DesignationIds>0){
							if($row->DesignationIds==$designation){
								$designationflg=true; 
							}else{$designationflg=false; }
						}
						if($row->GenderId>0){
							if($row->GenderId==$gender){
								$genderflg=true;
							}else{$genderflg=false;}
						}
						if($row->MaritalId>0){
							if($row->MaritalId==$marital){
								$maritalflg=true;
							}else{$maritalflg=false;}
						}
						if($row->GradeId>0){
							if($row->GradeId==$grade){
								$gradeflg=true; 
							}else{$gradeflg=false; }
						}
						if($row->ReligionId>0){
							if($row->ReligionId==$religion){
								$religionflg=true; 
							}else{$religionflg=false; }
						}
					}elseif($row->LeaveUsableSts==2){
						$divisionflg=false;
						$departmentflg=false; 
						$designationflg=false; 
						$gradeflg=false; 
						$genderflg=false; $maritalflg=false;
						$religionflg=false; 
						
						if($row->EmployeeIds!="")
						{
							$temp = explode(",", $row->EmployeeIds);
							for($i=0; $i<count($temp); $i++)
							{
								if($mid==$temp[$i]){
									$divisionflg=true;
									$departmentflg=true; 
									$designationflg=true; 
									$gradeflg=true; $religionflg=true;
									$genderflg=true; $maritalflg=true;
									break;
								}
								
							}
						}					
					}
					$annual=true;
					if($row->AnnualLeaveSts==1){
							if($row->WorkingDays ==$workingdays){
								$annual=true;
							}else{$annual=false;}
					}
					if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg && $annual && $religionflg)
					{
						if($row->AnnualLeaveSts==1){
							if($row->WorkingDays ==$workingdays){
								++$annualcount;
							}
						}
						$leftleave = $row->LeaveDays-$employeeusedleave;
						
						if($leftleave>0)
						{
							
							$sql3 = "SELECT * FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array( $orgid,$mid,$fiscalid));
							if($query3->rowCount()>0){
							
								$sql1 = "UPDATE LeaveHistory SET LeaveAllotted=?, BalanceLeave=?, UsedLeave=?, FiscalId=?, TotalLeave=? WHERE OrganizationId = ? and EmployeeId =? ";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($row->LeaveDays, $leftleave, $employeeusedleave, $fiscalid, 0, $orgid, $mid));
							
							}else{
							
								$fid=0;
								$cf=0;
								//////find out last fiscal year with current fiscal year's start date///////
								$enddate=date("Y-m-d", strtotime(date($row2->StartDate)." , -1 days "));
								$sql2 = "Select Id from FiscalMaster where OrganizationId=? and EndDate=?";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array( $orgid,$enddate));
									
								if($r1=$query2->fetch()){
									$fid=$r1->Id;
								}
								$sql3 = "SELECT BalanceLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
								$query3 = $this->db->prepare($sql3);
								$query3->execute(array( $orgid,$mid,$fid));
								if($r2=$query3->fetch()){
									$cf=$r2->BalanceLeave;
								}
								
								$sql1 = "INSERT into LeaveHistory ( EmployeeId, LeaveAllotted, BalanceLeave, UsedLeave, FiscalId, OrganizationId, TotalLeave) values(?, ?, ?, ?, ?, ?, ?)";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($mid,$row->LeaveDays, $leftleave,$employeeusedleave,$fiscalid ,$orgid,$cf));
							}
						}
					}
					
				}
			}
		}
		}catch(Exception $e) {
			$e->getMessage();
		}		
	}			
	}*/
	
	
	
	/*for employee confirmation*/
	public function ProbationEnding($orgid)
	{
		$sql = "SELECT Id, FirstName, LastName, Date_add(doj, interval ProvisionPeriod month ) as dateofconfirm FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' and DOC='0000-00-00' and Date_add(doj, interval ProvisionPeriod month )<=curdate()";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		$alert=$this->getLeadDays("NotifyAlert",15,$orgid);
		$mailsend=$this->getLeadDays("SendMail",15,$orgid);
			
		while($row= $query->fetch())
		{
			//////////////  UPDATING DATE OF CONFIRMATION FIELD ON COMPLETION OF PROBATION PERIOD /////////
			$sql1 = "UPDATE EmployeeMaster SET DOC=?,EmployeeStatus=5 WHERE OrganizationId = ? and Id =? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->dateofconfirm, $orgid, $row->Id));
			
			//////////////  CREATING HISTORY FOR THE EMPLOYEE  ////////////////////	
			$title="Confirmation";	
			//$msg="You have completed your probation period, now you confirmed on ". date("d M, Y", strtotime(date($row->dateofconfirm)));	
			$msg="You have completed your probation period and now become a confirmed employee";	
			$sql1="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Id, $title,$row->dateofconfirm, $msg, $orgid));
			
			
			///////////////   CREATING NOTIFICATION FOR THE EMPLOYEE RELATED TO EMPLOYEE CONFIRMATION  /////////
			$title="Employee Confirmation";	
			$name = ucwords(strtolower($row->FirstName." ".$row->LastName));
			$senior = $this->getSeniorId($row->Id, $orgid);
			$hr =  $this->getHR($orgid);
			$empids = implode($hr,",").",".$senior.",".$row->Id;
			$mdate = date("Y-m-d");
			$mid = $senior;
			$msg="$name has completed his/her probation period and has got confirmed on ". date("d M, Y", strtotime(date($row->dateofconfirm)));	
			$empids =explode(",",$empids);
			
				for($i=0;$i<count($empids);$i++)
				{
					if($alert){
						$this->CreateNotification($title,$msg,$orgid,$empids[$i]);
					}
					if($mailsend){
						$toemail=Utils::getName($empids[$i], 'EmployeeMaster','CompanyEmail',$this->db);
						Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
					}
				}
			
			/* $sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2)); */
		}
	}
	
	public function ApprovalEscalation($orgid)
	{
		$desig=0; 
		$escl=3; $mdate=date('Y-m-d');
		$con=0;
		$alert=$this->getLeadDays("NotifyAlert",16,$orgid);
		$mailsend=$this->getLeadDays("SendMail",16,$orgid);
							
		//////ProcessType -> 1 for leave, 2 for salary advance, 3 for document request, 4 for resignation, 5 for termination//////////
		$hr1=$this->getHR($orgid);
		$hr=implode(',',$hr1);
		Utils::Trace("aa".$hr);
		if($hr=="")
			$hr="0";
		////////////to get hr///////
		$hronly="";
		$sql = "select EmployeeMaster.Id as empid from DesignationMaster,EmployeeMaster where DesignationMaster.Id=EmployeeMaster.Designation and DesignationMaster.HrSts=1 and EmployeeMaster.OrganizationId=? and DesignationMaster.OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $orgid,$orgid));
		while($r=$query->fetch()){
			$ids[] = $r->empid;
			if($hronly == "")
				$hronly = $r->empid;
			else
				$hronly .= ", ".$r->empid;
		}
		if($hronly=="")
			$hronly="0";
		////////////end to get hr///////
		
		/////////for leave approvals escalation///
		try{
		////leave status 1- reject ,2- approve , 3- pending////
		$sql = "SELECT Id,EmployeeId FROM EmployeeLeave WHERE OrganizationId = ? and LeaveStatus=3";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row= $query->fetch())
		{
			$sql1 = "SELECT Designation FROM EmployeeMaster where Id=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->EmployeeId,$orgid));
			if($row1=$query1->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql1 = "SELECT EscalationPeriod FROM ApprovalProcess where Designation=? and ProcessType=1 and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($desig,$orgid));
			if($row1=$query1->fetch())
			{
				$escl=$row1->EscalationPeriod;
			}
					
			if($escl>0){
				$createddate=date('Y-m-d');
				$sql1 = "SELECT ApprovalDate FROM LeaveApproval WHERE LeaveId =? and ApproverSts=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($row->Id));
				while($row1=$query1->fetch())
				{
					$createddate=$row1->ApprovalDate;
				}
				
					$sql1 = "SELECT CreatedDate,ApproverId FROM LeaveApproval WHERE LeaveId =? and ApproverSts=3 and ApproverId NOT IN ($hronly)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					$con=$query1->rowCount();
					if($con > 0){
						if($row1=$query1->fetch())
						{
							$createddate=$row1->CreatedDate;
							$appid=$row1->ApproverId;
						}
						
						$escldate=date("Y-m-d", strtotime("+".$escl." Day, ".date($createddate)));
						$curtime=strtotime($mdate);
						$esctime=strtotime($escldate);
						if(($curtime >= $esctime)){
							////////leave will get rejected if there no response given by approval on leave application////the default approval status due to escalation should always be 'Reject'/////
							
							/* $sql1 = "UPDATE EmployeeLeave set LeaveStatus=1 ,ApproverComment=? WHERE Id =?";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array("leave has crossed the approval period and has been escalated for approval",$row->Id));	 */

							 $sql1 = "UPDATE LeaveApproval set ApproverSts=2 ,ApproverComment=?,ApprovalDate=? WHERE LeaveId =? and ApproverSts=3 and ApproverId NOT IN ($hronly)";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array("leave has crossed the approval period and has been escalated for approval",$mdate,$row->Id));	
							$i=0;
							/* $sql1 = "SELECT Id FROM LeaveApproval WHERE LeaveId =? and ApproverSts=3";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($row->Id));
							$con=$query1->rowCount();
							if($con == 0){	
								if(count($hr1)>0){
									$sql2 = "INSERT INTO LeaveApproval ( LeaveId, ApproverId, ApproverSts, CreatedDate , OrganizationId) VALUES (?, ?, ?, ?, ?)";
									$query2 = $this->db->prepare($sql2);
									$query2->execute(array($row->Id, $hr1[0], 3, $mdate, $orgid));
								}
							}  */
							//////////////  CREATING NOTIFICATION FOR THE EMPLOYEE IF ESCALATION PERIOD IS EXCEED ////////////////////
							//$hr =  $this->getHR($orgid);
							$empids = $appid;
							$emp=Utils::getEmployeeName($row->EmployeeId,$this->db);
							$title="Leave Escalated";	
							$msg=$emp."'s leave has crossed the approval period and has been escalated for approval";
							if($alert){
							$this->CreateNotification($title,$msg,$orgid, $empids);	
							}
							if($mailsend){
								$toemail=Utils::getName($empids, 'EmployeeMaster','CompanyEmail',$this->db);
								Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
							}
							/* $sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate,  StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +5 days ")), 2,2)); */
						}
					}
			}
		}
		}catch(Exception $e) {
			$e->getMessage();
		}
		
		$desig=0; 
		$escl=3; 
		
		///////////////for personal loan approvals escalation///////
		$sql = "SELECT Id,EmployeeId FROM SalaryAdvance WHERE OrganizationId = ? and LeaveStatus=3";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row= $query->fetch())
		{
			$sql1 = "SELECT Designation FROM EmployeeMaster where Id=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->EmployeeId,$orgid));
			if($row1=$query1->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql1 = "SELECT EscalationPeriod FROM ApprovalProcess where Designation=? and ProcessType=2 and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($desig,$orgid));
			if($row1=$query1->fetch())
			{
				$escl=$row1->EscalationPeriod;
			}
			if($escl>0){
				$createddate=date('Y-m-d');
				$sql1 = "SELECT ApprovalDate FROM SalaryApproval WHERE SalaryAdvanceId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($row->Id));
				while($row1=$query1->fetch())
				{
					$createddate=$row1->ApprovalDate;
				}
				
					$sql1 = "SELECT CreatedDate,ApproverId FROM SalaryApproval WHERE SalaryAdvanceId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($row1=$query1->fetch())
					{
						$createddate=$row1->CreatedDate;
						$appid=$row1->ApproverId;
					}
				
				$escldate=date("Y-m-d", strtotime("+".$escl." Day, ".date($createddate)));
				$curtime=strtotime($mdate);
				$esctime=strtotime($escldate);
				if($curtime >= $esctime){
					$sql1 = "UPDATE SalaryAdvance set LeaveStatus=1 ,Remarks=? WHERE Id =?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Personal Loan request has crossed the approval period and has been escalated for approval",$row->Id));
					/* $sql1 = "UPDATE SalaryApproval set LeaveStatus=2 ,ApproverComment=?,ApprovalDate=? WHERE ApproverId=? and SalaryAdvanceId =? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Personal Loan request is approve because escalation period is over",$mdate,$appid,$row->Id));	
					
					$sql1 = "SELECT Id FROM SalaryApproval WHERE SalaryAdvanceId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($query1->rowCount()==0)
					{
						$sql1 = "UPDATE SalaryAdvance set LeaveStatus=2 ,Remarks=? WHERE Id =? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array("Personal Loan request is approve because escalation period is over",$row->Id));	
						
					} */
					
					
					//////////////  CREATING NOTIFICATION FOR THE EMPLOYEE IF ESCALATION PERIOD IS EXCEED ////////////////////
					//$hr =  $this->getHR($orgid);
					$empids = $hr.",".$appid;
					$emp=Utils::getEmployeeName($row->EmployeeId,$this->db);
					$title="Personal Loan request Rejected";	
					$msg=$emp."'s Personal Loan request has crossed the approval period and has been escalated for approval";	
					
					$empids =explode(",",$empids);
					for($i=0;$i<count($empids);$i++)
					{
						if($alert){
							$this->CreateNotification($title,$msg,$orgid, $empids[$i]);
						}
						if($mailsend){
							$toemail=Utils::getName($empids[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
					}
					
					/* $sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate,  StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +5 days ")), 2,2)); */
				}
			
			}
		}
		
		$desig=0; 
		$escl=3; 
		///////////////for document request approvals escalation///////
		$sql = "SELECT Id,EmployeeId FROM DocumentReleaseMaster WHERE OrganizationId = ? and ApproverSts=3";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row= $query->fetch())
		{
			$sql1 = "SELECT Designation FROM EmployeeMaster where Id=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->EmployeeId,$orgid));
			if($row1=$query1->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql1 = "SELECT EscalationPeriod FROM ApprovalProcess where Designation=? and ProcessType=3 and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($desig,$orgid));
			if($row1=$query1->fetch())
			{
				$escl=$row1->EscalationPeriod;
			}
			if($escl>0){
				$createddate=date('Y-m-d');
				$sql1 = "SELECT ApprovalDate FROM DocumentApproval WHERE DocumentId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($row->Id));
				while($row1=$query1->fetch())
				{
					$createddate=$row1->ApprovalDate;
				}
				
					$sql1 = "SELECT CreatedDate,ApproverId FROM DocumentApproval WHERE DocumentId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($row1=$query1->fetch())
					{
						$createddate=$row1->CreatedDate;
						$appid=$row1->ApproverId;
					}
				
				$escldate=date("Y-m-d", strtotime("+".$escl." Day, ".date($createddate)));
				$curtime=strtotime($mdate);
				$esctime=strtotime($escldate);
				if($curtime >= $esctime){
					$sql1 = "UPDATE DocumentReleaseMaster set ApproverSts=1 ,Remarks=? WHERE Id =?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Document request has crossed the approval period and has been escalated for approval",$row->Id));
					/* $sql1 = "UPDATE DocumentApproval set LeaveStatus=2 ,ApproverComment=?,ApprovalDate=? WHERE ApproverId=? and DocumentId =? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Document release request is approve because escalation period is over",$mdate,$appid,$row->Id));	
					
					$sql1 = "SELECT Id FROM DocumentApproval WHERE DocumentId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($query1->rowCount()==0)
					{
						$sql1 = "UPDATE DocumentReleaseMaster set ApproverSts=2 ,Remarks=?,ApproveDate=? WHERE Id =? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array("Document release request is approve because escalation period is over",$mdate,$row->Id));	
						
					}
					 */
					//////////////  CREATING NOTIFICATION FOR THE EMPLOYEE IF ESCALATION PERIOD IS EXCEED ////////////////////
					//$hr =  $this->getHR($orgid);
					$empids = $hr.",".$appid;
					$emp=Utils::getEmployeeName($row->EmployeeId,$this->db);
					$title="Document request Rejected";	
					$msg=$emp."'s Document request has crossed the approval period and has been escalated for approval";
					
					$empids =explode(",",$empids);
					for($i=0;$i<count($empids);$i++)
					{
						if($alert){
							$this->CreateNotification($title,$msg,$orgid, $empids[$i]);
						}
						if($mailsend){
							$toemail=Utils::getName($empids[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
					}
					
					/* $sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate,  StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +5 days ")), 2,2)); */
				}
			
			}
		}
		
		
		$desig=0; 
		$escl=3; 
		///////////////for resignation/termination approvals escalation///////
		$sql = "SELECT Id,EmployeeId FROM SeveranceMaster WHERE OrganizationId = ? and SeveranceStatus=3 and EmployeeStatus<>3";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row= $query->fetch())
		{
			$sql1 = "SELECT Designation FROM EmployeeMaster where Id=? and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->EmployeeId,$orgid));
			if($row1=$query1->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql1 = "SELECT EscalationPeriod FROM ApprovalProcess where Designation=? and ProcessType in (4,5) and OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($desig,$orgid));
			if($row1=$query1->fetch())
			{
				$escl=$row1->EscalationPeriod;
			}
			if($escl>0){
				$createddate=date('Y-m-d');
				$sql1 = "SELECT ApprovalDate FROM ResignationApproval WHERE ResignationId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($row->Id));
				while($row1=$query1->fetch())
				{
					$createddate=$row1->ApprovalDate;
				}
				
					$sql1 = "SELECT CreatedDate,ApproverId FROM ResignationApproval WHERE ResignationId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($row1=$query1->fetch())
					{
						$createddate=$row1->CreatedDate;
						$appid=$row1->ApproverId;
					}
				
				$escldate=date("Y-m-d", strtotime("+".$escl." Day, ".date($createddate)));
				$curtime=strtotime($mdate);
				$esctime=strtotime($escldate);
				if($curtime >= $esctime){
					$sql1 = "UPDATE SeveranceMaster set SeveranceStatus=1 ,Message=? WHERE Id =?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Severance request has crossed the approval period and has been escalated for approval",$row->Id));
					/* $sql1 = "UPDATE ResignationApproval set LeaveStatus=2 ,ApproverComment=?,ApprovalDate=? WHERE ApproverId=? and ResignationId =? ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array("Severance request is approve because escalation period is over",$mdate,$appid,$row->Id));	
					
					$sql1 = "SELECT Id FROM ResignationApproval WHERE ResignationId =? and LeaveStatus=3";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($row->Id));
					if($query1->rowCount()==0)
					{
						$sql1 = "UPDATE SeveranceMaster set SeveranceStatus=2 ,Message=? WHERE Id =? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array("Severance request is approve because escalation period is over",$row->Id));	
						
					} */
					
					//////////////  CREATING NOTIFICATION FOR THE EMPLOYEE IF ESCALATION PERIOD IS EXCEED ////////////////////
					//$hr =  $this->getHR($orgid);
					$empids = $hr.",".$appid;
					$emp=Utils::getEmployeeName($row->EmployeeId,$this->db);
					$title="Severance request Rejected";	
					$msg=$emp."'s Severance request has crossed the approval period and has been escalated for approval";
									
					$empids =explode(",",$empids);
					for($i=0;$i<count($empids);$i++)
					{
						if($alert){	
							$this->CreateNotification($title,$msg,$orgid, $empids[$i]);
						}
						if($mailsend){
							$toemail=Utils::getName($empids[$i], 'EmployeeMaster','CompanyEmail',$this->db);
							Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
						}
					}
					
					/* $sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate,  StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +5 days ")), 2,2)); */
				}
			}
		}
	}
	public function GenerateLeaveHistory($orgid)
	{
		$count=0;
		try{
			$sql = "Select Id, StartDate, EndDate from FiscalMaster where FiscalSts=1 and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid));
				
			if($query->rowCount()>0){
				
				$row=$query->fetch();
				$fiscalid = $row->Id;
				$startdate = $row->StartDate;
				$enddate = $row->EndDate;
				$this->db->beginTransaction();	
				try{
					$sql1 = "SELECT Id,DOJ FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00'";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid));
					while($row1 = $query1->fetch())
					{
						
						$leavetype=$this->getEmpAnnualLeavetype($row1->Id,$orgid);
						if($leavetype !=0){
							//$this->updateLastyearLeavests($leavetype,$orgid,$row1->Id,$fiscalid,$row1->DOJ);
							$count+=$this->createLeaveHistory($leavetype,$orgid,$row1->Id,$fiscalid,$startdate,$enddate,$row1->DOJ);
							
						}
					}
					//echo $count;
					$this->db->commit(); 
				 
				}catch(PDOException $e)
				{
					
					$this->db->rollBack();
					//$errorMsg = 'Message: ' .$e->getMessage();
				}
				
			}
		}catch(Exception $e) {
			$e->getMessage();
		}
	}
	
	public function getEmpAnnualLeavetype($empid,$orgid)
	{
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $annualleave=0; $halfdays=0;
		
		$sql="select Division, Department, Designation, Grade, Gender, MaritalStatus ,WorkingDays, Shift from EmployeeMaster where OrganizationId=? and Id=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid,$empid));
		while($row=$query->fetch()){
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=substr_count($row->WorkingDays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);	
			
			$workingdays=$this->averageWorkingDayWeek($row->Shift, $orgid);
			$sqlleave = "SELECT * FROM LeaveMaster WHERE OrganizationId = ? and LeaveApply <= CURDATE() and WorkingDays =$workingdays and AnnualLeaveSts=1";
			$queryleave = $this->db->prepare($sqlleave);
			$queryleave->execute(array($orgid));
			$count1 =  $queryleave->rowCount();
			if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						
						$employeeusedleave=0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							if($rowleave->GradeId>0){
								if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; }
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							$annualleave = (int)$rowleave->Id;
							break;
						}
					}
				}
		}	
			return $annualleave;
	}
	
	public function carryforwardedLeave($mid,$orgid,$fiscalid)
	{
		
		try{
			$lastfiscalid=0;
			$sqllast="SELECT Id FROM FiscalMaster WHERE OrganizationId=? and Id<>$fiscalid Order BY Id DESC LIMIT 1";
			$querylast=$this->db->prepare($sqllast);
			$querylast->execute(array($orgid));
			if($row=$querylast->fetch())
			{
				$lastfiscalid=$row->Id;
			}
			
			$cf=0; $c1=0;$c2=0;$c3=0;
			
			$sql3 = "SELECT BalanceLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $orgid,$mid,$lastfiscalid));
			if($r2=$query3->fetch()){
				$cf=$r2->BalanceLeave;/////this year's balance leave
				//$c2=$r2->TotalLeave;////////this year's carry forward leave
				//$c3=$r2->AdvanceLeave;/////this year's advance leave
				//$cf=$c1;//$c1+$c2-$c3;
			}
		}catch(Exception $e) {
			$e->getMessage();
		}
		return $cf;
	}
	
	public function createLeaveHistory($leavetype,$orgid,$mid,$fiscalid,$startdate,$enddate,$doj)
	{
		//$time1 = microtime(true);
		 $fiscalenddate=''; $leavealotted=0; $leaveforcal=0;
		$employeeusedleave =0; $entitled=0; $carryforwarded=0; $advance =0; $unpaid=0; 
		$totalcf=0; $carryforward=0; $cfleave=0;
		$strdateadv="";
		$enddateadv="";
		
		$mdate=date('Y-m-d');
		
		try{
			$anniversaryyearsts=0;
			$sql="select LeaveDays,CarryForward from LeaveMaster where Id=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavetype, $orgid));
			while($row=$query->fetch()){
				$leavealotted=$row->LeaveDays;
				$leaveforcal=$row->LeaveDays;
				$leaveforcal=$row->LeaveDays;
				$anniversaryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
			}
			$start = strtotime($doj);
			$end = strtotime(date('Y-m-d'));
			$days_between = floor(abs($end - $start) / 86400);
			$annualsts=1;
			$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
			////////////calculate leave entitle for annual leave calender days,there leave days are 30////////////
			///new code add on 8 june 2017//////////
			//////if leave is for anniversary year///then we will calculate the leave from date of joining till now///////
			if($anniversaryyearsts ==1)
			{
				$annualsts=0;
				$leavealotted1=floor(($days_between * $leaveforcal)/365);
				$leavealotted=$leavealotted1;
				
				//////EMPLOYEES WITH 30 DAY CALENDER DAYS HAVE CALCULATION BASED ON THEIR ANNIVERSARY YEAR,THERE IS NO RELATION WITH FISCAL YEAR ,SO I DIVIDED THEM IN 2 CATEGORY 1. EMPLOYEE WITH LESS THEN 2 YEAR EXPERIENCE, AND 2. MORE THEN 2 YEAR EXPERIENCE//////
				 if($days_between < $twoyearsdays)
				{
				//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
					/* $leavealotted1=floor(($days_between * $leaveforcal)/365);
					$leavealotted=$leavealotted1; */
					$startdate=$doj;
					$enddate=$mdate;
				}else{
				/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
				
					///////////if employee have more than 2 year of experience then we will count the leaves from starting of software///that is april 2015///
					$start = strtotime($doj);
					$end = strtotime(date("2015-04-01"));
					if($end>$start){
						//$days_between = floor(($end - $start) / 86400);
						//$leavealotted1=floor(($days_between * $leaveforcal)/365);
						//$employeeusedleave = $employeeusedleave + $leavealotted1;
					}
					
					$startdate=date("2015-04-01");
					$enddate=$mdate;
					
					
					
					/* $myear=date('Y');
					$anniversaryyear=date('m-d',strtotime(date($doj)));
					$enddate=$myear.'-'.$anniversaryyear;
					$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
					$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
					if(strtotime($mdate) > strtotime($enddate))
					{
						$startdate=$myear.'-'.$anniversaryyear;
						$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
					} */
					
					
				}
				
				$startdate=$doj;
				$enddate=$mdate;
			
			}elseif((strtotime($doj) > strtotime($startdate)) && $anniversaryyearsts !=1){
				//////////////////if an employee join organization in mid of fiscal year then leave days will calculated according to date of joining and end of fiscal year/////////////////
				//$sql="SELECT * FROM FiscalMaster where '$doj' between '$startdate' and '$enddate'";
				//$query = $this->db->prepare($sql);
				//$query->execute();
				//if($query->rowCount() >0 )
				//{
					$start = strtotime($doj);
					$end = strtotime($enddate);
					$days_between = floor(abs($end - $start) / 86400);
					$leavealotted1=floor(($days_between * $leavealotted)/365);
					$leavealotted=$leavealotted1;
				//}
			}
			
			//////////this code belongs to advance leave ,if there are advance leave in previous year taken by employee we have to add it to employee current used leave////////
			$strdateadv=date('Y-m-d',strtotime("- 1 year".date($startdate)));
			$enddateadv=date('Y-m-d',strtotime("- 1 year".date($enddate)));
			$sql = "Select Advance,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 ";
			$query = $this->db->prepare($sql);
			$query->execute(array($strdateadv, $enddateadv, $orgid, $mid, $leavetype));
			while($row3=$query->fetch()){
				if($row3->Advance == 1 && $row3->HalfDaySts == 1){
					$employeeusedleave = $employeeusedleave + 0.5;
				}
				elseif($row3->Advance == 1 && $row3->HalfDaySts != 1){
					$employeeusedleave++;
				}
			}
			///////////////////////////////////
			$sql = "Select Entitled,CarriedForward,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 ";
			$query = $this->db->prepare($sql);
			$query->execute(array($startdate, $enddate, $orgid, $mid, $leavetype));
			while($row3=$query->fetch()){
				if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
					$employeeusedleave = $employeeusedleave + 0.5;
				}
				elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
					$employeeusedleave++;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts == 1 ){
					$carryforwarded=$carryforwarded+0.5;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts != 1 ){
					$carryforwarded++;
				}
								
			}
			
				
				$leftleave = $leavealotted-$employeeusedleave;
				///HR will get notification when an employee's leave balance (accrual-leave utilized) reaches 60./////////
				if($leftleave >= 60 && $anniversaryyearsts ==1)
				{
					//$totalcf = $leavealotted;
					//$leavealotted = 0;
					/*$name=Utils::getEmployeeName($mid,$this->db);
					$title="60 Leave Accrued";
					$msg=$name." has accrued 60 leave!";
					$hrarr=$this->getHR($orgid);
					$empids=implode(',',$hrarr);
					
					 $sql="Select Id from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=? and CURDATE() between StartDate and EndDate";
					$query = $this->db->prepare($sql);
					$query->execute(array($title, $msg, $empids, $orgid));
					if($query->rowCount() == 0){
						$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +6 days ")), 2,2));
					} */
							
				}
					//echo 	$carryforwarded;
					/* if($mid==4335){
						echo "allot ".$leavealotted;
						echo "<br>used ".$employeeusedleave;
						echo "<br>left ".$leftleave;
					} */
				if($leftleave>=0)
				{
					//echo $fiscalid;
					
					$sql3 = "SELECT TotalLeave,ResetLeave,CFLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array( $orgid,$mid,$fiscalid));
					if($query3->rowCount()>0){
						$row3=$query3->fetch();
					////////if leave allotted is 30 and experience is less then 2 years then there is no requirement of carry forward leave calculation////////// 
						if($anniversaryyearsts==1 && ($days_between <= $twoyearsdays))
						{
							/////////if an employee completes 2 years then left leave will cf to the current year///////
								///in any employee's leave encash/lapsed then it will deducted from balance leave////////
								 $leftleave=$leftleave-$row3->ResetLeave;
								$cfleave=$leftleave;
								if($cfleave >60)
								$cfleave=60; 
							
						}else{
							$encashleave=$row3->ResetLeave;
							$leftleave=$leftleave;//-$row3->ResetLeave;
							$cfleave=$row3->CFLeave;
							$totalcf=$cfleave-$carryforwarded-$encashleave;//-$encashleave;
						}
						$leftleave=abs($leftleave);		
						$totalcf=abs($totalcf);		
						$sql1 = "UPDATE LeaveHistory SET LeaveAllotted=?, BalanceLeave=?, UsedLeave=?,TotalLeave=?,CFLeave=?, AnnualSts=? WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($leavealotted, $leftleave, $employeeusedleave,$totalcf,$cfleave,$annualsts, $orgid, $mid,$fiscalid));
						
					}else{
						if($anniversaryyearsts == 1 && ($days_between < $twoyearsdays))
						{
						}else{
							$totalcf=$this->carryforwardedLeave($mid,$orgid,$fiscalid);
							$startdateold=date("Y-m-d", strtotime(date($startdate)." , -1 year "));
							$enddateold=date("Y-m-d", strtotime(date($startdate)." , -1 days "));
							
							$sql = "Select Advance,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2";
							$query = $this->db->prepare($sql);
							$query->execute(array($startdateold, $enddateold, $orgid, $mid, $leavetype));
							while($row3=$query->fetch()){
								if($row3->Advance == 1 && $row3->HalfDaySts == 1 ){
									$advance=$advance+0.5;
									//$employeeusedleave=$employeeusedleave+0.5;
								}
								elseif($row3->Advance == 1 && $row3->HalfDaySts != 1 ){
									$advance=$advance+1;
									//$employeeusedleave=$employeeusedleave+1;
								}
												
							}
							//$totalcf=$carryforward-$carryforwarded;
						}	
						$sql1 = "INSERT into LeaveHistory ( EmployeeId, LeaveAllotted, BalanceLeave, UsedLeave, FiscalId, OrganizationId, CFLeave,TotalLeave,AdvanceLeave,AnnualSts) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($mid,$leavealotted, $leftleave,$employeeusedleave,$fiscalid ,$orgid,$totalcf,$totalcf,$advance,$annualsts));
					}
				}
						
		
		}catch(Exception $e) {
			$e->getMessage();
		}
	return 1;	
	}
	public function updateLastyearLeavests($leavetype,$orgid,$mid,$fiscalid,$doj)
	{
		//$time1 = microtime(true);
		$fiscalenddate=''; $leavealotted=0; $leaveforcal=0;
		$employeeusedleave =0; $entitled=0; $carryforwarded=0; $advance =0; $unpaid=0; 
		$totalcf=0; $carryforward=0; $cfleave=0;
		$strdateadv="";
		$enddateadv="";
		$lastfiscalid=0; $startdate=""; $enddate="";
		$sqllast="SELECT Id,StartDate,EndDate FROM FiscalMaster WHERE OrganizationId=? and Id<>$fiscalid Order BY Id DESC LIMIT 1";
		$querylast=$this->db->prepare($sqllast);
		$querylast->execute(array($orgid));
		if($row=$querylast->fetch())
		{
			$lastfiscalid=$row->Id;
			$startdate=$row->StartDate;
			$enddate=$row->EndDate;
		}
		$anniversryyearsts=0;
		$sql="select LeaveDays,CarryForward from LeaveMaster where Id=? and OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($leavetype, $orgid));
		while($row=$query->fetch()){
			$leavealotted=$row->LeaveDays;
			$leaveforcal=$row->LeaveDays;
			$anniversryyearsts=$row->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
		}
		$annualsts=1;
		if($anniversryyearsts ==1)
		{
			$annualsts=0;
		}
		$sql1 = "UPDATE LeaveHistory SET AnnualSts=? WHERE OrganizationId = ? and EmployeeId =? ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($annualsts, $orgid, $mid));
	}	
	public function updateLastyearLeave($leavetype,$orgid,$mid,$fiscalid,$doj)
	{
		//$time1 = microtime(true);
		$fiscalenddate=''; $leavealotted=0; $leaveforcal=0;
		$employeeusedleave =0; $entitled=0; $carryforwarded=0; $advance =0; $unpaid=0; 
		$totalcf=0; $carryforward=0; $cfleave=0;
		$strdateadv="";
		$enddateadv="";
		$lastfiscalid=0; $startdate=""; $enddate="";
		$sqllast="SELECT Id,StartDate,EndDate FROM FiscalMaster WHERE OrganizationId=? and Id<>$fiscalid Order BY Id DESC LIMIT 1";
		$querylast=$this->db->prepare($sqllast);
		$querylast->execute(array($orgid));
		if($row=$querylast->fetch())
		{
			$lastfiscalid=$row->Id;
			$startdate=$row->StartDate;
			$enddate=$row->EndDate;
		}
		
		
		$mdate=date($enddate);
		
		try{
			
			$sql="select LeaveDays,CarryForward from LeaveMaster where Id=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavetype, $orgid));
			while($row=$query->fetch()){
				$leavealotted=$row->LeaveDays;
				$leaveforcal=$row->LeaveDays;
			}
			$start = strtotime($doj);
			$end = strtotime(date($enddate));
			$days_between = floor(abs($end - $start) / 86400);
			$twoyearsdays=(365*2)+30;////ADD MORE 30 DAYS,FOR TAKE ACTION ON LEAVE///	
			////////////calculate leave entitle for annual leave calender days,there leave days are 30/////////
			if($leaveforcal ==30)
			{
				
				//////EMPLOYEES WITH 30 DAY CALENDER DAYS HAVE CALCULATION BASED ON THEIR ANNIVERSARY YEAR,THERE IS NO RELATION WITH FISCAL YEAR ,SO I DIVIDED THEM IN 2 CATEGORY 1. EMPLOYEE WITH LESS THEN 2 YEAR EXPERIENCE, AND 2. MORE THEN 2 YEAR EXPERIENCE//////
				
				if($days_between < $twoyearsdays)
				{
				//////////IN THIS CASE CALCULATION BASED ON DATE OF JOINING TILL NOW/////////
					$leavealotted1=floor(($days_between * $leaveforcal)/365);
					$leavealotted=$leavealotted1;
					$startdate=$doj;
					$enddate=$mdate;
				}else{
				/////////IN THIS CASE I FIND THE ANNIVERSARY YEAR OF EMPLOYEE OF THIS YEAR,AND CALCULATE LEAVE ,ON THIS BASIS////////
				
					$myear=date('Y',strtotime($mdate));
					$anniversaryyear=date('m-d',strtotime(date($doj)));
					$enddate=$myear.'-'.$anniversaryyear;
					$startdate=date('Y-m-d',strtotime("- 1 year".date($enddate)));
					if(strtotime($mdate) > strtotime($enddate))
					{
						$startdate=$myear.'-'.$anniversaryyear;
						$enddate=date('Y-m-d',strtotime("+ 1 year".date($startdate)));
					}
					
					
				}
			
			}
			
			//////////this code belongs to advance leave ,if there are advance leave in previous year taken by employee we have to add it to employee current used leave////////
			$strdateadv=date('Y-m-d',strtotime("- 1 year".date($startdate)));
			$enddateadv=date('Y-m-d',strtotime("- 1 year".date($enddate)));
			$sql = "Select Advance,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 ";
			$query = $this->db->prepare($sql);
			$query->execute(array($strdateadv, $enddateadv, $orgid, $mid, $leavetype));
			while($row3=$query->fetch()){
				if($row3->Advance == 1 && $row3->HalfDaySts == 1){
					$employeeusedleave = $employeeusedleave + 0.5;
				}
				elseif($row3->Advance == 1 && $row3->HalfDaySts != 1){
					$employeeusedleave++;
				}
			}
			//echo $startdate;
			//echo $enddate;
			
			///////////////////////////////////
			$sql = "Select Entitled,CarriedForward,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 ";
			$query = $this->db->prepare($sql);
			$query->execute(array($startdate, $enddate, $orgid, $mid, $leavetype));
			while($row3=$query->fetch()){
				if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
					$employeeusedleave = $employeeusedleave + 0.5;
				}
				elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
					$employeeusedleave++;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts == 1 ){
					$carryforwarded=$carryforwarded+0.5;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts != 1 ){
					$carryforwarded++;
				}
								
			}
			
				
				$leftleave = $leavealotted-$employeeusedleave;
					
					//echo 	$carryforwarded;
				if($leftleave>=0)
				{
					//echo $fiscalid;
					
					$sql3 = "SELECT TotalLeave,ResetLeave,CFLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array( $orgid,$mid,$lastfiscalid));
					if($query3->rowCount()>0){
						$row3=$query3->fetch();
					////////if leave allotted is 30 and experience is less then 2 years then there is no requirement of carry forward leave calculation////////// 
						if($leaveforcal == 30 && ($days_between <= $twoyearsdays))
						{
							/////////if an employee completes 2 years then left leave will cf to the current year///////
								///in any employee's leave encash/lapsed then it will deducted from balance leave////////
								$leftleave=$leftleave-$row3->ResetLeave;
								$cfleave=$leftleave;
								if($cfleave >60)
								$cfleave=60;
							
						}else{
							$encashleave=$row3->ResetLeave;
							$leftleave=$leftleave;//-$row3->ResetLeave;
							$cfleave=$row3->CFLeave;
							$totalcf=$cfleave-$carryforwarded-$encashleave;//-$encashleave;
						}
						$leftleave=abs($leftleave);		
						$totalcf=abs($totalcf);		
						$sql1 = "UPDATE LeaveHistory SET LeaveAllotted=?, BalanceLeave=?, UsedLeave=?,TotalLeave=?,CFLeave=? WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($leavealotted, $leftleave, $employeeusedleave,$totalcf,$cfleave, $orgid, $mid,$lastfiscalid));
						
						//////////update current year's carry forward leave////////
						
						$sql1 = "UPDATE LeaveHistory SET CFLeave=? WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($leftleave, $orgid, $mid,$fiscalid));
						
					}
				}
						
		
		}catch(Exception $e) {
			$e->getMessage();
		}
	return 1;	
	}
	
	
	public function createLeaveHistory1($leavetype,$orgid,$mid,$fiscalid,$startdate,$enddate,$doj)
	{
		//$time1 = microtime(true);
		 $fiscalenddate=''; $leavealotted=0; $leaveforcal=0;
		$employeeusedleave =0; $entitled=0; $carryforwarded=0; $advance =0; $unpaid=0; 
		$totalcf=0; $carryforward=0;
		
		$mdate=date('Y-m-d');
		
		try{
			
			$sql="select LeaveDays from LeaveMaster where Id=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavetype, $orgid));
			while($row=$query->fetch()){
				$leavealotted=$row->LeaveDays;
				$leaveforcal=$row->LeaveDays;
			}
			$start = strtotime($doj);
			$end = strtotime(date('Y-m-d'));
			$days_between = floor(abs($end - $start) / 86400);
			$twoyearsdays=(365*2)+30;	
			////////////calculate leave entitle for annual leave calender days,there leave days are 30/////////
			if($leaveforcal ==30)
			{
				
				//////find out employee who have more than two years experience in company,their leave eligibility will be according to fiscal year, and other then that less than 2 year experience employees eligibility will count according to DOJ////I add 30 in days because if any employee exceed 2 years from doj then the leave will be rest so for giving some time to take action on it,I add more 30 days//////
				
				if($days_between < $twoyearsdays)
				{
					$leavealotted1=floor(($days_between * $leaveforcal)/365);
					$leavealotted=$leavealotted1;
					$startdate=$doj;
				}
			
			}elseif(strtotime($doj) > strtotime($startdate)){
				//////////////////if an employee join organization in mid of fiscal year then leave days will calculated according to date of joining and end of fiscal year/////////////////
				//$sql="SELECT * FROM FiscalMaster where '$doj' between '$startdate' and '$enddate'";
				//$query = $this->db->prepare($sql);
				//$query->execute();
				//if($query->rowCount() >0 )
				//{
					$start = strtotime($doj);
					$end = strtotime($enddate);
					$days_between = floor(abs($end - $start) / 86400);
					$leavealotted1=floor(($days_between * $leavealotted)/365);
					$leavealotted=$leavealotted1;
				//}
			}
			
			
			$sql = "Select Entitled,CarriedForward,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2 ";
			$query = $this->db->prepare($sql);
			$query->execute(array($startdate, $enddate, $orgid, $mid, $leavetype));
			while($row3=$query->fetch()){
				if($row3->Entitled == 1 && $row3->HalfDaySts == 1){
					$employeeusedleave = $employeeusedleave + 0.5;
				}
				elseif($row3->Entitled == 1 && $row3->HalfDaySts != 1){
					$employeeusedleave++;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts == 1 ){
					$carryforwarded=$carryforwarded+0.5;
				}
				elseif($row3->CarriedForward == 1 && $row3->HalfDaySts != 1 ){
					$carryforwarded++;
				}
								
			}
				
				$leftleave = $leavealotted-$employeeusedleave;
				///HR will get notification when an employee's leave balance (accrual-leave utilized) reaches 60./////////
				if($leftleave >= 60 && $leaveforcal==30)
				{
					//$totalcf = $leavealotted;
					//$leavealotted = 0;
					$name=Utils::getEmployeeName($mid,$this->db);
					$title="60 Leave Accrued";
					$msg=$name." has accrued 60 leave!";
					$hrarr=$this->getHR($orgid);
					$empids=implode(',',$hrarr);
					
					/* $sql="Select Id from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=? and CURDATE() between StartDate and EndDate";
					$query = $this->db->prepare($sql);
					$query->execute(array($title, $msg, $empids, $orgid));
					if($query->rowCount() == 0){
						$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate,  LastModifiedDate, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mdate, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +6 days ")), 2,2));
					} */
							
				}
					//echo 	$carryforwarded;
						if($leftleave>=0)
						{
							//echo $fiscalid;
							
							$sql3 = "SELECT TotalLeave FROM LeaveHistory WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array( $orgid,$mid,$fiscalid));
							if($query3->rowCount()>0){
								$row3=$query3->fetch();
							////////if leave allotted is 30 and experience in less then 2 years then there is no requirement of carry forward leave calculation////////// 
								if($leaveforcal == 30 && ($days_between < $twoyearsdays))
								{
								}else{
									$totalcf=$this->carryforwardedLeave($mid,$orgid,$fiscalid);
									$totalcf=$totalcf-$carryforwarded;
								}							
								$sql1 = "UPDATE LeaveHistory SET LeaveAllotted=?, BalanceLeave=?, UsedLeave=?,TotalLeave=? WHERE OrganizationId = ? and EmployeeId =? and FiscalId=?";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($leavealotted, $leftleave, $employeeusedleave,$totalcf, $orgid, $mid,$fiscalid));
								
							}else{
								if($leaveforcal == 30 && ($days_between < $twoyearsdays))
								{
								}else{
									$totalcf=$this->carryforwardedLeave($mid,$orgid,$fiscalid);
									$startdateold=date("Y-m-d", strtotime(date($startdate)." , -1 year "));
									$enddateold=date("Y-m-d", strtotime(date($startdate)." , -1 days "));
									
									$sql = "Select Advance,HalfDaySts from EmployeeLeaveChild as empchild,EmployeeLeave as empleave where empchild.EmployeeLeaveId=empleave.Id and empchild.LossOfPay=0 and empchild.LeaveStatus=2 and (empchild.LeaveDay between ? and ?) and empleave.OrganizationId = ? and empleave.EmployeeId =? and empleave.LeaveTypeId=? and empleave.LeaveStatus=2";
									$query = $this->db->prepare($sql);
									$query->execute(array($startdateold, $enddateold, $orgid, $mid, $leavetype));
									while($row3=$query->fetch()){
										if($row3->Advance == 1 && $row3->HalfDaySts == 1 ){
											$advance=$advance+0.5;
										}
										elseif($row3->Advance == 1 && $row3->HalfDaySts != 1 ){
											$advance++;
										}
														
									}
									//$totalcf=$carryforward-$carryforwarded;
								}	
								$sql1 = "INSERT into LeaveHistory ( EmployeeId, LeaveAllotted, BalanceLeave, UsedLeave, FiscalId, OrganizationId, TotalLeave,AdvanceLeave) values(?, ?, ?, ?, ?, ?, ?, ?)";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($mid,$leavealotted, $leftleave,$employeeusedleave,$fiscalid ,$orgid,$totalcf,$advance));
							}
						}
						
		
		}catch(Exception $e) {
			$e->getMessage();
		}
	return 1;	
	}
	public function checkHoliday($leavefrom, $empid,$annaulsts)
	{
		if($annualsts){
			$sql = "SELECT Id, Name FROM HolidayMaster WHERE ? between DateFrom and DateTo";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavefrom ));
			if($query->rowCount()>0)
			{
				return false;
			}else{
				$sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
				 $query1 = $this->db->prepare($sql1);
				 $query1->execute(array( $empid ));			
				 $row1 = $query1->fetch();
				 $workingday = $row1->WorkingDays;
				 
				$temparr = explode(',',$workingday);
				$dw = date( "w", strtotime(date($leavefrom)));
				$date = "Leave Day";
				for($i=0; $i<count($temparr); $i++)
				{
					if($dw == $i){
						if($temparr[$i]==3){
							return false;
							break;
						}elseif($temparr[$i]==2){
							return false;
							break;
						}
					}
				}			
			}
			
			return true;
		}else{
			return true;
		}
	}
	
	////////////////////////////////////////////////////////////////////////
	public function getEmployeeLeftLeave($mid,$leavetype,$applydate)
    {
		$orgid=$_SESSION['ubihrm_org_id'];
		$count=0; $leftleave=0;
		$leaveid=0; $result=0;
			try{
				$fiscalid = Utils::getFiscalId($applydate, $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT Id  FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? and LeaveStatus=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $mid, $leavetype, $fiscalid));
				while($row1=$query1->fetch()){
					$leaveid.=','.$row1->Id;
				}
				$sql1 = "SELECT *  FROM LeaveMaster WHERE Id =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leavetype));
				while($row1=$query1->fetch()){
					$total=$row1->LeaveDays;
				}
				
					$sql = "SELECT *  FROM EmployeeLeaveChild WHERE EmployeeLeaveId in ($leaveid) and LeaveTypeId=?  and LeaveStatus=2";
					$query = $this->db->prepare($sql);
					$query->execute(array( $leavetype));
					while($row1=$query->fetch())
					{
						if($row1->HalfDaySts == 1){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					$leftleave = $total-$employeeusedleave;
					if($leftleave>0)
					{
						$result=$leftleave;
					}
				
				
				
		}catch(Exception $e) {
			
			$e->getMessage();
		}
		
		
		return $result;
    }
	
	public function updatejoininghistory()
	{
		$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = 1 and DOL='0000-00-00' and DOC!='0000-00-00' ";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row= $query->fetch())
		{
			$division=Utils::getName($row->Division,'DivisionMaster','Name',$this->db);
			$desig=Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
			$sql1 = "SELECT * FROM JobModificationMaster WHERE ApplySts=1 and EmployeeId=? and Id in (select JobId from JobModificationChild where Field='Designation')";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array( $row->Id ));
			if($row1 = $query1->fetch())
			{
				$desig=Utils::getName($row1->OldValue,'DesignationMaster',$this->db);
			}
			$title="Joining";	
			//$msg="You have completed your probation period, now you confirmed on ". date("d M, Y", strtotime(date($row->dateofconfirm)));	
			$msg="Joined $division on ".date("dS F, Y", strtotime($row->DOJ))." as $desig ";	
			$sql1="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($row->Id, $title,$row->DOJ, $msg, $orgid));
		
		}
		
	}
	
	///////work anniversary/////////
	public function WorkAnniversary($orgid)
	{
		$sql = "SELECT Id, FirstName, LastName, EmployeeCode, CompanyEmail, DOJ, YEAR(curdate())-YEAR(DOJ) as completedyears, datediff( DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj)+ IF(DAYOFYEAR(CURDATE()) >= DAYOFYEAR(doj),1,0) YEAR), curdate()) as diff FROM EmployeeMaster WHERE OrganizationId=? and  DATE_ADD(doj, INTERVAL YEAR(CURDATE())-YEAR(doj) + IF(DAYOFYEAR(CURDATE()) > DAYOFYEAR(doj),1,0)YEAR) BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 0 DAY) and YEAR(curdate())-YEAR(DOJ) <> 0  and  DOL='0000-00-00'";
		$query = $this->db->prepare($sql);
		$query->execute(array($orgid));
		while($row= $query->fetch())
		{
			//Utils::Trace("aaya");
			$mdate = date("Y-m-d");
			$name = ucwords(strtolower($row->FirstName." ".$row->LastName.""));
			$senior = $this->getSeniorId($row->Id, $orgid);
			$hr =  $this->getHR($orgid);
			$alert=$this->getLeadDays("NotifyAlert",17,$orgid);
			$mailsend=$this->getLeadDays("SendMail",17,$orgid);
			
			$mid = $senior;
			$dat = ($row->diff==0 || $row->diff==365)?"Today":(($row->diff==1)?"Tomorrow":date("d F", strtotime($row->DOJ)));
			$title="Work Anniversary";
			$msg="Dear ".$name.", Congratulations on completing ".$row->completedyears." years with us. Wish you continued success and many more years with us!";	
			$sqlc = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=?";
			$queryc = $this->db->prepare($sqlc);
			$queryc->execute(array( $orgid,$row->Id,$title,$msg, $mdate));
			$countc=$queryc->rowCount();
			if($countc == 0){
				
				if($alert){
					$this->CreateNotification($title,$msg,$orgid, $row->Id);
				}
				
				if($mailsend){
					Utils::sendMail(Utils::decode5t($row->CompanyEmail),'',$title,$msg);
				}
			}
			///////////////   CREATING NOTIFICATION FOR THE EMPLOYEE RELATED TO EMPLOYEE CONFIRMATION  /////////
			
			$msg=$dat." is the work anniversary of  ".$name;
			$sqlc = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and Title =? and Message =? and NotifyDate=?";
			$queryc = $this->db->prepare($sqlc);
			$queryc->execute(array( $orgid,$title,$msg, $mdate));
			$countc=$queryc->rowCount();
			if($countc == 0){
			$hrmin="";
			$toemail="";
			
			for($i=0;$i<count($hr);$i++)
			{
				if($hr[$i]!=$row->Id){
					/* if($hrmin=="")
					$hrmin=$hr[$i];
					else
					$hrmin=$hrmin.",".$hr[$i]; */
				
				//$toemail=Utils::getName($hr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
				
				//$empids = $hrmin.",".$senior;
				if($alert){
				$this->CreateNotification($title,$msg,$orgid, $hr[$i]);
				}
				if($mailsend){
				$toemail=Utils::getName($hr[$i], 'EmployeeMaster','CompanyEmail',$this->db);
				Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
				}
				}
			}
			//Utils::Trace($hrmin);
			//$empids = $hrmin.",".$senior;
			if($alert){
			$this->CreateNotification($title,$msg,$orgid, $senior);
			}
			if($mailsend){
				$toemail=Utils::getName($senior, 'EmployeeMaster','CompanyEmail',$this->db);
				Utils::sendMail(Utils::decode5t($toemail),'',$title,$msg);
			}
			}
		}
	}
	
	public function UpdateAttendance($organization){
		//Utils::Trace(Utils::encode5t("jeremy@gmail.com"));
		$sql = "SELECT LeaveDay, HalfDaySts, EmployeeLeaveId FROM `EmployeeLeaveChild` WHERE LeaveDay between (NOW() - INTERVAL 1 MONTH) and SUBDATE(CURDATE(),1) and EmployeeLeaveId in (select Id from EmployeeLeave where LeaveStatus=2 AND OrganizationId = $organization)";
		//echo $sql;
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{
				$ats=0;
				if($row->HalfDaySts==1){
							$ats=4;
				}else{
							$ats=6;
				}
				$leavedate=$row->LeaveDay;
				$empid=Utils::getName($row->EmployeeLeaveId, 'EmployeeLeave','EmployeeId',$this->db);
				$sql1 = "SELECT Id FROM AttendanceMaster where AttendanceDate=? and EmployeeId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($leavedate,$empid));
				
					if($query1->rowCount()==0){
						$shiftId=0;
						$orgid=0;
						$mdate=date('Y-m-d');
						
						$sql2 = "SELECT * FROM EmployeeMaster where Id=?";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array($empid));
						while($row2 = $query2->fetch()){
							$shiftId=$row2->Shift;
							$orgid=$row2->OrganizationId;
						}
						$sql3 = "INSERT INTO AttendanceMaster(EmployeeId, AttendanceDate, AttendanceStatus, ShiftId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, Overtime, EntryImage, checkInLoc, device,TimeinIp) VALUES ($empid,'$leavedate',6,$shiftId,$orgid,'$mdate',0,'$mdate',0,0,'00:00:00','','','Cron','0')";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array());
						Utils::TraceAttendance($sql3." | Device: Cron UpdateAttendance | ORGANIZATION: ".$orgid);
					}else{
						if($row->HalfDaySts==1){
							$sql4 = "UPDATE AttendanceMaster set  AttendanceStatus=? where AttendanceDate=? and EmployeeId=?";
							$query4 = $this->db->prepare($sql4);
							$query4->execute(array(4,$leavedate,$empid));
							
							Utils::TraceAttendance($sql4."  4 "." ".$leavedate. " ".$empid." | Device: Cron UpdateAttendance");
						}else{
							$sql4 = "UPDATE AttendanceMaster set  AttendanceStatus=? where AttendanceDate=? and EmployeeId=?";
							$query4 = $this->db->prepare($sql4);
							$query4->execute(array(6,$leavedate,$empid));
							
							Utils::TraceAttendance($sql4."  6 "." ".$leavedate. " ".$empid." | Device: Cron UpdateAttendance");
						}
					}	
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}	
		
	}
	
		public function UpdateAttendanceForAbsentee($organization){
			//echo date('d');
		for($i = 1; $i < date('d'); $i++){ 		 
	   //add the date to the dates array
	   $dateby = date('Y') . "-" . date('m') . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
	   //echo $dateby." ";
		//$dateby=date('Y-m-d', strtotime('-1 days'));
		$weekno=Utils::weekOfMonth($dateby);
		$dayofdate= 1 + date("w", strtotime($dateby));
		//Utils::Trace(Utils::encoe5t("jeremy@gmail.com"));
		$sql = "SELECT Id, Shift,OrganizationId from EmployeeMaster WHERE Id not in (select EmployeeId from AttendanceMaster where AttendanceDate='$dateby') and DOL='0000-00-00' and OrganizationId=$organization";
        $query = $this->db->prepare($sql);
		//$sql."<br> ";
		try{
			$query->execute(array());
			while($row = $query->fetch())
			{	
				$OffSts=true;
				$ats=2;
				$shiftid=$row->Shift;
				$empid=$row->Id;
				$orgid=$row->OrganizationId;
				//echo $orgid." ".$dateby."<br>";
				$sql4 = "SELECT LeaveDay, HalfDaySts, EmployeeLeaveId FROM `EmployeeLeaveChild` WHERE LeaveDay ='$dateby' and employeeLeaveId in (select Id from EmployeeLeave where LeaveStatus=2 and EmployeeId=? and OrganizationId=?) ";
				$query4 = $this->db->prepare($sql4);
				try{
					$query4->execute(array($empid,$orgid));
					if($row4 = $query4->fetch()){
						if($row4->HalfDaySts!=1){
								$ats=6;
						}
					}
				}catch(Exception $e){}
				
				/* 
					if($row->HalfDaySts==1){
								$ats=4;
					}else{
								$ats=6;
					}
				*/
				////////  FIND OUT THE WEEKLY OFF ON THE DAY OF ATTENDANCE  ///////////////////////
				
				$sql1 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=? and Day=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($shiftid,$dayofdate));
				$week="";
				if($row1 = $query1->fetch()){
					$week=$row1->WeekOff;
				}
				$weekarr=explode(",",$week);
				if($query1->rowCount()>0){
				if($weekarr[$weekno-1]==1)
					$OffSts=false;
				}
				
				////////  FIND OUT THE HOLIDAY ON THE DAY OF ATTENDANCE  ///////////////////////
						
				$holidaycount=0;
				$sql2 = "SELECT  Id FROM HolidayMaster WHERE OrganizationId = $orgid  and ('$dateby' between DateFrom and DateTo)";
				$query2 = $this->db->prepare($sql2);
				try{
					$query2->execute();
					$holidaycount =  $query2->rowCount();
					if($holidaycount>0){
						$OffSts=false;
					/* 	$sql3 = "delete from AttendanceMaster where AttendanceDate='$dateby' and OrganizationId = $orgid and AttendanceStatus=2";
						$query3 = $this->db->prepare($sql3);
						$query3->execute();
						Utils::TraceAttendance($sql3." | Device: Cron UpdateAttendanceForAbsentee| ORGANIZATION: ".$orgid); */
						// $sql3."<br>";
					}
					//echo $sql2." <br>";
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				
				if($OffSts){
					$mdate=date('Y-m-d');
					$sql3 = "INSERT INTO AttendanceMaster(EmployeeId, AttendanceDate, AttendanceStatus, TimeIn,ShiftId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, Overtime, EntryImage, checkInLoc, device,TimeinIp) VALUES ($empid,'$dateby','$ats','00:00:00',$shiftid,$orgid,'$mdate',0,'$mdate',0,0,'00:00:00','','','Absentee Cron','0')";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array());
					Utils::TraceAttendance($sql3." | Device: Cron UpdateAttendanceForAbsentee | ORGANIZATION: ".$orgid);
					//Utils::Trace($sql3);
				}				
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}
		
		}//FOR
	}
	
		public function UpdateTimeOut($organization){
		//for($i = 1; $i <=  date('t'); $i++){ 		 
	   //// add the date to the dates array
	   //$dateby = date('Y') . "-" . date('m') . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
		$dateby=date('Y-m-d', strtotime('-2 days'));
		//$dateby='2017-12-27';
		$sql = "SELECT Id, OrganizationId,Shift from EmployeeMaster WHERE Id in (select EmployeeId from AttendanceMaster where AttendanceDate='$dateby' and TimeOut='00:00:00' and TimeIn!='00:00:00') and DOL='0000-00-00' and OrganizationId=$organization";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array());
			while($row = $query->fetch())
			{	
				$OffSts=true;
				$ats=2;
				$shiftid=$row->Shift;
				$empid=$row->Id;
				$orgid=$row->OrganizationId;
				$timeout="";
				$autotimeout="";
				$sql4 = "SELECT TimeOut FROM `ShiftMaster` WHERE Id ='$shiftid'";
				$query4 = $this->db->prepare($sql4);
				try{
					$query4->execute(array($empid,$orgid));
					if($row4 = $query4->fetch()){
						$timeout=$row4->TimeOut;
					}
				}catch(Exception $e){}
				$time=strtotime($timeout);
				$time = $time - (15 * 60);
				$autotimeout = date("H:i:s", $time);
				$mdate=date('Y-m-d');
				$sql3 = "UPDATE AttendanceMaster set TimeOut=TimeIn ,device=? where TimeIn!='00:00:00' and TimeOut='00:00:00' and AttendanceDate='$dateby' and AttendanceDate!=CURDATE()";
				$query3 = $this->db->prepare($sql3);
				$query3->execute(array('Auto Time Out'));
				Utils::TraceAttendance($sql3." | Device: Cron UpdateTimeOut | ORGANIZATION: ".$orgid);
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}	
		
	//	}for
	}
	
	public function TimeOutNotification()
	{
		
			$sql1 = "SELECT * FROM SuspiciousAttendance where SendMailSts=0";
			$query1 = $this->db->prepare($sql1);
			$query1->execute();		
			$Organization="";
			$count=$query1->rowCount();
			$table="<table  border='1' style=' border-collapse: collapse;width:70%'><tr style=' background-color: rgba(107, 58, 137, 0.91); color: rgba(255, 247, 247, 1);'><th>Id</th><th>Organization</th><th>Altered Date</th><th>Attendance Date</th><th>Employee</th></tr>";
			while($row1 = $query1->fetch()){
						if($Organization==""){
							$Organization=$row1->OrganizationId;
						}else{
							$Organization.=",".$row1->OrganizationId;
						}
						$table.="<tr><td><center>".$row1->CountId."</center></td><td><center>".$row1->OrganizationId."</center></td><td><center>".$row1->AlterdDate."</center></td><td><center>".$row1->AttendanceDate."</center></td><td><center>".$row1->EmployeeId."</center></td></tr>";
						$sql2 = "Update SuspiciousAttendance set SendMailSts=1 where CountId=".$row1->CountId;
						$query2 = $this->db->prepare($sql2);
						$query2->execute();	
				}
			$table.="</table>";
			$title="Suspicious Entries in Attendance is found";
			$msg=$table;
			if($count>0){
			Utils::sendMail("gulab@ubitechsolutions.com,vijay@ubitechsolutions.com,abhinav@ubitechsolutions.com",'Suspicious Updation in TimeOut',$title,$msg);
			Utils::TraceAttendance($title." ".$msg);
			}
		
	}
	
	public function averageWorkingDayWeek($shiftid,$orgid)
	{
		 
		 $sql1 = "SELECT * FROM ShiftMasterChild where ShiftId=? and Day in (1,2,3,4,5,6,7)";
		 $query1 = $this->db->prepare($sql1);
		 $query1->execute(array( $shiftid));		
		 $count=0;
		 while($row1 = $query1->fetch()){
		 $workingday = $row1->WeekOff;
		 $temparr = explode(',',$workingday);
			 foreach($temparr as $value){
				 if($value==0){
					 $count=$count+1;
				 }elseif($value==2){
					 $count=$count+0.5;
				 }
			}
		}
		$count=ceil($count/5);
		return $count;
	}
	
}

?>