<?php

/**
 * TimesheetModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TimesheetModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
    */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    public function getAllTimesheetData($user_id)
    {
	$limit = isset($_POST['limit']) ? $_POST['limit'] : "";
	$offset = isset($_POST['offset']) ? $_POST['offset'] : "0";
	$userid = isset($_POST['userid']) ? $_POST['userid'] : "0";
	$projectid = isset($_POST['projectid']) ? $_POST['projectid'] : "0";
	$cond="";
	$cond1="";
	if($limit!="")
	{
		$cond="limit $limit offset $offset";
	}
	
	if($userid==0){$userid=$user_id;}
		
	if($projectid!=0){
	$cond1.=" and project_id = $projectid ";
	}
		
        $sql = "SELECT * , TIMESTAMPDIFF(hour,start_date, end_date) as timeinhour, TIMESTAMPDIFF(minute,start_date, end_date) as timeinmin FROM timesheet_master where emp_id = :userid  $cond1  order by start_date desc $cond";
        $query = $this->db->prepare($sql);
        $query->execute(array(":userid"=>$userid));
        $result =array();
        while($row = $query->fetch())
        {
		$res= array();
		$res['id'] = $row->id;
		$res['pname'] = self::getProjectName($row->project_id);
		$res['tname'] = (self::getTaskName($row->task_id)=="-")?'Other Task':self::getTaskName($row->task_id);
		$res['empid'] = self::getUserName($row->emp_id);
		$res['description'] = $row->description;
		$res['startdate'] = date("dS M, Y h:i A", strtotime(date($row->start_date)));
		$res['enddate'] = $row->end_date;
		$res['createddate'] = $row->created_date;
		$res['updateddate'] = $row->updated_date;
		$res['timestatus'] = $row->time_status;
		$res['pauseon'] = $row->pause_on;
		$res['timepause'] = $row->time_pause;
		$min = $row->timeinmin-($row->timeinhour*60);
		$res['totaltime'] = $row->timeinhour." hrs, ".$min." min";
		$result[] =$res;
		}
      
        return $result;
    }

	function getProjectName($id)
	{
	
		$result="-";
		$sql = "SELECT project_title FROM project_master WHERE id = :id";
        	$query = $this->db->prepare($sql);
        	$query->execute(array(':id' => $id));
		 while($row = $query->fetch())
		 {
			$result= ucwords($row->project_title);
		 }
		
		return $result;
	}
	
	function getUserName($id)
	{
	
		$result="-";
		$sql = "SELECT full_name FROM user_master WHERE user_id = :id";
        	$query = $this->db->prepare($sql);
        	$query->execute(array(':id' => $id));
		while($row = $query->fetch())
		{
			$result= ucwords(strtolower($row->full_name));
		}
		
		return $result;
	}
	
	function getTaskName($id)
	{
	
		$result="-";
		$sql = "SELECT task_title FROM task_master WHERE id = :id";
        	$query = $this->db->prepare($sql);
        	$query->execute(array(':id' => $id));
		while($row = $query->fetch())
		{
			$result= ucwords($row->task_title);
		}
		
		return $result;
	}
	
	public function getComboTaskData($user_id)
	{	
		$sql = "SELECT * FROM task_master WHERE (emp_id=:user_id or created_by=:user_id or report_by=:user_id or emp_id=0) order by id desc";
		$query = $this->db->prepare($sql);
		$query->execute(array(':user_id' => $user_id));

		$result =array();
		while($row = $query->fetch())
		{
			$res= array();
			$res['id'] = $row->id;
			$res['project_id'] = $row->project_id;
			$res['task_title'] = ucwords($row->task_title);
		
			$result[] =$res;
		}
		  
		return $result;
	}
    /**
     * Getter for a single group
     * @param int $group_id id of the specific group
     * @return object a single object (the result)
     */
	 
	  public function getDetail($sheet_id)
    {
		$sheet_id;
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$sql = "SELECT * FROM timesheet_master WHERE id = :sheet_id";
        $query = $this->db->prepare($sql);
		
        $query->execute(array(':sheet_id' => $sheet_id));
		$count =  $query->rowCount();
     
        while($row = $query->fetch())
        {
		$res= array();
		$res['id'] = $row->id;
		$res['project_id'] = $row->project_id;
		$res['task_id'] = $row->task_id;
		$res['emp_id'] = $row->EmployeeId;
		$res['description'] = $row->description;
		$res['start_date'] = Utils::dateformatter($row->timesheetstart);
		$res['total_time'] =date('H:i', strtotime($row->total_time));
		
		$data[] =$res;
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = TASK_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = TASK_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        return $result;
    }
	 
    public function getTimesheetData($sheet_id)
    {
        $sql = "SELECT * FROM timesheet_master WHERE id = :sheet_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sheet_id' => $sheet_id));

        $result =array();
        while($row = $query->fetch())
        {
		$res= array();
		$res['id'] = $row->id;
		$res['project_id'] = "-";
		
		$sql1 = "SELECT project_title FROM project_master WHERE id = :id";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array(':id' => $row->project_id));
		while($row1 = $query1->fetch())
		{
			$res['project_id'] = $row1->project_title;
		}			
		$res['task_id'] = $row->task_id;
		$res['emp_id'] = $row->emp_id;
		$res['description'] = $row->description;
		$res['start_date'] = date("Y-m-d", strtotime($row->start_date));
		$res['start_time'] = date("h:i A", strtotime($row->start_date));
		//$res['end_date'] = date("Y-m-d", strtotime($row->end_date));
		$res['end_time'] = date("h:i A", strtotime($row->end_date));
		
		$res['created_date'] = $row->created_date;
		$res['updated_date'] = $row->updated_date;
		$res['time_status'] = $row->time_status;
		$res['pause_on'] = $row->pause_on;
		$res['time_pause'] = $row->time_pause;
		
		$result[] =$res;
	}
      
        return $result;
    }

    /**
     * Setter for a group (create)
     * @param string $group_text group text that will be created
     * @return bool feedback (was the group created properly ?)
     */
    public function create()
    {
        	// clean the input to prevent for example javascript within the groups.
        $task_id = isset($_POST['task_id']) ? $_POST['task_id'] : "";
		$description = isset($_POST['description']) ? $_POST['description'] : "";
		$start_date1 = isset($_POST['start_date']) ? $_POST['start_date'] : "";
		//$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : "";
		$start_time = isset($_POST['start_time']) ? $_POST['start_time'] : "";
		$end_time = isset($_POST['end_time']) ? $_POST['end_time'] : "";
		
		$start_date = date("Y-m-d H:i", strtotime($start_date1." ".$start_time));
		$end_date = date("Y-m-d H:i", strtotime($start_date1." ".$end_time));
		$count=0;
		$project_id=0;
		$description = htmlspecialchars($description);
		$user_id = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
	
		$sql = "SELECT project_id FROM task_master WHERE id = :id";
        	$query = $this->db->prepare($sql);
        	$query->execute(array(':id' => $task_id));
		while($row = $query->fetch())
		{
			$project_id= $row->project_id;
		}
		 
		$sql = "INSERT INTO timesheet_master (project_id, task_id, emp_id, description, start_date, end_date, created_date, updated_date) VALUES (:project_id, :task_id, :emp_id, :description, :start_date, :end_date, :created_date, :updated_date)";
		$query = $this->db->prepare($sql);
		$query->execute(array(':project_id' => $project_id, ':task_id' => $task_id, ':emp_id' => $user_id, ':description'=>$description,':start_date' => $start_date, ':end_date'=>$end_date, ':created_date'=>$mdate, ':updated_date'=>$mdate));

		$count =  $query->rowCount();
		
		if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_TIMESHEET_ADDITION_SUCCESSFUL;
		    	return true;
		} else {
		    	$_SESSION["feedback_negative"][] = FEEDBACK_TIMESHEET_ADDITION_FAILED;
		}
		
		
	   return false;
    }

    /**
     * Setter for a group (update)
     * @param int $group_id id of the specific group
     * @param string $group_text new text of the specific group
     * @return bool feedback (was the update successful ?)
     */
    public function editSave()
    {
       	// clean the input to prevent for example javascript within the groups.
		$sheet_id = isset($_POST['sheet_id']) ? $_POST['sheet_id'] : "";
		$task_id = isset($_POST['task_id']) ? $_POST['task_id'] : "";
		$description = isset($_POST['description']) ? $_POST['description'] : "";
		$start_date1 = isset($_POST['start_date']) ? $_POST['start_date'] : "";
		//$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : "";
		$start_time = isset($_POST['start_time']) ? $_POST['start_time'] : "";
		$end_time = isset($_POST['end_time']) ? $_POST['end_time'] : "";
		$start_date = date("Y-m-d H:i", strtotime($start_date1." ".$start_time));
		$end_date = date("Y-m-d H:i", strtotime($start_date1." ".$end_time));
		$count=0;
		$project_id=0;
		$description = htmlspecialchars($description);
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid = $_SESSION['ubihrm_org_id'];
		$mdate = date("Y-m-d H:i:s");
		$count=0;
		$sql = "SELECT project_id FROM task_master WHERE id = :id";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $task_id));
		 while($row = $query->fetch())
		 {
			$project_id= $row->project_id;
		 }
		 
		$sql = "UPDATE timesheet_master SET project_id=:project_id, task_id = :task_id, description = :description, start_date = :start_date, end_date=:end_date, updated_date=:mdate WHERE id = :sheet_id";
		$query = $this->db->prepare($sql);
	        $query->execute(array(':project_id' => $project_id, ':task_id' => $task_id, ':description'=>$description,':start_date' => $start_date, ':end_date'=>$end_date,  ':mdate'=>$mdate, ':sheet_id'=>$sheet_id));
		   
        	$count =  $query->rowCount();
		
		if ($count == 1) {
			$_SESSION["feedback_positive"][] = FEEDBACK_TIMESHEET_EDITING_SUCCESSFUL;
            		return true;
		} else {
		    	$_SESSION["feedback_negative"][] = FEEDBACK_TIMESHEET_EDITING_FAILED;
		}
	       
        // default return
        return false;
    }
    
  
    /**
     * Deletes a specific group
     * @param int $group_id id of the group
     * @return bool feedback (was the group deleted properly ?)
     */
    public function delete($sheet_id)
    {
        $sql = "DELETE FROM timesheet_master WHERE id = :sheet_id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':sheet_id' => $sheet_id));

        $count =  $query->rowCount();

        if ($count == 1) {
		$_SESSION["feedback_positive"][] = FEEDBACK_COURSE_DELETION_SUCCESSFUL;
            	return true;
        } else {
            	$_SESSION["feedback_negative"][] = FEEDBACK_COURSE_DELETION_FAILED;
        }
        // default return
        return false;
    }
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'timesheet_master';
		$sIndexColumn = "id";
		$aColumns = array(  'project_id', 'task_id','EmployeeId', 'updated_date', 'time_status', 'id');
		try{
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		
		
		$sWhere = " WHERE  OrganizationId = $orgid and EmployeeId in (select Id EmployeeMaster where Is_Delete=0 )";
		
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if($i!=3){
				if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
				{
					if ( $sWhere == "" )
					{
						$sWhere = "WHERE ";
					}
					else
					{
						$sWhere .= " AND ";
					}
					
						if($i==1){
							$sWhere .= $aColumns[$i]." in (select Id from FiscalMaster where '".($_GET['sSearch_'.$i])."' between StartDate and EndDate) ";
						}else{
							$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
						}
					
					
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==2)
				{
					
					$row[] = self::getEmpAnnualLeavetype($aRow->EmployeeId,$orgid);
					
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==3)
				{
					$doj = Utils::getName($aRow->EmployeeId,'EmployeeMaster','DOJ',$this->db);
					$row[] = Utils::dateformatter($doj);
				}
				/*elseif($aColumns[$i]=="BalanceLeave" && $i>5)
				{
					$totalleave=($aRow->BalanceLeave)+($aRow->TotalLeave)-($aRow->AdvanceLeave);
					$row[] =$totalleave ;
				}*/
				elseif($aColumns[$i]=="Id"  )
				{
					if($hrsts==1){
						$row[] = '<a rel="tooltip" title="Encash/Lapse" href="'.URL.'leave/lapsencashleave/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					else{
						$row[] ="";
					}
					
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
	}
	
	////////for team's timesheet//////////
	public function getunassigntimesheet($type)
	{
		$sTable = 'timesheet_master';
		$sIndexColumn = "project_id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array('project_id', 'task_id', 'task_id', 'EmployeeId','description', 'timesheetstart','start_time','end_time','total_time','id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			if($type==1){
				$sOrder = "ORDER BY timesheetstart desc, ";
			}
			elseif($type==2){
				$sOrder = "ORDER BY  EmployeeId, ";
			}elseif($type==3){
				$sOrder = "ORDER BY  project_id, ";
			}else{
				$sOrder = "ORDER BY  ";
			}
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			/* isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			} */
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}/* else{
			$sOrder = "ORDER BY  EmployeeId";
		} */
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		//$fiscalid=Utils::getFiscalId(date('Y-m-d'), $this->db);
		$ids = Utils::getReportingIds($userid, $this->db);
		/* $dept=isset($_GET['department'])?$_GET['department']:0;
		$desig=isset($_GET['designation'])?$_GET['designation']:0;
		$div=isset($_GET['division'])?$_GET['division']:0; */
		$sWhere = "";
		/*if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid";
			
			 if($dept != 0 || $desig != 0 || $div != 0){
				$sWhere = "Where (EmployeeId in (select Id from EmployeeMaster where Department=$dept or Designation =$desig OR Division =$div) AND OrganizationId= $orgid) ";
			}
			if($dept != 0 && $desig != 0 && $div != 0){
				$sWhere = " WHERE  OrganizationId = $orgid and (EmployeeId in (select Id from EmployeeMaster where Department=$dept AND Designation =$desig AND Division =$div))";
			} 
		}else{*/
			$sWhere = " Where (EmployeeId in ($ids) AND OrganizationId= $orgid AND timesheetstart!='0000-00-00') and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
			
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}else if($aColumns[$i]=="project_id"){
				$sWhere .= " (project_id in ( select id from project_master where project_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}else if($aColumns[$i]=="task_id" && $i==2){
				$sWhere .= " (task_id in ( select id from task_master where task_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				
				if($i==5){
					$sWhere .= "(".($_GET['sSearch_'.$i]).")";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array(); $flg=false;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				 if($aColumns[$i]=="EmployeeId")
				{
					$row[] =''. Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'';
					
				}
				else if($aColumns[$i]=="id")
				{
					
						$row[] = '<a rel="tooltip" title="View" href="'.URL.'timesheet/viewtimesheet1/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1" ><i class="fa fa-eye"></i></a>';
				}
				elseif($aColumns[$i]=="task_id"  && $i==2)
				{
					if($aRow->{$aColumns[$i]}==0){
						$row[] = "Other";
					}else{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'task_master','task_title',$this->db);
					}
				}elseif($aColumns[$i]=="task_id"  && $i==1)
				{$milestoneid=0;
					
					$milestoneid = Utils::getName($aRow->{$aColumns[$i]},'task_master','milestoneid',$this->db);
					if($milestoneid==0){
						$row[] = "Other";
					}else{
						$row[] = Utils::getName($milestoneid,'SettingMilestone','Name',$this->db);
					}
				}
				elseif($aColumns[$i]=="project_id"  )
				{
					if($aRow->{$aColumns[$i]}==0){
						$row[] = "Other";
					}else{
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'project_master','project_title',$this->db);
					}
				}elseif($aColumns[$i]=="timesheetstart")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="start_time" || $aColumns[$i]=="end_time" || $aColumns[$i]=="total_time")
				{
					if($aRow->{$aColumns[$i]}!='00:00:00')
					$row[] = date('H:i', strtotime($aRow->{$aColumns[$i]}));
					else
						$row[]='-';
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	}
