<?php

/**
 * EmpleaveModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TimeoffModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database rel
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
    /**
     * Get method for fetching the records of department
     * @return array an array with several rels (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM Timeoff WHERE OrganizationId = :id and EmployeeId=:eid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid , ':eid' => $mid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['employeeid'] = $row->EmployeeId;
				$res['leavefrom'] = $row->TimeFrom ;
				$res['leaveto'] = $row->TimeTo;
				$res['leavereason'] = $row->Reason;
				$res['leavestatus'] = $row->ApprovalSts;
				$res['approvercomment'] = $row->ApproverComment;
                $res['applydate'] = $row->ApplyDate;
                $res['leavevalidsts'] = $row->LeaveValidDays;
                $res['fiscalid'] = $row->FiscalId;
                $res['approvedby'] = $row->ApproverId;
                $res['leavetypeid'] = $row->LeaveTypeId;
                $res['resumptiondate'] = $row->ResumptionDate;
				$res['createdate'] = $row->CreatedDate;
				$res['lastmodifieddate'] = $row->LastModifiedDate;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEELEAVE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getTimeOffDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
			$sql = "SELECT * FROM Timeoff WHERE Id = :id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
			$res=array();
			$createdate=$row->CreatedDate;
			$timeofdate=$row->TimeofDate;
			
			$res["date"]=date("d/m/Y", strtotime($createdate));
			$res["timeoffdate"]=date("d/m/Y", strtotime($timeofdate));
			$res["timefrom"]=$row->TimeFrom;
			$res["timeto"]=$row->TimeTo;
			$res["reason"]=$row->Reason;
			$sts=$row->ApprovalSts;
			if($sts==2)
			$res["sts"]="Approved";
		elseif($sts==3)
			$res["sts"]="Pending";
			elseif($sts==1)
			$res["sts"]="Rejected";
			elseif($sts==4)
			$res["sts"]="Cancel";
			elseif($sts==5)
			$res["sts"]="Withdraw";
			else
				$res["sts"]="Pending";
			$res["comment"]=$row->ApproverComment;
			$res["id"]=$row->Id;
			$data[]=$res;
				}
			}
			
			if ($count >= 1) {
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			$changests 	= 0;
			$sts=$_SESSION['ubihrm_user_sts'];
			$hrsts=$_SESSION['ubihrm_hr_sts'];
			if($sts==1 || $hrsts==1)
			{
				$changests 	= 1;
			}
			$sql = "SELECT * FROM Timeoff WHERE Id = :id";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();				
					$res['fromdate'] 		= Utils::dateformatter($row->TimeFrom );       
					$res['fromdate1'] 		= $row->TimeFrom ;       
					$res['employeeid'] 		= (int)$row->EmployeeId;
					$res['todate'] 			= Utils::dateformatter($row->TimeTo);
					$res['todate1'] 		= $row->TimeTo;
					$res['leavereason'] 	= $row->Reason;
					$res['leavestatus'] 	= $row->ApprovalSts;
					$res['approvercomment'] = $row->ApproverComment;
					$res['applydate'] 		= Utils::dateformatter($row->ApplyDate);
					$res['leavevalidsts'] 	= $row->LeaveValidDays;
					$res['approvedby'] 		= (int)$row->ApproverId;
					$res['fiscalid'] 		= $row->FiscalId;
					$res['leavetypeid'] 	= (int)$row->LeaveTypeId;
					$res['resumptiondate'] 	= Utils::dateformatter($row->ResumptionDate);
					$res['substituteid'] 		= $row->SubstituteEmployeeId;
					$res['emergencycontact'] 	= $row->EmergencyContact;
					$res['fromdaytype'] 	= $row->FromDayType;
					$res['todaytype'] 	= $row->ToDayType;
					$res['timeoffrom'] 	= $row->TimeOfFrom;
					$res['timeofto'] 	= $row->TimeOfTo;
					$res['leavebreakdown'] 	= $row->LeaveBreakDown;
					$res['leaveattachment'] 	= "";
					$code=Utils::getName($row->EmployeeId,'EmployeeMaster','EmployeeCode',$this->db);
					$doc1="$code".'_'."$id";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res['leaveattachment']=URL.$dir."/$filename";
								}
							}
							closedir($dh);
						}
					}
					
					$data[] = $res;
				}
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEELEAVE_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['changestatus']=$changests;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a Employeeleave (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leaveid=0;
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		try{
			$mdate = date("Y-m-d H:i:s");
			$timeoffdate = Utils::getDateformat($request[3]);
			
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId=? and TimeofDate=? and ((? between  TimeFrom  and TimeTo )or (? between  TimeFrom  and TimeTo )) and (ApprovalSts=2 or ApprovalSts=3) and OrganizationId=? and Id<>?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2],$timeoffdate ,$request[4],$request[5],$orgid ,$request[7]));
		$count =$count +  $query->rowCount();
		
		if($count>=1)
			{
				$status=false;
				$errorMsg=" Time off already Exist";
			}else{
			
				$sql = "UPDATE Timeoff SET  EmployeeId=?, TimeofDate=?, TimeFrom =?,  TimeTo=?, Reason=? , ModifiedDate=?, OrganizationId=?  where Id=?";	
				$query = $this->db->prepare($sql);
				   
				$query->execute(array( $request[2],$timeoffdate, $request[4], $request[5],$request[6],$mdate, $orgid,  $request[7] ));			
				$count =  $query->rowCount();
				
			if ($count == 1) {
				$status =true;
				$successMsg =  "Time off updated successfully.";
			}else{ 
				$status =false;
				$errorMsg = "Time off updation failed, due to no change in data.";
			}    
		
		}
		}catch(Exception $e) {                              
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		//$result["leaveid"] =$id;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a Employeeleave (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $leaveid=0;
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		try{		
		$mdate = date("Y-m-d H:i:s");
		$timeoffdate = Utils::getDateformat($request[3]);
		
		$sql = "SELECT * FROM Timeoff WHERE EmployeeId=? and TimeofDate=? and ((? between  TimeFrom  and TimeTo )or (? between  TimeFrom  and TimeTo )) and (ApprovalSts=2 or ApprovalSts=3) and OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[2],$timeoffdate ,$request[4],$request[5],$orgid ));
		$count =$count +  $query->rowCount();
		
		if($count>=1)
		{
			$status=false;
			$errorMsg=" Time off already Exist";
		}else{
			$sql = "INSERT INTO Timeoff  (EmployeeId, TimeofDate,TimeFrom , TimeTo, Reason,   ApprovalSts, CreatedDate	, ModifiedDate, OrganizationId) VALUES (?,?, ?, ?, ?, 2, ?, ?, ?)";		
			$query = $this->db->prepare($sql);
			$query->execute(array( $request[2],$timeoffdate, $request[4], $request[5],$request[6], $mdate, $mdate, $orgid));
			$count =  $query->rowCount();		
			if ($count == 1) {
			   $status =true;
			   $successMsg ="Time off created successfully";
			} else {
			   $status =false;
			   $errorMsg ="There is some problem while created record.";
			}
		}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result["leaveid"] =$leaveid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function checkHoliday($leavefrom, $empid,$leavecal)
	{
		if($leavecal==0){
			$sql = "SELECT Id, Name FROM HolidayMaster WHERE ? between DateFrom and DateTo";
			$query = $this->db->prepare($sql);
			$query->execute(array($leavefrom ));
			if($query->rowCount()>0)
			{
				return false;
			}else{
				$sql1 = "SELECT WorkingDays FROM EmployeeMaster WHERE Id = ?";
				 $query1 = $this->db->prepare($sql1);
				 $query1->execute(array( $empid ));			
				 $row1 = $query1->fetch();
				 $workingday = $row1->WorkingDays;
				 
				$temparr = explode(',',$workingday);
				$dw = date( "w", strtotime(date($leavefrom)));
				$date = "Leave Day";
				for($i=0; $i<count($temparr); $i++)
				{
					if($dw == $i){
						if($temparr[$i]==3){
							return false;
							break;
						}elseif($temparr[$i]==2){
							return false;
							break;
						}
					}
				}			
			}
			return true;
		}else{
			return true;
		}
		
		
	}
	
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM TimeoffApproval WHERE TimeofId = :id ";
		$query = $this->db->prepare($sql);
		$query->execute(array(':id' => $did));
		
		$sql = "DELETE FROM Timeoff WHERE Id = :id ";
		
		try{			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = "Time off deleted successfully!";
        }else {
           $status =false;
		   $errorMsg = "There is some problem while deleting record.";
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getleavetype($id)
	{
		$name ="";
		$sql = "SELECT * FROM LeaveMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getEmployeeName($id)
	{
		$name ="";
		$sql = "SELECT FirstName, MiddleName, LastName FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getEntitledLeave($empid,$fiscal)
	{
		$name =0;
		$sql = "SELECT BalanceLeave FROM LeaveHistory WHERE EmployeeId = :id and FiscalId= :fid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $empid,':fid' => $fiscal ));
			while($row = $query->fetch())
			{
				$name = $row->BalanceLeave;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'Timeoff';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId', 'TimeofDate','TimeFrom','TimeTo','ModifiedDate','CreatedDate' ,'ApproverId', 'Reason', 'ApproverComment','ApprovalSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  ApplyDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$fiscalid=Utils::getFiscalId(date('Y-m-d'), $this->db);
		$ids = Utils::getReportingIds($userid, $this->db);
		$dept=isset($_GET['department'])?$_GET['department']:0;
		$desig=isset($_GET['designation'])?$_GET['designation']:0;
		$div=isset($_GET['division'])?$_GET['division']:0;
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0) ";
			
		}else{
			$sWhere = " WHERE (EmployeeId in ($ids) AND OrganizationId= $orgid and EmployeeId in(select Id from EmployeeMaster where Is_Delete=0)) ) ";
			
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster WHERE FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and FiscalId=$fiscalid
				}
				elseif($aColumns[$i]=="LeaveTypeId"){
				$sWhere .= " (LeaveTypeId in ( select Id from LeaveMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
	//	echo $sQuery;

		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array(); $flg=false;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
									
					$edit =""; $delete="";
					$flg = ($aRow->ApprovalSts == 1) ? true : (($aRow->ApprovalSts == 5)  ? true : false);
					
					if($editper && !$flg){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'leave/edittimeoff/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}
					elseif($editper &&  $flg){
						$edit = '<a href="#" rel="tooltip" title="Application is either Rejected or Withdrawn"><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){					
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				
					
				}elseif($aColumns[$i]=="EmployeeId" ){
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'leave/viewtimeoff/'.Utils::encode5t($aRow->Id).'/1" >'.self::getEmployeeName($aRow->{$aColumns[$i]}).'</a>';
				
					
				}elseif( $aColumns[$i]=="ApproverId" || $aColumns[$i]=="CreatedById" || $aColumns[$i]=="LastModifiedById"){
					$row[] = self::getEmployeeName($aRow->{$aColumns[$i]});
					
				}
				elseif($aColumns[$i]=="ApprovalSts"){
                    if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->gettimeoffApproverPendingSts($aRow->{$aColumns[10]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
				elseif($aColumns[$i]=="ModifiedDate"){
					$time1 = strtotime(date("1980-01-01 ".$aRow->TimeFrom)); 
					$time2 = strtotime(date("1980-01-01 ".$aRow->TimeTo));  
					$totaltime = ($time2 - $time1);
					//$totaltime =($totaltime/60);
					$start = date_create("1980-01-01 ".$aRow->TimeFrom);
					$end = date_create("1980-01-01 ".$aRow->TimeTo);
					$diff=date_diff($end,$start);
					//print_r($diff);
					$hrs=$diff->format('%h');
					$mins=$diff->format('%i');
					if($hrs == 0)
						$hrs = "00";
					if($mins == 0)
						$mins = "00";
					$sts="hrs";
					if($hrs == 0)
						$sts="mins";
					$diff=$hrs.":".$mins. " ".$sts;
					$row[]=$diff ;
				}				
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate" ){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="TimeofDate"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}/* elseif($aColumns[$i]=="TimeFrom" || $aColumns[$i]=="TimeTo"){
					if(($aRow->{$aColumns[$i]})=="00:00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::timeformatter($aRow->{$aColumns[$i]});
					}
				} */
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	
////////////////////////////////////////////////////////////////////////
	public function getEmployeeLeftLeave($mid,$leavetype,$applydate)
    {
		$orgid=$_SESSION['ubihrm_org_id'];
		$count=0; $leftleave=0;
		$leaveid=0; $result=0;
			try{
				$fiscalid = Utils::getFiscalId($applydate, $this->db);
				$employeeusedleave=0;
				$sql1 = "SELECT Id  FROM Timeoff WHERE OrganizationId = ? and EmployeeId =? and LeaveTypeId=? and FiscalId =? and ApprovalSts=2";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $mid, $leavetype, $fiscalid));
				while($row1=$query1->fetch()){
					$leaveid.=','.$row1->Id;
				}
				$sql1 = "SELECT LeaveDays FROM LeaveMaster WHERE Id =?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $leavetype));
				while($row1=$query1->fetch()){
					$total=$row1->LeaveDays;
				}
				
					$sql = "SELECT HalfDaySts  FROM TimeoffChild WHERE TimeoffId in ($leaveid) and LeaveTypeId=? and Entitled=1 and ApprovalSts=2";
					$query = $this->db->prepare($sql);
					$query->execute(array( $leavetype));
					while($row1=$query->fetch())
					{
						if($row1->HalfDaySts == 1 ){
							$employeeusedleave = $employeeusedleave + 0.5;
						}
						else{
							$employeeusedleave++;
						}
					}
					$leftleave = $total-$employeeusedleave;
					if($leftleave>0)
					{
						$result=$leftleave;
					}
				
				
				
		}catch(Exception $e) {
			
			$e->getMessage();
		}
		
		
		return $result;
    }
	
	public function getTimeoffDataTable($editper, $deleteper)
	{
		try{
		$sTable = 'Timeoff';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','TimeofDate', 'TimeFrom', 'TimeTo', 'Reason','CreatedDate' ,'ApprovalSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		$sOrder = "ORDER BY "; 
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			//$sOrder .= ", ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY CreatedDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
			
		}else{
			$sWhere = " WHERE Id IN (SELECT TimeofId FROM TimeoffApproval Where ApproverId=$userid ) and OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";
					$sts=$this->getTimeoffApproverSts($aRow->Id,$userid);
					if($aRow->ApprovalSts==3 && $sts ){						
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'leave/edittimeoffapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
					}
					if($hrsts==1 && $sts && $aRow->ApprovalSts==3){
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'leave/edittimeoffapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/2" ><i class="fa fa-thumbs-up"></i></a>';	
					}	
					$row[] =$edit;
					
				}elseif($aColumns[$i]=="ApprovalSts"){                    
					if($aRow->{$aColumns[$i]}==3){
						$pendingapprover=$this->gettimeoffApproverPendingSts($aRow->{$aColumns[7]},3);
						$pendingapp=Utils::getEmployeeName($pendingapprover,$this->db);			
						if($pendingapp=="")
							$row[] = "<span class='label label-info'>Pending</span>";
						else
							$row[] = "<span class='label label-info'>Pending at $pendingapp</span>";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
                 }
			
				 elseif($aColumns[$i]=="EmployeeId"){
                    
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'leave/viewtimeoff/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }elseif($aColumns[$i]=="TimeofDate"){
					$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
				 }
				elseif($aColumns[$i]=="CreatedDate"){
					$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
				 }
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
		
	}
	
	public function getTimeoffApproverSts($id,$userid)
	{
		$flg =false;
		$employee=0;
		$sql = "SELECT * FROM TimeoffApproval WHERE TimeofId = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				
				if($row->ApproverSts==3){
					$employee=$row->ApproverId;
					break;
				}
			}
			if($employee ==  $userid){
					$flg = true;
				}
		}catch(Exception $e) {
			
		}
		return $flg;
	}
	
		//////////////////////////// to find out the approver on which the timeoff is pending ///////////////////////////
	
		public function gettimeoffApproverPendingSts($id,$sts)
		{
			$name ="0";
			if($sts==2)//approved
				$sql = "SELECT * FROM TimeoffApproval where TimeofId=? and ApproverSts=? order by Id desc limit 1";
			else//pending	
				$sql = "SELECT * FROM TimeoffApproval where TimeofId=? and ApproverSts=? order by Id asc limit 1";
			$query = $this->db->prepare($sql);
			try{
				$query->execute(array( $id,$sts ));
				while($row = $query->fetch())
				{
					$name = $row->ApproverId;
				}
			}catch(Exception $e) {}
			return $name;
		}
	

}
