<?php

/**
 * DiscussionModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class TasksModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

	public function getProjectDate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$projectid=$_POST["projectid"];
        $sql = "SELECT * FROM project_master WHERE OrganizationId = :id and id = :projectid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$projectid = $request[2];	
				
			$query->execute(array(':id' => $orgid, ':projectid' => $projectid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				
				$res = array();
				$srtdt = $row->start_date;
				$startDate = date("Y/m/d", strtotime($srtdt));
				$enddt = $row->completed_date;
				$endDate = date("Y/m/d", strtotime($enddt));
				$res['start_date'] = $startDate;
				$res['completed_date'] = $endDate;
				$data[] = $res;
			}
        }else{
			$status=false;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	 public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_master WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['task_title'] = $row->task_title;
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		$res= array();
			$res['id'] = "0";
			$res['task_title'] = strtolower("others");
			$data[] =$res;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getComment($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_comments WHERE OrganizationId = :id and taskid= :taskid and comment!='' order by CreatedDate desc" ;
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$taskid = $request[2];
			$query->execute(array(':id' => $orgid, ':taskid' =>$taskid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['comment'] = $row->comment;
				$res['createdby']=$this->getEmployeeName($row->CreatedBy);
				$res['createddate']=Utils::datetimeformatter( $row->CreatedDate);
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function gettaskbyproject($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		if($request[2]!=""){
        $sql = "SELECT * FROM task_master WHERE OrganizationId = :id and projectid= :projectid and assignto = :assignto order by fromdate desc";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid, ':projectid' =>$request[2], ':assignto' => $mid  ));
			 $count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				if($row->taskstatus==1 || $row->taskstatus==5){
				$res = array();
				$res['id'] = $row->id;
				 $res['task_title'] = $row->task_title;
				$data[] = $res;
				}
			}
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		}
		/* $res = array();
		$res['id'] =0;
		$res['task_title'] = "Other Task"; */
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getAllMilestone($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sql = "SELECT * FROM SettingMilestone WHERE  OrganizationId = :id and Id in (Select DefaultMilestoneId from Milestone where projectid= :projectid)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid, ':projectid' => $request[2] ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['title'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		$res = array();
		$res['id'] =0;
		$res['title'] = "Other";
		$data[] = $res;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM project_master WHERE OrganizationId = :id and id = :projectid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid, ':projectid' => $request[2] ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$emps=$row->assigned_to;
				$emp= explode(',', $emps);
				foreach($emp as $value){
					$sql1 = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Id = :emp_id and Is_Delete=0";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' => $orgid, ':emp_id' => $value ));
					while($row1 = $query1->fetch()){
						$res = array();
				$res['id'] = $row1->Id;
				$res['name'] = $row1->EmployeeCode." - ". ucwords(strtolower($row1->FirstName." ".$row1->LastName));
				$data[] = $res;
					}
				}
				
			}
        }else{
			$status=false;
			$successMsg = "No record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmpProject($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM project_master WHERE OrganizationId = $orgid and find_in_set($request[2], assigned_to) and project_status=1 ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res=array();
				$res['id']=$row->id;
				$res['name']=$row->project_title;
				$res['company']=$row->company;
				$data[]=$res;
			}
        }else{
			$status=false;
			$successMsg = "No record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_master WHERE id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['task_title'] = $row->task_title;
				$res['fromdate'] =Utils::dateformatter($row->fromdate);
				$res['todate'] =Utils::dateformatter($row->todate);
				$res['assignto'] = $row->assignto;
				$res['projectid'] = $row->projectid;
				$res['milestoneid'] = $row->milestoneid;
				$res['task_title'] = $row->task_title;
				$res['desc'] = $row->description;
				$res['priority'] = $row->priority;
				$res['taskstatus'] = $row->taskstatus;
				$res['miscunduct'] = $row->miscunduct;
				$res['reopencount'] = $row->ReOpenCount;
				$res['rating'] = $row->rating;
				if($row->taskdocs!="")
				$res['taskdocs']=explode(",",$row->taskdocs);
				$timeduration="";
				$timeduration=explode(":",$row->Totalhour);
				if($row->Totalhour!=""){
				$res['durationhours']=(int)$timeduration[0];
				$res['durationminutes']=(int)$timeduration[1];
			}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = TASK_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = TASK_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a TASKTable (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$taskid=$request[12];
		
		$sql1 = "SELECT * FROM task_master WHERE OrganizationId = :id and id = :taskid";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array(':id' => $orgid, ':taskid' => $taskid));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			while($row1 = $query1->fetch()) {
				$taskstatus1=$row1->taskstatus;
				$task_no=$row1->task_no;
				$title=$row1->task_title;
				$projectid=$row1->projectid;
				$assignedbyid=$row1->CreatedById;
				$assigntoid=$row1->assignto;
				$fromdate=$row1->fromdate;
				$todate=$row1->todate;
				$desc=$row1->description;
			}
        }
		$sql = "UPDATE task_master SET task_title=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?, projectid=?, milestoneid=?, assignto=?, description=?,fromdate=?,todate=?,priority=?,  Totalhour =? where id=?";
		$mdate = date("Y-m-d H:i:s");
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$from = Utils::getDateformat($request[7]);
			$to = Utils::getDateformat($request[8]);
			$timeduration = ($request[10].":".$request[11]);
			if($request[10]<=9 && $request[11]<=9){
				$timeduration1= '0'.$request[10].':'.'0'.$request[11];
			}else if($request[10]<=9 && $request[11]<>9){
				$timeduration1= '0'.$request[10] .':'.$request[11];
			}else if($request[10]<>9 && $request[11]<=9){
				$timeduration1=$request[10].':'.'0'.$request[11];
			}else{
				$timeduration1= $request[10] .':'.$request[11];
			}
			$newmindate= date('M d, Y ', strtotime($from));
			$newmaxdate= date('M d, Y ', strtotime($to));
			$query->execute(array($request[6], $orgid, $mdate, $mid, $request[2], $request[3], $request[4], $request[5],$from,$to,$request[9],$timeduration , $request[12]));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			///////Generate Activities Log File///////////
			$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
			$msg="Task <b>$title</b> has been updated by <b>$empname</b>";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Timesheet", $msg, $orgid));
			$assignedtoemail=Utils::decode5t(Utils::getName($assigntoid,'EmployeeMaster','CompanyEmail',$this->db));
				//$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid!=0)
					$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid==0){
					$projectname="Misc. Activities";
				}
				$assignedtoname=$this->getEmployeeName($assigntoid);
				$assignedbyname=$this->getEmployeeName($mid);
				$sub="Assigned Task Change: $task_no- $title";
				$msg="
				<table>
				<tr><td>Dear $assignedtoname,</td></tr>
				<tr><td></td></tr>
				<tr><td>Task: $task_no- $title has been Updated by $assignedbyname .</td></tr>
				<tr><td>Project: $projectname </td></tr>
				<tr><td>Task: $title </td></tr>
				<tr><td>Started on: From $newmindate to $newmaxdate </td></tr>
				<tr><td>Duration:  $timeduration1 </td></tr>
				
				
				</table>";
				Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg);
				Utils::Trace($assignedtoemail." ".$sub." ".$msg);
				// end send mail to assigned to//
		
		   $status =true;
		   $successMsg = TASK_MODULE_UPDATION_SUCCESS;
		} else {
		   $status =false;
		   $errorMsg = TASK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function UpdateTaskFile($request)
    {
	$model=json_decode($_POST['model']);
	$taskid=$model->taskid;
	$result = array();
	$count=0; $errorMsg=""; $successMsg=""; $status=false;
	$data = array();
	$mdate = date("Y-m-d H:i:s");
	$taskno="";
	$taskdocs="";
	$file_name = "";
	$uploadfiles="";
	
		/////////////////////// To take task number  and files/////////////////////////
	
	$sql1 = "SELECT * FROM task_master WHERE OrganizationId = :id and id = :taskid";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array(':id' => $orgid, ':taskid' => $taskid));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row1 = $query1->fetch())
			{
				$taskno=$row1->task_no;
				$taskdocs=$row1->taskdocs;
				
			}
        }
			//Utils::Trace("Task Docs before update ".$taskdocs);
	////////////////////// To take task number and files End /////////////////////////////
	
	//////////////////////File Uploads Starts////////////////////////////////
			if(isset($_FILES)){
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++){
			if(isset($_FILES['file'.$i])){
				
				$duplicatefile=false;
				$errors= array();
				$file_name = $_FILES['file'.$i]['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				$storage_name="";
				if($uploadfiles=="")
				$uploadfiles=$storage_name=$taskno."_".$file_name;
				else
				$uploadfiles.=",".$storage_name=$taskno."_".$file_name;
				if (!file_exists("public/uploads/taskdocs/")) {
						mkdir("public/uploads/taskdocs/", 0777, true);
				}
				if (file_exists("public/uploads/taskdocs/$storage_name"))
				{ 
						unlink("public/uploads/taskdocs/$storage_name"); 
						$duplicatefile=true;
				}
				//Utils::Trace($duplicatefile);
				$file_size =$_FILES['file'.$i]['size'];
				$file_tmp =$_FILES['file'.$i]['tmp_name'];
				$file_type=$_FILES['file'.$i]['type'];   
				$location="public/uploads/taskdocs/";
				if($file_size > 2097152){
				$errorMsg='File size must be less than 2 MB';
				}
				if(empty($errors)==true){
						$sts=move_uploaded_file($file_tmp, $location.$storage_name );
						if($sts){
							if(!$duplicatefile){
							$sql = "UPDATE task_master SET taskdocs=? where id=?";
							$mdate = date("Y-m-d H:i:s");
							$query = $this->db->prepare($sql);
							try{
							
							if($taskdocs!=""){
							$taskdocs.=",".$storage_name;
				 
							}else{
							$taskdocs=$storage_name;
							}
					
							$query->execute(array($taskdocs,$taskid));			
							$count =  $query->rowCount();
							//if($count>=1)
							//Utils::Trace("Task Docs after update ".$taskdocs);
						
							}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
							}	
						}
						}
					}else{
					print_r($errors);
				}
			}
			}
			}
			
		
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		// default return
        return $result;
    }

   
    /**
     * Setter for a TASKTable (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request) {
		$model=json_decode($_POST['model']);
		$projectid=$model->projectid;
		$milestoneid=$model->milestoneid;
		$assignto="";
		$assignto =$model->assignto;
		
		$desc=$model->desc;
		$title=$model->title;
		$fromdate=$model->fromdate;
		$todate=$model->todate;
		$durationhours=$model->durationhours;
		$durationminutes=$model->durationminutes;
		$priority=$model->priority;
		$taskstatus=1;
		$miscunduct=$model->miscunduct;
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$task_id="";
		$file_name = "";
		$uploadfiles="";
		 $timeduration="";
		$timeduration = ($durationhours.":".$durationminutes);
		if($durationhours<=9 && $durationminutes<=9){
			$timeduration1= '0'.$durationhours.':'.'0'.$durationminutes;
		}else if($durationhours<=9 && $durationminutes<>9){
			$timeduration1= '0'.$durationhours .':'.$durationminutes;
		}else if($durationhours<>9 && $durationminutes<=9){
			$timeduration1=$durationhours.':'.'0'.$durationminutes;
		}else{
			$timeduration1= $durationhours .':'.$durationminutes;
		}
		$newmindate= date('M d, Y ', strtotime(Utils::getDateformat($fromdate)));
		$newmaxdate= date('M d, Y ', strtotime(Utils::getDateformat($todate)));
		/////////////////////// To Make task number /////////////////////////
		$query1 = $this->db->prepare("SELECT max(id)+1 as maxid FROM task_master");
		$query1->execute();
		if ($row1=$query1->fetch()) {
			$num1 =str_pad($row1->maxid, 4, '0', STR_PAD_LEFT);
			$task_id="TSK-".$num1;
		}
		////////////////////// To Make task number End /////////////////////////////
		//////////////////////File Uploads Starts////////////////////////////////
		if(isset($_FILES)){
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++){
				if(isset($_FILES['file'.$i])){
					$duplicatefile=false;
					$errors= array();
					$file_name = $_FILES['file'.$i]['name'];
					$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
					$storage_name="";
					$storage_name=$task_id."_".$file_name;
					if (!file_exists("public/uploads/taskdocs/")) {
						mkdir("public/uploads/taskdocs/", 0777, true);
					}
					if (file_exists("public/uploads/taskdocs/$storage_name")) { 
						unlink("public/uploads/taskdocs/$storage_name"); 
						$duplicatefile=true;
					}
					if(!$duplicatefile){
						if($uploadfiles=="")
						$uploadfiles=$storage_name;
						else
						$uploadfiles.=",".$storage_name;
					}
					$file_size =$_FILES['file'.$i]['size'];
					$file_tmp =$_FILES['file'.$i]['tmp_name'];
					$file_type=$_FILES['file'.$i]['type'];   
					$location="public/uploads/taskdocs/";
					if($file_size > 2097152){
						$errorMsg='File size must be less than 2 MB';
					}
					if(empty($errors)==true){
						move_uploaded_file($file_tmp, $location.$storage_name );
					}else{
						print_r($errors);
					}
				}
			}
		}
		//////For Multiple Employee Assigned Multiple Task//////////////
		
		for($e=0;$e<count($assignto);$e++)	{
			$sql = "INSERT INTO task_master (task_title,  OrganizationId,  CreatedDate, CreatedById, projectid, milestoneid, assignto, description,fromdate,todate, Totalhour, priority, taskstatus, miscunduct, task_no,taskdocs) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				$from = Utils::getDateformat($fromdate);
				$to = Utils::getDateformat($todate);
				$query = $this->db->prepare($sql);
				$query->execute(array($title, $orgid, $mdate, $mid, $projectid, $milestoneid, $assignto[$e], $desc,$from,$to,$timeduration, $priority, $taskstatus, $miscunduct,$task_id,$uploadfiles));
				$count =  $query->rowCount();			
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if ($count == 1) {
			/*generate mail and alert for task assigned*/
			$tid=$this->db->LastInsertId();
			Alerts::generateActionAlerts(19,$tid,$orgid,$this->db);
			//////////Generate Activites Logs File///////////////
			$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
			$msg="Task <b>$title</b> has been created by <b>$empname</b>";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Timesheet", $msg, $orgid));
			
			///// send mail to assigned_to//////
			
			$assignedtoemail=Utils::decode5t(Utils::getName($assignto[$e],'EmployeeMaster','CompanyEmail',$this->db));
			$assignedbyemail=Utils::decode5t(Utils::getName($mid,'EmployeeMaster','CompanyEmail',$this->db));
			/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
			$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
			$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
			$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
			/////////Get Project Name//////////////
			if($projectid!=0)
				$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
			if($projectid==0){
				$projectname="Misc. Activities";
			} 
			///////Get Name Assigned To & Assigned BY/////////////
			$assignedbyname=$this->getEmployeeName($mid);
			$assignedtoname=$this->getEmployeeName($assignto[$e]);
			/////////Send Mail/////////
			if($mid==$ProjectLeadID && $ProjectLeadID!=""){
				/////Send Mail To ProjectManager/////////
				if($ProjectmanagerID!=""){
					$Projectmanageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
					$Projectmanagername=$this->getEmployeeName($ProjectmanagerID);
					$sub="Task '$title' has been assigned by $assignedbyname to $assignedtoname";
					$msg="
					<table>
						<tr><td>Dear <b>$Projectmanagername</b>,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> has been assigned  by <b>'$assignedbyname'<b> to <b>'$assignedtoname'</b>.</td></tr
						<tr><td>Project: $projectname </td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>End Date: $newmaxdate </td></tr>
						<tr><td>Estimated Hours: $timeduration1 </td></tr>
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($Projectmanageremail,$assignedbyemail,$sub,$msg);
					Utils::Trace($sts." ".$Projectmanageremail." ".$sub." ".$msg);
				}else{
					/////Send Mail To ClientHead/////////
					$clientheademail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
					$ClientHeadname=$this->getEmployeeName($clientheadID);
					$sub="Task '$title' has been assigned by $assignedbyname to $assignedtoname";
					$msg="
					<table>
						<tr><td>Dear <b>$ClientHeadname</b>,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> has been assigned  by <b>'$assignedbyname'<b> to <b>'$assignedtoname'</b>.</td></tr
						<tr><td>Project: $projectname </td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>End Date: $newmaxdate </td></tr>
						<tr><td>Estimated Hours: $timeduration1 </td></tr>
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($clientheademail,$assignedbyemail,$sub,$msg);
					Utils::Trace($sts." ".$clientheademail." ".$sub." ".$msg);
				}
				////////Send Mail To Assigned To/////////////
					$sub1="Task '$title' is assigned by $assignedbyname ";
					$msg1="
					<table>
						<tr><td>Dear <b>$assignedtoname</b>,</td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> is assigned  by <b>'$assignedbyname'</b> to <b>'$assignedtoname'</b>.</td></tr
						<tr><td>Project: $projectname </td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>End Date: $newmaxdate </td></tr>
						<tr><td>Estimated Hours: $timeduration1 </td></tr>
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($assignedtoemail,$assignedbyemail,$sub1,$msg1);
					Utils::Trace($sts." ".$assignedtoemail." ".$sub1." ".$msg1);
			}/////////Send Mail BY ProjectManager////////////////
			else if($ProjectmanagerID!="" && $mid==$ProjectmanagerID ) {
				/////Send Mail To ClientHead/////////
				$clientheademail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
				$ClientHeadname=$this->getEmployeeName($clientheadID);
				$sub="Task '$title' has been assigned by $assignedbyname to $assignedtoname";
				$msg="
				<table>
					<tr><td>Dear <b>$ClientHeadname</b>,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: <b>'$title'</b> has been assigned  by <b>'$assignedbyname'<b> to <b>'$assignedtoname'</b>.</td></tr
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 </td></tr>
				</table>";
				//Utils::Trace($sub." ".$msg);
				$sts=Utils::sendMail($clientheademail,$assignedbyemail,$sub,$msg);
				Utils::Trace($sts." ".$clientheademail." ".$sub." ".$msg);
				////////Send Mail To Assigned To/////////////
				$sub1="Task '$title' is assigned by $assignedbyname ";
				$msg1="
				<table>
					<tr><td>Dear <b>$assignedtoname</b>,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: <b>'$title'</b> is assigned  by <b>'$assignedbyname'<b> to <b>'$assignedtoname'<b>.</td></tr
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 </td></tr>
				</table>";
				//Utils::Trace($sub." ".$msg);
				$sts=Utils::sendMail($assignedtoemail,$assignedbyemail,$sub1,$msg1);
				Utils::Trace($sts." ".$assignedtoemail." ".$sub1." ".$msg1);
			}////////Send Mail By ClientHead////////
			else if($mid==$clientheadID){
				$sub="Task '$title' is assigned by $assignedbyname ";
				$msg="
				<table>
					<tr><td>Dear <b>$assignedtoname</b>,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: <b>'$title'</b> is assigned  by <b>'$assignedbyname'</b> to <b>'$assignedtoname'</b>.</td></tr
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 </td></tr>
				</table>";
				//Utils::Trace($sub." ".$msg);
				$sts=Utils::sendMail($assignedtoemail,$assignedbyemail,$sub,$msg);
				Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
			}
			$status =true;
		  $successMsg = "Task assigned successfully!";
		}else {
		   $status =false;
		   $errorMsg = TASK_MODULE_CREATION_FAILED;
		}
			///// end send mail to assigned_to//////
		}
		
		   
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
		$tasktitle=$this->getDetail($did);
		if($tasktitle!=""){
			$title=$tasktitle['data'][0]['task_title'];
		}
		$sql = "DELETE FROM task_master WHERE id = :id ";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
	
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	
		if ($count == 1) {
			//////////Generate Activites Logs File///////////////
			
			$msg="Task <b>$title</b> has been deleted by <b>$empname</b>";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Timesheet", $msg, $orgid));
			$status =true;
			$successMsg = TASK_MODULE_DELETE_SUCCESS;
		}else {
		   $status =false;
			   $errorMsg = TASK_MODULE_DELETE_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function AddTasksStatus($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $request[0];
		$admin=0; $rid=0;
		$taskid="";
		$title="";
		$projectid="";
		$assignedbyid="";
		$fromdate="";
		$todate="";
		$desc="";
		$sql = "select * from task_master WHERE OrganizationId =? and id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[0], $request[1] ));
		while($row = $query->fetch()) {
			$admin=$row->taskstatus;
			$taskid=$row->task_no;
			$title=$row->task_title;
			$projectid=$row->projectid;
			
			$assignedbyid=$row->CreatedById;
			$assigntoid=$row->assignto;
			$fromdate=Utils::dateformatter($row->fromdate);
			$todate=Utils::dateformatter($row->todate);
			$totoalhour="";
			$totoalhour= explode(":",$row->Totalhour);
			if($row->Totalhour!=""){
					//$duration= '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
				if($totoalhour[0]<=9 && $totoalhour[1]<=9){
					$duration = '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
				}else if($totoalhour[0]<=9 && $totoalhour[1]<>9){
					$duration = '0'.$totoalhour[0] .':'.$totoalhour[1];
				}else if($totoalhour[0]<>9 && $totoalhour[1]<=9){
					$duration= $totoalhour[0] .':'.'0'.$totoalhour[1];
				}else{
					$duration= $totoalhour[0] .':'.$totoalhour[1];
				}
			}
			$desc=$row->description;
			$sql1 = "select * from timesheet_master WHERE OrganizationId =? and task_id = ? order by id desc";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($request[0], $request[1] ));
			while($row1 = $query1->fetch()) {
				$mindate=$row1->timesheetstart;
				$newmindate= date('M d, Y ', strtotime($mindate));
				$maxdate=$row1->timesheetend;
				//$newmaxdate= date('H:i A , M d, Y ', strtotime($maxdate));
				$totaltime= date('H:i', strtotime($row1->total_time));
				$timesheetdesc= $row1->description;
			}
		}
		if($admin==1 or $admin==5){
			$sql = "UPDATE task_master SET taskstatus = ? WHERE  id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( 2,$request[1] ));
			$count = $query->rowCount();
			if($count>=1)	{
			/*generate mail and alert for task assigned*/
			Alerts::generateActionAlerts(22,$request[1],$orgid,$this->db);
			
			/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
				$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
				$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
				$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
				/////////Get Project Name//////////////	
				if($projectid!=0)
					$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid==0){
					$projectname="Misc. Activities";
				}
				///Get Assigned To Name////////
				$assignedtoname=Utils::getEmployeeName($assigntoid,$this->db);
				///////Get Assigned by name/////////
				$assignedbyemail=Utils::decode5t(Utils::getName($assignedbyid,'EmployeeMaster','CompanyEmail',$this->db));
				$assignedbyname=Utils::getEmployeeName($assignedbyid,$this->db);
				/////////Approved Reject Link//////
				$compeletedlink=URL."approvalbymail/taskcompeleteapproval/$request[1]/$assignedbyid/$orgid/4";
				$reassignlink=URL."approvalbymail/taskcompeleteapproval/$request[1]/$assignedbyid/$orgid/5";
				// Start Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
				if($clientheadID!=""){
					$Clientemail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
					$Clientname=Utils::getEmployeeName($clientheadID,$this->db);
				}
				if($ProjectmanagerID!=""){
					$ProManageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
					$ProManagername=Utils::getEmployeeName($ProjectmanagerID,$this->db);
				}	
				if($ProjectLeadID!=""){
					$ProLeademail=Utils::decode5t(Utils::getName($ProjectLeadID,'EmployeeMaster','CompanyEmail',$this->db));
					$ProLeadname=Utils::getEmployeeName($ProjectLeadID,$this->db);
				}
				// End Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
				//////////////////////	
				if($assigntoid==$ProjectLeadID && $ProjectLeadID!=""){
					if($assigntoid!=$assignedbyid){
						////////Send Mail ProjectManager///////////
						if($ProjectmanagerID!="" && $ProjectmanagerID==$assignedbyid){
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$ProManagername,</b> </td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b> assigned to <b>$assignedtoname</b> has been submitted.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Hours: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
							$msg1="
							<table>
							<tr><td>Dear <b>$Clientname,</b> </td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b> assigned to <b>$assignedtoname</b> by <b>$assignedbyname</b>  has been submitted.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Hours: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							</table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg1);
						}else{
							////////Send Mail Assigned By/////
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$assignedbyname,</b> </td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b> assigned to <b>$assignedtoname</b> has been submitted.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Hours: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							
							$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
						}
					}else{
						////////Send Mail ProjectManager///////////
						if($ProjectmanagerID!=""){
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$ProManagername,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Hours: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
							$msg1="
							<table>
							<tr><td>Dear <b>$Clientname,<b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task:  <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							</table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg1);
						}else{
							////////Send Mail ClientHead///////////
							$sub="Task <b>'$title'</b> is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$Clientname,<b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
						}
					}
				}elseif($assigntoid==$ProjectmanagerID && $ProjectmanagerID!=""){
					if($assigntoid!=$assignedbyid){
						////////Send Mail Assigned By///////////
						$sub="Task '$title' is submitted by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear <b>$assignedbyname,</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> assigned to <b>$assignedtoname</b> has been submitted.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $totaltime hours</td></tr>
						<tr><td>Description: $timesheetdesc</td></tr>
						<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
						</td></tr></table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}else{
						////////Send Mail ClientHead///////////
						$sub="Task '$title' is submitted by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear <b>$Clientname,</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $totaltime hours</td></tr>
						<tr><td>Description: $timesheetdesc</td></tr>
						<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
						</td></tr></table>";
						$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
					}
				}else if($assigntoid==$clientheadID){
					if($assigntoid!=$assignedbyid){
						///////Send Mail ClientHead To////////
						$sub="Task '$title' is submitted by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear <b>$assignedbyname,</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> assigned to <b>$assignedtoname</b> has been submitted.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $totaltime hours</td></tr>
						<tr><td>Description: $timesheetdesc</td></tr>
						<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
						</td></tr></table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}else{
						/////Send Mail To Reporting To Person /////////
						$sendmail=Utils::getSeniorId($assigntoid,$this->db);
						$assignedbyemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
						$assignedbyname=Utils::getEmployeeName($sendmail,$this->db);
						$sub="Task '$title' is submitted by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear <b>$assignedbyname,</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $totaltime hours</td></tr>
						<tr><td>Description: $timesheetdesc</td></tr>
						<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
						</td></tr></table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}	
				}else{
					if($assigntoid==$assignedbyid){
						//////Send Mail ProjectLead//////////
						if($ProjectLeadID!=""){
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$ProLeadname,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							$sts=Utils::sendMail($ProLeademail,$assignedtoname,$sub,$msg);
							
							$msg1="
							<table>
							<tr><td>Dear <b>$ProManagername,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							</table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg1);
							
						}else if($ProjectmanagerID!=""){
							//////Send Mail ProjectManager//////////
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$ProManagername,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
							$msg1="
							<table>
							<tr><td>Dear <b>$Clientname,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							</table>";
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg1);
						}else {
							//////Send Mail ClientHead//////////
							$sub="Task '$title' is submitted by $assignedtoname";
							$msg="
							<table>
							<tr><td>Dear <b>$Clientname,</b></td></tr>
							<tr><td></td></tr>
							<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
							<tr><td>Project: $projectname</td></tr>
							<tr><td>Start Date: $newmindate</td></tr>
							<tr><td>Logged Time: $totaltime hours</td></tr>
							<tr><td>Description: $timesheetdesc</td></tr>
							<tr><td><br/><br/>
							<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
							&nbsp;&nbsp;
							&nbsp;&nbsp;
							<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
							<br/><br/>
							</td></tr></table>";
							
							$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
						}
					}else{
						//////////Send Mail Assigned By/////////
						$sub="Task '$title' is submitted by $assignedtoname";
						$msg="
						<table>
						<tr><td>Dear <b>$assignedbyname,</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b>assigned to self has been submitted by <b>$assignedtoname</b>.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>Logged Time: $totaltime hours</td></tr>
						<tr><td>Description: $timesheetdesc</td></tr>
						<tr><td><br/><br/>
						<a href='$compeletedlink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green; -webkit-border-radius: 4px;  -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$reassignlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
						</td></tr></table>";
						$sts=Utils::sendMail($assignedbyemail,$assignedtoname,$sub,$msg);
					}
				}
				Utils::Trace($sts." ".$assignedbyemail." ".$sub." ".$msg);
				$status =true;
				$successMsg=TASK_MODULE_UPDATION_SUCCESS;
			}	
			else {
			   $status =false;
			   $errorMsg=TASK_MODULE_UPDATION_FAILED;
			}
		} else{
			$status =true;
				 $successMsg="No permission to change status";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDataTable($editper, $deleteper, $type)
	{
		$sTable = 'task_master';
		$sIndexColumn = "id";
		$aColumns = array('task_title','projectid','milestoneid','assignto','CreatedById','fromdate','todate','Totalhour','id','id','id', 'id','id','taskstatus', 'id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			if($type==1){
				$sOrder = "ORDER BY fromdate desc, ";
			}
			elseif($type==2){
				$sOrder = "ORDER BY projectid, ";
			}elseif($type==3){
				$sOrder = "ORDER BY assignto, ";
			}else{
				$sOrder = "ORDER BY  ";
			}
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid and assignto in (select Id from EmployeeMaster where Is_Delete=0) ";
		}else{
			//$ids = Utils::getReportingIds($userid, $this->db).",".$userid;
			//$sWhere = " WHERE (CreatedById in ($ids) AND OrganizationId= $orgid)";
			$sWhere = " WHERE (projectid in (select id from project_master where (owner_id=$userid or ClientManager=$userid or ProjectLead =$userid)) AND OrganizationId= $orgid and assignto in (select Id from EmployeeMaster where Is_Delete=0))";
			}
	
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="assignto"){
					
				$sWhere .= " (assignto in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";//and
								//FiscalId=$fiscalid
				}
				elseif($aColumns[$i]=="projectid"){
					$sWhere .= " (projectid in ( select id from project_master where project_title LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($i==5){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==3){
					$sWhere = substr_replace( $sWhere, "", -4 );
					continue;
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		Utils::Trace("Datatable task: ".$sQuery);
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id" && $i==14)
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'tasks/edittask/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/'.$type.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				/* elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				} */
				else if($aColumns[$i]=="task_title")
				{
					$row[] = '<a href="'.URL.'tasks/viewtask/'.Utils::encode5t($aRow->id).'/'.$type.'/1" title="Task Details" rel="tooltip">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else if($aColumns[$i]=="Totalhour")
				{
					$totoalhour="";
					$totoalhour= explode(":",$aRow->Totalhour);
					if($aRow->Totalhour!=""){
						if($totoalhour[0]<=9 && $totoalhour[1]<=9){
								$row[] = '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
						}else if($totoalhour[0]<=9 && $totoalhour[1]<>9){
							$row[] = '0'.$totoalhour[0] .':'.$totoalhour[1];
						}else if($totoalhour[0]<>9 && $totoalhour[1]<=9){
							$row[] = $totoalhour[0] .':'.'0'.$totoalhour[1];
						}else{
								$row[] = $totoalhour[0] .':'.$totoalhour[1];
						}
				
					}else{
						$row[] ="";
					}
				}
				else if($aColumns[$i]=="taskstatus"){
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-danger'>Assigned</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Submitted</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-info'>Archive</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-success'>Approved</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Re-opened</span>";
					$row[] = $sts;
				}
				else if($aColumns[$i]=="fromdate" || $aColumns[$i]=="todate"){
											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="projectid"){
											
					$row[] = $this->getProjectName($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="assignto"){
											
					$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="milestoneid"){
					
					if($aRow->{$aColumns[$i]}!=0){						
					$milestone=Utils::getName($aRow->{$aColumns[$i]},'SettingMilestone','Name',$this->db); 
					$row[]=$milestone;
					}
					else{
						$row[]="Other";
					}
					
				}
					else if($aColumns[$i]=="id" && $i==8){
					if($aRow->taskstatus==2 || $aRow->taskstatus==4 ){
						list($totalhour,$totalminute)=$this->getTaskDelayHours($aRow->{$aColumns[$i]},1); 
						if($totalhour!="" || $totalminute!=""){
							if($totalhour<=9 && $totalminute<=9){
								$row[] = '0'.$totalhour .':'.'0'.$totalminute;
							}else if($totalhour<=9 && $totalminute<>9){
								$row[] = '0'.$totalhour .':'.$totalminute;
							}else if($totalhour<>9 && $totalminute<=9){
								$row[] = $totalhour .':'.'0'.$totalminute;
							}else{
									$row[] = $totalhour .':'.$totalminute;
							}
						}else{
							$row[] ="";
						}
					}else{
						$row[]="";
					} 
				}else if($aColumns[$i]=="id" && $i==9){
						
					if($aRow->taskstatus==2 || $aRow->taskstatus==4 ){
						$timediff="";
						$acttotal_time=$this->getTaskDelayHours($aRow->{$aColumns[$i]},2); 
						try{
						$datetime1 = new DateTime($acttotal_time);
						$datetime2 = new DateTime($aRow->Totalhour);
						$interval = $datetime1->diff($datetime2);
					    $timediff=$interval->format('%H:%I');
						/* $time1 = strtotime($acttotal_time);
						$time2 = strtotime($aRow->Totalhour);
						$diff = $time1 - $time2; */
						//echo $diff.'<br>'; 
						//$timediff = date('H:i', $diff);
						}catch(Exception $e){}
						$row[]=$timediff;
					}else{
						$row[]="";
					}
				}
				else if($aColumns[$i]=="id" && $i==10){
				
					if($aRow->taskstatus==2 || $aRow->taskstatus==4 ){					
						$start=$this->getTaskDelayDay($aRow->{$aColumns[$i]}); 
						$row[]=  Utils::dateformatter($start);
					}else{
							$row[]="";
					}
				}else if($aColumns[$i]=="id" && $i==11){
					$days1=''; 
					if($aRow->taskstatus==2 || $aRow->taskstatus==4 ){
						$start=$this->getTaskDelayDay($aRow->{$aColumns[$i]}); 
						$today= $aRow->todate;
						if($start!="0000-00-00"  && $today!="0000-00-00"){
							if( strtotime($today) < strtotime($start)) {
								$days1 = (strtotime($start)- strtotime($today)  );
								$totalday1 = floor($days1/(60*60*24));		
								$row[] =$totalday1;
							}else{
								$row[]="";
							}
						}else{
								$row[]="";
							}
					}else{
								$row[]="";
							}
				}else if($aColumns[$i]=="id" && $i==12){
											
					$row[] =$this->getTaskComment($aRow->{$aColumns[$i]}); 
				}
			
				else if($aColumns[$i]=="CreatedById"){
											
					$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]});
				}
				/* else if($aColumns[$i]=="status")
				{
						if($aRow->{$aColumns[$i]}==1){
						$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->id."')\" ><span class='badge bg-aqua'>Open</span></a>";
							
						}
						else{
							if($aRow->{$aColumns[$i]}==0){
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->id."')\" ><span class='badge bg-red'>Close</span></a>";
							}
						}
					
				} */
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	} 
	
		public function getProfileTaskDataTable($request)
		{
		$sTable = 'task_master';
		$sIndexColumn = "id";
		$aColumns = array('projectid','milestoneid','task_title','CreatedById','fromdate','todate','Totalhour','taskstatus', 'id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  id desc,";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$type=$request[2];
		$typecond="";
		if($type!=6)
		$typecond = " and taskstatus = $type";
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		/* if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid  ";
		}else{ */
			
			$sWhere = " WHERE (OrganizationId= $orgid and assignto=$userid. $typecond )";
	/* 	} */
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				$status=0;
				if($aColumns[$i]=="id")
				{
					 $view=""; $changestatus="";$addtimesheet="";
				$status=$aRow->{$aColumns[7]};
						
					if($status==1 or $status==5)
					//	$changestatus='<a rel="tooltip" title="Submit Task" data-toggle="modal" data-target="#confirm1" href="#" onclick="angular.element(this).scope().getId('.$aRow->id.')" ><i class="fa fa-thumbs-up"></i></a>';
					
						$view = '<a rel="tooltip" title="View Task" href="'.URL.'profile/viewtask/'.Utils::encode5t($aRow->id).'/1/'.$type.'"><i class="fa fa-eye"></i></a>';
						
					if($status==1 or $status==5)	
						$addtimesheet='<a  rel="tooltip" href="#"  onclick="angular.element(this).scope().addtimesheet(\''.$aRow->projectid.'\', \''.$aRow->id.'\')"  title="Task Done"><i class="fa fa-thumbs-up"></i> </a>';
					
					$row[] =$view."&nbsp;&nbsp;".$addtimesheet;
				}
				/* elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				} */
				else if($aColumns[$i]=="task_title")
				{
					$row[] = '<a href="'.URL.'profile/viewtask/'.Utils::encode5t($aRow->id).'/1/1" title="View Task" rel="tooltip">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else if($aColumns[$i]=="taskstatus"){
					
					if($aRow->{$aColumns[$i]}==1)
						$sts="<span class='label label-danger'>Assigned</span>";
					else if($aRow->{$aColumns[$i]}==2)
						$sts="<span class='label label-warning'>Submitted</span>";
					else if($aRow->{$aColumns[$i]}==3)
						$sts="<span class='label label-info'>Archive</span>";
					else if($aRow->{$aColumns[$i]}==4)
						$sts="<span class='label label-success'>Approved</span>";
					else if($aRow->{$aColumns[$i]}==5)
						$sts="<span class='label label-primary'>Re-opened</span>";
					$row[] = $sts;
				}
				else if($aColumns[$i]=="fromdate" || $aColumns[$i]=="todate"){
											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				else if($aColumns[$i]=="Totalhour")
				{
					$totoalhour="";
					$totoalhour= explode(":",$aRow->Totalhour);
					if($aRow->Totalhour!=""){
						if($totoalhour[0]<=9 && $totoalhour[1]<=9){
								$row[] = '0'.$totoalhour[0] .':'.'0'.$totoalhour[1];
						}else if($totoalhour[0]<=9 && $totoalhour[1]<>9){
							$row[] = '0'.$totoalhour[0] .':'.$totoalhour[1];
						}else if($totoalhour[0]<>9 && $totoalhour[1]<=9){
							$row[] = $totoalhour[0] .':'.'0'.$totoalhour[1];
						}else{
								$row[] = $totoalhour[0] .':'.$totoalhour[1];
						}
				
					}else{
						$row[] ="";
					}
				}
				else if($aColumns[$i]=="projectid"){
											
					$row[] = $this->getProjectName($aRow->{$aColumns[$i]});
				}else if($aColumns[$i]=="milestoneid"){
						if($aRow->{$aColumns[$i]}!=0)					
						$row[] =Utils::getName($aRow->{$aColumns[$i]},'SettingMilestone','Name',$this->db); 
					else
						$row[]="Other";
				}
				else if($aColumns[$i]=="CreatedById"){
											
					$row[] = $this->getEmployeeName($aRow->{$aColumns[$i]});
				}
				/* else if($aColumns[$i]=="status")
				{
						if($aRow->{$aColumns[$i]}==1){
						$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->id."')\" ><span class='badge bg-aqua'>Open</span></a>";
							
						}
						else{
							if($aRow->{$aColumns[$i]}==0){
								$row[]=	"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->id."')\" ><span class='badge bg-red'>Close</span></a>";
							}
						}
					
				} */
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	} 
	
		public function getProjectName($id){
		  $name="";
		  $sql = "SELECT * FROM project_master WHERE id = :id";
        $query = $this->db->prepare($sql);
	
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				
				while($row = $query->fetch())
				{
					$name = $row->project_title;
				}
			}
			if($id==0)
			$name = "Other";
		return $name;
	}
	public function getTaskDelayDay($id)
	{
		$name ="";
		$sql = "SELECT * FROM timesheet_master WHERE task_id = :id order by id desc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->timesheetstart;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getTaskDelayHours($id,$val)
	{
		$totalhour1=0;$totalminute1=0;$hours1='';$minutes1='';$acttotal_time ="";
		$sql = "SELECT total_time FROM timesheet_master WHERE task_id = :id order by id desc";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$start = explode(":", $row->total_time);
				if($row->total_time!=""){
					$hours1= $start[0];
					$totalhour1=$totalhour1+$hours1;
					$minutes1 = $start[1];
					$totalminute1=$totalminute1+$minutes1;
					if($totalminute1>60){
						$totalhour1=$totalhour1+1;
						$totalminute1=$totalminute1-60;
					}
				}
			}
			
		}catch(Exception $e) {
			
		}
		$acttotal_time = $totalhour1.':'.$totalminute1;
		if($val==1)
		return array($totalhour1,$totalminute1);
		if($val==2)
		return $acttotal_time;
	}
	public function getTaskComment($id)
	{
		$name ="";
		$sql = "SELECT * FROM task_comments WHERE taskid = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->comment;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeName($id){
		$name="";
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		$query->execute(array(':id' => $id ));
		$count =  $query->rowCount();
		if($count>=1) {
			while($row = $query->fetch()) {
				$name = $row->FirstName." ".$row->LastName;
			}
        }
		return $name;
	}
	
	public function uploadFile($request)
	{
			try {
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$model=json_decode($_POST['model']);
			//print_r($model);
			/*echo $model->name;
			echo $model->comments; */
			$file_name = "";
			if(isset($_FILES)){
				
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++){
			if(isset($_FILES['file'.$i])){
				
				$errors= array();
				$file_name = $_FILES['file'.$i]['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				
				$storage_name="abc$i.$ext";
					if (!file_exists("public/uploads/")) {
						mkdir("public/uploads/", 0777, true);
						}
				if (file_exists($storage_name))
				{ 
						unlink("public/uploads/$storage_name"); 
				}

				$file_size =$_FILES['file'.$i]['size'];
				$file_tmp =$_FILES['file'.$i]['tmp_name'];
				$file_type=$_FILES['file'.$i]['type'];   
				$location="public/uploads/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					
				}else{
					print_r($errors);
				}
			}else{
				echo "not isset";
			}
			}
			}else{
				echo "else";
			}
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';

			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
	}
	////////////Create Profile task //////////////////
	public function CreateProfileTask($request)  {
		
		$projectid=$request[2];
		$milestoneid=$request[3];
		$assignto=$request[4];
		$desc=$request[5];
		$title=$request[6];
		$fromdate=$request[7];
		$todate=$request[8];
		$durationhours=$request[10];
		$durationminutes=$request[11];
		$priority=$request[9];
		$taskstatus=1;
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		 $timeduration="";
		$timeduration = ($durationhours.":".$durationminutes);
		if($durationhours<=9 && $durationminutes<=9){
			$timeduration1= '0'.$durationhours.':'.'0'.$durationminutes;
		}else if($durationhours<=9 && $durationminutes<>9){
			$timeduration1= '0'.$durationhours .':'.$durationminutes;
		}else if($durationhours<>9 && $durationminutes<=9){
			$timeduration1=$durationhours.':'.'0'.$durationminutes;
		}else{
			$timeduration1= $durationhours .':'.$durationminutes;
		}
		$newmindate= date('M d, Y ', strtotime(Utils::getDateformat($fromdate)));
		$newmaxdate= date('M d, Y ', strtotime(Utils::getDateformat($todate)));
		/////////////////////// To Make task number /////////////////////////
		$query1 = $this->db->prepare("SELECT max(id)+1 as maxid FROM task_master");
		$query1->execute();
		if ($row1=$query1->fetch()) {
			$num1 =str_pad($row1->maxid, 4, '0', STR_PAD_LEFT);
			$task_id="TSK-".$num1;
		}
		////////////////////// To Make task number End /////////////////////////////
		
		$sql = "INSERT INTO task_master (task_title,  OrganizationId,  CreatedDate, CreatedById, projectid, milestoneid, assignto, description,fromdate,todate, Totalhour, priority, taskstatus, task_no) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$from = Utils::getDateformat($fromdate);
			$to = Utils::getDateformat($todate);
			$query = $this->db->prepare($sql);
			$query->execute(array($title, $orgid, $mdate, $mid, $projectid, $milestoneid, $assignto, $desc,$from,$to,$timeduration, $priority, $taskstatus,$task_id));
			$count =  $query->rowCount();		
		}catch(Exception $e){
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1){
			/*generate mail and alert for task assigned*/
			$tid=$this->db->LastInsertId();
			Alerts::generateActionAlerts(19,$tid,$orgid,$this->db);
			//////////Generate Activites Logs File///////////////
			$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
			$msg="<b>$empname</b> has assigned Task <b>$title</b> to self ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Self Service", $msg, $orgid));
			///////Send Mail //////////////////
			///// send mail to assigned_to//////
			$assignedtoemail=Utils::decode5t(Utils::getName($assignto,'EmployeeMaster','CompanyEmail',$this->db));
			/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
			$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
			$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
			$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
			if($clientheadID!=""){
				$Clientemail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
				$Clientname=Utils::getEmployeeName($clientheadID,$this->db);
			}
			if($ProjectmanagerID!=""){
				$ProManageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProManagername=Utils::getEmployeeName($ProjectmanagerID,$this->db);
			}	
			if($ProjectLeadID!=""){
				$ProLeademail=Utils::decode5t(Utils::getName($ProjectLeadID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProLeadname=Utils::getEmployeeName($ProjectLeadID,$this->db);
			}
			/////////Get Project Name//////////////
			if($projectid!=0)
				$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
			if($projectid==0){
				$projectname="Misc. Activities";
			} 
			///////Get Name Assigned To & Assigned BY/////////////
			$assignedbyname=$this->getEmployeeName($mid);
			$assignedtoname=$this->getEmployeeName($assignto);
			/////////Send Mail/////////
			if($mid==$ProjectLeadID && $ProjectLeadID!=""){
				/////Send Mail To ProjectManager/////////
				if($ProjectmanagerID!=""){
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $ProManagername,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$ProManageremail." ".$sub." ".$msg);
				}else{
					/////Send Mail To ClientHead/////////
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $Clientname,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$Clientemail." ".$sub." ".$msg);
				}	
			}/////////Send Mail BY ProjectManager////////////////
			else if($ProjectmanagerID!="" && $mid==$ProjectmanagerID ) {
				/////Send Mail To ClientHead/////////
				$sub="Task '$title' has been assigned  by $assignedtoname to self";
				$msg="
				<table>
				<tr><td>Dear $Clientname,</td></tr>
				<tr><td></td></tr>
				<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
				<tr><td>Project: $projectname </td></tr>
				<tr><td>Start Date: $newmindate</td></tr>
				<tr><td>End Date: $newmaxdate </td></tr>
				<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
				</table>";
				//Utils::Trace($sub." ".$msg);
				$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
				Utils::Trace($sts." ".$Clientemail." ".$sub." ".$msg);
			}////////Send Mail By ClientHead////////
			else if($mid==$clientheadID){
				/////Send Mail To Reporting To Person /////////
				$sendmail=Utils::getSeniorId($assignto,$this->db);
				$assignedemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
				$assignedname=Utils::getEmployeeName($sendmail,$this->db);
				$sub="Task '$title' has been assigned  by $assignedtoname to self";
				$msg="
				<table>
				<tr><td>Dear $assignedname,</td></tr>
				<tr><td></td></tr>
				<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
				<tr><td>Project: $projectname </td></tr>
				<tr><td>Start Date: $newmindate</td></tr>
				<tr><td>End Date: $newmaxdate </td></tr>
				<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
				
				</table>";
				//Utils::Trace($sub." ".$msg);
				$sts=Utils::sendMail($assignedemail,$assignedtoname,$sub,$msg);
				Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
			}
			else{
				if($ProjectLeadID!=""){
					////////Send Mail Project Lead//////
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $ProLeadname,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					
					</table>";
					$sts=Utils::sendMail($ProLeademail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$ProLeademail." ".$sub." ".$msg);
				}else if($ProjectmanagerID!=""){
					///////Send Mail Project Manager///////
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $ProManagername,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($ProManageremail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$ProManageremail." ".$sub." ".$msg);
				}else if($clientheadID!=""){
					///////Send Mail ClientHead///////
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $Clientname,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($Clientemail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$Clientemail." ".$sub." ".$msg);
				}else{
					$sendmail=Utils::getSeniorId($assignto,$this->db);
					$assignedemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
					$assignedname=Utils::getEmployeeName($sendmail,$this->db);
					$sub="Task '$title' has been assigned  by $assignedtoname to self";
					$msg="
					<table>
					<tr><td>Dear $assignedname,</td></tr>
					<tr><td></td></tr>
					<tr><td>Task: '$title' has been assigned  by $assignedtoname to self </td></tr>
					<tr><td>Project: $projectname </td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration1 Hours</td></tr>
					
					</table>";
					//Utils::Trace($sub." ".$msg);
					$sts=Utils::sendMail($assignedemail,$assignedtoname,$sub,$msg);
					Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
				}
			}
			//Utils::Trace($sts." ".$assignedbyemail." ".$sub." ".$msg);
			///// end send mail to assigned_to//////
		   $status =true;
		   $successMsg = TASK_MODULE_CREATION_SUCCESS;
		}else {
		   $status =false;
		   $errorMsg = TASK_MODULE_CREATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function UpdateProfileTask($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$taskid=$request[12];
		$sql1 = "SELECT * FROM task_master WHERE OrganizationId = :id and id = :taskid";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array(':id' => $orgid, ':taskid' => $taskid));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			while($row1 = $query1->fetch()) {
				$taskstatus1=$row1->taskstatus;
				$task_no=$row1->task_no;
				$title=$row1->task_title;
				$projectid=$row1->projectid;
				$assignedbyid=$row1->CreatedById;
				$assigntoid=$row1->assignto;
				$fromdate=$row1->fromdate;
				$todate=$row1->todate;
				$desc=$row1->description;
			}
        }
		$sql = "UPDATE task_master SET task_title=?, OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?, projectid=?, milestoneid=?, assignto=?, description=?,fromdate=?,todate=?,priority=?, taskstatus=?,  Totalhour =? where id=?";
		$mdate = date("Y-m-d H:i:s");
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$from = Utils::getDateformat($request[7]);
			$to = Utils::getDateformat($request[8]);
			$timeduration = ($request[10].":".$request[11]);
			$query->execute(array($request[6], $orgid, $mdate, $mid, $request[2], $request[3], $request[4], $request[5],$from,$to,$request[9], 1,$timeduration , $request[12]));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
			////////Generate Activities Log file//////////
			$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
			$msg="<b>$empname</b> has assigned Task <b>$title</b> to self ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Self Service", $msg, $orgid));
			
			$sendmail=Utils::decode5t(Utils::getSeniorId($assignedbyid,$this->db));
			$assignedtoemail=Utils::decode5t(Utils::getName($sendmail,'EmployeeMaster','CompanyEmail',$this->db));
				//$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid!=0)
					$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
				if($projectid==0){
					$projectname="Misc. Activities";
				}
				$assignedtoname=$this->getEmployeeName($assigntoid);
				$assignedbyname=$this->getEmployeeName($sendmail);
				$sub="Assigned Task Change: $task_no- $title";
				$msg="
				<table>
				<tr><td>Dear <b>$assignedbyname</b>,</td></tr>
				<tr><td></td></tr>
				<tr><td>Task: $task_no- $title has been Updated by $assignedtoname.</td></tr>
				<tr><td>Project: $projectname</td></tr>
				<tr><td>Task: $title</td></tr>
				<tr><td>Estimated Date: From <b>$fromdate</b> to <b>$todate</b></td></tr>
				<tr><td>Estimated Duration: From <b>$timeduration</b></td></tr>
				<tr><td>Description: $desc</td></tr>
				<tr><td>Reason: <b>$request[5]</b></td></tr>
				
				</table>";
				Utils::sendMail($assignedtoemail,"UBIHRM",$sub,$msg);
				Utils::Trace($assignedtoemail." ".$sub." ".$msg);
				// end send mail to assigned to//
		
		   $status =true;
		   $successMsg = TASK_MODULE_UPDATION_SUCCESS;
		} else {
		   $status =false;
		   $errorMsg = TASK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getpreviousTaskApprovalSts($task_id, $org_id ){
		$sql1 = "select * from task_master WHERE id =? and OrganizationId=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $task_id, $org_id));
		$con=$query1->rowCount();
		$ApproverSts=2;
		if($r=$query1->fetch()){
			$ApproverSts=$r->taskstatus;
		}
		return $ApproverSts;
	}
	public function UpdateTaskMailSts($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$sql1 = "SELECT * FROM task_master WHERE OrganizationId = ? and id =?";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array($request[1], $request[2]));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			while($row1 = $query1->fetch()) {
				$taskstatus1=$row1->taskstatus;
				$task_no=$row1->task_no;
				$title=$row1->task_title;
				$projectid=$row1->projectid;
				$assignedbyid=$row1->CreatedById;
				$assigntoid=$row1->assignto;
				$fromdate=$row1->fromdate;
				$todate=$row1->todate;
				$desc=$row1->description;
			}
        }
		$sql = "UPDATE task_master SET  taskstatus=? where id=?";
		$mdate = date("Y-m-d H:i:s");
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
			$query->execute(array($request[3], $request[2]));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$sql = "INSERT INTO task_comments (taskid,  OrganizationId,  CreatedDate, CreatedBy, comment) VALUES (?, ?, ?, ?, ?)";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $orgid, $mdate, $mid, $request[4]));
			$count =  $query->rowCount();		
			
			/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
			$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
			$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
			$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
			/////////Get Project Name//////////////	
			if($projectid!=0)
				$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);
			if($projectid==0){
				$projectname="Misc. Activities";
			}
			///Get Assigned To Name////////
			$assignedtoname=Utils::getEmployeeName($assigntoid,$this->db);
			$assignedtoemail=Utils::decode5t(Utils::getName($assigntoid,'EmployeeMaster','CompanyEmail',$this->db));
			///////Get Assigned by name/////////
			$assignedbyname=Utils::getEmployeeName($mid,$this->db);
			// Start Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
			if($clientheadID!=""){
				$Clientemail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
				$Clientname=Utils::getEmployeeName($clientheadID,$this->db);
			}
			if($ProjectmanagerID!=""){
				$ProManageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProManagername=Utils::getEmployeeName($ProjectmanagerID,$this->db);
			}	
			if($ProjectLeadID!=""){
				$ProLeademail=Utils::decode5t(Utils::getName($ProjectLeadID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProLeadname=Utils::getEmployeeName($ProjectLeadID,$this->db);
			}
			// End Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
			////////Send Mail//////////////	
				if($mid==$ProjectLeadID && $ProjectLeadID!=""){
					
					////////Send Mail ProjectManager///////////
					if($ProjectmanagerID!=""){
						$sub="Task '$title' has been approved by $assignedbyname";
						$msg="
						<table>
						<tr><td>Dear <b>$ProManagername</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b> assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
						<tr><td>Remarks: $request[4]</td></tr>
						
						</table>";
						$sts=Utils::sendMail($ProManageremail,$assignedbyname,$sub,$msg);
						
					}else{
						////////Send Mail ClientHead By/////
						$sub="Task '$title' has been approved by $assignedbyname";
						$msg="
						<table>
						<tr><td>Dear <b>$Clientname</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b>assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
						<tr><td>Remarks: $request[4]</td></tr>
						</table>";
						$sts=Utils::sendMail($Clientemail,$assignedbyname,$sub,$msg);
					}
					/////////Send Mail Assigned To/////////
					$sub="Task '$title' has been approved by $assignedbyname";
					$msg1="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b>assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
					<tr><td>Remarks: $request[4]</td></tr>
					
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg1);
				}elseif($mid==$ProjectmanagerID && $ProjectmanagerID!=""){
					////////Send Mail ClientHead///////////
					$sub="Task '$title' has been approved by $assignedbyname";
					$msg="
					<table>
					<tr><td>Dear <b>$Clientname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b>assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'<b>.</td></tr>
					<tr><td>Remarks: $request[4]</td></tr>
					</table>";
					$sts=Utils::sendMail($Clientemail,$assignedbyname,$sub,$msg);
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been approved by $assignedbyname";
					$msg1="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b> assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
					<tr><td>Remarks: $request[4]</td></tr>
					
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg1);
				}else if($mid==$clientheadID){
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been approved by $assignedbyname";
					$msg="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b>assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
					<tr><td>Remarks: $request[4]</td></tr>
					
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg);
				}else{
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been approved by $assignedbyname";
					$msg1="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task <b>'$title'</b> of the project <b>'$projectname'</b>assigned to <b>'$assignedtoname'</b> has been approved by <b>'$assignedbyname'</b>.</td></tr>
					<tr><td>Remarks: $request[4]</td></tr>
					
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg1);
				}
				Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
				// end send mail to assigned to//
		
		   $status =true;
		   $successMsg = "Task has been approved successfully";
		} else {
		   $status =false;
		   $errorMsg = TASK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function reassignTaskUpdated($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$taskid=$request[8];
		
		$sql1 = "SELECT * FROM task_master WHERE OrganizationId = ? and id = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query1->execute(array($orgid, $taskid));
			$count =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1) {
			while($row1 = $query1->fetch()) {
				$taskstatus1=$row1->taskstatus;
				$task_no=$row1->task_no;
				$title=$row1->task_title;
				$projectid=$row1->projectid;
				$assignedbyid=$row1->CreatedById;
				$assigntoid=$row1->assignto;
				$totalhour=$row1->Totalhour;
				$miscunduct =$row1->miscunduct ;
				$fromdate=$row1->fromdate;
				$todate=$row1->todate;
				$desc=$row1->description;
				$addduration=explode(":" , $row1->Totalhour);
				if($row1->Totalhour!=""){
					$addhour=$addduration[0];
					$addminutes=$addduration[1];
				}
			}
        }
		$newmindate= date('M d, Y ', strtotime(Utils::getDateformat($request[3])));
		$newmaxdate= date('M d, Y ', strtotime(Utils::getDateformat($request[4])));
		$miscunduct=$miscunduct+1;
		$addhous1=$request[5] + $addhour;
		$addminutes1=$request[6]+ $addminutes;
		$timeduration1 = ($addhous1.":".$addminutes1);
		$sql = "UPDATE task_master SET OrganizationId=?,  LastModifiedDate=?, LastModifiedById=?, description=?, todate=?, taskstatus=?,  Totalhour =?, miscunduct=? where id=?";
		$mdate = date("Y-m-d H:i:s");
		$query = $this->db->prepare($sql);
		try{
			$from = Utils::getDateformat($request[3]);
			$to = Utils::getDateformat($request[4]);
			//$timeduration1 = ($request[5]." : ".$request[6]);
			if($request[5]<=9 && $request[6]<=9){
					$timeduration= '0'.$request[5].':'.'0'.$request[6];
			}else if($request[5]<=9 && $request[6]<>9){
				$timeduration= '0'.$request[5] .':'.$request[6];
			}else if($request[5]<>9 && $request[6]<=9){
				$timeduration= $request[5] .':'.'0'.$request[6];
			}else{
					$timeduration= $request[5] .':'.$request[6];
			}
			$query->execute(array($orgid, $mdate, $mid, $request[7] ,$to,$request[2], $timeduration1 ,$miscunduct, $request[8]));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count >= 1) {
			$sql = "INSERT INTO task_comments (taskid,  OrganizationId,  CreatedDate, CreatedBy, comment) VALUES (?, ?, ?, ?, ?)";
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[8], $orgid, $mdate, $mid, $request[7]));
			$count =  $query->rowCount();
			$projectname=Utils::getName($projectid,'project_master','project_title',$this->db);			
			/////GET ClientHead ,ProjectManager, ProjectLead IDs//////
			$clientheadID=Utils::getName($projectid,'project_master','ClientManager',$this->db);
			$ProjectmanagerID=Utils::getName($projectid,'project_master','owner_id',$this->db);
			$ProjectLeadID=Utils::getName($projectid,'project_master','ProjectLead',$this->db);
			///Get Assigned To Name////////
			$assignedtoname=Utils::getEmployeeName($assigntoid,$this->db);
			$assignedtoemail=Utils::decode5t(Utils::getName($assigntoid,'EmployeeMaster','CompanyEmail',$this->db));
			///////Get Assigned by name/////////
			$assignedbyname=Utils::getEmployeeName($mid,$this->db);
			// Start Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
			if($clientheadID!=""){
				$Clientemail=Utils::decode5t(Utils::getName($clientheadID,'EmployeeMaster','CompanyEmail',$this->db));
				$Clientname=Utils::getEmployeeName($clientheadID,$this->db);
			}
			if($ProjectmanagerID!=""){
				$ProManageremail=Utils::decode5t(Utils::getName($ProjectmanagerID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProManagername=Utils::getEmployeeName($ProjectmanagerID,$this->db);
			}	
			if($ProjectLeadID!=""){
				$ProLeademail=Utils::decode5t(Utils::getName($ProjectLeadID,'EmployeeMaster','CompanyEmail',$this->db));
				$ProLeadname=Utils::getEmployeeName($ProjectLeadID,$this->db);
			}
			// End Get ClientHead , ProjectManager, ProjectLead Email ID & Name//
			////////Send Mail//////////////	
				if($mid==$ProjectLeadID && $ProjectLeadID!=""){
					////////Send Mail ProjectManager///////////
					if($ProjectmanagerID!=""){
						$sub="Task '$title' has been Rejected by $ProLeadname";
						$msg="
						<table>
						<tr><td>Dear <b>$ProManagername</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task: <b>'$title'</b> assigned to <b>'$assignedtoname'<b/> has been Re-Assigned by <b>'$ProLeadname'</b>.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>End Date: $newmaxdate </td></tr>
						<tr><td>Estimated Hours: $timeduration</td></tr>
						</table>";
						$sts=Utils::sendMail($ProManageremail,$ProLeadname,$sub,$msg);
					}else{
						////////Send Mail ClientHead By/////
						$sub="Task '$title' has been Rejected by $ProLeadname";
						$msg="
						<table>
						<tr><td>Dear <b>$Clientname</b></td></tr>
						<tr><td></td></tr>
						<tr><td>Task:<b>'$title'</b> assigned to <b>'$assignedtoname'<b/> has been Re-Assigned by <b>'$ProLeadname'</b>.</td></tr>
						<tr><td>Project: $projectname</td></tr>
						<tr><td>Start Date: $newmindate</td></tr>
						<tr><td>End Date: $newmaxdate </td></tr>
						<tr><td>Estimated Hours: $timeduration</td></tr>
						</table>";
						$sts=Utils::sendMail($Clientemail,$ProLeadname,$sub,$msg);
					}
					/////////Send Mail Assigned To/////////
					$sub="Task '$title' has been Rejected by $ProLeadname";
					$msg="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task::<b>'$title'</b> has been Re-Assigned by <b>'$ProLeadname'</b>. </td></tr>
					<tr><td>Project: $projectname</td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration</td></tr>
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$ProLeadname,$sub,$msg);
				}elseif($mid==$ProjectmanagerID && $ProjectmanagerID!=""){
					////////Send Mail ClientHead///////////
					$sub="Task '$title' has been Rejected by $ProManagername";
					$msg="
					<table>
					<tr><td>Dear <b>$Clientname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task:<b>'$title'</b>assigned to <b>'$assignedtoname'<b/>  has been Re-Assigned by <b>'$ProManagername'</b>.</td></tr>
					<tr><td>Project: $projectname</td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration</td></tr>
					</table>";
					$sts=Utils::sendMail($Clientemail,$ProManagername,$sub,$msg);
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been Rejected by $ProManagername";
					$msg="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task:<b>'$title'</b> has been Re-Assigned by <b>'$ProManagername'</b>.</td></tr>
					<tr><td>Project: $projectname</td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration</td></tr>
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$ProManagername,$sub,$msg);
				}else if($mid==$clientheadID){
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been Rejected by $Clientname";
					$msg="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task:<b>'$title'</b> has been Re-Assigned by <b>'$Clientname'</b>.</td></tr>
					<tr><td>Project: $projectname</td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration</td></tr>
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$Clientname,$sub,$msg);
				}else{
					//////Send Mail Assigned To /////////
					$sub="Task '$title' has been Rejected by $assignedbyname";
					$msg="
					<table>
					<tr><td>Dear <b>$assignedtoname</b></td></tr>
					<tr><td></td></tr>
					<tr><td>Task:<b>'$title'</b>assigned to <b>'$assignedtoname'<b/> has been Re-Assigned by <b>'$assignedbyname'</b>.</td></tr>
					<tr><td>Project: $projectname</td></tr>
					<tr><td>Start Date: $newmindate</td></tr>
					<tr><td>End Date: $newmaxdate </td></tr>
					<tr><td>Estimated Hours: $timeduration</td></tr>
					</table>";
					$sts= Utils::sendMail($assignedtoemail,$assignedbyname,$sub,$msg);
				}
				Utils::Trace($sts." ".$assignedtoemail." ".$sub." ".$msg);
				// end send mail to assigned to//
		
		   $status =true;
		   $successMsg = "Task reassigned successfully";
		} else {
		   $status =false;
		   $errorMsg = TASK_MODULE_UPDATION_FAILED;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	}

