<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SkillgapassessmentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AssessmentObjective WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($empid,$id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id FROM CompetencyAnalysis WHERE Designation = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
			}
			$sql3 = "SELECT DISTINCT Level FROM SkillGapChild WHERE SkillGapId = ? ";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			while($row3 = $query3->fetch())
			{
				$score=0;
				$level=$row3->Level;
				$sql4 = "SELECT * FROM SkillGapChild WHERE SkillGapId = ? and Level=?";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				while($row4 = $query4->fetch())
				{
					$score=$score+$row4->Score;
					$desigl=$row4->DesignationLevel;
				}
					
					
			}
					
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
	
    
	
	public function getassessmentDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $empid=0; $desigid=0;
		$data = array(); $color = "";  $data1=array(); $data2=array();
		$editper = 0;
		$mid=$request[0];
		$orgid=$request[1];
		$mdate = date("Y-m-d H:i:s");
		$assessmentid=Utils::decode5t($request[2]);
		$sql="SELECT * FROM SkillGapAssessment WHERE Id in (select SkillGapId from (select * from SkillGapApproval where  AssessmentSts = 0 and SkillGapId=$assessmentid) s where EmployeeId=$mid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$mid";
		
		$query = $this->db->prepare($sql);
		try{
			$query->execute();
			$c1=$query->rowCount();
			
		}catch(Exception $e){
			$errorMsg=$e->getMessage();
		}
		if($c1==0)
		{
			$editper = 0;
		
		}else{
			$editper = 1;
		}
		
		//////get assessment details of employee/////////
		$sqle = "SELECT * FROM SkillGapAssessment WHERE Id =?";
		$querye = $this->db->prepare($sqle);
		try{
		$querye->execute(array( $assessmentid ));
		while($r1=$querye->fetch()){
			
			$empid=$r1->EmployeeId;
			$fromdate=$r1->FromDate;
			$todate=$r1->ToDate;
			$desiglevel = $r1->AssessmentLevel;
			$period=(int)$r1->Period;
		}
		
		////////details of employee//////////
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
		
        $query = $this->db->prepare($sql);
		$query->execute(array( $empid,$orgid ));
		if($r=$query->fetch()){
			$desigid=$r->Designation;
			
			$empname = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
			$empdiv = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
			$empdept = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
			$empdesig = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
			
		}
		///////get objective of employee designation/////////
        $sql = "SELECT DISTINCT AnalysisId FROM SkillGapChild WHERE SkillGapId = :id";
        $query = $this->db->prepare($sql);
		
			
			$query->execute(array(':id' => $assessmentid ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				
				//////get competency details and results of perticular designation/////////////
				$sql1 = "SELECT  * FROM CompetencyAnalysisChild WHERE Id = :id " ;
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->AnalysisId ));
				while($row1 = $query1->fetch())
				{
					$compentencylevel=array();
					$results=array();
					$compid=$row1->Competency;
					$qid=$row1->CompetencyType;
					$sqlc = "SELECT Color FROM CompetencyType WHERE Id = ? ";
					$queryc = $this->db->prepare($sqlc);
					$queryc->execute(array( $qid ));
					if($rowc = $queryc->fetch()){
						$color = $rowc->Color;
					}
					$res=array();
					$analysisid=$res['id'] = $row1->Id;
					$res['competencycolor'] = $color;
					$res['competencytype'] = Utils::getName($qid,'CompetencyType','Name',$this->db);
					$res['competency'] = Utils::getName($compid,'CompetencyMaster','Name',$this->db);
					
					$level = (int)$row1->Level;
						
					$sql2= "SELECT  * FROM CompetencyChild WHERE Id = :id " ;
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(':id' => $level ));	
					while($row1=$query2->fetch()){
						//$res1=array();
						$compentancyid = $row1->CompetencyId;
						$res['competencylevel'] = $row1->CompLevel;
						$res['indicator'] = $row1->BehaviouralIndicator;
						$res['level'] = (int)$row1->Level;
						//$results[]=$res1;
						$sql4= "SELECT  * FROM CompetencyChild WHERE CompetencyId = :id " ;
						$query4 = $this->db->prepare($sql4);
						$query4->execute(array(':id' => $compentancyid ));	
						while($row3=$query4->fetch()){
							$res2=array();
							
							$res2['id'] = $row3->Id;
							$res2['level'] = $row3->Level;
							$res2['name'] = $row3->CompLevel;
							$res2['indicator'] = $row3->BehaviouralIndicator;
							
							$compentencylevel[]=$res2;
							
							}
							$sql3= "SELECT  * FROM SkillGapChild WHERE SkillGapId = ? and AnalysisId = ? ORDER BY Level desc" ;
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array( $assessmentid,  $analysisid));	
							while($row2=$query3->fetch()){
								if($row2->AssessedLevel !=0 && $row2->DesireLevel !=0 ){
								
									$res1=array();
									$res1['id'] = $row2->Id;
									$res1['anlysisid'] = $row2->AnalysisId;
									$res1['comments'] = $row2->Comments;
									$res1['level'] = $row2->Level;
									$res1['assessby'] = $this->getName($row2->AssessedBy,$assessmentid);
									$res1['assesslevel'] =$row2->AssessedLevel;
									$sql5= "SELECT  * FROM CompetencyChild WHERE CompetencyId = ? and Level=?" ;
									$query5 = $this->db->prepare($sql5);
									$query5->execute(array( $compentancyid,$row2->AssessedLevel ));	
									while($row4=$query5->fetch()){
										$res1['assesslevelname'] = $row4->CompLevel;
										$res1['indicator'] = $row4->BehaviouralIndicator;
									}
									$gap =  ($row2->DesireLevel - $row2->AssessedLevel);
									if($gap >0){
									$res1['gap'] = $gap;
									}
									else{
									$res1['gap'] = 0;
									}
									$results[]=$res1;
								}		
							}	
					}
					
					$res['competencylevel1']=$compentencylevel;	
					$res['results']=$results;
					
					$data[] = $res;	
					
				
				}
				
				/////designation of logged in employee///////////
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
				{
					$approvardesig=$row1->Designation;
				}
					$res2=array();
					$res2['editpermission'] = $editper;
					$res2['employeeid'] = $empid;
					$res2['name'] = $empname;
					$res2['empdivision'] = $empdiv;
					$res2['empdepartment'] = $empdept;
					$res2['empdesignation'] = $empdesig;
					$res2['designationid'] = $desigid;
					$res2['loginempdesig'] = $approvardesig;
										
					if($period == 1){
						$res2['assessmentype']='Yearly' ;
						
					}
					elseif($period == 2){
						$res2['assessmentype']='Half-Yearly' ;
					}
					elseif($period == 3){
						$res2['assessmentype'] ='Quarterly' ;
					}
					elseif($period == 4){
						$res2['assessmentype'] ='Monthly' ;
					}
					$res2['typeid']=$period ;
					
					$res2['desiglevel'] = $desiglevel;
					$res2['fromdate']= Utils::dateformatter($fromdate);
					$res2['todate']= Utils::dateformatter($todate);
					$data1[]=$res2;			
				
				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data1"] =$data1;
		$result["data"] =$data;
		
		//////generate overall result////////
		//$result["data2"] =$this->getDetail($empid,$assessmentid);
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
   public function getassessmentResult($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $empid=0; $desigid=0;
		$data = array(); $color = "";  $data1=array(); $data2=array();
		
		$mid=$request[0];
		$orgid=$request[1];
		$mdate = date("Y-m-d H:i:s");
		$assessmentid=Utils::decode5t($request[2]);
		
		
		//////get assessment details of employee/////////
		$sqle = "SELECT * FROM SkillGapAssessment WHERE Id =?";
		$querye = $this->db->prepare($sqle);
		try{
		$querye->execute(array( $assessmentid ));
		while($r1=$querye->fetch()){
			
			$empid=$r1->EmployeeId;
			$fromdate=$r1->FromDate;
			$todate=$r1->ToDate;
			$desiglevel = $r1->AssessmentLevel;
		}
		
		////////details of employee//////////
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $empid,$orgid ));
		if($r=$query->fetch()){
			$desigid=$r->Designation;
			
			$empname = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
			$empdiv = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
			$empdept = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
			$empdesig = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
			
		}
		///////get objective of employee designation/////////
        $sql = "SELECT * FROM CompetencyAnalysis WHERE Designation = :id";
        $query = $this->db->prepare($sql);
		
			
			$query->execute(array(':id' => $desigid ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			if($row = $query->fetch())
			{
				$id = $row->Id;
				
				$period=(int)$row->Period;
				
				
				//////get competency details and results of perticular designation/////////////
				$sql1 = "SELECT  * FROM CompetencyAnalysisChild WHERE AnalysisId = :id " ;
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row = $query1->fetch())
				{
					$compentencylevel=array();
					$results=array();
					$compid=$row->Competency;
					$qid=$row->CompetencyType;
					$sqlc = "SELECT Color FROM CompetencyType WHERE Id = ? ";
					$queryc = $this->db->prepare($sqlc);
					$queryc->execute(array( $qid ));
					if($rowc = $queryc->fetch()){
						$color = $rowc->Color;
					}
					$res=array();
					$analysisid=$res['id'] = $row->Id;
					$res['competencycolor'] = $color;
					$res['competencytype'] = Utils::getName($qid,'CompetencyType','Name',$this->db);
					$res['competency'] = Utils::getName($compid,'CompetencyMaster','Name',$this->db);
					
					$level = (int)$row->Level;
						
					$sql2= "SELECT  * FROM CompetencyChild WHERE Id = :id " ;
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(':id' => $level ));	
					while($row1=$query2->fetch()){
						//$res1=array();
						$compentancyid = $row1->CompetencyId;
						$res['competencylevel'] = $row1->CompLevel;
						$res['indicator'] = $row1->BehaviouralIndicator;
						$res['level'] = (int)$row1->Level;
						//$results[]=$res1;
						$sql4= "SELECT  * FROM CompetencyChild WHERE CompetencyId = :id " ;
						$query4 = $this->db->prepare($sql4);
						$query4->execute(array(':id' => $compentancyid ));	
						while($row3=$query4->fetch()){
							$res2=array();
							
							$res2['id'] = $row3->Id;
							$res2['level'] = $row3->Level;
							$res2['name'] = $row3->CompLevel;
							$res2['indicator'] = $row3->BehaviouralIndicator;
							
							$compentencylevel[]=$res2;
							
							}
							$sql3= "SELECT  * FROM SkillGapChild WHERE SkillGapId = ? and AnalysisId = ? ORDER BY Level desc" ;
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array( $assessmentid,  $analysisid));	
							while($row2=$query3->fetch()){
							if($row2->AssessedLevel !=0 && $row2->DesireLevel !=0 ){
								$res1=array();
									
								$res1['id'] = $row2->Id;
								$res1['anlysisid'] = $row2->AnalysisId;
								$res1['comments'] = $row2->Comments;
								$res1['level'] = $row2->Level;
								$res1['assessby'] = $this->getName($row2->AssessedBy,$assessmentid);
								
								$res1['assesslevel'] =$row2->AssessedLevel;
								$sql5= "SELECT  * FROM CompetencyChild WHERE CompetencyId = ? and Level=?" ;
								$query5 = $this->db->prepare($sql5);
								$query5->execute(array( $compentancyid,$row2->AssessedLevel ));	
								while($row4=$query5->fetch()){
									$res1['assesslevelname'] = $row4->CompLevel;
									$res1['indicator'] = $row4->BehaviouralIndicator;
								}
								$gap =  ($row2->DesireLevel - $row2->AssessedLevel);
								if($gap >0){
								$res1['gap'] = $gap;
								}
								else{
								$res1['gap'] = 0;
								}
								$results[]=$res1;
							}		
							}	
					}
					
					$res['competencylevel1']=$compentencylevel;	
					$res['results']=$results;
					
					$data[] = $res;	
					
				
				}
				
				/////designation of logged in employee///////////
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
				{
					$approvardesig=$row1->Designation;
				}
					$res2=array();
					$res2['editpermission'] = $editper;
					$res2['employeeid'] = $empid;
					$res2['name'] = $empname;
					$res2['empdivision'] = $empdiv;
					$res2['empdepartment'] = $empdept;
					$res2['empdesignation'] = $empdesig;
					$res2['designationid'] = $desigid;
					$res2['loginempdesig'] = $approvardesig;
										
					if($period == 1){
						$res2['assessmentype']='Yearly' ;
						
					}
					elseif($period == 2){
						$res2['assessmentype']='Half-Yearly' ;
					}
					elseif($period == 3){
						$res2['assessmentype'] ='Quarterly' ;
					}
					elseif($period == 4){
						$res2['assessmentype'] ='Monthly' ;
					}
					$res2['typeid']=$period ;
					
					$res2['desiglevel'] = $desiglevel;
					$res2['fromdate']= Utils::dateformatter($fromdate);
					$res2['todate']= Utils::dateformatter($todate);
					$data1[]=$res2;			
				
				
			}
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data1"] =$data1;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
   
   
   
    /**
     * Setter for a SkillGapAssessment (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
	
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); $level=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
        $aid=Utils::decode5t($request[6]);	
		try{
				
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
					{
						$approvardesig=$row1->Designation;
					}
						// INSERTING ASSESSMENT CHILD IF PASSED AS AN JSON
					$objective = json_decode($_POST['assessmentarr'], true); 
					for($i=0; $i<count($objective); $i++)
					{
						if($objective[$i]['id']!="" && $objective[$i]['assesslevel'] !="" && $objective[$i]['comments'] !=""){
							$levelcount=count($objective[$i]['results']);
							if($levelcount == 0)
							{
								$level=1;
							}
							else{
								$level=$levelcount+1;
								
							}
																				
							$sqlobjective = " UPDATE SkillGapChild SET AssessedLevel=? , Comments=? ,DesireLevel =? where SkillGapId =? and AnalysisId =? and Level=? and AssessedBy=? ";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute(array($objective[$i]['assesslevel'],$objective[$i]['comments'],$objective[$i]['level'],$aid,$objective[$i]['id'], $level,$approvardesig));
							
						}
					}
				
					$sql1="UPDATE SkillGapApproval set AssessmentSts = ?  WHERE SkillGapId=? AND EmployeeId=?";
				    $query1 = $this->db->prepare($sql1);
				    $query1->execute(array(1,$aid,$mid));
					$count1=0;
					$sql1 = "SELECT AssessmentSts FROM SkillGapApproval WHERE SkillGapId = ? and AssessmentSts=1";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $aid ));
					while($r1=$query1->fetch()){
						$count1++;
					}
					
					$sql1 = "SELECT AssessmentLevel FROM SkillGapAssessment WHERE EmployeeId = ?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $request[2] ));
					if($r1=$query1->fetch()){
						$desiglevel=isset($r1->AssessmentLevel)?explode(',',$r1->AssessmentLevel):"";
					}
						
					if($count1 == count($desiglevel)){
						$sql1="UPDATE SkillGapAssessment set AssessmentSts = ?  WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(1,$aid));
					}
					$count =  $queryobjective->rowCount();	
				
				if ($count >= 1) {
				   $status =true;
				   $successMsg = ASSESSMENT_MODULE_CREATION_SUCCESS;
				   
				} else {
				   $status =false;
				   $errorMsg = ASSESSMENT_MODULE_CREATION_FAILED;
				}
			}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}	
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		
		
		try{
			$sql = "DELETE FROM SkillGapAssessment WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM SkillGapAssessmentChild WHERE SkillGapAssessmentId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getassessmentId()
	{
		$empid=$_SESSION['ubihrm_user_id'];	
		$name ="0";
		$sql = "SELECT Id FROM SkillGapAssessment WHERE EmployeeId=?  Order by Id desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
			}
		$name = Utils::encode5t($name);
		return $name;
	}
	
	
	public function getName($desig,$assessmentid)
	{
		$name ="";
		$sql = "SELECT * FROM SkillGapApproval WHERE DesignationId= ? and SkillGapId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($desig, $assessmentid));
			while($row = $query->fetch())
			{
				$name = Utils::getEmployeename($row->EmployeeId,$this->db);
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getEmployeeAssessmentPending($assessid, $userid)
	{
		$flg =false;
		
			$sql1="SELECT * FROM SkillGapAssessment Where Id in (select SkillGapId from (select * from SkillGapApproval where  AssessmentSts = 0 and SkillGapId=$assessid Group by SkillGapId) s where EmployeeId=$userid)  AND AssessmentSts = 0 AND EmployeeId<>$userid";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute();
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		
		return $flg;
	}
	public function getEmployeeAssessmentRunning($assessid)
	{
		$flg =false;
		$sql1 = "SELECT EmployeeId FROM SkillGapApproval WHERE SkillGapId = ?  and AssessmentSts=1";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		return $flg;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SkillGapAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','Period' ,'FromDate','ToDate','AssessmentSts', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " Where OrganizationId=$orgid and EmployeeId<>$userid";
		}
		else{
			$sWhere = " Where (Id in (select SkillGapId from SkillGapApproval where EmployeeId=$userid ) and OrganizationId= $orgid and  EmployeeId<>$userid) ";
		}
		//$sWhere = " Where OrganizationId=$orgid and (Id in (select SkillGapId from SkillGapApproval where EmployeeId=$userid)) AND EmployeeId<>$userid";
		//$sWhere = " Where Id in (select SkillGapId from (select * from SkillGapApproval where  AssessmentSts = 0 Group by SkillGapId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$aid=Utils::encode5t($aRow->Id);
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($aRow->AssessmentSts !=1){
						
						if($editper){
							$sts = $this->getEmployeeAssessmentPending($aRow->Id,$userid);
							if($sts){
								$edit = '<a rel="tooltip" title="Assessment" href="'.URL.'performance/editskillgapassessment/'.$aid.'" ><i class="fa fa-font"></i></a>';
							}
						}else{
							$edit = '<a href="#" rel="tooltip" title="No permission to assess"><i class="fa fa-font"></i></a>';
						}
					}				
						$row[] =$edit;
					
					
				}
				else if($aColumns[$i]=="Period")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performance/viewskillgapassessment/'.$aid.'/2" >'.Utils::getEmployeename($aRow->{$aColumns[$i]}, $this->db).'</a>';
				}
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment is running'/>";
						}
					}
					$row[]= $img;
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	/*public function getAssessmentresultTable($editper, $deleteper)
	{
		$sTable = 'SkillGapAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'Period' , 'FromDate', 'ToDate', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts==1){
			$sWhere = " Where OrganizationId=$orgid and (Id in (select SkillGapId from SkillGapApproval where AssessmentSts = 1)) and AssessmentSts = 1";
		}
		else{
			$sWhere = " Where (Id in (select SkillGapId from SkillGapApproval where EmployeeId = $userid and AssessmentSts = 1) and AssessmentSts = 1 AND OrganizationId= $orgid and  EmployeeId<>$userid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering 
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering 
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit ='<a rel="tooltip" title="View" href="'.URL.'performance/viewskillgapresult/'.Utils::encode5t($aRow->Id).'/1" ><i class="fa fa-eye"></i></a>'; 
					$row[] =$edit;
				}
				else if($aColumns[$i]=="Period")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performance/viewskillgapresult/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getEmployeename($aRow->{$aColumns[$i]}, $this->db).'</a>' ;
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}*/
}
