<?php

/**
 * ShiftModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ShiftModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = " and Id in (select Shift FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT * FROM ShiftMaster WHERE OrganizationId = :id $sWhere order by name";
        $query = $this->db->prepare($sql);
		try{
			
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SHIFT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false; $status1=false;
		$data = array();
		$weekoff=array();
		
        $sql = "SELECT * FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['timein'] = date("H:i", strtotime($row->TimeIn));
				$res['timeout'] = date("H:i", strtotime($row->TimeOut));
				$res['gracein'] = date("H:i", strtotime($row->TimeInGrace));
				$res['graceout'] = date("H:i", strtotime($row->TimeOutGrace));
				$res['breakin'] = date("H:i", strtotime($row->TimeInBreak));
				$res['breakout'] = date("H:i", strtotime($row->TimeOutBreak));
				$res['breakingrace'] = date("H:i", strtotime($row->BreakInGrace));
				$res['breakoutgrace'] = date("H:i", strtotime($row->BreakOutGrace));
				$res['shifttype'] =$row->shifttype;
				$data[] = $res;
			}
			
			 $sql = "SELECT * FROM ShiftMasterChild WHERE ShiftId = :id";
			$query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count1 =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status1=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['Day'] = $row->Day;
				$res['WeekOff'] = $row->WeekOff;
				$weekoff[] = $res;
			}
			
        }
			
        }
		
		if ($count >= 1) {
           $status =true;
		   $successMsg = SHIFT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SHIFT_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["weekoff"] =$weekoff;
		$result['status']=$status;
		$result['status1']=$status1;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	
    
    /**
     * Setter for a ShiftMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$SundayArr = json_decode($request[12], true); 
		$MondayArr = json_decode($request[13], true); 
		$TuesdayArr = json_decode($request[14], true); 
		$WednesdayArr = json_decode($request[15], true); 
		$ThursdayArr = json_decode($request[16], true); 
		$FridayArr = json_decode($request[17], true); 
		$SaturdayArr = json_decode($request[18], true); 
		$sunday="";
		$monday="";
		$tuesday="";
		$wednesday="";
		$thursday="";
		$friday="";
		$saturday="";
		
		for($i=0; $i<=4; $i++)
			{
				if($sunday=="")
					$sunday=(string)$SundayArr[$i]['week'];
				else
					$sunday.=",".$SundayArr[$i]['week'];
				
				if($monday=="")
					$monday=(string)$MondayArr[$i]['week'];
				else
					$monday.=",".$MondayArr[$i]['week'];
				
				if($tuesday=="")
					$tuesday=(string)$TuesdayArr[$i]['week'];
				else
					$tuesday.=",".$TuesdayArr[$i]['week'];
				
				if($wednesday=="")
					$wednesday=(string)$WednesdayArr[$i]['week'];
				else
					$wednesday.=",".$WednesdayArr[$i]['week'];
				
				if($thursday=="")
					$thursday=(string)$ThursdayArr[$i]['week'];
				else
					$thursday.=",".$ThursdayArr[$i]['week'];
				
				if($friday=="")
					$friday=(string)$FridayArr[$i]['week'];
				else
					$friday.=",".$FridayArr[$i]['week'];
				
				if($saturday=="")
					$saturday=(string)$SaturdayArr[$i]['week'];
				else
					$saturday.=",".$SaturdayArr[$i]['week'];
				}
			
		
		$sql = "UPDATE ShiftMaster SET Name=?, TimeIn=?, TimeOut=?, TimeInGrace=?, TimeOutGrace=?, TimeInBreak=?, TimeOutBreak=?, LastModifiedDate=?, LastModifiedById=?, BreakInGrace=?, BreakOutGrace=? , shifttype=?  where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $mdate, $mid,  $request[10], $request[11],$request[19], $request[9] ));			
			$count =  $query->rowCount();
			
			if($count==1){
					$count1=0;
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($sunday,$mid,$mdate,$orgid,'1',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($monday,$mid,$mdate,$orgid,'2',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($tuesday,$mid,$mdate,$orgid,'3',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($wednesday,$mid,$mdate,$orgid,'4',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($thursday,$mid,$mdate,$orgid,'5',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($friday,$mid,$mdate,$orgid,'6',$request[9]));
					$count1 +=  $query->rowCount();
					
					$sql = "update ShiftMasterChild set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=? and ShiftId=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($saturday,$mid,$mdate,$orgid,'7',$request[9]));
					$count1 +=  $query->rowCount();
					
					if($count1==0){
					$sql = "INSERT INTO ShiftMasterChild (ShiftId, Day, WeekOff, OrganizationId, ModifiedBy, ModifiedDate) VALUES (?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?)";		
					$query = $this->db->prepare($sql);
					$query->execute(array($request[9],'1',$sunday,$orgid,$mid, $mdate,$request[9],'2',$monday,$orgid,$mid, $mdate,$request[9],'3',$tuesday,$orgid,$mid, $mdate,$request[9],'4',$wednesday,$orgid,$mid, $mdate,$request[9],'5',$thursday,$orgid,$mid, $mdate,$request[9],'6',$friday,$orgid,$mid, $mdate,$request[9],'7',$saturday,$orgid,$mid, $mdate));
					}
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count >= 1) 
		{
				$msg="Shift has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Shift Master", $msg, $orgid));
           $status =true;
		   $successMsg = SHIFT_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SHIFT_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a ShiftMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$SundayArr = json_decode($request[11], true); 
		$MondayArr = json_decode($request[12], true); 
		$TuesdayArr = json_decode($request[13], true); 
		$WednesdayArr = json_decode($request[14], true); 
		$ThursdayArr = json_decode($request[15], true); 
		$FridayArr = json_decode($request[16], true); 
		$SaturdayArr = json_decode($request[17], true); 
		$sunday="";
		$monday="";
		$tuesday="";
		$wednesday="";
		$thursday="";
		$friday="";
		$saturday="";
		
		for($i=0; $i<=4; $i++)
			{
				if($sunday=="")
					$sunday=(string)$SundayArr[$i]['week'];
				else
					$sunday.=",".$SundayArr[$i]['week'];
				
				if($monday=="")
					$monday=(string)$MondayArr[$i]['week'];
				else
					$monday.=",".$MondayArr[$i]['week'];
				
				if($tuesday=="")
					$tuesday=(string)$TuesdayArr[$i]['week'];
				else
					$tuesday.=",".$TuesdayArr[$i]['week'];
				
				if($wednesday=="")
					$wednesday=(string)$WednesdayArr[$i]['week'];
				else
					$wednesday.=",".$WednesdayArr[$i]['week'];
				
				if($thursday=="")
					$thursday=(string)$ThursdayArr[$i]['week'];
				else
					$thursday.=",".$ThursdayArr[$i]['week'];
				
				if($friday=="")
					$friday=(string)$FridayArr[$i]['week'];
				else
					$friday.=",".$FridayArr[$i]['week'];
				
				if($saturday=="")
					$saturday=(string)$SaturdayArr[$i]['week'];
				else
					$saturday.=",".$SaturdayArr[$i]['week'];
				
				
			}
			
		
		
		$sql = "INSERT INTO ShiftMaster (Name, TimeIn, TimeOut, TimeInGrace, TimeOutGrace, TimeInBreak, TimeOutBreak, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,  BreakInGrace, BreakOutGrace,shifttype) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2], $request[3], $request[4], $request[5], $request[6], $request[7], $request[8], $orgid, $mdate, $mid, $mdate, $mid, $mid, $request[9], $request[10], $request[18]));
			$count =  $query->rowCount();
			$ShiftMasterId = $this->db->lastInsertId();
			if($count==1){
						
					$sql = "INSERT INTO ShiftMasterChild ( ShiftId, Day, WeekOff, OrganizationId, ModifiedBy, ModifiedDate) VALUES (?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?),(?, ?, ?, ?, ?, ?)";		
					$query = $this->db->prepare($sql);
					$query->execute(array($ShiftMasterId,'1',$sunday,$orgid,$mid, $mdate,$ShiftMasterId,'2',$monday,$orgid,$mid, $mdate,$ShiftMasterId,'3',$tuesday,$orgid,$mid, $mdate,$ShiftMasterId,'4',$wednesday,$orgid,$mid, $mdate,$ShiftMasterId,'5',$thursday,$orgid,$mid, $mdate,$ShiftMasterId,'6',$friday,$orgid,$mid, $mdate,$ShiftMasterId,'7',$saturday,$orgid,$mid, $mdate));
					$count =  $query->rowCount();
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count >= 1) {
           $status =true;
		   $successMsg = SHIFT_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SHIFT_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT Id FROM AttendanceMaster WHERE ShiftId = :id";
        	$query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( ':id' => $did));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=SHIFT_MODULE_DELETE_EXIST;
		}else{
		
				$sql = "DELETE FROM ShiftMaster WHERE Id = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count =  $query->rowCount();		
			if($count==1){
				$sql = "DELETE FROM ShiftMasterChild WHERE ShiftId = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$count1 =  $query->rowCount();	
			}
			if ($count == 1) {
			   $status =true;
			   $successMsg = SHIFT_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg = SHIFT_MODULE_DELETE_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'ShiftMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'TimeIn', 'TimeOut','TimeInGrace', 'TimeOutGrace','TimeInBreak', 'TimeOutBreak','BreakInGrace', 'BreakOutGrace','shifttype', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid and Id in (select Shift FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'attendance/editshift/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate']." ".$_SESSION['ubihrm_timeformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				elseif($aColumns[$i]=="shifttype"){
					if($aRow->shifttype==1){
						$row[] ="Single day";
					}else if($aRow->shifttype==2){
						$row[] ="Multiple days";
					}else{
						$row[] ="";
					}
					
				}
				
				elseif($aColumns[$i]=="TimeIn" || $aColumns[$i]=="TimeOut" || $aColumns[$i]=="TimeInBreak" || $aColumns[$i]=="TimeOutBreak" || $aColumns[$i]=="TimeInGrace" || $aColumns[$i]=="TimeOutGrace" || $aColumns[$i]=="BreakInGrace" || $aColumns[$i]=="BreakOutGrace"){
					$row[] = isset($_SESSION['ubihrm_timeformate'])?date($_SESSION['ubihrm_timeformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				
				else
				{
					if($i==0){
						
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'attendance/viewshift/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					}
					else{
					$row[] = $aRow->{$aColumns[$i]};
					}
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
