<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SeveranceModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SeveranceMaster WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SEVERANCE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getTurnoverreason()
    {         
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        		//AND ActualValue >= 20
		$sql = "SELECT * FROM OtherMaster WHERE OtherType='SeveranceReason' ";	
        $query = $this->db->prepare($sql);
               
		try{
			
			$query->execute();			
			$count =  $query->rowCount();
		
        if ($count > 1) 
        {
        	while($row = $query->fetch())
        	{	   
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = $row->DisplayName;
			$res['value'] = $row->ActualValue;
			
			$data[] = $res;
		}
		              	   
        $status =true;
		$successMsg = "Detail fatched successfully !";
	   
	} else {
	
	   $status =false;
	   $errorMsg = "There is some problem while fetching detail !";
	}
	}catch(Exception $e) {
                              
			$errorMsg = 'Message: ' .$e->getMessage();
		}	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function getSeverancests($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmploymentStatusMaster WHERE OrganizationId = :id and Id=9 or Id=10";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['code'] = $row->Code;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPSTATUS_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	 public function getLastWorkingDate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $setting=0;
		if($request[3]==1)
		{
			$setting=8;
		}elseif($request[3]==2)
		{
			$setting=7;
		}
        $sql = "SELECT * FROM SettingChild WHERE SettingId = ? and OrganizationId= ?";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$severancedate=Utils::getDateformat($request[2]);
			$query->execute(array($setting, $orgid ));
			$count =  $query->rowCount();
			
			$noticeperioddays=$request[3];
			if($noticeperioddays!=""){
				$currentdate=strtotime($severancedate);
				$lastwd=date('Y-m-d', strtotime("+".$noticeperioddays." days",$currentdate));
				$res=array();
				$res['value'] = Utils::dateformatter($lastwd);
							
				$data[] = $res;
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				
				//$res = array();
				//$severancedate=strtotime($severancedate);
				//$lastwd=date('Y-m-d', strtotime("+".$row->ExecutionValue." days",$severancedate));
				//$res['value'] = Utils::dateformatter($lastwd);
				//$data[] = $res;
				
				
			}
        }else{
			$status=true;
			$successMsg = EMPSTATUS_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$_SESSION['ubihrm_org_id'];
		$userid=$_SESSION['ubihrm_user_id'];
        $sql = "SELECT * FROM SeveranceMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['empid'] = (int)$row->EmployeeId;
				$severancedate=strtotime($row->SeveranceDate);
				$lastwd=date('Y-m-d', strtotime("+30 days",$severancedate));
				if($row->EffectDate == '0000-00-00'){
					$res['applyfrom'] = Utils::dateformatter($lastwd);	
				}
				else{
					$res['applyfrom'] = Utils::dateformatter($row->EffectDate);
				}
				$res['noticeperiod'] = $row->NoticePeriod;
				
					if($row->NoticePeriod ==2 )
					{
						//$res['noticeperiod'] = "With One month notice";
					}
				$res['severancedate'] = Utils::dateformatter($row->SeveranceDate);
				$res['severancereason'] = $row->SeveranceReason;
				$res['message'] = $row->Message;
				$res['empsts'] = $row->EmployeeStatus;
				$res['empsts1'] = Utils::getEmployeeStatus($row->EmployeeStatus);
				$res['reason1'] = Utils::getOtherName($row->TurnoverReason, "SeveranceReason", $this->db);
				$res['turnoverreason'] = $row->TurnoverReason;
				$res['createdate'] = $row->CreatedDate;
				$res['approversts'] = $this->getApprovarSts($row->Id, $userid);
				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($row->EmployeeId ));
				while($row1=$query1->fetch()){
					$res['empname'] = $row1->FirstName.' '.$row1->LastName;	
					$res['empdivision'] = Utils::getName($row1->Division,'DivisionMaster','Name',$this->db);
					$res['empdept'] = Utils::getName($row1->Department,'DepartmentMaster','Name',$this->db);
					$res['empreport'] = Utils::getEmployeeName($row1->ReportingTo,$this->db);
				
				}
				
				$sql1 = "SELECT * FROM ResignationApproval WHERE ResignationId = ? and OrganizationId = ? and LeaveStatus<>3";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $row->Id,$orgid ));
				while($r=$query1->fetch())
				{
					$res1=array();
					$res1['id'] = $r->Id;
					$res1['name'] = Utils::getEmployeeName($r->ApproverId, $this->db);
					$res1['sts'] = Utils::getOtherName($r->LeaveStatus, "LeaveStatus", $this->db);
					$res1['comment'] = $r->ApproverComment;
					$res1['approvaldate'] = Utils::datetimeformatter($r->ApprovalDate);
					$res['Approvals'][]=$res1;
				}
				
				$image= $row->Attachment;
				$empcode=$this->getCode($row->EmployeeId);
				$res['attachment']="";
				if ($image !="") {
					$res['attachment']= URL."public/uploads/$orgid/$empcode/$image";
				}
				
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SEVERANCE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SEVERANCE_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getResignationDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid=$request[1];
		$userid=$request[0];
		$empsts = 1;   /////////// 1 FOR RESIGNATION 2 FOR TERMINATION /////////////////////////
		$lastwd=0;
        $sql = "SELECT * FROM SeveranceMaster WHERE EmployeeId = ? and  CreatedById=? and EmployeeStatus=? and OrganizationId=? and SeveranceStatus = 3 ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $userid, $userid , $empsts, $orgid ));
			$count =  $query->rowCount();
		
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['empid'] = (int)$row->EmployeeId;
					$res['applyfrom'] = Utils::dateformatter($row->EffectDate);
					$res['noticeperiod'] = $row->NoticePeriod." Days";
					if($row->NoticePeriod ==2 )
					{
						//$res['noticeperiod'] = "With One month notice";
					}
					$res['severancedate'] = Utils::dateformatter($row->SeveranceDate);
					//$severancedate=strtotime($row->SeveranceDate);
					//$lastwd=date('Y-m-d', strtotime("+30 days",$severancedate));
					$res['effectdate'] = Utils::dateformatter($row->EffectDate);
					$res['reason'] = $row->SeveranceReason;
					$res['resignsts'] = $row->SeveranceStatus;
					$res['message'] = $row->Message;
					$res['reason1'] = Utils::getOtherName($row->TurnoverReason, "SeveranceReason", $this->db);
					
					$image= $row->Attachment;
					$empcode=$this->getCode($row->EmployeeId);
					if ($image !="") {
						$res['attachment']= URL."public/uploads/$orgid/$empcode/$image";
					}
					$data[] = $res;
				}
				
				
				
			}		
			if ($count == 1) {
			   $status =true;
			   $successMsg = SEVERANCE_MODULE_GETDETAIL_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_GETDETAIL_FAILED;
			}
				$sql = "SELECT * FROM SettingChild WHERE SettingId = 8 and OrganizationId= ?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $orgid ));			
				$severancedate=date('Y-m-d');
					
				$count =  $query->rowCount();
				
				while($row1 = $query->fetch())
				{
					$severancedate=strtotime($severancedate);
					$lastwd=date('Y-m-d', strtotime("+".$row1->ExecutionValue." days",$severancedate));
					$lastwd = Utils::dateformatter($lastwd);
				}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["lastworkday"] =$lastwd ;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a SeveranceMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
				
			$sql = "UPDATE SeveranceMaster SET EmployeeId=?, EmployeeStatus=?, EffectDate=?, NoticePeriod=?, SeveranceDate=?,Message=?, LastModifiedDate=?, LastModifiedById=?,TurnoverReason=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array($request[2], $request[8],Utils::getDateformat($request[3]), $request[4],Utils::getDateformat($request[5]),$request[6],  $mdate, $mid,$request[9], $request[7] ));			
				$count =  $query->rowCount();
			if ($count == 1) {
			//	$empid=Utils::getName($timeoffid,'Timeoff','EmployeeId',$this->db);
                $empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="Severance of $empname has been updated";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance", $msg, $orgid));
			    $status =true;
			    $successMsg = SEVERANCE_MODULE_UPDATION_SUCCESS;
			    $msg="";$title="";
			   ////////create employee history/////////
			   $sts=Utils::getEmployeeStatus($request[8]);
			   if($sts=='Terminated'){
					 $title="Termination";
					// $msg="You has been terminated on ".$request[5];
					$msg="Terminated on ".$request[5];
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg="Resigned on ".$request[5];					
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg="You has been absconded on ".$request[5];					
			   }
			   $sql="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($request[2],$title,Utils::getDateformat($request[5]), $msg, $orgid));
				$reason=Utils::getOtherName($request[9],'SeveranceReason',$this->db);
			   $name = Utils::getEmployeeName($request[2], $this->db);
			   $seniorids = Utils::getSeniorIds($request[2], $this->db);
			   $msg = $name." has resigned on ".date("d M, Y");	
			   if($sts=='Terminated'){
					 $title="Termination";
					 $msg=$name." has been terminated on ".$request[5].", due to ".$reason;
					 
					$ests=$this->getEmpStsId($sts);
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg=$name." has resigned on ".$request[5].", due to ".$reason;	
					$ests=$this->getEmpStsId($sts);
					
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg=$name." has been absconded on ".$request[5].", due to ".$reason;
					$ests=$this->getEmpStsId($sts);
					
					Utils::checkseniors($request[2],$this->db);
			   
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , DOL=?, LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,Utils::getDateformat($request[3]),$mid,$mdate,$request[2]));
			   }
			   
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, Utils::getDateformat($request[5]), date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2));
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_UPDATION_FAILED;
			}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$_SESSION["feedback_positive"][] = "Success! We have updated your settings. Background Process can take upto 12 hours to detect changes and refresh. ubiHRM has no control over that refresh process. ";	
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a SeveranceMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM SeveranceMaster WHERE EmployeeId = ? AND EmployeeStatus =?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$request[7]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=SEVERANCE_MODULE_CREATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO SeveranceMaster ( EmployeeId, EffectDate, NoticePeriod, SeveranceDate, Message,  CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, EmployeeStatus,SeveranceStatus,TurnoverReason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],Utils::getDateformat($request[3]), $request[4],Utils::getDateformat($request[5]),$request[6],$mid,$mdate,$mid, $mdate, $orgid,  $mid, $request[7],2,$request[8]));
				$sid=$this->db->lastInsertId();
				$count =  $query->rowCount();		
			
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'OfficLetterMaster','EmployeeId',$this->db);
				$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="Severance of $empname has been created. ";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance", $msg, $orgid));
			   $status =true;
			   $successMsg = SEVERANCE_MODULE_CREATION_ABSCOND;
			    if($request[7] == 1)
					$successMsg = "Employee has been Resigned successfully";
				 if($request[7] == 2)
					$successMsg = "Employee has been Terminated successfully";
				$successMsg = "Employee's severance submitted successfully";
			   $msg="";$title="";
			   ////////create employee history/////////
			   $sts=Utils::getEmployeeStatus($request[7]);
			   if($sts=='Terminated'){
					 $title="Termination";
					 $msg="Terminated on ".date("dS M, Y", strtotime($request[5]));
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg=" Resigned on " .date("dS M, Y", strtotime($request[5]));				
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg="Absconded on ".date("dS M, Y", strtotime($request[5]));						
			   }
			   $sql="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($request[2],$title,Utils::getDateformat($request[5]), $msg, $orgid));
				$reason=Utils::getOtherName($request[8],'SeveranceReason',$this->db);
			   $name = Utils::getEmployeeName($request[2], $this->db);
			   $seniorids = Utils::getSeniorIds($request[2], $this->db);
			   $msg = $name." has been resigned on ".date("d M, Y");	
			   if($sts=='Terminated'){
					 $title="Termination";
					 $msg=$name." has been terminated on ".$request[5].", due to ".$reason;
					 
					$ests=$this->getEmpStsId($sts);
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg=$name." has been resigned on ".$request[5].", due to ".$reason;	
					$ests=$this->getEmpStsId($sts);
					
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg=$name." has been absconded on ".$request[5].", due to ".$reason;
					$ests=$this->getEmpStsId($sts);
					
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , DOL=?, LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,Utils::getDateformat($request[3]),$mid,$mdate,$request[2]));
			   }
			   
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, Utils::getDateformat($request[5]), date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2));
			   
			   
			
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_CREATION_FAILED;
			}
			}catch(Exception $e) {
				$status =false;
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		$_SESSION["feedback_positive"][] = "Success! We have updated your settings. Background Process can take upto 12 hours to detect changes and refresh. ubiHRM has no control over that refresh process. ";
		$result["data"] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function Create1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM SeveranceMaster WHERE EmployeeId = ? AND EmployeeStatus =?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$request[7]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=SEVERANCE_MODULE_CREATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO SeveranceMaster ( EmployeeId, EffectDate, NoticePeriod, SeveranceDate, Message,  CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, EmployeeStatus,SeveranceStatus,TurnoverReason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],Utils::getDateformat($request[3]), $request[4],Utils::getDateformat($request[5]),$request[6],$mid,$mdate,$mid, $mdate, $orgid,  $mid, $request[7],3,$request[8]));
				$sid=$this->db->lastInsertId();
				$count =  $query->rowCount();		
			
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'OfficLetterMaster','EmployeeId',$this->db);
				$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
				$msg="Severance  has been created of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance", $msg, $orgid));
			   $status =true;
			   $successMsg = SEVERANCE_MODULE_CREATION_ABSCOND;
			   if($request[7] != 3){
					$type=4;
					$successMsg = SEVERANCE_MODULE_CREATION_SUCCESS;
					if($request[7] == 2){
						$type=5;	

					}
					$senior = Utils::getApprovalLevelEmp($request[2], $type, $this->db);
					if($senior==0)
					{
						$senior = Utils::getSeniorId($request[2], $this->db);
					}
					if($senior!=0)
					{
						$temp = explode(",", $senior);
						for($i=0; $i<count($temp); $i++)
						{
							$sql = "INSERT INTO ResignationApproval ( ResignationId, ApproverId, LeaveStatus, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($sid, $temp[$i], 3, $mdate, $orgid));
						}
					}	
			   
			   }else{
					Utils::checkseniors($request[2],$this->db);
			   }
			   
			   $msg="";$title="";
			   ////////create employee history/////////
			   $sts=Utils::getEmployeeStatus($request[7]);
			   if($sts=='Terminated'){
					 $title="Termination";
					 $msg="Terminated on ".date("dS M, Y", strtotime($request[5]));
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg=" Resigned on " .date("dS M, Y", strtotime($request[5]));				
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg="Absconded on ".date("dS M, Y", strtotime($request[5]));						
			   }
			   $sql="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($request[2],$title,Utils::getDateformat($request[5]), $msg, $orgid));
				$reason=Utils::getOtherName($request[8],'SeveranceReason',$this->db);
			   $name = Utils::getEmployeeName($request[2], $this->db);
			   $seniorids = Utils::getSeniorIds($request[2], $this->db);
			   $msg = $name." has been resigned on ".date("d M, Y");	
			   if($sts=='Terminated'){
					 $title="Termination";
					 $msg=$name." has been terminated on ".$request[5].", due to ".$reason;
					 
					$ests=$this->getEmpStsId($sts);
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Resigned'){
					$title="Resignation";	
					$msg=$name." has been resigned on ".$request[5].", due to ".$reason;	
					$ests=$this->getEmpStsId($sts);
					
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,$mid,$mdate,$request[2]));	
					
			   }elseif($sts=='Absconded'){
					$title="Absconding";	
					$msg=$name." has been absconded on ".$request[5].", due to ".$reason;
					$ests=$this->getEmpStsId($sts);
					
					$sql="UPDATE EmployeeMaster set EmployeeStatus=? , DOL=?, LastModifiedById=?, LastModifiedDate=? where Id=?";
				    $query = $this->db->prepare($sql);
				    $query->execute(array($ests,Utils::getDateformat($request[3]),$mid,$mdate,$request[2]));
			   }
			   
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, Utils::getDateformat($request[5]), date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2));
			   
			   
			
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_CREATION_FAILED;
			}
			}catch(Exception $e) {
				$status =false;
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		$result["data"] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	/**
     * Setter for a SeveranceMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function CreateResigned($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		$resignedon =  date("Y-m-d");
		$empsts = 1;   /////////// 1 FOR RESIGNATION 2 FOR TERMINATION /////////////////////////
		
		$sql = "INSERT INTO SeveranceMaster ( EmployeeId, SeveranceDate,EffectDate, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, EmployeeStatus, SeveranceStatus, SeveranceReason,NoticePeriod,TurnoverReason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, $resignedon,Utils::getDateformat($request[4]), $mid, $mdate, $mid, $mdate, $orgid, $mid, $empsts, 3, $request[2],$request[3],$request[5]));
			$sid=$this->db->lastInsertId();
			$count =  $query->rowCount();		
			$resignationid= $this->db->lastInsertId();
			if ($count == 1) {
				//$empid=Utils::getName($did,'OfficLetterMaster','EmployeeId',$this->db);
				$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
				$msg="Severance  has been created resigned of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance Model", $msg, $orgid));
			   $status =true;
			   $successMsg = SEVERANCE_MODULE_SELF_CREATION_SUCCESS;
				   
				
				$senior = Utils::getApprovalLevelEmp($mid, 4, $this->db);
				if($senior==0)
				{
					$senior = Utils::getSeniorId($mid, $this->db);
				}
				if($senior!=0)
				{
					$temp = explode(",", $senior);
					//print_r($temp);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ResignationApproval ( ResignationId, ApproverId, LeaveStatus, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($resignationid, $temp[$i], 3, $mdate, $orgid));
						if($i==0){
						/////////////////////////// Fetching severence and employee detail /////////////////////////////////
						$count=0; $severenceempid=""; $severancedate=""; $lastwd=""; $noticeperiod=""; $empsts="";$reason=""; $reasontitle=""; $lastworkingday=""; $empname=""; $division=""; $department=""; $reportingto="";
						$userid=$mid;
						$sql = "SELECT * FROM SeveranceMaster WHERE Id = :id";
						$query = $this->db->prepare($sql);
						try{
							$query->execute(array(':id' => $sid ));
							$count =  $query->rowCount();
							if($count>=1)
							{
								$status=true;
								//$successMsg=$count." record found";
								if($row = $query->fetch())
								{	
									$noticeperiod = $row->NoticePeriod;
									$severancedate = Utils::dateformatter($row->SeveranceDate);
									$empsts = Utils::getEmployeeStatus($row->EmployeeStatus);
									$reason = $row->SeveranceReason;
									$reasontitle = Utils::getOtherName($row->TurnoverReason, "SeveranceReason", $this->db);
									$lastworkingday=Utils::dateformatter($row->EffectDate);
									$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ?";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($row->EmployeeId ));
									while($row1=$query1->fetch()){
										$empname = $row1->FirstName.' '.$row1->LastName;	
										$division = Utils::getName($row1->Division,'DivisionMaster','Name',$this->db);
										$department = Utils::getName($row1->Department,'DepartmentMaster','Name',$this->db);
										$reportingto = Utils::getEmployeeName($row1->ReportingTo,$this->db);
									}
									/* $sql1 = "SELECT * FROM ResignationApproval WHERE ResignationId = ? and OrganizationId = ? and LeaveStatus<>3";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array( $row->Id,$orgid ));
									while($r=$query1->fetch())
									{
										$res1=array();
										$res1['id'] = $r->Id;
										$res1['name'] = Utils::getEmployeeName($r->ApproverId, $this->db);
										$res1['sts'] = Utils::getOtherName($r->LeaveStatus, "LeaveStatus", $this->db);
										$res1['comment'] = $r->ApproverComment;
										$res1['approvaldate'] = Utils::datetimeformatter($r->ApprovalDate);
										$res['Approvals'][]=$res1;
									} */
								}
							}
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
						
						/////////////////////////// End Fetching severence and employee detail /////////////////////////////////
						$empname=Utils::getName($mid,'EmployeeMaster','FirstName',$this->db);
						$seniorname=Utils::getName($temp[$i],'EmployeeMaster','FirstName',$this->db);
						$senioremail=Utils::decode5t(Utils::getName($temp[$i],'EmployeeMaster','CompanyEmail',$this->db));
						$approvelink=URL."approvalbymail/viewapproveseveranceapproval/$temp[$i]/$orgid/$resignationid/2";
						$rejectlink=URL."approvalbymail/viewapproveseveranceapproval/$temp[$i]/$orgid/$resignationid/1";
						$title="Severance Request";
						$msg="
						<b>Request for severance</b><hr><br>
							<center>
								<table width='80%'>
									<tr><th width='10%'></th><th width='40%'></th><th width='10%'></th><th width='40%'></th></tr>
									<tr><td><b>Employee</b></td><td>$empname</td><td><b>Division</b></td><td>$division</td></tr>
									<tr><td><b>Department</td></b><td>$department</td><td><b>Reporting to</b></td><td>$reportingto</td></tr>
									<tr><td><b>Severance Date<b/></td><td>$severancedate</td><td><b>Employee Status<b/></td><td>$empsts</td></tr>
									<tr><td><b>Last Working Day</b></td><td>$lastworkingday</td><td><b>Notice Period</b></td><td>$noticeperiod</td></tr>
									<tr><td><b>Reason</b></td><td>$reasontitle</td></tr>
								</table><br>
							</center>
						<b>Request for severance</b><hr><br>
							<center>
							<table width='80%'>
							<tr><td>
							$reason
							</td></tr>
							</table><br>
							</center>

						<center>
						
						<table>
						<tr>
						<td><br/><br/>
						<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
						-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
						&nbsp;&nbsp;
						&nbsp;&nbsp;
						<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
						-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
						<br/><br/>
					</td>															
			</tr>
		</table>
	</center>";
						//Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
							//Utils::Trace($senioremail." ".$msg);
						}
					}
				}
				
			   ////////create employee history/////////
			$title="Resignation";	
			$msg="You resigned on ".date("d M, Y");						
			$sql="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, $title, $resignedon, $msg, $orgid));
			/*    $name = Utils::getEmployeeName($mid, $this->db);
			   $seniorids = Utils::getSeniorIds($mid, $this->db);
			   $msg = $name." has resigned on ".date("d M, Y");	
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $resignedon, date("Y-m-d", strtotime(date("Y-m-d")." , +10 days ")), 2,2)); */
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;		
        // default return
        return $result;
    }
	
	
	public function CreateTerminated($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		$terminateon =  Utils::getDateformat($request[4]);
		$employeeid =  $request[3];
		$empsts = 2;   /////////// 1 FOR RESIGNATION 2 FOR TERMINATION /////////////////////////
		
		$sql = "INSERT INTO SeveranceMaster ( EmployeeId, SeveranceDate, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, EmployeeStatus, SeveranceStatus, SeveranceReason) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($employeeid, $terminateon, $mid, $mdate, $mid, $mdate, $orgid, $mid, $empsts, 3, $request[2]));
			$sid=$this->db->lastInsertId();
			$count =  $query->rowCount();		
			
			if ($count == 1) {
				//$empid=Utils::getName($did,'OfficLetterMaster','EmployeeId',$this->db);
				$empname=Utils::getName($employeeid,'EmployeeMaster','FirstName',$this->db);
				$msg="Severance  has been create terminated $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance Model", $msg, $orgid));
			    $status =true;
			    $successMsg = SEVERANCE_MODULE_CREATION_SUCCESS;
				$terminationid= $this->db->lastInsertId();
				$senior = Utils::getApprovalLevelEmp($employeeid, 4, $this->db);
				if($senior==0)
				{
					$senior = Utils::getSeniorId($employeeid, $this->db);
				}
				if($senior!=0)
				{
					$temp = explode(",", $senior);
					for($i=0; $i<count($temp); $i++)
					{
						$sql = "INSERT INTO ResignationApproval ( ResignationId, ApproverId, LeaveStatus, CreatedDate ,   OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($terminationid, $temp[$i], 3, $mdate, $orgid));
					}
				}
				////////create employee history/////////
			   $title="Termination Request";	
				
			   $empname = Utils::getEmployeeName($employeeid, $this->db);
			   $name = Utils::getEmployeeName($mid, $this->db);
			   $seniorids = Utils::getSeniorIds($mid, $this->db);
			   
			   $msg = $name." has requested to terminate an employee '$empname' by ".date("d M, Y", strtotime($terminateon));	
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, date("Y-m-d"), date("Y-m-d", strtotime(date("Y-m-d").", +10 days ")), 2,2));
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["data"] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function WithdrawResignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		$severanid =  $request[2];
		
		$sql = "UPDATE  SeveranceMaster SET  SeveranceStatus = 5,  LastModifiedDate = ?, LastModifiedById=? WHERE Id=?";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array( $mdate, $mid, $severanid));
			$sid=$this->db->lastInsertId();
			$count =  $query->rowCount();		
			
			if ($count == 1) {
				$empid=Utils::getName($severanid,'SeveranceMaster','EmployeeId',$this->db);
				$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
				$msg="Severance  has been resignation withdraw of $empname";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Severance Model", $msg, $orgid));
			   $status =true;
			   $successMsg = SEVERANCE_MODULE_WITHDRAW_SUCCESS;
				   
			   $name = Utils::getEmployeeName($mid, $this->db);
			   $title="Resignation Withdraw";	
				
			  
			   $seniorids = Utils::getSeniorIds($mid, $this->db);
			   
			   $msg = $name." has withdraw his/her resignation";	
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationType, NotificationPriority) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $seniorids, $orgid, $mdate, $mid, $mdate, $mid, $mid, date("Y-m-d"), date("Y-m-d", strtotime(date("Y-m-d").", +2 days ")), 2, 2));
			   
			  
			} else {
			   $status =false;
			   $errorMsg = SEVERANCE_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		$result["data"] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function ChangeStatus($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $sid=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
        $count1 = 0;
		$mdate = date("Y-m-d H:i:s");
		$severanid =  $request[2];
		$severansts =  $request[3];
		$comments =  $request[4];
		
		$sql = "UPDATE  ResignationApproval SET  LeaveStatus = ?, ApproverComment = ?,  ApprovalDate = ? WHERE ResignationId = ? and ApproverId=?";
		//Utils::Trace($sql);
		$query = $this->db->prepare($sql);
		$query->execute(array($severansts,$comments,$mdate,$severanid,$mid));
		if( $query->rowCount()>0)
		{
			$status =true;
			$successMsg = "Severance approved successfully";
			if($severansts == 1)
			$successMsg = "Severance rejected successfully";
			$sql1 ="Select * from ResignationApproval where ResignationId=? and LeaveStatus=3";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($severanid));
			if( $query1->rowCount()==0)
			{
				$sql = "UPDATE  SeveranceMaster SET  SeveranceStatus =? , LastModifiedDate = ?, LastModifiedById=? WHERE Id=?";
				try{
					$query = $this->db->prepare($sql);
					$query->execute(array($severansts, $mdate, $mid, $severanid));
					$status =true;
					$successMsg = "Severance approval completed successfully";
					
					$sql2 = "SELECT * FROM EmployeeMaster WHERE Id = (Select EmployeeId from SeveranceMaster where Id=?)";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array($severanid ));
					if($row2=$query2->fetch()){
						$empname = $row2->FirstName.' '.$row2->LastName;	
						$companyemail=Utils::decode5t(Utils::getName($row2->Id,'EmployeeMaster','CompanyEmail',$this->db));
						$title="Severance approval";
						$msg="";
						if($severansts==2)					
							$msg="Dear  $empname,<br> Your application for Severance is accepted <br> Thanking You";
						else
							$msg="Dear  $empname,<br> Your application for Severance is rejected <br> Thanking You";
							
							Utils::Trace($companyemail." ".$msg);
							Utils::sendMail($companyemail,"UBIHRM",$title,$msg);
					}
					
					
				}catch(Exception $e) {
					$status =false;
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			
			if($r=$query1->fetch())
				{				
					$nxtapproverid = $r->ApproverId;
					//$approvelink=URL."approvalbymail/viewapproveseveranceapproval/$temp[$i]/$orgid/$resignationid/2";
					$approvelink = URL."approvalbymail/viewapproveseveranceapproval/$nxtapproverid/$orgid/$severanid/2";
					$rejectlink = URL."approvalbymail/viewapproveseveranceapproval/$nxtapproverid/$orgid/$severanid/1";
					$seniorname = Utils::getName($nxtapproverid,'EmployeeMaster','FirstName',$this->db);
					$senioremail = Utils::decode5t(Utils::getName($nxtapproverid,'EmployeeMaster','CompanyEmail',$this->db));
					
					/////////////////////////// Fetching severence and employee detail /////////////////////////////////
					$count=0; $severenceempid=""; $severancedate=""; $lastwd=""; $noticeperiod=""; $empsts="";$reason=""; $reasontitle=""; $lastworkingday=""; $empname=""; $division=""; $department=""; $reportingto="";$approverhistory = "";
					$userid=$mid;
					$sql = "SELECT * FROM SeveranceMaster WHERE Id = :id";
					$query = $this->db->prepare($sql);
					try{
						$query->execute(array(':id' => $severanid ));
						$count =  $query->rowCount();
						if($count>=1)
						{
							//$empid=Utils::getName($timeoffid,'Timeoff','EmployeeId',$this->db);
							//$empname=Utils::getName($request[2],'EmployeeMaster','FirstName',$this->db);
							$msg="Severance has been updated of $empname";
							$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
							$query = $this->db->prepare($sql);
							$query->execute(array($mid, "Severance Model", $msg, $orgid));
							$status=true;
							//$successMsg=$count." record found";
							if($row = $query->fetch())
							{	
								$noticeperiod = $row->NoticePeriod;
								$severancedate = Utils::dateformatter($row->SeveranceDate);
								$empsts = Utils::getEmployeeStatus($row->EmployeeStatus);
								$reason = $row->SeveranceReason;
								$reasontitle = Utils::getOtherName($row->TurnoverReason, "SeveranceReason", $this->db);
								$lastworkingday=Utils::dateformatter($row->EffectDate);
								$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ?";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array($row->EmployeeId ));
								while($row1=$query1->fetch()){
									$empname = $row1->FirstName.' '.$row1->LastName;	
									$division = Utils::getName($row1->Division,'DivisionMaster','Name',$this->db);
									$department = Utils::getName($row1->Department,'DepartmentMaster','Name',$this->db);
									$reportingto = Utils::getEmployeeName($row1->ReportingTo,$this->db);
								}
								
								$sql1 = "SELECT * FROM ResignationApproval WHERE ResignationId = ? and OrganizationId = ? and LeaveStatus<>3";
								$query1 = $this->db->prepare($sql1);
								$query1->execute(array( $severanid,$orgid ));
								$count =  $query1->rowCount();
								if($count>=1){
									$approverhistory = "<p><b>Approval History</b></p><hr><br><center>
									<table border='1' style=' border-collapse: collapse;width:80%'>
									<tr style=' background-color: rgba(107, 58, 137, 0.91);color: rgba(255, 247, 247, 1);'>
														<th>Approval By</th>
														<th>Approval Status</th>
														<th>Approval Date</th>
														<th>Remarks</th>
									</tr>";
								}
									while($r1=$query1->fetch()){
										$approvername=Utils::getEmployeeName($r1->ApproverId,$this->db);
										$approvalsts=$r1->LeaveStatus;
										if($approvalsts==1){
											$approvalsts="Rejected";
										}elseif($approvalsts==2){
											$approvalsts="Approved";
										}elseif($approvalsts==3){
											$approvalsts="Pending";
										}elseif($approvalsts==4){
											$approvalsts="Cancel";
										}elseif($approvalsts==5){
											$approvalsts="Withdrawn";
										}
										$approvaldate="";
										$approvaldate=Utils::datetimeformatter($r1->ApprovalDate);
										$approvercomment=$r1->ApproverComment;
										$approverhistory.="<tr>
										<th>$approvername</th>
										<th>$approvalsts</th>
										<th>$approvaldate</th>
										<th>$approvercomment</th>
									</tr>";
								}
								if($count>=1){
									$approverhistory.="</table></center>";
								}
							}
						}
						
						}catch(Exception $e) {
							$errorMsg = 'Message: ' .$e->getMessage();
						}
					
					$title="Severance approval";
					$msg="
					<b>Request for severance</b><hr><br>
						<center>
							<table width='80%'>
								<tr><th width='10%'></th><th width='40%'></th><th width='10%'></th><th width='40%'></th></tr>
								<tr><td><b>Employee</b></td><td>$empname</td><td><b>Division</b></td><td>$division</td></tr>
								<tr><td><b>Department</td></b><td>$department</td><td><b>Reporting to</b></td><td>$reportingto</td></tr>
								<tr><td><b>Severance Date<b/></td><td>$severancedate</td><td><b>Employee Status<b/></td><td>$empsts</td></tr>
								<tr><td><b>Last Working Day</b></td><td>$lastworkingday</td><td><b>Notice Period</b></td><td>$noticeperiod</td></tr>
								<tr><td><b>Reason</b></td><td>$reasontitle</td></tr>
							</table><br>
						</center>
					<b>Request for severance</b><hr><br>
						<center>
						<table width='80%'>
						<tr><td>
						$reason
						</td></tr>
						</table><br>
						</center>
						$approverhistory
						<center>
							<table>
								<tr>
									<td><br/><br/>
											<a href='$approvelink' style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
											-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Approve</a>
											&nbsp;&nbsp;
											&nbsp;&nbsp;
											<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
											-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Reject</a>
											<br/><br/>
										</td>															
								</tr>
							</table>
							
							
						</center>";
					Utils::Trace($senioremail." ".$msg);
					Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
				}
			
			  /*  $name = Utils::getEmployeeName($mid, $this->db);
			   $title="Severance Status";	
			   $msg = $name." has been reject your Severance";	
			   if($severansts==2){ 	
					$msg = $name." has been approved your Severance";	
			   }
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationType, NotificationPriority) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, $empid, $orgid, $mdate, $mid, $mdate, $mid, $mid, date("Y-m-d"), date("Y-m-d", strtotime(date("Y-m-d").", +2 days ")), 1, 2)); */
		}else{
				$sql1 = "select * from ResignationApproval WHERE ResignationId=? and ApproverId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($severanid,$mid));
				$sts=0;
				if($r=$query1->fetch()){
					$sts=$r->ApproverSts;
				}
				if($sts==1){
					$sts="rejected";
				}elseif($sts==2){
					$sts="approved";
				}else{
					$sts="answered";
				}
				$status=false;
				$errorMsg="Request already been ".$sts;
		}
		$result['data'] =$sid;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
		$empid=Utils::getName($did,'SeveranceMaster','EmployeeId',$this->db);		
		/////if we delete severance then date of leaving for that employee should be blank////
		$sql1 = "SELECT * FROM SeveranceMaster WHERE Id = ?";	
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $did ));		
		while($row= $query1->fetch())
		{
			$sql = "UPDATE EmployeeMaster set DOL='0000-00-00' WHERE Id = ? ";	
			$query = $this->db->prepare($sql);
			$query->execute(array( $row->EmployeeId ));
			
			$sql = "UPDATE UserMaster set VisibleSts='1' WHERE EmployeeId = ? ";	
			$query = $this->db->prepare($sql);
			$query->execute(array( $row->EmployeeId ));
		}
		$sql = "DELETE FROM ResignationApproval WHERE ResignationId = ? ";	
		$query = $this->db->prepare($sql);
		$query->execute(array( $did ));		
		$sql = "DELETE FROM SeveranceMaster WHERE Id = :id ";		
				
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		if ($count == 1) {
			
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Severance of $empname  has been deleted.  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Severance", $msg, $orgid));
		   $status =true;
		   $successMsg = SEVERANCE_MODULE_DELETE_SUCCESS;
		}else {
		   $status =false;
		   $errorMsg = SEVERANCE_MODULE_DELETE_FAILED;
		}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	/*public function deletedoc($path) {
        if (is_dir($path)) {
            array_map(function($value) {
                $this->deletedoc($value);
                rmdir($value);
            },glob($path . '/*', GLOB_ONLYDIR));
            array_map('unlink', glob($path."/*"));
        }
		rmdir($path);
    }*/
	//////////////////////////////uploading image/////////////////////////////
	public function uploadImage($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$empcode=$this->getCode($empid);
		$new_name="";
		$dir="public/uploads/$orgid/$empcode";
		try{
		//$this->deletedoc($dir);
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0777);
			
		}
		//$dir="public/uploads/$orgid";
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif' || $ext=='pdf' || $ext=='doc' || $ext=='docx')
				{
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$empcode.$ext1")
								{
									unlink($dir."/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name=$empcode."_severance.".$ext;
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					//$location="public/uploads/$orgid/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $dir.'/'.$new_name);
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}				
			}
			
			//////////////updating path of employee profile picture in database/////////////
			
			$sql = "UPDATE SeveranceMaster SET  Attachment=? where EmployeeId=?";	
            $query = $this->db->prepare($sql);
			$query->execute(array($new_name,$empid ));			
			$count =  $query->rowCount();
				
			}catch(Exception $e) {
			
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_PROFILEIMAGE;
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getEmpStsId($sts)
	{
		$empcode ="";
		$sql = "SELECT ActualValue FROM OtherMaster WHERE OtherType='EmployeeStatus' and DisplayName = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $sts ));
			while($row = $query->fetch())
			{
				$empcode =  $row->ActualValue;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getApprovarSts($id, $userid)
	{
		$result = false;
		$sql = "SELECT ApproverId FROM ResignationApproval WHERE ResignationId = ? and LeaveStatus=3 limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				if($row->ApproverId==$userid)
					return true;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SeveranceMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'EmployeeStatus', 'SeveranceDate','EffectDate','SeveranceStatus','TurnoverReason','Message','Id');
		$mdate = date("Y-m-d");
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		else{
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = " WHERE  OrganizationId= $orgid  AND Id in (SELECT ResignationId FROM ResignationApproval where ApproverId=$userid)  ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $approver="";
					
					if($editper && ($hrsts==1 || $sts==1)){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editseverance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					
					if($this->getApprovarSts($aRow->Id, $userid) && ($aRow->SeveranceStatus==3 || $aRow->SeveranceStatus==0)){
						$approver = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editseveranceapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-thumbs-o-up"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
					}
					
					if($deleteper &&( $sts==1 || $hrsts==1)){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					if($aRow->EmployeeStatus == 3){
						$row[] =$delete;
					}else{
						$row[] =$approver.$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'employee/viewseverance/'.Utils::encode5t($aRow->Id).'/1">'.Utils::getEmployeeName($aRow->{$aColumns[$i]},$this->db) .'</a>';
					
				}
				else if($aColumns[$i]=="EmployeeStatus")
				{
					$row[] = Utils::getEmployeeStatus($aRow->{$aColumns[$i]});
					
				}
				else if($aColumns[$i]=="TurnoverReason")
				{
					$row[] = Utils::getOtherName($aRow->{$aColumns[$i]},'SeveranceReason',$this->db);
					
				}
				else if($aColumns[$i]=="SeveranceStatus")
				{
					if($aRow->EmployeeStatus == 3){
						$row[] =" ";
					}else{
						$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
					}
				}
				else if( $aColumns[$i]=="SeveranceDate" ||  $aColumns[$i]=="EffectDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
		/////////// to find out the previous status of severance wether it is approved or not /////////////
		public function getpreviousSeveranceApprovalSts($user_id,$org_id,$employeeseveranceid){
		$sql1 = "select * from ResignationApproval WHERE ResignationId =? AND ApproverId=? and OrganizationId=?";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array( $employeeseveranceid,$user_id,$org_id));
		$con=$query1->rowCount();
		$ApproverSts=3;
		if($r=$query1->fetch()){
			$ApproverSts=$r->LeaveStatus;
		}
		return $ApproverSts;
		}
	
}
