<?php

/**
 * SetupModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SetupModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the details of specific organization
     * @return array an array with several objects (the results)
     */
    public function getOrganization()
    {
		$result = array();
		$orgid=$_SESSION['ubihrm_org_id'];
        $sql = "SELECT * FROM Organization WHERE Id = :id";
        $query = $this->db->prepare($sql);
        $query->execute(array(':id' => $_SESSION['ubihrm_org_id']));
		$count =  $query->rowCount();
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['website'] = $row->Website;
				$res['phone'] = $row->PhoneNumber;
				$res['altphone'] = $row->AltPhoneNumber;
				$res['email'] = $row->Email;
				$res['altemail'] = $row->AltEmail;
				$res['logo'] = $row->Logo;
				$res['address'] = $row->Address;
				$res['country'] = $row->Country;
				$res['city'] = $row->City;
				$res['zip'] = $row->ZipCode;
				$res['landmark'] = $row->Landmark;
				$res['currency'] = $row->Currency;
				$res['dateformat'] = $row->DateFormat;
				$res['timeformat'] = $row->TimeFormat;
				$res['timezone'] = $row->TimeZone;
				$res['aboutcompany'] = $row->AboutCompany;
				$res['cmppic']=$row->Logo;
				$result["data"][] = $res;
				$result['result']=true;
				$result['status']=true;
			}
        }else{
			$result["data"] =array();
			$result['result']=false;
			$result['status']=false;
		}
		return $result;
    }

    
    /**
     * Setter for a note (create)
     * @param string $note_text note text that will be created
     * @return bool feedback (was the note created properly ?)
     */
    public function AddUpdateOrganization()
    {
		$result = array();
		$orgid = $_SESSION['ubihrm_org_id'];
        // Get post data variable submitted from form
		$name 			= isset($_POST['company_name']) 	? $_POST['company_name'] 	: "";
		$website 		= isset($_POST['company_website']) 	? $_POST['company_website'] : "";
		$number 		= isset($_POST['contact_number']) 	? $_POST['contact_number'] 	: "";
		$alt_number 	= isset($_POST['alternate_number']) ? $_POST['alternate_number']: "";
		$email 			= isset($_POST['email_address']) 	? $_POST['email_address'] 	: "";
		$alt_email 		= isset($_POST['alternate_email']) 	? $_POST['alternate_email'] : "";
		$address 		= isset($_POST['address']) 			? $_POST['address'] 		: "";
		$country 		= isset($_POST['country']) 			? $_POST['country'] 		: "";
		$landmark 		= isset($_POST['landmark']) 		? $_POST['landmark'] 		: "";
		$city 			= isset($_POST['city']) 			? $_POST['city'] 			: "";
		$zip_code 		= isset($_POST['zip_code']) 		? $_POST['zip_code'] 		: "";
		$currency 		= isset($_POST['currency']) 		? $_POST['currency'] 		: "";
		$timezone 		= isset($_POST['timezone']) 		? $_POST['timezone'] 		: "";
		$dateformate 	= isset($_POST['dateformate']) 		? $_POST['dateformate'] 	: "";
		$timeformate 	= isset($_POST['timeformate']) 		? $_POST['timeformate'] 	: "";
		$about 			= isset($_POST['about']) 			? $_POST['about'] 			: "";
		
        $count1=0;$count2 =0;
		$mdate = date("Y-m-d H:i:s");
		$mid =0;
		$sql1 = "SELECT Id FROM Organization WHERE Id = :id";
        $query1 = $this->db->prepare($sql1);
        $query1->execute(array(':id' => $orgid));
		$count1 =  $query1->rowCount();
		if ($count1 == 1) 
		{
			$sql2 = "UPDATE Organization SET Name=:name, Website=:website, PhoneNumber=:number, AltPhoneNumber=:altnumber, Email=:email, AltEmail=:altemail, Address=:address, Country=:country, City=:city, ZipCode=:zipcode, Landmark=:landmark, Currency=:currency, DateFormat=:dateformat, TimeFormat=:timeformat, TimeZone=:timezone, AboutCompany=:about, LastModifiedDate=:mdate, LastModifiedById=:mid where Id=:id";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array(':name' => $name, ':website' => $website, ':number' => $number, ':altnumber' => $alt_number, ':email' => $email, ':altemail' => $alt_email, ':address' => $address, ':country' => $country, ':city' => $city, ':zipcode' => $zip_code, ':landmark' => $landmark, ':currency' => $currency, ':dateformat' => $dateformate, ':timeformat' => $timeformate, ':timezone' => $timezone, ':about' => $about, ':mdate' => $mdate, ':mid' => $mid,  ':id' => $orgid ));
			
			$count2 =  $query2->rowCount();
		}else
		{
			$sql2 = "INSERT INTO Organization (Name, Website, PhoneNumber, AltPhoneNumber, Email, AltEmail, Address, Country, City, ZipCode, Landmark, Currency, DateFormat, TimeFormat, TimeZone, AboutCompany, LastModifiedDate, LastModifiedById, CreatedDate, CreatedById) VALUES (:name, :website, :number, :altnumber, :email, :altemail, :address, :country, :city, :zipcode, :landmark, :currency, :dateformat, :timeformat, :timezone, :about, :mdate, :mid, :cdate, :cid)";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array(':name' => $name, ':website' => $website, ':number' => $number, ':altnumber' => $alt_number, ':email' => $email, ':altemail' => $alt_email, ':address' => $address, ':country' => $country, ':city' => $city, ':zipcode' => $zip_code, ':landmark' => $landmark, ':currency' => $currency, ':dateformat' => $dateformate, ':timeformat' => $timeformate, ':timezone' => $timezone, ':about' => $about, ':mdate' => $mdate, ':mid' => $mid, ':cdate' => $mdate, ':cid' => $mid ));
			$count2 =  $query2->rowCount();
		}
		
        if ($count2 == 1) {
           $result['result']=true;
		   $result['msg']="Company details updated";
        } else {
           $result['result']=false;
		   $result['msg']="There is some problem";
        }
        // default return
        return $result;
    }
    
    
   function RelatedList($table,$org_id)
   {

	$data='';
	$count=0; 
	
	$sqlr ="SELECT * FROM RelatedListMaster WHERE ParentObject = ? AND Sts=1";

	$query = $this->db->prepare($sqlr);
        
        
	$query->execute(array($table));
	$count =  $query->rowCount();

	if($count>0)
	{
		while($rowRL = $query->fetch())
		{
			
			//echo $count;
			$count1=0;
			//print_r($rowRL);
			// displaying contact table data 
			$data .= '<div class="box box-solid box-primary">
            				<div class="box-header with-border">';
			$data .= '<h3 class="box-title">'.$rowRL->ListName.'</h3></div>';
			$data .= '<div class="box-body">';
			$listname = $rowRL->ChildObject;
			$dfields = $rowRL->DisplayFields;
			$sql2 ="";
			
			$view='';
			if($listname=='DepartmentMaster')
			{
				$view="viewdepartment";
			}
			if($listname=='DivisionMaster')
			{
				$view="viewdivision";
			}
			if($listname=='DesignationMaster')
			{
				$view="viewdesignation";
			}
			if($listname=='AssetsMaster')
			{
				$view="viewasset";
			}
			
			//$childobj = '';	
			$sql2 ="SELECT Id,$dfields FROM $listname WHERE OrganizationId=$org_id LIMIT 4 ";
			$dbq2 = $this->db->prepare($sql2);
			$dbq2-> execute();
			$count1 =  $dbq2->rowCount();
			//echo $count1;
			//$data .= '<tr><td>';
			$data .= '<table id="example1" class="table table-bordered table-striped">';
			//exit();
			//$childobj = $org_id."_".strtolower($rowRL['ChildObject']);
			if($count1>=1)
			{
				
					$headerRow = true;
					
					while ($row = $dbq2->fetch()) 
					{
						//print_r($row);
													
						if ($headerRow) 
						{
							$column = explode(',',$rowRL->DisplayFields);
							$headerRow = false;
							$data .= '<thead><tr>';
							
							for ($i=0; $i<count($column); $i++) 
							{
								$data .= '<th>'.$column[$i].'</th>';
							}
							
							$data .= '</tr></thead>';
							$data .= '<tbody><tr>';    
						}
						
						for($j=0; $j<count($column); $j++)
						{
							if($j==0)
							{
							$data .= '<td><a href="'.URL.'setup/'.$view.'/'.$row->Id.'/1">'.$row->$column[$j].'</a></td>';
							}
							else
							{
							$data .= '<td>'.$row->$column[$j].'</td>';
							}
							
						}
						$data .= '</tr>';
						
					}
					//exit();
					$data .= '</tr></tbody>';
				
			}
			else
			{
				$data .= '<tr><td>No records to display</td></tr>';
			}
			$data .= '</table>';
			$data .= '</div>';
			$data .= '</div>';
		}

	    }
	    return $data;
       }



function viewData($table,$id,$dfields)
   {

	$data='';
	$count=0; 

	$sqlr ="SELECT $dfields FROM $table WHERE Id=$id";

	$query = $this->db->prepare($sqlr);
        
        
	$query->execute();
	$count =  $query->rowCount();

	if($count>0)
	{
		while($rowRL = $query->fetch())
		{
			//echo $count;
			$count1=0;
			//print_r($rowRL);
			// displaying contact table data 
			$data .= '<div class="box box-solid box-primary">
            				<div class="box-header with-border">';
			$data .= '<h3 class="box-title">'.$table.'</h3></div>';
			$data .= '<div class="box-body">';
			
			
			if(0)
			{
				
					$headerRow = true;
					
						//print_r($row);
													
						if ($headerRow) 
						{
							$column = explode(',',$rowRL->DisplayFields);
							$headerRow = false;
							$data .= '<thead><tr>';
							
							for ($i=0; $i<count($column); $i++) 
							{
								$data .= '<th>'.$column[$i].'</th>';
							}
							
							$data .= '</tr></thead>';
							$data .= '<tbody><tr>';    
						}
						
						for($j=0; $j<count($column); $j++)
						{
							if($j==0)
							{
							$data .= '<td><a href="'.URL.'setup/viewdetail/'.$row->Id.'/'.$listname.'">'.$row->$column[$j].'</a></td>';
							}
							else
							{
							$data .= '<td>'.$row->$column[$j].'</td>';
							}
							
						}
						$data .= '</tr>';
						
					
					//exit();
					$data .= '</tr></tbody>';
				
			}
			else
			{
				//$data .= '<tr><td>No records to display</td></tr>';
			}
			//$data .= '</table>';
			$data .= '</div>';
			$data .= '</div>';
		}

	    }
	    return $data;
       }


	/*function getColumnValue($key,$value,$org_id,$id,$childobj)
	{

	switch ($key):
	case "Id":
	       echo '';
	       break;
	   case "CaseNumber":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$org_id.'_case\')">'.$value.'</a></td>';
	       break;
	   case "AccountId":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$value.'\',\''.$org_id.'_account\')">'.getAccountName($value,$org_id).'</a></td>';
	       break;
	case "ContactId":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$value.'\',\''.$org_id.'_contact\')">'.getContactName($value,$org_id).'</a></td>';
	       break;
	case "CreatedById":
	       echo '<td>'.getSfUserName($value,$org_id).'</td>';
	       break;
	case "CreatedbyId":
	       echo '<td>'.getSfUserName($value,$org_id).'</td>';
	       break;	

	case "Name":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$childobj.'\')">'.$value.'</a></td>';
	       break;
	case "Title":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$childobj.'\')">'.$value.'</a></td>';
	       break;	
	case "Empowerment_No__c":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$childobj.'\')">'.$value.'</a></td>';
	       break;
	case "SMService_Name__c":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$childobj.'\')">'.$value.'</a></td>';
	       break;
	case "Subject":
	       echo '<td><a href="javascript:void()" onclick="viewData(\''.$id.'\',\''.$childobj.'\')">'.$value.'</a></td>';
	       break;	
	case "LastModifiedDate":
	       echo '<td>'.changeDateFormate($value,true).'</td>';
	       break;	
	case "MessageDate":
	       echo '<td>'.changeDateFormate($value,true).'</td>';
	       break;
	case "CreatedDate":
	       echo '<td>'.changeDateFormate($value,true).'</td>';
	       break;	
	   default:
	       echo "<td>$value</td>";
	endswitch;
	}*/
   
  //////////////////upload company logo/////////////

	public function uploadImage($request)
	{
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d h:i:s");

		$new_name="";
		
		if (!file_exists("public/uploads/$orgid")) {
			mkdir("public/uploads/$orgid" ,  0777,true);
		}
		
		$dir="public/uploads/$orgid";
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='jpg' || $ext=='gif' || $ext=='MOV' || $ext=='ico' || $ext=='tif'){
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$orgid.$ext1")
								{
									unlink("public/uploads/$orgid/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$orgid.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						if(move_uploaded_file($file_tmp, $location.$new_name))
						{
							$count++;
						}
						
					}
					else{
						print_r($errors);
					}
				}
				else{
					$status =false;
					$successMsg = "Choose Only Image File Format like jpg,png,gif..etc";
				}				
			}
			//////////////updating path of employee profile picture in database/////////////
			
			$sql = "UPDATE Organization SET  Logo=?,  LastModifiedDate=? where Id=?";	
            $query = $this->db->prepare($sql);
		
			try{
		
				$query->execute(array($new_name,$mdate,$orgid ));			
				$count1 =  $query->rowCount();
				
			}catch(Exception $e) {
			
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			
			if ($count1 >= 1) {
			
			   $status =true;
			   $successMsg = "Logo uploaded successfully..";
			} else {
			   $status =false;
			   
			   $errorMsg .= "Logo not uploaded..";
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}  
   ///get salary checklist//// 
   public function getsalarychecklist()
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
				$sql = "SELECT * FROM ChecklistMaster WHERE CategoryId = 3 and OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid));
				$count=$query->rowCount();
				while($row1 = $query->fetch())
				{	
					$res = array();
					$res['id'] = 0;
					$res['name'] = $row1->Name;
					$res['categoryid'] = $row1->CategoryId;
					$res['sts'] = 0;
					$res['checklistid'] = $row1->Id;
					$data[] = $res;
				}
				if($count>0)
				{
					$status=true;
					$successMsg=$count." record found";
				}
				
		}catch(Exception $e){ 
			$status = false;
			$errorMsg =$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}	
	
}
