<?php

/**
 * SettingModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SettingModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SettingChild WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SETTINGS_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $arr[1];
		$type = $arr[2];
        //$sql = "SELECT * FROM SettingChild WHERE OrganizationId = ? and SettingId in (SELECT Id FROM SettingMaster where PageType=?)";
        $sql = "Select sc.Id as scid, sm.Id as smsettingid,sm.module_id as smmoduleid, sm.Name as smname, sc.ExecutionType as scExecutionType, sc.ExecutionValue as scExecutionValue, sc.NotifyAlert as scNotifyAlert, sc.SendMail as scSendMail from SettingMaster sm left join SettingChild sc on sm.Id=sc.SettingId and OrganizationId = ? where sm.PageType=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid, $type ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$modid = $row->smmoduleid;
				$per=Utils::CheckPermission($modid, 1);
				if($per){
					$res = array();
					$res['id'] = $row->scid;
					$res['setid'] = $row->smsettingid;
					$res['name'] = $row->smname;
					$res['exptype'] = (int)$row->scExecutionType;
					$res['expvalue'] = (float)$row->scExecutionValue;
					$res['alert'] = ($row->scNotifyAlert==1)?true:false;
					$res['mail'] = ($row->scSendMail==1)?true:false;
					if($row->smsettingid==11 || $row->smsettingid==13 || $row->smsettingid==14 || $row->smsettingid==16){
						$res['leadshow'] = 0;
					}
					else{
						$res['leadshow'] = 1;
					}
					$data[] = $res;
				}
			}
        }else{
			$sql = "SELECT * FROM SettingMaster where PageType=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $type ));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = 0;
				$res['setid'] = $row->Id;
				$res['name'] = $row->Name;
				$res['exptype'] = 0;
				$res['expvalue'] = 1;
				$res['alert'] = false;
				$res['mail'] = false;
				if($row->Id==11 || $row->Id==13 || $row->Id==14 || $row->Id==16){
					$res['leadshow'] = 0;
				}
				else{
					$res['leadshow'] = 1;
				}
				$data[] = $res;
			}
		}
		
		if ($count > 0) {
           $status =true;
		   $successMsg = SETTINGS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SETTINGS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		return $result;
    }
	  
	  public function getTabsEvent($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $data1 = array();
		//$orgid = $request;
		//$orgid=$_SESSION['ubihrm_org_id'];
		$orgid = $arr[1];
		$type = $arr[2];
		$empcount=0;
       // $sql = "SELECT * FROM ModuleMaster where TabId<>0 and ModuleSts=1 order by SortOnTab";
	   ////////////this code belongs to found out modules according to organization package//////////////
		//   $sql = "Select sc.Id as scid, sm.Id as smsettingid,sm.module_id as smmoduleid, sm.Name as smname, sc.ExecutionType as scExecutionType, sc.ExecutionValue as scExecutionValue, sc.NotifyAlert as scNotifyAlert, sc.SendMail as scSendMail from SettingMaster sm left join SettingChild sc on sm.Id=sc.SettingId and OrganizationId = ? where sm.PageType=?";
	 $sql = "SELECT * FROM SettingMaster where PageType=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($type));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			//$res = array();
			//$res['id'] = 0;
			//$res['sts'] = false;
			//$data[] = $res;
			
			while($row = $query->fetch())
			{
				$modid = $row->module_id;
				$per=Utils::CheckPermission($modid, 1);
				if($per){
					$res = array();
					$res['id'] = $row->Id;
					$res['setid'] = $row->Id;
					$res['name'] = $row->Name;
					$res['exptype'] = 0;
					$res['expvalue'] = 1;
					$settings = $this->getSettingChildval($row->Id,'Settingsonoff');
					$res['settingsonoff'] = ($settings==1)?true:false;
					//$res['alert'] = false;
					$res['mail'] = false;
					if($row->Id==11 || $row->Id==13 || $row->Id==14 || $row->Id==16){
							$res['leadshow'] = 0;
					}
					else{
						$res['leadshow'] = 1;
					}
					$res['label'] = $row->Name;
					$res['tabid'] = Utils::getName($modid, 'ModuleMaster', 'TabId', $this->db);
					$data[] = $res;
					/* $res = array();
					$res['id'] = $row->scid;
					$res['setid'] = $row->smsettingid;
					$res['name'] = $row->smname;
					$res['label'] = $row->smname;
					$res['tabid'] = Utils::getName($modid, 'ModuleMaster', 'TabId', $this->db);
					$res['tabname'] = ($row->TabId==1)?"Employee":(($row->TabId==2)?"Attendance":(($row->TabId==3)?"Leave":(($row->TabId==4)?"Salary":($row->TabId==5)?"Organization":($row->TabId==6)?"Performance":"Timesheet")));
					$res['exptype'] = (int)$row->scExecutionType;
					$res['expvalue'] = (float)$row->scExecutionValue;
					$res['alert'] = ($row->scNotifyAlert==1)?true:false;
					$res['mail'] = ($row->scSendMail==1)?true:false;
					if($row->smsettingid==11 || $row->smsettingid==13 || $row->smsettingid==14 || $row->smsettingid==16){
						$res['leadshow'] = 0;
					}
					else{
						$res['leadshow'] = 1;
					} */
					
				}
			}
			/////////find out the permitted tabs according to organization id////
			$sql = "SELECT *,m.id as moduleid FROM ModuleMaster m,OrgPermission o where m.id=o.ModuleId and m.TabId=o.TabId and OrgId=? and  m.TabId<>0 and ModuleSts=1 and ViewPermission=1 group by m.TabId ORDER BY FIELD(m.TabId, 5) DESC";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid));
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->moduleid;
				$res['tabid'] = $row->TabId;
				$tabname="";
				if($row->TabId==5)
					$tabname="Organization";
				elseif($row->TabId==1)
					$tabname="Employee";
				elseif($row->TabId==2)
					$tabname="Attendance";
				elseif($row->TabId==3)
					$tabname="Leave";
				elseif($row->TabId==4)
					$tabname="Salary";
				elseif($row->TabId==6)
					$tabname="Performance";	
				else
					$tabname="Timesheet";		
				$res['tabname'] = $tabname;
				$res['name'] = strtolower($tabname);
				$data1[] = $res;
			}
			$empcount=Utils::getTotalOnJobEmployee($orgid,$this->db);
        }
	else {
           $status =false;
		   $errorMsg=ROLE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result["tabs"] =$data1;
		$result["empcount"] =$empcount;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a SettingChild (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
     public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$settings = json_decode($_POST['settings_array'], true); 
		for($i=0; $i<count($settings); $i++)
		{
			
			if($settings[$i]['id']>0)
			{
				
				$sql = "UPDATE SettingChild SET SettingId=?, ExecutionType=?, ExecutionValue=?,NotifyAlert=?,SendMail=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($settings[$i]['setid'],$settings[$i]['exptype'], $settings[$i]['expvalue'],$settings[$i]['notifyalert'],$settings[$i]['sendmail'],$mdate, $mid, $settings[$i]['id'] ));			
				$count =  $query->rowCount();
				
				if ($count == 1) {
				   $status =true;
				   $successMsg = SETTINGS_MODULE_UPDATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg = SETTINGS_MODULE_UPDATION_FAILED;
				}
			}else{
				$sql = "INSERT INTO SettingChild ( SettingId, ExecutionType, ExecutionValue, NotifyAlert,SendMail, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				
				$query = $this->db->prepare($sql);
				$query->execute(array($settings[$i]['setid'],$settings[$i]['exptype'], $settings[$i]['expvalue'],$settings[$i]['notifyalert'],$settings[$i]['sendmail'], $orgid, $mdate, $mid, $mdate,  $mid, $mid ));
							
				$count =  $query->rowCount();
				
				if ($count == 1) {
				   $status =true;
				   $successMsg = SETTINGS_MODULE_UPDATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg = SETTINGS_MODULE_UPDATION_FAILED;
				}
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a SettingChild (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM SettingChild WHERE Code = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[4]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=SETTINGS_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO SettingChild (Name, Code, Description, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?, ?, ?, ?, ?,?, ?)";
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[4], $request[3], $orgid, $mdate, $mid, $mdate, $mid, $mid));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = SETTINGS_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = SETTINGS_MODULE_CREATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM SettingChild WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SETTINGS_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = SETTINGS_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM SettingMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getSettingChildval($id,$col)
	{
		$name ="";
		$orgid =$_SESSION['ubihrm_org_id'];
		$sql = "SELECT $col FROM SettingChild WHERE SettingId = :id and OrganizationId= :orgid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id,':orgid' => $orgid ));
			while($row = $query->fetch())
			{
				$name = $row->$col;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SettingChild';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Code', 'Description', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editbank/'.$aRow->{$aColumns[$i]}.'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" data-href="'.URL.'employee/deletebank/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="Name")
				{
					$row[] = '<a href="'.URL.'employee/viewbank/'.$aRow->Id.'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	  public function getEventDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SettingChild WHERE OrganizationId = :id and SettingId = :setid";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$setid = $request[2];	//SETTING ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ,':setid' => $setid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['setid'] = $row->SettingId;
				$res['title'] = $row->Title;
				$res['descemp'] = $row->DescEmp;
				$res['descother'] = $row->DescOther;
				//$res['notifyto'] = $row->Notifyto;
				$res['leaddays'] = $row->ExecutionValue;
				$res['alert'] = ($row->NotifyAlert==1)?true:false;
				$res['sendmail'] = ($row->SendMail==1)?true:false;
				$res['notifyall'] = ($row->notifyall==1)?true:false;
				$res['notifyself'] = ($row->notifyself==1)?true:false;
				$res['notifysupervisor'] = ($row->notifysupervisor==1)?true:false;
				$res['notifyhradmin'] = ($row->notifyhradmin==1)?true:false;
				$res['notifyteam'] = ($row->notifyteam==1)?true:false;
				$res['notifyjsteam'] = ($row->notifyjsteam==1)?true:false;
				$res['employeetype'] = $row->employeeType;
				$data[] = $res;
			}
        }else{
			$status=false;
			$successMsg = SETTINGS_MODULE_GETALL;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
   public function createupdatesettings($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$id = $_POST['id']; 
		$setid = $_POST['setid']; 
		$title = $_POST['title']; 
		$descemp = $_POST['descemp']; 
		$descother = $_POST['descother']; 
		$leaddays = $_POST['leaddays']; 
		$sendmail = ($_POST['sendmail']=='true')?1:0; 
		$genalert = ($_POST['genalert']=='true')?1:0; 
		$notifyall = ($_POST['notifyall']=='true')?1:0; 
		$notifyself = ($_POST['notifyself']=='true')?1:0; 
		$notifysupervisor = ($_POST['notifysupervisor']=='true')?1:0; 
		$notifyhradmin = ($_POST['notifyhradmin']=='true')?1:0; 
		$notifyteam= ($_POST['notifyteam']=='true')?1:0; 
		$notifyjsteam= ($_POST['notifyjsteam']=='true')?1:0; 
		$employeetype= $_POST['employeetype']; 
			if(!$id){
				//Utils::Trace("aa in");
				$sql1 = "SELECT * FROM SettingChild WHERE SettingId = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array($setid,$orgid));
					$count1 =  $query1->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count1 > 0){
					$row1 = $query1->fetch();
					$id = $row1->Id;
				}
			}
			if($id)
			{
				//Utils::Trace("bb in");
				$sql = "UPDATE SettingChild SET title=?, DescEmp=?, DescOther=?, ExecutionValue=?,NotifyAlert=?,SendMail=?,notifyall=?, notifyself=?, notifysupervisor=?, notifyhradmin=?, notifyteam=?, notifyjsteam=?, employeeType=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($title, $descemp, $descother, $leaddays, $genalert, $sendmail, $notifyall, $notifyself, $notifysupervisor, $notifyhradmin, $notifyteam,$notifyjsteam,$employeetype, $mdate, $mid, $id));			
				$count =  $query->rowCount();
				if ($count == 1) {
				   $status =true;
				   $successMsg = SETTINGS_MODULE_UPDATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg = SETTINGS_MODULE_UPDATION_FAILED;
				}
			}else{
				//Utils::Trace("cc in");
				$sql = "INSERT INTO SettingChild ( SettingId, ExecutionType, ExecutionValue, NotifyAlert,SendMail, notifyall, notifyself, notifysupervisor, notifyhradmin, notifyteam, notifyjsteam, employeeType, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, title, DescEmp, DescOther) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($setid,1, $leaddays,$genalert,$sendmail,$notifyall,$notifyself, $notifysupervisor,$notifyhradmin, $notifyteam,  $notifyjsteam,  $employeetype, $orgid, $mdate, $mid, $mdate, $mid, $mid, $title, $descemp, $descother));
				$count =  $query->rowCount();
				if ($count == 1) {
				   $status =true;
				   $successMsg = SETTINGS_MODULE_UPDATION_SUCCESS;
				} else {
				   $status =false;
				   $errorMsg = SETTINGS_MODULE_UPDATION_FAILED;
				}
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
    }

 public function enableSettings($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$id = $_POST['setid']; 
		$setting = ($_POST['setting']=="true")?1:0;
		
		//Utils::Trace($setting);
			$sql = "UPDATE SettingChild SET Settingsonoff=?, LastModifiedDate=?, LastModifiedById=? where SettingId=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($setting, $mdate, $mid, $id, $orgid));			
			$count =  $query->rowCount();
			if ($count == 1) {
			   $status =true;
			   $successMsg = SETTINGS_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = SETTINGS_MODULE_UPDATION_FAILED;
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
    }
	/* public function getNoticePeriod($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $arr[1];
		$type = $arr[2];
        $sql = "SELECT * FROM SettingChild WHERE OrganizationId = ? and SettingId in (SELECT Id FROM SettingMaster where PageType=?)";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid, $type ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['setid'] = $row->SettingId;
				$res['name'] = $this->getName($row->SettingId);
				$res['exptype'] = (int)$row->ExecutionType;
				$res['expvalue'] = (float)$row->ExecutionValue;
				$res['notifyalert'] = $row->NotifyAlert;
				$res['sendmail'] = $row->SendMail;
				
				$data[] = $res;
			}
        }else{
			$sql = "SELECT * FROM SettingMaster where PageType=?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $type ));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = 0;
				$res['setid'] = $row->Id;
				$res['name'] = $row->Name;
				$res['exptype'] = 0;
				$res['expvalue'] = 1;
				$res['notifyalert'] = 0;
				$res['sendmail'] = 0;

				$data[] = $res;
			}
		}
		
		if ($count > 0) {
           $status =true;
		   $successMsg = SETTINGS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SETTINGS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	 */
		public function getNoticePeriod($arr)
    {
		$result = array();
		$count=0;$count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $arr[1];
		$type = $arr[2];
      
			$sql = "SELECT * FROM SettingMaster where PageType=? and module_id=0";
			//$sql = "SELECT * FROM SettingMaster INNER JOIN SettingChild ON SettingChild.SettingId=SettingMaster.Id where SettingMaster.PageType=3 and SettingChild.OrganizationId = 5287";
			$query = $this->db->prepare($sql);
			$query->execute(array( $type ));
			$count =  $query->rowCount();
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = 0;
				$res['setid'] = $row->Id;
				$res['name'] = $row->Name;
				$sql1="SELECT * FROM SettingChild WHERE OrganizationId = ? and SettingId =?";
				$query1 = $this->db->prepare($sql1);
				try{
					$query1->execute(array( $orgid,$row->Id ));
					$count1 =  $query1->rowCount();
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				if($count1>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					while($row = $query1->fetch())
					{
						//$res = array();
						$res['id'] = $row->Id;
						$res['setid'] = $row->SettingId;
						$res['name'] = $this->getName($row->SettingId);
						$res['exptype'] = (int)$row->ExecutionType;
						$res['expvalue'] = (float)$row->ExecutionValue;
						$res['notifyalert'] = $row->NotifyAlert;
						$res['sendmail'] = $row->SendMail;
						
						//$data[] = $res;
						
					}
				}else{
				$res['exptype'] = 0;
				$res['expvalue'] = 1;
				$res['notifyalert'] = 0;
				$res['sendmail'] = 0;
				}
				$data[] = $res;
				
			}
	
		if ($count > 0) {
           $status =true;
		   $successMsg = SETTINGS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SETTINGS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 }
