<?php

/**
 * SalarytypeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalarytypeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryTypeMaster WHERE OrganizationId = :id order by Name";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$sql1="SELECT * from SalaryTypeChild where SalaryId=?";
				$query1=$this->db->prepare($sql1);
				$query1->execute(array($row->Id));
				$typearr=array();
				while($row1=$query1->fetch())
				{
					$res1=array();
					$res1['salaryheadid']=$row1->SalaryHeadId;
					$res1['salarypercent']=$row1->SalaryPercent;
					$typearr[]=$res1;
				}
				$res['salarytypedetails']=$typearr;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=SALARYTYPE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM SalaryTypeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$res['salaryapply']=Utils::dateformatter($row->SalaryApply);
				$res['desc']=$row->Description;
				$res['division']= (int)$row->DivisionId;
				$res['grade']= (int)$row->GradeId;
				$res['salaryamt']= (int)$row->SalaryAmount;
				$res['department']= (int)$row->DepartmentIds;
                $res['designation']= (int)$row->DesignationIds;
                $res['salaryrangemin']= $row->SalaryRangeMin;
                $res['salaryrangemax']= $row->SalaryRangeMax;
				$empid= explode(',', $row->EmployeeId);
				$empidarr=array();				
				foreach($empid as $value)
				{						
						$empidarr[]=$value;
				}
                $res['employeeid']= $empidarr;
				$res['employeeexperience']=$row->EmployeeExperience; 
				$res['exptype']=$row->exptype; 
               
				
				$res['heads'] = array();
				$sql1 = "SELECT * FROM SalaryTypeChild WHERE SalaryId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->Id ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['salaryheadid'] = $row1->SalaryHeadId;
					$res1['percent'] = $row1->SalaryPercent;
					$res1['percenttype'] = $row1->IsPercent;
					$res['heads'][] = $res1;
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYTYPE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYTYPE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a SalaryTypeMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$mdate = date("Y-m-d H:i:s");
		$salaryapply = Utils::getDateformat($request[4]);
		$sqlcode="SELECT * FROM SalaryTypeMaster WHERE  Name=? and DesignationIds=? and DivisionId=? and GradeId=? and OrganizationId=? and Id<>?";
		
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($request[3], $request[9], $request[6], $request[7], $orgid, Utils::decode5t($request[2]) ));
		$count1=$querycode->rowCount();
		if($count1>=1 ){
			$status =false;
		    $errorMsg ="Salary type criteria already exists.";
		}else{
			try{
				$employeeid=$request[16];
			$employeeids="";
			if(is_array($employeeid)){
				foreach($employeeid as $value){
					if($employeeids==""){
						$employeeids=$value;
					}else{
					$employeeids.=",".$value;					
					}
				}
			}
			$sql = "UPDATE SalaryTypeMaster SET Name=?, SalaryApply=?, Description=?, DivisionId=?, GradeId=?, DepartmentIds=?, DesignationIds=?, EmployeeExperience=?, LastModifiedDate=?, LastModifiedById=?,SalaryAmount=? ,exptype=?, SalaryRangeMin=?, SalaryRangeMax=?, EmployeeId=? where Id=?";		
			$query = $this->db->prepare($sql);			
			
				
				$query->execute(array($request[3], $salaryapply,$request[5],$request[6],$request[7],$request[8],$request[9], $request[10],  $mdate, $mid, $request[12],  $request[13],$request[14],$request[15],$employeeids,Utils::decode5t($request[2]) ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			///////////////////UPDATE CHILD TABLE OF SALARY TYPE MASTER ////////////
			$sql1 = "DELETE FROM SalaryTypeChild WHERE SalaryId = ?";		
			try{
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(Utils::decode5t($request[2])));
			
				//$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			foreach($request[11] as $value)
			{
				$sql = "INSERT INTO SalaryTypeChild (SalaryId, SalaryHeadId, SalaryPercent, IsPercent) values(?,?,?,?)";		
				$query = $this->db->prepare($sql);			
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					
					$query->execute(array(Utils::decode5t($request[2]), $value['salaryheadid'], $value['percent'], $value['percenttype'] ));			
					$count =  $query->rowCount();
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = SALARYTYPE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=SALARYTYPE_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a SalaryTypeMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$mdate = date("Y-m-d H:i:s");
		$salaryapply = Utils::getDateformat($request[3]);
		$sqlcode="SELECT * FROM SalaryTypeMaster WHERE Name=? and  DepartmentIds=? and DesignationIds=? and DivisionId=? and GradeId=? and OrganizationId=?";
		
		$querycode=$this->db->prepare($sqlcode);
		$querycode->execute(array($request[2],$request[7], $request[8], $request[5], $request[6],$orgid));
		
		$count1=$querycode->rowCount();
		if($count1>=1){
			$status =false;
		    $errorMsg = "Salary type criteria already exists.";
		}else{
			$employeeid=$request[15];
			$employeeids="";
			if(is_array($employeeid)){
				foreach($employeeid as $value){
					if($employeeids==""){
						$employeeids=$value;
					}else{
					$employeeids.=",".$value;					
					}
				}
			}
			$sqlmax = "select coalesce(Max(Id)+1,1) as maxid from SalaryTypeMaster";
			$querymax = $this->db->prepare($sqlmax);
			$querymax->execute();
			$maxrow = $querymax->fetch();
			$empid = $maxrow->maxid;
			
			$sql = "INSERT INTO SalaryTypeMaster (Id, Name, SalaryApply, Description, DivisionId, GradeId, DepartmentIds, DesignationIds ,  EmployeeExperience, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, SalaryAmount,exptype, SalaryRangeMin, SalaryRangeMax, EmployeeId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($empid, $request[2], $salaryapply,$request[4],$request[5],$request[6],$request[7],$request[8], $request[9], $orgid, $mdate, $mid, $mdate, $mid, $mid ,$request[11],$request[12], $request[13], $request[14], $employeeids));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		
			///////////////////INSERT CHILD TABLE RECORD OF SALARY TYPE MASTER ////////////
			foreach($request[10] as $value)
			{
				$sql = "INSERT INTO SalaryTypeChild (SalaryId, SalaryHeadId, SalaryPercent, IsPercent) values(?,?,?,?)";		
				$query = $this->db->prepare($sql);			
				try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					
					$query->execute(array($empid, $value['salaryheadid'], $value['percent'], $value['percenttype'] ));			
					$count =  $query->rowCount();
					
				}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = SALARYTYPE_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=SALARYTYPE_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific SALARYTYPE
     * @param  $did contains SALARYTYPE id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		
			$sql1 = "DELETE FROM SalaryTypeChild WHERE SalaryId = :id ";		
			try{
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $did));
			
				//$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			$sql = "DELETE FROM SalaryTypeMaster WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = SALARYTYPE_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=SALARYTYPE_MODULE_DELETE_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM SalaryTypeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryTypeMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalarytype/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="Name" )
				{
					$row[] = '<a href="'.URL.'salary/viewsalarytype/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($aRow->{$aColumns[$i]})):$aRow->{$aColumns[$i]};
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
