<?php

/**
 * SalaryHeadModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class SalaryheadModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryHead WHERE OrganizationId = ? and ApplyDate <= current_date";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ($row->HeadType==1)?"(+) ".$row->Name:"(-) ".$row->Name;
				$res['type'] = $row->HeadType;
				$res['code'] = $row->Code;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SALARYHEAD_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	/**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAllAdditionHead($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM SalaryHead WHERE OrganizationId = ? and ApplyDate <= current_date order by HeadType";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(  $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = ($row->HeadType==1)?"(+) ".$row->Name:"(-) ".$row->Name;
				$res['type'] = $row->HeadType;
				$res['code'] = $row->Code;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = SALARYHEAD_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM SalaryHead WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['salaryheadname'] = $row->Name;
				$res['headtype'] = $row->HeadType;
				$res['code'] = $row->Code;
				$res['main'] = $row->Main;
				$res['sub'] = $row->Sub;
				$res['description'] = $row->Description;
				$res['headcategoryid'] = $row->IncludeInPayslip;
				$res['applieddate'] = Utils::dateformatter($row->ApplyDate) ;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getOtherDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$id=Utils::decode5t($id);
        $sql = "SELECT * FROM SalaryOtherHead WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['salaryheadname'] = $row->Name;
				$res['salaryheadcode'] = $row->Code;
				$res['sub'] = $row->Sub;
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a SalaryHeadMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mdate = date("Y-m-d H:i:s");
		$sql = "UPDATE SalaryHead SET Name=?,HeadType=?,IncludeInPayslip=?,ApplyDate=?, OrganizationId=?, LastModifiedDate=?, LastModifiedById=?,Code=? ,Main=? ,Sub=? ,Description=? where Id=?";
		$query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array($request[2],$request[4],$request[3],Utils::getDateformat($request[5]), $orgid, $mdate, $mid, $request[7],$request[8],$request[9],$request[10],  Utils::decode5t($request[6])));			
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_UPDATION_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		  // default return
        return $result;
    }
	
	public function UpdateOtherHead($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$sql = "UPDATE SalaryOtherHead SET Name=?, Code=? , Sub=? , LastModifiedDate=? where Id=?";
		$query = $this->db->prepare($sql);
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($request[2],$request[3], $request[5], $mdate, $request[4]) );			
			$count =  $query->rowCount();
			
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_UPDATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a SalaryHeadMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "INSERT INTO SalaryHead (Name, HeadType, IncludeInPayslip, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId,Code,Main,Sub,Description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)";
		
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3],$request[4],Utils::getDateformat($request[5]),$orgid,$mdate,$mid,$mdate,$mid,$mid, $request[6], $request[7],$request[8], $request[9]));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_CREATION_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM SalaryHead WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = SALARYHEAD_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = SALARYHEAD_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	//function for getting name
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM SalaryHead WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	//function for getting HeadCategory
	public function getCategory($id)
	{
		$name ="";
		$sql = "SELECT Name FROM CategoryMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	 public function ChangeStatus($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		//$orgid = $request;
		$admin=0; $rid=0;
		try{
		$sql = "select ActiveSts from SalaryOtherHead WHERE Id = ?";
		$query = $this->db->prepare($sql);
		$query->execute(array($request[1] ));
		while($row = $query->fetch())
		{
			$admin=$row->ActiveSts;
		}
			
			$admin = ($admin==0) ? 1 : 0 ;
			$sql = "UPDATE SalaryOtherHead SET ActiveSts = ? WHERE  Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $admin,$request[1] ));
			$count = $query->rowCount();
			
			if($count>=1)
			{
				$status =true;
				$successMsg="Status has been changed successfully!";
			}	
			else {
			   $status =false;
			   $errorMsg=USER_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e)
		{
			
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'SalaryHead';
		$sIndexColumn = "Id";
		$aColumns = array('Code',  'Name','HeadType','IncludeInPayslip','ApplyDate', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$sWhere = " WHERE  OrganizationId= $orgid";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper ){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'salary/editsalaryhead/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper ){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
						if($aRow->Name=="Basic" ||$aRow->Name=="HRA" ||$aRow->Name=="PLP" ||$aRow->Name=="Cost of living Allowance"||$aRow->Name=="COLA"){
							$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
						}
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="IncludeInPayslip")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"<small class='label text-center bg-green'>Yes</small>":"<small class='label text-center bg-red'>No</small>";//$this->getCategory($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="HeadType")
				{
					if($aRow->{$aColumns[$i]} == 1)
					{	
						$row[] = $aRow->{$aColumns[$i]}="Addition";
					}
					elseif($aRow->{$aColumns[$i]} == 3)
					{	
						$row[] = $aRow->{$aColumns[$i]}="Deduction";
					}elseif($aRow->{$aColumns[$i]} == 2)
					{	
						$row[] = $aRow->{$aColumns[$i]}="Allowance";
					}elseif($aRow->{$aColumns[$i]} == 4)
					{	
						$row[] = $aRow->{$aColumns[$i]}="Fixed";
					}
				}
				elseif( $aColumns[$i]=="ApplyDate" || $aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Name" )
				{
					$row[] = '<a href="'.URL.'salary/viewsalaryhead/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	public function getSalaryOtherHeadDataTable()
	{
		$sTable = 'SalaryOtherHead';
		$sIndexColumn = "Id";
		$aColumns = array('Code', 'Name','Type', 'HeadSts', 'ActiveSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="where OrganizationId=$orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$row[] = "<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#edit' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."');angular.element(this).scope().onfetchotherhead('".$aRow->Id."')\" ><i class='fa fa-edit'></i></a>";//$this->getCategory($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ActiveSts")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><small class='label text-center bg-green'>ON</small></a>":"<a rel='tooltip' title='Change Status' data-toggle='modal' data-target='#confirm1' href='#' onclick=\"angular.element(this).scope().getId('".$aRow->Id."')\" ><small class='label text-center bg-red'>OFF</small></a>";//$this->getCategory($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Type")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"Addition":(($aRow->{$aColumns[$i]}==2)?"Fund":"Deduction");
				}
				elseif($aColumns[$i]=="HeadSts")
				{
					$row[] = ($aRow->{$aColumns[$i]}==1)?"Normal Salary Head":"Final Settlement Head";
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}

?>
